<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'pt', branch 'MOODLE_28_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'prestes a ser instalado';
$string['action'] = 'Ação';
$string['actionchoice'] = 'O que deseja fazer com o ficheiro \'{$a}\'?';
$string['actions'] = 'Ações';
$string['active'] = 'Ativo';
$string['activeusers'] = 'Utilizadores ativos';
$string['activities'] = 'Atividades';
$string['activities_help'] = 'Atividades, como fóruns, testes e wikis permitem que seja adicionado conteúdo interativo à disciplina.';
$string['activity'] = 'Atividade';
$string['activityclipboard'] = 'A mover a atividade: {$a}';
$string['activityiscurrentlyhidden'] = 'Esta atividade encontra-se oculta';
$string['activitymodule'] = 'Módulo de atividade';
$string['activitymodules'] = 'Atividades';
$string['activityreport'] = 'Relatório de atividade';
$string['activityreports'] = 'Relatórios de atividade';
$string['activityselect'] = 'Selecione esta atividade para ser movida para outro local';
$string['activitysince'] = 'Atividade desde {$a}';
$string['activityweighted'] = 'Atividade por utilizador';
$string['add'] = 'Adicionar';
$string['addactivity'] = 'Adicionar uma atividade';
$string['addactivitytosection'] = 'Adicionar uma atividade à secção \'{$a}\'';
$string['addadmin'] = 'Adicionar administrador';
$string['addblock'] = 'Adicionar bloco';
$string['addcomment'] = 'Adicionar comentário…';
$string['addcountertousername'] = 'Criar utilizador adicionando número ao nome de utilizador';
$string['addcreator'] = 'Adicionar criador da disciplina';
$string['adddots'] = 'Adicionar...';
$string['added'] = 'Adicionado {$a}';
$string['addedrecip'] = 'Adicionado {$a} novo destinatário';
$string['addedrecips'] = 'Adicionados {$a} novos destinatários';
$string['addedtogroup'] = 'Adicionado ao grupo {$a}';
$string['addedtogroupnot'] = 'Não adicionado ao grupo {$a}';
$string['addedtogroupnotenrolled'] = '{$a} não foi adicionado ao grupo, pois não está inscrito na disciplina';
$string['addfilehere'] = 'Adicionar ficheiro(s) aqui';
$string['addinganew'] = 'Adicionar "{$a}"';
$string['addinganewto'] = 'Adicionar "{$a->what}" em "{$a->to}"';
$string['addingdatatoexisting'] = 'Adicionar dados à existente';
$string['additionalnames'] = 'Nomes adicionais';
$string['addlinkhere'] = 'Adicionar uma hiperligação aqui';
$string['addnewcategory'] = 'Adicionar nova categoria';
$string['addnewcourse'] = 'Adicionar nova disciplina';
$string['addnewuser'] = 'Adicionar novo utilizador';
$string['addnousersrecip'] = 'Adicionar utilizadores que não tenham acedido este(a) {$a} à lista de destinatários';
$string['addpagehere'] = 'Adicionar texto aqui';
$string['addresource'] = 'Adicionar um recurso';
$string['addresourceoractivity'] = 'Adicionar uma atividade ou recurso';
$string['addresourcetosection'] = 'Adicionar um recurso à secção \'{$a}\'';
$string['address'] = 'Morada';
$string['addstudent'] = 'Adicionar aluno';
$string['addsubcategory'] = 'Adicionar uma subcategoria';
$string['addteacher'] = 'Adicionar professor';
$string['admin'] = 'Administrador';
$string['adminhelpaddnewuser'] = 'Para criar manualmente uma nova conta de utilizador';
$string['adminhelpassignadmins'] = 'Os administradores poderão fazer qualquer coisa e entrar em qualquer parte do site';
$string['adminhelpassigncreators'] = 'Os criadores podem criar novas disciplinas e leccionar nelas';
$string['adminhelpassignsiteroles'] = 'Aplicar papéis atribuídos a utilizadores específicos';
$string['adminhelpassignstudents'] = 'Entre numa disciplina e inscreva alunos a partir do menu de administração';
$string['adminhelpauthentication'] = 'Pode usar contas internas ou de base de dados externas';
$string['adminhelpbackup'] = 'Configure programação de cópias de segurança automáticas';
$string['adminhelpconfiguration'] = 'Configure a aparência e funcionalidades do site';
$string['adminhelpconfigvariables'] = 'Modifique as variáveis de configuração global do site';
$string['adminhelpcourses'] = 'Defina as disciplinas e categorias e atribua-lhes pessoas; edite disciplinas pendentes';
$string['adminhelpeditorsettings'] = 'Definir configurações básicas do editor HTML';
$string['adminhelpedituser'] = 'Visualize e/ou edite a lista de contas de utilizadores';
$string['adminhelpenvironment'] = 'Verifique se o servidor cumpre os requisitos para a versão atual do Moodle e posteriores.';
$string['adminhelpfailurelogs'] = 'Ver registo de tentativas de autenticação sem sucesso.';
$string['adminhelplanguage'] = 'Verificar e editar o pacote linguístico atualmente em uso';
$string['adminhelplogs'] = 'Ver todos os registos de atividade do site';
$string['adminhelpmanageblocks'] = 'Gerir blocos instalados e as suas configurações';
$string['adminhelpmanagedatabase'] = 'Aceda diretamente à base de dados (tenha cuidado!)';
$string['adminhelpmanagefilters'] = 'Escolha filtros de texto e configurações relacionadas';
$string['adminhelpmanagemodules'] = 'Configure os módulos instalados e as suas opções';
$string['adminhelpmanageroles'] = 'Criar ou definir papéis que poderão ser atribuídos aos utilizadores';
$string['adminhelpmymoodle'] = 'Configurar o bloco Minha página principal para utilizadores';
$string['adminhelpreports'] = 'Relatórios a nível do site';
$string['adminhelpsitefiles'] = 'Para publicar ficheiros ou fazer o envio de cópias de segurança externas';
$string['adminhelpsitesettings'] = 'Defina a aparência da página principal do site';
$string['adminhelpstickyblocks'] = 'Configurar blocos persistentes do Moodle';
$string['adminhelpthemes'] = 'Escolha a aparência do site (cores, tipos de letra, etc)';
$string['adminhelpuploadusers'] = 'Importar ficheiro de texto com novas contas de utilizadores';
$string['adminhelpusers'] = 'Defina os utilizadores e configure o método de autenticação';
$string['adminhelpxmldbeditor'] = 'Interface para editar os ficheiros XMLDB. Apenas para programadores.';
$string['administration'] = 'Administração';
$string['administrationsite'] = 'Administração do Site';
$string['administrator'] = 'Administrador';
$string['administratordescription'] = 'Habitualmente, os administradores podem fazer qualquer coisa no site, em todas as disciplinas.';
$string['administrators'] = 'Administradores';
$string['administratorsall'] = 'Todos os administradores';
$string['administratorsandteachers'] = 'Administradores e professores';
$string['advanced'] = 'Avançado';
$string['advancedfilter'] = 'Filtro avançado';
$string['advancedsettings'] = 'Configurações avançadas';
$string['afterresource'] = 'A seguir ao recurso "{$a}"';
$string['aftersection'] = 'A seguir à secção "{$a}"';
$string['again'] = 'novamente';
$string['aimid'] = 'ID do AIM';
$string['ajaxuse'] = 'AJAX e Javascript';
$string['all'] = 'Todos';
$string['allactions'] = 'Todas as ações';
$string['allactivities'] = 'Todas as atividades';
$string['allcategories'] = 'Todas as categorias';
$string['allchanges'] = 'Todas as alterações';
$string['alldays'] = 'Todos os dias';
$string['allfieldsrequired'] = 'Todos os campos são obrigatórios';
$string['allfiles'] = 'Todos os ficheiros';
$string['allgroups'] = 'Todos os grupos';
$string['alllogs'] = 'Toda a atividade';
$string['allmods'] = 'Todos os {$a}';
$string['allow'] = 'Permitir';
$string['allowinternal'] = 'Permitir também métodos internos';
$string['allownone'] = 'Não permitir nenhum';
$string['allownot'] = 'Não permitir';
$string['allparticipants'] = 'Todos os participantes';
$string['allteachers'] = 'Todos os professores';
$string['alphanumerical'] = 'Só pode conter caracteres alfabéticos ou numéricos';
$string['alreadyconfirmed'] = 'A inscrição já foi confirmada';
$string['alternatename'] = 'Nome alternativo';
$string['always'] = 'Sempre';
$string['and'] = '{$a->one} e {$a->two}';
$string['answer'] = 'Resposta';
$string['any'] = 'Qualquer';
$string['appearance'] = 'Aparência';
$string['approve'] = 'Aprovar';
$string['areyousure'] = 'Tem a certeza?';
$string['areyousuretorestorethis'] = 'Tem a certeza que o quer restaurar?';
$string['areyousuretorestorethisinfo'] = 'Mais para a frente neste processo poderá optar por incluir esta cópia de segurança numa outra disciplina já existente, ou numa nova disciplina.';
$string['asc'] = 'Ascendente';
$string['assessment'] = 'Avaliação';
$string['assignadmins'] = 'Designar administradores';
$string['assigncreators'] = 'Designar criadores';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Atribuir papéis para todo o site';
$string['authenticateduser'] = 'Utilizador autenticado';
$string['authenticateduserdescription'] = 'Todos os utilizadores autenticados';
$string['authentication'] = 'Autenticação';
$string['authenticationplugins'] = 'Módulos de Autenticação';
$string['autosubscribe'] = 'Subscrição de fóruns';
$string['autosubscribeno'] = 'Não: Não quero subscrever tópicos dos fóruns automaticamente';
$string['autosubscribeyes'] = 'Sim: Quero subscrever o tópico do fórum quando submeto uma mensagem';
$string['availability'] = 'Disponibilidade';
$string['availablecourses'] = 'Disciplinas disponíveis';
$string['back'] = 'Voltar';
$string['backto'] = 'Voltar a {$a}';
$string['backtocourselisting'] = 'Voltar à lista de disciplinas';
$string['backtopageyouwereon'] = 'Voltar à página anterior';
$string['backtoparticipants'] = 'Voltar à lista de participantes';
$string['backup'] = 'Cópia de segurança';
$string['backupactivehelp'] = 'Decida se deverão ser feitas ou não cópias de segurança automáticas.';
$string['backupcancelled'] = 'Cópia de segurança interrompida';
$string['backupcoursefileshelp'] = 'Se estiver selecionado, os ficheiros de uma disciplina serão incluídos nas cópias de segurança automáticas.';
$string['backupdate'] = 'Data da cópia de segurança';
$string['backupdatenew'] = '{$a->TAG} é agora {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} era {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalhes da cópia de segurança';
$string['backupexecuteathelp'] = 'Escolha a hora em que inicia a execução das cópias de segurança automáticas.';
$string['backupfailed'] = 'Algumas das suas disciplinas não foram gravadas!!';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Cópia de segurança concluída com sucesso';
$string['backupfromthissite'] = 'Cópia de segurança é feita na disciplina?';
$string['backupgradebookhistoryhelp'] = 'Se ativar esta opção, o historial da pauta será incluído nos backups automáticos. Note que para o historial da pauta ser guardado, não deve estar inativo nas configurações do Servidor (disablegradehistory)';
$string['backupincludemoduleshelp'] = 'Escolha se quer incluir módulos de uma disciplina, com ou sem dados de utilizadores, nas cópias de segurança automáticas.';
$string['backupincludemoduleuserdatahelp'] = 'Escolha se quer ou não incluir dados de utilizador dos módulos nas cópias de segurança automáticas.';
$string['backupkeephelp'] = 'Quantas cópias de segurança recentes quer manter para cada disciplina? Nota: As mais antigas serão apagadas automaticamente.';
$string['backuplogdetailed'] = 'Estatísticas detalhadas de execução';
$string['backuploglaststatus'] = 'Relatório sobre cópias de segurança automáticas das disciplinas';
$string['backupmissinguserinfoperms'] = 'Nota: Esta cópia de segurança não contém dados dos utilizadores. As atividades Exercise e Workshop não serão incluídas pois não são compatíveis com este tipo de cópia de segurança.';
$string['backupnext'] = 'Próxima cópia de segurança';
$string['backupnonisowarning'] = 'Advertência: esta cópia de segurança é para uma versão de Moodle que não usa Unicode (anterior a 1.6). Se esta cópia conter carateres que não sejam ISO-8859-1, poderão ficar ERRADOS se tentar passá-los para esta versão Unicode de Moodle. Consulte o <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> para mais informações sobre como recuperar corretamente esta cópia de segurança.';
$string['backupnotyetrun'] = 'Cópia de Segurança Automática pendente';
$string['backuporiginalname'] = 'Nome da cópia de segurança';
$string['backuproleassignments'] = 'Incluir atribuições para estes papéis na cópia de segurança';
$string['backupsavetohelp'] = 'Nome e caminho completo da pasta onde quer guardar os ficheiros de cópia de segurança<br />(deixe em branco se quiser que fiquem na própria pasta da disciplina).';
$string['backupsitefileshelp'] = 'Se for ativado, os ficheiros do site usados em disciplinas serão incluídos nas cópias de segurança automáticas';
$string['backuptakealook'] = 'Por favor leia os relatórios dos processos de criação de cópias de segurança em: {$a}';
$string['backupuserfileshelp'] = 'Escolha se os ficheiros de alunos (por exemplo fotografias) deverão ser incluídos nas cópias de segurança automáticas.';
$string['backupversion'] = 'Versão da cópia de segurança';
$string['badges'] = 'Medalhas';
$string['block'] = 'Bloco';
$string['blockconfiga'] = 'Configuração do bloco "{$a}"';
$string['blockconfigbad'] = 'Este bloco não tem uma interface de configuração, por não ter sido implementado corretamente.';
$string['blocks'] = 'Blocos';
$string['blocksaddedit'] = 'Adicionar/Editar blocos';
$string['blockseditoff'] = 'Desativar edição de blocos';
$string['blocksediton'] = 'Ativar edição de blocos';
$string['blocksetup'] = 'A configurar tabelas de blocos';
$string['blocksuccess'] = 'As tabelas de {$a} foram configuradas corretamente';
$string['brief'] = 'Menos detalhes';
$string['bulkactions'] = 'Operações em massa';
$string['bulkactionselect'] = '{$a} seleção de operação em massa';
$string['bulkmovecoursessuccess'] = 'Foram movidas com sucesso {$a->courses} disciplinas para {$a->category}';
$string['bycourseorder'] = 'Por ordem de disciplina';
$string['byname'] = 'por {$a}';
$string['bypassed'] = 'Ultrapassada';
$string['cachecontrols'] = 'Controlo da Cache';
$string['cancel'] = 'Cancelar';
$string['cancelled'] = 'Cancelado';
$string['categories'] = 'Categorias de disciplinas';
$string['categoriesandcoures'] = 'Categorias de disciplinas e disciplinas';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'A categoria \'{$a}\'  foi adicionada';
$string['categorybulkaction'] = 'Operações em massa para as categorias selecionadas';
$string['categorycontents'] = 'Subcategorias e disciplinas';
$string['categorycurrentcontents'] = 'Conteúdo de {$a}';
$string['categorydeleted'] = 'A categoria \'{$a}\' foi apagada';
$string['categoryduplicate'] = 'Já existe uma categoria com o nome \'{$a}\'!';
$string['categorymodifiedcancel'] = 'A Categoria foi modificada! Cancele e tente de novo.';
$string['categoryname'] = 'Nome da categoria';
$string['categorysubcategoryof'] = '{$a->category} - subcategoria de {$a->parentcategory}';
$string['categoryupdated'] = 'A categoria \'{$a}\' foi atualizada';
$string['changedpassword'] = 'Senha modificada';
$string['changepassword'] = 'Modificar senha';
$string['changesmadereallygoaway'] = 'Fez alterações. Tem a certeza de que deseja sair e perder as alterações efetuadas?';
$string['changessaved'] = 'Alterações gravadas';
$string['check'] = 'Verificar';
$string['checkall'] = 'Verificar todo';
$string['checkingbackup'] = 'Verificando a cópia de segurança';
$string['checkingcourse'] = 'Verificando a disciplina';
$string['checkingforbbexport'] = 'Verificando exportação para BlackBoard';
$string['checkinginstances'] = 'Verificando instâncias';
$string['checkingsections'] = 'Verificando secções';
$string['checklanguage'] = 'Verificar o idioma';
$string['checknone'] = 'Não verificar nada';
$string['childcoursenotfound'] = 'Disciplina de proveniência não encontrada';
$string['childcourses'] = 'Disciplinas de proveniência';
$string['choose'] = 'Selecionar';
$string['choosecourse'] = 'Escolha uma disciplina';
$string['choosedots'] = 'Escolha…';
$string['chooselivelogs'] = 'Ou examine estatísticas de acesso atual';
$string['chooselogs'] = 'Escolha que registos de atividade deseja ver';
$string['choosereportfilter'] = 'Escolha um filtro para o relatório';
$string['choosetheme'] = 'Escolha um tema';
$string['chooseuser'] = 'Escolha um utilizador';
$string['city'] = 'Cidade/Estado';
$string['clambroken'] = 'O administrador do seu sistema ativou a opção de deteção de vírus para os ficheiros enviados, mas algo ficou mal configurado.<br />O seu ficheiro NÃO foi recebido com sucesso. Foi enviado um e-mail ao administrador, pedindo-lhe para corrigir o problema.<br />Pode tentar enviar o ficheiro mais tarde.';
$string['clamdeletedfile'] = 'O ficheiro foi apagado';
$string['clamdeletedfilefailed'] = 'Não foi possível apagar o ficheiro';
$string['clamemailsubject'] = '{$a}:: Notificação do antivírus Clam';
$string['clamfailed'] = 'Não foi possível arrancar o antivírus Clam. A mensagem de erro foi {$a}. Segue-se a listagem de saída produzida pelo Clam:';
$string['clamlost'] = 'Moodle foi configurado para executar clam quando for enviado um ficheiro, mas a localização indicada para o antivírus Clam, {$a}, não é válida.';
$string['clamlostandactinglikevirus'] = 'Para além disso, moodle foi configurado de forma que se o clam falhar, os ficheiros recebidos serão considerados como vírus. Resumindo, isso quer dizer que enquanto não corrigir o problema, nenhum aluno conseguirá enviar qualquer ficheiro para o servidor.';
$string['clammovedfile'] = 'O ficheiro foi transferido para a pasta designado de zona de quarentena; a nova localização do ficheiro é {$a}';
$string['clammovedfilebasic'] = 'Este ficheiro foi transferido para a pasta de quarentena.';
$string['clamquarantinedirfailed'] = 'Não foi possível transferir o ficheiro para a pasta designado de zona de quarentena, {$a}. Tem que corrigir isso, já que os ficheiros que parecerem estar infetados por um vírus estão a ser apagados.';
$string['clamunknownerror'] = 'Ocorreu um erro desconhecido com o clam.';
$string['cleaningtempdata'] = 'A apagar dados temporários';
$string['clear'] = 'Apagar';
$string['clickhelpiconformoreinfo'] = '... continua ... Clique no ícone de ajuda para ler o artigo completo';
$string['clickhere'] = 'Clique aqui';
$string['clicktochangeinbrackets'] = '{$a} (Clique para alterar)';
$string['clicktohideshow'] = 'Clique para expandir ou contrair';
$string['closebuttontitle'] = 'Fechar';
$string['closewindow'] = 'Fechar esta janela';
$string['collapse'] = 'Contrair';
$string['collapseall'] = 'Contrair tudo';
$string['collapsecategory'] = 'Contrair {$a}';
$string['commentincontext'] = 'Encontrar este comentário no contexto';
$string['comments'] = 'Comentários';
$string['commentscount'] = 'Comentários ({$a})';
$string['commentsnotenabled'] = 'Os comentários não estão ativos';
$string['commentsrequirelogin'] = 'Necessita de estar autenticado para ver os comentários';
$string['comparelanguage'] = 'Comparar e editar o pacote linguístico em uso';
$string['complete'] = 'Completo';
$string['completereport'] = 'Relatório completo';
$string['configuration'] = 'Configuração';
$string['confirm'] = 'Confirmar contas';
$string['confirmcheckfull'] = 'Tem certeza absoluta que quer confirmar {$a}?';
$string['confirmcoursemove'] = 'Tem a certeza de que pretende mover esta disciplina ({$a->course}) para esta categoria ({$a->category})?';
$string['confirmed'] = 'O seu registo foi confirmado com sucesso';
$string['confirmednot'] = 'O seu registo ainda não foi confirmado!';
$string['content'] = 'Conteúdo';
$string['continue'] = 'Continuar';
$string['continuetocourse'] = 'Carregue aqui para entrar na sua disciplina';
$string['convertingwikitomarkdown'] = 'A converter Wiki para Markdown';
$string['cookiesenabled'] = 'Tem que ativar o suporte para Cookies no seu navegador';
$string['cookiesenabled_help'] = 'Dois cookies são utilizados por este site:

O essencial é a sessão de cookie, normalmente chamado de MoodleSession. Deve permitir este cookie no seu navegador para dar continuidade e manter a sua autenticação de página para página. Quando sair ou fechar o navegador essa cookie é eliminada (no seu navegador e no servidor).

O outro cookie é puramente por conveniência, chamada geralmente de algo como MOODLEID. Ele apenas só se lembra do seu nome de utilizador no navegador. Isto significa que quando voltar a este site o nome na página de autenticação já estará preenchido. É seguro aceitar este cookie - apenas terá que escrever o seu nome de utilizador cada vez que acede à plataforma.';
$string['cookiesnotenabled'] = 'Infelizmente o seu navegador tem as cookies desativadas';
$string['copy'] = 'Duplicar';
$string['copyasnoun'] = 'Cópia';
$string['copyingcoursefiles'] = 'A copiar os ficheiros da disciplina';
$string['copyingsitefiles'] = 'A copiar ficheiros do site usados na disciplina';
$string['copyinguserfiles'] = 'A copiar os ficheiros de utilizador';
$string['copyingzipfile'] = 'A copiar os ficheiros .zip';
$string['copyrightnotice'] = 'Nota de direitos de autor';
$string['coresystem'] = 'sistema';
$string['cost'] = 'Custo';
$string['costdefault'] = 'Custo predefinido';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'País';
$string['course'] = 'Disciplina';
$string['courseadministration'] = 'Administração da disciplina';
$string['courseapprovedemail'] = 'A disciplina que pediu, {$a->name}, foi aprovada e já foi registado como professor dessa disciplina. Para aceder à sua nova disciplina, clique em {$a->url}';
$string['courseapprovedemail2'] = 'A disciplina que pediu, {$a->name}, foi aprovada. Para aceder à sua nova disciplina, clique em {$a->url}';
$string['courseapprovedfailed'] = 'Não foi possível gravar a disciplina como aprovada!';
$string['courseapprovedsubject'] = 'A sua disciplina foi aprovada';
$string['courseavailable'] = 'Esta disciplina está disponível para alunos';
$string['courseavailablenot'] = 'Esta disciplina não está disponível para alunos';
$string['coursebackup'] = 'Cópia de segurança da disciplina';
$string['coursebulkaction'] = 'Aplicar operação em massa para as disciplinas selecionadas';
$string['coursecategories'] = 'Categorias da disciplina';
$string['coursecategory'] = 'Categoria da disciplina';
$string['coursecategorydeleted'] = 'A categoria  {$a} foi apagada';
$string['coursecategory_help'] = 'Esta configuração determina a categoria em que a disciplina vai aparecer na lista de disciplinas.';
$string['coursecatmanagement'] = 'Gestão de disciplinas e categorias';
$string['coursecompletion'] = 'Conclusão da disciplina';
$string['coursecompletions'] = 'Conclusões da disciplina';
$string['coursecreators'] = 'Criador de disciplinas';
$string['coursecreatorsdescription'] = 'Os criadores de disciplinas podem criar novas disciplinas e leccionar nelas.';
$string['coursedeleted'] = 'A disciplina {$a} foi apagada';
$string['coursedisplay'] = 'Visualização';
$string['coursedisplay_help'] = 'Esta opção determina se toda a disciplina é exibida numa página única ou se é dividida em várias páginas.';
$string['coursedisplay_multi'] = 'Mostrar uma secção por página';
$string['coursedisplay_single'] = 'Mostrar todas as secções na mesma página';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Ficheiros da disciplina (retrocompatibilidade com versões anteriores do Moodle)';
$string['coursefilesedit'] = 'Editar Ficheiros da disciplina (retrocompatibilidade com versões anteriores do Moodle)';
$string['coursefileswarning'] = 'Os ficheiros da disciplina estão desatualizados';
$string['coursefileswarning_help'] = 'Os ficheiros da disciplina estão desatualizados desde o Moodle 2.0, use repositórios externos sempre que possível.';
$string['courseformatdata'] = 'Dados do formato da disciplina';
$string['courseformatoptions'] = 'Opção de formato para {$a}';
$string['courseformats'] = 'Formatos da disciplina';
$string['courseformatudpate'] = 'Atualizar formato';
$string['coursegrades'] = 'Notas da disciplina';
$string['coursehelpcategory'] = 'Insira a disciplina na lista de disciplinas, para tornar mais fácil os alunos encontrarem-na.';
$string['coursehelpforce'] = 'Forçar o modo de grupo para todas as atividades na disciplina.';
$string['coursehelpformat'] = 'A página principal da disciplina será mostrada neste formato.';
$string['coursehelphiddensections'] = 'Forma como as secções ocultas da disciplina são apresentadas aos alunos.';
$string['coursehelpmaximumupload'] = 'Tamanho máximo do ficheiro que é possível carregar na disciplina, limitado pelo tamanho máximo definido para todo o site';
$string['coursehelpnewsitemsnumber'] = 'Número de itens recentes do Fórum Notícias que aparecem no bloco Últimas notícias na página da disciplina. Se for definido o valor zero (0), o bloco Últimas notícias não será exibido.';
$string['coursehelpnumberweeks'] = 'Número de secções da disciplina (só se aplica a certos formatos de disciplina).';
$string['coursehelpshowgrades'] = 'Permitir que a pauta esteja disponível para os alunos. Não impede que as notas sejam apresentadas em cada atividade.';
$string['coursehidden'] = 'Esta disciplina está atualmente indisponível para alunos';
$string['courseinfo'] = 'Informações sobre a disciplina';
$string['courselegacyfiles'] = 'Ficheiros da disciplina (retrocompatibilidade com versões anteriores do Moodle)';
$string['courselegacyfiles_help'] = 'A área Ficheiros da disciplina fornece alguma retrocompatibilidade com a versão 1.9 do Moodle e anteriores. Note que todos os ficheiros nesta área estão sempre acessíveis a todos os participantes da disciplina (quer estabeleça, ou não, uma hiperligação para eles) e não existe forma de saber se, nem onde, estes ficheiros estão a ser usados no Moodle.

Se usar esta área para guardar ficheiros da disciplina, pode estar a correr riscos de violação de privacidade e segurança, assim como sujeito a falta de ficheiros nas cópias de segurança, importação de disciplinas e na partilha de conteúdos. Assim, não é aconselhável a utilização desta área a não ser que tenha de facto a certeza do que está a fazer.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Ficheiros de retrocompatibilidade da disciplina: {$a}';
$string['coursemessage'] = 'Mensagem para utilizadores da disciplina';
$string['coursenotaccessible'] = 'Esta disciplina não permite acesso público';
$string['courseoverview'] = 'Sumário da disciplina';
$string['courseoverviewfiles'] = 'Ficheiros de resumo da disciplina';
$string['courseoverviewfilesext'] = 'Extensões de ficheiros de resumo da disciplina';
$string['courseoverviewfiles_help'] = 'Ficheiros de resumo da disciplina, tais como imagens, são exibidos na lista da disciplinas juntamente com o resumo.';
$string['courseoverviewfileslimit'] = 'Limite dos ficheiros de resumo da disciplina';
$string['courseoverviewgraph'] = 'Gráfico sumário da disciplina';
$string['courseprofiles'] = 'Perfis da disciplina';
$string['coursereasonforrejecting'] = 'Razão para rejeitar este pedido';
$string['coursereasonforrejectingemail'] = 'Mensagem que será enviada a quem fez o pedido';
$string['coursereject'] = 'Rejeitar pedido de disciplina';
$string['courserejected'] = 'A disciplina foi rejeitada e o autor do pedido notificado.';
$string['courserejectemail'] = 'Lamentamos, mas a disciplina que pediu foi rejeitada. A causa é a seguinte:

{$a}';
$string['courserejectreason'] = 'Justifique a sua decisão de rejeitar a disciplina<br />(a sua justificação será enviada por correio para o autor do pedido)';
$string['courserejectsubject'] = 'A sua disciplina não foi aprovada';
$string['coursereport'] = 'Relatório da disciplina';
$string['coursereports'] = 'Relatórios da disciplina';
$string['courserequest'] = 'Pedido de disciplina';
$string['courserequestdetails'] = 'Detalhes da disciplina que está a pedir';
$string['courserequestfailed'] = 'Por alguma razão a disciplina que pediu não pode ser gravada';
$string['courserequestintro'] = 'Use este formulário para fazer um pedido de criação de disciplina.<br />Tente preencher o formulário quanto possível<br />para que os administradores possam compreender a sua razão para o pedido.';
$string['courserequestreason'] = 'Justificação do pedido de criação da disciplina';
$string['courserequestsuccess'] = 'O seu pedido de criação de disciplina foi registado com sucesso. Em breve irá receber um email a informá-lo do resultado do seu pedido.';
$string['courserequestsupport'] = 'Informação de suporte para auxiliar o administrador a avaliar este pedido';
$string['courserestore'] = 'Reposição da disciplina';
$string['courses'] = 'Disciplinas';
$string['coursesectionsummaries'] = 'Secção de sumários da disciplina';
$string['coursesectiontitle'] = 'Disciplina: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'Configuração predefinida das disciplinas';
$string['coursesmovedout'] = 'Disciplinas movidas de {$a}';
$string['coursespending'] = 'Disciplinas à espera de aprovação';
$string['coursestart'] = 'Início';
$string['coursesummary'] = 'Resumo';
$string['coursesummary_help'] = 'O resumo da disciplina é apresentado na lista de disciplinas. A pesquisa de disciplinas pesquisa igualmente nesta informação, para além do nome das disciplinas.';
$string['coursetitle'] = 'Disciplina: {$a->course}';
$string['courseupdates'] = 'Atualizações à disciplina';
$string['create'] = 'Criar';
$string['createaccount'] = 'Criar a minha conta';
$string['createcategory'] = 'Criar categoria';
$string['createfolder'] = 'Criar uma pasta em {$a}';
$string['createnew'] = 'Criar novo';
$string['createnewcategory'] = 'Criar nova categoria';
$string['createnewcourse'] = 'Criar nova disciplina';
$string['createnewsubcategory'] = 'Criar nova subcategoria';
$string['createsubcategoryof'] = 'Criar subcategoria de {$a}';
$string['createuser'] = 'Criar utilizador';
$string['createuserandpass'] = 'Escolha um nome de utilizador e senha';
$string['createziparchive'] = 'Criar um ficheiro zip';
$string['creatingblocks'] = 'A criar blocos';
$string['creatingblocksroles'] = 'A criar atribuições e revogações de papéis ao nível de blocos.';
$string['creatingblogsinfo'] = 'A criar informação dos blogues';
$string['creatingcategoriesandquestions'] = 'A criar categorias e perguntas';
$string['creatingcoursemodules'] = 'A criar módulos da disciplina';
$string['creatingcourseroles'] = 'A criar atribuições e revogações de papéis ao nível de disciplinas.';
$string['creatingevents'] = 'A criar eventos';
$string['creatinggradebook'] = 'A criar pauta';
$string['creatinggroupings'] = 'A criar agrupamentos';
$string['creatinggroupingsgroups'] = 'A adicionar grupos ao agrupamento';
$string['creatinggroups'] = 'A criar grupos';
$string['creatinglogentries'] = 'A criar registo de entradas';
$string['creatingmessagesinfo'] = 'A criar informação sobre mensagens';
$string['creatingmodroles'] = 'A criar atribuições e revogações de papéis ao nível de módulos.';
$string['creatingnewcourse'] = 'A criar nova disciplina';
$string['creatingrolesdefinitions'] = 'A definir os papéis a atribuir';
$string['creatingscales'] = 'A criar escalas';
$string['creatingsections'] = 'A criar secções';
$string['creatingtemporarystructures'] = 'A criar estruturas temporárias';
$string['creatinguserroles'] = 'A criar atribuições e revogações de papéis ao nível de utilizadores.';
$string['creatingusers'] = 'A criar utilizadores';
$string['creatingxmlfile'] = 'A criar ficheiro XML';
$string['currency'] = 'Moeda';
$string['currentcourse'] = 'Disciplina atual';
$string['currentcourseadding'] = 'A inserir dados para a disciplina selecionada';
$string['currentcoursedeleting'] = 'A apagar a disciplina atual';
$string['currentlanguage'] = 'Idioma usado atualmente';
$string['currentlocaltime'] = 'a sua hora local';
$string['currentlyselectedusers'] = 'Utilizadores selecionados atualmente';
$string['currentpicture'] = 'Fotografia atual';
$string['currentrelease'] = 'Informação da versão atual';
$string['currentversion'] = 'Versão atual';
$string['databasechecking'] = 'A atualizar a base de dados do Moodle da versão {$a->oldversion} para {$a->newversion}...';
$string['databaseperformance'] = 'Desempenho da base de dados';
$string['databasesetup'] = 'A configurar a base de dados';
$string['databasesuccess'] = 'Base de dados atualizada com sucesso';
$string['databaseupgradebackups'] = 'A versão da cópia de segurança é {$a}';
$string['databaseupgradeblocks'] = 'A versão dos blocos é agora {$a}';
$string['databaseupgradegroups'] = 'A versão dos grupos é agora {$a}';
$string['databaseupgradelocal'] = 'A versão de personalização da base de dados local é agora {$a}';
$string['databaseupgrades'] = 'A atualizar a base de dados';
$string['date'] = 'Data';
$string['datechanged'] = 'Data de alteração';
$string['datemostrecentfirst'] = 'Data - mais recente(s) primeiro';
$string['datemostrecentlast'] = 'Data - mais recente(s) no fim';
$string['day'] = 'dia';
$string['days'] = 'dias';
$string['decodinginternallinks'] = 'A descodificar apontadores internos';
$string['default'] = 'Predefinido';
$string['defaultcoursestudent'] = 'Aluno';
$string['defaultcoursestudentdescription'] = 'Os alunos geralmente têm menos privilégios dentro de uma disciplina.';
$string['defaultcoursestudents'] = 'Alunos';
$string['defaultcoursesummary'] = 'Escreva aqui um parágrafo que explique de forma concisa e interessante o que esta disciplina é.';
$string['defaultcourseteacher'] = 'Professor';
$string['defaultcourseteacherdescription'] = 'Os professores podem fazer qualquer coisa dentro de uma disciplina, incluindo alteração das atividades e avaliação dos alunos.';
$string['defaultcourseteachers'] = 'Professores';
$string['defaulteditor'] = 'Editor predefinido';
$string['delete'] = 'Apagar';
$string['deleteablock'] = 'Apagar bloco';
$string['deleteall'] = 'Apague todos(as)';
$string['deleteallcannotundo'] = 'Apagar todos - não pode ser recuperado';
$string['deleteallcomments'] = 'Apagar todos os comentários';
$string['deleteallratings'] = 'Apagar todas as classificações';
$string['deletecategory'] = 'Apagar categoria: {$a}';
$string['deletecategorycheck'] = 'Tem a certeza absoluta que quer apagar completamente esta categoria  <b>\'{$a}\'</b>?<br />As disciplinas nesta categoria serão deslocadas para a categoria superior, se existir, ou para a categoria Geral.';
$string['deletecategorycheck2'] = 'Se apagar esta categoria, deve decidir o que fazer às disciplinas e subcategorias nela contidas.';
$string['deletecategoryempty'] = 'Esta categoria está vazia.';
$string['deletecheck'] = 'Apagar {$a} ?';
$string['deletecheckfiles'] = 'Tem a certeza que pretende apagar estes ficheiros?';
$string['deletecheckfull'] = 'Tem a certeza absoluta que quer apagar completamente o utilizador {$a}, incluindo as suas inscrições, atividade e outra informação de utilizador?';
$string['deletechecktype'] = 'Tem a certeza que deseja apagar {$a->type}?';
$string['deletechecktypename'] = 'Tem a certeza que deseja apagar {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Está prestes a apagar estes ficheiros';
$string['deletecomment'] = 'Apagar este comentário';
$string['deletecompletely'] = 'Apagar completamente';
$string['deletecourse'] = 'Apagar uma disciplina';
$string['deletecoursecheck'] = 'Tem a certeza absoluta que quer apagar completamente esta disciplina e todos os dados contidos nela?';
$string['deleted'] = 'Apagado(a)';
$string['deletedactivity'] = 'Apagado: {$a}';
$string['deletedcourse'] = '{$a} foi completamente apagado(a)';
$string['deletednot'] = 'Não foi possível apagar {$a} !';
$string['deleteselected'] = 'Apagar selecionados';
$string['deleteselectedkey'] = 'Apagar chave selecionada';
$string['deletingcourse'] = 'A apagar {$a}';
$string['deletingexistingcoursedata'] = 'A apagar dados da disciplina';
$string['deletingolddata'] = 'A apagar dados antigos';
$string['department'] = 'Departamento';
$string['desc'] = 'Descendente';
$string['description'] = 'Descrição';
$string['deselectall'] = 'Desselecionar';
$string['detailedless'] = 'Menos detalhes';
$string['detailedmore'] = 'Mais detalhes';
$string['directory'] = 'Pasta';
$string['disable'] = 'Desativar';
$string['disabledcomments'] = 'Comentários desativados';
$string['displayingfirst'] = 'Apenas o(s) primeiro(s) {$a->count} {$a->things} são apresentados';
$string['displayingrecords'] = 'Total de registos: {$a}';
$string['displayingusers'] = 'Listagem dos utilizadores desde {$a->start} até {$a->end}';
$string['displayonpage'] = 'Mostrar na página';
$string['dndcourse'] = 'Pode arrastar e largar esta disciplina para alterar a sua posição ou para a mover para outra categoria.';
$string['dndenabled_inbox'] = 'arraste para aqui os ficheiros para os carregar';
$string['dndnotsupported'] = 'Carregar ficheiros através de arrastar e largar não é suportado';
$string['dndnotsupported_help'] = 'O seu navegador não suporta o carregamento de ficheiros através de arrastar e largar.<br/> Esta funcionalidade está disponível em todas as versões recentes do Chrome, Firefox e Safari, bem como no Internet Explorer 10 e posterior';
$string['dndnotsupported_insentence'] = 'Arrastar e largar não suportado';
$string['dnduploadwithoutcontent'] = 'Este carregamento não tem conteúdo nenhum';
$string['dndworkingfile'] = 'Para adicionar ficheiros nos tópicos arraste-os do seu computador para o local pretendido';
$string['dndworkingfilelink'] = 'Para adicionar ficheiros ou hiperligações nos tópicos arraste-os do seu computador para o local pretendido';
$string['dndworkingfiletext'] = 'Para adicionar ficheiros ou textos nos tópicos arraste-os do seu computador para o local pretendido';
$string['dndworkingfiletextlink'] = 'Arraste do seu computador ficheiros, textos ou hiperligações para dentro dos tópicos';
$string['dndworkinglink'] = 'Para adicionar hiperligações nos tópicos arraste-os do seu computador para o local pretendido';
$string['dndworkingtext'] = 'Para adicionar texto nos tópicos arraste-o do seu computador para o local pretendido';
$string['dndworkingtextlink'] = 'Para adicionar textos ou hiperligações nos tópicos arraste-os do seu computador para o local pretendido';
$string['documentation'] = 'Documentação do Moodle';
$string['dontsortcategories'] = 'Não ordenar categorias';
$string['dontsortcourses'] = 'Não ordenar disciplinas';
$string['down'] = 'Para baixo';
$string['download'] = 'Descarregar';
$string['downloadall'] = 'Descarregar tudo';
$string['downloadexcel'] = 'Descarregar em formato Excel';
$string['downloadfile'] = 'Descarregar ficheiro';
$string['downloadods'] = 'Descarregar em formato ODS';
$string['downloadtext'] = 'Descarregar em formato Texto';
$string['doyouagree'] = 'Leu e compreendeu as condições?';
$string['droptoupload'] = 'arraste para aqui os ficheiros para os carregar';
$string['duplicate'] = 'Duplicar';
$string['edhelpaspellpath'] = 'A verificação ortográfica no editor só pode ser utilizada se o servidor tiver o programa <strong>aspell 0.50</strong> (ou versões posteriores) instalado. Além disso, é necessário especificar o caminho correto para o ficheiro executável do programa.  Em sistemas Unix/Linux este caminho é normalmente <strong>/usr/bin/aspell</strong>.';
$string['edhelpbgcolor'] = 'Definir a área de edição de cor de fundo.<br />Os valores válidos são, por exemplo: #FFFFFF ou branco';
$string['edhelpcleanword'] = 'Esta configuração ativa ou desativa o formato Word específico de filtragem.';
$string['edhelpenablespelling'] = 'Ativa ou desativa a verificação ortográfica no editor. Quando a opção está ativa, <strong>aspell</strong> deve ser instalado no servidor. O segundo valor é o <strong>dicionário predefinido</strong>. Tal será usado se o aspell não tiver o dicionário da linguagem do utilizador.';
$string['edhelpfontfamily'] = 'A família da fonte é uma lista de fontes de nomes e/ou nomes genéricos de famílias. Os nomes das famílias devem ser separados por vírgulas.';
$string['edhelpfontlist'] = 'Definir as fontes usadas em editores com lista pendente.';
$string['edhelpfontsize'] = 'O tamanho da fonte predefinido define o tamanho da fonte no editor. <br />São exemplos de valores válidos:médio, grande, menor, maior, 10pt, 11px.';
$string['edit'] = 'Editar';
$string['edita'] = 'Editar {$a}';
$string['editcategorysettings'] = 'Configuração da categoria';
$string['editcategorythis'] = 'Editar categoria';
$string['editcoursesettings'] = 'Configuração da disciplina';
$string['editfiles'] = 'Editar ficheiros';
$string['editgroupprofile'] = 'Editar perfil do grupo';
$string['editinga'] = 'A editar {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Este valor não pode ser editado!';
$string['editmyprofile'] = 'Editar perfil';
$string['editorbgcolor'] = 'Cor de fundo';
$string['editorcleanonpaste'] = 'Limpar Word ao colar';
$string['editorcommonsettings'] = 'Configurações comuns';
$string['editordefaultfont'] = 'Fonte predefinida';
$string['editorenablespelling'] = 'Ativar verificação ortográfica';
$string['editorfontlist'] = 'Fontlist';
$string['editorfontsize'] = 'Tamanho da fonte predefinido';
$string['editorresettodefaults'] = 'Repor os valores predefinidos';
$string['editorsettings'] = 'Configurações do Editor';
$string['editorshortcutkeys'] = 'Teclas de Atalho do Editor';
$string['editsettings'] = 'Editar configurações';
$string['editsummary'] = 'Editar sumário';
$string['editthisactivity'] = 'Editar esta atividade';
$string['editthiscategory'] = 'Editar esta categoria';
$string['edittitle'] = 'Editar nome';
$string['edittitleinstructions'] = 'Escape para cancelar, Enter quando terminar';
$string['edituser'] = 'Editar contas de utilizadores';
$string['edulevel'] = 'Nível de acesso';
$string['edulevelother'] = 'Outro';
$string['edulevelparticipating'] = 'Participar';
$string['edulevelteacher'] = 'Ensinar';
$string['email'] = 'Endereço de e-mail';
$string['emailactive'] = 'E-mail ativo';
$string['emailagain'] = 'E-mail (novamente)';
$string['emailalreadysent'] = 'Já foi enviado um e-mail de reposição de senha. Por favor, verifique o seu email.';
$string['emailcharset'] = 'Charset do e-mail';
$string['emailconfirm'] = 'Confirme a sua conta';
$string['emailconfirmation'] = 'Olá {$a->firstname},

Uma nova conta foi pedida a {$a->sitename}
usando o seu endereço de e-mail.

Para confirmar a sua nova conta, clique em:

{$a->link}

Na maioria dos programas de e-mail este endereço aparece como uma hiperligação a azul que basta clicar. Se tal não funcionar,
então corte e cole o endereço na linha de Endereço no topo da janela do seu navegador de internet.

Se necessitar de ajuda, contacte o administrador do site,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: Confirmação da conta';
$string['emailconfirmsent'] = '<p>Acaba de ser enviada uma mensagem para o seu endereço <strong>{$a}</strong>, com instruções fáceis para completar a sua inscrição.</p><p>Se tiver alguma dificuldade em completar o registo, contacte o administrador do servidor.</p>';
$string['emaildigest'] = 'Tipo de Sumário de fóruns';
$string['emaildigestcomplete'] = 'Completo (e-mail diário com mensagens completas)';
$string['emaildigest_help'] = 'Esta é a configuração de resumo diário que os fóruns irão usar por omissão.

*Sem sumário: irá receber um e-mail por cada mensagem publicada no fórum;

*Completo: irá receber um e-mail diário com o conteúdo completo de cada mensagem publicada no fórum;

*Assuntos - irá receber um e-mail diário com os assuntos de cada mensagem publicada no fórum.

Poderá ainda escolher uma configuração para cada fórum, se assim desejar.';
$string['emaildigestoff'] = 'Sem sumário (um e-mail por cada mensagem submetida)';
$string['emaildigestsubjects'] = 'Assuntos (e-mail diário com assuntos das mensagens)';
$string['emaildisable'] = 'Este e-mail está desativado';
$string['emaildisableclick'] = 'Clique aqui para impedir que seja enviado e-mail para este endereço';
$string['emaildisplay'] = 'Privacidade do e-mail';
$string['emaildisplaycourse'] = 'Só pode ver o meu e-mail quem está inscrito na disciplina';
$string['emaildisplayhidden'] = 'E-mail oculto';
$string['emaildisplayno'] = 'Ninguém pode ver o meu e-mail';
$string['emaildisplayyes'] = 'Todos podem ver o meu e-mail';
$string['emailenable'] = 'Este e-mail está ativado';
$string['emailenableclick'] = 'Clique aqui para que todo o correio do sistema seja enviado para este endereço';
$string['emailexists'] = 'Este e-mail já foi registado.';
$string['emailformat'] = 'Formato de e-mail';
$string['emailmustbereal'] = 'Atenção: o seu e-mail tem que ser verdadeiro';
$string['emailnotallowed'] = 'Não são permitidos endereços de e-mail nestes domínios ({$a})';
$string['emailnotfound'] = 'O e-mail não foi encontrado na base de dados';
$string['emailonlyallowed'] = 'Este e-mail não está entre os permitidos ({$a})';
$string['emailpasswordchangeinfo'] = 'Caro(a) {$a->firstname},

Foi pedida uma nova senha para a sua conta em \'{$a->sitename}\'.

Para mudar a sua senha, aceda a:

{$a->link}

Na maioria dos programas de e-mail basta clicar neste endereço que deverá aparecer como uma hiperligação a azul. Se isto não funcionar, copie e cole o endereço na barra de endereço no topo da janela do seu navegador de Internet.

Se necessitar de ajuda, contacte o administrador do site:
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Caro(a) {$a->firstname},

Foi pedida uma nova senha para a sua conta em \'{$a->sitename}\'.

Infelizmente, a sua conta neste site está desativada e não pode ser reposta.

Por favor, contacte o administrador do site:
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Caro(a) {$a->firstname},

Foi pedida uma nova senha para a sua conta em \'{$a->sitename}\'.

Infelizmente, as senhas não podem ser definidas neste site.

Por favor, contacte o administrador do site:
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informação para alteração de senha';
$string['emailpasswordconfirmation'] = 'Viva {$a->firstname},
Pediu uma nova senha para a sua conta no servidor \'{$a->sitename}\'.

Para confirmar este pedido e receber a nova senha por e-mail, clique em:

{$a->link}

Na maioria dos programas de e-mail este endereço aparece como uma hiperligação a azul que basta clicar. Se tal não funcionar,
então corte e cole o endereço na linha de Endereço no topo da janela do seu navegador de internet.

Se necessitar de ajuda, contacte o administrador do site,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}:  Confirmação de alteração da senha';
$string['emailpasswordconfirmmaybesent'] = '<p>Se indicou um nome de utilizador ou e-mail corretos, deverá receber um e-mail.</p>
<p>Leia as instruções nessa mensagem para confirmar e completar a seleção de uma nova senha. Se continuar a ter dificuldades, por favor contacte o administrador do site.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>A conta de utilizador que especificou não possui um endereço de e-mail gravado.</p>
<p>Por favor, contacte o administrador do site.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>O detalhe de utilizador que forneceu não identifica nenhuma conta de utilizador existente.</p>
<p>Por favor, verifique a informação que introduziu e tente novamente. Se continuar a ter dificuldade, por favor contacte o administrador do site.</p>';
$string['emailpasswordconfirmsent'] = 'Foi enviada uma mensagem para o seu endereço <b>{$a}</b>.
<br />Esta contém instruções para confirmar e completar a alteração da senha.
Se continuar a ter dificuldades, contacte o administrador do servidor.';
$string['emailpasswordsent'] = 'Obrigado por confirmar a alteração da sua senha.
A sua nova senha foi enviada por correio para <br /><b>{$a->email}</b>.<br />
A nova senha foi gerada automaticamente - poderá querer <a href="{$a->link}">alterar a sua senha</a> para algo que se recorde depois com mais facilidade (mas primeiro procure a nova senha na mensagem que acabou de ser enviada).';
$string['emailresetconfirmation'] = 'Olá {$a->firstname},

Uma reposição de senha foi pedida para a sua conta \'{$a->username}\' em {$a->sitename}.

Para confirmar este pedido e definir uma nova senha, por favor aceda ao seguinte endereço: {$a->link} (Esta hiperligação é válida por {$a->resetminutes} minutos a partir do momento em que a reposição de senha foi pedida pela primeira vez).

Se este pedido de reposição de senha não foi feito por si, ignore esta mensagem.

Se precisar de ajuda, por favor contacte o administrador do site, {$a->admin}.';
$string['emailresetconfirmationsubject'] = '{$a}: Pedido de reposição de senha';
$string['emailresetconfirmsent'] = 'Foi enviado um e-mail para o seu endereço em <b>{$a}</b>.<br />Este contém instruções para confirmar e completar a alteração da sua senha. Se precisar de ajuda, por favor contacte o administrador do site, {$a->admin}.';
$string['emailtoprivatefiles'] = 'Também pode enviar ficheiros como anexos de email diretamente para a sua área de ficheiros privados. Basta anexar os seus ficheiros a um email e enviá-lo para {$a}.';
$string['emailtoprivatefilesdenied'] = 'O administrador desativou a possibilidade de carregar ficheiros privados.';
$string['emptydragdropregion'] = 'região vazia';
$string['enable'] = 'Ativar';
$string['encryptedcode'] = 'Código encriptado';
$string['english'] = 'Inglês';
$string['enrolmentmethods'] = 'Métodos de inscrição';
$string['entercourse'] = 'Clique para entrar na disciplina';
$string['enteremail'] = 'Inglês';
$string['enteremailaddress'] = 'Introduza o seu e-mail
para criar uma nova senha que lhe será enviada para esse endereço.';
$string['enterusername'] = 'Insira o seu nome de utilizador';
$string['entries'] = 'Entradas';
$string['error'] = 'Erro';
$string['errorcreatingactivity'] = 'Não é possível criar a instância da atividade \'{$a}';
$string['errorfiletoobig'] = 'O ficheiro é maior do que o limite permitido de {$a} bytes';
$string['errornouploadrepo'] = 'Não existe repositórios para este site';
$string['errorwhenconfirming'] = 'A sua conta ainda não está confirmada porque ocorreu um erro. Se clicou numa hiperligação numa mensagem para chegar aqui, assegure-se de que não havia um parágrafo ou retorno de linha na linha da sua mensagem. Tem que usar a opção cortar-colar para reconstruir o apontador completo.';
$string['eventcommentcreated'] = 'Comentário criado';
$string['eventcommentdeleted'] = 'Comentário apagado';
$string['eventcommentsviewed'] = 'Comentários visualizados';
$string['eventcontentviewed'] = 'Conteúdo visualizado';
$string['eventcoursecategorycreated'] = 'Categoria criada';
$string['eventcoursecategorydeleted'] = 'Categoria apagada';
$string['eventcoursecategoryupdated'] = 'Categoria atualizada';
$string['eventcoursecontentdeleted'] = 'Conteúdo da disciplina apagado';
$string['eventcoursecreated'] = 'Disciplina criada';
$string['eventcoursedeleted'] = 'Disciplina apagada';
$string['eventcoursemodulecreated'] = 'Módulo de disciplina criado';
$string['eventcoursemoduledeleted'] = 'Módulo de disciplina apagado';
$string['eventcoursemoduleinstancelistviewed'] = 'Lista de instâncias do módulo de disciplina visualizada';
$string['eventcoursemoduleupdated'] = 'Módulo de disciplina atualizado';
$string['eventcoursemoduleviewed'] = 'Módulo de disciplina visualizado';
$string['eventcourseresetended'] = 'Reinicialização da disciplina concluída';
$string['eventcourseresetstarted'] = 'Reinicialização da disciplina iniciada';
$string['eventcourserestored'] = 'Disciplina restaurada';
$string['eventcoursesectionupdated'] = 'Secção de disciplina atualizada';
$string['eventcourseupdated'] = 'Disciplina atualizada';
$string['eventcourseuserreportviewed'] = 'Relatório de utilizador da disciplina visualizado';
$string['eventcourseviewed'] = 'Disciplina visualizada';
$string['eventemailfailed'] = 'Falha ao enviar email';
$string['eventname'] = 'Nome do evento';
$string['eventrecentactivityviewed'] = 'Atividade recente visualizada';
$string['eventunknownlogged'] = 'Evento desconhecido';
$string['eventusercreated'] = 'Utilizador criado';
$string['eventuserdeleted'] = 'Utilizador apagado';
$string['eventuserlistviewed'] = 'Lista de utilizadores visualizada';
$string['eventuserloggedout'] = 'Utilizador saiu';
$string['eventuserpasswordupdated'] = 'Senha de utilizador atualizada';
$string['eventuserprofileviewed'] = 'Perfil do utilizador visualizado';
$string['eventuserupdated'] = 'Utilizador atualizado';
$string['everybody'] = 'Todos';
$string['executeat'] = 'Horário de execução';
$string['existing'] = 'Existente';
$string['existingadmins'] = 'Administradores existentes';
$string['existingcourse'] = 'Disciplina existente';
$string['existingcourseadding'] = 'Disciplina existente, adicionando-lhe dados';
$string['existingcoursedeleting'] = 'Disciplina existente, eliminando-a primeiro';
$string['existingcreators'] = 'Possíveis criadores de disciplinas';
$string['existingstudents'] = 'Alunos inscritos';
$string['existingteachers'] = 'Professores existentes';
$string['expand'] = 'Expandir';
$string['expandall'] = 'Expandir tudo';
$string['expandcategory'] = 'Expandir {$a}';
$string['explanation'] = 'Explicação';
$string['extendenrol'] = 'Alargar validade da inscrição';
$string['extendperiod'] = 'Período de extensão';
$string['failedloginattempts'] = '{$a->attempts} tentativas de entrada sem sucesso desde a sua última visita';
$string['feedback'] = 'Comentários';
$string['file'] = 'Ficheiro';
$string['fileexists'] = 'Já existe um ficheiro com nome {$a}';
$string['filemissing'] = '{$a} não existe';
$string['files'] = 'Ficheiros';
$string['filesanduploads'] = 'Ficheiros e carregamentos';
$string['filesfolders'] = 'Ficheiros/pastas';
$string['filetoolarge'] = 'é muito grande para carregar';
$string['fileuploadwithcontent'] = 'O carregamento de ficheiros não deve incluir o parâmetro conteúdo';
$string['filloutallfields'] = 'Por favor preencha todos os campos no formulário';
$string['filter'] = 'Filtrar';
$string['findmorecourses'] = 'Procurar mais disciplinas...';
$string['first'] = 'Primeiro';
$string['firstaccess'] = 'Primeiro acesso';
$string['firstname'] = 'Nome';
$string['firstnamephonetic'] = 'Nome - fonético';
$string['firstsiteaccess'] = 'Primeiro acesso ao site';
$string['firsttime'] = 'É a sua primeira visita aqui?';
$string['folder'] = 'Pasta';
$string['folderclosed'] = 'Pasta fechada';
$string['folderopened'] = 'Pasta aberta';
$string['followingoptional'] = 'Os campos seguintes são opcionais';
$string['followingrequired'] = 'Os campos seguintes são obrigatórios';
$string['for'] = 'Para';
$string['force'] = 'Forçar';
$string['forcelanguage'] = 'Forçar idioma';
$string['forceno'] = 'Não forçar';
$string['forcepasswordchange'] = 'Forçar mudança de senha';
$string['forcepasswordchangecheckfull'] = 'Tem a certeza que deseja forçar a mudança de senha para {$a}?';
$string['forcepasswordchange_help'] = 'Se ativar esta opção, o utilizador terá de alterar a sua senha na próxima vez que se autenticar';
$string['forcepasswordchangenot'] = 'Não é possível forçar a mudança de senha para {$a}';
$string['forcepasswordchangenotice'] = 'Deverá alterar a sua senha para poder continuar.';
$string['forcetheme'] = 'Forçar o tema';
$string['forgotaccount'] = 'Recuperar senha';
$string['forgotten'] = 'Esqueceu-se do seu nome de utilizador ou senha?';
$string['forgottenduplicate'] = 'O endereço de e-mail é partilhado por várias contas. Introduza antes o nome de utilizador';
$string['forgotteninvalidurl'] = 'URL para recuperação de senhas esquecidas';
$string['format'] = 'Formato';
$string['format_help'] = 'O formato da disciplina determina o layout da página principal:

* Formato Atividade Única - Para exibir uma única atividade ou recurso (como um Teste ou um pacote SCORM) na página da disciplina;

* Formato Social - É mostrado um fórum na página principal da disciplina;

* Formato Tópicos - A página da disciplina é organizada por secções de tópicos;

* Formato Semanal - A página da disciplina é organizada por secções semanais, em que a primeira semana começa na data de início da disciplina.';
$string['formathtml'] = 'Formato HTML';
$string['formatmarkdown'] = 'Formato Markdown';
$string['formatplain'] = 'Formato de texto simples';
$string['formattext'] = 'Autoformatação Moodle';
$string['formattexttype'] = 'Formatação';
$string['framesetinfo'] = 'Este documento quadro contém:';
$string['from'] = 'De';
$string['frontpagecategorycombo'] = 'Mostrar lista de categorias e disciplinas';
$string['frontpagecategorynames'] = 'Mostrar lista de categorias';
$string['frontpagecourselist'] = 'Mostrar lista de disciplinas';
$string['frontpagecoursesearch'] = 'Caixa \'Procurar disciplinas\'';
$string['frontpagedescription'] = 'Resumo da Página principal';
$string['frontpagedescriptionhelp'] = 'Este resumo pode ser exibido na Página principal usando o bloco Descrição da disciplina/site.';
$string['frontpageenrolledcourselist'] = 'Mostrar lista \'Minhas disciplinas\'';
$string['frontpageformat'] = 'Formato da página principal';
$string['frontpageformatloggedin'] = 'Formato da página principal, quando autenticado';
$string['frontpagenews'] = 'Mostrar últimas notícias';
$string['frontpagesettings'] = 'Configurações da página principal';
$string['fulllistofcourses'] = 'Todas as disciplinas';
$string['fullname'] = 'Nome completo';
$string['fullnamecourse'] = 'Nome completo da disciplina';
$string['fullnamecourse_help'] = 'O nome completo da disciplina é apresentado no topo de cada página e na lista de disciplinas.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nome completo do utilizador';
$string['fullprofile'] = 'Perfil completo';
$string['fullsitename'] = 'Nome completo do site';
$string['functiondisabled'] = 'Esta funcionalidade encontra-se atualmente desativada';
$string['general'] = 'Geral';
$string['geolocation'] = 'latitude - longitude';
$string['gettheselogs'] = 'Obter estes registos';
$string['go'] = 'Executar';
$string['gpl'] = 'Copyright (C) 1999 e posteriores, Martin Dougiamas (http://moodle.com)

Este programa é software livre; pode redistribuí-lo e/ou modificá-lo sob os termos da Licença Pública Geral GNU, conforme publicada pela Free Software Foundation; tanto a versão 2 da Licença como (a seu critério) qualquer versão mais recente.

Este programa é distribuído com a esperança de que seja útil, mas SEM QUALQUER GARANTIA; sem mesmo a garantia implícita de COMERCIALIZAÇÃO ou de ADEQUAÇÃO A QUALQUER PROPÓSITO EM PARTICULAR.

Para ver os pormenores, consulte a página da Licença do Moodle:
http://docs.moodle.org/en/License';
$string['gpl3'] = 'Copyright (C) 1999 e posteriores, Martin Dougiamas (http://moodle.com)

Este programa é software livre; pode redistribuí-lo e/ou modificá-lo sob os termos da Licença Pública Geral GNU, conforme publicada pela Free Software Foundation; tanto a versão 3 da Licença como (a seu critério) qualquer versão mais nova.

Este programa é distribuído com a esperança de que seja útil, mas SEM QUALQUER GARANTIA; sem mesmo a garantia implícita de COMERCIALIZAÇÃO ou de ADEQUAÇÃO A QUALQUER PROPÓSITO EM PARTICULAR.

Para ver os pormenores, consulte a página da Licença do Moodle:

http://docs.moodle.org/en/License';
$string['gpllicense'] = 'licença GPL';
$string['grade'] = 'Nota';
$string['grades'] = 'Pauta';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> está ativo neste site. Se não carregar nenhuma foto para o perfil, o Moodle irá tentar obter uma a partir do Gravatar.';
$string['group'] = 'Grupo';
$string['groupadd'] = 'Adicione novo grupo';
$string['groupaddusers'] = 'Adicione selecionados ao grupo';
$string['groupextendenrol'] = 'Alargar prazos de inscrição de todos';
$string['groupfor'] = 'para o grupo';
$string['groupinfo'] = 'Informação sobre grupo selecionado';
$string['groupinfoedit'] = 'Editar configurações de grupo';
$string['groupinfomembers'] = 'Informação sobre utilizadores selecionados';
$string['groupinfopeople'] = 'Informação sobre pessoas selecionadas';
$string['groupmembers'] = 'Membros do grupo';
$string['groupmemberssee'] = 'Mostrar membros do grupo';
$string['groupmembersselected'] = 'Membros do grupo selecionado';
$string['groupmode'] = 'Modo de grupo';
$string['groupmodeforce'] = 'Forçar modo de grupo';
$string['groupmy'] = 'O meu grupo';
$string['groupnonmembers'] = 'Pessoas em nenhum grupo';
$string['groupnotamember'] = 'Lamentamos mas não é membro desse grupo.';
$string['grouprandomassign'] = 'Distribuir aleatoriamente todos em grupos';
$string['groupremove'] = 'Apagar grupos selecionados';
$string['groupremovemembers'] = 'Apagar membros selecionados';
$string['groups'] = 'Grupos';
$string['groupsnone'] = 'Não há grupos';
$string['groupsseparate'] = 'Grupos separados';
$string['groupsvisible'] = 'Grupos visíveis';
$string['guest'] = 'Visitante';
$string['guestdescription'] = 'Os visitantes têm privilégios mínimos, e habitualmente não podem escrever texto em nenhuma parte.';
$string['guestskey'] = 'Permitir acesso a visitantes que saibam a senha';
$string['guestsno'] = 'Não admitir visitantes';
$string['guestsnotallowed'] = 'Lamentamos mas \'{$a}\'  não permite acesso a visitantes.';
$string['guestsyes'] = 'Permitir acesso a visitantes sem senha';
$string['guestuser'] = 'Visitante';
$string['guestuserinfo'] = 'Este nome de utilizador é especial e só permite acesso a algumas disciplinas.';
$string['help'] = 'Ajuda';
$string['helpprefix2'] = 'Ajuda sobre {$a}';
$string['helpwiththis'] = 'Ajuda sobre isto';
$string['hiddenassign'] = 'Atribuição oculta';
$string['hiddenfromstudents'] = 'Oculto para os alunos';
$string['hiddensections'] = 'Secções ocultas';
$string['hiddensectionscollapsed'] = 'Secções ocultas são apresentadas em forma contraída';
$string['hiddensections_help'] = 'Esta configuração determina se as secções ocultas são apresentadas aos alunos de forma contraída (talvez para uma disciplina em formato semanal para indicar feriados) ou completamente ocultas.';
$string['hiddensectionsinvisible'] = 'Secções ocultas serão completamente invisíveis';
$string['hide'] = 'Ocultar';
$string['hideadvancedsettings'] = 'Ocultar configurações avançadas';
$string['hidepicture'] = 'Ocultar fotografia';
$string['hidesection'] = 'Esconder secção {$a}';
$string['hidesettings'] = 'Ocultar opções';
$string['hideshowblocks'] = 'Ocultar ou mostrar blocos';
$string['hits'] = 'Número de acessos';
$string['hitsoncourse'] = 'Número de acessos de {$a->username} a {$a->coursename}';
$string['hitsoncoursetoday'] = 'Número de acessos a {$a->coursename} do utilizador {$a->username} hoje';
$string['home'] = 'Página principal';
$string['hour'] = 'hora';
$string['hours'] = 'horas';
$string['howtomakethemes'] = 'Como fazer temas novos';
$string['htmleditor'] = 'Usar o editor HTML';
$string['htmleditoravailable'] = 'O editor HTML está disponível';
$string['htmleditordisabled'] = 'O editor HTML foi desativado no seu perfil de utilizador';
$string['htmleditordisabledadmin'] = 'O administrador desativou o editor HTML neste site';
$string['htmleditordisabledbrowser'] = 'O editor HTML não está disponível por não ser compatível com o seu navegador.';
$string['htmlfilesonly'] = 'Só ficheiros HTML';
$string['htmlformat'] = 'Formato HTML';
$string['icon'] = 'Ícone';
$string['icqnumber'] = 'Número de ICQ';
$string['idnumber'] = 'Código de identificação';
$string['idnumbercourse'] = 'Código';
$string['idnumbercoursecategory'] = 'Número ID da categoria';
$string['idnumbercoursecategory_help'] = 'O número de identificação de uma disciplina de uma categoria apenas é usado para comunicação com sistemas externos e não é exibido em nenhum lugar da plataforma. Se a categoria tem um código oficial deve ser inserido, caso contrário o campo pode ser deixado em branco.';
$string['idnumbercourse_help'] = 'O código de uma disciplina só é usado quando comunica com sistemas externos e não é mostrado na plataforma. Se a disciplina tem um código oficial pode ser inserido, caso contrário o campo pode ser deixado em branco.';
$string['idnumbergroup'] = 'Número de identificação do grupo';
$string['idnumbergroup_help'] = 'O número de identificação de um grupo só é usado quando a correspondência do grupo com sistemas externos não é exibido em nenhuma parte do site. Se o grupo tem um nome de código oficial deve ser inserido, caso contrário o campo pode ser deixado em branco.';
$string['idnumbergrouping'] = 'Número de identificação do agrupamento';
$string['idnumbergrouping_help'] = 'O número de identificação de um agrupamento só é usado quando a correspondência do grupo com sistemas externos não é exibido em nenhuma parte do site. Se o agrupamento tem um nome de código oficial deve ser inserido, caso contrário o campo pode ser deixado em branco.';
$string['idnumbermod'] = 'Número de identificação';
$string['idnumbermod_help'] = 'Definir um número de identificação é uma forma de identificar a atividade para fins de cálculo da notas. Se a atividade não é incluída no cálculo de notas, o campo pode ser deixado em branco.

O número de identificação também pode ser definido no relatório de avaliação, porém só pode ser editado na página de configurações da atividade.';
$string['idnumbertaken'] = 'Este número de identificação já está a ser usado';
$string['imagealt'] = 'Descrição da imagem';
$string['import'] = 'Importar';
$string['importdata'] = 'Importar dados de disciplina';
$string['importdataexported'] = 'Dados da disciplina de origem exportados com sucesso.<br />
Continua a importação para a sua disciplina de destino.';
$string['importdatafinished'] = 'Importação concluída! Siga para a sua disciplina.';
$string['importdatafrom'] = 'Procure uma disciplina donde importar dados:';
$string['inactive'] = 'Inativo';
$string['include'] = 'Incluir';
$string['includeallusers'] = 'Incluir todos os utilizadores';
$string['includecoursefiles'] = 'Incluir ficheiros da disciplina';
$string['includecourseusers'] = 'Incluir utilizadores da disciplina';
$string['included'] = 'Incluídos';
$string['includelogentries'] = 'Incluir entradas de registo';
$string['includemodules'] = 'Incluir Módulos';
$string['includemoduleuserdata'] = 'Incluir dados de utilizador do módulo';
$string['includeneededusers'] = 'Incluir utilizadores necessários';
$string['includenoneusers'] = 'Não inclui nenhuns utilizadores';
$string['includeroleassignments'] = 'Incluir papéis atribuídos';
$string['includesitefiles'] = 'Incluir ficheiros do site usados nesta disciplina';
$string['includeuserfiles'] = 'Incluir ficheiros de utilizador';
$string['increasesections'] = 'Aumentar o número de secções';
$string['info'] = 'Informação';
$string['institution'] = 'Instituição';
$string['instudentview'] = 'em modo de visão do aluno';
$string['interests'] = 'Interesses';
$string['interestslist'] = 'Lista de interesses';
$string['interestslist_help'] = 'Insira os seus interesses separados por vírgulas. Serão mostrados na página do seu perfil como tags.';
$string['invalidemail'] = 'Endereço de correio não válido';
$string['invalidlogin'] = 'Nome de utilizador não válido, por favor tente novamente';
$string['invalidusername'] = 'O nome de utilizador apenas pode conter caracteres alfanuméricos, minúsculas, underscore (_), hífen (-), ponto final (.) ou o símbolo (@)';
$string['invalidusernameupload'] = 'Nome de utilizador inválido';
$string['ip_address'] = 'Endereço IP';
$string['jump'] = 'Saltar';
$string['jumpto'] = 'Ir para...';
$string['keep'] = 'Manter';
$string['keepsearching'] = 'Continuar a pesquisar';
$string['langltr'] = 'Direção do texto do idioma da esquerda para a direita';
$string['langrtl'] = 'Direção do texto do idioma da direita para a esquerda';
$string['language'] = 'Idioma';
$string['languagegood'] = 'Este pacote linguístico está em dia! : -)';
$string['last'] = 'Último';
$string['lastaccess'] = 'Último acesso';
$string['lastcourseaccess'] = 'Último acesso ao site';
$string['lastedited'] = 'Última edição';
$string['lastip'] = 'Último endereço IP';
$string['lastlogin'] = 'Última autenticação';
$string['lastmodified'] = 'Última alteração';
$string['lastname'] = 'Apelido';
$string['lastnamephonetic'] = 'Apelido - fonético';
$string['lastsiteaccess'] = 'Último acesso ao site';
$string['lastyear'] = 'Ano passado';
$string['latestlanguagepack'] = 'Verificar o pacote linguístico mais recente em moodle.org';
$string['layouttable'] = 'Tabela de esquema';
$string['leavetokeep'] = 'Deixe em branco se quiser manter a senha atual';
$string['legacythemeinuse'] = 'Este site está a ser mostrado em modo de compatibilidade pois o seu o navegador está numa versão muito antiga.';
$string['license'] = 'Licença';
$string['licenses'] = 'Licenças';
$string['liketologin'] = 'Quer aceder agora ao sistema com uma conta completa de utilizador?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista de ficheiros em {$a}';
$string['listofallpeople'] = 'Lista de todas as pessoas';
$string['listofcourses'] = 'Lista de disciplinas';
$string['loadinghelp'] = 'A carregar…';
$string['local'] = 'Local';
$string['localplugins'] = 'Módulos locais';
$string['localpluginsmanage'] = 'Gerir módulos';
$string['location'] = 'Localização';
$string['locktimeout'] = 'A operação excedeu o tempo de execução enquanto aguardava por um bloqueio.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Nome de utilizador: {$a}.';
$string['loggedinasguest'] = 'Encontra-se a utilizar acesso de visitante';
$string['loggedinnot'] = 'Utilizador não autenticado.';
$string['login'] = 'Entrar';
$string['loginalready'] = 'Já está autenticado como';
$string['loginas'] = 'Entrar como';
$string['loginaspasswordexplain'] = '<p>Para poder utilizar esta opção terá que introduzir a senha especial para "entrar como".<br />Se não souber essa senha, pergunte ao administrador.</p>';
$string['login_failure_logs'] = 'Relatórios de tentativas de autenticação sem sucesso';
$string['loginguest'] = 'Entrar como visitante';
$string['loginsite'] = 'Entrar no site';
$string['loginsteps'] = '</a> <p>Para ter acesso completo às disciplinas precisa dedicar um minuto a criar uma nova conta de utilizador.</p>
<p>Cada disciplina pode também ter uma "senha de inscrição", fornecida pelo professor.</p>
<p>Siga as instruções:</p>
<ol>
<li>Preencha o formulário de <a href="{$a}">Nova Conta</a>  com os seus dados.</li>
<li>Será enviada imediatamente uma mensagem para o seu e-mail.</li>
<li>Leia a mensagem e visite a hiperligação fornecida para confirmar o registo.</li>
<li>A sua conta será confirmada e será autenticado no site.</li>
<li>A seguir poderá selecionar a disciplina na qual se quer inscrever.</li>
<li>Se for solicitada uma "senha de inscrição", terá que usara a senha indicada pelo seu professor. Esta ação o inscreverá na disciplina.</li>
<li>Passará assim a ter acesso completo à disciplina. A partir de agora só precisará de introduzir o seu nome de utilizador e senha (no formulário nesta página) para se autenticar e aceder a qualquer curso em que está inscrito.</li>
</ol>';
$string['loginstepsnone'] = '<p>Viva!</p>
<p>Para ter acesso total às disciplinas, vai ter que criar a sua própria conta de utilizador.</p>
<p>Só precisa de escolher um nome de utilizador e senha, e usá-los no formulário nesta página!</p>
<p>Se já alguém tiver escolhido esse nome de utilizador deverá tentar com um nome diferente.</p>';
$string['loginto'] = 'Entrar em {$a}';
$string['logout'] = 'Sair';
$string['logoutconfirm'] = 'Tem a certeza que quer sair?';
$string['logs'] = 'Registos de atividade';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">more</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">more</a> ]';
$string['lookback'] = 'Desde há';
$string['mailadmins'] = 'Informe os administradores';
$string['mailstudents'] = 'Informar os alunos';
$string['mailteachers'] = 'Informe os professores';
$string['maincoursepage'] = 'Página principal da disciplina';
$string['makeafolder'] = 'Criar pasta';
$string['makeeditable'] = 'Se mudar as permissões de \'{$a}\' para que o servidor de http (por exemplo Apache) possa modificá-lo, este ficheiro poderá ser editado diretamente nesta página';
$string['makethismyhome'] = 'Fazer desta a minha página principal';
$string['manageblocks'] = 'Blocos';
$string['managecategorythis'] = 'Gerir esta categoria';
$string['managecourses'] = 'Gerir disciplinas';
$string['managedatabase'] = 'Gestão da base de dados';
$string['manageeditorfiles'] = 'Gerir ficheiros usados pelo editor';
$string['managefilters'] = 'Filtros';
$string['managemodules'] = 'Módulos';
$string['manageroles'] = 'papéis e permissões';
$string['markedthistopic'] = 'Este tópico está marcado como o tópico atual';
$string['markthistopic'] = 'Marque este tópico como o tópico atual';
$string['matchingsearchandrole'] = 'Corresponder \'{$a->search}\' e {$a->role}';
$string['maxareabytesreached'] = 'A imagem (ou o tamanho total de vários ficheiros) é maior do que o espaço restante nesta área.';
$string['maxbytesforfile'] = 'O ficheiro {$a} é maior do que o tamanho máximo permitido.';
$string['maxfilesize'] = 'Tamanho máximo para novos ficheiros: {$a}';
$string['maxfilesreached'] = 'Tem permissão para anexar um máximo de {$a} ficheiro (s) para este item';
$string['maximumchars'] = 'Máximo de {$a} caracteres';
$string['maximumgrade'] = 'Nota máxima';
$string['maximumgradex'] = 'Nota máxima: {$a}';
$string['maximumshort'] = 'Máx';
$string['maximumupload'] = 'Tamanho máximo dos ficheiros enviados';
$string['maximumupload_help'] = 'Esta configuração determina o tamanho máximo dos ficheiros que podem ser enviados para a disciplina, limitado pelas configurações definidas pelo administrador. Os módulos de atividades também incluem uma configuração do tamanho máximo de forma a restringir ainda mais o tamanho dos ficheiros.';
$string['maxnumberweeks'] = 'Número máximo de secções';
$string['maxnumberweeks_desc'] = 'Número máximo disponível na lista pendente "Número de Semanas/Tópicos" nas configurações da disciplina (aplica-se apenas a certos formatos de disciplina).';
$string['maxnumcoursesincombo'] = 'Procurar <a href="{$a->link}">{$a->numberofcourses} disciplinas</a>.';
$string['maxsize'] = 'Tamanho máximo:{$a}';
$string['maxsizeandareasize'] = 'Tamanho máximo para novos ficheiros: {$a->size}, overall limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Tamanho máximo para novos ficheiros: {$a->size}, máximo de anexos: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Tamanho máximo para novos ficheiros: {$a->size}, número máximo de anexos: {$a->attachments}, limite global: {$a->areasize}';
$string['memberincourse'] = 'Participantes na disciplina';
$string['messagebody'] = 'Conteúdo da mensagem';
$string['messagedselectedusers'] = 'A mensagem foi enviada para os utilizadores selecionados e a lista de destinatários reiniciada.';
$string['messagedselectedusersfailed'] = 'Algo falhou no envio da mensagem para os utilizadores selecionados. Alguns deles poderão ter recebido a mensagem.';
$string['messageprovider:availableupdate'] = 'Notificação de atualizações disponíveis';
$string['messageprovider:backup'] = 'Notificações da cópia de segurança';
$string['messageprovider:badgecreatornotice'] = 'Notificações do emissor da Medalha';
$string['messageprovider:badgerecipientnotice'] = 'Notificações do destinatário da Medalha';
$string['messageprovider:courserequestapproved'] = 'Notificação da aprovação do pedido de disciplina';
$string['messageprovider:courserequested'] = 'Notificação do pedido de disciplina';
$string['messageprovider:courserequestrejected'] = 'Notificação de rejeição do pedido de disciplina';
$string['messageprovider:errors'] = 'Erros importantes no site';
$string['messageprovider:errors_help'] = 'Estes são alguns erros importantes que o administrador deve conhecer';
$string['messageprovider:instantmessage'] = 'Mensagens pessoais entre utilizadores';
$string['messageprovider:instantmessage_help'] = 'Esta secção define as mensagens enviadas diretamente de uns utilizadores para outros através do site';
$string['messageprovider:notices'] = 'Avisos sobre problemas menores';
$string['messageprovider:notices_help'] = 'Estes são avisos que o administrador pode estar interessado em ver.';
$string['messageselect'] = 'Selecionar este aluno como destinatário de uma mensagem';
$string['messageselectadd'] = 'Enviar mensagem';
$string['middlename'] = 'Nome do meio';
$string['migratinggrades'] = 'Migração de notas';
$string['min'] = 'minuto';
$string['mins'] = 'minutos';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['miscellaneous'] = 'Diversos';
$string['missingcategory'] = 'Tem que escolher uma categoria';
$string['missingdescription'] = 'Falta a descrição';
$string['missingemail'] = 'Falta o e-mail';
$string['missingfirstname'] = 'Falta o nome';
$string['missingfromdisk'] = 'Em falta no disco';
$string['missingfullname'] = 'Falta o nome completo';
$string['missinglastname'] = 'Falta o apelido';
$string['missingname'] = 'Falta o nome completo';
$string['missingnewpassword'] = 'Falta a nova senha';
$string['missingpassword'] = 'Falta a senha';
$string['missingrecaptchachallengefield'] = 'Falta preencher o campo do reCAPTCHA';
$string['missingreqreason'] = 'Falta justificação';
$string['missingshortname'] = 'Falta o nome curto';
$string['missingshortsitename'] = 'Falta o nome curto do site';
$string['missingsitedescription'] = 'Falta a descrição do site';
$string['missingsitename'] = 'Falta o nome do site';
$string['missingstrings'] = 'Detetar variáveis que faltam';
$string['missingstudent'] = 'Tem que escolher algo';
$string['missingsummary'] = 'Falta o sumário';
$string['missingteacher'] = 'Tem que escolher algo';
$string['missingurl'] = 'Falta o URL';
$string['missingusername'] = 'Falta o nome de utilizador';
$string['modchooserdisable'] = 'Desativar seleção rápida';
$string['modchooserenable'] = 'Ativar seleção rápida';
$string['moddoesnotsupporttype'] = 'A atividade {$a->modname} não suporta carregamentos do tipo {$a->type}';
$string['modified'] = 'Modificado';
$string['moduleintro'] = 'Descrição';
$string['modulesetup'] = 'Ajustando as tabelas de módulos';
$string['modulesuccess'] = 'As tabelas de {$a} foram configuradas corretamente';
$string['modulesused'] = 'Módulos utilizados';
$string['month'] = 'Mês';
$string['months'] = 'Meses';
$string['moodledocs'] = 'Documentação';
$string['moodledocslink'] = 'Documentação Moodle para esta página';
$string['moodlerelease'] = 'Versão Moodle';
$string['moodleversion'] = 'Versão do Moodle';
$string['more'] = 'mais';
$string['morehelp'] = 'Mais ajuda';
$string['moreinfo'] = 'Mais informação';
$string['moreinformation'] = 'Mais informações sobre este erro';
$string['moreprofileinfoneeded'] = 'Conte-nos mais coisas sobre si';
$string['mostrecently'] = 'mais recentemente';
$string['move'] = 'Mover';
$string['movecategoriessuccess'] = 'Foram movidas com sucesso {$a->count} categorias para a categoria \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Foram movidas com sucesso {$a->count} categorias para o nível superior';
$string['movecategorycontentto'] = 'Mover para';
$string['movecategorysuccess'] = 'Foi movida com sucesso a categoria \'{$a->moved}\' para a categoria \'{$a->to}\'';
$string['movecategoryto'] = 'Mover categoria para:';
$string['movecategorytotopsuccess'] = 'Foi movida com sucesso a categoria \'{$a->moved}\' para o nível superior';
$string['movecontent'] = 'Mover {$a}';
$string['movecontentstoanothercategory'] = 'Mover conteúdo para outra categoria';
$string['movecoursemodule'] = 'Mover recurso';
$string['movecoursesection'] = 'Mover secção';
$string['movecourseto'] = 'Mover disciplina para:';
$string['movedown'] = 'Mover para baixo';
$string['movefilestohere'] = 'Mover os ficheiros para este local';
$string['movefull'] = 'Mover {$a} para este local';
$string['movehere'] = 'Mover para aqui';
$string['moveleft'] = 'Mover para a esquerda';
$string['moveright'] = 'Mover para a direita';
$string['movesection'] = 'Mover secção {$a}';
$string['moveselectedcategoriesto'] = 'Mover as categorias selecionadas para';
$string['moveselectedcoursesto'] = 'Mover as disciplinas selecionadas para...';
$string['movetoanotherfolder'] = 'Mover para outra pasta';
$string['moveup'] = 'Mover para cima';
$string['msnid'] = 'ID do MSN';
$string['mustchangepassword'] = 'A nova senha deverá ser diferente da atual';
$string['mustconfirm'] = 'Precisa confirmar a sua autenticação';
$string['mycourses'] = 'As minhas disciplinas';
$string['myfiles'] = 'Meus ficheiros privados';
$string['myfilesmanage'] = 'Gerir os meus ficheiros privados';
$string['myhome'] = 'Minha página principal';
$string['mymoodledashboard'] = 'Meu Painel do utilizador Moodle';
$string['myprofile'] = 'Meu perfil';
$string['name'] = 'Designação';
$string['nameforlink'] = 'Que nome deseja dar a esta hiperligação?';
$string['nameforpage'] = 'Nome';
$string['navigation'] = 'Navegação';
$string['needed'] = 'Necessários';
$string['networkdropped'] = 'A sua ligação à Internet está instável ou foi interrompida.<br />
Por favor, esteja ciente que as alterações podem não ser guardadas corretamente até que a sua ligação melhore.';
$string['never'] = 'Nunca';
$string['neverdeletelogs'] = 'Nunca apague os registos de atividade';
$string['new'] = 'Novo';
$string['newaccount'] = 'Nova conta';
$string['newcourse'] = 'Nova disciplina';
$string['newpassword'] = 'Nova senha';
$string['newpasswordfromlost'] = '<strong>ATENÇÃO:</strong> A sua <strong>senha atual</strong> deverá ter sido enviada para si na <strong>segunda</strong> de duas mensagens que lhe foram enviadas como parte do processo de recuperação de senha. Verifique que já recebeu a mensagem com a senha de substituição antes de continuar com esta página.';
$string['newpassword_help'] = 'Insira uma nova senha ou deixe em branco para manter a atual.';
$string['newpasswordtext'] = 'Viva {$a->firstname},
Tal como foi pedido, a senha da sua conta em  \'{$a->sitename}\' foi substituída por uma nova senha provisória.

A informação atual da sua conta de utilizador é:

  Nome de utilizador: {$a->username}
  senha: {$a->newpassword}

Por favor visite a página que se segue, para modificar a senha provisória:
   {$a->link}

Em muitos leitores de correio bastará clicar sobre o apontador acima.
Se isso não funcionar, recorte e cole o endereço na barra de endereço do seu
navegador.

Cumprimentos,
{$a->signoff}

Administrador do servidor \'{$a->sitename}\'

(esta mensagem foi gerada automaticamente)';
$string['newpicture'] = 'Nova imagem';
$string['newpicture_help'] = 'Para adicionar uma nova imagem, procure e selecione uma imagem (em formato JPG ou PNG) e clique em "Atualizar perfil". A imagem será recortada na forma de um quadrado e redimensionada para 100x100 pixels.';
$string['newsitem'] = 'notícia';
$string['newsitems'] = 'notícias';
$string['newsitemsnumber'] = 'Notícias a mostrar';
$string['newsitemsnumber_help'] = 'Esta configuração determina quantas notícias mais recentes aparecem no bloco de últimas notícias na página da disciplina. Se for definido o valor "0" (zero), então o bloco "Últimas notícias" não será mostrado.';
$string['newuser'] = 'Novo utilizador';
$string['newusernewpasswordsubj'] = 'Nova conta de utilizador';
$string['newusernewpasswordtext'] = 'Uma nova conta de utilizador foi criada para si em
 \'{$a->sitename}\' e foi-lhe atribuída uma senha temporária.

Os seus dados atuais são:
Nome de utilizador: {$a->username};
Senha: {$a->newpassword} (pode alterar a sua senha depois de se autenticar no Moodle, em Administração » Meu perfil » Modificar senha).

Para começar a usar \'{$a->sitename}\' aceda a:
{$a->link}.

Na maior parte dos programas de e-mail a hiperligação anterior deverá aparecer sublinhada, permitindo-lhe aceder a essa página com um simples clique. Se isso não funcionar, copie o URL para a barra de endereços no topo do seu navegador.

Cumprimentos,
{$a->signoff}

Administrador do servidor \'{$a->sitename}\'

(Esta mensagem foi gerada automaticamente.)';
$string['newusers'] = 'Novos utilizadores';
$string['newwindow'] = 'Nova janela';
$string['next'] = 'Seguinte';
$string['nextsection'] = 'Nova secção';
$string['no'] = 'Não';
$string['noblockstoaddhere'] = 'Não existem blocos que possa adicionar a esta página.';
$string['nobody'] = 'Ninguém';
$string['nochange'] = 'Sem alteração';
$string['nocomments'] = 'Sem comentários';
$string['nocourses'] = 'Em nenhuma disciplina';
$string['nocoursesfound'] = 'Não foram encontradas disciplinas com as palavras \'{$a}';
$string['nocoursesyet'] = 'Nenhuma disciplina nesta categoria';
$string['nodstpresets'] = 'O administrador do sistema não ativou o suporte para horário de verão.';
$string['nofilesselected'] = 'Não foram selecionados ficheiros para serem restaurados';
$string['nofilesyet'] = 'A sua disciplina ainda não tem nenhum ficheiro';
$string['nograde'] = 'Nenhuma nota';
$string['nohelpforactivityorresource'] = 'Não exite atualmente nenhuma ajuda associada a esse recurso ou atividade';
$string['noimagesyet'] = 'A sua disciplina ainda não tem nenhuma imagem';
$string['nologsfound'] = 'Não foram encontrados registos de atividade';
$string['nomatchingusers'] = 'Não existem utilizadores que correspondam a \'{$a}';
$string['nomorecourses'] = 'Não foram encontradas mais disciplinas';
$string['nomoreidnumber'] = 'Sem usar um número de identificação, para evitar colisões';
$string['none'] = 'Nenhum';
$string['noneditingteacher'] = 'Professor não editor';
$string['noneditingteacherdescription'] = 'Os professores não editores poderão leccionar numa disciplina e atribuir classificações aos alunos, mas não poderão modificar as atividades.';
$string['nonstandard'] = 'Não predefinido';
$string['nopendingcourses'] = 'Não existem disciplinas à espera de aprovação';
$string['nopotentialadmins'] = 'Nenhum candidato a administrador';
$string['nopotentialcreators'] = 'Nenhum candidato a criador de disciplina';
$string['nopotentialstudents'] = 'Nenhum candidato a aluno';
$string['nopotentialteachers'] = 'Nenhum candidato a professor(a)';
$string['norecentactivity'] = 'Não existe atividade recente';
$string['noreplybouncemessage'] = 'Respondeu para um e-mail que não aceita  respostas. Se estava a responder a uma mensagem num fórum, por favor use o Responder na mensagem {$a}.

Segue o conteúdo da sua mensagem de e-mail:';
$string['noreplybouncesubject'] = '{$a} - mensagens devolvidas';
$string['noreplyname'] = 'Não responda para este endereço';
$string['noresetrecord'] = 'Não existe nenhum registo desse pedido de reposição. Por favor, inicie um novo pedido de reposição de senha.';
$string['noresults'] = 'Sem resultados';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Filtro normal';
$string['nosite'] = 'Não foi possível encontrar disciplina no nível site';
$string['nostudentsfound'] = 'Nenhum {$a} encontrado';
$string['nostudentsingroup'] = 'Ainda não existem alunos neste grupo';
$string['nostudentsyet'] = 'Ainda não há nenhum aluno inscrito nesta disciplina';
$string['nosuchemail'] = 'Esse e-mail não existe';
$string['notavailable'] = 'Não disponível';
$string['notavailablecourse'] = '{$a} não está disponível';
$string['noteachersyet'] = 'Esta disciplina ainda não tem professor';
$string['notenrolled'] = '{$a} não está inscrito nesta disciplina.';
$string['notenrolledprofile'] = 'Este perfil não está ativo porque o utilizador não está inscrito nesta disciplina.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Nota:</strong> A capacidade de restaurar datas foi desativada pois não possui permissões para tal.';
$string['noteuserschangednonetocourse'] = '<strong>Nota:</strong> É necessário restaurar os utilizadores da disciplina quando se restaurar os dados dos utilizadores. Esta configuração foi alterada para si.';
$string['nothingnew'] = 'Sem atividade recente';
$string['nothingtodisplay'] = 'Não existe informação para apresentar';
$string['notice'] = 'Aviso';
$string['noticenewerbackup'] = 'Esta cópia de segurança foi criada com Moodle {$a->backuprelease} ({$a->backupversion}) que é mais recente do que a sua versão atual do Moodle {$a->serverrelease} ({$a->serverversion}). Isso poderá gerar algumas inconsistências por ser impossível garantir a compatibilidade entre cópias para versões diferentes.';
$string['notifications'] = 'Notificações';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, User: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Pode ver estes registos de atividade em {$a}';
$string['notifyloginfailuresmessagestart'] = 'Esta é a lista de tentativas de autenticação sem sucesso em {$a}, desde a última vez que foi notificado';
$string['notifyloginfailuressubject'] = '{$a} :: Tentativas de autenticação sem sucesso';
$string['notincluded'] = 'Não incluído';
$string['notingroup'] = 'Lamentamos, mas precisa de estar inscrito num grupo para ver esta atividade.';
$string['notpublic'] = 'Privado!';
$string['nousersfound'] = 'Nenhum utilizador encontrado';
$string['nousersmatching'] = 'Não foram encontrados utilizadores coincidentes com \'{$a}';
$string['nousersyet'] = 'Ainda não há nenhum utilizador';
$string['novalidcourses'] = 'Não existem disciplinas válidas para exibir';
$string['now'] = 'agora';
$string['numattempts'] = '{$a} tentativa(s) de autenticação sem sucesso';
$string['numberofcourses'] = 'Número de disciplinas';
$string['numberweeks'] = 'Número de secções';
$string['numdays'] = '{$a} dia(s)';
$string['numhours'] = '{$a} hora(s)';
$string['numletters'] = '{$a} letra(s)';
$string['numminutes'] = '{$a} minuto(s)';
$string['nummonths'] = '{$a} mês(es)';
$string['numseconds'] = '{$a} segundo()s';
$string['numviews'] = '{$a} acesso(s)';
$string['numweeks'] = '{$a} semana(s)';
$string['numwords'] = '{$a} palavra(s)';
$string['numyears'] = '{$a} ano(s)';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Senha atual';
$string['olduserdirectory'] = 'Esta é a ANTIGA pasta de utilizadores, que já não é necessário. Pode apagá-lo sem problemas. Os ficheiros nele contidos foram copiados para a NOVA pasta.';
$string['optional'] = 'opcional';
$string['options'] = 'opções';
$string['order'] = 'Ordem';
$string['originalpath'] = 'Caminho original';
$string['orphanedactivitiesinsectionno'] = 'Atividades órfãs (secção {$a})';
$string['other'] = 'Outro';
$string['outline'] = 'Esboço';
$string['outlinereport'] = 'Relatório geral';
$string['page'] = 'Página';
$string['pagea'] = 'Página {$a}';
$string['pageheaderconfigablock'] = 'A configurar um bloco em {$a->fullname}';
$string['pagepath'] = 'Caminho da página';
$string['pageshouldredirect'] = 'Esta página será redirecionada automaticamente. Se tal não acontecer use a hiperligação de continuar abaixo.';
$string['parentcategory'] = 'Categoria ascendente';
$string['parentcoursenotfound'] = 'Disciplina ascendente desconhecida';
$string['parentfolder'] = 'Pasta ascendente';
$string['participants'] = 'Participantes';
$string['participantslist'] = 'Rácio de participantes';
$string['participationratio'] = 'Taxa de participação';
$string['participationreport'] = 'Relatório de participação';
$string['password'] = 'Senha';
$string['passwordchanged'] = 'Senha modificada';
$string['passwordconfirmchange'] = 'Confirme alteração de senha';
$string['passwordextlink'] = 'O seguinte apontador permite-lhe substituir a sua senha esquecida. Este apontador conduz para o site Moodle que está utilizar.';
$string['passwordforgotten'] = 'Senha esquecida';
$string['passwordforgotteninstructions'] = 'Primeiro teremos que identificar os seus dados na base de dados. Por favor diga-nos <strong>algum dos dois dados seguintes</strong> no campo respetivo: o seu nome de utilizador no site Moodle, ou o e-mail com que está registado. Não é preciso indicar as duas coisas.';
$string['passwordforgotteninstructions2'] = 'Para redefinir a sua senha, insira o seu nome de utilizador ou endereço de e-mail. Se for encontrada na base de dados, será enviado um e-mail para o seu endereço, com instruções sobre como obter o acesso novamente.';
$string['passwordnohelp'] = 'No é possível ajudar a recuperar a sua senha perdida. Por favor entre em contacto com o administrador do site Moodle que está a utilizar.';
$string['passwordrecovery'] = 'Sim, ajude-me a entrar';
$string['passwordsdiffer'] = 'As senhas não coincidem';
$string['passwordsent'] = 'Senha enviada com sucesso';
$string['passwordsenttext'] = '<p>Foi enviada uma mensagem para o seu endereço {$a->email}.</p>
<p><strong>Por favor aceda à sua sua nova senha na sua caixa de e-mail</strong>.</p>
<p>A nova senha foi gerada automaticamente, sendo assim conveniente <a href="{$a->link}">mudá-la para outra mais fácil de se lembrar</a>.</p>';
$string['passwordset'] = 'A sua senha foi definida';
$string['path'] = 'Caminho';
$string['pathnotexists'] = 'Esse caminho não existe no seu servidor!';
$string['pathslasherror'] = 'O caminho não pode terminar com / !!';
$string['paymentinstant'] = 'Use o botão em baixo para pagar e completar a inscrição!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pending</small>)';
$string['paymentrequired'] = 'Esta disciplina exige uma taxa de inscrição.';
$string['payments'] = 'Pagamentos';
$string['paymentsorry'] = 'Obrigado pelo seu pagamento! Infelizmente a sua inscrição ainda não foi processada por completo e ainda não pode aceder à disciplina "{$a->fullname}". Por favor tente novamente dentro de alguns segundos e se continuar sem acesso, contacte o professor {$a->teacher} ou o administrador do site.';
$string['paymentthanks'] = 'Obrigado pelo seu pagamento. Já está inscrito na disciplina:<br />"{$a}"';
$string['pendingrequests'] = 'Pedidos pendentes';
$string['periodending'] = 'Fim do período  ({$a})';
$string['perpage'] = 'Por página';
$string['perpagea'] = 'Por página: {$a}';
$string['personal'] = 'Pessoal';
$string['personalprofile'] = 'Perfil pessoal';
$string['phone'] = 'Telefone';
$string['phone2'] = 'Telemóvel';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = 'Fotografia de {$a}';
$string['pictureofuser'] = 'Fotografia do utilizador';
$string['pleaseclose'] = 'Por favor feche esta janela já.';
$string['pleasesearchmore'] = 'Por favor procure um pouco mais';
$string['pleaseusesearch'] = 'Por favor use a pesquisa';
$string['plugin'] = 'Módulo';
$string['plugincheck'] = 'Teste dos módulos';
$string['plugindeletefiles'] = 'Todos os dados associados ao módulo \'{$a->name}\' foram apagados da base de dados. Para prevenir a reinstalação do módulo, deve apagar esta pasta do seu servidor: {$a->directory}';
$string['pluginsetup'] = 'A configurar tabelas de módulos';
$string['policyaccept'] = 'Compreendo e concordo';
$string['policyagree'] = 'Deverá aceitar este regulamento para poder proceder a utilizar este site. Aceita o regulamento?';
$string['policyagreement'] = 'Regulamento de utilização';
$string['policyagreementclick'] = 'Carregue aqui para ler o regulamento de utilização';
$string['popup'] = 'expandir';
$string['popupwindow'] = 'Abra o ficheiro numa nova janela';
$string['popupwindowname'] = 'Janela expandida';
$string['post'] = 'Submeter';
$string['posts'] = 'Submissões';
$string['potentialadmins'] = 'Possíveis administradores';
$string['potentialcreators'] = 'Possíveis criadores de disciplinas';
$string['potentialstudents'] = 'Possíveis alunos';
$string['potentialteachers'] = 'Possíveis professores';
$string['preferences'] = 'Preferências';
$string['preferredlanguage'] = 'Idioma preferido';
$string['preferredtheme'] = 'Tema preferido';
$string['preprocessingbackupfile'] = 'Pré cópia de segurança';
$string['prev'] = 'Anterior';
$string['preview'] = 'Pré-visualização';
$string['previewhtml'] = 'Pré-visualização em HTML';
$string['previeworchoose'] = 'Ver ou escolher um tema';
$string['previous'] = 'Anterior';
$string['previouslyselectedusers'] = 'Os utilizadores selecionados não correspondem \'{$a}';
$string['previoussection'] = 'Secção anterior';
$string['primaryadminsetup'] = 'Conta de administrador configurador';
$string['private_files_handler'] = 'Armazene os anexos para um e-mail na área de armazenamento de ficheiros privados do utilizador.';
$string['private_files_handler_name'] = 'E-mail para ficheiros privados';
$string['profile'] = 'Perfil';
$string['profilenotshown'] = 'Esta descrição do perfil não será mostrada até que este utilizador esteja inscrito em pelo menos uma disciplina.';
$string['publicprofile'] = 'Perfil público';
$string['publicsitefileswarning'] = 'Nota: Os ficheiros aqui colocados poderão ser acedidos por todos';
$string['publicsitefileswarning2'] = 'Nota: Os ficheiros colocados aqui podem ser acessados todos que saibam (ou adivinhem) o URL. Por razões de segurança, é recomendado que todos os ficheiros de cópias de segurança sejam apagados imediatamente após a sua restauração.';
$string['publicsitefileswarning3'] = 'Nota: Os ficheiros colocados aqui podem ser acessados todos que saibam (ou adivinhem) o URL.<br />Por razões de segurança, os ficheiros das cópias de segurança devem ser guardados apenas numa pasta segura.';
$string['publish'] = 'Publicar';
$string['question'] = 'Pergunta';
$string['questionsinthequestionbank'] = 'Perguntas no banco de questões';
$string['readinginfofrombackup'] = 'Lendo informação da cópia de segurança';
$string['readme'] = 'LEIA-ME';
$string['recentactivity'] = 'Atividade recente';
$string['recentactivityreport'] = 'Relatório completo de atividade recente...';
$string['recipientslist'] = 'Lista de destinatários';
$string['recreatedcategory'] = 'Recriada a categoria {$a}';
$string['redirect'] = 'Redirecionar';
$string['reducesections'] = 'Reduzir o número de secções';
$string['refresh'] = 'Atualizar';
$string['refreshingevents'] = 'A atualizar eventos';
$string['registration'] = 'Registo do Moodle';
$string['registrationcontact'] = 'Contacto por parte do público';
$string['registrationcontactno'] = 'Não, não quero um formulário de contacto nesta listagem do site.';
$string['registrationcontactyes'] = 'Sim, inclua um formulário para que potenciais utilizadores do Moodle possam contactar-me.';
$string['registrationemail'] = 'Notificações por e-mail';
$string['registrationinfo'] = '<p>Esta página permite-lhe registar-se no site do Moodle (moodle.org). O registo é gratuito.
O principal benefício de se registar é que será adicionado a uma lista de correio apenas para divulgação de alertas de segurança e de novas versões do Moodle.</p>
<p>Por omissão, os seus dados serão mantidos confidenciais, e nunca serão vendidos ou facultados a mais ninguém. A única razão para a recolha desta informação é para efeitos de apoio, e para ajudar a criar estatísticas acerca da comunidade de utilizadores do Moodle.</p>
<p>Se assim o entender, poderá permitir que o nome do seu site, país e URL sejam adicionados à lista pública de sites que usam o Moodle.</p>
<p>Todos os novos registos serão verificados manualmente antes de serem adicionados à lista, mas uma vez adicionados, poderá atualizar os dados do seu registo em qualquer altura submetendo novamente este formulário.</p>';
$string['registrationinfotitle'] = 'Informação de registo';
$string['registrationno'] = 'Não pretendo receber notificações por e-mail';
$string['registrationsend'] = 'Enviar dados de registo para o moodle.org';
$string['registrationyes'] = 'Notifique-me acerca de assuntos importantes';
$string['reject'] = 'Rejeitar';
$string['rejectdots'] = 'Rejeitar...';
$string['reload'] = 'Recarregar';
$string['remoteappuser'] = 'Utilizador remoto {$a}';
$string['remove'] = 'Remover';
$string['removeadmin'] = 'Remover administrador';
$string['removecreator'] = 'Remover criador da disciplina';
$string['removestudent'] = 'Remover aluno';
$string['removeteacher'] = 'Remover professor';
$string['rename'] = 'Renomear';
$string['renamefileto'] = 'Renomear <strong>{$a}</strong> para';
$string['report'] = 'Relatório';
$string['reports'] = 'Relatórios';
$string['repositories'] = 'Repositórios';
$string['requestcourse'] = 'Pedir disciplina';
$string['requestedby'] = 'Pedida por';
$string['requestedcourses'] = 'Disciplinas pedidas';
$string['requestreason'] = 'Justificação do pedido de disciplina';
$string['required'] = 'Obrigatório';
$string['requirespayment'] = 'Esta disciplina exige uma taxa de inscrição.';
$string['reset'] = 'Limpar';
$string['resetcomponent'] = 'Componente';
$string['resetcourse'] = 'Reiniciar disciplina';
$string['resetinfo'] = 'Esta página permite-lhe limpar os dados de utilizadores numa disciplina, mantendo as atividades e outras configurações. Por favor tenha em atenção que após submeter o seu pedido nesta página, os dados apagados serão perdidos para sempre!';
$string['resetnotimplemented'] = 'Reiniciação não implementada';
$string['resetrecordexpired'] = 'A hiperligação que usou para repor a senha foi gerada há mais de {$a} minutos e expirou. Por favor, inicie um novo pedido de reposição de senha.';
$string['resetstartdate'] = 'Reiniciar data de início';
$string['resetstatus'] = 'Estado';
$string['resettask'] = 'Tarefa';
$string['resettodefaults'] = 'Reiniciar com valores predefinidos';
$string['resortcourses'] = 'Ordenar disciplinas';
$string['resortsubcategoriesby'] = 'Ordenar subcategorias por {$a} ascendente';
$string['resortsubcategoriesbyreverse'] = 'Ordenar subcategorias por {$a} descendente';
$string['resource'] = 'Recurso';
$string['resourcedisplayauto'] = 'Automático';
$string['resourcedisplaydownload'] = 'Forçar descarga';
$string['resourcedisplayembed'] = 'Incorporar';
$string['resourcedisplayframe'] = 'Frame';
$string['resourcedisplaynew'] = 'Nova janela';
$string['resourcedisplayopen'] = 'Mesma janela';
$string['resourcedisplaypopup'] = 'Janela de pop-up';
$string['resources'] = 'Recursos';
$string['resources_help'] = 'Os Recursos permitem inserir na disciplina quase todo o tipo de conteúdo.';
$string['restore'] = 'Restaurar';
$string['restorecancelled'] = 'Restauro cancelado';
$string['restorecannotassignroles'] = 'Para restaurar necessita de atribuir papéis e não possui permissão para fazê-lo.';
$string['restorecannotcreateorassignroles'] = 'Ao restaurar necessita de criar ou atribuir papéis na disciplina e não tem permissões para tal';
$string['restorecannotcreateuser'] = 'Ao restaurar necessita de criar o utilizador \'{$a}\' a partir do ficheiro da cópia de segurança e não tem permissões para tal';
$string['restorecannotoverrideperms'] = 'Ao restaurar precisa de substituir permissões e não tem permissão para tal';
$string['restorecoursenow'] = 'Restaurar a disciplina';
$string['restoredaccount'] = 'Conta recuperada';
$string['restoredaccountinfo'] = 'Esta conta foi importada de outro servidor e perdeu a senha. Para configurar uma nova senha por e-mail, clique em Continuar';
$string['restorefinished'] = 'Restauro concluído com sucesso';
$string['restoreto'] = 'Restaurar para';
$string['restoretositeadding'] = 'Aviso: Está prestes a restaurar a página inicial do site, adicionando-lhe dados!';
$string['restoretositedeleting'] = 'Aviso: Está prestes a restaurar a página inicial do site, excluindo-lhe dados!';
$string['restoreuserconflict'] = 'Tentar restaurar o utilizador \'{$a}\' do ficheiro da cópia de segurança irá causar conflitos';
$string['restoreuserinfofailed'] = 'O processo de restauração parou porque não possui permissão para restaurar dados dos utilizadores.';
$string['restoreusersprecheck'] = 'A verificar os dados dos utilizadores';
$string['restoreusersprecheckerror'] = 'Foram encontrados problemas ao verificar os dados dos utilizadores';
$string['restricted'] = 'Restritos';
$string['returningtosite'] = 'Voltar para este site?';
$string['returntooriginaluser'] = 'Voltar a {$a}';
$string['revert'] = 'Reverter';
$string['role'] = 'Papel ';
$string['roleassignments'] = 'Permissões do papel';
$string['rolemappings'] = 'Mapa de papéis atribuídos';
$string['rolerenaming'] = 'Alteração de nome do papel';
$string['rolerenaming_help'] = 'Este parâmetro permite alterar os nomes dos papéis. Apenas o nome do papel é mudado - as permissões desse papel não são afetadas. Se forem criados novos papéis, os seus nomes aparecerão em todas as páginas da disciplina. Se algum dos papéis renomeados tiver sido selecionado pelo administrador como gestor da disciplina, então o novo nome desse papel vai também aparecer nas listas de disciplinas.';
$string['roles'] = 'Papéis atribuídos';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Número de artigos RSS recentes';
$string['rsserror'] = 'Erro na leitura de dados RSS';
$string['rsserrorauth'] = 'A sua hiperligação de RSS não contém um token de autenticação válido.';
$string['rsserrorguest'] = 'Esta lista usa o acesso de visitante para aceder à informação, mas o visitante não tem permissões de leitura dessa informação. Visite o URL de origem desta lista autenticado com uma conta válida para obter uma nova hiperligação de RSS.';
$string['rsskeyshelp'] = '<p>Para garantir a segurança e privacidade, os URLs das listas RSS possuem um token especial identificador. Desta forma, evita-se que outros utilizadores acedam a áreas indevidas do Moodle através das listas. </p><p> Este token é criado automaticamente da primeira vez que aceder a uma área de Moodle que produz uma lista RSS. Se sentir que o seu token lista RSS foi comprometido de alguma forma, pode solicitar um novo clicando na hiperligação aqui de Recomeço. Após isto repare que os seus URLs de listas RSS ficarão inválidos. </p>';
$string['rsstype'] = 'Lista RSS para esta atividade';
$string['saveandnext'] = 'Gravar e mostrar o seguinte';
$string['savechanges'] = 'Gravar alterações';
$string['savechangesanddisplay'] = 'Gravar alterações e mostrar';
$string['savechangesandreturntocourse'] = 'Gravar alterações e regressar à disciplina';
$string['savecomment'] = 'Gravar comentário';
$string['savedat'] = 'Gravado em:';
$string['savepreferences'] = 'Gravar preferências';
$string['saveto'] = 'Gravar em';
$string['scale'] = 'Nota';
$string['scale_help'] = 'As notas qualitativas permitem avaliar atividades numa disciplina. A escala de notas qualitativas consiste numa lista ordenada de indicadores,
que vão do negativo ao positivo, separados por vírgulas. Por exemplo:Não satisfaz, Satisfaz pouco, Satisfaz bastante,Excelente';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Escalas';
$string['scalescustom'] = 'Escalas personalizadas';
$string['scalescustomcreate'] = 'Adicionar uma nova escala';
$string['scalescustomno'] = 'Ainda não foram criadas escalas personalizadas';
$string['scalesstandard'] = 'Escalas padrão';
$string['scalestandard'] = 'Escala padrão';
$string['scalestandard_help'] = 'Uma escala padrão está disponível em todo o site para todas as disciplinas.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Para criar escalas personalizadas, use a ligação Escalas... no menu de administração da sua disciplina.';
$string['scalestip2'] = 'Para criar escalas personalizadas, clique na secção Notas no menu de administração da disciplina e a seguir selecione Editar, Escalas.';
$string['schedule'] = 'Horário';
$string['screenshot'] = 'Captura de ecrã';
$string['search'] = 'Procurar';
$string['searchagain'] = 'Procurar novamente';
$string['searchbyemail'] = 'Procurar por endereço de e-mail';
$string['searchbyusername'] = 'Procurar por nome de utilizador';
$string['searchcourses'] = 'Procurar disciplinas';
$string['searchhelp'] = '<p>Pode procurar várias palavras de uma só vez e refinar a pesquisa de várias formas:</p>
<ul>
<li>"palavra" - encontrar qualquer correspondência desta palavra no texto.</li>
<li>"+palavra" - apenas correspondências exatas das palavras serão encontradas.</li>
<li>"-palavra" - não incluir resultados que contenham esta palavra.</li>
</ul>';
$string['search_help'] = 'Para fazer uma pesquisa básica de uma ou mais palavras no texto, digite as palavras a pesquisar separadas por espaços. São consideradas para pesquisa todas as palavras com mais de dois caracteres.

Para fazer pesquisas avançadas clique no botão de pesquisa sem digitar nenhuma palavra na caixa de texto para ter acesso ao formulário de pesquisa avançada.';
$string['searchoptions'] = 'Opções de pesquisa';
$string['searchresults'] = 'Procurar resultados';
$string['sec'] = 'segundo';
$string['seconds'] = 'segundos';
$string['secondsleft'] = '{$a} segundos';
$string['secondstotime172800'] = '2 dias';
$string['secondstotime259200'] = '3 dias';
$string['secondstotime345600'] = '4 dias';
$string['secondstotime432000'] = '5 dias';
$string['secondstotime518400'] = '6 dias';
$string['secondstotime604800'] = '1 semana';
$string['secondstotime86400'] = '1 dia';
$string['secretalreadyused'] = 'A senha não foi alterada, porque a ligação para confirmar a sua alteração já foi utilizada.';
$string['secs'] = 'segundos';
$string['section'] = 'Secção';
$string['sectionname'] = 'Nome da secção';
$string['sections'] = 'Secções';
$string['sectionusedefaultname'] = 'Usar o nome predefinido da secção';
$string['seealsostats'] = 'Ver também: estatísticas';
$string['selctauser'] = 'Selecione um utilizador';
$string['select'] = 'Selecione';
$string['selectacategory'] = 'Por favor, selecione uma categoria';
$string['selectacountry'] = 'Selecione um país';
$string['selectacourse'] = 'Selecione uma disciplina';
$string['selectacoursesite'] = 'Selecione uma disciplina ou site';
$string['selectagroup'] = 'Selecione um grupo';
$string['selectall'] = 'Selecionar todos';
$string['selectamodule'] = 'Por favor selecione um módulo de atividade';
$string['selectanaction'] = 'Selecione uma ação';
$string['selectanoptions'] = 'Selecione uma opção';
$string['selectaregion'] = 'Selecione uma região';
$string['selectcategorysort'] = 'Que categorias gostaria de ordenar?';
$string['selectcategorysortby'] = 'Selecione como gostaria de ordenar as categorias';
$string['selectcoursesortby'] = 'Selecione como gostaria de ordenar as disciplinas';
$string['selectdefault'] = 'Selecionar valor predefinido';
$string['selectedcategories'] = 'Categorias selecionadas';
$string['selectedfile'] = 'Selecione um ficheiro';
$string['selectednowmove'] = '{$a} ficheiros selecionados para serem movidos. Vá ao destino e pressione Mude os ficheiros para este local';
$string['selectfiles'] = 'Selecione os ficheiros';
$string['selectmoduletoviewhelp'] = 'Selecione uma atividade ou recurso para exibir a respetiva ajuda. Faça duplo clique no nome de uma atividade ou recurso para os adicionar rapidamente.';
$string['selectnos'] = 'Selecione todos os \'Não\'';
$string['selectperiod'] = 'Selecione período';
$string['senddetails'] = 'Envie os meus dados por correio';
$string['separate'] = 'Separar';
$string['separateandconnected'] = 'Modos de aprendizagem isolado e conexo';
$string['separateandconnectedinfo'] = 'A escala baseia-se na teoria de aprendizagem isolado e conexo. Esta teoria descreve duas maneiras diferentes que podemos avaliar e aprender sobre as coisas que vemos e ouvimos. <ul> <li> <strong>Aprendizagem isolada</ strong> tão objectiva quanto possível, evitando sentimentos e emoções. Numa discussão com outras pessoas, gostam de defender as suas próprias ideias, usando a lógica de encontrar lacunas nas ideias dos adversários. </li><li><strong>Conexo</strong> são mais sensíveis a outras pessoas. Criam facilmente empatia e preferem ouvir e questionar até que sentem que se podem conectar e "compreender as coisas sob outro ponto de vista". Eles aprendem através da partilha das experiências que levaram ao conhecimento que encontramos em outras pessoas.</li></ul>';
$string['servererror'] = 'Ocorreu um erro ao comunicar com o servidor';
$string['serverlocaltime'] = 'Hora local do servidor';
$string['setcategorytheme'] = 'Definir tema da categoria';
$string['setpassword'] = 'Definir senha';
$string['setpasswordinstructions'] = 'Por favor, introduza abaixo e repita a sua nova senha, depois clique em "Definir Senha".<br /> A sua nova senha será gravada e em seguida poderá autenticar-se no site.';
$string['settings'] = 'Configurações';
$string['shortname'] = 'Nome curto';
$string['shortnamecollisionwarning'] = '[*] = Este nome curto já está a ser usado por uma disciplina e deverá ser modificado quando a disciplina for aprovada.';
$string['shortnamecourse'] = 'Nome curto';
$string['shortnamecourse_help'] = 'O nome curto da disciplina é mostrado na barra de navegação e no assunto das mensagens enviadas por e-mail.';
$string['shortnametaken'] = 'O nome curto selecionado já está atribuído a outra disciplina ({$a})';
$string['shortnameuser'] = 'Nome curto do utilizador';
$string['shortsitename'] = 'Nome curto do site (uma única palavra)';
$string['show'] = 'Mostrar';
$string['showactions'] = 'Ações a mostrar';
$string['showadvancedsettings'] = 'Mostrar configurações avançadas';
$string['showall'] = 'Mostrar tudo {$a}';
$string['showallcourses'] = 'Mostrar todas as disciplinas';
$string['showallusers'] = 'Mostrar todos os utilizadores';
$string['showblockcourse'] = 'Mostrar a lista das disciplinas que contêm bloco';
$string['showcategory'] = 'Mostrar {$a}';
$string['showcomments'] = 'Mostrar/Ocultar comentários';
$string['showcommentsnonjs'] = 'Mostrar comentários';
$string['showdescription'] = 'Mostrar descrição na página da disciplina.';
$string['showdescription_help'] = 'Se ativar esta opção, a descrição acima será exibida na página da disciplina logo abaixo da hiperligação para a atividade ou recurso.';
$string['showgrades'] = 'Mostrar pauta aos alunos';
$string['showgrades_help'] = 'Muitas das atividades permitem que seja atribuída avaliação. Esta configuração determina se o aluno pode ver uma lista das suas notas na disciplina através de uma hiperligação disponível no bloco administração.';
$string['showingacourses'] = 'Mostrar todas as {$a} disciplinas';
$string['showingxofycourses'] = 'A mostrar disciplinas de {$a->start} a {$a->end} num total de  {$a->total} disciplinas';
$string['showlistofcourses'] = 'Mostrar todas as disciplinas';
$string['showmodulecourse'] = 'Mostrar a lista de disciplinas com atividades';
$string['showonly'] = 'Mostrar apenas';
$string['showperpage'] = 'Mostrar apenas {$a} por página';
$string['showrecent'] = 'Mostrar atividade recente';
$string['showreports'] = 'Mostrar relatórios de atividade';
$string['showreports_help'] = 'São disponibilizados relatórios de atividade para cada participante, mostrando a sua atividade na disciplina atual. Esses relatórios incluem o registo das suas contribuições nos fóruns, trabalhos e relatórios de acesso. Esta configuração determina se o aluno pode ter acesso a estes relatórios através da página do seu perfil.';
$string['showsettings'] = 'Mostrar configuração';
$string['showtheselogs'] = 'Mostrar estatísticas de acesso';
$string['showthishelpinlanguage'] = 'Mostrar esta ajuda no idioma: {$a}';
$string['since'] = 'Desde';
$string['sincelast'] = 'desde a última autenticação';
$string['site'] = 'Site';
$string['sitedefault'] = 'Valor predefinido do site';
$string['siteerrors'] = 'Erros no site';
$string['sitefiles'] = 'Ficheiros do site';
$string['sitefilesused'] = 'Ficheiros do site usados nesta disciplina';
$string['sitehome'] = 'Página inicial do site';
$string['sitelegacyfiles'] = 'Ficheiros da disciplina (retrocompatibilidade)';
$string['sitelogs'] = 'Estatísticas de acesso ao site';
$string['sitemessage'] = 'Utilizadores de mensagens';
$string['sitenews'] = 'Notícias';
$string['sitepages'] = 'Páginas do site';
$string['sitepartlist'] = 'Não possui as permissões necessárias para ver a lista de participantes';
$string['sitepartlist0'] = 'A lista de participantes só pode ser consultada pelos professores da página principal do site';
$string['sitepartlist1'] = 'A lista de participantes só pode ser consultada pelos professores';
$string['sites'] = 'Sites';
$string['sitesection'] = 'Incluir secção de conteúdo editável';
$string['sitesettings'] = 'Configurações do site';
$string['siteteachers'] = 'Professores do site';
$string['size'] = 'Tamanho';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['skipped'] = 'Ignorado';
$string['skiptocategorylisting'] = 'Ir para as listas de categorias';
$string['skiptocoursedetails'] = 'Ir para as informações detalhadas da disciplina';
$string['skiptocourselisting'] = 'Ir para as listas de disciplinas';
$string['skypeid'] = 'ID do Skype';
$string['socialheadline'] = 'Fórum social - últimos tópicos';
$string['someallowguest'] = 'Algumas disciplinas podem aceitar visitantes';
$string['someerrorswerefound'] = 'Alguma informação incorreta ou em falta. Veja pormenores a seguir e corrija.';
$string['sort'] = 'Ordenar';
$string['sortby'] = 'Ordenar por';
$string['sortbyx'] = 'Ordenar por {$a} ascendente';
$string['sortbyxreverse'] = 'Ordenar por {$a} descendente';
$string['sorting'] = 'Ordenar';
$string['sourcerole'] = 'Procurar papel';
$string['specifyname'] = 'Tem de atribuir um nome';
$string['standard'] = 'Padrão';
$string['starpending'] = '([*] = disciplinas à espera de aprovação)';
$string['startdate'] = 'Data de início';
$string['startdate_help'] = 'Esta configuração determina a data de início da disciplina quando se encontra em formato semanal. Também determina a data mais próxima em que os relatórios das atividades da disciplina se encontram disponíveis. Caso a disciplina seja reiniciada e a data de início alterada, todas as datas da disciplina serão movidas relativamente à nova data de início.';
$string['startingfrom'] = 'Iniciar a partir de';
$string['startsignup'] = 'Criar nova conta';
$string['state'] = 'Estado/Província';
$string['statistics'] = 'Estatísticas';
$string['statisticsgraph'] = 'Gráfico de estatísticas';
$string['stats'] = 'Estatísticas';
$string['statslogins'] = 'Autenticações';
$string['statsmodedetailed'] = 'Visão detalhada (utilizador)';
$string['statsmodegeneral'] = 'Visão geral';
$string['statsnodata'] = 'Não existem dados disponíveis para essa combinação de disciplina e período.';
$string['statsnodatauser'] = 'Não existem dados disponíveis para essa combinação de disciplina, utilizador e período.';
$string['statsoff'] = 'Estatísticas atualmente desativadas';
$string['statsreads'] = 'Vistas';
$string['statsreport1'] = 'Autenticações';
$string['statsreport10'] = 'Atividade de utilizador';
$string['statsreport11'] = 'Disciplinas mais ativas';
$string['statsreport12'] = 'Disciplinas mais ativas (com pesos)';
$string['statsreport13'] = 'Disciplinas com maior participação (inscrições)';
$string['statsreport14'] = 'Disciplinas com maior participação (consultas/contribuições)';
$string['statsreport2'] = 'Consultas (professores e alunos)';
$string['statsreport3'] = 'Contribuições (professores e alunos)';
$string['statsreport4'] = 'Toda a atividade (professores e alunos)';
$string['statsreport5'] = 'Atividade de alunos (consultas e contribuições)';
$string['statsreport7'] = 'Atividade de utilizadores (consultas e contribuições)';
$string['statsreport8'] = 'Toda a atividade de utilizadores';
$string['statsreport9'] = 'Autenticações (página principal)';
$string['statsreportactivity'] = 'Toda a atividade (professores e alunos)';
$string['statsreportactivitybyrole'] = 'Todas as atividades (vistas e contribuições)';
$string['statsreportforuser'] = 'para';
$string['statsreportlogins'] = 'Autenticações';
$string['statsreportreads'] = 'Consultas (todos os papéis)';
$string['statsreporttype'] = 'Tipo de relatório';
$string['statsreportwrites'] = 'Contribuições (todos os papéis)';
$string['statsstudentactivity'] = 'Atividade de alunos';
$string['statsstudentreads'] = 'Consultas de alunos';
$string['statsstudentwrites'] = 'Contribuições de alunos';
$string['statsteacheractivity'] = 'Atividade de professores';
$string['statsteacherreads'] = 'Consultas de professores';
$string['statsteacherwrites'] = 'Contribuições de professores';
$string['statstimeperiod'] = 'Período de tempo - fim:';
$string['statsuniquelogins'] = 'Autenticações únicas';
$string['statsuseractivity'] = 'Toda a atividade';
$string['statsuserlogins'] = 'Autenticações';
$string['statsuserreads'] = 'Vistas';
$string['statsuserwrites'] = 'Afixação de elementos';
$string['statswrites'] = 'Afixação de elementos';
$string['status'] = 'Estado';
$string['stringsnotset'] = 'As variáveis seguintes não estão definidas em {$a}';
$string['studentnotallowed'] = 'Desculpe, mas não se pode inscrever nesta disciplina como \'{$a}';
$string['students'] = 'Alunos';
$string['studentsandteachers'] = 'Alunos e professores';
$string['subcategories'] = 'Subcategorias';
$string['subcategory'] = 'Subcategoria';
$string['subcategoryof'] = 'Subcategoria de {$a}';
$string['submit'] = 'Submeter';
$string['success'] = 'Operação realizada com sucesso!';
$string['summary'] = 'Sumário';
$string['summary_help'] = 'Um sumário é um texto curto cujo o objetivo é fornecer informação para preparar os alunos para as atividades dentro do tópico ou semana. O texto é mostrado na página da disciplina sob o nome da secção.';
$string['summaryof'] = 'Sumário de {$a}';
$string['supplyinfo'] = 'Insira alguma informação sobre si';
$string['suspended'] = 'Suspenso';
$string['suspendedusers'] = 'Utilizadores suspensos';
$string['switchdevicedefault'] = 'Mudar para o tema standard';
$string['switchdevicerecommended'] = 'Mudar para o tema recomendado';
$string['switchrolereturn'] = 'Retomar o meu papel habitual';
$string['switchroleto'] = 'Assumir o papel de...';
$string['tag'] = 'Palavra-chave';
$string['tagalready'] = 'Esta palavra-chave já existe';
$string['tagmanagement'] = 'Adicionar/ apagar palavras-chave...';
$string['tags'] = 'Palavras-chave';
$string['targetrole'] = 'Papel atribuído no destino';
$string['teacheronly'] = 'só para o {$a}';
$string['teacherroles'] = '{$a} papéis';
$string['teachers'] = 'Professores';
$string['textediting'] = 'Editor de texto';
$string['texteditor'] = 'Usar formulários Web';
$string['textformat'] = 'Formato de texto simples';
$string['thanks'] = 'Obrigado';
$string['theme'] = 'Tema';
$string['themes'] = 'Temas';
$string['themesaved'] = 'O novo tema foi gravado';
$string['therearecourses'] = 'Há {$a} disciplinas';
$string['thereareno'] = 'Não existe nenhum {$a} nesta disciplina';
$string['thiscategory'] = 'Esta categoria';
$string['thiscategorycontains'] = 'Esta categoria contém';
$string['time'] = 'Hora';
$string['timecreatedcourse'] = 'Data de criação da disciplina';
$string['timezone'] = 'Fuso horário';
$string['to'] = 'Até';
$string['tocontent'] = 'Para o item "{$a}"';
$string['tocreatenewaccount'] = 'Passar para criar nova conta';
$string['today'] = 'Hoje';
$string['todaylogs'] = 'Atividade de hoje';
$string['toeveryone'] = 'para todos';
$string['toomanybounces'] = 'Esse e-mail tem devolvido várias mensagens. <strong>Deverá modificá-lo</strong> para poder continuar.';
$string['toomanytoshow'] = 'Há demasiados utilizadores para mostrar';
$string['toomanyusersmatchsearch'] = 'Demasiados utilizadores, ({$a->count}) coincidem \'{$a->search}';
$string['toomanyuserstoshow'] = 'Demasiados utilizadores ({$a}) para mostrar';
$string['toonly'] = 'apenas para {$a}';
$string['top'] = 'Topo';
$string['topic'] = 'Tópico';
$string['topichide'] = 'Esconda este tópico de {$a}';
$string['topicoutline'] = 'Lista de tópicos';
$string['topicshow'] = 'Mostre este tópico a {$a}';
$string['toplevelcategory'] = 'Categoria de nível superior';
$string['total'] = 'Total';
$string['totopofsection'] = 'Para o topo da secção "{$a}"';
$string['trackforums'] = 'Monitorização de fóruns';
$string['trackforumsno'] = 'Não: não assinalar mensagens não lidas';
$string['trackforumsyes'] = 'Sim: Assinalar mensagens não lidas';
$string['trysearching'] = 'Tente melhor fazer uma pesquisa.';
$string['turneditingoff'] = 'Desativar modo de edição';
$string['turneditingon'] = 'Ativar modo de edição';
$string['unauthorisedlogin'] = 'A conta de utilizador "{$a}" não está disponível neste site';
$string['undecided'] = 'Indeciso';
$string['unfinished'] = 'Sem terminar';
$string['unknowncategory'] = 'Categoria desconhecida';
$string['unknownerror'] = 'Erro desconhecido';
$string['unlimited'] = 'Ilimitado(a)';
$string['unpacking'] = 'Desempacotando {$a}';
$string['unsafepassword'] = 'Senha pouco segura - tente outra melhor';
$string['untilcomplete'] = 'Até estar completo';
$string['unusedaccounts'] = 'Contas que não sejam utilizadas por mais do que {$a} dias são apagadas automaticamente';
$string['unzip'] = 'Descompactar';
$string['unzippingbackup'] = 'Descompactando cópia de segurança';
$string['up'] = 'Para cima';
$string['update'] = 'Atualizar';
$string['updated'] = '{$a} foi atualizado(a)';
$string['updatemymoodleoff'] = 'Terminar personalização desta página';
$string['updatemymoodleon'] = 'Personalizar esta página';
$string['updatemyprofile'] = 'Atualizar Perfil';
$string['updatesevery'] = 'Atualizações a cada {$a} segundos';
$string['updatethis'] = 'Atualizar {$a}';
$string['updatethiscourse'] = 'Atualizar esta disciplina';
$string['updatinga'] = 'A atualizar: {$a}';
$string['updatingain'] = 'Atualizar {$a->what} em {$a->in}';
$string['upload'] = 'Carregar';
$string['uploadafile'] = 'Carregar ficheiro';
$string['uploadcantwrite'] = 'Não foi possível escrever ficheiro no disco';
$string['uploadedfile'] = 'Ficheiro recebido com sucesso';
$string['uploadedfileto'] = 'Recebido {$a->file} em {$a->directory}';
$string['uploadedfiletoobig'] = 'Lamentamos, mas esse ficheiro é muito grande (o limite é {$a} bytes)';
$string['uploadextension'] = 'O envio de ficheiro parado pela extensão';
$string['uploadfailednotrecovering'] = 'A recepção do ficheiro que enviou falhou devido a um problema com um dos ficheiros, {$a->name}.<br />Os problemas encontrados foram:<br />{$a->problem}<br />Não foi possível resolver o problema.';
$string['uploadfilelog'] = 'Relatório de envio do ficheiro {$a}';
$string['uploadformlimit'] = 'O ficheiro enviado {$a} excedeu o limite máximo permitido no formulário';
$string['uploadlabel'] = 'Título:';
$string['uploadlimitwithsize'] = 'Tamanho limite do carregamento de ficheiros no contexto {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Carregar novo ficheiro';
$string['uploadnofilefound'] = 'Nenhum ficheiro encontrado - tem a certeza que selecionou algum ficheiro para enviar?';
$string['uploadnotallowed'] = 'Não é permitido anexar ficheiros';
$string['uploadnotempdir'] = 'Não existe pasta temporária';
$string['uploadoldfilesdeleted'] = 'O(s) ficheiro(s) antigo(s) na sua área de ficheiros enviados foi apagado';
$string['uploadpartialfile'] = 'Foi recebida apenas uma parte do ficheiro';
$string['uploadproblem'] = 'Ocorreu m problema desconhecido no envio do ficheiro \'{$a}\' (talvez fosse demasiado grande?)';
$string['uploadrenamedchars'] = 'O ficheiro foi renomeado de {$a->oldname} para {$a->newname} para substituir caracteres não válidos.';
$string['uploadrenamedcollision'] = 'O ficheiro foi renomeado de  {$a->oldname} para {$a->newname} devido a um conflito no nome.';
$string['uploadserverlimit'] = 'O ficheiro enviado excedeu o limite de tamanho máximo imposto pelo servidor';
$string['uploadthisfile'] = 'Carregar este ficheiro';
$string['url'] = 'URL';
$string['used'] = 'Utilizado';
$string['usedinnplaces'] = 'Utilizado em {$a} locais';
$string['usemessageform'] = 'Ou use o formulário abaixo para enviar uma mensagem para os alunos selecionados';
$string['user'] = 'Utilizador';
$string['useractivity'] = 'Atividade';
$string['userconfirmed'] = '{$a} confirmado';
$string['usercurrentsettings'] = 'Meu perfil';
$string['userdata'] = 'Dados de utilizador';
$string['userdeleted'] = 'Este utilizador foi apagado';
$string['userdescription'] = 'Descrição';
$string['userdescription_help'] = 'Nesta caixa pode inserir algum texto sobre si que será mostrado no seu perfil quando outros utilizadores o consultarem.';
$string['userdetails'] = 'Mais detalhes';
$string['userfiles'] = 'Ficheiros de utilizador';
$string['userlist'] = 'Lista de utilizadores';
$string['usermenu'] = 'Menu do utilizador';
$string['username'] = 'Nome de utilizador';
$string['usernameemail'] = 'Nome de utilizador / e-mail';
$string['usernameemailmatch'] = 'O nome de utilizador e e-mail não correspondem ao mesmo utilizador';
$string['usernameexists'] = 'Este nome de utilizador já existe; escolha outro';
$string['usernamelowercase'] = 'Apenas são permitidas letras minúsculas';
$string['usernamenotfound'] = 'O nome de utilizador não foi encontrado na base de dados';
$string['usernameoremail'] = 'Introduza o nome de utilizador ou o e-mail';
$string['usernotconfirmed'] = 'Não foi possível confirmar {$a}';
$string['userpic'] = 'Foto';
$string['users'] = 'Utilizadores';
$string['userselectorautoselectunique'] = 'Se for encontrado apenas um utilizador, selecionar automaticamente.';
$string['userselectorpreserveselected'] = 'Mantenha os utilizadores selecionados, mesmo que já não correspondam à pesquisa';
$string['userselectorsearchanywhere'] = 'Localizar o texto a procurar em qualquer parte dos campos exibidos';
$string['usersnew'] = 'Novos utilizadores';
$string['usersnoaccesssince'] = 'Mostrar utilizadores inativos por mais de';
$string['userswithfiles'] = 'Utilizadores com ficheiros';
$string['useruploadtype'] = 'Tipo de envio do utilizador: {$a}';
$string['userviewingsettings'] = 'Configurações de perfil para {$a}';
$string['userzones'] = 'Zonas de utilizador';
$string['usetheme'] = 'Usar tema';
$string['usingexistingcourse'] = 'Usando a disciplina existente';
$string['valuealreadyused'] = 'Este valor já foi usado.';
$string['version'] = 'Versão';
$string['view'] = 'Ver';
$string['viewallcourses'] = 'Ver todas as disciplinas';
$string['viewallcoursescategories'] = 'Ver todas as disciplinas e categorias';
$string['viewallsubcategories'] = 'Ver todas as subcategorias';
$string['viewfileinpopup'] = 'Ver ficheiro numa janela pop-up';
$string['viewing'] = 'A visualizar:';
$string['viewmore'] = 'Ver mais';
$string['viewprofile'] = 'Ver perfil';
$string['views'] = 'Visualizações';
$string['viewsolution'] = 'ver solução';
$string['virusfound'] = 'Atenção Sr. Administrador! O antivírus Clam detetou a presença dum vírus num ficheiro enviado por {$a->user}  para a disciplina {$a->course}. Segue-se a mensagem de saída do clamscan:';
$string['virusfoundlater'] = 'No ficheiro  {$a->filename} que enviou em {$a->date}, para a disciplina {$a->course}, foi posteriormente encontrado um vírus. Segue-se um sumário do que foi feito ao ficheiro:

{$a->action}

Se o ficheiro fazia parte de algum trabalho, será melhor enviá-lo novamente para que o professor possa vê-lo.';
$string['virusfoundlateradmin'] = 'Atenção Sr. administrador! Encontrou-se um vírus num  ficheiro que foi enviado em {$a->date}, com o nome {$a->filename}, para a disciplina {$a->course}, pelo utilizador {$a->user}. Segue-se um sumário do que foi feito do ficheiro:

{$a->action}

foi também enviada uma notificação para o utilizador.';
$string['virusfoundlateradminnolog'] = 'Atenção Sr. administrador! Encontrou-se um vírus num  ficheiro que foi enviado com o nome {$a->filename}. Moodle não conseguiu determinar qual foi o utilizador que enviou o ficheiro.

Segue-se um sumário do que foi feito do ficheiro:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Detetado um vírus!';
$string['virusfounduser'] = 'O ficheiro {$a->filename} que enviou foi inspeccionado pelo detetor de vírus e foi diagnosticado como infetado! O seu envio de ficheiro não teve sucesso.';
$string['virusplaceholder'] = 'Foi detetado um vírus neste ficheiro que foi enviado; o ficheiro foi transferido ou apagado e o utilizador foi notificado.';
$string['visible'] = 'Visível';
$string['visible_help'] = 'Esta configuração determina se a disciplina aparece na lista de disciplinas. Se a disciplina não estiver disponível para alunos, apenas os utilizadores com os papéis de "Professor" e "Administrador" poderão entrar na disciplina.';
$string['visibletostudents'] = 'Visível para {$a}';
$string['warning'] = 'Aviso';
$string['warningdeleteresource'] = 'Advertência: {$a} é referido(a) num recurso. Quer atualizar esse recurso?';
$string['webpage'] = 'Página Web';
$string['week'] = 'Semana';
$string['weekhide'] = 'Oculte esta semana a {$a}';
$string['weeklyoutline'] = 'Agenda semanal';
$string['weeks'] = 'semanas';
$string['weekshow'] = 'Mostre esta semana a {$a}';
$string['welcometocourse'] = 'Bem-vindo à página da disciplina {$a}';
$string['welcometocoursetext'] = 'Bem-vindo à página da disciplina {$a->coursename}!

Uma das primeiras coisas que deveria fazer é editar a sua página de perfil dentro da disciplina, para que possamos conhecê-lo(a) melhor:

 {$a->profileurl}';
$string['whatforlink'] = 'O que pretende fazer com a hiperligação?';
$string['whatforpage'] = 'O que pretende fazer com o texto?';
$string['whattocallzip'] = 'Qual o nome para o ficheiro .zip?';
$string['whattodo'] = 'O que fazer';
$string['windowclosing'] = 'Esta janela deve fechar automaticamente, se não acontecer por favor feche-a.';
$string['withchosenfiles'] = 'Com os ficheiros escolhidos';
$string['withdisablednote'] = '{$a} (desativado)';
$string['withoutuserdata'] = 'sem dados de utilizador';
$string['withselectedusers'] = 'Com os utilizadores selecionados...';
$string['withselectedusers_help'] = '* Enviar mensagem - Para enviar uma mensagem a um ou mais participantes
* Adicionar nova nota - Para adicionar notas a participantes selecionados
* Adicionar nota comum - Para adicionar a mesma nota a vários participantes
* Alargar validade da inscrição - Para alargar o tempo de acesso de um aluno selecionado, mesmo quando se encontra um período de acesso definido
* Alargar prazos de inscrição de todos - Para alargar o prazo de acesso de mais que um participante pelo mesmo tempo';
$string['withuserdata'] = 'com dados de utilizador';
$string['wordforstudent'] = 'Aluno';
$string['wordforstudenteg'] = 'algo como Aluno, Participante, etc';
$string['wordforstudents'] = 'Alunos';
$string['wordforstudentseg'] = 'algo como Alunos, Participantes, etc';
$string['wordforteacher'] = 'Professor';
$string['wordforteachereg'] = 'algo como Professor, Tutor, Supervisor, etc';
$string['wordforteachers'] = 'Professores';
$string['wordforteacherseg'] = 'algo como Professores, Tutores, Supervisores, etc';
$string['writingblogsinfo'] = 'A escrever informação do blogue';
$string['writingcategoriesandquestions'] = 'A escrever categorias e questões';
$string['writingcoursedata'] = 'A escrever dados da disciplina';
$string['writingeventsinfo'] = 'A escrever informações de evento';
$string['writinggeneralinfo'] = 'A escrever dados gerais';
$string['writinggradebookinfo'] = 'A escrever informação da pauta';
$string['writinggroupingsgroupsinfo'] = 'A guardar informação de grupos do agrupamento';
$string['writinggroupingsinfo'] = 'A escrever informação de agrupamentos';
$string['writinggroupsinfo'] = 'A escrever informação de grupos';
$string['writingheader'] = 'A escrever o cabeçalho';
$string['writingloginfo'] = 'A escrever dados do registo';
$string['writingmessagesinfo'] = 'A escrever informação sobre mensagens';
$string['writingmoduleinfo'] = 'A escrever dados do módulo';
$string['writingscalesinfo'] = 'A escrever dados das escalas';
$string['writinguserinfo'] = 'A escrever dados dos utilizadores';
$string['wrongpassword'] = 'Senha errada para este utilizador';
$string['yahooid'] = 'ID do Yahoo';
$string['year'] = 'ano';
$string['years'] = 'anos';
$string['yes'] = 'Sim';
$string['youareabouttocreatezip'] = 'Está prestes a criar um ficheiro .zip contendo';
$string['youaregoingtorestorefrom'] = 'Irá restaurar de';
$string['youneedtoenrol'] = 'Para poder realizar essa ação, precisa inscrever-se nesta disciplina.';
$string['yourlastlogin'] = 'A sua última autenticação foi';
$string['yourself'] = 'si próprio';
$string['yourteacher'] = 'seu {$a}';
$string['yourwordforx'] = 'Designação para "{$a}"';
$string['zippingbackup'] = 'Empacotando (zip) a cópia de segurança';
