<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'pt', branch 'MOODLE_28_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Endereço';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Inserir/editar âncora';
$string['advanced:backcolor_desc'] = 'Selecionar a cor de fundo';
$string['advanced:block'] = 'Formatação';
$string['advanced:blockquote'] = 'Citação';
$string['advanced:blockquote_desc'] = 'Citação';
$string['advanced:bold_desc'] = 'Negrito (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Inserir/remover lista com marcas';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Inserir carater especial';
$string['advanced:cleanup_desc'] = 'Limpar código incorreto';
$string['advanced:clipboard_msg'] = 'Copiar/cortar/colar não está disponível no Mozilla e Firefox. Deseja obter mais informações sobre este assunto?';
$string['advanced:code'] = 'Código';
$string['advanced:code_desc'] = 'Editar código HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Copiar';
$string['advanced:custom1_desc'] = 'Insira aqui a sua descrição personalizada';
$string['advanced:cut_desc'] = 'Cortar';
$string['advanced:dd'] = 'Descrição da definição';
$string['advanced:div'] = 'DIV';
$string['advanced_dlg:'] = 'Configurações avançadas DLG';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'Sobre';
$string['advanced_dlg:about_help'] = 'Ajuda';
$string['advanced_dlg:about_license'] = 'Licença';
$string['advanced_dlg:about_loaded'] = 'Módulos Instalados';
$string['advanced_dlg:about_plugin'] = 'Módulo';
$string['advanced_dlg:about_plugins'] = 'Módulos';
$string['advanced_dlg:about_title'] = 'Sobre o TinyMCE';
$string['advanced_dlg:about_version'] = 'Versão';
$string['advanced_dlg:accessibility_help'] = 'Ajuda à acessibilidade';
$string['advanced_dlg:accessibility_usage_title'] = 'Utilização geral';
$string['advanced_dlg:anchor_invalid'] = 'Por favor especifique um nome de âncora válido.';
$string['advanced_dlg:anchor_name'] = 'Nome da âncora';
$string['advanced_dlg:anchor_title'] = 'Inserir/editar âncora';
$string['advanced_dlg:charmap_title'] = 'Selecionar carater especial';
$string['advanced_dlg:charmap_usage'] = 'Use as setas direita e esquerda para navegar';
$string['advanced_dlg:code_title'] = 'Editor HTML';
$string['advanced_dlg:code_wordwrap'] = 'Quebra automática de linha';
$string['advanced_dlg:colorpicker_color'] = 'Cor:';
$string['advanced_dlg:colorpicker_name'] = 'Nome:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Personalizadas';
$string['advanced_dlg:colorpicker_named_title'] = 'Cores Personalizadas';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paleta de Cores';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paleta de Cores';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Editor';
$string['advanced_dlg:colorpicker_picker_title'] = 'Editor de Cores';
$string['advanced_dlg:colorpicker_title'] = 'Selecione uma cor';
$string['advanced_dlg:image_align'] = 'Alinhamento';
$string['advanced_dlg:image_align_baseline'] = 'Sobre a linha de texto';
$string['advanced_dlg:image_align_bottom'] = 'Abaixo';
$string['advanced_dlg:image_align_left'] = 'Esquerda';
$string['advanced_dlg:image_align_middle'] = 'Meio';
$string['advanced_dlg:image_align_right'] = 'Direita';
$string['advanced_dlg:image_align_textbottom'] = 'Base do texto';
$string['advanced_dlg:image_align_texttop'] = 'Topo do texto';
$string['advanced_dlg:image_align_top'] = 'Topo';
$string['advanced_dlg:image_alt'] = 'Descrição da imagem';
$string['advanced_dlg:image_border'] = 'Limites';
$string['advanced_dlg:image_dimensions'] = 'Dimensões';
$string['advanced_dlg:image_hspace'] = 'Espaço Horizontal';
$string['advanced_dlg:image_list'] = 'Lista de imagens';
$string['advanced_dlg:image_src'] = 'Endereço da imagem';
$string['advanced_dlg:image_title'] = 'Inserir/editar imagem';
$string['advanced_dlg:image_vspace'] = 'Espaço Vertical';
$string['advanced_dlg:invalid_color_value'] = 'Valor de cor inválido';
$string['advanced_dlg:link_is_email'] = 'O URL inserido parece ser um endereço de e-mail. Deseja acrescentar o prefixo \'mailto:\' necessário?';
$string['advanced_dlg:link_is_external'] = 'O URL inserido parece ser uma hiperligação externa. Deseja acrescentar o prefixo \'http://\' necessário?';
$string['advanced_dlg:link_list'] = 'Lista de Links';
$string['advanced_dlg:link_target'] = 'Alvo';
$string['advanced_dlg:link_target_blank'] = 'Abrir hiperligação numa nova janela';
$string['advanced_dlg:link_target_same'] = 'Abrir hiperligação na mesma janela';
$string['advanced_dlg:link_title'] = 'Inserir/editar hiperligação';
$string['advanced_dlg:link_titlefield'] = 'Título';
$string['advanced_dlg:link_url'] = 'Hiperligação para URL';
$string['advanced:dt'] = 'Termo da definição';
$string['advanced:fontdefault'] = 'Tipo de fonte';
$string['advanced:font_size'] = 'Tamanho';
$string['advanced:forecolor_desc'] = 'Selecionar a cor do texto';
$string['advanced:h1'] = 'Título 1';
$string['advanced:h2'] = 'Título 2';
$string['advanced:h3'] = 'Título 3';
$string['advanced:h4'] = 'Título 4';
$string['advanced:h5'] = 'Título 5';
$string['advanced:h6'] = 'Título 6';
$string['advanced:help_desc'] = 'Ajuda';
$string['advanced:help_shortcut'] = 'Pressione ALT+F10 para mostrar a barra de ferramentas. Pressione ALT+0 para obter ajuda';
$string['advanced:hr_desc'] = 'Inserir linha horizontal';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Inserir/editar imagem';
$string['advanced:image_props_desc'] = 'Propriedades da imagem';
$string['advanced:indent_desc'] = 'Aumentar avanço';
$string['advanced:italic_desc'] = 'Itálico (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Centrar';
$string['advanced:justifyfull_desc'] = 'Justificar';
$string['advanced:justifyleft_desc'] = 'Alinhar à esquerda';
$string['advanced:justifyright_desc'] = 'Alinhar à direita';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Inserir/editar hiperligação';
$string['advanced:more_colors'] = 'Mais cores...';
$string['advanced:newdocument'] = 'Tem a certeza que deseja apagar tudo?';
$string['advanced:newdocument_desc'] = 'Novo documento';
$string['advanced:numlist_desc'] = 'Inserir/remover lista numerada';
$string['advanced:outdent_desc'] = 'Diminuir avanço';
$string['advanced:paragraph'] = 'Parágrafo';
$string['advanced:paste_desc'] = 'Colar';
$string['advanced:path'] = 'Caminho';
$string['advanced:pre'] = 'Pré-formatado';
$string['advanced:redo_desc'] = 'Refazer a ação anulada (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Remover formatação';
$string['advanced:rich_text_area'] = 'Área de texto em formato RTF';
$string['advanced:samp'] = 'Exemplo de código';
$string['advanced:shortcuts_desc'] = 'Ajuda à acessibilidade';
$string['advanced:striketrough_desc'] = 'Rasurado';
$string['advanced:style_select'] = 'Estilos';
$string['advanced:sub_desc'] = 'Inferior à linha';
$string['advanced:sup_desc'] = 'Superior à linha';
$string['advanced:toolbar'] = 'Barra de ferramentas';
$string['advanced:toolbar_focus'] = 'Atalho para as ferramentas: Alt+Q; Atalho  para o editor: Alt+Z; Atalho para o caminho do elemento: Alt+X.';
$string['advanced:underline_desc'] = 'Sublinhado (Ctrl+U)';
$string['advanced:undo_desc'] = 'Anular a ação anterior (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Remover hiperligação';
$string['advanced:visualaid_desc'] = 'Mostrar/ocultar guias/elementos invisíveis';
$string['advhr:advhr_desc'] = 'Inserir linha horizontal';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Sem sombra';
$string['advhr_dlg:size'] = 'Altura';
$string['advhr_dlg:width'] = 'Largura';
$string['advhr_dlg:widthunits'] = 'Unidades';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'Alinhamento';
$string['advimage_dlg:align_baseline'] = 'Sobre a linha de texto';
$string['advimage_dlg:align_bottom'] = 'Abaixo';
$string['advimage_dlg:align_left'] = 'Esquerda';
$string['advimage_dlg:align_middle'] = 'Meio';
$string['advimage_dlg:align_right'] = 'Direita';
$string['advimage_dlg:align_textbottom'] = 'Base do texto';
$string['advimage_dlg:align_texttop'] = 'Topo do texto';
$string['advimage_dlg:align_top'] = 'Topo';
$string['advimage_dlg:alt'] = 'Descrição da imagem';
$string['advimage_dlg:alt_image'] = 'Imagem alternativa';
$string['advimage_dlg:border'] = 'Limite';
$string['advimage_dlg:classes'] = 'Classes';
$string['advimage_dlg:constrain_proportions'] = 'Manter proporções';
$string['advimage_dlg:dialog_title'] = 'Inserir/editar imagem';
$string['advimage_dlg:dimensions'] = 'Dimensões';
$string['advimage_dlg:example_img'] = 'Pré-Visualização';
$string['advimage_dlg:general'] = 'Geral';
$string['advimage_dlg:height'] = 'Altura';
$string['advimage_dlg:hspace'] = 'Espaço horizontal';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Lista de imagens';
$string['advimage_dlg:langcode'] = 'Código do idioma';
$string['advimage_dlg:langdir'] = 'Direção do texto';
$string['advimage_dlg:list'] = 'Lista de imagens';
$string['advimage_dlg:long_desc'] = 'Descrição extensa';
$string['advimage_dlg:ltr'] = 'Da esquerda para a direita';
$string['advimage_dlg:map'] = 'Mapa da imagem';
$string['advimage_dlg:misc'] = 'Misto';
$string['advimage_dlg:missing_alt'] = 'Tem a certeza que pretende continuar sem incluir uma descrição à imagem? Isto pode gerar problemas de acessibilidade em alguns navegadores.';
$string['advimage_dlg:mouseout'] = 'rato sai de cima';
$string['advimage_dlg:mouseover'] = 'rato em cima';
$string['advimage_dlg:preview'] = 'Pré-Visualização';
$string['advimage_dlg:rtl'] = 'Da direita para a esquerda';
$string['advimage_dlg:src'] = 'Endereço da imagem';
$string['advimage_dlg:style'] = 'Estilo';
$string['advimage_dlg:swap_image'] = 'Trocar imagem';
$string['advimage_dlg:tab_advanced'] = 'Avançado';
$string['advimage_dlg:tab_appearance'] = 'Aparência';
$string['advimage_dlg:tab_general'] = 'Geral';
$string['advimage_dlg:title'] = 'Título';
$string['advimage_dlg:vspace'] = 'Espaço vertical';
$string['advimage_dlg:width'] = 'Largura';
$string['advimage:image_desc'] = 'Inserir/editar imagem';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Tecla de acesso';
$string['advlink_dlg:advanced_props'] = 'Propriedades avançadas';
$string['advlink_dlg:advanced_tab'] = 'Avançado';
$string['advlink_dlg:anchor_names'] = 'Âncoras';
$string['advlink_dlg:classes'] = 'Classes';
$string['advlink_dlg:encoding'] = 'Codificação de caracteres';
$string['advlink_dlg:event_props'] = 'Eventos';
$string['advlink_dlg:events_tab'] = 'Eventos';
$string['advlink_dlg:general_props'] = 'Propriedades gerais';
$string['advlink_dlg:general_tab'] = 'Geral';
$string['advlink_dlg:height'] = 'Altura';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'O URL inserido parece ser um endereço de e-mail. Deseja acrescentar o prefixo \'mailto:\' necessário?';
$string['advlink_dlg:is_external'] = 'O URL inserido parece ser uma hiperligação externa. Deseja acrescentar o prefixo \'http://\' necessário?';
$string['advlink_dlg:langcode'] = 'Código do idioma';
$string['advlink_dlg:langdir'] = 'Direção do texto';
$string['advlink_dlg:link_list'] = 'Lista de hiperligações';
$string['advlink_dlg:list'] = 'Lista de hiperligações';
$string['advlink_dlg:ltr'] = 'Da esquerda para a direita';
$string['advlink_dlg:mime'] = 'Alvo tipo MIME';
$string['advlink_dlg:popup'] = 'Popup JavaScript';
$string['advlink_dlg:popup_dependent'] = 'Dependente (Mozilla/Firefox apenas)';
$string['advlink_dlg:popup_location'] = 'Mostrar a barra de endereços';
$string['advlink_dlg:popup_menubar'] = 'Mostrar a barra de menu';
$string['advlink_dlg:popup_name'] = 'Nome da janela';
$string['advlink_dlg:popup_opts'] = 'Opções';
$string['advlink_dlg:popup_position'] = 'Posição (X/Y)';
$string['advlink_dlg:popup_props'] = 'Propriedades de pop-up';
$string['advlink_dlg:popup_resizable'] = 'Permitir alteração do tamanho da janela';
$string['advlink_dlg:popup_return'] = 'Inserir "return false"';
$string['advlink_dlg:popup_scrollbars'] = 'Mostrar as barras de scroll';
$string['advlink_dlg:popup_size'] = 'Tamanho';
$string['advlink_dlg:popup_statusbar'] = 'Mostrar a barra de estado';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Mostrar a barra de ferramentas';
$string['advlink_dlg:popup_url'] = 'URL do pop-up';
$string['advlink_dlg:rel'] = 'Relação página/alvo';
$string['advlink_dlg:rev'] = 'Relação alvo/página';
$string['advlink_dlg:rtl'] = 'Da direita para a esquerda';
$string['advlink_dlg:style'] = 'Estilo';
$string['advlink_dlg:tabindex'] = 'Tabindex';
$string['advlink_dlg:target'] = 'Alvo';
$string['advlink_dlg:target_blank'] = 'Abrir numa nova janela';
$string['advlink_dlg:target_langcode'] = 'Idioma alvo';
$string['advlink_dlg:target_name'] = 'Nome do alvo';
$string['advlink_dlg:target_parent'] = 'Abrir na janela/frame ascendente';
$string['advlink_dlg:target_same'] = 'Abrir nesta janela/frame';
$string['advlink_dlg:target_top'] = 'Abrir numa página inteira (substitui todos os quadros)';
$string['advlink_dlg:title'] = 'Inserir/editar hiperligação';
$string['advlink_dlg:titlefield'] = 'Título';
$string['advlink_dlg:url'] = 'URL da hiperligação';
$string['advlink_dlg:width'] = 'Largura';
$string['advlink:link_desc'] = 'Inserir/editar hiperligação';
$string['advlist:circle'] = 'Círculo';
$string['advlist:def'] = 'Predefinido';
$string['advlist:disc'] = 'Disco';
$string['advlist:lower_alpha'] = 'Lower alpha';
$string['advlist:lower_greek'] = 'Lower greek';
$string['advlist:lower_roman'] = 'Lower roman';
$string['advlist:square'] = 'Quadrado';
$string['advlist:types'] = 'Tipos';
$string['advlist:upper_alpha'] = 'Upper alpha';
$string['advlist:upper_roman'] = 'Upper roman';
$string['aria:rich_text_area'] = 'Área de texto em formato RTF';
$string['autosave:restore_content'] = 'Restaurar conteúdo guardado automaticamente';
$string['autosave:unload_msg'] = 'As mudanças efetuadas serão perdidas se sair desta página.';
$string['autosave:warning_message'] = 'Se restaurar o conteúdo guardado, irá perder todo o conteúdo que se encontra atualmente no editor.

Tem a certeza que pretende restaurar o conteúdo guardado?';
$string['availablebuttons'] = 'Botões disponíveis';
$string['colors:000000'] = 'Preto';
$string['colors:000080'] = 'Azul-marinho';
$string['colors:0000FF'] = 'Azul';
$string['colors:003300'] = 'Verde-escuro';
$string['colors:003366'] = 'Azul-escuro';
$string['colors:008000'] = 'Verde';
$string['colors:008080'] = 'Verde-azulado';
$string['colors:00CCFF'] = 'Azul-céu';
$string['colors:00FF00'] = 'Lima';
$string['colors:00FFFF'] = 'Verde-água';
$string['colors:333300'] = 'Verde-azeitona escuro';
$string['colors:333333'] = 'Cinzento muito escuro';
$string['colors:333399'] = 'Índigo (Anil)';
$string['colors:3366FF'] = 'Azul real';
$string['colors:339966'] = 'Verde-mar';
$string['colors:33CCCC'] = 'Turquesa';
$string['colors:666699'] = 'Azul acinzentado';
$string['colors:800000'] = 'Castanho-avermelhado';
$string['colors:800080'] = 'Roxo';
$string['colors:808000'] = 'Verde-azeitona';
$string['colors:808080'] = 'Cinzento';
$string['colors:993300'] = 'Tijolo';
$string['colors:993366'] = 'Castanho';
$string['colors:999999'] = 'Cinzento médio';
$string['colors:99CC00'] = 'Amarelo-esverdeado';
$string['colors:99CCFF'] = 'Azul-céu claro';
$string['colors:C0C0C0'] = 'Prateado';
$string['colors:CC99FF'] = 'Ameixa';
$string['colors:CCFFCC'] = 'Verde-pálido';
$string['colors:CCFFFF'] = 'Ciano-pálido';
$string['colors:FF0000'] = 'Vermelho';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Laranja';
$string['colors:FF9900'] = 'Castanho-amarelado';
$string['colors:FF99CC'] = 'Rosa';
$string['colors:FFCC00'] = 'Dourado';
$string['colors:FFCC99'] = 'Pêssego';
$string['colors:FFFF00'] = 'Amarelo';
$string['colors:FFFF99'] = 'Amarelo-claro';
$string['colors:FFFFFF'] = 'Branco';
$string['common:apply'] = 'Aplicar';
$string['common:browse'] = 'Procurar';
$string['common:cancel'] = 'Cancelar';
$string['common:class_name'] = 'Classe';
$string['common:clipboard_msg'] = 'Copiar/cortar/colar não está disponível no Mozilla e Firefox. Pretende obter mais informações sobre este assunto?';
$string['common:clipboard_no_support'] = 'O seu navegador não suporta esta função, use os atalhos de teclado.';
$string['common:close'] = 'Fechar';
$string['common:edit_confirm'] = 'Deseja usar o modo de edição avançado neste campo de texto?';
$string['common:insert'] = 'Inserir';
$string['common:invalid_data'] = 'Erro: Inseridos valores inválidos que estão marcados a vermelho.';
$string['common:invalid_data_min'] = '{#field} tem de ser um número maior do que {#min}';
$string['common:invalid_data_number'] = '{#field} tem de ser um número';
$string['common:invalid_data_size'] = '{#field} tem de ser um número ou percentagem';
$string['common:more_colors'] = 'Mais cores...';
$string['common:not_set'] = '-- Não especificado --';
$string['common:popup_blocked'] = 'Detetamos que o bloqueador de pop-ups impediu uma janela que é essencial para a aplicação. Precisa desativar o bloqueador de janelas de pop-up para utilizar esta ferramenta.';
$string['common:update'] = 'Atualizar';
$string['common:value'] = '(valor)';
$string['contextmenu:align'] = 'Alinhamento';
$string['contextmenu:center'] = 'Centro';
$string['contextmenu:full'] = 'Justificado';
$string['contextmenu:left'] = 'Esquerda';
$string['contextmenu:right'] = 'Direita';
$string['customconfig'] = 'Configuração personalizada';
$string['customconfig_desc'] = 'Configuração personalizada avançada do TinyMCE no formato JSON, por exemplo: {"option1" : "value2", "option2" : "value2"}. Quaisquer opções especificadas aqui substituirão as definições padrão e as dos módulos.';
$string['customtoolbar'] = 'Barra de ferramentas do Editor';
$string['customtoolbar_desc'] = 'Cada linha contém uma lista de nomes de botões separados por vírgulas, use "|" como separador de grupo, as linhas vazias serão ignoradas. Ver aqui a lista de botões predefinidos do TinyMCE <a href="{$a}" target="_blank">{$a}</a> .';
$string['directionality:ltr_desc'] = 'Da esquerda para direita';
$string['directionality:rtl_desc'] = 'Da direita para esquerda';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'Fixe';
$string['emotions_dlg:cry'] = 'Chorão';
$string['emotions_dlg:desc'] = 'Emoticons';
$string['emotions_dlg:embarassed'] = 'Embaraçado';
$string['emotions_dlg:foot_in_mouth'] = 'Disse asneira';
$string['emotions_dlg:frown'] = 'Decepção';
$string['emotions_dlg:innocent'] = 'Inocente';
$string['emotions_dlg:kiss'] = 'Beijo';
$string['emotions_dlg:laughing'] = 'Riso';
$string['emotions_dlg:money_mouth'] = 'Avarez';
$string['emotions_dlg:sealed'] = 'Boca Fechada';
$string['emotions_dlg:smile'] = 'Sorriso';
$string['emotions_dlg:surprised'] = 'Surpresa';
$string['emotions_dlg:title'] = 'Inserir emoticon';
$string['emotions_dlg:tongue_out'] = 'Língua de fora';
$string['emotions_dlg:undecided'] = 'Indeciso';
$string['emotions_dlg:usage'] = 'Use as setas para a direita e para a esquerda para navegar.';
$string['emotions_dlg:wink'] = 'Piscadela';
$string['emotions_dlg:yell'] = 'Irado';
$string['emotions:emotions_desc'] = 'Emoticons';
$string['fontselectlist'] = 'Lista de tipos de fonte disponíveis';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Propriedades do documento';
$string['fullpage_dlg:active_color'] = 'Cor ativa';
$string['fullpage_dlg:add'] = 'Acrescentar novo elemento';
$string['fullpage_dlg:add_base'] = 'BASE';
$string['fullpage_dlg:add_comment'] = 'Comentário';
$string['fullpage_dlg:add_link'] = 'LINK';
$string['fullpage_dlg:add_meta'] = 'META';
$string['fullpage_dlg:add_script'] = 'SCRIPT';
$string['fullpage_dlg:add_style'] = 'STYLE';
$string['fullpage_dlg:add_title'] = 'TITLE';
$string['fullpage_dlg:advanced_props'] = 'Avançado';
$string['fullpage_dlg:advanced_tab'] = 'Avançado';
$string['fullpage_dlg:appearance_bgprops'] = 'Propriedades do plano de fundo';
$string['fullpage_dlg:appearance_linkprops'] = 'Cores das hiperligações';
$string['fullpage_dlg:appearance_marginprops'] = 'Margens (BODY)';
$string['fullpage_dlg:appearance_style'] = 'Propriedades das folhas de estilo';
$string['fullpage_dlg:appearance_tab'] = 'Aparência';
$string['fullpage_dlg:appearance_textprops'] = 'Propriedades do texto';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'BASE';
$string['fullpage_dlg:bgcolor'] = 'Cor de fundo';
$string['fullpage_dlg:bgimage'] = 'Imagem de fundo';
$string['fullpage_dlg:bottom_margin'] = 'Margem inferior';
$string['fullpage_dlg:charset'] = 'Codificação';
$string['fullpage_dlg:comment_element'] = 'Comentário';
$string['fullpage_dlg:content'] = 'Conteúdo';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Adiar';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Codificação de caracteres';
$string['fullpage_dlg:fontface'] = 'Fonte';
$string['fullpage_dlg:font_face'] = 'Fonte';
$string['fullpage_dlg:fontsize'] = 'Tamanho fonte';
$string['fullpage_dlg:font_size'] = 'Tamanho fonte';
$string['fullpage_dlg:general_props'] = 'Geral';
$string['fullpage_dlg:head_elements'] = 'Elementos HEAD';
$string['fullpage_dlg:hover_color'] = 'Hover';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Informação';
$string['fullpage_dlg:langcode'] = 'Código do idioma';
$string['fullpage_dlg:langdir'] = 'Direção do texto';
$string['fullpage_dlg:langprops'] = 'Idioma e codificação';
$string['fullpage_dlg:language'] = 'Idioma';
$string['fullpage_dlg:left_margin'] = 'Margem esquerda';
$string['fullpage_dlg:link_color'] = 'Cor das hiperligações';
$string['fullpage_dlg:link_element'] = 'LINK';
$string['fullpage_dlg:ltr'] = 'Esquerda para direita';
$string['fullpage_dlg:media'] = 'Conteúdo multimédia';
$string['fullpage_dlg:meta_description'] = 'Descrição';
$string['fullpage_dlg:meta_element'] = 'META';
$string['fullpage_dlg:meta_index_follow'] = 'Indexar e seguir as hiperligações';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexar e não seguir as hiperligações';
$string['fullpage_dlg:meta_keywords'] = 'Palavras-chave';
$string['fullpage_dlg:meta_noindex_follow'] = 'Seguir hiperligações, mas não indexar';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Não indexar e não seguir hiperligações';
$string['fullpage_dlg:meta_props'] = 'Meta-informação';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'Geral';
$string['fullpage_dlg:meta_title'] = 'Título';
$string['fullpage_dlg:movedown'] = 'Descer elemento selecionado';
$string['fullpage_dlg:moveup'] = 'Subir elemento selecionado';
$string['fullpage_dlg:name'] = 'Nome';
$string['fullpage_dlg:properties'] = 'Propriedades';
$string['fullpage_dlg:rel'] = 'rel';
$string['fullpage_dlg:remove'] = 'Remover elemento selecionado';
$string['fullpage_dlg:rev'] = 'rev';
$string['fullpage_dlg:right_margin'] = 'Margem direita';
$string['fullpage_dlg:rtl'] = 'Direita para esquerda';
$string['fullpage_dlg:script_element'] = 'SCRIPT';
$string['fullpage_dlg:src'] = 'Fonte';
$string['fullpage_dlg:style'] = 'Estilo';
$string['fullpage_dlg:style_element'] = 'STYLE';
$string['fullpage_dlg:stylesheet'] = 'Folha de estilo';
$string['fullpage_dlg:target'] = 'Alvo';
$string['fullpage_dlg:textcolor'] = 'Cor';
$string['fullpage_dlg:text_color'] = 'Cor do texto';
$string['fullpage_dlg:title'] = 'Propriedades do documento';
$string['fullpage_dlg:title_element'] = 'TITLE';
$string['fullpage_dlg:top_margin'] = 'Margem superior';
$string['fullpage_dlg:type'] = 'Tipo';
$string['fullpage_dlg:value'] = 'Valor';
$string['fullpage_dlg:visited_color'] = 'Cor de visitado';
$string['fullpage_dlg:xml_pi'] = 'Declaração XML';
$string['fullscreen:desc'] = 'Alternar entre modo de ecrã inteiro';
$string['iespell:download'] = 'Módulo de ortografia não-detetado. Deseja instalar agora?';
$string['iespell:iespell_desc'] = 'Verificar ortografia';
$string['insertdatetime:date_fmt'] = '%%d-%%m-%%Y';
$string['insertdatetime:day_long'] = 'Domingo,Segunda-feira,Terça-feira,Quarta-feira,Quinta-feira,Sexta-feira,Sábado,Domingo';
$string['insertdatetime:day_short'] = 'Dom,Seg,Ter,Qua,Qui,Sex,Sab,Dom';
$string['insertdatetime:insertdate_desc'] = 'Inserir data';
$string['insertdatetime:inserttime_desc'] = 'Inserir hora';
$string['insertdatetime:months_long'] = 'Janeiro,Fevereiro,Março,Abril,Maio,Junho,Julho,Agosto,Setembro,Outubro,Novembro,Dezembro';
$string['insertdatetime:months_short'] = 'Jan,Fev,Mar,Abr,Mai,Jun,Jul,Ago,Set,Out,Nov,Dez';
$string['insertdatetime:time_fmt'] = '%%H:%%M:%%S';
$string['layer:absolute_desc'] = 'Alternar o posicionamento absoluto';
$string['layer:backward_desc'] = 'Mover para trás';
$string['layer:content'] = 'Nova camada...';
$string['layer:forward_desc'] = 'Mover para a frente';
$string['layer:insertlayer_desc'] = 'Inserir nova camada';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Inserir/Editar conteúdo multimédia incorporado';
$string['media_dlg:advanced'] = 'Avançado';
$string['media_dlg:align'] = 'Alinhamento';
$string['media_dlg:align_bottom'] = 'Abaixo';
$string['media_dlg:align_bottom_left'] = 'Abaixo esquerda';
$string['media_dlg:align_bottom_right'] = 'Abaixo direita';
$string['media_dlg:align_center'] = 'Centro';
$string['media_dlg:align_left'] = 'Esquerda';
$string['media_dlg:align_right'] = 'Direita';
$string['media_dlg:align_top'] = 'Topo';
$string['media_dlg:align_top_left'] = 'Topo esquerda';
$string['media_dlg:align_top_right'] = 'Topo direita';
$string['media_dlg:altsource1'] = 'Fonte alternativa 1';
$string['media_dlg:altsource2'] = 'Fonte alternativa 2';
$string['media_dlg:audio'] = 'Áudio HTML5';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Execução automática';
$string['media_dlg:balance'] = 'Stereo';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'URL Base';
$string['media_dlg:bgcolor'] = 'Fundo';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'ID de legenda';
$string['media_dlg:center'] = 'Centro';
$string['media_dlg:class_name'] = 'Classe';
$string['media_dlg:console'] = 'Consola';
$string['media_dlg:constrain_proportions'] = 'Manter proporções';
$string['media_dlg:controller'] = 'Controlador';
$string['media_dlg:controls'] = 'Controlos';
$string['media_dlg:correction'] = 'Sem correções';
$string['media_dlg:currentmarker'] = 'Marcador atual';
$string['media_dlg:currentposition'] = 'Posição atual';
$string['media_dlg:defaultframe'] = 'Frame predefinido';
$string['media_dlg:embeddedaudio'] = 'Áudio incorporado';
$string['media_dlg:embedded_audio_options'] = 'Opções de áudio incorporado';
$string['media_dlg:enabled'] = 'Ativado';
$string['media_dlg:enablejavascript'] = 'Disponibilizar JavaScript';
$string['media_dlg:endtime'] = 'Hora de fim';
$string['media_dlg:file'] = 'Ficheiro/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Opções Flash';
$string['media_dlg:flashvars'] = 'Variáveis Flash';
$string['media_dlg:fullscreen'] = 'Ecrã inteiro';
$string['media_dlg:general'] = 'Geral';
$string['media_dlg:hidden'] = 'Oculto';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Espaço horizontal';
$string['media_dlg:html5_audio_options'] = 'Opções de áudio';
$string['media_dlg:html5_video_options'] = 'Opções de vídeo HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Status da imagem';
$string['media_dlg:invokeurls'] = 'Invocar URLs';
$string['media_dlg:kioskmode'] = 'Modo Quiosque';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Repetição automática';
$string['media_dlg:maintainaspect'] = 'Manter aspeto';
$string['media_dlg:menu'] = 'Mostrar menu';
$string['media_dlg:mute'] = 'Mudo';
$string['media_dlg:name'] = 'Nome';
$string['media_dlg:nojava'] = 'Sem Java';
$string['media_dlg:numloop'] = 'Número de repetições';
$string['media_dlg:play'] = 'Execução automática';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Executar todas as frames';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = 'Pré-carregar';
$string['media_dlg:preload_auto'] = 'Permitir que seja o navegador do utilizador a decidir';
$string['media_dlg:preload_metadata'] = 'Pré-visualizar metadados de vídeo';
$string['media_dlg:preload_none'] = 'Não pré-carregar';
$string['media_dlg:preview'] = 'Pré-visualização';
$string['media_dlg:progress'] = 'Progresso';
$string['media_dlg:qt_options'] = 'Opções do Quicktime';
$string['media_dlg:qtsrc'] = 'Fonte Quicktime';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:qt_stream_warn'] = 'Fluxos de recursos RTSP devem ser acrescentados ao campo QT Src abaixo do Modo Avançado. Deve também ser acrescentada uma versão sem fluxo  ao campo Src.';
$string['media_dlg:quality'] = 'Qualidade';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Opções do Real Media Player';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Escala';
$string['media_dlg:scriptcallbacks'] = 'callbacks de script';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Opções Shockwave';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'Dimensões';
$string['media_dlg:sound'] = 'Som';
$string['media_dlg:source'] = 'Origem';
$string['media_dlg:starttime'] = 'Hora de início';
$string['media_dlg:stretchtofit'] = 'Esticar';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Stretch Style';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Alvo';
$string['media_dlg:targetcache'] = 'Cache alvo';
$string['media_dlg:title'] = 'Inserir/editar conteúdo multimédia incorporado';
$string['media_dlg:type'] = 'Tipo';
$string['media_dlg:uimode'] = 'Modo UI';
$string['media_dlg:video'] = 'Vídeo HTML5';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = 'Espaço vertical';
$string['media_dlg:windowlessvideo'] = 'Vídeo sem janela';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Opções do Windows Media Player';
$string['media:edit'] = 'Editar conteúdo multimédia incorporado';
$string['nonbreaking:nonbreaking_desc'] = 'Inserir um espaço inquebrável';
$string['pagebreak:desc'] = 'Inserir quebra de página para impressão';
$string['paste_dlg:text_linebreaks'] = 'Manter quebras de linha';
$string['paste_dlg:text_title'] = 'Use as teclas CTRL+V para colar o texto na janela.';
$string['paste_dlg:word_title'] = 'Use as teclas CTRL+V para colar o texto na janela.';
$string['paste:paste_text_desc'] = 'Colar como Texto simples';
$string['paste:paste_word_desc'] = 'Colar (copiado do WORD)';
$string['paste:plaintext_mode'] = 'A opção Colar está agora em modo de texto simples. Clique novamente para alternar para o modo colar normal. Após colar algo voltará para o modo de colar normal.';
$string['paste:plaintext_mode_stick'] = 'A opção Colar está agora em modo de texto simples. Clique novamente para alternar para o modo colar normal.';
$string['paste:selectall_desc'] = 'Selecionar tudo';
$string['pluginname'] = 'Editor HTML TinyMCE';
$string['preview:preview_desc'] = 'Pré-visualizar';
$string['print:print_desc'] = 'Imprimir';
$string['save:cancel_desc'] = 'Cancelar todas as alterações';
$string['save:save_desc'] = 'Guardar';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'Foram efetuadas todas as substituições.';
$string['searchreplace_dlg:direction'] = 'Direção';
$string['searchreplace_dlg:down'] = 'Abaixo';
$string['searchreplace_dlg:findnext'] = 'Localizar próximo';
$string['searchreplace_dlg:findwhat'] = 'Localizar';
$string['searchreplace_dlg:mcase'] = 'Diferenciar maiúsculas';
$string['searchreplace_dlg:notfound'] = 'A pesquisa foi concluída sem resultados.';
$string['searchreplace_dlg:replace'] = 'Substituir';
$string['searchreplace_dlg:replaceall'] = 'Substituir todos';
$string['searchreplace_dlg:replace_title'] = 'Localizar/substituir';
$string['searchreplace_dlg:replacewith'] = 'Substituir com';
$string['searchreplace_dlg:searchnext_desc'] = 'Localizar novamente';
$string['searchreplace_dlg:search_title'] = 'Localizar';
$string['searchreplace_dlg:up'] = 'Acima';
$string['searchreplace:replace_desc'] = 'Localizar/substituir';
$string['searchreplace:search_desc'] = 'Localizar';
$string['settings'] = 'Configurações gerais';
$string['simple:bold_desc'] = 'Negrito (Ctrl+B)';
$string['simple:bullist_desc'] = 'Inserir/remover lista com marcas';
$string['simple:cleanup_desc'] = 'Limpar código incorreto';
$string['simple:italic_desc'] = 'Itálico (Ctrl+I)';
$string['simple:numlist_desc'] = 'Inserir/remover lista com numerações';
$string['simple:redo_desc'] = 'Refazer a ação anulada (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Rasurado';
$string['simple:underline_desc'] = 'Sublinhado (Ctrl+U)';
$string['simple:undo_desc'] = 'Anular a ação anterior (Ctrl+Z)';
$string['spellchecker:desc'] = 'Alternar corretor ortográfico';
$string['spellchecker:ignore_word'] = 'Ignorar palavra';
$string['spellchecker:ignore_words'] = 'Ignorar tudo';
$string['spellchecker:langs'] = 'Idiomas';
$string['spellchecker:learn_word'] = 'Adicionar palavra';
$string['spellchecker:menu'] = 'Configurações do corretor ortográfico';
$string['spellchecker:no_mpell'] = 'Não foram detetados erros de ortografia.';
$string['spellchecker:no_sug'] = 'Sem sugestões';
$string['spellchecker:sug'] = 'Sugestões';
$string['spellchecker:wait'] = 'Aguarde...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Editar estilo CSS';
$string['style_dlg:apply'] = 'Aplicar';
$string['style_dlg:background'] = 'Fundo';
$string['style_dlg:background_attachment'] = 'Fixar';
$string['style_dlg:background_color'] = 'Cor de fundo';
$string['style_dlg:background_hpos'] = 'Posição horizontal';
$string['style_dlg:background_image'] = 'Imagem de fundo';
$string['style_dlg:background_repeat'] = 'Repetir';
$string['style_dlg:background_tab'] = 'Fundo';
$string['style_dlg:background_vpos'] = 'Posição vertical';
$string['style_dlg:block'] = 'Bloco';
$string['style_dlg:block_display'] = 'Mostrar';
$string['style_dlg:block_letterspacing'] = 'Espaçamento entre caracteres';
$string['style_dlg:block_tab'] = 'Bloco';
$string['style_dlg:block_text_align'] = 'Alinhamento do texto';
$string['style_dlg:block_text_indent'] = 'Avanço do texto';
$string['style_dlg:block_vertical_alignment'] = 'Alinhamento vertical';
$string['style_dlg:block_whitespace'] = 'Espaço';
$string['style_dlg:block_wordspacing'] = 'Espaçamento entre palavras';
$string['style_dlg:border'] = 'Limites';
$string['style_dlg:border_tab'] = 'Limites';
$string['style_dlg:bottom'] = 'Abaixo';
$string['style_dlg:box'] = 'Caixa';
$string['style_dlg:box_clear'] = 'Limpo';
$string['style_dlg:box_float'] = 'Float';
$string['style_dlg:box_height'] = 'Altura';
$string['style_dlg:box_tab'] = 'Caixa';
$string['style_dlg:box_width'] = 'Largura';
$string['style_dlg:bullet_image'] = 'Imagem de lista';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Cor';
$string['style_dlg:height'] = 'Altura';
$string['style_dlg:left'] = 'Esquerda';
$string['style_dlg:list'] = 'Lista';
$string['style_dlg:list_tab'] = 'Lista';
$string['style_dlg:list_type'] = 'Tipo';
$string['style_dlg:margin'] = 'Margem';
$string['style_dlg:overflow'] = 'Overflow';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'Posicionamento';
$string['style_dlg:position'] = 'Posição';
$string['style_dlg:positioning_tab'] = 'Posicionamento';
$string['style_dlg:positioning_type'] = 'Tipo';
$string['style_dlg:right'] = 'Direita';
$string['style_dlg:same'] = 'O mesmo para todos';
$string['style_dlg:style'] = 'Estilo';
$string['style_dlg:text'] = 'Texto';
$string['style_dlg:text_blink'] = 'Piscar';
$string['style_dlg:text_case'] = 'Maiúscula';
$string['style_dlg:text_color'] = 'Cor';
$string['style_dlg:text_decoration'] = 'Decoração';
$string['style_dlg:text_font'] = 'Fonte';
$string['style_dlg:text_lineheight'] = 'Altura da linha';
$string['style_dlg:text_none'] = 'Nenhum';
$string['style_dlg:text_overline'] = 'Linha por cima';
$string['style_dlg:text_props'] = 'Texto';
$string['style_dlg:text_size'] = 'Tamanho';
$string['style_dlg:text_striketrough'] = 'Rasurado';
$string['style_dlg:text_style'] = 'Estilo';
$string['style_dlg:text_tab'] = 'Texto';
$string['style_dlg:text_underline'] = 'Sublinhado';
$string['style_dlg:text_variant'] = 'Variante';
$string['style_dlg:text_weight'] = 'Editar CSS';
$string['style_dlg:title'] = 'Editar estilo CSS';
$string['style_dlg:toggle_insert_span'] = 'Inserir um espaço inquebrável';
$string['style_dlg:top'] = 'Topo';
$string['style_dlg:visibility'] = 'Visibilidade';
$string['style_dlg:width'] = 'Largura';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'Módulo';
$string['subplugintype_tinymce_plural'] = 'Módulos';
$string['table:cell'] = 'Célula';
$string['table:cell_desc'] = 'Propriedades das células';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Coluna';
$string['table:col_after_desc'] = 'Inserir coluna depois';
$string['table:col_before_desc'] = 'Inserir coluna antes';
$string['table:copy_row_desc'] = 'Copiar linha';
$string['table:cut_row_desc'] = 'Cortar linha';
$string['table:del'] = 'Apagar Tabela';
$string['table:delete_col_desc'] = 'Apagar coluna';
$string['table:delete_row_desc'] = 'Apagar linha';
$string['table:desc'] = 'Inserir/editar tabela';
$string['table_dlg:advanced_props'] = 'Propriedades avançadas';
$string['table_dlg:advanced_tab'] = 'Avançado';
$string['table_dlg:align'] = 'Alinhamento';
$string['table_dlg:align_bottom'] = 'Abaixo';
$string['table_dlg:align_default'] = 'Predefinido';
$string['table_dlg:align_left'] = 'Esquerda';
$string['table_dlg:align_middle'] = 'Centro';
$string['table_dlg:align_right'] = 'Direita';
$string['table_dlg:align_top'] = 'Topo';
$string['table_dlg:bgcolor'] = 'Cor de fundo';
$string['table_dlg:bgimage'] = 'Imagem de fundo';
$string['table_dlg:border'] = 'Limites';
$string['table_dlg:bordercolor'] = 'Cor dos limites';
$string['table_dlg:caption'] = 'Título da tabela';
$string['table_dlg:cell_all'] = 'Atualizar todas as células na tabela';
$string['table_dlg:cell_cell'] = 'Atualizar esta célula';
$string['table_dlg:cell_col'] = 'Atualizar todas as células da coluna';
$string['table_dlg:cell_limit'] = 'Excedeu o número máximo de células de {$cells}.';
$string['table_dlg:cellpadding'] = 'Margens da célula';
$string['table_dlg:cell_row'] = 'Atualizar todas as células na linha';
$string['table_dlg:cellspacing'] = 'Espaçamento entre células';
$string['table_dlg:cell_title'] = 'Propriedades da célula';
$string['table_dlg:cell_type'] = 'Tipo de célula';
$string['table_dlg:colgroup'] = 'Grupo da coluna';
$string['table_dlg:col_limit'] = 'Excedeu o número máximo de colunas de {$cols}.';
$string['table_dlg:cols'] = 'Colunas';
$string['table_dlg:frame'] = 'Frame';
$string['table_dlg:frame_all'] = 'Todos';
$string['table_dlg:frame_cols'] = 'colunas';
$string['table_dlg:frame_groups'] = 'Grupos';
$string['table_dlg:frame_none'] = 'Nenhum';
$string['table_dlg:frame_rows'] = 'Linhas';
$string['table_dlg:general_props'] = 'Propriedades gerais';
$string['table_dlg:general_tab'] = 'Geral';
$string['table_dlg:height'] = 'Altura';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Código do Idioma';
$string['table_dlg:langdir'] = 'Direção do texto';
$string['table_dlg:ltr'] = 'Da esquerda para a direita';
$string['table_dlg:merge_cells_title'] = 'Unir células';
$string['table_dlg:mime'] = 'MIME alvo';
$string['table_dlg:missing_scope'] = 'Tem certeza de que quer continuar sem especificar um contexto para esta célula? (Isso poderá causar dificuldades a utilizadores portadores de deficiência).';
$string['table_dlg:row_all'] = 'Atualizar todas as linhas';
$string['table_dlg:row_even'] = 'Atualizar linhas pares';
$string['table_dlg:rowgroup'] = 'Grupo da linha';
$string['table_dlg:row_limit'] = 'Excedeu o número máximo de linhas de {$rows}.';
$string['table_dlg:row_odd'] = 'Atualizar linhas ímpares';
$string['table_dlg:row_row'] = 'Atualizar esta linha';
$string['table_dlg:rows'] = 'Linhas';
$string['table_dlg:row_title'] = 'Propriedades de linhas';
$string['table_dlg:rowtype'] = 'Tipo de linha';
$string['table_dlg:rtl'] = 'Da direita para a esquerda';
$string['table_dlg:rules'] = 'Regras';
$string['table_dlg:rules_above'] = 'acima';
$string['table_dlg:rules_below'] = 'abaixo';
$string['table_dlg:rules_border'] = 'Limites';
$string['table_dlg:rules_box'] = 'Caixa';
$string['table_dlg:rules_hsides'] = 'Hsides';
$string['table_dlg:rules_lhs'] = 'Lhs';
$string['table_dlg:rules_rhs'] = 'Rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'Vsides';
$string['table_dlg:scope'] = 'Contexto';
$string['table_dlg:style'] = 'Estilo';
$string['table_dlg:summary'] = 'Sumário';
$string['table_dlg:tbody'] = 'Corpo';
$string['table_dlg:td'] = 'Dados';
$string['table_dlg:tfoot'] = 'Rodapé';
$string['table_dlg:th'] = 'Campo';
$string['table_dlg:thead'] = 'Cabeçalho';
$string['table_dlg:title'] = 'Inserir/modificar tabela';
$string['table_dlg:valign'] = 'Alinhamento vertical';
$string['table_dlg:width'] = 'Largura';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Unir células';
$string['table:paste_row_after_desc'] = 'Colar linha depois';
$string['table:paste_row_before_desc'] = 'Colar linha antes';
$string['table:props_desc'] = 'Propriedades da tabela';
$string['table:row'] = 'Linha';
$string['table:row_after_desc'] = 'Inserir linha depois';
$string['table:row_before_desc'] = 'Inserir linha antes';
$string['table:row_desc'] = 'Propriedades das linhas';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Dividir células';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Inserir modelo';
$string['template_dlg:cdate_format'] = '%%d-%%m-%%Y %%H:%%M:%%S';
$string['template_dlg:day_long'] = 'Domingo,Segunda-feira,Terça-feira,Quarta-feira,Quinta-feira,Sexta-feira,Sábado,Domingo';
$string['template_dlg:day_short'] = 'Dom,Seg,Ter,Qua,Qui,Sex,Sab,Dom';
$string['template_dlg:desc'] = 'Inserir modelo';
$string['template_dlg:desc_label'] = 'Descrição';
$string['template_dlg:label'] = 'Modelo';
$string['template_dlg:mdate_format'] = '%%d-%%m-%%Y %%H:%%M:%%S';
$string['template_dlg:months_long'] = 'Janeiro,Fevereiro,Março,Abril,Maio,Junho,Julho,Agosto,Setembro,Outubro,Novembro,Dezembro';
$string['template_dlg:months_short'] = 'Jan,Fev,Mar,Abr,Mai,Jun,Jul,Ago,Set,Out,Nov,Dez';
$string['template_dlg:preview'] = 'Pré-Visualização';
$string['template_dlg:select'] = 'Selecionar modelo';
$string['template_dlg:title'] = 'Modelos';
$string['template_dlg:warning'] = 'Atenção: Atualizar um modelo com outro pode causar a perda de dados.';
$string['visualblocks:desc'] = 'Mostrar/ocultar bloco elementos';
$string['visualchars:desc'] = 'Mostrar/ocultar caracteres de controle';
$string['wordcount:words'] = 'Palavras:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Abreviação';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acrónimo';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Inserir/Editar atributos';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citação';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Apagar';
$string['xhtmlxtras_dlg:attribs_title'] = 'Inserir/editar atributos';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributos';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributos';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Eventos';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Chave de acesso';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Citar';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Classe';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Data/Hora';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Idioma';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Direção do texto';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Estilo';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Título';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Da esquerda para a direita';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Da direita para a esquerda';
$string['xhtmlxtras_dlg:events_tab'] = 'Eventos';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atributos do elemento';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Eventos do elemento';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Configurações gerais';
$string['xhtmlxtras_dlg:general_tab'] = 'Geral';
$string['xhtmlxtras_dlg:insert_date'] = 'Inserir data/hora';
$string['xhtmlxtras_dlg:option_ltr'] = 'Da esquerda para a direita';
$string['xhtmlxtras_dlg:option_rtl'] = 'Da direita para a esquerda';
$string['xhtmlxtras_dlg:remove'] = 'Remover';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Elemento de abreviação';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Elemento de acrónimo';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Elemento de citação';
$string['xhtmlxtras_dlg:title_del_element'] = 'Elemento de remoção';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Elemento de inserção';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Inserir';
