<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'hu', branch 'MOODLE_28_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Új fórumüzenetek érkeztek.';
$string['addanewdiscussion'] = 'Új vitatéma hozzáadása';
$string['addanewquestion'] = 'Új kérdés hozzáadása';
$string['addanewtopic'] = 'Új téma hozzáadása';
$string['advancedsearch'] = 'Részletes keresés';
$string['allforums'] = 'Minden fórum';
$string['allowdiscussions'] = 'Egy {$a} hozzászólhat ehhez a fórumhoz?';
$string['allowsallsubscribe'] = 'A fórum bárki részére lehetővé teszi, hogy eldöntse: feliratkozik, avagy sem';
$string['allowsdiscussions'] = 'A fórum mindenki számára egyetlen vitatéma megnyitását engedi meg.';
$string['allsubscribe'] = 'Feliratkozás minden fórumra';
$string['allunsubscribe'] = 'Leiratkozás minden fórumról';
$string['alreadyfirstpost'] = 'Ez már az első hozzászólás a vitához.';
$string['anyfile'] = 'Bármely állomány';
$string['areaattachment'] = 'Csatolt állományok';
$string['areapost'] = 'Üzenetek';
$string['attachment'] = 'Csatolt állomány';
$string['attachment_help'] = 'A hozzászólásokhoz állományokat csatolhat. Ha képet mellékel, az az üzenet után jelenik meg.';
$string['attachmentnopost'] = 'Hozzászólás-azonosító nélkül nem exportálhat csatolt állományokat.';
$string['attachments'] = 'Csatolt állományok';
$string['attachmentswordcount'] = 'Mellékletek és szószám';
$string['blockafter'] = 'Hozzászólás határértéke a blokkoláshoz';
$string['blockafter_help'] = 'Beállítja a felhasználók által adott idő alatt elküldött hozzászólások számát. után már nem küldhetnek további hozzászólásokat. A mod/forum:postwithoutthrottling jogosultságú felhasználókra a korlátozás nem vonatkozik.';
$string['blockperiod'] = 'Blokkolás időtartama';
$string['blockperioddisabled'] = 'Ne blokkolja';
$string['blockperiod_help'] = 'A tanulók adott idő alatt bizonyos számú hozzászólás után már nem küldhetnek további hozzászólásokat. A mod/forum:postwithoutthrottling jogosultságú felhasználókra a korlátozás nem vonatkozik.';
$string['blogforum'] = 'Standard fórum blogüzenetszerű megjelenítésben';
$string['bynameondate'] = '{$a->name} írta {$a->date} időpontban';
$string['cannotadd'] = 'A fórumhoz a vitát nem lehetett hozzáadni.';
$string['cannotadddiscussion'] = 'Ahhoz, hogy hozzáadhasson vitát, ezen a fórumon csoporttagságra van szükség.';
$string['cannotadddiscussionall'] = 'Ön nem adhat hozzá új vitatémát az összes résztvevő számára.';
$string['cannotaddsubscriber'] = 'A(z) {$a} azonosítójú feliratkozót nem adhatja hozzá ehhez a fórumhoz';
$string['cannotaddteacherforumto'] = 'A kurzus 0. szakaszához nem lehetett hozzáadni az átalakított tanári fórumot.';
$string['cannotcreatediscussion'] = 'Nem sikerült új vitát létrehozni.';
$string['cannotcreateinstanceforteacher'] = 'Nem sikerült új kurzusmodult létrehozni a tanári fórumhoz.';
$string['cannotdeletepost'] = 'Nem törölheti ezt a hozzászólást.';
$string['cannoteditposts'] = 'Nem szerkesztheti mások hozzászólását!';
$string['cannotfinddiscussion'] = 'Nincs meg a vita a fórumban';
$string['cannotfindfirstpost'] = 'Nincs meg a fórum első hozzászólása';
$string['cannotfindorcreateforum'] = 'A portálhoz nem található vagy nem hozható létre fő hírfórum';
$string['cannotfindparentpost'] = 'A(z) {$a} hozzászólás legfölső eleme nem található.';
$string['cannotmovefromsingleforum'] = 'A vita egyetlen egyszerű vitafórumból nem helyezhető át.';
$string['cannotmovenotvisible'] = 'A fórum nem látható.';
$string['cannotmovetonotexist'] = 'A fórumot nem helyezheti át, mert nem létezik!';
$string['cannotmovetonotfound'] = 'A célfórum nem található ebben a kurzusban.';
$string['cannotmovetosingleforum'] = 'A vita nem helyezhető át egyetlen egyszerű vitafórumba.';
$string['cannotpurgecachedrss'] = 'A gyorsítótárba helyezett RSS-hírek a forrásfórumból és/vagy a célfórumból nem törölhető - ellenőrizze a permissionsforums állományt.';
$string['cannotremovesubscriber'] = 'A(z) {$a} azonosítójú feliratkozót nem távolíthatja el ebből a fórumból';
$string['cannotreply'] = 'Erre a hozzászólásra nem válaszolhat.';
$string['cannotsplit'] = 'A fórum vitái nem oszthatók föl.';
$string['cannotsubscribe'] = 'Feliratkozáshoz csoporttagnak kell lennie.';
$string['cannottrack'] = 'A fórum nyomon követését nem lehetett leállítani.';
$string['cannotunsubscribe'] = 'Kiiratkoztatása a fórumból nem sikerült.';
$string['cannotupdatepost'] = 'A hozzászólást nem frissítheti.';
$string['cannotviewpostyet'] = 'Ezen vita során más tanulók kérdéseit még nem olvashatja el, mert még nem szólt hozzá';
$string['cannotviewusersposts'] = 'Ennek a felhasználónak nincs az Ön által megtekinthető hozzászólása';
$string['cleanreadtime'] = 'A régi hozzászólásokat ekkor törölje';
$string['clicktosubscribe'] = 'Nincs feliratkozva. Kattintson a feliratkozáshoz.';
$string['clicktounsubscribe'] = 'Feliratkozott a megbeszélésre. Kattintson a leiratkozáshoz.';
$string['completiondiscussions'] = 'A tanulónak vitát kell létrehoznia:';
$string['completiondiscussionsgroup'] = 'Viták előírása';
$string['completiondiscussionshelp'] = 'viták befejezésének előírása';
$string['completionposts'] = 'A tanulónak vitával vagy válasszal kell hozzászólnia';
$string['completionpostsgroup'] = 'Hozzászólások előírása';
$string['completionpostshelp'] = 'Viták vagy válaszok befejezésének előírása';
$string['completionreplies'] = 'A tanulónak választ kell küldeni:';
$string['completionrepliesgroup'] = 'Válaszok előírása';
$string['completionreplieshelp'] = 'válaszok befejezésének előírása';
$string['configcleanreadtime'] = 'A nap azon órája, amikor a rendszer törli az olvasási táblázatból a régi hozzászólásokat.';
$string['configdigestmailtime'] = 'Azok, akik összesítve kérik az e-mailek kézbesítését, ezt naponta fogják megkapni. Ezzel állítható be, hogy a napi e-mail elküldése hány órakor történjék (az adott óra utáni első cron fogja elküldeni).';
$string['configdisplaymode'] = 'Alapértelmezett megjelenítési mód, ha más nincs megadva';
$string['configenablerssfeeds'] = 'Ezzel kapcsolható be minden fórum esetén az RSS-frissítés. A fórumok beállításai között a frissítések bekapcsolását továbbra is kézzel kell elvégezni.';
$string['configenabletimedposts'] = 'Állítsa \'igen\'-re, ha lehetővé kívánja tenni olyan megjelenítési időszakok beállítását, amikor új fórumvita beküldésére nyílik lehetőség (kísérleti jellegű, mivel nincs teljesen leellenőrizve).';
$string['configlongpost'] = 'Minden ennél hosszabb (HTML nélküli) hozzászólás hosszúnak tekintendő. A portál kezdőoldalán, a fórumformájú kurzusok oldalain és a felhasználói profilokban megjelenő hozzászólások rövidítve láthatók a forum_shortpost és a forum_longpost közötti intervallumban.';
$string['configmanydiscussions'] = 'Az oldalanként megjelenítendő viták maximális száma';
$string['configmaxattachments'] = 'A hozzászólásonként megengedett csatolt állományok alapbeállítás szerinti maximális száma';
$string['configmaxbytes'] = 'A portálon az összes fórumhoz csatolt állomány alapbeállítás szerinti maximális mérete (a kurzuskorlátok és más helyi beállítások függvényében)';
$string['configoldpostdays'] = 'Ennyi nap elteltével a hozzászólások elolvasottnak tekintendők.';
$string['configreplytouser'] = 'Ha egy hozzászólást postáznak, tartalmazza-e a felhasználó e-mail címét, hogy a címzettek személy szerint válaszolhassanak a fórum helyett? Még \'Igen\' beállítás esetén is dönthet úgy a felhasználó, hogy profiljában titokban tartja e-mail címét.';
$string['configshortpost'] = 'Minden ennél rövidebb
(HTML nélküli) hozzászólás rövidnek tekintendő.';
$string['configtrackingtype'] = 'Olvasás figyelésének alapbeállítása';
$string['configtrackreadposts'] = 'Állítsa \'igen\'-re, ha a felhasználók mindegyikénél figyelni kívánja, hogy elolvasta-e a hozzászólást.';
$string['configusermarksread'] = 'Ha \'igen\', a felhasználónak kézzel kell a hozzászólás elolvasását megadni. Ha \'nem\', az üzenet megtekintésekor megkapja az \'elolvasott\' megjelölést.';
$string['confirmsubscribe'] = 'Biztosan feliratkozik a(z) \'{$a}\' fórumra?';
$string['confirmsubscribediscussion'] = 'Biztosan feliratkozik a  \'{$a->forum}\' fórum  \'{$a->discussion}\' vitájára?';
$string['confirmunsubscribe'] = 'Biztosan leiratkozik a(z) \'{$a}\' fórumról?';
$string['confirmunsubscribediscussion'] = 'Biztosan leiratkozik a  \'{$a->forum}\' fórum  \'{$a->discussion}\' vitájáról?';
$string['couldnotadd'] = 'Ismeretlen hiba miatt a hozzászólást nem lehetett hozzáadni';
$string['couldnotdeletereplies'] = 'Nem törölhető, már válaszoltak rá';
$string['couldnotupdate'] = 'Ismeretlen hiba miatt a hozzászólását nem lehetett frissíteni';
$string['crontask'] = 'Fórum levelezési és karbantartási feladatai';
$string['delete'] = 'Törlés';
$string['deleteddiscussion'] = 'A vitatémát törölték';
$string['deletedpost'] = 'A hozzászólást törölték';
$string['deletedposts'] = 'A hozzászólásokat törölték';
$string['deleteoriginalonreply'] = 'Ha közvetlenül e-mailben válaszol, ne csatolja válaszához az eredeti másolatát';
$string['deletesure'] = 'Biztosan törölni akarja a hozzászólást?';
$string['deletesureplural'] = 'Biztosan törölni akarja a hozzászólást és minden választ? ({$a} hozzászólás)';
$string['digestmailheader'] = 'Ez a {$a->sitename} portál fórumaira érkezett hozzászólásainak napi összesítése. A fórum e-mail beállításainak a módosításához térjen át ide: {$a->userprefs}.';
$string['digestmailpost'] = 'Fórumolvasási beállítások módosítása';
$string['digestmailprefs'] = 'az Ön felhasználói profilja';
$string['digestmailsubject'] = '{$a}: fórum összesítése';
$string['digestmailtime'] = 'Összesített e-mailek elküldésének órája';
$string['digestsentusers'] = 'E-mail összesítések sikeresen elküldve {$a} felhasználónak.';
$string['disallowsubscribe'] = 'Feliratkozás nem engedélyezett';
$string['disallowsubscribeteacher'] = 'Feliratkozás nem engedélyezett (a tanárokat kivéve)';
$string['disallowsubscription'] = 'Feliratkozás';
$string['disallowsubscription_help'] = 'A fórum úgy van beállítva, hogy nem engedélyezi a megbeszélésekre való feliratkozást.';
$string['discussion'] = 'Vita';
$string['discussionmoved'] = 'A vita átkerült ide: \'{$a}\'.';
$string['discussionmovedpost'] = 'A vita átkerült a(z) <a href="{$a->forumhref}">{$a->forumname}</a> fórumon belül <a href="{$a->discusshref}">ide</a>';
$string['discussionname'] = 'Vita megnevezése';
$string['discussionnownotsubscribed'] = '{$a->name} NEM értesül a(z) \'{$a->name}\' vitához a(z) \'{$a->forum}\' fórumra küldött új hozzászólásokról';
$string['discussionnowsubscribed'] = '{$a->name} NEM értesül a(z) \'{$a->name}\' vitához a(z) \'{$a->forum}\' fórumra küldött új hozzászólásokról';
$string['discussions'] = 'Viták';
$string['discussionsstartedby'] = '{$a} által indított viták';
$string['discussionsstartedbyrecent'] = '{$a} által nemrég indított viták';
$string['discussionsstartedbyuserincourse'] = 'A vitát {$a->fullname} kezdeményezte a(z) ({$a->coursename} kurzusban';
$string['discussionsubscribestart'] = 'Küldjön részemre e-mailben másolatot a megbeszéléshez érkező hozzászólásokról';
$string['discussionsubscribestop'] = 'Ne küldjön részemre e-mailben másolatot a megbeszéléshez érkező hozzászólásokról';
$string['discussionsubscription'] = 'Megbeszélésre való feliratkozás';
$string['discussionsubscription_help'] = 'Ha feliratkozik egy megbeszélésre, akkor  e-mailben másolatot kap a megbeszéléshez érkező hozzászólásokról';
$string['discussthistopic'] = 'Téma megvitatása';
$string['displayend'] = 'Megjelenítés vége';
$string['displayend_help'] = '<p>Megadhatja, hogy egy fórumüzenet egy meghatározott naptól legyen látható, egy megadott napon túl már
ne legyen látható, illetve csak egy megadott időszakban legyen látható.</p>

<p>A kijelzés kezdetét/végét a kikapcsoló opció kijelölésének megszüntetésével kapcsolhatja be.</p>

<p>A rendszergazdák az üzeneteket megjelenésük előtt és levételük után is láthatják.</p>';
$string['displaymode'] = 'Megjelenítési mód';
$string['displayperiod'] = 'Megjelenítési időtartam';
$string['displaystart'] = 'Megjelenítés kezdete';
$string['displaystart_help'] = '<p>Megadhatja, hogy egy fórumüzenet egy meghatározott naptól legyen látható, egy megadott napon túl már
ne legyen látható, illetve csak egy megadott időszakban legyen látható.</p>

<p>A kijelzés kezdetét/végét a kikapcsoló opció kijelölésének megszüntetésével kapcsolhatja be.</p>

<p>A rendszergazdák az üzeneteket megjelenésük előtt és levételük után is láthatják.</p>';
$string['displaywordcount'] = 'Szószám megjelenítése';
$string['displaywordcount_help'] = 'Megszabja, hogy az egyes üzenetekben szereplő szavak száma látsszon-e.';
$string['eachuserforum'] = 'Mindenki egy vitatémát ad meg';
$string['edit'] = 'Szerkesztés';
$string['editedby'] = 'Szerkesztette {$a->name} - eredeti leadás ideje: {$a->date}';
$string['editedpostupdated'] = '{$a} hozzászólásának frissítése megtörtént.';
$string['editing'] = 'Szerkesztés';
$string['emaildigest_0'] = 'Fórumüzenetenként egy e-mailt fog kapni.';
$string['emaildigest_1'] = 'Naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tartalmával';
$string['emaildigest_2'] = 'Naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tárgyával';
$string['emaildigestcompleteshort'] = 'Teljes üzenetek';
$string['emaildigestdefault'] = 'Alapbeállítás ({$a})';
$string['emaildigestoffshort'] = 'Ne ömlesztve';
$string['emaildigestsubjectsshort'] = 'Csak a tárgy';
$string['emaildigesttype'] = 'Fórumolvasási lehetőségek';
$string['emaildigesttype_help'] = 'Az egyes fórumokról kapott értesítés típusa

* Alapbeállítás - a felhasználói profiljában szereplő olvasási beállítás. Ha frissíti profilját, az itt is megjelenik;
* Ne ömlesztve - fórumüzenetenként egy e-mailt fog kapni.
* Ömlesztve - teljes üzenetek - naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tartalmával;
* Ömlesztve - csak a tárgy -
naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tárgyával';
$string['emaildigestupdated'] = 'Az e-mail olvasási beállítása \'{$a->maildigesttitle}\' értékre változott \'{$a->forum}\' fórum esetén. {$a->maildigestdescription}';
$string['emaildigestupdated_default'] = 'Az e-mail olvasási \'{$a->maildigesttitle}\' alapbeállítását használta a(z) \'{$a->forum}\' fórum. {$a->maildigestdescription}';
$string['emptymessage'] = 'Hiba a hozzászólásban. Talán üresen hagyta, vagy túl nagy a csatolt állomány. A változásokat a rendszer NEM mentette el.';
$string['erroremptymessage'] = 'A hozzászólás szövege nem lehet üres.';
$string['erroremptysubject'] = 'A hozzászólás tárgya nem lehet üres.';
$string['errorenrolmentrequired'] = 'A tartalom eléréséhez fel kell vennie a kurzust.';
$string['errorwhiledelete'] = 'Hiba a rekord törlése közben.';
$string['eventassessableuploaded'] = 'Tartalmat küldtek be';
$string['eventcoursesearched'] = 'Keresett kurzus';
$string['eventdiscussioncreated'] = 'Megbeszélés létrehozva';
$string['eventdiscussiondeleted'] = 'Megbeszélés törölve';
$string['eventdiscussionmoved'] = 'Megbeszélés áthelyezve';
$string['eventdiscussionsubscriptioncreated'] = 'Megbeszélésre való feliratkozás létrehozva';
$string['eventdiscussionsubscriptiondeleted'] = 'Megbeszélésre való feliratkozás törölve';
$string['eventdiscussionupdated'] = 'Megbeszélés frissítve';
$string['eventdiscussionviewed'] = 'Megbeszélés megtekintve';
$string['eventpostcreated'] = 'Hozzászólás létrehozva';
$string['eventpostdeleted'] = 'Hozzászólás törölve';
$string['eventpostupdated'] = 'Hozzászólás frissítve';
$string['eventreadtrackingdisabled'] = 'Olvasás követése kikapcsolva';
$string['eventreadtrackingenabled'] = 'Olvasás követése bekapcsolva';
$string['eventsubscribersviewed'] = 'Megtekintett regisztráló';
$string['eventsubscriptioncreated'] = 'Regisztráció létrehozva';
$string['eventsubscriptiondeleted'] = 'Regisztráció törölve';
$string['eventuserreportviewed'] = 'Felhasználói jelentés megtekintve';
$string['everyonecanchoose'] = 'Mindenki feliratkozhat';
$string['everyonecannowchoose'] = 'Mindenki feliratkozhat most';
$string['everyoneisnowsubscribed'] = 'Erre a fórumra most mindenki feliratkozott';
$string['everyoneissubscribed'] = 'Erre a fórumra mindenki feliratkozott';
$string['existingsubscribers'] = 'Feliratkozottak';
$string['exportdiscussion'] = 'A teljes vita exportálása';
$string['forcedreadtracking'] = 'Előírt olvasás nyomon követésének engedélyezése';
$string['forcedreadtracking_desc'] = 'Fórumok előírt olvasás nyomon követésére való beállításának engedélyezése. Egyes felhasználóknál - különösen sok fórum és üzenet esetén - teljesítménycsökkenéssel jár. Kikapcsolása esetén a korábban előírtra beállított fórumokat választhatóként kezeli.';
$string['forcesubscribed'] = 'Ez a fórum mindenkit feliratkoztat';
$string['forcesubscribed_help'] = 'A fórum úgy van beállítva, hogy nem engedélyezi a megbeszélésekről való leiratkozást.';
$string['forum'] = 'Fórum';
$string['forum:addinstance'] = 'Új fórum hozzáadása';
$string['forum:addnews'] = 'Hírek hozzáadása';
$string['forum:addquestion'] = 'Kérdés hozzáadása';
$string['forum:allowforcesubscribe'] = 'Feliratkoztatás engedélyezése';
$string['forumauthorhidden'] = 'Szerző (rejtett)';
$string['forumblockingalmosttoomanyposts'] = 'Közelíti a hozzászólások határértékét. Az utolsó {$a->blockperiod} alatt {$a->numposts} alkalommal küldött hozzászólást, a határ pedig {$a->blockafter} hozzászólás';
$string['forumbodyhidden'] = 'A hozzászólást nem tekintheti meg, feltehetőleg azért, mert még nem szólt hozzá a vitához, vagy nem telt le a maximális szerkesztési idő, illetve a vita még nem kezdődött el vagy már letelt a vitára szánt idő.';
$string['forum:createattachment'] = 'Csatolt állományok létrehozása';
$string['forum:deleteanypost'] = 'Bármely hozzászólás törlése (bármikor)';
$string['forum:deleteownpost'] = 'Saját hozzászólások törlése (határidőn belül)';
$string['forum:editanypost'] = 'Bármely hozzászólás szerkesztése';
$string['forum:exportdiscussion'] = 'A teljes vita exportálása';
$string['forum:exportownpost'] = 'Saját hozzászólás exportálása';
$string['forum:exportpost'] = 'Hozzászólás exportálása';
$string['forumintro'] = 'Fórumbevezető';
$string['forum:managesubscriptions'] = 'Feliratkozások kezelése';
$string['forum:movediscussions'] = 'Viták áthelyezése';
$string['forumname'] = 'Fórum neve';
$string['forumposts'] = 'Fórum hozzászólásai';
$string['forum:postwithoutthrottling'] = 'Mentesség az üzenetküldési korlát alól';
$string['forum:rate'] = 'Hozzászólások értékelése';
$string['forum:replynews'] = 'Válasz a hírekre';
$string['forum:replypost'] = 'Válasz a hozzászólásokra';
$string['forums'] = 'Fórumok';
$string['forum:splitdiscussions'] = 'Viták felosztása';
$string['forum:startdiscussion'] = 'Új viták indítása';
$string['forumsubjecthidden'] = 'Tárgy (rejtett)';
$string['forumtracked'] = 'Az olvasatlan hozzászólások figyelése';
$string['forumtrackednot'] = 'Az olvasatlan hozzászólások figyelmen kívül hagyása';
$string['forumtype'] = 'Fórum típusa';
$string['forumtype_help'] = 'Ötféle fórumfajta közül választhat:

* Egyszeri egyszerű megbeszélés - mindössze egyetlen téma, amelyre bárki válaszolhat.
* Mindenki egy megbeszélendőt küld Minden tanuló csakis egy új megbeszélendőt küldhet, melyre bárki válaszolhat.
* Kérdés--felelet fórum - A tanulók a többi tanuló üzenetének megtekintése előtt beküldik álláspontjukat.
 * Standard, blogszerű fórum - Olyan nyitott fórum, ahol bárki bármikor
új témát kezdeményezhet. A témák az "Adott téma megvitatása" ugróponttal összekapcsolt oldalakon jelennek meg.
* Standard általános fórum -  Olyan nyitott fórum, ahol bárki bármikor új témát kezdeményezhet.';
$string['forum:viewallratings'] = 'Minden egyénileg készített értékelés megtekintése';
$string['forum:viewanyrating'] = 'Az illetők részére beérkezett összes értékelés megtekintése';
$string['forum:viewdiscussion'] = 'Viták  megtekintése';
$string['forum:viewhiddentimedposts'] = 'Rejtett ütemezett hozzászólások megtekintése';
$string['forum:viewqandawithoutposting'] = 'K/V-hozzászólások folyamatos megjelenítése';
$string['forum:viewrating'] = 'Az általam elért összesített értékelés megtekintése';
$string['forum:viewsubscribers'] = 'Feliratkozottak megtekintése';
$string['generalforum'] = 'Általános célú fórum';
$string['generalforums'] = 'Általános fórumok';
$string['hiddenforumpost'] = 'Rejtett fórumüzenet';
$string['inforum'] = '{$a} fórumban';
$string['introblog'] = 'A fórum üzenetei a kurzus felhasználóinak blogjaiból automatikusan kerültek ide, mert a blogüzenetek már nem elérhetők.';
$string['intronews'] = 'Általános hírek és közlemények';
$string['introsocial'] = 'Nyitott fórum, ahol bármit meg lehet beszélni';
$string['introteacher'] = 'Fórum csak a tanárok megjegyzései és vitája számára';
$string['invalidaccess'] = 'Az oldal elérése hibásan történt';
$string['invaliddigestsetting'] = 'Érvénytelen olvasási beállítást adtak meg.';
$string['invaliddiscussionid'] = 'Érvénytelen vagy már nem létező a vitaazonosító';
$string['invalidforcesubscribe'] = 'Érvénytelen feliratkozást előíró mód';
$string['invalidforumid'] = 'Érvénytelen volt a fórumazonosító';
$string['invalidparentpostid'] = 'A fölső hozzászólás-azonosító hibás volt.';
$string['invalidpostid'] = 'Érvénytelen {$a} hozzászólás-azonosító';
$string['lastpost'] = 'Utolsó hozzászólás';
$string['learningforums'] = 'Tanulási fórumok';
$string['longpost'] = 'Hosszú hozzászólás';
$string['mailnow'] = 'Küldés most';
$string['manydiscussions'] = 'Vita oldalanként';
$string['markalldread'] = 'Ezen vita minden hozzászólását olvasottként jelöli meg.';
$string['markallread'] = 'Ezen fórum minden hozzászólását olvasottként jelöli meg.';
$string['markread'] = 'Elolvasottnak jelöl';
$string['markreadbutton'] = 'Elolvasottnak<br />jelöl';
$string['markunread'] = 'Elolvasatlannak jelöl';
$string['markunreadbutton'] = 'Elolvasatlannak<br />jelöl';
$string['maxattachments'] = 'Csatolt állományok max. száma';
$string['maxattachments_help'] = '<p>Itt állíthatja be, hány állomány csatolható a fórumon belül egy-egy hozzászóláshoz.</p>';
$string['maxattachmentsize'] = 'Csatolt állomány maximális mérete';
$string['maxattachmentsize_help'] = '<p>A csatolt állományok mérete bizonyos értékre mérsékelhető, melyet a fórumot
létrehozó személy választhat ki.</p>
<p>Esetenként ennél nagyobb állomány is feltölthető, de az adott állomány nem
tárolódik a szerveren, és esetlegesen hibajelzés jelenhet meg. </p>';
$string['maxtimehaspassed'] = 'A hozzászólás szerkesztéséhez rendelkezésére álló idő ({$a}) lejárt.';
$string['message'] = 'Üzenet';
$string['messageinboundattachmentdisallowed'] = 'A válasz nem küldhető el, mert csatolt állományt tartalmaz, ezt pedig a fórum nem engedélyezi.';
$string['messageinboundfilecountexceeded'] = 'A válasz nem küldhető el, mert a fórumban engedélyezettnél több csatolt állományt tartalmaz ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'A válasz nem küldhető el, mert a fórumban engedélyezett összes csatolt állomány mérete ({$a->filesize}) nagyobb a megengedettnél ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'A válasz nem küldhető el, mert a fórum jelenleg nem elérhető.';
$string['messageinboundnopostforum'] = 'A válasz nem küldhető el, mert a(z) {$a->forum->name} fórum ezt nem engedélyezi Önnek.';
$string['messageinboundthresholdhit'] = 'A válasz nem küldhető el, mert túllépte a fórumban engedélyezett mértéket.';
$string['messageprovider:digests'] = 'Járatott fórum összesítései';
$string['messageprovider:posts'] = 'Járatott fórum hozzászólásai';
$string['missingsearchterms'] = 'Az alábbi kereső kifejezések az üzenetnek csak a HTML-kódjában jelennek meg:';
$string['modeflatnewestfirst'] = 'Válaszok egymás után, a legújabbal kezdve';
$string['modeflatoldestfirst'] = 'Válaszok egymás után, a legrégebbivel kezdve';
$string['modenested'] = 'Válaszok beágyazott formában';
$string['modethreaded'] = 'Válaszok témánkénti formában';
$string['modulename'] = 'Fórum';
$string['modulename_help'] = 'A Fórum az aszinkrón  megbeszélések helye.

A fórum különféle módokon strukturálható, emellett szerepelhet benne az egyes
üzenetek csoporttársi értékelése is.

Az üzenetek számos változatban
megjeleníthetők és tartalmazhatnak csatolt állományt is.

A fórumra való feliratkozással a
részvevők minden egyes üzenetből kapnak egy-egy példányt a levelesládájukba.

A tanár adott
esetben mindenki számára előírhatja a feliratkozást.';
$string['modulenameplural'] = 'Fórumok';
$string['more'] = 'tovább';
$string['movedmarker'] = '(Áthelyezve)';
$string['movethisdiscussionto'] = 'A téma áthelyezése a következő helyre...';
$string['mustprovidediscussionorpost'] = 'Exportáláshoz meg kell adnia egy vitaazonosítót vagy egy hozzászólás-azonosítót';
$string['namenews'] = 'Hírfórum';
$string['namenews_help'] = '<p>A hírfórum speciális, minden egyes kurzushoz és a portál kezdőoldalához automatikusan létrehozott fórum, melyen általános bejelentések tehetők közzé. Kurzusonként legfeljebb egy hírfórumot működtethet.</p>

<p>A "Friss hírek" blokkban ezen fórum legutóbbi megbeszélései jelennek meg (akkor is, ha átnevezi).  Ezért a fórum automatikusan újból létrejön, ha a Friss hírek blokkot használja.</p>';
$string['namesocial'] = 'Társas fórum';
$string['nameteacher'] = 'Tanári fórum';
$string['newforumposts'] = 'A fórum új hozzászólásai';
$string['nextdiscussiona'] = 'Következő megbeszélés:  {$a}';
$string['noattachments'] = 'A hozzászóláshoz nincsenek csatolt állományok';
$string['nodiscussions'] = 'Ebben a fórumban még nincsenek vitatémák';
$string['nodiscussionsstartedby'] = '{$a} még nem kezdeményezett vitát';
$string['nodiscussionsstartedbyyou'] = 'Ön még nem kezdeményezett vitát.';
$string['noguestpost'] = 'Vendégek nem szólhatnak hozzá.';
$string['noguestsubscribe'] = 'Ez vendégek számára nem elérhető.';
$string['noguesttracking'] = 'Vendégek nyomon követést nem állíthatnak be.';
$string['nomorepostscontaining'] = 'Nincs több \'{$a}\' tartalmú hozzászólás';
$string['nonews'] = 'Nincs még hír';
$string['noonecansubscribenow'] = 'Most nem lehet feliratkozni.';
$string['nopermissiontosubscribe'] = 'A fórumra feliratkozottakat nem tekintheti meg';
$string['nopermissiontoview'] = 'Ezt a hozzászólást nem tekintheti meg.';
$string['nopostforum'] = 'Ön erre a fórumra nem küldhet hozzászólást';
$string['noposts'] = 'Nincs hozzászólás';
$string['nopostsmadebyuser'] = '{$a} felhasználónak nincs hozzászólása';
$string['nopostsmadebyyou'] = 'Önnek még nincs hozzászólása';
$string['noquestions'] = 'Még nincsenek kérdések ezen a fórumon';
$string['nosubscribers'] = 'Még senki nincs feliratkozva erre a fórumra';
$string['notexists'] = 'A vita már nem létezik.';
$string['nothingnew'] = 'Semmi új {$a} kapcsán.';
$string['notingroup'] = 'Ennek a fórumnak a megtekintéséhez csoporttagnak kell lennie.';
$string['notinstalled'] = 'A fórummodul nincs telepítve.';
$string['notpartofdiscussion'] = 'A hozzászólás egy vitának sem része.';
$string['notrackforum'] = 'Olvasatlan hozzászólásokat ne kövessen nyomon';
$string['notsubscribed'] = 'Feliratkozás';
$string['noviewdiscussionspermission'] = 'Ezen fórum vitáit nem tekintheti meg';
$string['nowallsubscribed'] = 'A(z) {$a} esetén minden fórumra feliratkoztak.';
$string['nowallunsubscribed'] = 'A(z) {$a} esetén a fórumokra nem iratkoztak fel.';
$string['nownotsubscribed'] = '{$a->name} NEM kap értesítést a(z) \'{$a->forum}\' fórum új hozzászólásairól.';
$string['nownottracking'] = '{$a->name} már nem követi nyomon a(z) \'{$a->forum}\' fórumot.';
$string['nowsubscribed'] = '{$a->name} kap értesítést a(z) \'{$a->forum}\' fórum új hozzászólásairól:';
$string['nowtracking'] = '{$a->name} már nyomon követi a(z) \'{$a->forum}\' fórumot.';
$string['numposts'] = '{$a} hozzászólás';
$string['olderdiscussions'] = 'Régebbi viták';
$string['oldertopics'] = 'Régebbi témák';
$string['oldpostdays'] = 'Ennyi nap után elolvasott';
$string['overviewnumpostssince'] = '{$a} hozzászólás az utolsó belépés óta';
$string['overviewnumunread'] = '{$a} olvasatlan összesen';
$string['page-mod-forum-discuss'] = 'A fórummodul vitáját követő oldal';
$string['page-mod-forum-view'] = 'A fórummodul fő oldala';
$string['page-mod-forum-x'] = 'A fórummodul bármely oldala';
$string['parent'] = 'Előzmény megjelenítése';
$string['parentofthispost'] = 'A hozzászólás előzménye';
$string['pluginadministration'] = 'Fórum kezelése';
$string['pluginname'] = 'Fórum';
$string['postadded'] = 'A hozzászólást sikeresen hozzáadtuk. Van {$a} a javításra, ha változtatni szeretné.';
$string['postaddedsuccess'] = 'Hozzászólását sikeresen hozzáadtuk.';
$string['postaddedtimeleft'] = 'Ha módosításokat kíván végrehajtani, szerkesztendő: {$a}';
$string['postbymailsuccess'] = '"{$a->subject}" tárgyú fórumüzenetét sikeresen hozzáadtuk. Itt tekintheti meg: {$a->discussionurl}.';
$string['postbymailsuccess_html'] = '"{$a->subject}" tárgyú <a href="{$a->discussionurl}"> fórumüzenetét sikeresen közzétettük.';
$string['postbyuser'] = '{$a->user} felhasználótól származó {$a->post}';
$string['postincontext'] = 'Nézze ezt a hozzászólást összefüggéseiben.';
$string['postmailinfo'] = 'Ez a(z) {$a} portálra küldött hozzászólás másolata.

Válaszadáshoz kattintson erre az ugrópontra:';
$string['postmailnow'] = 'Ezt a hozzászólást minden fórumra feliratkozott haladéktalanul megkapja.';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Főként elkülönült ismeretet tartalmaz';
$string['postrating2'] = 'Elkülönült és kapcsolt ismeretet is tartalmaz';
$string['postrating3'] = 'Főként kapcsolt ismeretet tartalmaz';
$string['posts'] = 'Hozzászólások';
$string['postsmadebyuser'] = '{$a} hozzászólásai';
$string['postsmadebyuserincourse'] = '{$a->fullname} hozzászólásai a(z) ({$a->coursename} kurzusban';
$string['posttoforum'] = 'Hozzászólás a fórumhoz';
$string['postupdated'] = 'A hozzászólás frissítése megtörtént';
$string['potentialsubscribers'] = 'Lehetséges feliratkozók';
$string['prevdiscussiona'] = 'Előző megbeszélés:  {$a}';
$string['processingdigest'] = 'Összesített e-mail feldolgozása {$a} számára';
$string['processingpost'] = 'A(z) {$a} hozzászólás feldolgozása';
$string['prune'] = 'Szétvágás';
$string['prunedpost'] = 'A hozzászólás óta új vita jött létre';
$string['pruneheading'] = 'Vita szétvágása és a hozzászólás áthelyezése egy új vitába';
$string['qandaforum'] = 'Kérdések és válaszok jellegű fórum';
$string['qandanotify'] = 'Ez egy kérdések és válaszok jellegű fórum. A kérdésekre adott többi tanulói válasz megtekintéséhez előbb saját válaszát kell beküldenie.';
$string['re'] = 'Tárgy:';
$string['readtherest'] = 'A téma további részének olvasása';
$string['replies'] = 'Válaszok';
$string['repliesmany'] = 'Eddig {$a} válasz';
$string['repliesone'] = 'Eddig csak {$a} válasz';
$string['reply'] = 'Válasz';
$string['replyforum'] = 'Válasz a fórumra';
$string['reply_handler'] = 'Fórumüzenetek megválaszolása e-mailben';
$string['reply_handler_name'] = 'Fórumüzenetek megválaszolása';
$string['replytoforumpost'] = 'Választ küldhet e-mailben erre a fórumra.';
$string['replytopostbyemail'] = 'Ha közvetlenül e-mailben válaszol, ne csatolja válaszához az eredeti másolatát';
$string['replytouser'] = 'A válaszban használjon e-mail címet';
$string['resetdigests'] = 'Összes felhasználónkénti olvasási beállítás törlése';
$string['resetforums'] = 'Innen érkezett hozzászólások törlése';
$string['resetforumsall'] = 'Az összes hozzászólás törlése';
$string['resetsubscriptions'] = 'Összes fórumra való feliratkozás törlése';
$string['resettrackprefs'] = 'A fórum összes nyomon követési beállításának törlése';
$string['rssarticles'] = 'Legfrissebb RSS-hírek száma';
$string['rssarticles_help'] = '<p>Itt kiválaszthatja, hány cikk kerüljön az RSS-hírek közé.</p>

<p>A legtöbb fórum esetén egy 5 és 20 közötti szám megadása elegendő.
Növelje meg a hírek számát, ha a fórumot sűrűn használja.</p>';
$string['rsssubscriberssdiscussions'] = 'Vitákhoz kapcsolódó RSS-hírek';
$string['rsssubscriberssposts'] = 'Hozzászólásokhoz kapcsolódó RSS-hírek ';
$string['rsstype'] = 'A tevékenységhez kapcsolódó RSS-hírek';
$string['rsstype_help'] = 'A tevékenységhez RSS-híreket kapcsolhat, ha vitát vagy üzenetet jelöl meg mint a hírbe beszúrandó elemet.';
$string['search'] = 'Keresés';
$string['searchdatefrom'] = 'A hozzászólásoknak ennél újabbaknak kell lenni';
$string['searchdateto'] = 'A hozzászólásoknak ennél régebbinek kell lenni';
$string['searchforumintro'] = 'Az alábbi mező(k)ben adja meg a kereső kifejezéseket:';
$string['searchforums'] = 'Keresés a fórumokban';
$string['searchfullwords'] = 'Ezek a szavak teljes szavakként jelenjenek meg';
$string['searchnotwords'] = 'Ezeket a szavakat NE tartalmazza';
$string['searcholderposts'] = 'Keresés régebbi hozzászólások között...';
$string['searchphrase'] = 'Ennek a kifejezésnek pontosan így kell szerepelnie a hozzászólásban';
$string['searchresults'] = 'Keresési eredmények';
$string['searchsubject'] = 'Ezek a szavak a tárgysorban szerepeljenek';
$string['searchuser'] = 'Ennek a névnek a szerzőével kell egyeznie';
$string['searchuserid'] = 'A szerző Moodle-azonosítója';
$string['searchwhichforums'] = 'Válassza ki a keresendő fórumot';
$string['searchwords'] = 'Ezek a szavak a hozzászólásban bárhol előfordulhatnak';
$string['seeallposts'] = 'Ezen felhasználó összes hozzászólásainak megmutatása';
$string['shortpost'] = 'Rövid hozzászólás';
$string['showsubscribers'] = 'Mostani feliratkozottak megmutatása/szerkesztése';
$string['singleforum'] = 'Egyszerű vita';
$string['smallmessage'] = '{$a->user} hozzászólt a(z) {$a->forumname} fórumhoz';
$string['startedby'] = 'Indította';
$string['subject'] = 'Téma';
$string['subscribe'] = 'Feliratkozás a fórumra';
$string['subscribeall'] = 'Mindenki feliratkoztatása a fórumra';
$string['subscribed'] = 'Feliratkozott';
$string['subscribediscussion'] = 'Feliratkozás a  vitára';
$string['subscribeenrolledonly'] = 'Csak beiratkozott felhasználók kaphatnak értesítést fórumhozzászólásokról.';
$string['subscribenone'] = 'Mindenki leiratkozása a fórumról';
$string['subscribers'] = 'Feliratkozottak';
$string['subscribersto'] = 'A(z) \'{$a}\' fórumra feliratkozottak';
$string['subscribestart'] = 'Kérek e-mailt a fórum hozzászólásairól';
$string['subscribestop'] = 'Nem kérek e-mailt a fórum hozzászólásairól';
$string['subscription'] = 'Feliratkozás';
$string['subscriptionandtracking'] = 'Feliratkozás és követés';
$string['subscriptionauto'] = 'Automatikus feliratkozás';
$string['subscriptiondisabled'] = 'Feliratkozás kikapcsolva';
$string['subscriptionforced'] = 'Kötelező feliratkozás ';
$string['subscription_help'] = 'Ha valaki feliratkozik egy fórumra, akkor e-mailben minden fórumra küldött üzenetből kap egy-egy
példányt. A fórumra való feliratkozásról általában saját maga dönthet, bár esetenként a tanár előírhatja a belépést valamely fórumra, amikor is a fórumüzenetekből mindenki kap egy másolatot e-mailben.';
$string['subscriptionmode'] = 'Feliratkozási mód';
$string['subscriptionmode_help'] = 'Ha valaki feliratkozik egy fórumra, a fórum minden hozzászólásából kap e-mailben egy másolatot.

A fórumra négyféleképpen iratkozhat fel.

* Választható feliratkozás - A résztvevő dönti el, feliratkozik-e
* Kötelező feliratkozás - Mindenki feliratkozik és nem iratkozhat le
* Automatikus feliratkozás - Kezdetben mindenki feliratkozik, de bármikor leiratkozhat
* Feliratkozás kikapcsolva - Nem lehet feliratkozni

Megjegyzés: a feliratkozási változások csak a kurzust később felvevő tanulókat érintik, a meglévőket nem.';
$string['subscriptionoptional'] = 'Választható feliratkozás';
$string['subscriptions'] = 'Feliratkozások';
$string['thisforumisthrottled'] = 'A fórumra az Ön által adott idő alatt beküldhető hozzászólások maximálva vannak - jelenleg ez {$a->blockafter} hozzászólás {$a->blockperiod} alatt';
$string['timedposts'] = 'Időzített hozzászólások';
$string['timestartenderror'] = 'A kijelzendő befejezési idő nem lehet a kezdési időnél korábban';
$string['trackforum'] = 'Elolvasatlan hozzászólások nyomon követése';
$string['tracking'] = 'Nyomon követés';
$string['trackingoff'] = 'Ki';
$string['trackingon'] = 'Előírt';
$string['trackingoptional'] = 'Opcionális';
$string['trackingtype'] = 'Elolvassa a fórum nyomon követését';
$string['trackingtype_help'] = 'Ha be van kapcsolva, akkor a résztvevők
nyomon követhetik az elolvasott és az el nem olvasott fórumüzeneteket.

A beállításhoz három lehetőség áll rendelkezésre:
* Választható: a résztvevők maguk állíthatják be a
nyomon követést.
* Előírt: A nyomon követés mindig be van kapcsolva.
* Ki: A nyomon követés mindig ki van kapcsolva.';
$string['unread'] = 'Elolvasatlan';
$string['unreadposts'] = 'Elolvasatlan hozzászólások';
$string['unreadpostsnumber'] = '{$a} elolvasatlan hozzászólás';
$string['unreadpostsone'] = '1 elolvasatlan hozzászólás';
$string['unsubscribe'] = 'Leiratkozás a fórumról';
$string['unsubscribeall'] = 'Leiratkozás minden fórumról';
$string['unsubscribeallconfirm'] = 'Jelenleg  {$a->forums} fórumra és {$a->discussions} vitára van feliratkozva. Biztosan le akar iratkozni az összes fórumról és vitáról, és kikapcsolja az automatikus feliratkozást?';
$string['unsubscribeallconfirmdiscussions'] = 'Jelenleg  {$a->discussions} vitára van feliratkozva. Biztosan le akar iratkozni az összes vitáról  és kikapcsolja az automatikus feliratkozást?';
$string['unsubscribeallconfirmforums'] = 'Jelenleg  {$a->forums} fórumra van feliratkozva. Biztosan le akar iratkozni az összes fórumról és kikapcsolja az automatikus feliratkozást?';
$string['unsubscribealldone'] = 'Minden fórumra való feliratkozását töröltük, de a közvetlen feliratkozású fórumoktól még továbbra is kap értesítéseket. Az értesítések kezeléséhez  térjen át profiljának beállításai között az üzenetküldésre';
$string['unsubscribeallempty'] = 'Ön semmilyen fórumra nincs feliratkozva. Ha semmilyen értesítést nem kíván kapni erről a szerverről, térjen át profiljának beállításai között az üzenetküldésre.';
$string['unsubscribed'] = 'Leiratkozott';
$string['unsubscribediscussion'] = 'Leiratkozás a megbeszélésről.';
$string['unsubscribeshort'] = 'Leiratkozás';
$string['usermarksread'] = 'Üzenet elolvasásának kézi bejelölése';
$string['viewalldiscussions'] = 'Az összes vita megtekintése';
$string['warnafter'] = 'Hozzászólás határértéke a figyelmeztetéshez';
$string['warnafter_help'] = 'A tanulók figyelmeztetést kaphatnak, ha közel járnak az adott időszak alatt részükre engedélyezett hozzászólások maximális számához. Ez a beállítás adja meg, hány hozzászólás után kapnak figyelmeztetést. A hozzászólási korlát mod/forum:postwithoutthrottling jogosultságú felhasználókra nem vonatkozik.';
$string['warnformorepost'] = 'Figyelem! A fórumban egynél több vita zajlik - a legújabb használatára kerül sor.';
$string['yournewquestion'] = 'Az Ön új kérdése';
$string['yournewtopic'] = 'Az Ön új vitatémája';
$string['yourreply'] = 'Az Ön válasza';
