<?php
// index=> array(permission, dependency, customer_allowed, description)

$config = array(
    'mandatory'     => true,
    'recommended'   => true,
    'description'   => 'Domain management module.',
    'navButtonLabel'=> lang('Domains'),
    'dependencies'  => array(),
    'hasSchemaFile' => true,
    'hasInitialData'=> true,
    'hasUninstallSQLScript' => false,
    'hasUninstallPHPScript' => false,
    'order'         => 3,
    'settingTypes'  => array(),
    'hooks'         => array(
        'Menu'                              =>  'Domains_menu'
    ),
    'permissions' => array(
        1    => array('domains_view',                        0, true,  lang('View Domain Overview')),
        2    => array('domains_manage_domains',              1, true, lang('Manage Domain')),
        3    => array('domains_viewcontactinfo',             2, true, lang('View Domain Contact Information')),
        17   => array('domains_updatecontactinfo',           3, true,  lang('Edit Domain Contact Information')),
        4    => array('domains_dnssettings',                 2, true,  lang('View Domain DNS Settings')),
        16   => array('domains_updatedns',                   4, true,  lang('Update DNS Host Information')),
        5    => array('domains_transfer',                    2, true,  lang('Manage Domain Transfer Settings')),
        12   => array('domains_lock',                        5, true,  lang('Toggle Domain Registrar Lock')),
        13   => array('domains_transfer_key',                5, true,  lang('Send Transfer Key')),
        6    => array('domains_nameservers',                 2, true,  lang('View Domain Nameservers')),
        //7    => array('domains_registerns',                  6, true,  lang('Register Nameservers With Registrar')),
        8    => array('domains_editns',                      6, true,  lang('Edit Nameservers For A Domain')),
        //9    => array('domains_deletens',                    6, true,  lang('Delete Nameservers From Registrar')),
        //10   => array('domains_updatens',                    6, true,  lang('Update Nameservers With Registrar')),
        //11   => array('domains_autorenew',                   1, true,  lang('Toggle Domain Autorenew')),
        14   => array('domains_fetch',                       1, false,  lang('Fetch Domains From Registrar')),
        15   => array('domains_delete',                      1, false,  lang('Delete Domain Name')),
    ),
    'hreftarget' => '#'
);

// language entries referred in this module, but that need to be loaded always
// (e.g. menu item labels)
$lang = array(
lang("Nexus Category"),
lang("US Citizen"),
lang("A natural person who is a US Citizen."),
lang("Permanent Resident"),
lang("A natural person who is a Permanent Resident."),
lang("Business Entity"),
lang("An entity or organization that is (i) incorporated within one of the fifty US states, the District of Columbia, or any of the US possessions or territories, or (ii) organized or otherwise constituted under the laws of a state of the US, the District of Columbia or any of its possessions and territories (including federal, state, or local government of the US, or a political subdivision thereof, and non-commercial organizations based in the US.)."),
lang("Foreign Entity"),
lang("US Based Office"),
lang("Application Purpose"),
lang("For Profit"),
lang("Business use for profit"),
lang("Non-profit"),
lang("Non-profit business, club, association, religious organization, etc."),
lang("Personal"),
lang("Personal use"),
lang("Educational"),
lang("Educational purposes"),
lang("Government"),
lang("Government purposes"),
lang("Company identification number"),
lang("Company or person domain is registered for (this must be accurate and CANNOT BE CHANGED)"),
lang("Personal Identification Number(or Organization number), if you are an individual registrant (or organization) in Sweden"),
lang("Only individuals and organizations that have a physical presence in one of New York City’s 5 boroughs will be allowed to register a .nyc domain.
- P.O Boxes not permitted
- Registrants must agree that they are in compliance with all relevant Federal, New York State and New York City laws and tax requirements
- Registrants must remain in compliance with the applicable Nexus Policy for the duration of domain’s registration
- No proxy registrations permitted– Registrants must agree not to license, sub-delegate or transfer .nyc domain(s) to third parties.

I declare that I am an:
"),
lang("Organization"),
lang("An entity or organization that has a physical street address in New York City."),
lang("Individual"),
lang("Individuals whose primary place of residence is in New York City."),
lang(".physio domain names are for members of the global physio/physical therapy community.
	In order to register or renew a .physio domain name the applicant must satisfy Criteria A, B or C
Criteria A:
Where a professional association that is a member of the World Confederation for Physical Therapy exists in the country where the applicant resides the applicant must:
1. Be a natural person; and
2. Be entitled to be a member of the professional association of the country where	 they reside or were educated. 

Criteria B
In the case where a professional association exists but is not a member of the World Confederation for Physical Therapy or where a professional association does not exist in the country where the applicant resides the applicant must:
1. Be a natural person; and
2. Be completing, or have completed, a programme of study that affords eligibility	 to practice physiotherapy in that country.

Criteria C
In the case of a company or organisation:
1. One of their primary purposes must be to support, promote, service or supply	 persons identified in Criteria A or B, as an identified professional group, and
2. They may only register a domain name that is a close and substantial match to	 their business name, product or service.
The list of professional associations that are members of the World Confederation for Physical Therapy is available at the following link, http://www.wcpt.org/members."),
lang("I Agree"),
lang("I agree and acknowledge that I am registering based on the criteria stated above"),
lang("Please write a brief description of your intended use of this domain (max 255 characters)"),
lang("By registering this domain name, the registrant commits to not undermine the Principles of Organic Agriculture as formulated by the IFOAM (POA). 
		If the registrant is a producer, a transformer or retailer in the field of agriculture, food and farming, the registrant commits to abide by POA and by any 
		regulations in force in the relevant markets where the registrant intends to present or promote its products within the on-line content associated with this .BIO domain name(s)"),
lang("I agree"),
lang("I certify that the registrant of this domain the commits to not undermine the Principles of Organic Agriculture as formulated by the IFOAM (POA). 
		If the registrant is a producer, a transformer or retailer in the field of agriculture, food and farming, the registrant commits to abide by POA and by any 
		regulations in force in the relevant markets where the registrant intends to present or promote its products within the on-line content associated with this .BIO domain name(s)."),
lang("By registering this domain name, you certify that the registrant of this domain is an individual professional architect (or an architecture firm) registered as a member of a national architects association authorized by the registry operator, or an architecture-related organization authorized by the registry operator.&quot;"),
lang("I certify that the registrant of this domain is an individual professional architect (or an architecture firm)."),
lang("Legal type of registrant contact"),
lang("Corporation"),
lang("A corporation under the laws of Canada or any province or territory of Canada, Charities, Cooperative, Council.&lt;br/&gt;Requirements: Registrant name must be the full legal name of the corporation and must be followed by the jurisdiction of incorporation (eg. Canada, Ontario, NWT...), unless it is obvious from the corporation&#39;s name. Canadian Internet Registration Authority (Canada). For Charities, the NFP should be included in the organization name. If this is a not-for-profit organization, you are also required to submit the registration number i.e.: 123456789 RR0001"),
lang("Canadian Citizen"),
lang("A Canadian citizen of the age of majority under the laws of the province or territory in Canada in which he or she resides or last resided.&lt;br/&gt;Requirements: The Registrant&#39;s name must be the full legal name of the Canadian Citizen who will hold the domain name registration as the name would appear on a passport, driver&#39;s license or other identification document issued by a government. The name can be followed by a space and &quot;o/a xxxx&quot; where &quot;o/a&quot; stands for &quot;Operating As&quot; and &quot;xxxx&quot; can be any alpha-numeric string designated by the applicant and subject to applicable rules and length restrictions (e.g. &quot;John Doe o/a Doe Consulting Group&quot;). The name may also be followed by a space and a degree granted to the registrant (eg. PhD.) Full legal names of individuals may only consist of alphabetic characters and the special characters: single quote mark(&#39;), hyphen(-), period(.)."),
lang("Canadian Resident"),
lang("A permanent resident as defined in the Immigration and Refugee Protection Act (Canada) S.C. 2001, c.27, as amended from time to time, who is &quot;ordinarily resident&quot; (as defined below) in Canada and of the age of majority under the laws of the province or territory in Canada in which he or she resides or last resided. &quot;Ordinarily resident in Canada&quot; means an individual who resides in Canada for more than 183 days in the twelve month period immediately preceding the date of the applicable request for registration of the .ca domain name or sub-domain name and in each twelve month period thereafter for the duration of the domain name registration.&lt;br/&gt;Requirements: The Registrant&#39;s name must be the full legal name of the Permanent Resident who will hold the domain name registration as the name would appear on a driver&#39;s license or other identification document issued by a government. The full legal name may be followed by a space and &quot;o/a xxxx&quot; where &quot;o/a&quot; stands for &quot;Operating As&quot; and &quot;xxxx&quot; can be any alpha-numeric string designated by the applicant and subject to applicable rules and length restrictions (e.g. &quot;John Doe o/a Doe Consulting Group&quot;). The name may also be followed by a space and a degree granted to the registrant by a recognized degree granting institution or a recognized professional designation which the registrant has the right to use (eg. PhD, MD, DDS.) Full legal names of individuals may only consist of alphabetic characters and the special characters: single quote mark(&#39;), hyphen(-), period(.)."),
lang("Government Entity"),
lang("Her Majesty the Queen in right of Canada, a province or a territory; an agent of Her Majesty the Queen in right of Canada, of a province or of a territory; a federal, provincial or territorial Crown corporation, government agency or government entity; or a regional, municipal or local area government.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete official name of the entity that will hold the domain name registration, without any abbreviations. (A common abbreviation may follow the official name in parentheses). If the Registrant is not a government, the Registrant&#39;s name must be followed by the name of the jurisdiction (eg. Canada, province, territory, municipality, etc) to which the Registrant is related."),
lang("(i) A university or college which is located in Canada and which is authorized or recognized as a university or college under an Act of the legislature of a province or territory of Canada; or&lt;br /&gt;(ii) A college, post-secondary school, vocational school, secondary school, pre-school or other school or educational institution which is located in Canada and which is recognized by the educational authorities of a province or territory of Canada or licensed under or maintained by an Act of Parliament of Canada or of the legislature of a province or territory of Canada.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete official name of the institution that will hold the domain name registration, without any abbreviations. A common abbreviation may follow the official name in parentheses. The Registrant name must be followed by the jurisdiction (e.g. name of province, municipality) in which the institution is accredited if not obvious from the Registrant&#39;s name."),
lang("Unincorporated Association"),
lang("This Registrant Type is principally intended for religious congregations, social and sports clubs and community groups, council (not registered) or society (not registered) which are based and operating in Canada. An unincorporated organization, association or club:&lt;br /&gt;(i) At least 80% of whose members: (A) are ordinarily resident in Canada (if such members are individuals); or (B) meet the requirements of any one of the following Registrant Types: Corporation (Canada or Canadian province or territory), Canadian citizen, Permanent Resident of Canada, Partnership Registered in Canada, Trust established in Canada, Legal Representative of a Canadian Citizen or Permanent Resident; and&lt;br /&gt;(ii) At least 80% of whose directors, officers, employees, managers, administrators or other representatives are ordinarily resident in Canada.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete name of the association that will hold the domain name registration, without any abbreviations. (A common abbreviation may follow the complete name in parentheses)."),
lang("Hospital"),
lang("A hospital which is located in Canada and which is licensed, authorized or approved to operate as a hospital under an Act of the legislature of a province or territory of Canada&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete official name of the hospital that will hold the domain name registration, without any abbreviations. (A common abbreviation may follow the complete name in parentheses.) The Registrant&#39;s name must be followed by the jurisdiction (eg. name of province) which accredited the hospital if not obvious from the Registrant&#39;s name."),
lang("Partnership"),
lang("A partnership, more than 66 2/3 per cent of whose partners meet the requirements of one of the following Registrant Types: Corporation (Canada or Canadian province or territory), Canadian citizen, Permanent Resident of Canada, Trust established in Canada or a Legal Representative of a Canadian Citizen or Permanent Resident, which is registered as a partnership under the laws of any province or territory of Canada.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the registered name of the partnership that will hold the domain name registration. The Registrant name must be followed by the jurisdiction of registration (eg. Alberta) and the registration number."),
lang("Trade-mark"),
lang("A Person which does not fall under any other registrant type, but which is the owner of a trade-mark which is the subject of a registration under the Trade-marks Act (Canada) R.S.C. 1985, c.T-13 as amended from time to time, but in this case such permission is limited to a request to register a .ca domain name consisting of or including the exact word component of that registered trade-mark.&lt;br /&gt;This Registrant Type is only intended for Registrants which do not meet the requirements associated with any other registrant type but which have a trade-mark registered in Canada. (Trade-marks subject of trade-mark applications and trade-marks registered in other jurisdictions, such as the United States, do not qualify.)&lt;br /&gt;The domain name to be registered must include the trade-mark. (eg. If the trade-mark is AVEA this type of registrant can register avea.ca or aveaisus.ca but not xyz.ca)."),
lang("Trade Union"),
lang("A trade union which is recognized by a labour board under the laws of Canada or any province or territory of Canada and which has its head office in Canada.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete official name of the trade union that will hold the domain name registration, without abbreviations. (A common abbreviation may follow the official name in parentheses.) The Registrant name must be followed by the jurisdiction in Canada which recognizes it (if it is not obvious from the Registrant&#39;s name.)"),
lang("Political Party"),
lang("A political party registered under a relevant electoral law of Canada or any province or territory of Canada&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete official name of the political party holding the domain name registration, without abbreviations. (A common abbreviation may follow the official name in parentheses.) The Registrant name must also by followed by the jurisdiction in Canada in which it is registered (if it is not obvious from the official name)."),
lang("Library, Archive or Museum"),
lang("An institution, whether or not incorporated, that:&lt;br /&gt;(i) is located in Canada; and&lt;br /&gt;(ii) is not established or conducted for profit or does not form part of, or is not administered or directly or indirectly controlled by, a body that is established or conducted for profit in which is held and maintained a collection of documents and other materials that is open to the public or to researchers.&lt;br /&gt;Requirements: The Registrant&#39;s name  must be the complete legal name of the institution which will hold the domain name registration without abbreviations. (A common abbreviation may follow the complete name in parentheses.)"),
lang("Trust"),
lang("A trust established and subsisting under the laws of a province or territory of Canada, more than 66 2/3 % of whose trustees meet the requirements of one of the following Registrant Types: Corporation (Canada or Canadian province or territory), Canadian citizen, Permanent Resident of Canada, or a Legal Representative of a Canadian Citizen or Permanent Resident.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete official name of the trust, without any abbreviations. (A common abbreviation may follow the official name in parentheses.) The Registrant name must also indicate the total percentage of the trustees that meet one or more of the following requirements: Canadian citizen, permanent resident, Canadian corporation, legal representative."),
lang("Aboriginal Peoples"),
lang("Any individual belonging to any Inuit, First Nation, Metis or other people indigenous to Canada.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the full legal name of the Aboriginal Person applying for the Registration as it would appear on a driver&#39;s license or other identification document issued by government.&lt;br /&gt;The Registrant may enter its full legal name followed by a space and &quot;o/a xxxx&quot; where &quot;o/a&quot; stands for &quot;Operating As&quot; and &quot;xxxx&quot; can be any alpha-numeric string designated by the applicant and subject to applicable rules and length restrictions (e.g. &quot;John Doe o/a Doe Consulting Group&quot;). The name may also be followed by a space and a degree granted to the registrant by a recognized degree granting institution or a recognized professional designation which the registrant has the right to use  (eg. PhD, MD, DDS.)&lt;br /&gt;Full legal names of individuals may only consist of alphabetic characters and the special characters: single quote mark(&#39;&#39;), hyphen(-), period(.).&lt;br/&gt;Groups: Any Inuit, First Nation, Metis or other people indigenous to Canada, and any collectivity of such Aboriginal peoples.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete official name of the indigenous people a collectivity of Aboriginal Persons or, if there is no official name, the name by which the collectivity is commonly known."),
lang("Indian Band"),
lang("Any Indian band as defined in the Indian Act, R.S.C. 1985, c. I-5, as amended from time to time, and any group of Indian bands;&lt;br /&gt;Requirements: The name of Registrant must be the Indian Band Name as registered with the Department of Indian and Northern Affairs, Canada."),
lang("Legal Representative"),
lang("An executor, administrator or other legal representative of a Person listed as a Canadian Citizen or Permanent Resident of Canada.&lt;br /&gt;Note: This registrant type is only available to a person or entity that has been appointed by legal process to represent an individual who is not competent to represent him or herself. It is not available to anyone who represents a Canadian or foreign corporation  in any capacity.&lt;br /&gt;Requirements: The Registrant&#39;s name must be the full legal name of the Canadian Citizen or Permanent Resident of Canada who is being represented as it would appear on a passport, driver&#39;s license or other government identification document. This must be followed by the full legal name and capacity of at least one of the official representatives. The representative should be identified as the administrative contact for these registrations."),
lang("Official Mark"),
lang("A Person which does not meet the requirements for any other Registrant Type, but which is a Person intended to be protected by Subsection 9(1) of the Trade-Marks Act (Canada) at whose request the Registrar of Trade-marks has published notice of adoption of any badge, crest, emblem, official mark or other mark pursuant to Subsection 9(1), but in this case such permission is limited to a request to register a .ca domain name consisting of or including the exact word component of such badge, crest, emblem, official mark or other mark in respect of which such Person requested publications.&lt;br /&gt;Notes: This registrant type is only intended for Registrants which do not meet the requirements associated with any other registrant type but which have an Official Mark registered in Canada. The domain name must include the official mark (eg. If the official mark is WIPO, the registrant can register wipo.ca but not intellectual-property.ca)&lt;br /&gt;Requirements: The Registrant&#39;s name must be the complete official name of the entity holding the domain name registration without any abbreviations. (A common abbreviation may follow the complete name in parentheses.) The registration number of the official mark must follow the Registrant Name."),
lang("The Queen"),
lang("Her Majesty Queen Elizabeth the Second and her successors. Requirements: The Registrant&#39;s name must be that of Her Majesty the Queen or, after a succession, the name of her successor."),
lang("Hide registrant data in CIRA WHOIS"),
lang("No"),
lang("Do not hide the registrant contact information in CIRA WHOIS."),
lang("Yes"),
lang("Hide the registrant contact information in Cira WHOIS (only available to individuals)."),
lang("The contact&#39;s preferred language for communication"),
lang("English"),
lang("Use English for Registry to Registrant communication"),
lang("French"),
lang("Use French for Registry to Registrant communication"),
lang("Version of the CIRA Registrant Agreement displayed and agreed to by the Registrant on the Registrar website"),
lang("2.0"),
lang("Current Version of Registrant Agreement"),
lang("Registrant has agreed to CIRA&#39;s Registrant Agreement"),
lang("&quot;You have read, understood and agree to the terms and conditions of the Registrant
Agreement, and that CIRA may, from time to time and at its discretion, amend any or all of
the terms and conditions of the Registrant Agreement, as CIRA deems appropriate, by
posting a notice of the changes on the CIRA website and by sending a notice of any
material changes to Registrant.&quot;&quot;You meet all the requirements of the Registrant Agreement to be a Registrant, to apply for
the registration of a Domain Name Registration, and to hold and maintain a Domain Name
Registration, including without limitation CIRA&#39;s Canadian Presence Requirements for
Registrants, at: www.cira.ca/assets/Documents/Legal/Registrants/CPR.pdf.&quot;&quot;CIRA will collect, use and disclose your personal information, as set out in CIRA&#39;s
Privacy Policy, at: www.cira.ca/assets/Documents/Legal/Registrants/privacy.pdf.&quot;"),
lang("Indicated professional association recognized by government body"),
lang("Registry Data Transfer Policy"),
lang("I AGREE"),
lang("I hereby agree that the Registry is entitled to transfer the data contained in this application to third parties (i) if ordered to do so by a public authority, carrying out its legitimate tasks; and (ii) upon demand of an ADR Provider as mentioned in section 16 of the Terms and Conditions which are published at www.eurid.eu; and (iii) as provided in Section 2 (WHOIS look-up facility) of the .eu Domain Name WHOIS Policy which is published at www.eurid.eu."),
lang("Tax ID. If the requester is an Italian natural person it contains his/her Codice Fiscale. 
For foreigners it can contain a  document number. For associations without VAT number and tax code must be equal to &quot;n.a.&quot;. 
In all the other cases must be equal to VAT number (in the 11 numbers format if Nationality=IT) or the numeric Codice Fiscale."),
lang("Codice Fiscale"),
lang("If the requester is an Italian natural person it contains his/her Codice Fiscale. 
For foreigners it can contain a  document number. For associations without VAT number and tax code must be equal to &quot;n.a.&quot;. 
In all the other cases must be equal to VAT number (in the 11 numbers format if Nationality=IT) or the numeric Codice Fiscale."),
lang("Type of Registrant Entity"),
lang("1. Italian and foreign natural persons"),
lang("Italian and foreign natural persons"),
lang("2. Companies/One Man Companies"),
lang("Companies/One Man Companies"),
lang("3. Freelance workers/professionals"),
lang("Freelance workers/professionals"),
lang("4. Non-Profit Organizations"),
lang("Non-Profit Organizations"),
lang("5. Public Organizations"),
lang("Public Organizations"),
lang("6. Other Subjects"),
lang("Other Subjects"),
lang("7. Foreigners who match 2-6"),
lang("Foreigners who match 2-6"),
lang("Allow the publication of contact&#39;s personal data"),
lang("Allow Publication"),
lang("Consent for Processing of Information"),
lang("Agree"),
lang("The interested party, after reading the above disclosure, gives consent to the processing of
information required for registration, as defined in the above disclosure.
Giving consent is optional, but if no consent is given, it will not be possible to finalize the
registration, assignment and management of the domain name."),
lang("Consent for Dissemination and Accessibility via the Internet"),
lang("The interested party, after reading the above disclosure, gives consent to the dissemination
and accessibility via the Internet, as defined in the disclosure above.
Giving consent is optional, but absence of consent does not allow the dissemination and
accessibility of Internet data."),
lang("Terms and Conditions"),
lang("The Registrant of the domain name in question, declares under their own responsibility that
they are:&lt;br&gt;
a) in possession of the citizenship or resident in a country belonging to the European
   Union (in the case of registration for natural persons);&lt;br&gt;
b) established in a country belonging to the European Union (in the case of registration
   for other organizations););&lt;br&gt;
c) aware and accept that the registration and management of a domain name is subject to
   the &quot;Rules of assignment and management of domain names in ccTLD. it&quot; and&quot;Regulations for the resolution of disputes in the ccTLD.it&quot; and their subsequent
   amendments;);&lt;br&gt;
d) entitled to the use and/or legal availability of the domain name applied for, and that
   they do not prejudice, with the request for registration, the rights of others;);&lt;br&gt;
e) aware that for the inclusion of personal data in the Database of assigned domain
   names, and their possible dissemination and accessibility via the Internet, consent
   must be given explicitly by ticking the appropriate boxes in the information below.
   See &quot;The policy of the .it Registry in the Whois Database&quot; on the website of the
   Registry (http://www.nic.it););&lt;br&gt;
f) aware and agree that in the case of erroneous or false declarations in this request, the
   Registry shall immediately revoke the domain name, or proceed with other legal
   actions. In such case the revocation shall not in any way give rise to claims against the
   Registry;);&lt;br&gt;
g) release the Registry from any liability resulting from the assignment and use of the
   domain name by the natural person that has made the request;);&lt;br&gt;
h) accept Italian jurisdiction and laws of the Italian State."),
lang("Explicit Acceptance of Registry Terms"),
lang("For explicit acceptance, the interested party declares that they:&lt;br&gt;
c) are aware and agree that the registration and management of a domain name is subject to
   the &quot;Rules of assignment and management of domain names in ccTLD.it&quot; and &quot;Regulations
   for the resolution of disputes in the ccTLD.it &quot;and their subsequent amendments;&lt;br&gt;
f) are aware and agree that in the case of erroneous or false declarations in this request, the
   Registry shall immediately revoke the domain name, or proceed with other legal actions. In
   such case the revocation shall not in any way give rise to claims against the Registry;&lt;br&gt;
g) release the Registry from any liability resulting from the assignment and use of the
   domain name by the natural person that has made the request;&lt;br&gt;
h) accept the Italian jurisdiction and laws of the Italian State."),
lang("Natural or Legal Person"),
lang("Natural Person"),
lang("Legal Person"),
lang("Username"),
lang("Password"),
lang("Email Address"),
lang("I declare that I am working on behalf of the following type of entity"),
lang("Economic Interest Group"),
lang("Association"),
lang("Sports Association"),
lang("Professional Association"),
lang("Savings Bank"),
lang("Community Property"),
lang("Community of Owners"),
lang("Order or Religious Institution"),
lang("Consulate"),
lang("Public Law Association"),
lang("Embassy"),
lang("Local Authority"),
lang("Sports Federation"),
lang("Foundation"),
lang("Mutual Insurance Company"),
lang("Regional Government Body"),
lang("Central Government Body"),
lang("Farm Partnership"),
lang("Public Limited Company"),
lang("Civil Society"),
lang("General Partnership"),
lang("General and Limited Partnership"),
lang("Cooperative"),
lang("Worker-owned Company"),
lang("Limited Company"),
lang("Spanish Office"),
lang("Temporary Alliance of Enterprises"),
lang("Worker-owned Limited Company"),
lang("Regional Public Entity"),
lang("National Public Entity"),
lang("Local Public Entity"),
lang("Others"),
lang("Designation of Origin Supervisory Council"),
lang("Entity Managing Natural Areas"),
lang("ID type"),
lang("Generic ID"),
lang("Generic ID document used for passports, company registration numbers and foreign documents"),
lang("VAT ID"),
lang("Spanish personal and company VAT ID card (NIF)"),
lang("Resident alien ID"),
lang("Spanish resident alien ID card (NIE)"),
lang("ID number"),
lang("I accept the .ES terms and conditions listed at: http://www.dominios.es/dominios/sites/default/files/files/T%C3%A9rminos%20y%20condiciones%20del%20_es%20%28ingl%C3%A9s%29.pdf"),
lang("I agree to the terms and conditions"),
lang("ID card or passport number of the admininstrative contact. You may create contacts for Spanish citizens using their passport.    In this case you should indicate “Others” as type of Identification Document and include the passport number.    Please remember that, in the event that the User may request a change of registrant, they should sign it with the copy of their passport"),
lang("ID type for Administrative Contact"),
lang("other (for contacts outside Spain)"),
lang("National Identity"),
lang("DNI/NIF (for spanish contacts)"),
lang("NIE (ID number for foreigners in Spain, composed of a letter at the beginning (usually X or Y), 7 numbers and a final letter, not hyphenated)"),
lang("Australian Business Number"),
lang("Australian Company Number"),
lang("Business Registration Number"),
lang("Trademark Number"),
lang("For individual: The corresponding ID-Card/Passport
For organization: The corresponding company registration or VAT-number "),
lang("Depending on the type of registrant, different extensions must be provided. "),
lang("Company"),
lang("Companies having their head office in the territory of the European Union"),
lang("Individual person responsible for the domain."),
lang("Bogus legal type to see if this works"),
lang("Corporation "),
lang("A corporation under the laws of Canada or any province or territory of Canada, Charities, Cooperative, Council.
Requirements: Registrant name must be the full legal name of the corporation and must be followed by the jurisdiction of incorporation (eg. Canada, Ontario, NWT...), unless it is obvious from the corporation&#39;s name. Canadian Internet Registration Authority (Canada). For Charities, the NFP should be included in the organization name. If this is a not-for-profit organization, you are also required to submit the registration number i.e.: 123456789 RR0001 "),
);

?>
