<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'pl', branch 'MOODLE_28_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Są nowe wpisy na forum';
$string['addanewdiscussion'] = 'Dodaj nowy temat dyskusji';
$string['addanewquestion'] = 'Dodaj nowe pytanie';
$string['addanewtopic'] = 'Dodaj nowy temat';
$string['advancedsearch'] = 'Zaawansowane szukanie';
$string['allforums'] = 'Wszystkie fora';
$string['allowdiscussions'] = 'Czy {$a} może wysyłać wiadomości na to forum?';
$string['allowsallsubscribe'] = 'W tym forum każdy może wybrać, czy subskrybować je czy nie.';
$string['allowsdiscussions'] = 'W tym forum każdy może utworzyć tylko jeden temat dyskusji.';
$string['allsubscribe'] = 'Subskrybuj wszystkie fora';
$string['allunsubscribe'] = 'Odwołaj subskrypcje wszystkich forów';
$string['alreadyfirstpost'] = 'To jest pierwszy wpis w dyskusji';
$string['anyfile'] = 'Jakikolwiek plik';
$string['areaattachment'] = 'Załączniki';
$string['areapost'] = 'Wiadomości';
$string['attachment'] = 'Załącznik';
$string['attachment_help'] = 'Opcjonalnie można dołączyć jeden lub więcej plików do wątku na forum. Jeśli dołączysz zdjęcie, zostanie ono wyświetlone po wiadomości.';
$string['attachmentnopost'] = 'Nie można wyeksportować załączników bez identyfikatora wpisu';
$string['attachments'] = 'Załączniki';
$string['attachmentswordcount'] = 'Załączniki i zliczanie słów';
$string['blockafter'] = 'Próg wpisów do blokowania';
$string['blockafter_help'] = 'To ustawienie określa maksymalną liczbę wpisów, które użytkownik może zamieścić na forum w danym okresie. Użytkownicy z opcją mod/forum: postwithoutthrottling są zwolnieni z tego ograniczenia.';
$string['blockperiod'] = 'Czas blokowania';
$string['blockperioddisabled'] = 'Nie blokuj';
$string['blockperiod_help'] = 'Studenci mogą mieć ograniczenie w ilości napisanych wpisów w danym przedziale czasowym. Użytkownicy z uprawnieniem od/forum:postwithoutthrottling są wyjęci spod tej zasady.';
$string['blogforum'] = 'Standardowe forum wyświetlane w układzie bloga';
$string['bynameondate'] = 'Napisane przez: {$a->name} ( {$a->date})';
$string['cannotadd'] = 'Nie można dodać do dyskusji na tym forum';
$string['cannotadddiscussion'] = 'Musisz być członkiem grupy aby dodać dyskusję do tego forum';
$string['cannotadddiscussionall'] = 'Nie masz uprawnień, aby dodać nową dyskusję dla wszystkich uczestników.';
$string['cannotaddsubscriber'] = 'Nie można dodać subskrybenta o identyfikatorze {$a} do tego forum!';
$string['cannotaddteacherforumto'] = 'Nie można dodać przekonwertowanego forum nauczycieli do sekcji 0 kursu';
$string['cannotcreatediscussion'] = 'Nie można utworzyć nowego wątku';
$string['cannotcreateinstanceforteacher'] = 'Nie można utworzyć nowego egzemplarza forum nauczycieli';
$string['cannotdeletepost'] = 'Nie możesz usunąć tego wpisu!';
$string['cannoteditposts'] = 'Nie możesz edytować wpisów innych osób!';
$string['cannotfinddiscussion'] = 'Nie można znaleźć dyskusji na tym forum';
$string['cannotfindfirstpost'] = 'Nie można znaleźć pierwszego wpisu na tym forum';
$string['cannotfindorcreateforum'] = 'Nie można znaleźć lub utworzyć głównego forum wiadomości dla tej witryny';
$string['cannotfindparentpost'] = 'Nie znaleziono głównego wpisu nadrzędnego w stosunku do wpisu {$a}';
$string['cannotmovefromsingleforum'] = 'Nie można przenieść dyskusji z forum prostej, pojedynczej dyskusji';
$string['cannotmovenotvisible'] = 'Forum jest niewidoczne';
$string['cannotmovetonotexist'] = 'Nie możesz przenieść do tego forum - ono nie istnieje!';
$string['cannotmovetonotfound'] = 'Docelowe forum nie zostało znalezione w tym kursie.';
$string['cannotmovetosingleforum'] = 'Nie można przenieść dyskusji do forum prostej, pojedynczej dyskusji';
$string['cannotremovesubscriber'] = 'Nie możesz usunąć subskrybenta o identyfikatorze {$a} z tego forum!';
$string['cannotreply'] = 'Nie możesz odpowiedzieć na ten wpis';
$string['cannotsplit'] = 'Dyskusje z tego forum nie mogą być rozdzielone';
$string['cannotsubscribe'] = 'Musisz być  członkiem grupy, aby subskrybować.';
$string['cannottrack'] = 'Nie można zatrzymać śledzenia tego forum';
$string['cannotunsubscribe'] = 'Nie można wypisać się z tego forum';
$string['cannotupdatepost'] = 'Nie możesz aktualizować tego wpisu';
$string['cannotviewpostyet'] = 'Nie możesz czytać pytań innych studentów w tej dyskusji, bo jeszcze nic nie napisałeś';
$string['cannotviewusersposts'] = 'Nie ma wpisów tego użytkownika, które możesz zobaczyć.';
$string['cleanreadtime'] = 'Zaznacz stare wpisy jako przeczytane w tej godzinie';
$string['clicktosubscribe'] = 'Nie subskrybujesz tej dyskusji. Kliknij, aby subskrybować.';
$string['clicktounsubscribe'] = 'Subskrybujesz tę dyskusję. Kliknij, aby zrezygnować z subskrypcji.';
$string['completiondiscussions'] = 'Student musi utworzyć dyskusję:';
$string['completiondiscussionsgroup'] = 'Wymagaj dyskusji';
$string['completiondiscussionshelp'] = 'wymaga się dyskusji, aby ukończyć';
$string['completionposts'] = 'Student musi rozpocząć dyskusję lub odpowiedzieć*';
$string['completionpostsgroup'] = 'Wymagaj wpisów';
$string['completionpostshelp'] = 'wymaga się dyskusji lub odpowiedzi, aby ukończyć';
$string['completionreplies'] = 'Student musi odpowiedzieć';
$string['completionrepliesgroup'] = 'Wymagaj odpowiedzi';
$string['completionreplieshelp'] = 'wymaga się odpowiedzi, aby ukończyć';
$string['configcleanreadtime'] = 'Godzina i dzień oczyszczania starych wpisów w tablicy przeczytanych';
$string['configdigestmailtime'] = 'Dla tych, którzy wybrali wysyłanie streszczenia codziennie mailem, można ustawić, o której godzinie codziennie streszczenie będzie wysyłane.';
$string['configdisplaymode'] = 'Domyślny tryb wyświetlania dyskusji, jeśli nie wybrano innego.';
$string['configenablerssfeeds'] = 'Umożliwia RSS feeds dla wszystkich forów dyskusyjnych. Musisz jednak i tak włączyć obsługę feeds manualnie dla każdego forum.';
$string['configenabletimedposts'] = 'Ustaw na \'tak\', jeśli chcesz zezwolić na ustawienie, kiedy ma być wysłany wpis do dyskusji (Eksperymentalne, jeszcze nie w pełni przetestowane!)';
$string['configlongpost'] = 'Każdy wpis o długości przekraczającej tą liczbę (nie uwzględniając kodu HTML) jest uważany za długi.';
$string['configmanydiscussions'] = 'Maksymalna ilość dyskusji pokazywanych na jednej stronie forum.';
$string['configmaxattachments'] = 'Domyślna maksymalna liczba załączników dozwolonych na jeden wpis.';
$string['configmaxbytes'] = 'Domyślna wielkość plików dla wszystkich załączników na tej stronie (chyba, że przedmiot bądź ustawienia strony nakładają jeszcze inne ograniczenia)';
$string['configoldpostdays'] = 'Wpis';
$string['configreplytouser'] = 'Czy wysłany wpis powinien zawierać email wysyłającego, tak aby mogli do niego osobiście odpowiedzieć (zamiast poprzez forum)? Nawet przy wyborze "Tak" użytkownicy mogą wybrać w swoich profilach, że chcą ukryć swój adres email.';
$string['configshortpost'] = 'Każdy wpis o długości mniejszej od tej liczby (nie uwzględniając kodu HTML) jest uważany za krótki';
$string['configtrackingtype'] = 'Domyślne ustawienia dla śledzenia odczytu.';
$string['configtrackreadposts'] = 'Ustaw "tak" jeżeli chcesz śledzić przeczytane/nieprzeczytane wpisy dla każdego użytkownika';
$string['configusermarksread'] = 'Jeżeli "tak" użytkownik musi sam zaznaczyć wpis jako przeczytany. Jeżeli "nie", to wpis wyświetlony jest zaznaczany jako przeczytany.';
$string['confirmsubscribe'] = 'Czy na pewno chcesz się zapisać na forum \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Czy chcesz subskrybować dyskusję \'{$a->discussion}\' na forum \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Czy na pewno chcesz się wypisać z forum \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Czy chcesz zrezygnować z subskrypcji dyskusji \'{$a->discussion}\' na forum \'{$a->forum}\'?';
$string['couldnotadd'] = 'Nie można dodać twojego wpisu z powodu nieznanego błędu';
$string['couldnotdeletereplies'] = 'Niestety, nie można było usunąć tego wpisu, gdyż inni użytkownicy już na niego odpowiedzieli.';
$string['couldnotupdate'] = 'Nie można zaktualizować twojego wpisu z powodu nieznanego błędu';
$string['delete'] = 'Usuń';
$string['deleteddiscussion'] = 'Usunięto temat dyskusji';
$string['deletedpost'] = 'Wpis został usunięty';
$string['deletedposts'] = 'Wpisy zostały usunięte';
$string['deleteoriginalonreply'] = 'Jeśli odpowiadasz bezpośrednio na ten post poprzez e-mail, prosimy o niedołączanie kopii postu.';
$string['deletesure'] = 'Czy masz pewność, że chcesz usunąć ten wpis?';
$string['deletesureplural'] = 'Czy na pewno chcesz usunąć ten wpis i wszystkie odpowiedzi? ({$a} wpisów)';
$string['digestmailheader'] = 'To jest twoje dzienne streszczenie wpisów z forum {$a->sitename}. Aby zmienić emailowe preferencje forum, idź do {$a->userprefs}.';
$string['digestmailpost'] = 'Zmień swoje preferencje streszczenia wiadomości na forum';
$string['digestmailprefs'] = 'profil użytkownika';
$string['digestmailsubject'] = '{$a}: streszczenie wpisów';
$string['digestmailtime'] = 'Godzina do wysłania emaili przeglądowych';
$string['digestsentusers'] = 'Wysłano do użytkownika {$a}';
$string['disallowsubscribe'] = 'Subskrypcje niedozwolone';
$string['disallowsubscribeteacher'] = 'Subskrypcje niedozwolone (nie dotyczy nauczycieli)';
$string['disallowsubscription'] = 'Subskrypcja';
$string['disallowsubscription_help'] = 'To forum zostało skonfigurowane w taki sposób, że nie można subskrybować tej dyskusji.';
$string['discussion'] = 'Temat';
$string['discussionmoved'] = 'Dyskusja ta została przeniesiona do \'{$a}\'.';
$string['discussionmovedpost'] = 'Ta dyskusja została przeniesiona do <a href="{$a->discusshref}">here</a> na forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nazwa dyskusji';
$string['discussionnownotsubscribed'] = '{$a->name} nie zostanie powiadomiona/y o nowych postach w \'{$a->discussion}\' dla forum \'{$a->forum}\'';
$string['discussionnowsubscribed'] = '{$a->name} zostanie powiadomiona/y o nowych postach w \'{$a->discussion}\' dla forum \'{$a->forum}\'';
$string['discussions'] = 'Dyskusje';
$string['discussionsstartedby'] = 'Dyskusje rozpoczęte przez {$a}';
$string['discussionsstartedbyrecent'] = 'Dyskusje rozpoczęte ostatnio przez {$a}';
$string['discussionsstartedbyuserincourse'] = 'Dyskusja rozpoczęta przez {$a->fullname} w {$a->coursename}';
$string['discussionsubscribestart'] = 'Wyślij mi powiadomienia o nowych postach w tej dyskusji';
$string['discussionsubscribestop'] = 'Nie chcę, aby otrzymywać powiadomień o nowych postach w tej dyskusji';
$string['discussionsubscription'] = 'Subskrypcja dyskusja';
$string['discussthistopic'] = 'Podyskutuj na ten temat';
$string['displayend'] = 'Pokaż koniec';
$string['displayend_help'] = 'To ustawienie określa, czy wpisy na forum powinny być ukryte po określonej dacie. Należy pamiętać, że administratorzy mogą zawsze przeglądać wpisy na forum.';
$string['displaymode'] = 'Sposób wyświetlania';
$string['displayperiod'] = 'Czas wyświetlania';
$string['displaystart'] = 'Początek wyświetlania';
$string['displaystart_help'] = 'To ustawienie określa, czy wpisy na forum powinny być wyświetlane z określoną datą. Należy pamiętać, że administratorzy mogą zawsze przeglądać wpisy na forum.';
$string['displaywordcount'] = 'Wyświetl liczbę słów';
$string['displaywordcount_help'] = 'Jeśli to ustawienie jest zaznaczone na "Tak" wtedy pod każdym wpisem wyświetlona jest liczba użytych słów.';
$string['eachuserforum'] = 'Każdy wysyła jeden temat dyskusji';
$string['edit'] = 'Edycja';
$string['editedby'] = 'Edytowany przez {$a->name} - pierwotnie wysłano {$a->date}';
$string['editedpostupdated'] = 'Wpis {$a} został zaktualizowany';
$string['editing'] = 'Edycja';
$string['emaildigest_0'] = 'Otrzymasz jeden e-mail na post.';
$string['emaildigestdefault'] = 'Domyślne ({$a})';
$string['emaildigestoffshort'] = 'Bez streszczenia';
$string['emaildigestsubjectsshort'] = 'Tylko tematy';
$string['emaildigesttype_help'] = 'Typ powiadomienia, które zostanie wysłane z wybranego forum.

* Domyślne - ustawienia zgodne z tymi, które zostały nadane w profilu użytkownika. Zmiana typu powiadomienia w profilu wpływa na sposób wysyłania powiadomień z danego forum.
* Bez streszczenia - zostanie wysłany jeden email na każdy wpis
* Pełny - jeden email dziennie z wszystkimi wpisami
* Tematy - codzienny email tylko z tematami wpisów';
$string['emptymessage'] = 'Coś nie tak z twoim wpisem. Być może był  pusty lub załącznik był zbyt duży. Twoje zmiany nie zostały zapisane.';
$string['erroremptymessage'] = 'Wiadomość nie może być pusta';
$string['erroremptysubject'] = 'Tytuł wpisu nie może być pusty.';
$string['errorenrolmentrequired'] = 'Musisz być zapisany na ten kurs, by mieć dostęp do tej zawartości';
$string['errorwhiledelete'] = 'Wystąpił błąd podczas usuwania zapisu.';
$string['eventdiscussioncreated'] = 'Utworzono wątek';
$string['eventdiscussiondeleted'] = 'Usunięto wątek';
$string['eventdiscussionmoved'] = 'Dyskusja przeniesiona';
$string['eventpostcreated'] = 'Post utworzony';
$string['eventpostdeleted'] = 'Post usunięty';
$string['eventpostupdated'] = 'Post zaktualizowany';
$string['everyonecanchoose'] = 'Każdy może się zapisać na forum';
$string['everyonecannowchoose'] = 'Każdy może teraz wybrać subskrypcję';
$string['everyoneisnowsubscribed'] = 'Wszyscy subskrybują to forum';
$string['everyoneissubscribed'] = 'Każdy jest zapisany na to forum';
$string['existingsubscribers'] = 'Istniejący subskrybenci';
$string['exportdiscussion'] = 'Eksportuj całą dyskusję';
$string['forcesubscribed'] = 'To forum wymusza subskrypcję u wszystkich.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Dodaj nowy dział';
$string['forum:addnews'] = 'Dodaj wiadomość';
$string['forum:addquestion'] = 'Dodaj pytanie';
$string['forum:allowforcesubscribe'] = 'Pozwól na wymuszenie zapisów';
$string['forumauthorhidden'] = 'Autor (ukryty)';
$string['forumblockingalmosttoomanyposts'] = 'Zbliżasz się do progu liczby wpisów. Napisałeś {$a->numposts}  wpisów w czasie {$a->blockperiod}  a limit to {$a->blockafter}  wpisów.';
$string['forumbodyhidden'] = 'Nie możesz oglądać tej dyskusji, prawdopodobnie dlatego, że jeszcze w niej nic nie napisałeś, maksymalny czas edycji jeszcze nie minął, dyskusja nie rozpoczęła się lub wygasła.';
$string['forum:createattachment'] = 'Utworzyć załączniki';
$string['forum:deleteanypost'] = 'Usunąć każdy wpis (kiedykolwiek umieszczony)';
$string['forum:deleteownpost'] = 'Usunąć własne wpisy';
$string['forum:editanypost'] = 'Modyfikować każdy wpis';
$string['forum:exportdiscussion'] = 'Eksportuj całą dyskusję';
$string['forum:exportownpost'] = 'Eksportuj własne wpisy';
$string['forum:exportpost'] = 'Eksport wpisów';
$string['forumintro'] = 'Wstęp';
$string['forum:managesubscriptions'] = 'Zarządzać subskrypcjami';
$string['forum:movediscussions'] = 'Przesunąć dyskusje';
$string['forumname'] = 'Nazwa Forum';
$string['forumposts'] = 'Wpisy forum';
$string['forum:postwithoutthrottling'] = 'Wyjątek od tego limitu';
$string['forum:rate'] = 'Ocenić wpisy';
$string['forum:replynews'] = 'Odpowiedzieć na aktualności';
$string['forum:replypost'] = 'Odpowiedzieć na wpis';
$string['forums'] = 'Fora dyskusyjne';
$string['forum:splitdiscussions'] = 'Podzielić dyskusje';
$string['forum:startdiscussion'] = 'Rozpocząć nową dyskusję';
$string['forumsubjecthidden'] = 'Tytuł (ukryty)';
$string['forumtracked'] = 'Nieprzeczytane wpisy są śledzone';
$string['forumtrackednot'] = 'Nieprzeczytane wpisy nie są śledzone';
$string['forumtype'] = 'Rodzaj forum';
$string['forumtype_help'] = '<P ALIGN=CENTER><B>Rodzaje forów</B></P>

<P>Można wybrać spośród kilku następujących rodzajów forów:</P>

<P><B>Pojedyncza prosta dyskusja</B> - jeden temat, wszystko na jednej stronie. Opcja ta jest przydatna w przypadku krótkich dyskusji skupiających się na określonym temacie.</P>

<P><B>Forum standardowe do użytku ogólnego</B> - otwarte forum, na którym każdy może w każdej chwili rozpocząć dyskusję na nowy temat. Jest to najbardziej odpowiednie forum dla użytku ogólnego.</P>

<P><B>Każda osoba przesyła jeden temat dyskusji</B> - każda osoba może przesłać tylko jeden nowy temat dyskusji (ale wszyscy mogą odpowiadać). Jest to opcja przydatna w przypadku gdy chcesz aby każdy ze studentów rozpoczął dyskusję na temat np. ich refleksji dotyczących tematu tygodnia, a wszyscy inni użytkownicy mają się wypowiedzieć.</P>

<P>(Więcej możliwości pojawi się w przyszłych wersjach Moodle)</P>';
$string['forum:viewallratings'] = 'Zobacz wszystkie, poszczególne oceny wystawione przez użytkowników';
$string['forum:viewanyrating'] = 'Przeglądać dowolne oceny';
$string['forum:viewdiscussion'] = 'Przeglądać dyskusje';
$string['forum:viewhiddentimedposts'] = 'Zobacz ukryte wpisy z ustawionym czasem wysłania';
$string['forum:viewqandawithoutposting'] = 'Pokazuj pytania i odpowiedzi również osobom które nie odpowiedziały';
$string['forum:viewrating'] = 'Wyświetl całkowitą otrzymaną ocenę';
$string['forum:viewsubscribers'] = 'Przeglądać subskrybentów';
$string['generalforum'] = 'Forum standardowe do użytku ogólnego';
$string['generalforums'] = 'Fora ogólne';
$string['inforum'] = 'w {$a}';
$string['introblog'] = 'Wpisy na tym forum zostały skopiowane automatycznie z blogów użytkowników tego kursu, ponieważ te wpisy na blogach nie są już dostępne';
$string['intronews'] = 'Wiadomości i ogłoszenia';
$string['introsocial'] = 'Forum otwarte do dyskusji na dowolny temat';
$string['introteacher'] = 'Forum wyłącznie dla prowadzących';
$string['invalidaccess'] = 'Ta strona nie była prawidłowo dostępna';
$string['invaliddiscussionid'] = 'ID dyskusji było nieprawidłowe lub już nie istnieje';
$string['invalidforcesubscribe'] = 'Nieprawidłowy tryb wymuszenia subskrypcji';
$string['invalidforumid'] = 'Identyfikator forum był niepoprawny';
$string['invalidparentpostid'] = 'Identyfikator nadrzędnego wpisu był niepoprawny';
$string['invalidpostid'] = 'Nieprawidłowy identyfikator wpisu - {$a}';
$string['lastpost'] = 'Ostatni wpis';
$string['learningforums'] = 'Forum dydaktyczne';
$string['longpost'] = 'Długi wpis';
$string['mailnow'] = 'Napisz teraz';
$string['manydiscussions'] = 'Dyskusji na stronę';
$string['markalldread'] = 'Ustaw wszystkie wpisy w tej dyskusji jako przeczytane';
$string['markallread'] = 'Ustaw wszystkie wpisy w tym forum jako przeczytane';
$string['markread'] = 'Przeczytane';
$string['markreadbutton'] = 'Przeczytane';
$string['markunread'] = 'Nieprzeczytane';
$string['markunreadbutton'] = 'Nieprzeczytane';
$string['maxattachments'] = 'Maksymalna liczba załączników';
$string['maxattachments_help'] = 'To ustawienie określa maksymalną liczbę plików, które mogą być dołączone do wpisu na forum.';
$string['maxattachmentsize'] = 'Maksymalna wielkość załącznika';
$string['maxattachmentsize_help'] = '<P ALIGN=CENTER><B>Maksymalna wielkość załącznika</B></P>

<P>Maksymalna wielkość załącznika jest określana przez osobę, która otwiera forum.</p>

<P>Czasami udaje się przesłać plik większy niż określony w tym parametrze, jednakże
ten plik nie zostanie zachowany na serwerze i prawdopodobnie zostanie wyświetlony
komunikat o wystąpieniu błędu.</p>';
$string['maxtimehaspassed'] = 'Niestety, maksymalny czas dozwolony na edycję tego wpisu ({$a}) minął!';
$string['message'] = 'Wiadomość';
$string['messageprovider:digests'] = 'Streszczenie wiadomości z subskrybowanego forum';
$string['messageprovider:posts'] = 'Wpisy z subskrybowanego forum';
$string['missingsearchterms'] = 'Następujące terminy wyszukiwania pojawiają się tylko w markowaniu HTML dla tej wiadomości';
$string['modeflatnewestfirst'] = 'Wyświetl odpowiedzi płasko, z najnowszymi na początku';
$string['modeflatoldestfirst'] = 'Wyświetl odpowiedzi płasko, z najdawniejszymi na początku';
$string['modenested'] = 'Wyświetl odpowiedzi tematycznie';
$string['modethreaded'] = 'Wyświetl odpowiedzi wątkami';
$string['modulename'] = 'Forum';
$string['modulename_help'] = '<P>Ten moduł może być najważniejszy - właśnie w nim odbywa się większość dyskusji.
   Fora mogą posiadać różną strukturę i mogą umożliwiać ocenę każdego postu przez współuczestników.
   Posty mogą być przeglądane w różnych formatach i mogą zawierać załączniki.
   Uczestnicy, którzy są subskrybentami forum otrzymają pocztą elektroniczną kopie każdego nowego postu. Prowadzący może narzucić subskrypcję wszystkim uczestnikom.</P>';
$string['modulenameplural'] = 'Fora dyskusyjne';
$string['more'] = 'Więcej';
$string['movedmarker'] = '(Przesunięte)';
$string['movethisdiscussionto'] = 'Przenieś tę dyskusję do ...';
$string['mustprovidediscussionorpost'] = 'Do eksportu musisz podać id dyskusji lub wpisu';
$string['namenews'] = 'Forum aktualności';
$string['namenews_help'] = 'Forum "aktualności" jest specjalnym forum tworzonym automatycznie w każdym kursie, może być tylko jedno takie forum w kursie. W tym forum pisać mogą jedynie nauczyciele i administrator. Najnowsze wpisy z tego forum wyświetlane są w bloku "Najnowsze wiadomości"';
$string['namesocial'] = 'Forum towarzyskie';
$string['nameteacher'] = 'Forum nauczycielskie';
$string['newforumposts'] = 'Nowe wpisy na forum';
$string['nextdiscussiona'] = 'Następna dyskusja: {$a}';
$string['noattachments'] = 'Brak załączników do tego wpisu';
$string['nodiscussions'] = 'Nie ma żadnych tematów na tym forum';
$string['nodiscussionsstartedby'] = 'Użytkownik {$a} nie rozpoczął żadnych dyskusji';
$string['nodiscussionsstartedbyyou'] = 'Nie rozpocząłeś jeszcze żadnej dyskusji';
$string['noguestpost'] = 'Niestety goście nie mogą zabierać głosu na tym forum';
$string['noguesttracking'] = 'Niestety goście nie mogą zmienić opcji obserwowania wpisów.';
$string['nomorepostscontaining'] = 'Nie znaleziono więcej wpisów zawierających \'{$a}\'';
$string['nonews'] = 'Nie umieszczono jeszcze żadnych nowości';
$string['noonecansubscribenow'] = 'Subskrypcje są teraz niedozwolone';
$string['nopermissiontosubscribe'] = 'Nie masz uprawnień do przeglądania subskrybentów forum';
$string['nopermissiontoview'] = 'Nie masz uprawnień do zobaczenia tego wpisu';
$string['nopostforum'] = 'Niestety, nie możesz publikować wpisów w tym forum';
$string['noposts'] = 'Brak wpisów';
$string['nopostsmadebyuser'] = '{$a} nie dokonał żadnych wpisów';
$string['nopostsmadebyyou'] = 'Nie dokonano żadnych wpisów';
$string['noquestions'] = 'Na tym forum nie ma jeszcze wpisów';
$string['nosubscribers'] = 'Nikt jeszcze nie zapisał się na to forum';
$string['notexists'] = 'Dyskusja już nie istnieje';
$string['nothingnew'] = 'nic nowego dla {$a}';
$string['notingroup'] = 'Musisz być zapisany do grupy aby móc przeglądać to forum.';
$string['notinstalled'] = 'Moduł forum nie jest zainstalowany';
$string['notpartofdiscussion'] = 'Ten wpis nie jest częścią dyskusji!';
$string['notrackforum'] = 'Nie pokazuj nieprzeczytanych wpisów';
$string['notsubscribed'] = 'Subskrybuj';
$string['noviewdiscussionspermission'] = 'Nie masz uprawnień do przeglądania dyskusji na tym forum';
$string['nowallsubscribed'] = 'Wszystkie fora w {$a} są zajęte';
$string['nowallunsubscribed'] = 'Wszystkie fora w {$a} nie są zajęte';
$string['nownotsubscribed'] = '{$a->name} NIE będzie otrzymywać kopii nowych wpisów na \'{$a->forum}\' pocztą elektroniczną.';
$string['nownottracking'] = '{$a->name} nie obserwuje nieprzeczytanych wpisów na {$a->forum}';
$string['nowsubscribed'] = '{$a->name} będzie otrzymywać kopie \' nowych wpisów {$a->forum}\' pocztą elektroniczną.';
$string['nowtracking'] = '{$a->name} obserwuje \'{$a->forum}\'.';
$string['numposts'] = '{$a} wpisów';
$string['olderdiscussions'] = 'Starsze dyskusje';
$string['oldertopics'] = 'Starsze tematy';
$string['oldpostdays'] = 'Oznacz jako przeczytane po ...';
$string['overviewnumpostssince'] = '{$a} wpisów od ostatniego logowania';
$string['overviewnumunread'] = '{$a} nie czytanych';
$string['page-mod-forum-discuss'] = 'Strona z wątkiem dyskusji modułu Forum dyskusyjne';
$string['page-mod-forum-view'] = 'Strona główna modułu Forum dyskusyjne';
$string['page-mod-forum-x'] = 'Jakakolwiek strona modułu Forum dyskusyjne';
$string['parent'] = 'Przejdź do wiadomości wyżej („parent”)';
$string['parentofthispost'] = 'Wpis nadrzędny';
$string['pluginadministration'] = 'Administracja forum';
$string['pluginname'] = 'Forum';
$string['postadded'] = 'Twój wpis został dodany. <br />Jeżeli chcesz coś jeszcze zmienić masz {$a} na edycję.';
$string['postaddedsuccess'] = 'Wpis został dodany.';
$string['postaddedtimeleft'] = 'Masz {$a}, aby go edytować, jeśli chcesz wprowadzić jakieś zmiany.';
$string['postbyuser'] = '{$a->post} utworzony przez  {$a->user}';
$string['postincontext'] = 'Zobacz ten wpis w kontekście';
$string['postmailinfo'] = 'To jest kopia wiadomości wysłanej przez serwis  {$a}. Aby dodać odpowiedź poprzez stronę WWW kliknij poniższy link:';
$string['postmailnow'] = '<p>Ten wpis zostanie natychmiast wysłany do wszystkich użytkowników forum</p>';
$string['postrating1'] = 'Demonstruje głównie poznawanie odrębne';
$string['postrating2'] = 'Demonstruje w równym stopniu poznawanie odrębne i powiązane';
$string['postrating3'] = 'Demonstruje głównie poznawanie powiązane';
$string['posts'] = 'Wpisy';
$string['postsmadebyuser'] = 'Wpis utworzony przez {$a}';
$string['postsmadebyuserincourse'] = 'Wpis utworzony przez {$a->fullname} w {$a->coursename}';
$string['posttoforum'] = 'Wyślij wpis na forum';
$string['postupdated'] = 'Wpis został zaktualizowany';
$string['potentialsubscribers'] = 'Potencjalni subskrybenci';
$string['processingdigest'] = 'Przetwarzanie streszczenia maili użytkownika {$a}';
$string['processingpost'] = 'Wpis {$a} jest w trakcie przetwarzania';
$string['prune'] = 'Zerwij';
$string['prunedpost'] = 'Z tego wpisu została utworzona nowa dyskusja';
$string['pruneheading'] = 'Rozdziel tą dyskusję i przenieś ten wpis do nowej dyskusji';
$string['qandaforum'] = 'Forum pytań i odpowiedzi';
$string['qandanotify'] = 'To jest forum Pytań i odpowiedzi. Aby zobaczyć odpowiedzi innych osób, musisz najpierw sam udzielić odpowiedzi.';
$string['re'] = 'Odp:';
$string['readtherest'] = 'Przeczytaj resztę tematu';
$string['replies'] = 'Odpowiedzi';
$string['repliesmany'] = '{$a} odpowiedzi  (jak dotąd)';
$string['repliesone'] = '{$a} odpowiedź (jak dotąd)';
$string['reply'] = 'Odpowiedz';
$string['replyforum'] = 'Odpowiedz forum';
$string['replytouser'] = 'Użyj adresu e-mail w odpowiedzi';
$string['resetforums'] = 'Usuń wpisy z';
$string['resetforumsall'] = 'Usuń wszystkie wpisy';
$string['resetsubscriptions'] = 'Usuń wszystkie subskrypcje forum';
$string['resettrackprefs'] = 'Usuń wszystkie preferencje śledzenia forum';
$string['rssarticles'] = 'Liczba ostatnich artykułów RSS ';
$string['rssarticles_help'] = '<P ALIGN=CENTER><B>Liczba artykułów w RSS</B></P>

<P>Ta opcja pozawala ustalić liczbę artykułów w RSS Feed.

<P>Liczba pomiędzy 5 a 20 jest zwykle odpowiednia. Zwiększ ją, jesli forum jest bardzo aktywne.';
$string['rsssubscriberssdiscussions'] = 'Kanał RSS dyskusji';
$string['rsssubscriberssposts'] = 'Kanał RSS wpisów';
$string['rsstype'] = 'Kanał RSS dla tej aktywności';
$string['rsstype_help'] = '<P ALIGN=CENTER><B>RSS feed dla tego forum</B></P>

<P>Ta opcja włącza RSS feeds w tym forum.

<P>Możesz wybrać jeden z dwóch rodzajów forum:

<UL>
<LI><B>Dyskusja:</B> W tej opcji zawarte będą nowe dyskusje z ich pierwszymi wpisami.

<LI><B>Posty:</B> W tej opcji zawarty będzie każdy wpis tego forum.
</UL>';
$string['search'] = 'Szukaj';
$string['searchdatefrom'] = 'Wpis nowszy niż';
$string['searchdateto'] = 'Wpis starszy niż';
$string['searchforumintro'] = 'Wprowadź szukane słowo/słowa. Możesz uzupełnić jedno lub więcej pól.';
$string['searchforums'] = 'Szukaj w forach';
$string['searchfullwords'] = 'Ze słowami';
$string['searchnotwords'] = 'Bez następujących słów';
$string['searcholderposts'] = 'Przeszukaj starsze wpisy...';
$string['searchphrase'] = 'Ta fraza musi pojawić się we wpisie';
$string['searchresults'] = 'Szukaj w rezultatach';
$string['searchsubject'] = 'Słowa w polu tytuł';
$string['searchuser'] = 'Słowa w polu autor';
$string['searchuserid'] = 'Id autora';
$string['searchwhichforums'] = 'Wybierz forum';
$string['searchwords'] = 'Słowa które mają wystąpić we wpisach';
$string['seeallposts'] = 'Pokaż wszystkie wpisy tego użytkownika';
$string['shortpost'] = 'Krótki wpis';
$string['showsubscribers'] = 'Wyświetl/modyfikuj użytkowników zapisanych na forum';
$string['singleforum'] = 'Pojedyncza prosta dyskusja';
$string['smallmessage'] = '{$a->user} napisał w {$a->forumname}';
$string['startedby'] = 'Rozpoczęty przez';
$string['subject'] = 'Temat';
$string['subscribe'] = 'Zapisz się na to forum';
$string['subscribeall'] = 'Zapisz wszystkich do tego forum';
$string['subscribed'] = 'Zapisany na forum';
$string['subscribeenrolledonly'] = 'Tylko zapisani użytkownicy mogą subskrybować powiadomienia o nowych wpisach na forum.';
$string['subscribenone'] = 'Wypisz wszystkich z tego forum';
$string['subscribers'] = 'Zapisani na forum';
$string['subscribersto'] = 'Zapisani na \'{$a}\'';
$string['subscribestart'] = 'Przesyłaj mi kopie wpisów z tego forum pocztą elektroniczną';
$string['subscribestop'] = 'Nie chcę otrzymywać kopii wpisów z tego forum';
$string['subscription'] = 'Zapisanie się na forum';
$string['subscriptionandtracking'] = 'Subskrypcja i obserwacja';
$string['subscriptionauto'] = 'Automatyczna subskrypcja';
$string['subscriptiondisabled'] = 'Subskrypcja wyłączona';
$string['subscriptionforced'] = 'Wymuś subskrypcję';
$string['subscription_help'] = '<P ALIGN=CENTER><B>Subskrypcja (zapis na) forum</B></P>

<P>Każda osoba, która zapisze się na dane forum otrzyma pocztą elektroniczną kopie wszystkich wpisów do tego forum (wpisy wysyłane są po upływie około <?PHP echo $CFG->maxeditingtime/60 ?> minut po ich napisaniu). </P>

<P>Na ogół każdy może samodzielnie zdecydować czy chce zapisać się na dane forum.</P>

<P>W przypadku jednak gdy prowadzący wymusi subskrypcję danego forum, wybór nie jest możliwy i wszystkie osoby w grupie będą otrzymywać kopie wpisów.</P>

<P>Jest to szczególnie przydatne w przypadku forum Aktualności oraz na początku kursu zanim wszyscy uczestnicy zorientują się, że mogą samodzielnie zapisać się na fora.</P>';
$string['subscriptionmode'] = 'Tryb subskrypcji';
$string['subscriptionmode_help'] = 'Gdy ktoś jest zapisany na forum, będzie otrzymywał
na swój adres e-mail kopie każdego wpisu wysłanego na to forum.

Są 4 tryby subskrypcji:

* Subskrypcja  opcjonalna - Uczestnicy mogą wybrać czy chcą być zapisani
* Subskrybcja wymuszona - Wszyscy są subskrybentami i nie mogą zrezygnować z subskrypcji
* Automatyczna subskrypcja - Każdy początkowo jest zapisany, ale może zrezygnować z subskrypcji
* Subskrypcja wyłączona - nie można subskrybować forum';
$string['subscriptionoptional'] = 'Subskrypcja opcjonalna';
$string['subscriptions'] = 'Zapisy na fora';
$string['thisforumisthrottled'] = 'To forum ma ograniczoną liczbę wpisów, które można napisać w określonym czasie – jest to ustawione na  {$a->blockafter} wpis(ów) w {$a->blockperiod}';
$string['timedposts'] = 'Wpisy przygotowane do wysłania';
$string['timestartenderror'] = 'Końcowa data nie może być późniejsza niż początkowa';
$string['trackforum'] = 'Pokaż nieprzeczytane wpisy';
$string['tracking'] = 'Obserwuj';
$string['trackingoff'] = 'Wyłącz';
$string['trackingon'] = 'Włącz';
$string['trackingoptional'] = 'Opcjonalnie';
$string['trackingtype'] = 'Przeczytać obserwacje dla tego forum?';
$string['trackingtype_help'] = '<p>Jeżeli opcja obserwowania jest włączona, użytkownik może obserwować przeczytane i nieprzeczytane wiadomości w forach i dyskusjach. Prowadzący może wymusić obserwowanie forum używając tego ustawienia. </p>

<p>Są trzy możliwe opcje do ustawienia:
 <ul>
<li> Opcjonalnie [domyślny ]: studenci mogą włączać i wyłączać obserwowanie forum.</li>
<li>Wyłącz: Obserwowanie forum jest zawsze wyłączone.</li></ul></p>
<li>Włącz: Obserwowanie forum jest zawsze włączone.</li>';
$string['unread'] = 'Nieprzeczytane';
$string['unreadposts'] = 'Nieprzeczytane wpisy';
$string['unreadpostsnumber'] = '{$a} nieprzeczytanych wpisów';
$string['unreadpostsone'] = '1 nieprzeczytany wpis';
$string['unsubscribe'] = 'Wypisz się z tego forum';
$string['unsubscribeall'] = 'Wypisz się ze wszystkich forów';
$string['unsubscribeallconfirm'] = 'Jesteś teraz zapisany do {$a} forów dyskusyjnych. Czy rzeczywiście chcesz się wypisać ze wszystkich i wyłączyć autozapisywanie się do for w których piszesz?';
$string['unsubscribealldone'] = 'Wszystkie twoje subskrypcje zostały anulowane. Możesz jednak otrzymywać e-maile z forów dyskusyjnych, w których zapisanie jest obowiązkowe. Jeśli nie chcesz otrzymywać żadnych wpisów z forów dyskusyjnych możesz wyłączyć e-mail w swoim profilu.';
$string['unsubscribeallempty'] = 'Do żadnego forum nie jesteś zapisany.
Jeśli nie chcesz otrzymywać żadnych informacji z tego serwera, możesz wyłączyć e-mail w swoim profilu.';
$string['unsubscribed'] = 'Wypisany z forum';
$string['unsubscribediscussion'] = 'Wypisz się z tej dyskusji';
$string['unsubscribeshort'] = 'Wypisz';
$string['usermarksread'] = 'Ręczne zaznaczanie przeczytanych wpisów';
$string['viewalldiscussions'] = 'Zobacz wszystkie dyskusje';
$string['warnafter'] = 'Ostrzeżenie o progu wpisów';
$string['warnafter_help'] = 'Studenci mogą otrzymywać ostrzeżenie, gdy zbliżają się do maksymalnej liczby wpisów dozwolonych w danym okresie. Tu podajemy liczbę wpisów, po których studenci są ostrzegani. Użytkownicy z uprawnieniem mod/forum:postwithoutthrottling są zwolnieni z limitów wpisów.';
$string['warnformorepost'] = 'Ostrzeżenie! Jest więcej niż jedna dyskusja na tym forum - użyto najnowszej';
$string['yournewquestion'] = 'Twoje nowe pytanie';
$string['yournewtopic'] = 'Twoja nowa dyskusja';
$string['yourreply'] = 'Twoja odpowiedź';
