<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'pl', branch 'MOODLE_28_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Masz nowe zadanie, które wymaga Twojej uwagi.';
$string['addattempt'] = 'Zezwalaj na inną próbę';
$string['addnewattempt'] = 'Dodaj odpowiedź';
$string['addnewattemptfromprevious'] = 'Dodaj nową próbę na podstawie poprzedniego zgłoszenia';
$string['addnewattemptfromprevious_help'] = 'To skopiuje zawartość twojego poprzedniego zgłoszenia do nowego zgłoszenia nad którym będziesz mógł pracować';
$string['addnewattempt_help'] = 'Utworzy nowe czyste zgłoszenie, nad którym będziesz mógł pracować.';
$string['addsubmission'] = 'Dodaj rozwiązanie';
$string['allocatedmarker'] = 'Przydzielona osoba oceniająca';
$string['allocatedmarker_help'] = 'Osoba oceniająca, która została przydzielona do tego rozwiązania';
$string['allowsubmissions'] = 'Pozwól użytkownikom nadal wysyłać odpowiedzi na to zadanie.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Szczegóły zadania oraz możliwość rozwiązania będzie dostępna od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Zezwól na przesyłanie rozwiązań od';
$string['allowsubmissionsfromdate_help'] = 'Jeśli opcja jest włączona, studenci nie będą mogli przesyłać rozwiązań przed wybraną datą. W przeciwnym wypadku studenci będą mogli rozwiązywać zadanie od momentu utworzenia zadania.';
$string['allowsubmissionsfromdatesummary'] = 'Rozwiązania tego zadania będzie można przesyłać od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Pozwól na ponowne przesyłanie rozwiązań';
$string['alwaysshowdescription'] = 'Zawsze udostępniaj treść zadania';
$string['alwaysshowdescription_help'] = 'Jeśli opcja jest wyłączona, treść zadania będzie widoczna dopiero po dacie rozpoczęcia zadania.';
$string['applytoteam'] = 'Zastosuj oceny i informacje zwrotne dla całej grupy';
$string['assign:addinstance'] = 'Dodaj nowe zadanie';
$string['assign:editothersubmission'] = 'Edytuj zadania innego studenta';
$string['assign:exportownsubmission'] = 'Eksportuj własne zadania';
$string['assignfeedback'] = 'Plugin informacji zwrotnych';
$string['assignfeedbackpluginname'] = 'Plugin informacji zwrotnych';
$string['assign:grade'] = 'Oceń zadanie';
$string['assign:grantextension'] = 'Przedłużenie terminu oddania';
$string['assignmentisdue'] = 'Zadanie jest zaległe';
$string['assignmentmail'] = '{$a->grader} przesłał komentarz do Twojego zadania \'{$a->assignment}\' Możesz go zobaczyć tutaj: {$a->url}';
$string['assignmentmailhtml'] = '{$a->grader} przesłał komentarz do Twojego zadania \'<i>{$a->assignment}</i>\'<br /><br /> Możesz go zobaczyć <a href="{$a->url}">tutaj</a>.';
$string['assignmentmailsmall'] = '{$a->grader} przesłał komentarz do Twojego zadania \'{$a->assignment}\' Możesz go zobaczyć przy oddanym zadaniu.';
$string['assignmentname'] = 'Nazwa zadania';
$string['assignmentplugins'] = 'Pluginy modułu Zadanie';
$string['assignmentsperpage'] = 'Liczba zadań na stronę';
$string['assign:revealidentities'] = 'Odkrywanie tożsamości studenckich';
$string['assignsubmission'] = 'Pluginy modułu Zadanie';
$string['assignsubmissionpluginname'] = 'Pluginy modułu Zadanie';
$string['assign:submit'] = 'Zgłoś zadanie';
$string['assign:view'] = 'Zobacz zadanie';
$string['assign:viewgrades'] = 'Podgląd ocen';
$string['attemptheading'] = 'Próba {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Poprzednie próby';
$string['attemptnumber'] = 'Numer próby';
$string['attemptreopenmethod'] = 'Ponownie otwarte próby';
$string['attemptreopenmethod_help'] = 'To ustawienie pozwala określić w jaki sposób prowadzący może ponownie udostępnić możliwość podejścia do zadania.
Dostępne opcje:<ul><li>Nigdy - nie ma możliwości ponownego otwarcia podejścia do zadania.</li><li>Ręcznie - podejście może być ponownie otwarte przez prowadzącego</li><li>Automatycznie, aż przejdą - podejścia są automatycznie otwierane, dopóki dany student nie osiągnie oceny przekraczającej próg zaliczeniowy</li></ul>';
$string['attemptreopenmethod_manual'] = 'Ręcznie';
$string['attemptreopenmethod_none'] = 'Nigdy';
$string['attemptreopenmethod_untilpass'] = 'Automatycznie, aż przejdą';
$string['attemptsettings'] = 'Ustawienia próby';
$string['availability'] = 'Dostępność';
$string['backtoassignment'] = 'Wróć do zadania';
$string['batchoperationconfirmaddattempt'] = 'Zezwolić na kolejną próbę?';
$string['batchoperationconfirmgrantextension'] = 'Czy przedłużenie terminu odnosi się do wszystkich zaznaczonych uczestników?';
$string['batchoperationconfirmlock'] = 'Zablokować wszystkie wybrane przesłane rozwiązania?';
$string['batchoperationconfirmreverttodraft'] = 'Zwrócić wybraną odpowiedź do poprawki?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Czy ustawić stan przepływu pracy w ocenianiu dla wszystkich zaznaczonych rozwiązań?';
$string['batchoperationconfirmunlock'] = 'Odblokować wybrane przesłane rozwiązania?';
$string['batchoperationlock'] = 'Zablokuj przesyłanie rozwiązań';
$string['batchoperationreverttodraft'] = 'Zwróć odpowiedzi do poprawki';
$string['batchoperationsdescription'] = 'Z wybranymi ...';
$string['batchoperationunlock'] = 'Odblokuj przesyłanie rozwiązań';
$string['batchsetallocatedmarker'] = 'Ustaw osobę oceniającą dla {$a} wybranych użytkowników.';
$string['batchsetmarkingworkflowstateforusers'] = 'Ustaw stan przepływu pracy w ocenianiu {$a} dla wybranych użytkowników.';
$string['blindmarking'] = 'Anonimowe ocenianie';
$string['blindmarking_help'] = 'To ustawienie ukrywa tożsamość uczestnika realizującego dane zadanie. Uwaga. Nie będzie możliwości zmiany tego ustawieniu po wystawieniu pierwszej oceny.';
$string['changegradewarning'] = 'W tym zadaniu domowym znajdują się ocenione prace. Zmiana oceny za ten moduł nie spowoduje automatycznego przeliczenia tych ocen ocenionych prac. Musisz przeliczyć ponownie oceny za złożone dotychczas prace, jeśli chcesz zmienić ocenę.';
$string['choosegradingaction'] = 'Akcja oceniania';
$string['choosemarker'] = 'Wybierz ...';
$string['chooseoperation'] = 'Wybierz operację';
$string['comment'] = 'Komentarz';
$string['completionsubmit'] = 'Student musi zatwierdzić tą aktytność, by ją zakończyć';
$string['configshowrecentsubmissions'] = 'Każdy może zobaczyć powiadomienia o przesłanych zadaniach w ostatnich raportach aktywności.';
$string['confirmbatchgradingoperation'] = 'Czy na pewno chcesz wykonać operację "{$a->operation}" dla {$a->count} studentów/a?';
$string['confirmsubmission'] = 'Czy na pewno chcesz wysłać swoje zadanie do oceny? Nie będziesz mógł po tej operacji dokonać żadnych zmian.';
$string['conversionexception'] = 'Nie można przekonwertować zadania. Wyjątkiem: {$a}.';
$string['couldnotconvertgrade'] = 'Nie można przekonwertować oceny dla użytkownika {$a}.';
$string['couldnotconvertsubmission'] = 'Nie można przekonwertować zadnia dla użytkownika {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nie można było utworzyć modułu kursu.';
$string['couldnotcreatenewassignmentinstance'] = 'Nie można było utworzyć instancji Zadania.';
$string['couldnotfindassignmenttoupgrade'] = 'Nie można było znaleźć starej instancji Zadania do ulepszenia.';
$string['currentattempt'] = 'To jest próba nr {$a}.';
$string['currentattemptof'] = 'To jest próba nr {$a->attemptnumber} ( liczba dozwolonych prób: {$a->maxattempts} ).';
$string['currentgrade'] = 'Bieżąca ocena w dzienniku ocen';
$string['cutoffdate'] = 'Ostateczny termin';
$string['cutoffdatefromdatevalidation'] = 'Data ostatecznego terminu musi być późniejsza daty terminu oddania zadania.';
$string['cutoffdate_help'] = 'Jeśli ustawienie jest aktywne - nie będzie możliwe oddanie zadania po upływie tego terminu.';
$string['cutoffdatevalidation'] = 'Data ostatecznego terminu nie może być wcześniejsza niż data terminu oddania zadania.';
$string['defaultsettings'] = 'Standardowe ustawienia zadania';
$string['defaultsettings_help'] = 'Ten parametr określa domyślne ustawienia dla wszystkich nowych zadań domowych.';
$string['defaultteam'] = 'Domyślna grupa';
$string['deleteallsubmissions'] = 'Usuń wszystkie złożone prace.';
$string['description'] = 'Opis';
$string['downloadall'] = 'Pobierz wszystkie przesłane rozwiązania';
$string['duedate'] = 'Termin oddania';
$string['duedate_help'] = 'Określa termin oddania prac. Jeśli przesyłanie prac po tym terminie jest zezwolone, prace takie zostaną oznaczone jako spóźnione.';
$string['duedateno'] = 'Brak terminu oddania';
$string['duedatereached'] = 'Minął termin oddania tego zadania';
$string['duedatevalidation'] = 'Ostateczny termin oddania rozwiązań musi być po dacie rozpoczęcia zadania';
$string['editaction'] = 'Akcje...';
$string['editattemptfeedback'] = 'Edytuj ocenę i komentarz dla próby numer {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Edytujesz komentarz dla poprzedniej próby. To jest próba nr {$a->attemptnumber} z {$a->totalattempts}.';
$string['editingstatus'] = 'Edycja statusu';
$string['editsubmission'] = 'Edytuj moje zadanie';
$string['editsubmission_help'] = 'Dodaj lub edytuj swoje zadanie';
$string['editsubmissionother'] = 'Edytuj zadanie dla {$a}';
$string['enabled'] = 'Aktywny';
$string['errornosubmissions'] = 'Brak zadań do pobrania';
$string['errorquickgradingvsadvancedgrading'] = 'Oceny nie zostały zapisane, ponieważ zadanie wykorzystuje zaawansowaną metodę oceniania.';
$string['errorrecordmodified'] = 'Oceny nie zostały zapisane, ponieważ ktoś modyfikował któreś rozwiązanie po załadowaniu strony';
$string['eventallsubmissionsdownloaded'] = 'Wszystkie zadania zostały pobrane.';
$string['eventassessablesubmitted'] = 'Zadanie zostało przesłane.';
$string['eventsubmissionupdated'] = 'Zadanie zaktualizowane.';
$string['eventsubmissionviewed'] = 'Zadanie wyświetlone.';
$string['extensionduedate'] = 'Termin przedłużenia';
$string['extensionnotafterduedate'] = 'Termin przedłużenia musi być późniejszy niż data oddania';
$string['extensionnotafterfromdate'] = 'Termin przedłużenia musi być późniejszy niż data zezwolenia na przesyłanie rozwiązań';
$string['feedback'] = 'Informacja zwrotna';
$string['feedbackavailablehtml'] = '{$a->username} przesłał ocenę/komentarz do wysłanego zadania \'<i>{$a->assignment}</i>\'<br /><br /> Możesz go zobaczyć <a href="{$a->url}">tutaj</a>.';
$string['feedbackavailablesmall'] = '{$a->username} przesłał komentarz do zadania {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} przesłał komentarz do zadania \'{$a->assignment}\' możesz go zobaczyć tutaj: {$a->url}';
$string['feedbackplugin'] = 'Wtyczka informacji zwrotnej';
$string['feedbackpluginforgradebook'] = 'Wtyczka informacji zwrotnej która przeniesie komentarze do dziennika ocen';
$string['feedbackpluginforgradebook_help'] = 'Tylko jedna wtyczka informacji zwrotnej może przenieść komentarze do dziennika ocen';
$string['feedbackplugins'] = 'Wtyczki informacji zwrotnej';
$string['feedbacksettings'] = 'Ustawienia komentarza zwrotnego';
$string['feedbacktypes'] = 'Typy odpowiedzi';
$string['filesubmissions'] = 'Przesłane pliki';
$string['filter'] = 'Filtr';
$string['filternone'] = 'Brak filtru';
$string['filterrequiregrading'] = 'Wymaga oceniania';
$string['filtersubmitted'] = 'Oddane';
$string['gradeabovemaximum'] = 'Ocena musi być mniejsza lub równa {$a}';
$string['gradebelowzero'] = 'Ocena musi być większa lub równa zeru.';
$string['gradecanbechanged'] = 'Ocena może być zmieniona';
$string['graded'] = 'Ocenione';
$string['gradedby'] = 'Ocenione przez';
$string['gradedon'] = 'Ocenione dnia';
$string['gradelocked'] = 'Ta ocena jest zablokowana lub nadpisana w dzienniku ocen';
$string['gradeoutof'] = 'Ocena z max. {$a}';
$string['gradeoutofhelp'] = 'Ocena';
$string['gradeoutofhelp_help'] = 'Wpisz ocenę dla przesłanego rozwiązania studenta tutaj. Możesz używać liczb dziesietnych.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} uaktualnił oddane zadanie \'{$a->assignment}\'</i><br /><br />

Zadanie <a href="{$a->url}">jest dostępne na stronie</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} uaktualnił oddane zadanie {$a->assignment}';
$string['gradersubmissionupdatedtext'] = '{$a->username} uaktualnił oddane zadanie \'{$a->assignment}\'

Zadanie jest dostępne tutaj:

{$a->url}';
$string['gradestudent'] = 'Ocena studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Ocena {$a}';
$string['grading'] = 'Ocenianie';
$string['gradingchangessaved'] = 'Zmiana ocen(y) została zapisana';
$string['gradingmethodpreview'] = 'Kryteria oceny';
$string['gradingoptions'] = 'Opcje';
$string['gradingstatus'] = 'Stan oceniania';
$string['gradingstudent'] = 'Ocenianie studentów';
$string['gradingsummary'] = 'Podsumowanie';
$string['grantextension'] = 'Przedłużenie terminu oddania';
$string['grantextensionforusers'] = 'Przedłuż termin oddania zadania dla {$a} studenta(ów)';
$string['groupsubmissionsettings'] = 'Ustawienia zadań grupowych';
$string['hiddenuser'] = 'Uczestnik';
$string['hideshow'] = 'Ukryj/pokaż';
$string['instructionfiles'] = 'Pliki instrukcji';
$string['introattachments'] = 'Dodatkowe pliki';
$string['invalidfloatforgrade'] = 'Wpisana ocena nie została zrozumiana: {$a}';
$string['invalidgradeforscale'] = 'Wpisana ocena nie mieści się w wybranej skali';
$string['lastmodifiedgrade'] = 'Ostatnia aktualizacja (ocena)';
$string['lastmodifiedsubmission'] = 'Ostatnia modyfikacja (przesłane rozwiązanie)';
$string['latesubmissions'] = 'Zadania oddane po terminie';
$string['latesubmissionsaccepted'] = 'Rozwiązania mogą przesyłać studenci, których termin oddania zadania został przedłużony.';
$string['locksubmissionforstudent'] = 'Zablokuj przesyłanie rozwiązań studentowi (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Zablokuj wysyłanie rozwiązań';
$string['manageassignfeedbackplugins'] = 'Zarządzaj wtyczkami informacji zwrotnej w zadaniach domowych';
$string['manageassignsubmissionplugins'] = 'Zarządzaj wtyczkami składania prac';
$string['marker'] = 'Osoba oceniająca';
$string['markerfilter'] = 'Filtr osób oceniających';
$string['markingallocation'] = 'Przydział osób oceniających';
$string['markingallocation_help'] = 'Z tej opcji można korzystać tylko przy wlączonym trybie przepływu pracy w ocenianiu.
Osoby oceniające mogą być przydzielone do konkretnego studenta.';
$string['markingworkflow'] = 'Przepływ pracy w ocenianiu';
$string['markingworkflow_help'] = 'Jeśli włączymy tę opcję, ocenianie będzie wieloetapowe. Zanim studentom zostanie opublikowana ocena końcowa za zadanie prowadzący będą przydzielać odpowiednie stany w procesie oceniania. Takie rozwiązanie pozwala na wielokrotną zmianę oceny (studenci nie widzą tych zmian) i opublikowanie wszystkich ostatecznych ocen w tym samym momencie.';
$string['markingworkflowstate'] = 'Stan przepływu pracy w ocenianiu';
$string['markingworkflowstate_help'] = 'Możliwe stany w przepływe pracy w ocenianiu: <ul><li> Nie ocenione - osoba oceniająca nie rozpoczęła jeszcze procesu oceniania</li><li>W trakcie oceniania - osoba oceniająca rozpoczęła ocenianie ale jeszcze go nie ukończyła</li><li>Ocenianie zakończone - osoba oceniająca ukończyła ocenianie jednak w każdej chwili może wrócić do trybu oceniania w celu weryfikacji poprawności i naniesienia ewentualnych poprawek</li><li>W trakcie przeglądu - główny prowadzący dokonuje kontroli jakości wystawionej oceny</li><li>Gotowe do publikacji - główny prowadzący zaakceptował wystawione oceny ale czeka z publikacją ocen</li><li>Ocena opublikowana - studenci mają dostęp do oceny w dzienniku ocen lub jako element informacji zwrotnej w zadaniu</li></ul>';
$string['markingworkflowstateinmarking'] = 'W trakcie oceniania';
$string['markingworkflowstateinreview'] = 'W trakcie przeglądu';
$string['markingworkflowstatenotmarked'] = 'Nie ocenione';
$string['markingworkflowstatereadyforrelease'] = 'Gotowe do publikacji';
$string['markingworkflowstatereadyforreview'] = 'Ocenianie zakończone';
$string['markingworkflowstatereleased'] = 'Ocena opublikowana';
$string['maxattempts'] = 'Max. ilość prób';
$string['maxattempts_help'] = 'Maksymalna liczba podejść do zadania. Po przekroczeniu tej liczby student/uczestnik nie ma możliwości ponownego rozwiązania/wysłania zadania.';
$string['maxgrade'] = 'Maksymalna ocena';
$string['messageprovider:assign_notification'] = 'Powiadomienia o zadaniach';
$string['modulename'] = 'Zadanie';
$string['modulename_help'] = 'Moduł zadania pozwala nauczycielowi na komunikowanie się, zbieranie prac, ocenę i ich komentowanie.

Studenci składają prace w formie plików dowolnego typu (tekstowe, multimedialne, obrazy itd). Prace mogą być składane w postaci tekstu wprowadzanego bezpośrednio w edytorze na stronie. Moduł zadania domowego może być także wykorzystany do przypomnienia studentom o zadaniach z poza systemu Moodle (zadania offline).

Nauczyciel oceniając zadania może zamieścić komentarz, oraz przesłać pliki (np. poprawioną pracę studenta, czy plik audio z komentarzem). Ocena może być wystawiona w skali numerycznej lub innej. Wystawione oceny widoczne są w dzienniku ocen.';
$string['modulenameplural'] = 'Zadania';
$string['moreusers'] = '{$a} więcej ...';
$string['mysubmission'] = 'Moje zadania:';
$string['newsubmissions'] = 'Oddane zadania';
$string['noattempt'] = 'Nie próbowano';
$string['nofiles'] = 'Brak plików.';
$string['nograde'] = 'Brak oceny.';
$string['nolatesubmissions'] = 'Nie ma możliwości przesyłania zadań po terminie oddania.';
$string['nomoresubmissionsaccepted'] = 'Żadne rozwiązania nie będą akceptowane';
$string['noonlinesubmissions'] = 'To zadanie nie wymaga wysyłania niczego online';
$string['nosavebutnext'] = 'Następne';
$string['nosubmission'] = 'Żadne rozwiązanie nie zostało przesłane do tego zadania';
$string['nosubmissionsacceptedafter'] = 'Brak zadań przesłanych po';
$string['notgraded'] = 'Nie ocenione';
$string['notgradedyet'] = 'Jeszcze nie ocenione';
$string['notifications'] = 'Powiadomienia';
$string['notsubmittedyet'] = 'Jeszcze nie oddane';
$string['nousersselected'] = 'Nie wybrano użytkownika';
$string['numberofdraftsubmissions'] = 'Wersja robocza';
$string['numberofparticipants'] = 'Uczestnicy';
$string['numberofsubmissionsneedgrading'] = 'Wymaga oceny';
$string['numberofsubmittedassignments'] = 'Nadesłane';
$string['numberofteams'] = 'Grupy';
$string['offline'] = 'Wysyłanie online nie jest wymagane';
$string['open'] = 'Otwarte';
$string['outlinegrade'] = 'Ocena: {$a}';
$string['outof'] = '{$a->current} z {$a->total}';
$string['overdue'] = '<font color="red">Opóźnienie w przesłaniu: {$a}</font>';
$string['page-mod-assign-view'] = 'Strona główna i strona składania prac w module zadania domowego';
$string['page-mod-assign-x'] = 'Każda strona modułu Zadanie';
$string['participant'] = 'Uczestnik';
$string['pluginadministration'] = 'Administracja Zadaniem';
$string['pluginname'] = 'Zadanie';
$string['preventsubmissions'] = 'Zabroń użytkownikowi wysyłania rozwiązań do zadania';
$string['preventsubmissionsshort'] = 'Zabroń ponownego przesyłania rozwiązań';
$string['previous'] = 'Poprzedni';
$string['quickgrading'] = 'Szybkie ocenianie';
$string['quickgradingchangessaved'] = 'Zmiana ocen(y) została zapisana';
$string['quickgrading_help'] = 'Szybkie ocenianie pozwala  wpisywać oceny i wyniki bezpośrednio do tabeli przesłanych rozwiązań. Szybkie  ocenianie  nie jest kompatybilne z zaawansowaną metodą oceniania.';
$string['quickgradingresult'] = 'Szybkie ocenianie';
$string['recordid'] = 'identyfikator';
$string['requireallteammemberssubmit'] = 'Wymaga przesłania przez wszystkich członków grupy';
$string['requireallteammemberssubmit_help'] = 'Jeśli ustawienie jest aktywne, wtedy wszyscy członkowie grupy muszą kliknąć opcję "Zgłoś zadanie". Jeśli ustawienie nie jest aktywne - zadanie będzie uznane jako zgłoszone do oceny, gdy jeden z członków grupy kliknie opcję "Zgłoś zadanie".';
$string['requiresubmissionstatement'] = 'Wymagać oświadczenia dot. przesyłanej pracy?';
$string['requiresubmissionstatement_help'] = 'Włączenie tej opcji powoduje, że przy składaniu wszystkich prac (aktywność Zadanie) w całej instalacji Moodla, będzie wymagane złożenie przez studentów oświadczenia. Jeśli opcja jest wyłączona wymuszenie składania oświadczeń może być włączone lub wyłączone przy każdej aktywności "Zadanie".';
$string['revealidentities'] = 'Ujawnij tożsamość studenta';
$string['revealidentitiesconfirm'] = 'Czy na pewno ujawnić tożsamość studenta dla tego zadania? Tej operacji nie będzie można cofnąć. Kiedy tożsamość studenta będzie ujawniona, stopnie pojawią się w dzienniku ocen.';
$string['reverttodraft'] = 'Zwróć odpowiedź do poprawki';
$string['reverttodraftforstudent'] = 'Zwróć odpowiedź do poprawki dla studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Zwróć odpowiedź do poprawki';
$string['reviewed'] = 'Przejrzane';
$string['saveallquickgradingchanges'] = 'Zapisz wszystkie zmiany w szybkim ocenianiu';
$string['savechanges'] = 'Zapisz zmiany';
$string['savegradingresult'] = 'Ocena';
$string['savenext'] = 'Zapisz i pokaż kolejne';
$string['scale'] = 'Skala';
$string['selectedusers'] = 'Wybrani użytkownicy';
$string['selectlink'] = 'Wybierz ...';
$string['selectuser'] = 'Wybierz {$a}';
$string['sendlatenotifications'] = 'Poinformuj nauczycieli o rozwiązaniach przesłanych po terminie oddania';
$string['sendlatenotifications_help'] = 'Jeśli ta opcja jest włączona, nauczyciele dostaną wiadomość, gdy tylko student prześle rozwiązanie po ustalonym terminie.';
$string['sendnotifications'] = 'Poinformuj nauczycieli o przesłanych rozwiązaniach';
$string['sendnotifications_help'] = 'Jeśli ta opcja jest włączona, nauczyciele dostaną wiadomość gdy tylko student prześle rozwiązanie.';
$string['sendstudentnotifications'] = 'Poinformuj studentów';
$string['sendstudentnotificationsdefault'] = 'Domyślne ustawienie dla opcji "Poinformuj studentów"';
$string['sendsubmissionreceipts'] = 'Wyślij potwierdzenie studentom po przesłaniu rozwiązania zadania';
$string['sendsubmissionreceipts_help'] = 'Opcja włączy potwierdzenia wysyłane studentom, gdy tylko poprawnie wyślą rozwiązania do zadania';
$string['setmarkingallocation'] = 'Ustaw osobę oceniającą';
$string['setmarkingworkflowstate'] = 'Ustaw stan przepływu pracy w ocenianiu';
$string['setmarkingworkflowstateforlog'] = 'Ustaw stan przepływu pracy w ocenianiu : (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Ustawienia zadania';
$string['showrecentsubmissions'] = 'Pokaż ostatnio przesłane zadania';
$string['status'] = 'Status';
$string['submission'] = 'Oddane zadanie';
$string['submissiondrafts'] = 'Wymuś potwierdzanie przesłanego rozwiązania przez studentów';
$string['submissiondrafts_help'] = 'Jeśli aktywne, student musi oznaczyć składaną pracę jako zakończoną, poprzez kliknięcie na przycisk. To pozwoli studentowi na przechowywanie niedokończonej pracy w systemie. Jeśli zmienisz ten parametr z "Nie" na "Tak" po złożeniu prac przez studentów, te prace zostaną potraktowane jako zakończone.';
$string['submissioneditable'] = 'Student może edytować to zadanie';
$string['submissionempty'] = 'Nic nie przesłano';
$string['submissionlog'] = 'Student: {$a->fullname}, Status: {$a->status}';
$string['submissionnotcopiedinvalidstatus'] = 'Zadanie nie zostało skopiowane, ponieważ został wyedytowane od momentu otwarcia.';
$string['submissionnoteditable'] = 'Student nie może edytować tego zadania';
$string['submissionnotready'] = 'Zadanie nie jest gotowe do przesyłania rozwiązań';
$string['submissionplugins'] = 'Wtyczki składania prac';
$string['submissionreceipthtml'] = 'Wysłałeś rozwiązanie do zadania: \'<i>{$a->assignment}</i>\'<br /><br /> Możesz zobaczyć status swojej odpowiedzi <a href="{$a->url}">tutaj</a>.';
$string['submissionreceiptotherhtml'] = 'Przesłano rozwiązanie do zadania \'<i>{$a->assignment}</i>\'<br /><br />
Możesz zobaczyć status swojego rozwiązania <a href="{$a->url}">tutaj</a>.';
$string['submissionreceiptothersmall'] = 'Przesłano rozwiązanie do zadania {$a->assignment}';
$string['submissionreceiptothertext'] = 'Przesłano rozwiązanie do zadania \'{$a->assignment}\'

Możesz zobaczyć status swojego rozwiązania tutaj:

    {$a->url}';
$string['submissionreceipts'] = 'Wysyłaj potwierdzenia przesłania rozwiązania';
$string['submissionreceiptsmall'] = 'Przesłano rozwiązanie do zadania  {$a->assignment}';
$string['submissionreceipttext'] = 'Przesłano rozwiązanie do zadania  {$a->assignment}, możesz zobaczyć status swojego rozwiązania tutaj: {$a->url}';
$string['submissions'] = 'Oddane zadania';
$string['submissionsclosed'] = 'Przesyłanie rozwiązań do zadania jest zamknięte';
$string['submissionsettings'] = 'Ustawienia przesyłania zadania';
$string['submissionslocked'] = 'To zadanie nie akceptuje przesyłania rozwiązań';
$string['submissionslockedshort'] = 'Nie można zmienić przesłanych rozwiązań';
$string['submissionsnotgraded'] = 'Nieocenione przesłane rozwiązania: {$a}';
$string['submissionstatement'] = 'Oświadczenie dot. przysyłanej pracy';
$string['submissionstatementacceptedlog'] = 'Oświadczenie dot. przesyłanej pracy złożone przez {$a}';
$string['submissionstatementdefault'] = 'Twórca oświadcza, że jest autorem/współautorem i przysługują mu w zakresie objętym tym oświadczeniem osobiste prawa autorskie do tego zadania.
Twórca oświadcza, że utwór nie narusza praw autorskich innych osób oraz, że przejmuje na siebie wszelkie ewentualne roszczenia osób trzecich z tego tytułu.';
$string['submissionstatus'] = 'Status przesłanego zadania';
$string['submissionstatus_'] = 'Brak przesłanego zadania';
$string['submissionstatus_draft'] = 'Wersja robocza';
$string['submissionstatusheading'] = 'Status przesłanego zadania';
$string['submissionstatus_marked'] = 'Ocenione';
$string['submissionstatus_new'] = 'Prześlij rozwiązanie';
$string['submissionstatus_reopened'] = 'Ponownie otwarte';
$string['submissionstatus_submitted'] = 'Przesłane do oceny';
$string['submissionsummary'] = '{$a->status}. Ostatnio modyfikowany {$a->timemodified}';
$string['submissionteam'] = 'Grupa';
$string['submissiontypes'] = 'Typy zadań';
$string['submitaction'] = 'Prześlij';
$string['submitassignment'] = 'Zgłoś zadanie';
$string['submitassignment_help'] = 'Po zgłoszeniu tego zadania, nie będzie można wprowadzić zmian.';
$string['submitted'] = 'Oddane';
$string['submittedearly'] = 'Zadanie zostało złożone {$a} przed terminem';
$string['submittedlate'] = 'Zadanie zostało złożone {$a} po terminie';
$string['submittedlateshort'] = '{$a} po terminie';
$string['teamsubmission'] = 'Zadanie realizowane w grupie';
$string['teamsubmissiongroupingid'] = 'Grupy nadrzędne dla grup studenckich';
$string['teamsubmissiongroupingid_help'] = 'To ustawienie pozwala na udostępnienie zadania kilku grupom. Jeśli to ustawienie jest nieaktywne - do zadania będą przypisane grupy ustawione domyślnie w ramach przedmiotu.';
$string['teamsubmission_help'] = 'Jeśli ustawienie jest aktywne, zadanie będzie podzielone na grupy(podział grup jest zgodny z domyślnymi ustawieniami grup w ramach przedmiotu). Zadanie będzie współdzielone przez daną grupę. Każdy członek grupy ma możliwość wglądu w zmiany dokonywane przez pozostałych członków grupy.';
$string['textinstructions'] = 'Instrukcje zadania';
$string['timemodified'] = 'Ostatnio modyfikowane';
$string['timeremaining'] = 'Pozostały czas';
$string['unlimitedattempts'] = 'Nieograniczony';
$string['unlimitedattemptsallowed'] = 'Nieograniczone próby są dozwolone.';
$string['unlocksubmissionforstudent'] = 'Pozwól na złożenie pracy studentowi: (id = {$a->id}, imię i nazwisko = {$a->fullname}).';
$string['unlocksubmissions'] = 'Odblokuj przesyłanie rozwiązań';
$string['updategrade'] = 'Aktualizacja oceny';
$string['updatetable'] = 'Zapisz i zaktualizuj tabelę';
$string['userextensiondate'] = 'Przedłużono termin oddania do: {$a}';
$string['usergrade'] = 'Ocena użytkownika';
$string['userswhoneedtosubmit'] = 'Użytkownicy, którzy muszą przesłać zadanie: {$a}';
$string['validmarkingworkflowstates'] = 'Poprawne stany w przepływie pracy w ocenianiu';
$string['viewfeedback'] = 'Wyświetl informację zwrotną';
$string['viewfeedbackforuser'] = 'Wyświetl informację zwrotną dla użytkownika: {$a}';
$string['viewfull'] = 'Zobacz całość';
$string['viewfullgradingpage'] = 'Otwórz stronę oceniania aby zamieścić informację zwrotną';
$string['viewgradebook'] = 'Zobacz dziennik ocen';
$string['viewgrading'] = 'Zobacz/oceń wszystkie zadania';
$string['viewgradingformforstudent'] = 'Otwórz stronę oceniania dla studenta: (id = {$a->id}, imię i nazwisko = {$a->fullname}).';
$string['viewownsubmissionform'] = 'Wyświetl swoją stronę składania pracy';
$string['viewownsubmissionstatus'] = 'Wyświetl stronę ze statusem swojej pracy';
$string['viewsubmission'] = 'Wyświetl pracę domową';
$string['viewsubmissionforuser'] = 'Wyświetl pracę użytkownika: {$a}';
$string['viewsubmissiongradingtable'] = 'Wyświetl tabelę oceniania prac.';
$string['viewsummary'] = 'Zobacz podsumowanie';
$string['workflowfilter'] = 'Filtr przepływu pracy';
