<?php
/**
 * Shopware 5
 * Copyright (c) shopware AG
 *
 * According to our dual licensing model, this program can be used either
 * under the terms of the GNU Affero General Public License, version 3,
 * or under a proprietary license.
 *
 * The texts of the GNU Affero General Public License with an additional
 * permission and of our proprietary license can be found at and
 * in the LICENSE file you have received along with this program.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * "Shopware" is a registered trademark of shopware AG.
 * The licensing of the program under the AGPLv3 does not imply a
 * trademark license. Therefore any rights, title and interest in
 * our trademarks remain entirely with us.
 */

namespace Shopware\Bundle\MediaBundle;

use Shopware\Models\Media\Media;

class MediaExtensionMappingService implements MediaExtensionMappingServiceInterface
{
    /**
     * Media mappings
     *
     * Key: file extension
     * Value: media type
     *
     * @return array
     */
    private $mapping = [
        '24b' => Media::TYPE_IMAGE,
        'ai' => Media::TYPE_VECTOR,
        'bmp' => Media::TYPE_IMAGE,
        'cdr' => Media::TYPE_IMAGE,
        'gif' => Media::TYPE_IMAGE,
        'iff' => Media::TYPE_IMAGE,
        'ilbm' => Media::TYPE_IMAGE,
        'jpeg' => Media::TYPE_IMAGE,
        'jpg' => Media::TYPE_IMAGE,
        'pcx' => Media::TYPE_IMAGE,
        'png' => Media::TYPE_IMAGE,
        'tif' => Media::TYPE_IMAGE,
        'tiff' => Media::TYPE_IMAGE,
        'eps' => Media::TYPE_VECTOR,
        'pbm' => Media::TYPE_IMAGE,
        'psd' => Media::TYPE_IMAGE,
        'wbm' => Media::TYPE_IMAGE,
        '264' => Media::TYPE_VIDEO,
        '3g2' => Media::TYPE_VIDEO,
        '3gp' => Media::TYPE_VIDEO,
        '3gp2' => Media::TYPE_VIDEO,
        '3gpp' => Media::TYPE_VIDEO,
        '3gpp2' => Media::TYPE_VIDEO,
        '3mm' => Media::TYPE_VIDEO,
        '3p2' => Media::TYPE_VIDEO,
        '60d' => Media::TYPE_VIDEO,
        '787' => Media::TYPE_VIDEO,
        'aaf' => Media::TYPE_VIDEO,
        'aep' => Media::TYPE_VIDEO,
        'aepx' => Media::TYPE_VIDEO,
        'aet' => Media::TYPE_VIDEO,
        'aetx' => Media::TYPE_VIDEO,
        'ajp' => Media::TYPE_VIDEO,
        'ale' => Media::TYPE_VIDEO,
        'amv' => Media::TYPE_VIDEO,
        'amx' => Media::TYPE_VIDEO,
        'anim' => Media::TYPE_VIDEO,
        'arf' => Media::TYPE_VIDEO,
        'asf' => Media::TYPE_VIDEO,
        'asx' => Media::TYPE_VIDEO,
        'avb' => Media::TYPE_VIDEO,
        'avd' => Media::TYPE_VIDEO,
        'avi' => Media::TYPE_VIDEO,
        'avp' => Media::TYPE_VIDEO,
        'avs' => Media::TYPE_VIDEO,
        'axm' => Media::TYPE_VIDEO,
        'bdm' => Media::TYPE_VIDEO,
        'bdmv' => Media::TYPE_VIDEO,
        'bik' => Media::TYPE_VIDEO,
        'bin' => Media::TYPE_VIDEO,
        'bix' => Media::TYPE_VIDEO,
        'bmk' => Media::TYPE_VIDEO,
        'bnp' => Media::TYPE_VIDEO,
        'box' => Media::TYPE_VIDEO,
        'bs4' => Media::TYPE_VIDEO,
        'bsf' => Media::TYPE_VIDEO,
        'byu' => Media::TYPE_VIDEO,
        'camproj' => Media::TYPE_VIDEO,
        'camrec' => Media::TYPE_VIDEO,
        'clpi' => Media::TYPE_VIDEO,
        'cmmp' => Media::TYPE_VIDEO,
        'cmmtpl' => Media::TYPE_VIDEO,
        'cmproj' => Media::TYPE_VIDEO,
        'cmrec' => Media::TYPE_VIDEO,
        'cpi' => Media::TYPE_VIDEO,
        'cst' => Media::TYPE_VIDEO,
        'cvc' => Media::TYPE_VIDEO,
        'd2v' => Media::TYPE_VIDEO,
        'd3v' => Media::TYPE_VIDEO,
        'dat' => Media::TYPE_VIDEO,
        'dav' => Media::TYPE_VIDEO,
        'dce' => Media::TYPE_VIDEO,
        'dck' => Media::TYPE_VIDEO,
        'ddat' => Media::TYPE_VIDEO,
        'dif' => Media::TYPE_VIDEO,
        'dir' => Media::TYPE_VIDEO,
        'divx' => Media::TYPE_VIDEO,
        'dlx' => Media::TYPE_VIDEO,
        'dmb' => Media::TYPE_VIDEO,
        'dmsd' => Media::TYPE_VIDEO,
        'dmsd3d' => Media::TYPE_VIDEO,
        'dmsm' => Media::TYPE_VIDEO,
        'dmsm3d' => Media::TYPE_VIDEO,
        'dmss' => Media::TYPE_VIDEO,
        'dnc' => Media::TYPE_VIDEO,
        'dpa' => Media::TYPE_VIDEO,
        'dpg' => Media::TYPE_VIDEO,
        'dream' => Media::TYPE_VIDEO,
        'dsy' => Media::TYPE_VIDEO,
        'dv' => Media::TYPE_VIDEO,
        'dv-avi' => Media::TYPE_VIDEO,
        'dv4' => Media::TYPE_VIDEO,
        'dvdmedia' => Media::TYPE_VIDEO,
        'dvr' => Media::TYPE_VIDEO,
        'dvr-ms' => Media::TYPE_VIDEO,
        'dvx' => Media::TYPE_VIDEO,
        'dxr' => Media::TYPE_VIDEO,
        'dzm' => Media::TYPE_VIDEO,
        'dzp' => Media::TYPE_VIDEO,
        'dzt' => Media::TYPE_VIDEO,
        'edl' => Media::TYPE_VIDEO,
        'evo' => Media::TYPE_VIDEO,
        'eye' => Media::TYPE_VIDEO,
        'f4p' => Media::TYPE_VIDEO,
        'f4v' => Media::TYPE_VIDEO,
        'fbr' => Media::TYPE_VIDEO,
        'fbz' => Media::TYPE_VIDEO,
        'fcp' => Media::TYPE_VIDEO,
        'fcproject' => Media::TYPE_VIDEO,
        'flc' => Media::TYPE_VIDEO,
        'flh' => Media::TYPE_VIDEO,
        'fli' => Media::TYPE_VIDEO,
        'flv' => Media::TYPE_VIDEO,
        'flx' => Media::TYPE_VIDEO,
        'gfp' => Media::TYPE_VIDEO,
        'gl' => Media::TYPE_VIDEO,
        'grasp' => Media::TYPE_VIDEO,
        'gts' => Media::TYPE_VIDEO,
        'gvi' => Media::TYPE_VIDEO,
        'gvp' => Media::TYPE_VIDEO,
        'h264' => Media::TYPE_VIDEO,
        'hdmov' => Media::TYPE_VIDEO,
        'hkm' => Media::TYPE_VIDEO,
        'ifo' => Media::TYPE_VIDEO,
        'imovieproj' => Media::TYPE_VIDEO,
        'imovieproject' => Media::TYPE_VIDEO,
        'irf' => Media::TYPE_VIDEO,
        'ism' => Media::TYPE_VIDEO,
        'ismc' => Media::TYPE_VIDEO,
        'ismv' => Media::TYPE_VIDEO,
        'iva' => Media::TYPE_VIDEO,
        'ivf' => Media::TYPE_VIDEO,
        'ivr' => Media::TYPE_VIDEO,
        'ivs' => Media::TYPE_VIDEO,
        'izz' => Media::TYPE_VIDEO,
        'izzy' => Media::TYPE_VIDEO,
        'jts' => Media::TYPE_VIDEO,
        'jtv' => Media::TYPE_VIDEO,
        'k3g' => Media::TYPE_VIDEO,
        'lrec' => Media::TYPE_VIDEO,
        'lsf' => Media::TYPE_VIDEO,
        'lsx' => Media::TYPE_VIDEO,
        'm15' => Media::TYPE_VIDEO,
        'm1pg' => Media::TYPE_VIDEO,
        'm1v' => Media::TYPE_VIDEO,
        'm21' => Media::TYPE_VIDEO,
        'm2a' => Media::TYPE_VIDEO,
        'm2p' => Media::TYPE_VIDEO,
        'm2t' => Media::TYPE_VIDEO,
        'm2ts' => Media::TYPE_VIDEO,
        'm2v' => Media::TYPE_VIDEO,
        'm4e' => Media::TYPE_VIDEO,
        'm4u' => Media::TYPE_VIDEO,
        'm4v' => Media::TYPE_VIDEO,
        'm75' => Media::TYPE_VIDEO,
        'meta' => Media::TYPE_VIDEO,
        'mgv' => Media::TYPE_VIDEO,
        'mj2' => Media::TYPE_VIDEO,
        'mjp' => Media::TYPE_VIDEO,
        'mjpg' => Media::TYPE_VIDEO,
        'mkv' => Media::TYPE_VIDEO,
        'mmv' => Media::TYPE_VIDEO,
        'mnv' => Media::TYPE_VIDEO,
        'mob' => Media::TYPE_VIDEO,
        'mod' => Media::TYPE_VIDEO,
        'modd' => Media::TYPE_VIDEO,
        'moff' => Media::TYPE_VIDEO,
        'moi' => Media::TYPE_VIDEO,
        'moov' => Media::TYPE_VIDEO,
        'mov' => Media::TYPE_VIDEO,
        'movie' => Media::TYPE_VIDEO,
        'mp21' => Media::TYPE_VIDEO,
        'mp2v' => Media::TYPE_VIDEO,
        'mp4' => Media::TYPE_VIDEO,
        'mp4v' => Media::TYPE_VIDEO,
        'mpe' => Media::TYPE_VIDEO,
        'mpeg' => Media::TYPE_VIDEO,
        'mpeg4' => Media::TYPE_VIDEO,
        'mpf' => Media::TYPE_VIDEO,
        'mpg' => Media::TYPE_VIDEO,
        'mpg2' => Media::TYPE_VIDEO,
        'mpgindex' => Media::TYPE_VIDEO,
        'mpl' => Media::TYPE_VIDEO,
        'mpls' => Media::TYPE_VIDEO,
        'mpsub' => Media::TYPE_VIDEO,
        'mpv' => Media::TYPE_VIDEO,
        'mpv2' => Media::TYPE_VIDEO,
        'mqv' => Media::TYPE_VIDEO,
        'msdvd' => Media::TYPE_VIDEO,
        'msh' => Media::TYPE_VIDEO,
        'mswmm' => Media::TYPE_VIDEO,
        'mts' => Media::TYPE_VIDEO,
        'mtv' => Media::TYPE_VIDEO,
        'mvb' => Media::TYPE_VIDEO,
        'mvc' => Media::TYPE_VIDEO,
        'mvd' => Media::TYPE_VIDEO,
        'mve' => Media::TYPE_VIDEO,
        'mvp' => Media::TYPE_VIDEO,
        'mvy' => Media::TYPE_VIDEO,
        'mxf' => Media::TYPE_VIDEO,
        'mys' => Media::TYPE_VIDEO,
        'ncor' => Media::TYPE_VIDEO,
        'nsv' => Media::TYPE_VIDEO,
        'nuv' => Media::TYPE_VIDEO,
        'nvc' => Media::TYPE_VIDEO,
        'ogm' => Media::TYPE_VIDEO,
        'ogv' => Media::TYPE_VIDEO,
        'ogx' => Media::TYPE_VIDEO,
        'osp' => Media::TYPE_VIDEO,
        'par' => Media::TYPE_VIDEO,
        'pds' => Media::TYPE_VIDEO,
        'pgi' => Media::TYPE_VIDEO,
        'photoshow' => Media::TYPE_VIDEO,
        'piv' => Media::TYPE_VIDEO,
        'playlist' => Media::TYPE_VIDEO,
        'pmf' => Media::TYPE_VIDEO,
        'pmv' => Media::TYPE_VIDEO,
        'pns' => Media::TYPE_VIDEO,
        'ppj' => Media::TYPE_VIDEO,
        'prel' => Media::TYPE_VIDEO,
        'pro' => Media::TYPE_VIDEO,
        'prproj' => Media::TYPE_VIDEO,
        'prtl' => Media::TYPE_VIDEO,
        'psh' => Media::TYPE_VIDEO,
        'pssd' => Media::TYPE_VIDEO,
        'pva' => Media::TYPE_VIDEO,
        'pvr' => Media::TYPE_VIDEO,
        'pxv' => Media::TYPE_VIDEO,
        'qt' => Media::TYPE_VIDEO,
        'qtch' => Media::TYPE_VIDEO,
        'qtl' => Media::TYPE_VIDEO,
        'qtm' => Media::TYPE_VIDEO,
        'qtz' => Media::TYPE_VIDEO,
        'r3d' => Media::TYPE_VIDEO,
        'rcproject' => Media::TYPE_VIDEO,
        'rdb' => Media::TYPE_VIDEO,
        'rec' => Media::TYPE_VIDEO,
        'rm' => Media::TYPE_VIDEO,
        'rmd' => Media::TYPE_VIDEO,
        'rmp' => Media::TYPE_VIDEO,
        'rms' => Media::TYPE_VIDEO,
        'rmvb' => Media::TYPE_VIDEO,
        'roq' => Media::TYPE_VIDEO,
        'rp' => Media::TYPE_VIDEO,
        'rsx' => Media::TYPE_VIDEO,
        'rts' => Media::TYPE_VIDEO,
        'rum' => Media::TYPE_VIDEO,
        'rv' => Media::TYPE_VIDEO,
        'sbk' => Media::TYPE_VIDEO,
        'sbt' => Media::TYPE_VIDEO,
        'scc' => Media::TYPE_VIDEO,
        'scm' => Media::TYPE_VIDEO,
        'scn' => Media::TYPE_VIDEO,
        'screenflow' => Media::TYPE_VIDEO,
        'sec' => Media::TYPE_VIDEO,
        'seq' => Media::TYPE_VIDEO,
        'sfd' => Media::TYPE_VIDEO,
        'sfvidcap' => Media::TYPE_VIDEO,
        'smi' => Media::TYPE_VIDEO,
        'smil' => Media::TYPE_VIDEO,
        'smk' => Media::TYPE_VIDEO,
        'sml' => Media::TYPE_VIDEO,
        'smv' => Media::TYPE_VIDEO,
        'spl' => Media::TYPE_VIDEO,
        'sqz' => Media::TYPE_VIDEO,
        'srt' => Media::TYPE_VIDEO,
        'ssm' => Media::TYPE_VIDEO,
        'str' => Media::TYPE_VIDEO,
        'stx' => Media::TYPE_VIDEO,
        'svi' => Media::TYPE_VIDEO,
        'swf' => Media::TYPE_VIDEO,
        'swi' => Media::TYPE_VIDEO,
        'swt' => Media::TYPE_VIDEO,
        'tda3mt' => Media::TYPE_VIDEO,
        'tdx' => Media::TYPE_VIDEO,
        'tivo' => Media::TYPE_VIDEO,
        'tix' => Media::TYPE_VIDEO,
        'tod' => Media::TYPE_VIDEO,
        'tp' => Media::TYPE_VIDEO,
        'tp0' => Media::TYPE_VIDEO,
        'tpd' => Media::TYPE_VIDEO,
        'tpr' => Media::TYPE_VIDEO,
        'trp' => Media::TYPE_VIDEO,
        'ts' => Media::TYPE_VIDEO,
        'tsp' => Media::TYPE_VIDEO,
        'tvs' => Media::TYPE_VIDEO,
        'vc1' => Media::TYPE_VIDEO,
        'vcpf' => Media::TYPE_VIDEO,
        'vcr' => Media::TYPE_VIDEO,
        'vcv' => Media::TYPE_VIDEO,
        'vdo' => Media::TYPE_VIDEO,
        'vdr' => Media::TYPE_VIDEO,
        'veg' => Media::TYPE_VIDEO,
        'vem' => Media::TYPE_VIDEO,
        'vep' => Media::TYPE_VIDEO,
        'vf' => Media::TYPE_VIDEO,
        'vft' => Media::TYPE_VIDEO,
        'vfw' => Media::TYPE_VIDEO,
        'vfz' => Media::TYPE_VIDEO,
        'vgz' => Media::TYPE_VIDEO,
        'vid' => Media::TYPE_VIDEO,
        'video' => Media::TYPE_VIDEO,
        'viewlet' => Media::TYPE_VIDEO,
        'viv' => Media::TYPE_VIDEO,
        'vivo' => Media::TYPE_VIDEO,
        'vlab' => Media::TYPE_VIDEO,
        'vob' => Media::TYPE_VIDEO,
        'vp3' => Media::TYPE_VIDEO,
        'vp6' => Media::TYPE_VIDEO,
        'vp7' => Media::TYPE_VIDEO,
        'vpj' => Media::TYPE_VIDEO,
        'vro' => Media::TYPE_VIDEO,
        'vs4' => Media::TYPE_VIDEO,
        'vse' => Media::TYPE_VIDEO,
        'vsp' => Media::TYPE_VIDEO,
        'w32' => Media::TYPE_VIDEO,
        'wcp' => Media::TYPE_VIDEO,
        'webm' => Media::TYPE_VIDEO,
        'wlmp' => Media::TYPE_VIDEO,
        'wm' => Media::TYPE_VIDEO,
        'wmd' => Media::TYPE_VIDEO,
        'wmmp' => Media::TYPE_VIDEO,
        'wmv' => Media::TYPE_VIDEO,
        'wmx' => Media::TYPE_VIDEO,
        'wot' => Media::TYPE_VIDEO,
        'wp3' => Media::TYPE_VIDEO,
        'wpl' => Media::TYPE_VIDEO,
        'wtv' => Media::TYPE_VIDEO,
        'wvx' => Media::TYPE_VIDEO,
        'xej' => Media::TYPE_VIDEO,
        'xel' => Media::TYPE_VIDEO,
        'xesc' => Media::TYPE_VIDEO,
        'xfl' => Media::TYPE_VIDEO,
        'xlmv' => Media::TYPE_VIDEO,
        'xvid' => Media::TYPE_VIDEO,
        'yuv' => Media::TYPE_VIDEO,
        'zm1' => Media::TYPE_VIDEO,
        'zm2' => Media::TYPE_VIDEO,
        'zm3' => Media::TYPE_VIDEO,
        'zmv' => Media::TYPE_VIDEO,
        '4mp' => Media::TYPE_MUSIC,
        '669' => Media::TYPE_MUSIC,
        '6cm' => Media::TYPE_MUSIC,
        '8cm' => Media::TYPE_MUSIC,
        '8med' => Media::TYPE_MUSIC,
        '8svx' => Media::TYPE_MUSIC,
        'a2m' => Media::TYPE_MUSIC,
        'a52' => Media::TYPE_MUSIC,
        'aa' => Media::TYPE_MUSIC,
        'aa3' => Media::TYPE_MUSIC,
        'aac' => Media::TYPE_MUSIC,
        'aax' => Media::TYPE_MUSIC,
        'ab' => Media::TYPE_MUSIC,
        'abc' => Media::TYPE_MUSIC,
        'abm' => Media::TYPE_MUSIC,
        'ac3' => Media::TYPE_MUSIC,
        'acd' => Media::TYPE_MUSIC,
        'acd-bak' => Media::TYPE_MUSIC,
        'acd-zip' => Media::TYPE_MUSIC,
        'acm' => Media::TYPE_MUSIC,
        'acp' => Media::TYPE_MUSIC,
        'act' => Media::TYPE_MUSIC,
        'adg' => Media::TYPE_MUSIC,
        'adt' => Media::TYPE_MUSIC,
        'adts' => Media::TYPE_MUSIC,
        'adv' => Media::TYPE_MUSIC,
        'afc' => Media::TYPE_MUSIC,
        'agm' => Media::TYPE_MUSIC,
        'ahx' => Media::TYPE_MUSIC,
        'aif' => Media::TYPE_MUSIC,
        'aifc' => Media::TYPE_MUSIC,
        'aiff' => Media::TYPE_MUSIC,
        'ais' => Media::TYPE_MUSIC,
        'akp' => Media::TYPE_MUSIC,
        'al' => Media::TYPE_MUSIC,
        'alac' => Media::TYPE_MUSIC,
        'alaw' => Media::TYPE_MUSIC,
        'alc' => Media::TYPE_MUSIC,
        'all' => Media::TYPE_MUSIC,
        'als' => Media::TYPE_MUSIC,
        'amf' => Media::TYPE_MUSIC,
        'amr' => Media::TYPE_MUSIC,
        'ams' => Media::TYPE_MUSIC,
        'amxd' => Media::TYPE_MUSIC,
        'aob' => Media::TYPE_MUSIC,
        'ape' => Media::TYPE_MUSIC,
        'apf' => Media::TYPE_MUSIC,
        'apl' => Media::TYPE_MUSIC,
        'aria' => Media::TYPE_MUSIC,
        'ariax' => Media::TYPE_MUSIC,
        'asd' => Media::TYPE_MUSIC,
        'ase' => Media::TYPE_MUSIC,
        'at3' => Media::TYPE_MUSIC,
        'atrac' => Media::TYPE_MUSIC,
        'au' => Media::TYPE_MUSIC,
        'aud' => Media::TYPE_MUSIC,
        'aup' => Media::TYPE_MUSIC,
        'avr' => Media::TYPE_MUSIC,
        'awb' => Media::TYPE_MUSIC,
        'ay' => Media::TYPE_MUSIC,
        'b4s' => Media::TYPE_MUSIC,
        'band' => Media::TYPE_MUSIC,
        'bap' => Media::TYPE_MUSIC,
        'bdd' => Media::TYPE_MUSIC,
        'bidule' => Media::TYPE_MUSIC,
        'brstm' => Media::TYPE_MUSIC,
        'bun' => Media::TYPE_MUSIC,
        'bwf' => Media::TYPE_MUSIC,
        'c01' => Media::TYPE_MUSIC,
        'caf' => Media::TYPE_MUSIC,
        'cda' => Media::TYPE_MUSIC,
        'cdda' => Media::TYPE_MUSIC,
        'cel' => Media::TYPE_MUSIC,
        'cfa' => Media::TYPE_MUSIC,
        'cfxr' => Media::TYPE_MUSIC,
        'cidb' => Media::TYPE_MUSIC,
        'cmf' => Media::TYPE_MUSIC,
        'copy' => Media::TYPE_MUSIC,
        'cpr' => Media::TYPE_MUSIC,
        'cpt' => Media::TYPE_MUSIC,
        'csh' => Media::TYPE_MUSIC,
        'cwp' => Media::TYPE_MUSIC,
        'd00' => Media::TYPE_MUSIC,
        'd01' => Media::TYPE_MUSIC,
        'dcf' => Media::TYPE_MUSIC,
        'dcm' => Media::TYPE_MUSIC,
        'dct' => Media::TYPE_MUSIC,
        'ddt' => Media::TYPE_MUSIC,
        'dewf' => Media::TYPE_MUSIC,
        'df2' => Media::TYPE_MUSIC,
        'dfc' => Media::TYPE_MUSIC,
        'dig' => Media::TYPE_MUSIC,
        'dls' => Media::TYPE_MUSIC,
        'dm' => Media::TYPE_MUSIC,
        'dmf' => Media::TYPE_MUSIC,
        'dmsa' => Media::TYPE_MUSIC,
        'dmse' => Media::TYPE_MUSIC,
        'dra' => Media::TYPE_MUSIC,
        'drg' => Media::TYPE_MUSIC,
        'ds' => Media::TYPE_MUSIC,
        'ds2' => Media::TYPE_MUSIC,
        'dsf' => Media::TYPE_MUSIC,
        'dsm' => Media::TYPE_MUSIC,
        'dsp' => Media::TYPE_MUSIC,
        'dss' => Media::TYPE_MUSIC,
        'dtm' => Media::TYPE_MUSIC,
        'dts' => Media::TYPE_MUSIC,
        'dtshd' => Media::TYPE_MUSIC,
        'dvf' => Media::TYPE_MUSIC,
        'dwd' => Media::TYPE_MUSIC,
        'ear' => Media::TYPE_MUSIC,
        'efa' => Media::TYPE_MUSIC,
        'efe' => Media::TYPE_MUSIC,
        'efk' => Media::TYPE_MUSIC,
        'efq' => Media::TYPE_MUSIC,
        'efs' => Media::TYPE_MUSIC,
        'efv' => Media::TYPE_MUSIC,
        'emd' => Media::TYPE_MUSIC,
        'emp' => Media::TYPE_MUSIC,
        'emx' => Media::TYPE_MUSIC,
        'esps' => Media::TYPE_MUSIC,
        'expressionmap' => Media::TYPE_MUSIC,
        'f2r' => Media::TYPE_MUSIC,
        'f32' => Media::TYPE_MUSIC,
        'f3r' => Media::TYPE_MUSIC,
        'f4a' => Media::TYPE_MUSIC,
        'f64' => Media::TYPE_MUSIC,
        'far' => Media::TYPE_MUSIC,
        'fda' => Media::TYPE_MUSIC,
        'fff' => Media::TYPE_MUSIC,
        'flac' => Media::TYPE_MUSIC,
        'flp' => Media::TYPE_MUSIC,
        'fls' => Media::TYPE_MUSIC,
        'frg' => Media::TYPE_MUSIC,
        'fsm' => Media::TYPE_MUSIC,
        'ftm' => Media::TYPE_MUSIC,
        'fzb' => Media::TYPE_MUSIC,
        'fzf' => Media::TYPE_MUSIC,
        'fzv' => Media::TYPE_MUSIC,
        'g721' => Media::TYPE_MUSIC,
        'g723' => Media::TYPE_MUSIC,
        'g726' => Media::TYPE_MUSIC,
        'gbproj' => Media::TYPE_MUSIC,
        'gbs' => Media::TYPE_MUSIC,
        'gig' => Media::TYPE_MUSIC,
        'gm' => Media::TYPE_MUSIC,
        'gp5' => Media::TYPE_MUSIC,
        'gpbank' => Media::TYPE_MUSIC,
        'gpk' => Media::TYPE_MUSIC,
        'gpx' => Media::TYPE_MUSIC,
        'gro' => Media::TYPE_MUSIC,
        'groove' => Media::TYPE_MUSIC,
        'gsm' => Media::TYPE_MUSIC,
        'h0' => Media::TYPE_MUSIC,
        'hdp' => Media::TYPE_MUSIC,
        'hma' => Media::TYPE_MUSIC,
        'hsb' => Media::TYPE_MUSIC,
        'ics' => Media::TYPE_MUSIC,
        'igp' => Media::TYPE_MUSIC,
        'igr' => Media::TYPE_MUSIC,
        'imf' => Media::TYPE_MUSIC,
        'imp' => Media::TYPE_MUSIC,
        'ins' => Media::TYPE_MUSIC,
        'isma' => Media::TYPE_MUSIC,
        'it' => Media::TYPE_MUSIC,
        'iti' => Media::TYPE_MUSIC,
        'its' => Media::TYPE_MUSIC,
        'jam' => Media::TYPE_MUSIC,
        'jo' => Media::TYPE_MUSIC,
        'jo-7z' => Media::TYPE_MUSIC,
        'k25' => Media::TYPE_MUSIC,
        'k26' => Media::TYPE_MUSIC,
        'kar' => Media::TYPE_MUSIC,
        'kfn' => Media::TYPE_MUSIC,
        'kin' => Media::TYPE_MUSIC,
        'kit' => Media::TYPE_MUSIC,
        'kmp' => Media::TYPE_MUSIC,
        'koz' => Media::TYPE_MUSIC,
        'kpl' => Media::TYPE_MUSIC,
        'krz' => Media::TYPE_MUSIC,
        'ksc' => Media::TYPE_MUSIC,
        'ksf' => Media::TYPE_MUSIC,
        'kt2' => Media::TYPE_MUSIC,
        'kt3' => Media::TYPE_MUSIC,
        'ktp' => Media::TYPE_MUSIC,
        'l' => Media::TYPE_MUSIC,
        'la' => Media::TYPE_MUSIC,
        'lof' => Media::TYPE_MUSIC,
        'lqt' => Media::TYPE_MUSIC,
        'lso' => Media::TYPE_MUSIC,
        'lvp' => Media::TYPE_MUSIC,
        'lwv' => Media::TYPE_MUSIC,
        'm1a' => Media::TYPE_MUSIC,
        'm3u' => Media::TYPE_MUSIC,
        'm3u8' => Media::TYPE_MUSIC,
        'm4a' => Media::TYPE_MUSIC,
        'm4b' => Media::TYPE_MUSIC,
        'm4p' => Media::TYPE_MUSIC,
        'm4r' => Media::TYPE_MUSIC,
        'ma1' => Media::TYPE_MUSIC,
        'mbr' => Media::TYPE_MUSIC,
        'mdl' => Media::TYPE_MUSIC,
        'med' => Media::TYPE_MUSIC,
        'mgv' => Media::TYPE_MUSIC,
        'mid' => Media::TYPE_MUSIC,
        'midi' => Media::TYPE_MUSIC,
        'miniusf' => Media::TYPE_MUSIC,
        'mka' => Media::TYPE_MUSIC,
        'mlp' => Media::TYPE_MUSIC,
        'mmf' => Media::TYPE_MUSIC,
        'mmm' => Media::TYPE_MUSIC,
        'mmp' => Media::TYPE_MUSIC,
        'mo3' => Media::TYPE_MUSIC,
        'mod' => Media::TYPE_MUSIC,
        'mp1' => Media::TYPE_MUSIC,
        'mp2' => Media::TYPE_MUSIC,
        'mp3' => Media::TYPE_MUSIC,
        'mpa' => Media::TYPE_MUSIC,
        'mpc' => Media::TYPE_MUSIC,
        'mpga' => Media::TYPE_MUSIC,
        'mpu' => Media::TYPE_MUSIC,
        'mp_' => Media::TYPE_MUSIC,
        'mscx' => Media::TYPE_MUSIC,
        'mscz' => Media::TYPE_MUSIC,
        'msv' => Media::TYPE_MUSIC,
        'mt2' => Media::TYPE_MUSIC,
        'mt9' => Media::TYPE_MUSIC,
        'mte' => Media::TYPE_MUSIC,
        'mtf' => Media::TYPE_MUSIC,
        'mti' => Media::TYPE_MUSIC,
        'mtm' => Media::TYPE_MUSIC,
        'mtp' => Media::TYPE_MUSIC,
        'mts' => Media::TYPE_MUSIC,
        'mus' => Media::TYPE_MUSIC,
        'mus' => Media::TYPE_MUSIC,
        'musa' => Media::TYPE_MUSIC,
        'mws' => Media::TYPE_MUSIC,
        'mxl' => Media::TYPE_MUSIC,
        'mxmf' => Media::TYPE_MUSIC,
        'mzp' => Media::TYPE_MUSIC,
        'nap' => Media::TYPE_MUSIC,
        'ncw' => Media::TYPE_MUSIC,
        'nkb' => Media::TYPE_MUSIC,
        'nki' => Media::TYPE_MUSIC,
        'nkm' => Media::TYPE_MUSIC,
        'nks' => Media::TYPE_MUSIC,
        'nkx' => Media::TYPE_MUSIC,
        'npl' => Media::TYPE_MUSIC,
        'nra' => Media::TYPE_MUSIC,
        'nrt' => Media::TYPE_MUSIC,
        'nsa' => Media::TYPE_MUSIC,
        'nsf' => Media::TYPE_MUSIC,
        'nst' => Media::TYPE_MUSIC,
        'ntn' => Media::TYPE_MUSIC,
        'nvf' => Media::TYPE_MUSIC,
        'nwc' => Media::TYPE_MUSIC,
        'odm' => Media::TYPE_MUSIC,
        'ofr' => Media::TYPE_MUSIC,
        'oga' => Media::TYPE_MUSIC,
        'ogg' => Media::TYPE_MUSIC,
        'okt' => Media::TYPE_MUSIC,
        'oma' => Media::TYPE_MUSIC,
        'omf' => Media::TYPE_MUSIC,
        'omg' => Media::TYPE_MUSIC,
        'omx' => Media::TYPE_MUSIC,
        'orc' => Media::TYPE_MUSIC,
        'ots' => Media::TYPE_MUSIC,
        'ove' => Media::TYPE_MUSIC,
        'ovw' => Media::TYPE_MUSIC,
        'pac' => Media::TYPE_MUSIC,
        'pat' => Media::TYPE_MUSIC,
        'pbf' => Media::TYPE_MUSIC,
        'pca' => Media::TYPE_MUSIC,
        'pcast' => Media::TYPE_MUSIC,
        'pcg' => Media::TYPE_MUSIC,
        'pcm' => Media::TYPE_MUSIC,
        'pd' => Media::TYPE_MUSIC,
        'peak' => Media::TYPE_MUSIC,
        'pek' => Media::TYPE_MUSIC,
        'pho' => Media::TYPE_MUSIC,
        'phy' => Media::TYPE_MUSIC,
        'pk' => Media::TYPE_MUSIC,
        'pkf' => Media::TYPE_MUSIC,
        'pla' => Media::TYPE_MUSIC,
        'pls' => Media::TYPE_MUSIC,
        'pna' => Media::TYPE_MUSIC,
        'ppc' => Media::TYPE_MUSIC,
        'ppcx' => Media::TYPE_MUSIC,
        'prg' => Media::TYPE_MUSIC,
        'psf' => Media::TYPE_MUSIC,
        'psm' => Media::TYPE_MUSIC,
        'psy' => Media::TYPE_MUSIC,
        'ptf' => Media::TYPE_MUSIC,
        'ptm' => Media::TYPE_MUSIC,
        'pts' => Media::TYPE_MUSIC,
        'pvc' => Media::TYPE_MUSIC,
        'qcp' => Media::TYPE_MUSIC,
        'r' => Media::TYPE_MUSIC,
        'r1m' => Media::TYPE_MUSIC,
        'ra' => Media::TYPE_MUSIC,
        'ram' => Media::TYPE_MUSIC,
        'raw' => Media::TYPE_MUSIC,
        'rax' => Media::TYPE_MUSIC,
        'rbs' => Media::TYPE_MUSIC,
        'rcy' => Media::TYPE_MUSIC,
        'rex' => Media::TYPE_MUSIC,
        'rfl' => Media::TYPE_MUSIC,
        'rip' => Media::TYPE_MUSIC,
        'rmf' => Media::TYPE_MUSIC,
        'rmi' => Media::TYPE_MUSIC,
        'rmj' => Media::TYPE_MUSIC,
        'rmm' => Media::TYPE_MUSIC,
        'rmx' => Media::TYPE_MUSIC,
        'rng' => Media::TYPE_MUSIC,
        'rns' => Media::TYPE_MUSIC,
        'rol' => Media::TYPE_MUSIC,
        'rsn' => Media::TYPE_MUSIC,
        'rso' => Media::TYPE_MUSIC,
        'rti' => Media::TYPE_MUSIC,
        'rtm' => Media::TYPE_MUSIC,
        'rts' => Media::TYPE_MUSIC,
        'rvx' => Media::TYPE_MUSIC,
        'rx2' => Media::TYPE_MUSIC,
        's3i' => Media::TYPE_MUSIC,
        's3m' => Media::TYPE_MUSIC,
        's3z' => Media::TYPE_MUSIC,
        'saf' => Media::TYPE_MUSIC,
        'sam' => Media::TYPE_MUSIC,
        'sap' => Media::TYPE_MUSIC,
        'sb' => Media::TYPE_MUSIC,
        'sbg' => Media::TYPE_MUSIC,
        'sbi' => Media::TYPE_MUSIC,
        'sbk' => Media::TYPE_MUSIC,
        'sc2' => Media::TYPE_MUSIC,
        'sd' => Media::TYPE_MUSIC,
        'sd2' => Media::TYPE_MUSIC,
        'sd2f' => Media::TYPE_MUSIC,
        'sdat' => Media::TYPE_MUSIC,
        'sdii' => Media::TYPE_MUSIC,
        'sds' => Media::TYPE_MUSIC,
        'sdt' => Media::TYPE_MUSIC,
        'sdx' => Media::TYPE_MUSIC,
        'seg' => Media::TYPE_MUSIC,
        'ses' => Media::TYPE_MUSIC,
        'sesx' => Media::TYPE_MUSIC,
        'sf' => Media::TYPE_MUSIC,
        'sf2' => Media::TYPE_MUSIC,
        'sfap0' => Media::TYPE_MUSIC,
        'sfk' => Media::TYPE_MUSIC,
        'sfl' => Media::TYPE_MUSIC,
        'sfs' => Media::TYPE_MUSIC,
        'shn' => Media::TYPE_MUSIC,
        'sib' => Media::TYPE_MUSIC,
        'sid' => Media::TYPE_MUSIC,
        'sid' => Media::TYPE_MUSIC,
        'smf' => Media::TYPE_MUSIC,
        'smp' => Media::TYPE_MUSIC,
        'snd' => Media::TYPE_MUSIC,
        'snd' => Media::TYPE_MUSIC,
        'snd' => Media::TYPE_MUSIC,
        'sng' => Media::TYPE_MUSIC,
        'sng' => Media::TYPE_MUSIC,
        'sou' => Media::TYPE_MUSIC,
        'sppack' => Media::TYPE_MUSIC,
        'sprg' => Media::TYPE_MUSIC,
        'spx' => Media::TYPE_MUSIC,
        'sseq' => Media::TYPE_MUSIC,
        'sseq' => Media::TYPE_MUSIC,
        'ssnd' => Media::TYPE_MUSIC,
        'stap' => Media::TYPE_MUSIC,
        'stm' => Media::TYPE_MUSIC,
        'stx' => Media::TYPE_MUSIC,
        'sty' => Media::TYPE_MUSIC,
        'sty' => Media::TYPE_MUSIC,
        'svd' => Media::TYPE_MUSIC,
        'svx' => Media::TYPE_MUSIC,
        'svg' => Media::TYPE_VECTOR,
        'sw' => Media::TYPE_MUSIC,
        'swa' => Media::TYPE_MUSIC,
        'syh' => Media::TYPE_MUSIC,
        'syn' => Media::TYPE_MUSIC,
        'syn' => Media::TYPE_MUSIC,
        'syw' => Media::TYPE_MUSIC,
        'syx' => Media::TYPE_MUSIC,
        'tak' => Media::TYPE_MUSIC,
        'tak' => Media::TYPE_MUSIC,
        'td0' => Media::TYPE_MUSIC,
        'tfmx' => Media::TYPE_MUSIC,
        'tg' => Media::TYPE_MUSIC,
        'thx' => Media::TYPE_MUSIC,
        'toc' => Media::TYPE_MUSIC,
        'tsp' => Media::TYPE_MUSIC,
        'tta' => Media::TYPE_MUSIC,
        'tun' => Media::TYPE_MUSIC,
        'txw' => Media::TYPE_MUSIC,
        'u' => Media::TYPE_MUSIC,
        'uax' => Media::TYPE_MUSIC,
        'ub' => Media::TYPE_MUSIC,
        'ulaw' => Media::TYPE_MUSIC,
        'ult' => Media::TYPE_MUSIC,
        'ulw' => Media::TYPE_MUSIC,
        'uni' => Media::TYPE_MUSIC,
        'usf' => Media::TYPE_MUSIC,
        'usflib' => Media::TYPE_MUSIC,
        'uw' => Media::TYPE_MUSIC,
        'uwf' => Media::TYPE_MUSIC,
        'vag' => Media::TYPE_MUSIC,
        'val' => Media::TYPE_MUSIC,
        'vap' => Media::TYPE_MUSIC,
        'vb' => Media::TYPE_MUSIC,
        'vc3' => Media::TYPE_MUSIC,
        'vdj' => Media::TYPE_MUSIC,
        'vgm' => Media::TYPE_MUSIC,
        'vgz' => Media::TYPE_MUSIC,
        'vmd' => Media::TYPE_MUSIC,
        'vmf' => Media::TYPE_MUSIC,
        'vmf' => Media::TYPE_MUSIC,
        'voc' => Media::TYPE_MUSIC,
        'voi' => Media::TYPE_MUSIC,
        'vox' => Media::TYPE_MUSIC,
        'vpm' => Media::TYPE_MUSIC,
        'vqf' => Media::TYPE_MUSIC,
        'vrf' => Media::TYPE_MUSIC,
        'vtx' => Media::TYPE_MUSIC,
        'vyf' => Media::TYPE_MUSIC,
        'w01' => Media::TYPE_MUSIC,
        'w64' => Media::TYPE_MUSIC,
        'wav' => Media::TYPE_MUSIC,
        'wav' => Media::TYPE_MUSIC,
        'wave' => Media::TYPE_MUSIC,
        'wax' => Media::TYPE_MUSIC,
        'wfb' => Media::TYPE_MUSIC,
        'wfd' => Media::TYPE_MUSIC,
        'wfp' => Media::TYPE_MUSIC,
        'wma' => Media::TYPE_MUSIC,
        'wow' => Media::TYPE_MUSIC,
        'wpk' => Media::TYPE_MUSIC,
        'wpp' => Media::TYPE_MUSIC,
        'wproj' => Media::TYPE_MUSIC,
        'wrk' => Media::TYPE_MUSIC,
        'wtpl' => Media::TYPE_MUSIC,
        'wtpt' => Media::TYPE_MUSIC,
        'wus' => Media::TYPE_MUSIC,
        'wut' => Media::TYPE_MUSIC,
        'wv' => Media::TYPE_MUSIC,
        'wvc' => Media::TYPE_MUSIC,
        'wve' => Media::TYPE_MUSIC,
        'wwu' => Media::TYPE_MUSIC,
        'wyz' => Media::TYPE_MUSIC,
        'xa' => Media::TYPE_MUSIC,
        'xa' => Media::TYPE_MUSIC,
        'xfs' => Media::TYPE_MUSIC,
        'xi' => Media::TYPE_MUSIC,
        'xm' => Media::TYPE_MUSIC,
        'xmf' => Media::TYPE_MUSIC,
        'xmi' => Media::TYPE_MUSIC,
        'xmz' => Media::TYPE_MUSIC,
        'xp' => Media::TYPE_MUSIC,
        'xrns' => Media::TYPE_MUSIC,
        'xsb' => Media::TYPE_MUSIC,
        'xspf' => Media::TYPE_MUSIC,
        'xt' => Media::TYPE_MUSIC,
        'xwb' => Media::TYPE_MUSIC,
        'ym' => Media::TYPE_MUSIC,
        'zpa' => Media::TYPE_MUSIC,
        'zpl' => Media::TYPE_MUSIC,
        'zvd' => Media::TYPE_MUSIC,
        'zvr' => Media::TYPE_MUSIC,
        '0' => Media::TYPE_ARCHIVE,
        '000' => Media::TYPE_ARCHIVE,
        '7z' => Media::TYPE_ARCHIVE,
        'a00' => Media::TYPE_ARCHIVE,
        'a01' => Media::TYPE_ARCHIVE,
        'a02' => Media::TYPE_ARCHIVE,
        'ace' => Media::TYPE_ARCHIVE,
        'ain' => Media::TYPE_ARCHIVE,
        'alz' => Media::TYPE_ARCHIVE,
        'apz' => Media::TYPE_ARCHIVE,
        'ar' => Media::TYPE_ARCHIVE,
        'arc' => Media::TYPE_ARCHIVE,
        'arh' => Media::TYPE_ARCHIVE,
        'ari' => Media::TYPE_ARCHIVE,
        'arj' => Media::TYPE_ARCHIVE,
        'ark' => Media::TYPE_ARCHIVE,
        'b1' => Media::TYPE_ARCHIVE,
        'b64' => Media::TYPE_ARCHIVE,
        'ba' => Media::TYPE_ARCHIVE,
        'bh' => Media::TYPE_ARCHIVE,
        'boo' => Media::TYPE_ARCHIVE,
        'bz' => Media::TYPE_ARCHIVE,
        'bz2' => Media::TYPE_ARCHIVE,
        'bza' => Media::TYPE_ARCHIVE,
        'bzip' => Media::TYPE_ARCHIVE,
        'bzip2' => Media::TYPE_ARCHIVE,
        'c00' => Media::TYPE_ARCHIVE,
        'c01' => Media::TYPE_ARCHIVE,
        'c02' => Media::TYPE_ARCHIVE,
        'c10' => Media::TYPE_ARCHIVE,
        'car' => Media::TYPE_ARCHIVE,
        'cb7' => Media::TYPE_ARCHIVE,
        'cba' => Media::TYPE_ARCHIVE,
        'cbr' => Media::TYPE_ARCHIVE,
        'cbt' => Media::TYPE_ARCHIVE,
        'cbz' => Media::TYPE_ARCHIVE,
        'cp9' => Media::TYPE_ARCHIVE,
        'cpgz' => Media::TYPE_ARCHIVE,
        'cpt' => Media::TYPE_ARCHIVE,
        'czip' => Media::TYPE_ARCHIVE,
        'dar' => Media::TYPE_ARCHIVE,
        'dd' => Media::TYPE_ARCHIVE,
        'deb' => Media::TYPE_ARCHIVE,
        'dgc' => Media::TYPE_ARCHIVE,
        'dist' => Media::TYPE_ARCHIVE,
        'dl_' => Media::TYPE_ARCHIVE,
        'dz' => Media::TYPE_ARCHIVE,
        'ecs' => Media::TYPE_ARCHIVE,
        'efw' => Media::TYPE_ARCHIVE,
        'epi' => Media::TYPE_ARCHIVE,
        'f' => Media::TYPE_ARCHIVE,
        'fdp' => Media::TYPE_ARCHIVE,
        'gca' => Media::TYPE_ARCHIVE,
        'gz' => Media::TYPE_ARCHIVE,
        'gz2' => Media::TYPE_ARCHIVE,
        'gza' => Media::TYPE_ARCHIVE,
        'gzi' => Media::TYPE_ARCHIVE,
        'gzip' => Media::TYPE_ARCHIVE,
        'ha' => Media::TYPE_ARCHIVE,
        'hbc' => Media::TYPE_ARCHIVE,
        'hbc2' => Media::TYPE_ARCHIVE,
        'hbe' => Media::TYPE_ARCHIVE,
        'hki' => Media::TYPE_ARCHIVE,
        'hki1' => Media::TYPE_ARCHIVE,
        'hki2' => Media::TYPE_ARCHIVE,
        'hki3' => Media::TYPE_ARCHIVE,
        'hpk' => Media::TYPE_ARCHIVE,
        'hyp' => Media::TYPE_ARCHIVE,
        'ice' => Media::TYPE_ARCHIVE,
        'ipg' => Media::TYPE_ARCHIVE,
        'ipk' => Media::TYPE_ARCHIVE,
        'ish' => Media::TYPE_ARCHIVE,
        'ita' => Media::TYPE_ARCHIVE,
        'j' => Media::TYPE_ARCHIVE,
        'jar.pack' => Media::TYPE_ARCHIVE,
        'jgz' => Media::TYPE_ARCHIVE,
        'jic' => Media::TYPE_ARCHIVE,
        'kgb' => Media::TYPE_ARCHIVE,
        'kz' => Media::TYPE_ARCHIVE,
        'lbr' => Media::TYPE_ARCHIVE,
        'lemon' => Media::TYPE_ARCHIVE,
        'lha' => Media::TYPE_ARCHIVE,
        'lnx' => Media::TYPE_ARCHIVE,
        'lqr' => Media::TYPE_ARCHIVE,
        'lz' => Media::TYPE_ARCHIVE,
        'lzh' => Media::TYPE_ARCHIVE,
        'lzm' => Media::TYPE_ARCHIVE,
        'lzma' => Media::TYPE_ARCHIVE,
        'lzo' => Media::TYPE_ARCHIVE,
        'lzx' => Media::TYPE_ARCHIVE,
        'md' => Media::TYPE_ARCHIVE,
        'mint' => Media::TYPE_ARCHIVE,
        'mou' => Media::TYPE_ARCHIVE,
        'mpkg' => Media::TYPE_ARCHIVE,
        'mzp' => Media::TYPE_ARCHIVE,
        'mzp' => Media::TYPE_ARCHIVE,
        'oar' => Media::TYPE_ARCHIVE,
        'oz' => Media::TYPE_ARCHIVE,
        'pack.gz' => Media::TYPE_ARCHIVE,
        'package' => Media::TYPE_ARCHIVE,
        'pae' => Media::TYPE_ARCHIVE,
        'pak' => Media::TYPE_ARCHIVE,
        'paq6' => Media::TYPE_ARCHIVE,
        'paq7' => Media::TYPE_ARCHIVE,
        'paq8' => Media::TYPE_ARCHIVE,
        'paq8f' => Media::TYPE_ARCHIVE,
        'par' => Media::TYPE_ARCHIVE,
        'par2' => Media::TYPE_ARCHIVE,
        'pax' => Media::TYPE_ARCHIVE,
        'pbi' => Media::TYPE_ARCHIVE,
        'pcv' => Media::TYPE_ARCHIVE,
        'pea' => Media::TYPE_ARCHIVE,
        'pet' => Media::TYPE_ARCHIVE,
        'pf' => Media::TYPE_ARCHIVE,
        'pim' => Media::TYPE_ARCHIVE,
        'pit' => Media::TYPE_ARCHIVE,
        'piz' => Media::TYPE_ARCHIVE,
        'pkg' => Media::TYPE_ARCHIVE,
        'pup' => Media::TYPE_ARCHIVE,
        'pup' => Media::TYPE_ARCHIVE,
        'puz' => Media::TYPE_ARCHIVE,
        'pwa' => Media::TYPE_ARCHIVE,
        'qda' => Media::TYPE_ARCHIVE,
        'r0' => Media::TYPE_ARCHIVE,
        'r00' => Media::TYPE_ARCHIVE,
        'r01' => Media::TYPE_ARCHIVE,
        'r02' => Media::TYPE_ARCHIVE,
        'r03' => Media::TYPE_ARCHIVE,
        'r1' => Media::TYPE_ARCHIVE,
        'r2' => Media::TYPE_ARCHIVE,
        'r21' => Media::TYPE_ARCHIVE,
        'r30' => Media::TYPE_ARCHIVE,
        'rar' => Media::TYPE_ARCHIVE,
        'rev' => Media::TYPE_ARCHIVE,
        'rk' => Media::TYPE_ARCHIVE,
        'rnc' => Media::TYPE_ARCHIVE,
        'rp9' => Media::TYPE_ARCHIVE,
        'rpm' => Media::TYPE_ARCHIVE,
        'rte' => Media::TYPE_ARCHIVE,
        'rz' => Media::TYPE_ARCHIVE,
        'rzs' => Media::TYPE_ARCHIVE,
        's00' => Media::TYPE_ARCHIVE,
        's01' => Media::TYPE_ARCHIVE,
        's02' => Media::TYPE_ARCHIVE,
        's7z' => Media::TYPE_ARCHIVE,
        'sar' => Media::TYPE_ARCHIVE,
        'sbx' => Media::TYPE_ARCHIVE,
        'sdc' => Media::TYPE_ARCHIVE,
        'sdn' => Media::TYPE_ARCHIVE,
        'sea' => Media::TYPE_ARCHIVE,
        'sen' => Media::TYPE_ARCHIVE,
        'sfs' => Media::TYPE_ARCHIVE,
        'sfx' => Media::TYPE_ARCHIVE,
        'sh' => Media::TYPE_ARCHIVE,
        'shar' => Media::TYPE_ARCHIVE,
        'shk' => Media::TYPE_ARCHIVE,
        'shr' => Media::TYPE_ARCHIVE,
        'sit' => Media::TYPE_ARCHIVE,
        'sitx' => Media::TYPE_ARCHIVE,
        'spt' => Media::TYPE_ARCHIVE,
        'sqx' => Media::TYPE_ARCHIVE,
        'srep' => Media::TYPE_ARCHIVE,
        'sy_' => Media::TYPE_ARCHIVE,
        'tar.gz' => Media::TYPE_ARCHIVE,
        'tar.gz2' => Media::TYPE_ARCHIVE,
        'tar.lzma' => Media::TYPE_ARCHIVE,
        'tar.xz' => Media::TYPE_ARCHIVE,
        'taz' => Media::TYPE_ARCHIVE,
        'tbz' => Media::TYPE_ARCHIVE,
        'tbz2' => Media::TYPE_ARCHIVE,
        'tg' => Media::TYPE_ARCHIVE,
        'tgz' => Media::TYPE_ARCHIVE,
        'tlz' => Media::TYPE_ARCHIVE,
        'tlzma' => Media::TYPE_ARCHIVE,
        'txz' => Media::TYPE_ARCHIVE,
        'tz' => Media::TYPE_ARCHIVE,
        'uc2' => Media::TYPE_ARCHIVE,
        'ufs.uzip' => Media::TYPE_ARCHIVE,
        'uha' => Media::TYPE_ARCHIVE,
        'uzip' => Media::TYPE_ARCHIVE,
        'vem' => Media::TYPE_ARCHIVE,
        'vsi' => Media::TYPE_ARCHIVE,
        'war' => Media::TYPE_ARCHIVE,
        'wot' => Media::TYPE_ARCHIVE,
        'xef' => Media::TYPE_ARCHIVE,
        'xez' => Media::TYPE_ARCHIVE,
        'xmcdz' => Media::TYPE_ARCHIVE,
        'xx' => Media::TYPE_ARCHIVE,
        'xz' => Media::TYPE_ARCHIVE,
        'y' => Media::TYPE_ARCHIVE,
        'yz' => Media::TYPE_ARCHIVE,
        'yz1' => Media::TYPE_ARCHIVE,
        'z' => Media::TYPE_ARCHIVE,
        'z01' => Media::TYPE_ARCHIVE,
        'z02' => Media::TYPE_ARCHIVE,
        'z03' => Media::TYPE_ARCHIVE,
        'z04' => Media::TYPE_ARCHIVE,
        'zap' => Media::TYPE_ARCHIVE,
        'zfsendtotarget' => Media::TYPE_ARCHIVE,
        'zi' => Media::TYPE_ARCHIVE,
        'zip' => Media::TYPE_ARCHIVE,
        'zipx' => Media::TYPE_ARCHIVE,
        'zix' => Media::TYPE_ARCHIVE,
        'zl' => Media::TYPE_ARCHIVE,
        'zoo' => Media::TYPE_ARCHIVE,
        'zpi' => Media::TYPE_ARCHIVE,
        'zz' => Media::TYPE_ARCHIVE,
        'pdf' => Media::TYPE_PDF,
        'dae' => Media::TYPE_MODEL,
        'obj' => Media::TYPE_MODEL,
        'fbx' => Media::TYPE_MODEL,
        'spx' => Media::TYPE_MODEL,
        '3ds' => Media::TYPE_MODEL,
        '3mf' => Media::TYPE_MODEL,
        'blend' => Media::TYPE_MODEL,
        'awd' => Media::TYPE_MODEL,
        'ply' => Media::TYPE_MODEL,
        'pcd' => Media::TYPE_MODEL,
        'stl' => Media::TYPE_MODEL,
        'skp' => Media::TYPE_MODEL,
        'ico' => Media::TYPE_UNKNOWN,
    ];

    /**
     * {@inheritdoc}
     */
    public function isAllowed($extension)
    {
        $extension = strtolower($extension);

        return array_key_exists($extension, $this->mapping);
    }

    /**
     * {@inheritdoc}
     */
    public function getType($extension)
    {
        $extension = strtolower($extension);

        return array_key_exists($extension, $this->mapping) ? $this->mapping[$extension] : Media::TYPE_UNKNOWN;
    }
}
