<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'nl', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = 'Opmerking: deze officiële Moodle app zal enkel werken als je Moodle site dit toestaat. Praat met je systeembeheerder als je problemen hebt om verbinding te maken.

Als je Moodle site hiervoor is geconfigureerd, dan kun je deze app gebruiken om:
- te bladeren door de inhoud van je cursussen, zelfs offline
- meldingen krijgen van berichten en andere gebeurtenissen
- snel mensen vinden en contacteren in je cursussen
- afbeeldingen, geluid, video en andere bestanden uploaden van je mobiele apparaat
- je cijfers bekijken
- en meer!

Bekijk http://docs.moodle.org/en/Mobile_app voor de laatste informatie hierover.

We appreciëren goede reviews over de functionaliteit die er al in zit en ook suggesties over wat er nog ontbreekt zijn welkom!

De app heeft volgende rechten nodig:
Geluid opnemen - om geluid op te nemen en dat te uploaden naar Moodle
Lezen en wijzigen van de inhoud op je SD-kaart - Inhoud van cursussen wordt gedownload naar de SD-kaart, zodat je die offline kunt bekijken
Netwerktoegang - Om met je Moodle site te kunnen verbinden en om te  te controleren of je verbonden of offline bent
Achtergrondproces - Zodat je lokale meldingen kunt ontvangen, zelfs als de app op de achtergrond loopt
Slaapstand verhinderen - zodat je altijd push-meldingen kunt ontvangen';
$string['mma.calendar.calendarevents'] = 'Kalendergebeurenissen';
$string['mma.calendar.errorloadevent'] = 'Fout bij het laden van de gebeurtenis.';
$string['mma.calendar.errorloadevents'] = 'Fout bij het laden van de gebeurtenissen.';
$string['mma.calendar.noevents'] = 'Er zijn geen gebeurtenissen';
$string['mma.calendar.notifications'] = 'Meldingen';
$string['mma.coursecompletion.complete'] = 'Voltooi';
$string['mma.coursecompletion.completecourse'] = 'Voltooi cursus';
$string['mma.coursecompletion.completed'] = 'Voltooid';
$string['mma.coursecompletion.completiondate'] = 'Voltooiingsdatum';
$string['mma.coursecompletion.couldnotloadreport'] = 'Kon het voltooiingsrapport van de cursus niet laden. Probeer later opnieuw.';
$string['mma.coursecompletion.coursecompletion'] = 'Cursus voltooien';
$string['mma.coursecompletion.criteria'] = 'Criteria';
$string['mma.coursecompletion.criteriagroup'] = 'Criteria groep';
$string['mma.coursecompletion.criteriarequiredall'] = 'Alle onderstaande criteria zijn vereist';
$string['mma.coursecompletion.criteriarequiredany'] = 'Alle onderstaande criteria zijn vereist';
$string['mma.coursecompletion.inprogress'] = 'Bezig';
$string['mma.coursecompletion.manualselfcompletion'] = 'Manueel zelf voltooien';
$string['mma.coursecompletion.notyetstarted'] = 'Nog niet gestart';
$string['mma.coursecompletion.pending'] = 'Nog bezig';
$string['mma.coursecompletion.required'] = 'Vereist';
$string['mma.coursecompletion.requiredcriteria'] = 'Vereiste criteria';
$string['mma.coursecompletion.requirement'] = 'Vereiste';
$string['mma.coursecompletion.status'] = 'Status';
$string['mma.coursecompletion.viewcoursereport'] = 'Bekijk cursusrapport';
$string['mma.files.admindisableddownload'] = 'Je Moodle beheerder heeft het downloaden van bestanden uitgeschakeld. Je kunt door de bestandenlijst bladeren, maar ze niet downloaden.';
$string['mma.files.audio'] = 'Audio';
$string['mma.files.camera'] = 'Camera';
$string['mma.files.chooseaccountuploadfile'] = 'Kies een account waarnaar het bestand moet geüpload worden';
$string['mma.files.clicktoupload'] = 'Klik op onderstaande knop om bestanden naar je privé-bestanden te uploaden.';
$string['mma.files.confirmuploadfile'] = 'Je gaat {$a} uploaden. Wil je verder gaan?';
$string['mma.files.couldnotloadfiles'] = 'De bestandenlijst kon niet geladen worden.';
$string['mma.files.downloading'] = 'Downloaden';
$string['mma.files.emptyfilelist'] = 'Er zijn geen bestanden te tonen.';
$string['mma.files.errorcapturingaudio'] = 'Fout bij het opnemen van audio';
$string['mma.files.errorcapturingimage'] = 'Fout bij foto-opname.';
$string['mma.files.errorcapturingvideo'] = 'Fout bij opnemen video';
$string['mma.files.errorgettingimagealbum'] = 'Fout bij het ophalen van foto van album.';
$string['mma.files.errormustbeonlinetoupload'] = 'Je moet online zijn om bestanden te uploaden.';
$string['mma.files.errornoapp'] = 'Je hebt geen app geïnstalleerd om deze actie mee uit te voeren.';
$string['mma.files.errorreadingfile'] = 'Fout bij het lezen van bestand "{$a}"';
$string['mma.files.errorreceivefilenosites'] = 'Er zijn geen sites bewaard. Voeg een site toe voor je een bestand probeert te uploaden.';
$string['mma.files.errorwhiledownloading'] = 'Er is een fout opgetreden tijdens het downloaden van het bestand.';
$string['mma.files.errorwhilerecordingaudio'] = 'Er is een fout opgetreden tijdens het opnemen van geluid.';
$string['mma.files.errorwhileuploading'] = 'Er is een fout opgetreden tijdens het uploaden van het bestand.';
$string['mma.files.file'] = 'Bestand';
$string['mma.files.fileuploaded'] = 'Bestand geüploaded';
$string['mma.files.myfiles'] = 'Mijn bestanden';
$string['mma.files.myprivatefiles'] = 'Mijn privé-bestanden';
$string['mma.files.myprivatefilesdesc'] = 'Jouw bestanden op deze Moodle-site.';
$string['mma.files.photoalbums'] = 'Foto-albums';
$string['mma.files.readingfile'] = 'Bestand aan het lezen';
$string['mma.files.sitefiles'] = 'Sitebestanden';
$string['mma.files.sitefilesdesc'] = 'Andere bestanden op deze Moodle-site.';
$string['mma.files.success'] = 'Succes!';
$string['mma.files.uploadafile'] = 'Upload een bestand';
$string['mma.files.uploadfiles'] = 'Upload bestanden';
$string['mma.files.uploading'] = 'Uploaden';
$string['mma.files.video'] = 'Video';
$string['mma.frontpage.frontpage'] = 'Startpagina';
$string['mma.frontpage.sitehome'] = 'Site startpagina';
$string['mma.grades.average'] = 'Gemiddelde';
$string['mma.grades.contributiontocoursetotal'] = 'Bijdrage bij het cursustotaal';
$string['mma.grades.feedback'] = 'Feedback';
$string['mma.grades.grade'] = 'Cijfer';
$string['mma.grades.grades'] = 'Cijfers';
$string['mma.grades.itemname'] = 'Beoordelingsitem';
$string['mma.grades.lettergrade'] = 'Letterbeoordeling';
$string['mma.grades.percentage'] = 'Percentage';
$string['mma.grades.range'] = 'Bereik';
$string['mma.grades.rank'] = 'Volgorde';
$string['mma.grades.viewgrades'] = 'Bekijk cijfers';
$string['mma.grades.weight'] = 'Weging';
$string['mma.messages.contactlistempty'] = 'De contactenlijst is leeg';
$string['mma.messages.contactname'] = 'Naam';
$string['mma.messages.errordeletemessage'] = 'Fout bij het verwijderen van het bericht';
$string['mma.messages.errorwhileretrievingcontacts'] = 'Fout bij het ophalen van contacten van de server.';
$string['mma.messages.errorwhileretrievingdiscussions'] = 'Fout bij het ophalen van discussies van de server';
$string['mma.messages.errorwhileretrievingmessages'] = 'Fout bij het ophalen van berichten van de server';
$string['mma.messages.messagenotsent'] = 'Het bericht is niet verzonden. Probeer later opnieuw.';
$string['mma.messages.mustbeonlinetosendmessages'] = 'Je moet online zijn om berichten te versturen';
$string['mma.messages.newmessage'] = 'Nieuw bericht...';
$string['mma.messages.nomessages'] = 'Geen berichten.';
$string['mma.messages.nousersfound'] = 'Geen gebruikers gevonden';
$string['mma.messages.send'] = 'Stuur';
$string['mma.messages.type_blocked'] = 'Geblokkeerd';
$string['mma.messages.type_offline'] = 'Offline';
$string['mma.messages.type_online'] = 'Online';
$string['mma.messages.type_search'] = 'Zoekresultaten';
$string['mma.messages.type_strangers'] = 'Anderen';
$string['mma.mod_assign.userwithid'] = 'Gebruiker met Id {{id}}';
$string['mma.mod_chat.errorwhileconnecting'] = 'Fout bij het verbinden met de chat.';
$string['mma.mod_chat.errorwhilegettingchatdata'] = 'Fout bij het ophalen van de chatgegevens.';
$string['mma.mod_chat.errorwhilegettingchatusers'] = 'Fout bij het ophalen van de chatgebruikers.';
$string['mma.mod_chat.errorwhileretrievingmessages'] = 'Fout bij het ophalen van de berichten van de server.';
$string['mma.mod_chat.errorwhilesendingmessage'] = 'Fout tijdens het versturen van het bericht.';
$string['mma.mod_chat.messagebeepsyou'] = '{{$a}} heeft je gepiept';
$string['mma.mod_chat.messageenter'] = '{{$a}} is de chat binnengekomen';
$string['mma.mod_chat.messageexit'] = '{{$a}} heeft de chat verlaten';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = 'Je moet online zijn om berichten te versturen';
$string['mma.mod_chat.sessionstart'] = 'De volgende chatsessie zal starten over {{$a}}';
$string['mma.mod_choice.errorgetchoice'] = 'Fout bij het ophalen van de keuzegegevens.';
$string['mma.mod_choice.expired'] = 'Sorry, de activiteit is gesloten op {{$a}} en is niet langer beschikbaar.';
$string['mma.mod_choice.notopenyet'] = 'Sorry, de activiteit is niet zichtbaar tot {{$a}}';
$string['mma.mod_choice.numberofuser'] = 'Aantal deelnemers';
$string['mma.mod_choice.numberofuserinpercentage'] = 'Deelnemerspercentage';
$string['mma.mod_choice.previewonly'] = 'Je kunt hier de beschikbare opties voor deze activiteit bekijken. Je kunt je keuze ingeven vanaf {{$a}}.';
$string['mma.mod_choice.responsesresultgraphdescription'] = '{{number}}% van de gebruikers kozen optie: {{text}}.';
$string['mma.mod_folder.emptyfilelist'] = 'Geen bestanden.';
$string['mma.mod_folder.errorwhilegettingfolder'] = 'Fout bij het ophalen van de mapgegevens';
$string['mma.mod_forum.erroremptysubject'] = 'Onderwerp mag niet leeg zijn';
$string['mma.mod_forum.errorgetforum'] = 'Fout bij het ophalen van forumgegevens';
$string['mma.mod_forum.errorgetgroups'] = 'Fout bij het ophalen van groepinstellingen.';
$string['mma.mod_forum.forumnodiscussionsyet'] = 'Er zijn nog geen discussies in dit forum';
$string['mma.mod_forum.group'] = 'Groep';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}} discussies';
$string['mma.mod_forum.numreplies'] = '{{numreplies}} antwoorden';
$string['mma.mod_glossary.browsemode'] = 'Blader door items';
$string['mma.mod_glossary.byalphabet'] = 'Alfabetisch';
$string['mma.mod_glossary.byauthor'] = 'Groepeer per auteur';
$string['mma.mod_glossary.bynewestfirst'] = 'Nieuwste eerst';
$string['mma.mod_glossary.byrecentlyupdated'] = 'Onlangs gewijzigd';
$string['mma.mod_glossary.bysearch'] = 'Zoek';
$string['mma.mod_glossary.entrypendingapproval'] = 'Dit item wacht op goedkeuring.';
$string['mma.mod_glossary.errorloadingentries'] = 'Fout bij het laden van de items.';
$string['mma.mod_glossary.errorloadingentry'] = 'Fout tijdens het laden van dit item.';
$string['mma.mod_glossary.errorloadingglossary'] = 'Fout tijdens het laden van de woordenlijst.';
$string['mma.mod_glossary.noentriesfound'] = 'Geen items gevonden.';
$string['mma.mod_glossary.searchquery'] = 'Zoekopdracht';
$string['mma.mod_imscp.showmoduledescription'] = 'Toon beschrijving';
$string['mma.mod_label.label'] = 'Label';
$string['mma.mod_label.taptoview'] = 'Tik om label te zien.';
$string['mma.mod_lti.errorgetlti'] = 'Fout bij het ophalen van moduledata.';
$string['mma.mod_lti.errorinvalidlaunchurl'] = 'De start-URL is niet geldig';
$string['mma.mod_lti.launchactivity'] = 'Start de activiteit';
$string['mma.mod_page.errorwhileloadingthepage'] = 'Fout bij het laden van de pagina-inhoud.';
$string['mma.mod_resource.errorwhileloadingthecontent'] = 'Fout bij het laden van de inhoud.';
$string['mma.mod_resource.openthefile'] = 'Open het bestand';
$string['mma.mod_scorm.cannotcalculategrade'] = 'Cijfer kon niet berekend worden.';
$string['mma.mod_scorm.dataattemptshown'] = 'Deze gegevens horen bij poging nummer {{number}}.';
$string['mma.mod_scorm.errorcreateofflineattempt'] = 'Er is een fout opgetreden tijdens het maken van een offline poging. Probeer opnieuw.';
$string['mma.mod_scorm.errordownloadscorm'] = 'Fout bij het downloaden van SCORM: "{{name}}".';
$string['mma.mod_scorm.errorgetscorm'] = 'Fout bij het ophalen van SCORM-gegevens.';
$string['mma.mod_scorm.errorinvalidversion'] = 'Sorry, de applicatie ondersteund SCORM tot versie 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = 'Het downloaden van SCORM-pakketten is uitgeschakeld in jouw Moodle-site. Neem contact op met je site-beheerder.';
$string['mma.mod_scorm.errornovalidsco'] = 'Deze SCORM heeft geen zichtbare SCO om te laden.';
$string['mma.mod_scorm.errorpackagefile'] = 'Sorry, de applicatie ondersteunt enkel ZIP-pakketten.';
$string['mma.mod_scorm.errorsyncscorm'] = 'Er is een fout opgetreden tijdens het synchroniseren. Probeer opnieuw.';
$string['mma.mod_scorm.lastsync'] = 'Laatste synchronisatie';
$string['mma.mod_scorm.offlineattemptnote'] = 'Deze poging bevat gegevens die nog niet gesynchroniseerd zijn.';
$string['mma.mod_scorm.offlineattemptovermax'] = 'Deze poging kan niet verzonden worden omdat je het maximale aantal pogingen overschreden hebt.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = 'Deze SCORM is niet gedownload. Het zal automatisch gedownload worden als je het opent.';
$string['mma.mod_scorm.scormstatusoutdated'] = 'Deze SCORM is gewijzigd sinds de laatste download. Het zal automatisch gedownload worden wanneer je het opent.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = 'Sommige offline gegevens van poging {{number}} zijn verwijderd omdat ze niet in een nieuwe poging konden omgezet worden.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = 'Sommige pogingen konden niet gesynchroniseerd worden met de site omdat de laatste online-poging niet beëindigd was. Beëindig eerst de online-poging.';
$string['mma.mod_survey.cannotsubmitsurvey'] = 'Sorry, er was een probleem bij het insturen van je onderzoek. Probeer opnieuw.';
$string['mma.mod_survey.errorgetsurvey'] = 'Fout bij het ophalen van onderzoeksdata.';
$string['mma.mod_survey.results'] = 'Resultaten';
$string['mma.mod_url.accessurl'] = 'Ga naar de URL';
$string['mma.mod_url.pointingtourl'] = 'URL van deze bron verwijst naar';
$string['mma.mod_wiki.errorloadingpage'] = 'Er is een fout opgetreden tijdens het laden van de pagina.';
$string['mma.mod_wiki.errornowikiavailable'] = 'Er is geen wiki beschikbaar';
$string['mma.mod_wiki.gowikihome'] = 'Wiki startpagina';
$string['mma.mod_wiki.subwiki'] = 'Subwiki';
$string['mma.mod_wiki.viewpage'] = 'Bekijk pagina';
$string['mma.notes.addnewnote'] = 'Voeg een nieuwe notitie toe';
$string['mma.notes.coursenotes'] = 'Cursusnotities';
$string['mma.notes.eventnotecreated'] = 'Notitie gemaakt';
$string['mma.notes.nonotes'] = 'Er zijn nog geen notities van dit type.';
$string['mma.notes.note'] = 'Notitie';
$string['mma.notes.notes'] = 'Notities';
$string['mma.notes.personalnotes'] = 'Persoonlijke notities';
$string['mma.notes.publishstate'] = 'Context';
$string['mma.notes.sitenotes'] = 'Site notities';
$string['mma.notes.userwithid'] = 'Gebruiker met ID {{$a}}';
$string['mma.notifications.errorgetnotifications'] = 'Fout bij het ophalen van notificaties';
$string['mma.notifications.notifications'] = 'Meldingen';
$string['mma.notifications.therearentnotificationsyet'] = 'Er zijn geen meldingen';
$string['mma.participants.noparticipants'] = 'Geen deelnemers gevonden in deze cursus';
$string['mma.participants.participants'] = 'Deelnemers';
$string['mm.contentlinks.chooseaccount'] = 'Kies account';
$string['mm.contentlinks.chooseaccounttoopenlink'] = 'Kies een account om de link mee te openen.';
$string['mm.contentlinks.confirmurlothersite'] = 'Deze link verwijst naar een andere site. Wil je dit openen?';
$string['mm.contentlinks.errornoactions'] = 'Kon geen actie vinden om uit te voeren met deze link.';
$string['mm.contentlinks.errornosites'] = 'Kon geen site vinden om deze link te behandelen.';
$string['mm.core.android'] = 'Android';
$string['mm.core.cannotconnect'] = 'Kan niet verbinden: controleer of je de URL juist hebt ingegeven en dat je site Moodle 2.4 of recenter gebruikt.';
$string['mm.core.cannotdownloadfiles'] = 'Bestanden downloaden is uitgeschakeld voor jouw mobiele service. Neem contact op met je systeembeheerder.';
$string['mm.core.clearsearch'] = 'Zoekresultaten leegmaken';
$string['mm.core.clicktoseefull'] = 'Klik hier om de volledige inhoud te zien';
$string['mm.core.close'] = 'Sluit';
$string['mm.core.completion-alt-auto-fail'] = 'Voltooid: {{$a}} (slaagcijfer niet behaald)';
$string['mm.core.completion-alt-auto-n'] = 'Niet voltooid: {{$a}}';
$string['mm.core.completion-alt-auto-pass'] = 'Voltooid: {{$a}} (slaagcijfer behaald)';
$string['mm.core.completion-alt-auto-y'] = 'Voltooid: {{$a}}';
$string['mm.core.completion-alt-manual-n'] = 'Niet voltooid: {{$a}}. Selecteer om als voltooid te markeren.';
$string['mm.core.completion-alt-manual-y'] = 'Voltooid: {{$a}}. Selecteer om als niet voltooid te markeren.';
$string['mm.core.confirmopeninbrowser'] = 'Wil je het openen in je browser?';
$string['mm.core.deleting'] = 'Verwijderen.';
$string['mm.core.dfdayweekmonth'] = 'ddd, D, MMM';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'h[:]mm A';
$string['mm.core.downloading'] = 'Downloaden';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.errorchangecompletion'] = 'Er is een fout opgetreden tijdens het wijzigen van de voltooiingsstatus. Probeer opnieuw.';
$string['mm.core.errordownloading'] = 'Fout bij downloaden bestand';
$string['mm.core.errordownloadingsomefiles'] = 'Fout bij het downloaden van modulebestanden. Sommige bestanden kunnen ontbreken.';
$string['mm.core.errorinvalidresponse'] = 'Ongeldig antwoord gekregen. Contacteer je Moodle site-beheerder als het probleem zich blijft voordoen.';
$string['mm.core.erroropenfilenoapp'] = 'Fout bij het openen van het bestand: geen enkele app gevonden om dit soort bestand te openen.';
$string['mm.core.erroropenfilenoextension'] = 'Fout bij het openen van het bestand: het bestand heeft geen extentie.';
$string['mm.core.erroropenpopup'] = 'Deze activiteit probeert een popup te openen. Dit wordt niet ondersteund in deze app.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = 'Afbeelding';
$string['mm.core.imageviewer'] = 'Afbeeldingsviewer';
$string['mm.core.info'] = 'Info';
$string['mm.core.ios'] = 'IOS';
$string['mm.core.loading'] = 'Laden...';
$string['mm.core.lostconnection'] = 'We zijn de verbinding kwijt en moeten opnieuw verbinden. Je token is nu ongeldig.';
$string['mm.core.mod_assign'] = 'Opdracht';
$string['mm.core.mod_assignment'] = 'Opdracht';
$string['mm.core.mod_book'] = 'Boek';
$string['mm.core.mod_chat'] = 'Chat';
$string['mm.core.mod_choice'] = 'Keuze';
$string['mm.core.mod_data'] = 'Databank';
$string['mm.core.mod_database'] = 'Databank';
$string['mm.core.mod_external-tool'] = 'Externe tool';
$string['mm.core.mod_feedback'] = 'Feedback';
$string['mm.core.mod_file'] = 'Bestand';
$string['mm.core.mod_folder'] = 'Map';
$string['mm.core.mod_forum'] = 'Forum';
$string['mm.core.mod_glossary'] = 'Woordenlijkst';
$string['mm.core.mod_ims'] = 'IMS content package';
$string['mm.core.mod_imscp'] = 'IMS content package';
$string['mm.core.mod_label'] = 'Label';
$string['mm.core.mod_lesson'] = 'Les';
$string['mm.core.mod_lti'] = 'Externe tool';
$string['mm.core.mod_page'] = 'Pagina';
$string['mm.core.mod_quiz'] = 'Test';
$string['mm.core.mod_resource'] = 'Bron';
$string['mm.core.mod_scorm'] = 'SCORM-pakket';
$string['mm.core.mod_survey'] = 'Onderzoek';
$string['mm.core.mod_url'] = 'URL';
$string['mm.core.mod_wiki'] = 'Wiki';
$string['mm.core.mod_workshop'] = 'Workshop';
$string['mm.core.mygroups'] = 'Mijn groepen';
$string['mm.core.networkerrormsg'] = 'Netwerk niet ingeschakeld of werkt niet.';
$string['mm.core.notapplicable'] = 'n/a';
$string['mm.core.numdays'] = '{{$a}} dagen';
$string['mm.core.numhours'] = '{{$a}} uur';
$string['mm.core.numminutes'] = '{{$a}} minuten';
$string['mm.core.nummonths'] = '{{$a}} maand';
$string['mm.core.numseconds'] = '{{$a}} seconden';
$string['mm.core.numyears'] = '{{$a}} jaar';
$string['mm.core.offline'] = 'Offline';
$string['mm.core.online'] = 'Online';
$string['mm.core.openfullimage'] = 'Klik hier om de afbeelding op volledige grootte weer te geven';
$string['mm.core.openinbrowser'] = 'Open in browser';
$string['mm.core.othergroups'] = 'Andere groepen';
$string['mm.core.percentagenumber'] = '{{$a}}%';
$string['mm.core.pictureof'] = 'Afbeelding van {{$a}}';
$string['mm.core.pulltorefresh'] = 'Slepen om te verversen';
$string['mm.core.requireduserdatamissing'] = 'Er ontbreken vereiste gegevens in het profiel van deze gebruiker. Vul deze gegevens in op je Moodle site en probeer opnieuw.<br>{{$a}}';
$string['mm.core.searching'] = 'Zoeken';
$string['mm.core.sending'] = 'Sturen';
$string['mm.core.serverconnection'] = 'Fout bij het verbinden met de server';
$string['mm.core.sizetb'] = 'TB';
$string['mm.core.success'] = 'Gelukt!';
$string['mm.core.tablet'] = 'Tablet';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.unexpectederror'] = 'Onverwachte fout. Sluit en heropen de applicatie om opnieuw te proberen.';
$string['mm.core.unknown'] = 'Onbekend';
$string['mm.core.unzipping'] = 'Unzippen';
$string['mm.core.windowsphone'] = 'Windows Phone';
$string['mm.core.wsfunctionnotavailable'] = 'De webservice is niet beschikbaar';
$string['mm.course.activitynotyetviewable'] = 'Deze activiteit of bron kan nog niet bekeken worden met deze app.';
$string['mm.course.activitynotyetviewablegothere'] = 'Deze activiteit of bron kan nog niet bekeken worden met deze app. Klik op onderstaande knop om het te bekijken op de site.';
$string['mm.course.allsections'] = 'Alle secties';
$string['mm.course.confirmdownload'] = 'Je gaat {{size}} downloaden. Weet je zeker dat je verder wil gaan?';
$string['mm.course.confirmdownloadsection'] = 'Je gaat {{size}} downloaden. Weet je zeker dat je verder wil gaan?';
$string['mm.course.confirmdownloadunknownsize'] = 'We konden de grootte van de download niet berekenen. Weet je zeker dat je toch wil downloaden?';
$string['mm.course.contents'] = 'Inhoud';
$string['mm.course.couldnotloadsectioncontent'] = 'Kon sectie-inhoud niet laden. Probeer later opnieuw.';
$string['mm.course.couldnotloadsections'] = 'Kon secties niet laden. Probeer later opnieuw';
$string['mm.course.errordownloadingsection'] = 'Fout bij het downloaden van de sectie.';
$string['mm.course.errorgetmodule'] = 'Fout bij het ophalen van modulegegevens.';
$string['mm.course.gotothesite'] = 'Ga naar de site';
$string['mm.course.nocontentavailable'] = 'Geen inhoud beschikbaar.';
$string['mm.courses.confirmselfenrol'] = 'Weet je zeker dat je je wil aanmelden in deze cursus?';
$string['mm.courses.enrolme'] = 'Meld me aan';
$string['mm.courses.errorloadcourses'] = 'Er is een fout opgetreden tijdens het laden van de cursussen.';
$string['mm.courses.errorsearching'] = 'Er is een fout opgetreden tijdens het zoeken.';
$string['mm.courses.errorselfenrol'] = 'Er is een fout opgetreden tijdens het zelf aanmelden.';
$string['mm.courses.filter'] = 'Filter';
$string['mm.courses.filtermycourses'] = 'Filter mijn cursussen';
$string['mm.courses.frontpage'] = 'Startpagina';
$string['mm.course.showall'] = 'Toon alle';
$string['mm.courses.mycourses'] = 'Mijn cursussen';
$string['mm.courses.nocourses'] = 'Geen curusinformatie beschikbaar';
$string['mm.courses.nosearchresults'] = 'Je zoekopdracht gaf geen resultaten';
$string['mm.courses.notenroled'] = 'Je bent niet aangemeld in deze cursus.';
$string['mm.courses.notenrollable'] = 'Je kunt jezelf niet aanmelden in deze cursus.';
$string['mm.courses.password'] = 'Aanmeldingssleutel';
$string['mm.courses.search'] = 'Zoek';
$string['mm.courses.searchcourses'] = 'Zoek cursussen';
$string['mm.courses.searchcoursesadvice'] = 'Je kunt via de cursus zoekknop toegang krijgen als gast of jezelf aanmelden in cursussen die dit toestaan.';
$string['mm.courses.selfenrolment'] = 'Zelf aanmelden';
$string['mm.courses.totalcoursesearchresults'] = 'Totaal aantal cursusen: {{$a}}';
$string['mm.course.whoops'] = 'Whoops!';
$string['mm.login.authenticating'] = 'Authenticeren';
$string['mm.login.cancel'] = 'Annuleer';
$string['mm.login.cannotdownloadfiles'] = 'Het downloaden van bestanden is uitgeschakeld in je mobiele service. De app kan niet werken met deze instelling uitgeschakeld. Contacteer je Moodle sitebeheerder.';
$string['mm.login.confirmdeletesite'] = 'Weet je zeker dat je de site {{sitename}} wil verwijderen?';
$string['mm.login.connect'] = 'Verbinden!';
$string['mm.login.connecttomoodle'] = 'Verbinden met Moodle';
$string['mm.login.credentials'] = 'Accountgegevens';
$string['mm.login.credentialsdescription'] = 'Geef je gebruikersnaam en wachtwoord om je aan te melden op';
$string['mm.login.erroraccesscontrolalloworigin'] = 'De Cross-Origin call die je probeerde uit te voeren,  werd geweigerd. Controleer https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = 'Er is een fout opgetreden bij het verwijderen van deze site. Probeer opnieuw.';
$string['mm.login.errorupdatesite'] = 'Er is een fout opgetreden bij het updaten van het token van deze site.';
$string['mm.login.help'] = 'Help';
$string['mm.login.helpmelogin'] = '<p>Er zijn vele Moodle sites over de hele wereld. Deze app kan enkel verbinding maken met Moodle sites die expliciet mobiele toegang ingeschakeld hebben.</p><p>Als je geen verbinding met jouw Moodle site kunt maken, vraag dan aan de beheerder van jouw site om <a href=\'http://docs.moodle.org/en/Mobile_app\' target=\'_blank\'>http://docs.moodle.org/en/Mobile_app</a> te lezen en de toegang in te schakelen.</p><p>Om de app te testen in een Moodle demo site kun je <i>teacher</i> of <i>student</i> in het  <i>Gebruikersnaam</i>-veld typen en de op de <b>Toevoegen</b>-knop klikken.</p>';
$string['mm.login.invalidaccount'] = 'Controleer je logingegevens of vraag je site-beheerder om de site-configuratie te controleren.';
$string['mm.login.invalidmoodleversion'] = 'Ongeldige Moodleversie. De vereiste minimumversie is:';
$string['mm.login.invalidsite'] = 'Deze site-URL is niet geldig.';
$string['mm.login.localmobileunexpectedresponse'] = 'Moodle Mobile Additional Features Check gaf een onverwacht antwoord. Je zult aanmelden via de standaard Mobile service.';
$string['mm.login.login'] = 'Login';
$string['mm.login.loginbutton'] = 'Login!';
$string['mm.login.logininsiterequired'] = 'Je dient via een browser in te loggen op je Moodle site';
$string['mm.login.mobileservicesnotenabled'] = 'Mobiele diensten zijn niet geactiveerd voor jou Moodle site. Neem contact op met de sitebeheerder.';
$string['mm.login.newsitedescription'] = 'Geef de URL van je Moodle site. Merk op dat die misschien niet geconfigureerd is om met deze app te werken.';
$string['mm.login.notloggedin'] = 'Je moet ingelogd zijn.';
$string['mm.login.password'] = 'Wachtwoord';
$string['mm.login.passwordrequired'] = 'Wachtwoord vereist';
$string['mm.login.reconnect'] = 'Opnieuw verbinden';
$string['mm.login.reconnectdescription'] = 'Je authenticatietoken is niet geldig of is verlopen. Je moet opnieuw verbinden met de site.';
$string['mm.login.reconnectssodescription'] = 'Je authenticatietoken is niet geldig of is verlopen. Je moet opnieuw verbinden met de site. Je moet je op de site aanmelden via een browservenster.';
$string['mm.login.siteaddress'] = 'Site-adres';
$string['mm.login.siteinmaintenance'] = 'Je Moodle site staat in onderhoudsmodus';
$string['mm.login.siteurl'] = 'Site URL';
$string['mm.login.siteurlrequired'] = 'De site URL is vereist, bijvoorbeeld <i>http://www.jouwmoodlesite.abc of https://www.jouwmoodlesite.efg</i>';
$string['mm.login.username'] = 'Gebruikersnaam';
$string['mm.login.usernamerequired'] = 'Gebruikersnaam vereist';
$string['mm.login.webservicesnotenabled'] = 'Web services zijn niet geactiveerd op jouw Moodle site. Neem contact op met de sitebeheerder.';
$string['mm.settings.about'] = 'Over';
$string['mm.settings.appname'] = 'Moodle Mobile {{version}}';
$string['mm.settings.appready'] = 'App klaar.';
$string['mm.settings.cacheexpirationtime'] = 'Cache verlooptijd (milliseconden)';
$string['mm.settings.cordovadevicemodel'] = 'Cordova Device model';
$string['mm.settings.cordovadeviceosversion'] = 'Cordova Device OS versie';
$string['mm.settings.cordovadeviceplatform'] = 'Cordova Device platform';
$string['mm.settings.cordovadeviceuuid'] = 'Cordova Device uuid';
$string['mm.settings.cordovaversion'] = 'Cordova versie';
$string['mm.settings.credits'] = 'Credits';
$string['mm.settings.currentlanguage'] = 'Huidige taal';
$string['mm.settings.deletesitefiles'] = 'Weet je zeker dat je deze site en gedownloade bestanden ervan wil verwijderen?';
$string['mm.settings.deletesitefilestitle'] = 'Verwijder site-bestanden';
$string['mm.settings.development'] = 'Ontwikkeling';
$string['mm.settings.deviceinfo'] = 'Toestel info';
$string['mm.settings.deviceos'] = 'Toestel OS';
$string['mm.settings.devicewebworkers'] = 'Ondersteunde Device Web Workers';
$string['mm.settings.displayformat'] = 'Schermformaat';
$string['mm.settings.enabledebugging'] = 'Foutopsporing inschakelen';
$string['mm.settings.enabledownloadsection'] = 'Downloadsecties inschakelen';
$string['mm.settings.enabledownloadsectiondescription'] = 'Schakel deze optie uit om het laden van cursussecties te versnellen.';
$string['mm.settings.enablesyncwifi'] = 'Synchronisatie alleen over WI-FI toestaan.';
$string['mm.settings.errordeletesitefiles'] = 'Fout bij het verwijderen van bestanden';
$string['mm.settings.errorsyncsite'] = 'Fout bij het synchroniseren van sitegegevens. Controleer je internetverbinding en probeer opnieuw.';
$string['mm.settings.estimatedfreespace'] = 'Geschatte vrije ruimte';
$string['mm.settings.filesystemroot'] = 'Root bestandssysteem';
$string['mm.settings.general'] = 'Algemeen';
$string['mm.settings.language'] = 'Taal';
$string['mm.settings.license'] = 'Licentie';
$string['mm.settings.localnotifavailable'] = 'Lokale meldingen beschikbaar';
$string['mm.settings.locationhref'] = 'Webview URL';
$string['mm.settings.navigatorlanguage'] = 'Navigatietaal';
$string['mm.settings.navigatoruseragent'] = 'Navigatie userAgent';
$string['mm.settings.networkstatus'] = 'Internet connectiestatus';
$string['mm.settings.reportinbackground'] = 'Fouten automatisch rapporteren';
$string['mm.settings.settings'] = 'Instellingen';
$string['mm.settings.sites'] = 'Sites';
$string['mm.settings.spaceusage'] = 'Gebruikte ruimte';
$string['mm.settings.storagetype'] = 'Opslagtype';
$string['mm.settings.success'] = 'Gelukt!';
$string['mm.settings.synchronization'] = 'Synchronisatie';
$string['mm.settings.synchronizenow'] = 'Nu synchroniseren';
$string['mm.settings.synchronizing'] = 'Aan het synchroniseren...';
$string['mm.settings.syncsettings'] = 'Synchronisatie-instellingen';
$string['mm.settings.syncsitesuccess'] = 'Site-gegevens gesynchroniseerd en alle cache ongeldig gemaakt.';
$string['mm.settings.total'] = 'Totaal';
$string['mm.settings.versioncode'] = 'Versie code';
$string['mm.settings.versionname'] = 'Versie naam';
$string['mm.settings.wificonnection'] = 'Wifi-verbinding';
$string['mm.sidemenu.appsettings'] = 'App instellingen';
$string['mm.sidemenu.changesite'] = 'Naar andere site';
$string['mm.sidemenu.help'] = 'Help';
$string['mm.sidemenu.logout'] = 'Naar andere site';
$string['mm.sidemenu.mycourses'] = 'Mijn cursussen';
$string['mm.sidemenu.togglemenu'] = 'Menu schakelen';
$string['mm.sidemenu.website'] = 'Website';
$string['mm.user.address'] = 'Adres';
$string['mm.user.city'] = 'Stad';
$string['mm.user.contact'] = 'Contact';
$string['mm.user.country'] = 'Land';
$string['mm.user.description'] = 'Beschrijving';
$string['mm.user.details'] = 'Details';
$string['mm.user.detailsnotavailable'] = 'Je kunt de details voor deze gebruiker niet bekijken.';
$string['mm.user.editingteacher'] = 'Leraar';
$string['mm.user.email'] = 'E-mail';
$string['mm.user.interests'] = 'Interesses';
$string['mm.user.invaliduser'] = 'Ongeldige gebuiker';
$string['mm.user.manager'] = 'Manager';
$string['mm.user.phone1'] = 'Telefoon';
$string['mm.user.phone2'] = 'Mobiele telefoon';
$string['mm.user.roles'] = 'Rollen';
$string['mm.user.student'] = 'Leerling';
$string['mm.user.teacher'] = 'Leraar zonder bewerken';
$string['mm.user.viewprofile'] = 'Bekijk profiel';
$string['mm.user.webpage'] = 'Webpagina';
$string['pluginname'] = 'Moodle mobile taal-strings';
