<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'ru', branch 'MOODLE_28_STABLE'
 *
 * @package   offlinequiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Добавить';
$string['addlist'] = 'Добавить список';
$string['addnewpagesafterselected'] = 'Добавить разделители страниц после выбранных вопросов';
$string['addnewquestionsqbank'] = 'Добавить вопросы в категорию {$a->catname}: {$a->link}';
$string['addpagehere'] = 'Добавить страницу здесь';
$string['addparts'] = 'Добавить участников';
$string['addrandom'] = 'Добавить случайным образом {$a} вопросов с множественным выбором';
$string['addtoofflinequiz'] = 'Добавить в офлайн-тест';
$string['addtoqueue'] = 'Добавить в очередь';
$string['allinone'] = 'Без ограничения';
$string['alllists'] = 'Все списки';
$string['allresults'] = 'Показать все результаты';
$string['allstudents'] = 'Показать всех студентов';
$string['alwaysavailable'] = 'Всегда доступно';
$string['answerform'] = 'Форма для ответов';
$string['answerformforgroup'] = 'Ответ для группы  {$a}';
$string['answerforms'] = 'Формы ответов';
$string['attemptexists'] = 'Попытка существует';
$string['attemptsexist'] = 'Вы не можете больше добавлять или убирать вопросы';
$string['attemptsnum'] = 'Результаты: {$a}';
$string['attemptsonly'] = 'Показать только студентов с результатами';
$string['attendances'] = 'Посещаемость';
$string['bulksavegrades'] = 'Сохранить оценки';
$string['calibratescanner'] = 'Калибровка сканера';
$string['cannoteditafterattempts'] = 'Вы не можете добавлять или убирать вопросы, потому что уже есть завершенные результаты ({$a})';
$string['category'] = 'Категория';
$string['changed'] = 'Результаты были изменены';
$string['checkparts'] = 'Отметить выбранных участников как присутствующих';
$string['checkuserid'] = 'Проверьте ID группы/пользователя';
$string['chooseagroup'] = 'Выберите группу...';
$string['closestudentview'] = 'Закрыть просмотр студента';
$string['closewindow'] = 'Закрыть окно';
$string['configdecimalplaces'] = 'Количество цифр после запятой при отображении оценок за офлайн-тест';
$string['configkeepfilesfordays'] = 'Определите, сколько дней загруженные файлы изображений будут храниться. В течение этого времени файлы изображений будут доступны в отчете администратора офлайн-теста.';
$string['configpapergray'] = 'степень серости бумаги';
$string['configshuffleanswers'] = 'Перемешать ответы';
$string['copy'] = 'Копировать';
$string['copyselectedtogroup'] = 'Добавить выбранные вопросы в группу: {$a}';
$string['copytogroup'] = 'Добавить все вопросы в группу: {$a}';
$string['correct'] = '';
$string['correctforgroup'] = '';
$string['correctionform'] = 'Правка';
$string['correctionforms'] = 'Формы правки';
$string['correctionoptionsheading'] = 'Опции правки';
$string['correctupdated'] = 'Обновить форму правки для группы {$a}.';
$string['couldnotgrab'] = 'Не удается получить изображение {$a}';
$string['couldnotregister'] = 'Не удается зарегистрировать пользователя {$a}';
$string['createlistfirst'] = 'Добавить участников';
$string['createofflinequiz'] = 'Создать формы';
$string['createpartpdferror'] = 'PDF-формы со списком участников {$a} не может быть создан. Вероятно, он пуст.';
$string['createpdf'] = 'PDF-форма';
$string['createpdferror'] = 'Форма для группы {$a} не может быть создана. Вероятно, нет вопрсоов в группе.';
$string['createpdffirst'] = 'Создать сначала PDF-список';
$string['createpdfforms'] = 'Создать формы';
$string['createpdfs'] = 'PDF-формы';
$string['createpdfsparticipants'] = 'PDF-формы для списка участников';
$string['createquestionandadd'] = 'Создать новый вопрос и добавить в тест';
$string['createquiz'] = 'Создать формы';
$string['csvfile'] = 'CSV-файл';
$string['darkgray'] = 'Темно серый';
$string['datanotsaved'] = 'Не удается сохранить настройки';
$string['decimalplaces'] = 'Разрядность';
$string['decimalplaces_help'] = 'Число знаков после запятой при отображении оценок за офлайн-тест';
$string['deletelistcheck'] = 'Вы действительно хотите удалить выбранные списки и всех их участников?';
$string['deletepagecheck'] = 'Вы действительно хотите удалять выбранные страницы?';
$string['deletepagesafterselected'] = 'Убрать разделители страниц после выбранных вопросов';
$string['deletepartcheck'] = 'Вы действительно хотите удалить выбранных участников?';
$string['deleteparticipantslist'] = 'Удалить список участников';
$string['deletepdfs'] = 'Удалить документы';
$string['deleteresultcheck'] = 'Вы действительно хотите удалить выбранные результаты?';
$string['deleteselectedpart'] = 'Удалить выбранных участников';
$string['deleteselectedresults'] = 'Удалить выбранные результаты';
$string['deletethislist'] = 'Удалить этот список';
$string['deleteupdatepdf'] = 'Удалить и обновить PDF-формы';
$string['difficultytitle'] = 'Сложность';
$string['difficultytitlea'] = 'Сложность A';
$string['difficultytitleb'] = 'Сложность B';
$string['difficultytitlediff'] = 'Различия';
$string['done'] = 'готово';
$string['downloadallzip'] = 'Скачать все файлы в архиве ZIP';
$string['downloadpartpdf'] = 'Скачать PDF-файл для списка {$a}';
$string['downloadpdfs'] = 'Скачать документы';
$string['downloadresultsas'] = 'Скачать результаты в:';
$string['editgroupquestions'] = 'Редактировать вопросы группы';
$string['editgroups'] = 'Редактировать офлайн-группы';
$string['editingofflinequiz'] = 'Редактирование группы вопросов';
$string['editlist'] = 'Редактировать список';
$string['editlists'] = 'Редактировать списки';
$string['editofflinequiz'] = 'Редактировать офлайн-тест';
$string['editorder'] = 'Редактировать последовательность';
$string['editparticipants'] = 'Редактировать участников';
$string['editquestions'] = 'Редактировать вопросы';
$string['editscannedform'] = 'Редактировать сканируемую форму';
$string['editthislist'] = 'Редактировать список';
$string['emptygroups'] = 'Некоторые группы офлайн-теста пусты. Пожалуйста, добавьте туда вопросы.';
$string['enroluser'] = 'Записать пользователя';
$string['erroraccessingreport'] = 'Вам не разрешено смотреть этот отчет';
$string['errorreport'] = 'Отчет об ошибках импорта';
$string['eventattemptdeleted'] = 'Попытка офлайн-теста удалена';
$string['eventattemptpreviewstarted'] = 'Начат просмотр попытки офлайн-теста';
$string['eventattemptreviewed'] = 'Пересмотрена попытка офлайн-теста';
$string['eventattemptsummaryviewed'] = 'Просмотрена сводка по попытке офлайн-теста';
$string['eventattemptviewed'] = 'Просмотрена попытка офлайн-теста';
$string['eventdocscreated'] = 'Созданы формы вопроса и ответа для офлайн-теста';
$string['eventdocsdeleted'] = 'Удалены формы вопроса и ответа для офлайн-теста';
$string['eventeditpageviewed'] = 'Просмотрена страница редактирования офлайн-теста';
$string['eventofflinequizattemptsubmitted'] = 'Отправлена попытка офлайн-теста';
$string['eventparticipantmarked'] = 'Участник офлайн-теста отмечен вручную';
$string['eventquestionmanuallygraded'] = 'Вопрос оценен вручную';
$string['eventreportviewed'] = 'Просмотрен отчет офлайн-теста';
$string['eventresultsregraded'] = 'Переоценены результаты офлайн-теста';
$string['everythingon'] = 'активировано';
$string['fileformat'] = 'Формат листов с вопросами';
$string['fontsize'] = 'Размер шрифта';
$string['forautoanalysis'] = 'Для автоматического анализа';
$string['formforcorrection'] = 'Форма коррекции для группы {$a}';
$string['formforgroup'] = 'Форма вопросов для группы {$a}';
$string['formforgroupdocx'] = 'Форма вопросов для группы {$a} (DOCX)';
$string['formsexist'] = 'Формы уже созданы';
$string['formsheetsettings'] = 'Настройки формы';
$string['formspreview'] = 'Предпросмотр для форм';
$string['generalfeedback'] = 'Основной отзыв';
$string['generatepdfform'] = 'Сгенерировать PDF-форму';
$string['grade'] = 'Оценка';
$string['gradedon'] = 'Оценено';
$string['gradedscannedform'] = 'Отсканированная форма с оценками';
$string['gradeiszero'] = 'Примечание: Максимальная оценка за этот офлайн-тест 0 баллов!';
$string['gradeswarning'] = 'Оценки для вопросов должны быть числовыми';
$string['gradewarning'] = 'Оценка за вопрос должна быть числовой';
$string['gradingofflinequiz'] = 'Оценки';
$string['gradingoptionsheading'] = 'Опции оценки.';
$string['greeniscross'] = 'засчитано как крестик';
$string['group'] = 'Группа';
$string['groupquestions'] = 'Группа вопросов';
$string['hasresult'] = 'Результат существует';
$string['idnumber'] = 'Идентификационный номер';
$string['imagefile'] = 'Файл изображения';
$string['imagenotfound'] = 'Файл изображения {$a} не найден';
$string['imagenotjpg'] = 'Изображение не соответствует формату JPG или PNG: {$a}';
$string['import'] = 'Импортировать';
$string['importedon'] = 'Импортировано';
$string['importerror11'] = 'Существует другой результат';
$string['importerror12'] = 'Пользователь не зарегистрирован';
$string['importerror13'] = 'Нет информации о группе';
$string['importerror14'] = 'Не удалось получить';
$string['importerror15'] = 'Ненадежная маркировка';
$string['importerror16'] = 'Ошибка страницы';
$string['importerror17'] = 'Незавершенные страницы';
$string['importerror21'] = 'Не удалось получить';
$string['importerror22'] = 'Ненадежная маркировка';
$string['importerror23'] = 'Пользователя нет в списке';
$string['importerror24'] = 'Список не обнаружен';
$string['importforms'] = 'Импортировать формы ответа';
$string['importfromto'] = 'Импортирование из {$a->from} в {$a->to}, всего {$a->total}.';
$string['importisfinished'] = 'Импортирование офлайн-теста {$a} завершено';
$string['importlinkresults'] = 'Ссылка на результаты: {$a}';
$string['importlinkverify'] = 'Ссылка для удостоверения: {$a}';
$string['importmailsubject'] = 'Уведомление об импорте офлайн-теста';
$string['importnumberexisting'] = 'Количество повторных форм: {$a}';
$string['importnumberpages'] = 'Количество успешно импортированных страниц: {$a}';
$string['importnumberresults'] = 'Количество импортированных: {$a}';
$string['importnumberverify'] = 'Количество форм, требующих удостоверения: {$a}';
$string['importtimefinish'] = 'Процесс завершен: {$a}';
$string['importtimestart'] = 'Процесс начат: {$a}';
$string['inconsistentdata'] = 'Противоречивые данные: {$a}';
$string['info'] = 'Информация';
$string['infoshort'] = 'i';
$string['insecuremarkings'] = 'Ненадежные отметки требуют ручной корректировки';
$string['insecuremarkingsforquestion'] = 'Ненадежные отметки требуют ручной корректировки для вопроса';
$string['insertnumber'] = 'Пожалуйста, вставьте верный идентификационный номер, помеченный голубой рамкой';
$string['instruction1'] = 'Данная форма ответов будет отсканирована автоматически. Пожалуйста, не складывайте и не пачкайте ее. Используйте синюю или черную ручку для ответов:';
$string['instruction2'] = 'Только четкие отметки будут оценены корректно. Если вам требуется исправление, закрасьте место для ответа и поле будет считаться пустым:';
$string['instruction3'] = 'Исправленные ответы не могут быть помечены снова. Пожалуйста, не пишите ничего за пределами специальных мест для ответов.';
$string['introduction'] = 'Введение';
$string['invigilator'] = 'Экзаменатор';
$string['ischecked'] = 'Участие отмечено';
$string['isnotchecked'] = 'Участие не отмечено';
$string['keepfilesfordays'] = 'Хранить файл (дней)';
$string['lightgray'] = 'Светло-серый';
$string['linktoscannedform'] = 'Просмотреть отсканированную форму';
$string['listnotdetected'] = 'Не удается определить штрих-код для списка';
$string['logdeleted'] = 'Запись журнала {$a} удалена.';
$string['logourl'] = 'URL логотипа';
$string['marks'] = 'Отметки';
$string['maxgradewarning'] = 'Максимальная оценка должна быть числом';
$string['membersinplist'] = '{$a->count} участников в <a href="{$a->url}">{$a->name}</a>';
$string['missingimagefile'] = 'Отсутствует файл изображения';
$string['missingitemdata'] = 'Отсутствуют ответы для пользователя {$a}';
$string['missinglogdata'] = 'Отсутствуют записи журнала для существующего результата';
$string['missingquestion'] = 'Данный вопрос больше не существует';
$string['missinguserid'] = 'Отсутствует идентификационный номер пользователя. Не удается прочитать штрих-код.';
$string['modulename'] = 'Офлайн-тест';
$string['modulenameplural'] = 'Офлайн-тесты';
$string['moodleprocessing'] = 'Позволить Moodle обрабатывать данные';
$string['movecorners'] = 'Измените расположение угловых маркеров, используя перетаскивание';
$string['moveselectedonpage'] = 'Переместить выбранные вопросы на страницу {$a}';
$string['multianswersforsingle'] = 'Несколько ответов в вопросе, где подразумевается один ответ';
$string['multichoice'] = 'Множественный выбор';
$string['multipleanswers'] = 'Выберите по меньшей мере один ответ';
$string['name'] = 'Название офлайн-теста';
$string['newgrade'] = 'Оценено';
$string['newpage'] = 'Новая страница';
$string['noattemptexists'] = 'Не существует результата';
$string['noattempts'] = 'Результаты не импортированы';
$string['noattemptsonly'] = 'Отобразить студентов без результатов';
$string['nogradesseelater'] = 'Тест еще не оценен для {$a}. Результаты будут опубликованы здесь.';
$string['nogroupdata'] = 'Нет информации о группе для пользователя {$a}';
$string['nomcquestions'] = 'Нет вопросов с множественным выбором в группе {$a}';
$string['noofflinequiz'] = 'Нет офлайн-теста с идентификатором {$a}';
$string['nopages'] = 'Не импортировано ни одной страницы';
$string['noparticipantsfound'] = 'Участники не найдены';
$string['nopdfscreated'] = 'Документы не созданы';
$string['noquestions'] = 'Некоторые группы офлайн-теста пусты. Пожалуйста, добавьте вопросы.';
$string['noquestionselected'] = 'Не выбрано ни одного вопроса.';
$string['noquestionsfound'] = 'Нет вопросов в группе {$a}';
$string['noquestionsonpage'] = 'Пустая страница';
$string['noresults'] = 'Нет результатов.';
$string['noreview'] = 'Вам не разрешено пересматривать офлайн-тест';
$string['noscannedpage'] = 'Нет отсканированных страниц с идентификатором {$a}';
$string['notxtfile'] = 'Нет TXT файла';
$string['notyetgraded'] = 'Еще не оценено';
$string['nozipfile'] = 'Нет ZIP файла';
$string['numattempts'] = 'Количество импортированных результатов: {$a}';
$string['numattemptsqueue'] = '{$a} форм ответов добавлено в очередь. После обработки данных на ваш email будет отправлено уведомление.';
$string['numattemptsverify'] = 'Отсканированные формы, ожидающие корректировки: {$a}';
$string['numberformat'] = 'Значением должно быть число из {$a} цифр.';
$string['numbergroups'] = 'Число групп';
$string['numpages'] = '{$a} страниц импортировано';
$string['numquestionsx'] = 'Вопросов: {$a}';
$string['numusersadded'] = '{$a} участников добавлено';
$string['offlineimplementationfor'] = 'Офлайн реализация для';
$string['offlinequiz:addinstance'] = 'Добавить офлайн-тест';
$string['offlinequiz:attempt'] = 'Попытка';
$string['offlinequizcloses'] = 'Офлайн-тест закрывается';
$string['offlinequizcloseson'] = 'Пересмотр офлайн-теста закроется {$a}';
$string['offlinequiz:createofflinequiz'] = 'Создать формы офлайн-теста';
$string['offlinequiz:deleteattempts'] = 'Удалить результаты офлайн-теста';
$string['offlinequiz:grade'] = 'Оценить офлайн-тесты вручную';
$string['offlinequizisclosed'] = 'Офлайн-тест закрыт)';
$string['offlinequizisclosedwillopen'] = 'Офлайн-тест закрыт (откроется {$a})';
$string['offlinequizisopen'] = 'Этот офлайн-тест открыт';
$string['offlinequizisopenwillclose'] = 'Офлайн-тест открыт (закроется {$a})';
$string['offlinequiz:manage'] = 'Управление офлайн-тестами';
$string['offlinequizopenedon'] = 'Этот офлайн тест открыт {$a}';
$string['offlinequizopens'] = 'Офлайн-тест открывается';
$string['offlinequiz:preview'] = 'Предпросмотр офлайн-тестов';
$string['offlinequizsettings'] = 'Офлайн-настройки';
$string['offlinequiz:view'] = 'Просмотр информации офлайн-теста';
$string['offlinequiz:viewreports'] = 'Просмотр отчетов офлайн-теста';
$string['oneclickenrol'] = 'Подписка в один клик';
$string['oneclickrole'] = 'Роль для подписки в один клик';
$string['onlylocalcategories'] = 'Только локальные категории вопросов';
$string['orderandpaging'] = 'Сортировка и постраничный вывод';
$string['orderingofflinequiz'] = 'Сортировка и постраничный вывод';
$string['otherresultexists'] = 'Уже существует другой результат для {$a}, импорт';
$string['outof'] = '{$a->grade} превышает максимум {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Общий отзыв';
$string['overview'] = 'Обзор';
$string['pagecorrected'] = 'Исправленный лист со списком участников импортирован';
$string['pageimported'] = 'Лист со списком участников импортирован';
$string['page-mod-offlinequiz-edit'] = 'Редактировать страницу офлайн-тестирования';
$string['page-mod-offlinequiz-x'] = 'Любая страница офлайн-теста';
$string['pagenotdetected'] = 'Не удается определить штрих-код для страницы.';
$string['pagenumberimported'] = 'Лист {$a} со списком участников импортирован';
$string['pagesizeparts'] = 'Отображать участников на странице:';
$string['papergray'] = 'Уровень белизны бумаги';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">{$a->count} отмеченных участников без результата</a>';
$string['partcheckedwithresult'] = '{$a} отмеченных участников с результатом';
$string['participants'] = 'Участники';
$string['participantsinlists'] = 'Участники в списках';
$string['participantslist'] = 'Список участников';
$string['participantslists'] = 'Участники';
$string['partuncheckedwithoutresult'] = '{$a} неотмеченных участников без результатов';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">{$a->count} неотмеченные участники без результата</a>';
$string['pdfdeletedforgroup'] = 'Форма для группы {$a} удалена';
$string['pdfintro'] = 'Дополнительная информация';
$string['pdfintrotext'] = '<b>Как отвечать?</b><br />Форма ответов будет отсканирована автоматически. Пожалуйста, не складывайте и не пачкайте ее. Используйте черную или синюю ручку. Если вам требуется поправить ответ - закрасьте поле для ответа и оно будет расценено как пустое.<br />';
$string['pdfintrotoolarge'] = 'Вступление слишком длинное (более 2000 символов)';
$string['pdfscreated'] = 'PDF-формы были созданы';
$string['pdfsdeletedforgroup'] = 'Формы для группы {$a} удалены';
$string['pearlywhite'] = 'Жемчужно белый';
$string['pluginadministration'] = 'Администрирование офлайн-теста';
$string['point'] = 'точка';
$string['present'] = 'существующий';
$string['preview'] = 'Предпросмотр';
$string['previewforgroup'] = 'Предпросмотр для группы {$a}';
$string['previewquestion'] = 'Предпросмотр вопроса';
$string['questionanalysis'] = 'Анализ сложности';
$string['questionanalysistitle'] = 'Таблица анализа сложности';
$string['questionbankcontents'] = 'Банк вопросов содержит';
$string['questionforms'] = 'Формы вопросов';
$string['questionname'] = 'Название вопроса';
$string['questionsheet'] = 'Лист вопроса';
$string['questionsin'] = 'Вопросов в';
$string['questionsingroup'] = 'Вопросов в группе';
$string['questionsinthisofflinequiz'] = 'Вопросов в этом офлайн-тесте';
$string['questiontextisempty'] = '[пустой текст вопроса]';
$string['quizdate'] = 'Дата офлайн-теста';
$string['quizopenclose'] = 'Даты открытия и закрытия';
$string['quizopenclose_help'] = 'Студенты могут просматривать свои попытки после открытия и до закрытия';
$string['quizquestions'] = 'Вопросы теста';
$string['readjust'] = 'Подрегулировать';
$string['realydeletepdfs'] = 'Вы действительно хотите удалить файлы формы?';
$string['realydeleteupdatepdf'] = 'Вы действительно хотите удалить и обновить список участников?';
$string['recreatepdfs'] = 'Пересоздать PDF-ки';
$string['rediswrong'] = 'неверный крестик или отсутствует крестик';
$string['refreshpreview'] = 'обновить предпросмотр';
$string['regrade'] = 'Переоценить';
$string['regradinginfo'] = 'Если вы меняете баллы за вопрос, вам нужно переоценить офлайн-тест, чтобы обновить результаты участников';
$string['regradingquiz'] = 'Переоценивание';
$string['regradingresult'] = 'Переоценивание результатов для пользователя {$a}...';
$string['reloadpreview'] = 'Перезагрузить предпросмотр';
$string['reloadquestionlist'] = 'Перезагрузить список вопросов';
$string['remove'] = 'Убрать';
$string['removeemptypage'] = 'Убрать пустую страницу';
$string['removeselected'] = 'Убрать выбранное';
$string['reordergroupquestions'] = 'Пересортировать вопросы группы';
$string['reorderquestions'] = 'Пересортировать вопросы';
$string['reordertool'] = 'Показать инструмент пересортировки';
$string['repaginate'] = 'Сформировать новый постраничный вывод с {$a} вопросами на странице';
$string['repaginatecommand'] = 'Сформировать новый постраничный вывод';
$string['repaginatenow'] = 'Сформировать новый постраничный вывод сейчас';
$string['reportstarts'] = 'просмотр результатов';
$string['resetofflinequizzes'] = 'Сбросить данные офлайн-теста';
$string['resultexists'] = 'Такой же результат для {$a} уже существует, импорт проигнорирован.';
$string['resultimport'] = 'Импорт результатов';
$string['results'] = 'Результаты';
$string['review'] = 'Обзор';
$string['reviewbefore'] = 'Позволить просмотр обзора при открытом офлайн-тесте';
$string['reviewclosed'] = 'После закрытия офлайн-теста';
$string['reviewcloses'] = 'Обзор закрывается';
$string['reviewimmediately'] = 'Сразу после попытки';
$string['reviewincludes'] = 'Обзор включает в себя';
$string['reviewofresult'] = 'Обзор результатов';
$string['reviewopens'] = 'Обзор открывается';
$string['reviewoptions'] = 'Студенты могут видеть';
$string['reviewoptionsheading'] = 'Опции обзора';
$string['rimport'] = 'Загрузить/Поправить';
$string['rotate'] = 'Повернуть';
$string['rotatingsheet'] = 'Лист повернут...';
$string['save'] = 'Сохранить';
$string['saveandshow'] = 'Сохранить и показать изменения студенту';
$string['savescannersettings'] = 'Сохранить настройки сканера';
$string['scannedform'] = 'Отсканированная форма';
$string['scannerformfortype'] = 'Форма для типа {$a}';
$string['scanneroptions'] = 'Настройки сканера';
$string['scannerpdfs'] = 'Пустые формы';
$string['scannerpdfstext'] = 'Скачайте следующие пустые формы, если вы хотите использовать свою программу для сканирования.';
$string['scanningoptionsheading'] = 'Опции сканирования';
$string['score'] = 'Количество очков';
$string['select'] = 'Выбрать';
$string['selectagroup'] = 'Выбрать группу';
$string['selectall'] = 'Выбрать все';
$string['selectcategory'] = 'Выбрать категорию';
$string['selectdifferentgroup'] = 'Пожалуйста, выберите другую группу';
$string['selectedattempts'] = 'Выбранные попытки...';
$string['selectformat'] = 'Выберите формат...';
$string['selectlist'] = 'Пожалуйста, выберите список или попробуйте подрегулировать лист:';
$string['selectnone'] = 'Снять отметки выбора';
$string['selectpage'] = 'Пожалуйста, выберите номер страницы или попробуйте подрегулировать лист:';
$string['selectquestiontype'] = '-- Выберите тип вопроса --';
$string['showallparts'] = 'Показать все {$a} участников';
$string['showcopyright'] = 'Показать авторскую отметку';
$string['showgrades'] = 'Печатать оценки вопросов';
$string['showmissingattemptonly'] = 'Показать всех выбранных участников без результата';
$string['showmissingcheckonly'] = 'Показать всех невыбранных участников без результата';
$string['shownumpartsperpage'] = 'Показывать {$a} участников на странице';
$string['showstudentview'] = 'Показать представление учащегося';
$string['showtutorial'] = 'Показать руководство по офлайн-тесту учащимся';
$string['showtutorialdescription'] = 'Вы можете добавить ссылку на руководство на страницу курса, используя URL:';
$string['shuffleanswers'] = 'Перемешать ответы';
$string['shufflequestions'] = 'Перемешать вопросы';
$string['shufflequestionsanswers'] = 'Перемешать вопросы и ответы';
$string['shufflewithin'] = 'Перемешать в вопросах';
$string['shufflewithin_help'] = 'Если включено, части, составляющие каждый вопрос будут перемешиваться случайным образом каждый раз, когда вы нажимаете кнопку перезагрузки в виде превью. ПРИМЕЧАНИЕ: Этот параметр применяется только к вопросам, у которых активировано перемешивание.';
$string['signature'] = 'Подпись';
$string['standard'] = 'Стандарт';
$string['starttutorial'] = 'Начать руководство по тестированию';
$string['statistics'] = 'Статистика';
$string['statisticsplural'] = 'Статистика';
$string['statsoverview'] = 'Обзор статистики';
$string['studycode'] = 'Код обучения';
$string['theattempt'] = 'Попытка';
$string['timesup'] = 'Время вышло!';
$string['totalquestionsinrandomqcategory'] = 'Всего {$a} вопросов в категории.';
$string['trigger'] = 'нижняя/верхняя граница';
$string['tutorial'] = 'Руководство по офлайн-тесту';
$string['type'] = 'Тип';
$string['uncheckparts'] = 'Отметить выбранных учатников как отсутствующих';
$string['updatedsumgrades'] = 'Сумма всех оценок группы {$a->letter} была пересчитана и составляет {$a->grade}.';
$string['upgradingilogs'] = 'Обновление отсканированных страниц: отсканировано страниц {$a->done}/{$a->outof} <br/>(идентификатор офлайн-теста {$a->info})';
$string['upgradingofflinequizattempts'] = 'Обновление попыток офлайн-теста: офлайн-тест {$a->done}/{$a->outof} <br/>(идентификатор офлайн-теста {$a->info})';
$string['upload'] = 'Загрузить/Исправить';
$string['uploadpart'] = 'Загрузить/Исправить список участников';
$string['useradded'] = 'Пользователь {$a} добавлен';
$string['userdoesnotexist'] = 'Пользователь {$a} не существует в системе';
$string['useridentification'] = 'Идентификация пользователя';
$string['userimported'] = 'Пользователь {$a} импортирован и оценен';
$string['usernotincourse'] = 'Пользователь {$a} не в курсе';
$string['usernotinlist'] = 'Пользователь не зарегистрирован в списке';
$string['usernotregistered'] = 'Пользователь {$a} не зарегистрирован в курсе';
$string['userpageimported'] = 'Одна страница импортирована для пользователя {$a}';
$string['valuezero'] = 'Значение должно быть отлично от нуля';
$string['viewresults'] = 'Просмотреть результаты';
$string['white'] = 'Белый';
$string['withselected'] = 'С выбранным...';
$string['zerogradewarning'] = 'Предупреждение: оценка за ваш офлайн-тест 0.0!';
$string['zipfile'] = 'ZIP-файл';
$string['zipok'] = 'ZIP-файл импортирован';
