<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'he', branch 'MOODLE_28_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'על סף התקנה';
$string['action'] = 'פעולה';
$string['actionchoice'] = 'מה ברצונך לעשות עם קובץ זה \'{$a}\' ?';
$string['actions'] = 'פעולות';
$string['active'] = 'פועל';
$string['activeusers'] = 'משתמשים פעילים';
$string['activities'] = 'פעילויות';
$string['activities_help'] = 'פעילויות, כגון פורומים, ויקי ובחנים מאפשרים הוספת תכנים אינטראקטיביים לקורס.';
$string['activity'] = 'פעילות';
$string['activityclipboard'] = 'העברת הפעילות <b>{$a}</b>';
$string['activityiscurrentlyhidden'] = 'מצטערים, הפעילות כרגע נמצאת במצב נסתר';
$string['activitymodule'] = 'רכיב פעילות';
$string['activitymodules'] = 'פעילויות ומשאבים';
$string['activityreport'] = 'דוח פעילות';
$string['activityreports'] = 'דוחות פעילות';
$string['activityselect'] = 'בחירת פעילות זאת והעברה למקום אחר';
$string['activitysince'] = 'פעילות מאז {$a}';
$string['activityweighted'] = 'פעילות לכל משתמש';
$string['add'] = 'הוספה';
$string['addactivity'] = 'הוספת פעילות';
$string['addactivitytosection'] = 'הוספת פעילות ליחידת־הוראה \'{$a}\'';
$string['addadmin'] = 'הוספת מנהל/ת';
$string['addblock'] = 'הוספת משבצת';
$string['addcomment'] = 'הוספת הערה...';
$string['addcountertousername'] = 'יצירת משתמש ע"י הוספת מספר לשם המשתמש';
$string['addcreator'] = 'הוספת יוצר-קורסים';
$string['adddots'] = 'הוספה...';
$string['added'] = 'נוסף "{$a}"';
$string['addedrecip'] = 'נוסף {$a} נמען חדש';
$string['addedrecips'] = 'נוספו {$a} נמענים חדשים';
$string['addedtogroup'] = 'הצטרף לקבוצה {$a}';
$string['addedtogroupnot'] = 'לא הצטרף לקבוצה {$a}';
$string['addedtogroupnotenrolled'] = 'לא צורף לקבוצה "{$a}", מאחר שלא נרשם לקורס';
$string['addfilehere'] = 'הוספת קובץ/קבצים כאן';
$string['addinganew'] = 'הוספת {$a}';
$string['addinganewto'] = 'הוספת {$a->what} ל- {$a->to}';
$string['addingdatatoexisting'] = 'הוספת מידע לקיים';
$string['additionalnames'] = 'שמות נוספים';
$string['addlinkhere'] = 'הוספת קישור כאן';
$string['addnewcategory'] = 'הוספת קטגוריה חדשה';
$string['addnewcourse'] = 'הוספת קורס חדש';
$string['addnewuser'] = 'הוספת משתמש חדש';
$string['addnousersrecip'] = 'הוספת משתמשים שלא קיבלו גישה ל- {$a} זה, לרשימת הנימענים';
$string['addpagehere'] = 'הוספת מלל כאן';
$string['addresource'] = 'הוספת משאב';
$string['addresourceoractivity'] = 'הוספת משאב או פעילות';
$string['addresourcetosection'] = 'הוספת משאב ליחידת־הוראה \'{$a}\'';
$string['address'] = 'כתובת';
$string['addstudent'] = 'הוספת סטודנט';
$string['addsubcategory'] = 'הוספת תת-קטגוריה';
$string['addteacher'] = 'הוספת מורה';
$string['admin'] = 'מנהל/ת';
$string['adminhelpaddnewuser'] = 'ליצירה ידנית של חשבון משתמש חדש';
$string['adminhelpassignadmins'] = 'מנהלים יכולים לעשות הכל וללכת לכל מקום במערכת';
$string['adminhelpassigncreators'] = '"יוצרי קורסים" יכולים ליצור קורסים חדשים';
$string['adminhelpassignsiteroles'] = 'הפניית הגדרת תפקידי האתר למשתמש מסויים';
$string['adminhelpassignstudents'] = 'להיכנס לקורס ולהוסיף סטודנטים מתפריט הניהול';
$string['adminhelpauthentication'] = 'מותר להשתמש חשבונות משתמשים פנימיים או בסיסי מידע חיצוניים';
$string['adminhelpbackup'] = 'הגדר גיבויים אוטומטיים ואת לוחות הזמנים שלהם';
$string['adminhelpconfiguration'] = 'הגדרת מראה ודרך העבודה של המערכת';
$string['adminhelpconfigvariables'] = 'הגדר משתנים המשפיעים על הפעילות הכללית של האתר';
$string['adminhelpcourses'] = 'הגדר קורסים וקטגוריות וצוות אליהם משתמשים';
$string['adminhelpeditorsettings'] = 'הגדרת כיוונונים בסיסיים לעורך דף התוכן המעוצב';
$string['adminhelpedituser'] = 'עיין ברשימת חשבונות המשתמשים וערוך כל אחד מהם';
$string['adminhelpenvironment'] = 'בדיקה, כיצד השרת מותאם בצורה הנוכחית ודרישות התקנה העתידיות שלו';
$string['adminhelpfailurelogs'] = 'צפה ברישומי יומני המעקב לנסיונות התחברות כושלים';
$string['adminhelplanguage'] = 'לבדיקה ועריכה של חבילת השפה הנוכחית';
$string['adminhelplogs'] = 'עיין ביומני המעקב של כל הפעילות באתר זה';
$string['adminhelpmanageblocks'] = 'ניהול משבצות מותקנות וההגדרות שלהם';
$string['adminhelpmanagedatabase'] = 'כניסה ישירה למאגר המידע (הייה זהיר!)';
$string['adminhelpmanagefilters'] = 'בחירת מסנני טקסט והגדרות קשורות';
$string['adminhelpmanagemodules'] = 'ניהול רכיבים מותקנים וההגדרות שלהם';
$string['adminhelpmanageroles'] = 'יצירה והגדרת תפקידים אשר יכולים להיות שימושיים למשתמשים';
$string['adminhelpmymoodle'] = 'הגדרת משבצות ה-Moodle שלי עבור משתמשים';
$string['adminhelpreports'] = 'דוחות רמת אתר';
$string['adminhelpsitefiles'] = 'לפרסום קבצים כלליים או להעלות גיבויים חיצוניים';
$string['adminhelpsitesettings'] = 'הגדר כיצד העמוד הראשי של האתר נראה';
$string['adminhelpstickyblocks'] = 'הגדר משבצות דביקות בכל אתר מוודל';
$string['adminhelpthemes'] = 'יש לבחור כיצד האתר נראה (צבעים, גופנים וכו\')';
$string['adminhelpuploadusers'] = 'יבא חשבונות משתמשים חדשים מקובץ טקסט';
$string['adminhelpusers'] = 'הגדרת המשתמשים ושיטות אימות';
$string['adminhelpxmldbeditor'] = 'ממשק עבור עריכת קבצי XMLDB. מיועד רק למפתחים.';
$string['administration'] = 'ניהול';
$string['administrationsite'] = 'ניהול המערכת';
$string['administrator'] = 'מנהל/ת';
$string['administratordescription'] = 'מנהלים יכולים בד"כ לעשות הכל במערכת זו, בכל הקורסים.';
$string['administrators'] = 'מנהלים';
$string['administratorsall'] = 'כל המנהלים';
$string['administratorsandteachers'] = 'מנהלים ומורים';
$string['advanced'] = 'יש להציג תחת \'הגדרות נוספות\'';
$string['advancedfilter'] = 'חיפוש מתקדם';
$string['advancedsettings'] = 'הגדרות מתקדמות';
$string['afterresource'] = 'אחרי המשאב "{$a}"';
$string['aftersection'] = 'אחרי היחידה "{$a}"';
$string['again'] = 'שוב';
$string['aimid'] = 'משתמש AIM';
$string['ajaxuse'] = 'AJAX ו-Javascript';
$string['all'] = 'הכל';
$string['allactions'] = 'כל הפעולות';
$string['allactivities'] = 'כל הפעילויות';
$string['allcategories'] = 'כל הקטגוריות';
$string['allchanges'] = 'כל השינויים';
$string['alldays'] = 'כל הימים';
$string['allfieldsrequired'] = 'כל התחומים נדרשים';
$string['allfiles'] = 'כל הקבצים';
$string['allgroups'] = 'כל הקבוצות';
$string['alllogs'] = 'כל הפעילות בקורס';
$string['allmods'] = 'כל ה{$a}';
$string['allow'] = 'הרשה';
$string['allowinternal'] = 'הרשה גם שיטות פנימיות';
$string['allownone'] = 'אל תרשה';
$string['allownot'] = 'אל תרשה';
$string['allparticipants'] = 'כל המשתתפים';
$string['allteachers'] = 'כל המורים';
$string['alphanumerical'] = 'יכול להכיל רק סימנים אלפא-נומריים, מקף (-) או נקודה.';
$string['alreadyconfirmed'] = 'ההרשמה כבר אושרה';
$string['alternatename'] = 'שם חלופי';
$string['always'] = 'תמיד';
$string['and'] = '{$a->one} ו-{$a->two}';
$string['answer'] = 'תשובה';
$string['any'] = 'כלשהו';
$string['appearance'] = 'תצוגה חזותית';
$string['approve'] = 'אישור';
$string['areyousure'] = 'האם אתה בטוח?';
$string['areyousuretorestorethis'] = 'האם אתה רוצה להמשיך?';
$string['areyousuretorestorethisinfo'] = 'מאוחר יותר בתהליך זה תהיה בידך האפשרות להוסיף את הגיבוי הזה לקורס קיים או ליצור קורס חדש.';
$string['asc'] = 'עולה';
$string['assessment'] = 'הערכה';
$string['assignadmins'] = 'מינוי מנהלים';
$string['assigncreators'] = 'מנה יוצרים';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'מינוי תפקידים מערכתיים';
$string['authenticateduser'] = 'משתמש מאומת';
$string['authenticateduserdescription'] = 'כל המשתמשים המחוברים';
$string['authentication'] = 'אימות';
$string['authenticationplugins'] = 'תוספי ניהול הזדהות למערכת';
$string['autosubscribe'] = 'מנוי אוטומטי לעדכונים מהפורומים';
$string['autosubscribeno'] = 'לא: אל תרשום אותי אוטומטית לפורומים';
$string['autosubscribeyes'] = 'כן: כשאני שולח הודעה, רשום אותי לפורום';
$string['availability'] = 'זמינות';
$string['availablecourses'] = 'קורסים זמינים';
$string['back'] = 'חזרה';
$string['backto'] = 'חזרה ל {$a}';
$string['backtocourselisting'] = 'בחזרה לרשימת הקורסים';
$string['backtopageyouwereon'] = 'חזרה לעמוד הקודם';
$string['backtoparticipants'] = 'בחזרה לרשימת המשתתפים';
$string['backup'] = 'גיבוי';
$string['backupactivehelp'] = 'יש לבחור האם להפעיל גיבויים אוטומטיים, או לא.';
$string['backupcancelled'] = 'הגיבוי בוטל';
$string['backupcoursefileshelp'] = 'אם זמינים אז קבצי הקורס יכללו בגיבויים האוטומטיים';
$string['backupdate'] = 'תאריך גיבוי';
$string['backupdatenew'] = '  {$a->TAG} כרגע {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} היה {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'פרטי גיבוי';
$string['backupexecuteathelp'] = 'יש לבחור מתי להריץ את הגיבויים הממוכנים';
$string['backupfailed'] = 'חלק מהקורסים שלך לא נשמרו!';
$string['backupfilename'] = 'גיבוי';
$string['backupfinished'] = 'הגיבוי הושלם בהצלחה';
$string['backupfromthissite'] = 'האם נעשה גיבוי לאתר זה?';
$string['backupgradebookhistoryhelp'] = 'אם מאופשר, היסטוריית גליון ציונים תיכלל בגיבויים האוטומטים. דע, כי אסור להיסטוריית הציונים להיות לא-זמינה בהגדרות השרת  (disablegradehistory) בכדי שהדבר יעבוד.';
$string['backupincludemoduleshelp'] = 'יש לבחור האם לכלול את רכיבי הקורס, עם או ללא נתוני משתמש, בגיבויים אוטומטיים';
$string['backupincludemoduleuserdatahelp'] = 'יש לבחור האם לכלול נתוני משתמש בגיבויים האוטומטיים.';
$string['backupkeephelp'] = 'כמה גיבויים חדשים אתה רוצה לשמור לכל קורס? (גיבויים ישנים יותר יימחקו אוטומטית)';
$string['backuplogdetailed'] = 'דוח הפעלה מפורט';
$string['backuploglaststatus'] = 'דוח הפעלה אחרון';
$string['backupmissinguserinfoperms'] = 'הערה: גיבוי זה לא מכיל אף מידע על משתמש. פעילויות תרגיל והערכת עמיתים (סדנה) לא יכללו בגיבוי זה מפני שמודולים אלו לא תואמים סוג גיבוי זה.';
$string['backupnext'] = 'הגיבוי הבא';
$string['backupnonisowarning'] = 'אזהרה: גיבוי זה הוא מגירסת non-Unicode ל-Moodle pre 1.6. אם גיבוי זה מכיל טקסטים שהם non-ISO כלשהם הם עלולים להיות פגומים כאשר תנסה את 1-8859 בכדי לשחזר אותם לגירסת ה-Unicode הזו של Moodle. ראה ב- <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> למידע נוסף על-מנת לשחזר גיבוי זה בצורה נכונה.';
$string['backupnotyetrun'] = 'גיבוי אוטומטי בהמתנה';
$string['backuporiginalname'] = 'שם גיבוי';
$string['backuproleassignments'] = 'גיבוי הקצאות תפקידים עבור תפקידים אלו';
$string['backupsavetohelp'] = 'דרך מלאה לתיקיה בה אתה רוצה לשמור את קבצי הגיבוי <br /> (השאר ריק בכדי לשמור תיקיית ברירת מחדל של הקורס)';
$string['backupsitefileshelp'] = 'באם יאושר אזי קבצי באתר שמשתמשים בהם בקורס יהיו כלולים אוטומטית בגיבויים';
$string['backuptakealook'] = 'אנא בדוק את רישומי הגיבוי שלך ב:
{$a}';
$string['backupuserfileshelp'] = 'יש לבחור האם קבצי משתמשים (לדוגמא תמונות המשתמשים) צריכים להיכלל בגיבויים אוטומטיים';
$string['backupversion'] = 'גרסת גיבוי';
$string['badges'] = 'הישגים';
$string['block'] = 'משבצת (בלוק)';
$string['blockconfiga'] = 'מגדיר את תצורת המשבצת {$a}';
$string['blockconfigbad'] = 'משבצת זו לא מומשה כהלכה ולכן היא לא יכולה לספק ממשק הגדרות.';
$string['blocks'] = 'משבצות (בלוקים)';
$string['blocksaddedit'] = 'עריכת/הוספת משבצות';
$string['blockseditoff'] = 'סיום עריכת משבצות';
$string['blocksediton'] = 'עריכת משבצות';
$string['blocksetup'] = 'יצירת טבלאות עבור המשבצת';
$string['blocksuccess'] = 'הטבלאות {$a} נוצרו באופן תקין';
$string['brief'] = 'מצומצמת';
$string['bulkactions'] = 'פעולות חובקות';
$string['bulkactionselect'] = 'בחירת {$a} פעולות חובקות';
$string['bulkmovecoursessuccess'] = 'קורס {$a->courses} עבר לקטגוריה {$a->category} בהצלחה';
$string['bycourseorder'] = 'לפי סדר קורסים';
$string['byname'] = 'לפי {$a}';
$string['bypassed'] = 'נעקף';
$string['cachecontrols'] = 'כלי בקרת מטמון';
$string['cancel'] = 'ביטול';
$string['cancelled'] = 'בוטל';
$string['categories'] = 'קטגוריות קורסים';
$string['categoriesandcoures'] = 'קטגוריות וקורסים';
$string['category'] = 'קטגוריה';
$string['categoryadded'] = 'הקטגוריה \'{$a}\' התווספה';
$string['categorybulkaction'] = 'פעולות חובקות לקטגוריות נבחרות';
$string['categorycontents'] = 'תתי-קטגוריות וקורסים';
$string['categorycurrentcontents'] = 'תכני ה{$a}';
$string['categorydeleted'] = 'הקטגוריה \'{$a}\' נמחקה';
$string['categoryduplicate'] = 'קטגוריה בשם \'{$a}\' כבר קיימת!';
$string['categorymodifiedcancel'] = 'הקטגוריה עודכנה! יש לבטל ונסות שנית';
$string['categoryname'] = 'שם הקטגוריה';
$string['categorysubcategoryof'] = 'קטגוריה {$a->category}  תת-קטגוריה מ-{$a->parentcategory}';
$string['categoryupdated'] = 'הקטגוריה \'{$a}\' עודכנה';
$string['changedpassword'] = 'שינוי סיסמה';
$string['changepassword'] = 'שינוי סיסמה';
$string['changesmadereallygoaway'] = 'ניתן לערוך שינויים. האם בטוח כי ברצונך';
$string['changessaved'] = 'שינויים נשמרו';
$string['check'] = 'בדוק';
$string['checkall'] = 'בדוק הכל';
$string['checkingbackup'] = 'בודק גיבוי';
$string['checkingcourse'] = 'בודק קורס';
$string['checkingforbbexport'] = 'מחפש יצוא BlackBoard';
$string['checkinginstances'] = 'בודק הופעות';
$string['checkingsections'] = 'בודק יחידות־הוראה';
$string['checklanguage'] = 'בדיקת שפה';
$string['checknone'] = 'אל תבדוק';
$string['childcoursenotfound'] = 'הקורס הנגזר לא נמצא!';
$string['childcourses'] = 'קורסיי בנים';
$string['choose'] = 'בחירה';
$string['choosecourse'] = 'בחירת קורס';
$string['choosedots'] = 'בחירה...';
$string['chooselivelogs'] = 'או צפיה בפעילות נוכחית';
$string['chooselogs'] = 'בחירת יומני מעקב אותם יש להציג';
$string['choosereportfilter'] = 'בחירת מסנן לדיווח';
$string['choosetheme'] = 'בחירת ערכת עיצוב';
$string['chooseuser'] = 'בחירת משתמש';
$string['city'] = 'ישוב';
$string['clambroken'] = 'מנהל המערכת שלך איפשר בדיקת וירוסים עבור קבצים המועלים לאתר, אבל כנראה שגה בהגדרות.<br />העלאת הקובץ שלך לא הצליחה. למנהל המערכת שלך נשלחה הודעת דוא"ל כדי שהבעיה תתוקן.<br />נסה להעלות שוב את הקובץ במועד מאוחר יותר.';
$string['clamdeletedfile'] = 'הקובץ נמחק';
$string['clamdeletedfilefailed'] = 'מחיקת הקובץ נכשלה';
$string['clamemailsubject'] = '{$a} :: הודעת Clam AV';
$string['clamfailed'] = 'תוכנת Clam AV נכשלה בעת הפעלת. הודעת השגיאה שחזרה הייתה: {$a}. הינה הפלט מ-Clam';
$string['clamlost'] = 'Moodle מוגדר להפעיל את clam בהעלאת קובץ, אך הנתיב {$a} המסופק ל- Calm AV לא חוקי (שגוי).';
$string['clamlostandactinglikevirus'] = 'בנוסף, Moodle מוגדר כך שאם clam נכשלת מלרוץ, קבצים יטופלו כאל וירוסים. דבר זה יעיד בעיקר על כך שאף סטודנט לא יוכל לעלות קבצים עד שבעיה זו תתוקן.';
$string['clammovedfile'] = 'הקובץ הועבר ספריית ההסגר שציינת, המיקום החדש הוא {$a}';
$string['clammovedfilebasic'] = 'הקובץ הועבר לספריית הסגר, מוגנת.';
$string['clamquarantinedirfailed'] = 'ניתן היה להעביר את הקובץ שלך לספריית ההסגר, {$a}. עליך לתקן זאת כאשר קבצים נמחקים אם הם נמצאים נגועים.';
$string['clamunknownerror'] = 'תוכנת clam דיווחה על הודעה לא מזוהה.';
$string['cleaningtempdata'] = 'מנקה נתונים זמניים';
$string['clear'] = 'איפוס';
$string['clickhelpiconformoreinfo'] = 'המשך... לחץ על קישור העזרה לקריאה... המאמר המלא';
$string['clickhere'] = 'לחץ כאן...';
$string['clicktochangeinbrackets'] = '{$a} (לחץ לשינוי)';
$string['clicktohideshow'] = 'הקש להרחבה או לצמצום';
$string['closebuttontitle'] = 'סגירה';
$string['closewindow'] = 'סגור את החלון הזה';
$string['collapse'] = 'צמצם';
$string['collapseall'] = 'תצוגה מצומצמת';
$string['collapsecategory'] = 'כיווץ {$a}';
$string['commentincontext'] = 'מצא הערה זו בהקשר';
$string['comments'] = 'הערות';
$string['commentscount'] = '({$a}) הערות';
$string['commentsnotenabled'] = 'תכונת הערות לא מאופשרת';
$string['commentsrequirelogin'] = 'יש להתחבר למערכת בכדי לצפות בתגובות';
$string['comparelanguage'] = 'השוואה ועריכת חבילת שפה נוכחית';
$string['complete'] = 'הושלם';
$string['completereport'] = 'דוח פעילות ותוצרים מפורט';
$string['configuration'] = 'עדכן';
$string['confirm'] = 'אשר';
$string['confirmcheckfull'] = 'האם הינך בטוח לחלוטין שאתה רוצה לאשר {$a}';
$string['confirmcoursemove'] = 'האם הינך בטוח כי ברצונך להעביר את הקורס ({$a->course}) לקטגוריה ({$a->category}) ?';
$string['confirmed'] = 'ההרשמה שלך אושרה';
$string['confirmednot'] = 'ההרשמה שלך עדיין לא אושרה!';
$string['content'] = 'תוכן';
$string['continue'] = 'המשך';
$string['continuetocourse'] = 'מעבר לעמוד הראשי של הקורס';
$string['convertingwikitomarkdown'] = 'המרת ויקי לשפת סימנים Markdown';
$string['cookiesenabled'] = 'הדפדפן שלך צריך לאפשר עוגיות';
$string['cookiesenabled_help'] = '<p align="right" dir="rtl"><span lang="he"><b>עוגיות</b></span></p>

<p align="right" dir="rtl"><span lang="he">האתר הזה עושה שימוש בשתי עוגיות.
</span></p>

<p align="right" dir="rtl"><span lang="he">העוגיה ההכרחית היא עוגיית המפגש,
ולרוב היא נקראת </span> <b>MoodleSession<span lang="he">. </span></b>
<span lang="he">אתם חייבים להרשות לעוגייה הזאת להיכנס לדפדפן שלכם כדי לשמור על
המשכיות ולשמור על כך שתישארו מחוברים למערכת כשאתם עוברים מעמוד לעמוד. כשאתם
מתנתקים מהמערכת או כשאתם סוגרים את הדפדפן העוגייה הזו נהרסת (vהן על הדפדפן והן על
השרת שלכם). </span></p>

<p align="right" dir="rtl"><span lang="he">העוגייה האחרת נמצאת רק מטעמי נוחיות,
ולרוב היא השם שלה הוא משהו בסגנון </span> <b>MOODLEID<span lang="he">. </span></b>
<span lang="he">כל מה שהיא עושה זה לזכור את שם המשתמש שלכם בתוך הדפדפן. הדבר
אומר שכשאתם תחזרו לאתר הזה בשם המשתמש בעמוד ההתחברות כבר יהיה כתוב השם שלכם. זה
בטוח לסרב לעוגייה הזו, זה רק אומר שתצטרכו להקליד מחדש את שם המשתמש שלכם בכל פעם
שתרצו להתחבר. </span></p>';
$string['cookiesnotenabled'] = 'לתשומת לבך, עוגיות אינן מאופשרות כרגע בדפדפן שלך';
$string['copy'] = 'העתק';
$string['copyasnoun'] = 'העתק';
$string['copyingcoursefiles'] = 'מעתיק קבצי קורס';
$string['copyingsitefiles'] = 'העתקת קבצי האתר המשמשים בקורס';
$string['copyinguserfiles'] = 'מעתיק קבצי משתמש';
$string['copyingzipfile'] = 'מעתיק קבצי ארכיב';
$string['copyrightnotice'] = 'אזהרת זכויות יוצרים';
$string['coresystem'] = 'ליבת המערכת';
$string['cost'] = 'מחיר';
$string['costdefault'] = 'מחיר בררת־מחדל';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'ארץ';
$string['course'] = 'קורס';
$string['courseadministration'] = 'ניהול הקורס';
$string['courseapprovedemail'] = 'בקשת קורס, {$a->name}, שלך אושרה והמורה שלך הוא {$a->teacher}.בכדי להיכנס לקורס החדש שלך לחץ {$a->url}';
$string['courseapprovedemail2'] = 'הקורס שבקשת, {$a->name}, אושר. בכדי לגשת לקורס החדש שלך, המשך ל-{$a->url}';
$string['courseapprovedfailed'] = 'נכשל בנסיון לשמור את הקורס כמאושר';
$string['courseapprovedsubject'] = 'הקורס שלך מאושר';
$string['courseavailable'] = 'קורס זה זמין לסטודנטים';
$string['courseavailablenot'] = 'קורס זה אינו זמין לסטודנטים';
$string['coursebackup'] = 'גיבוי קורס';
$string['coursebulkaction'] = 'פעולות חובקות עבור הקורסים הנבחרים';
$string['coursecategories'] = 'קטגוריות קורסים';
$string['coursecategory'] = 'קטגוריית הקורס';
$string['coursecategorydeleted'] = 'קטגוריית הקורס {$a} נמחקה';
$string['coursecategory_help'] = '<p align="center"><b>קטגוריות קורסים</b></p>

<p>יכול להיות שמנהל המוודל שלכם יצטרך להקים מספר קטגוריות של קורסים.
</p>

<p>לדוגמא, "מדע", "אומנות", "בריאות הציבור" וכדומה.
</p>

<p>ביחרו בקטגוריה שהכי מתאימה לקורס שלכם. הבחירה הזו תשפיע על המקום שבו הקורס שלכם יופיע ברשימות הקורסים, דבר שיקל על הסטודנטים למצוא אותו.
</p>';
$string['coursecatmanagement'] = 'ניהול קורסים וקטגוריות';
$string['coursecompletion'] = 'השלמת הקורס';
$string['coursecompletions'] = 'השלמות הקורסים';
$string['coursecreators'] = 'יוצרי הקורס';
$string['coursecreatorsdescription'] = '"יוצרי קורס" יכולים ליצור קורסים חדשים.';
$string['coursedeleted'] = 'קורס {$a} נמחק';
$string['coursedisplay'] = 'תצוגת יחידות הוראה';
$string['coursedisplay_help'] = 'הגדרה זו קובעת האם כל הקורס יוצג בעמוד אחד או שיתפזר על-פני כמה עמודים.';
$string['coursedisplay_multi'] = 'הצגת יחידת־הוראה אחת בכל עמוד';
$string['coursedisplay_single'] = 'הצגת כל יחידות־הוראה בעמוד אחד';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'קבצי הקורס כפי שנוהלו בגרסאות  קודמות';
$string['coursefilesedit'] = 'עריכת קבצי הקורס כפי שנוהלו בגרסאות קודמות';
$string['coursefileswarning'] = 'ירידת ערכם של קבצי הקורס
';
$string['coursefileswarning_help'] = 'ערכם של קבצי הקורס ירד החל ממוודל 2.0, השתמש ככל האפשר במאגרים חימוניים.';
$string['courseformatdata'] = 'נתוני מבנה הקורס';
$string['courseformatoptions'] = 'אפשרויות עבור תצורת־קורס: "{$a}"';
$string['courseformats'] = 'תצורות תצוגת קורס';
$string['courseformatudpate'] = 'עדכון תצורה';
$string['coursegrades'] = 'ציוני הקורס';
$string['coursehelpcategory'] = 'מקם את הקורס ברשימת הקורסים בכדי להקל על הסטודנטים במציאת הקורס.';
$string['coursehelpforce'] = 'הכרח מצב קבוצה של הקורס לכל פעילות בקורס.';
$string['coursehelpformat'] = 'דף הראשי של הקורס יוצג במבנה זה.';
$string['coursehelphiddensections'] = 'אופן התצוגה של יחידות־הוראה מוסתרות, לסטודנטים בקורס.';
$string['coursehelpmaximumupload'] = 'הגדרת הגודל המרבי להעלאת קובץ ע"י המשתמשים בקורס זה, מוגבל ע"י ההגדרות ניהול של המערכת.';
$string['coursehelpnewsitemsnumber'] = 'מספר הפריטים האחרונים המופיעים בעמוד הבית של הקורס תחת משבצת חדשות אחרונות , מפורום לוח מודעות. 0 משמעותו כי המשבצת לא תופיע.';
$string['coursehelpnumberweeks'] = 'מספר יחידות ההוראה שיופיעו בקורס (משפיע על תצורות קורס מסויימות בלבד)';
$string['coursehelpshowgrades'] = 'הסתרת/הצגת גליון־הציונים. הדבר לא מונע מהציונים להופיע בתוך פעילויות שונות בקורס.';
$string['coursehidden'] = 'קורס זה אינו זמין כרגע לסטודנטים';
$string['courseinfo'] = 'מידע הקורס';
$string['courselegacyfiles'] = 'קבצי הקורס כפי שנוהלו בגרסאות קודמות';
$string['courselegacyfilesofcourse'] = 'קבצים ממהדורות קודמות: {$a}';
$string['coursemessage'] = 'הודעות הקורס למשתמשים';
$string['coursenotaccessible'] = 'קורס זה אינו מאפשר גישה ציבורית';
$string['courseoverview'] = 'סקירה כללית של הקורס';
$string['courseoverviewfiles'] = 'קבצים נלווים לתקציר קורס';
$string['courseoverviewfilesext'] = 'סוגי קובצי המבוא הציבוריים של הקורס';
$string['courseoverviewfiles_help'] = 'קבצים אשר מוצגים באופן ציבורי לפי הכניסה לקורס, תחת פסקאת התאור הכללי של הקורס.  למשל: סילבוס, מידע כללי, דרישות קדם לקורס, תוכן עניינים, ועוד...';
$string['courseoverviewfileslimit'] = 'מגבלת כמות קובצי המבוא הציבוריים של הקורס';
$string['courseoverviewgraph'] = 'גרף הסוקר כללית את הקורס';
$string['courseprofiles'] = 'פרופיל משתמש בקורס:';
$string['coursereasonforrejecting'] = 'סיבותך לדחיית בקשה זו';
$string['coursereasonforrejectingemail'] = 'ישלח דוא"ל למבקש';
$string['coursereject'] = 'דחיית בקשת הקורס';
$string['courserejected'] = 'הקורס נדחה והדבר נודע למבקש.';
$string['courserejectemail'] = 'מצטערים, אך בקשת הקורס שלך נדחתה. הינה הסיבה לכך: {$a}';
$string['courserejectreason'] = 'תמצית הסיבות לדחיית קורס זה <br> (ישלח אל מבקש הקורס בדוא"ל)';
$string['courserejectsubject'] = 'בקשת הקורס שלך נדחתה';
$string['coursereport'] = 'דוח הקורס';
$string['coursereports'] = 'דוח הקורס';
$string['courserequest'] = 'בקשת קורס';
$string['courserequestdetails'] = 'פרטי הקורס שביקשת';
$string['courserequestfailed'] = 'מסיבה כלשהי, בקשת הקורס שלך לא ניתנה לשמירה';
$string['courserequestintro'] = 'השתמש בטופס זה כדי לבקש יצירת קורס בשבילך.<br> השתדל למלא מידע רב על הקורס בכדי לאפשר למנהלים להבין את סיבותיך לבקשת קורס זה.';
$string['courserequestreason'] = 'סיבות לבקשת קורס זה';
$string['courserequestsuccess'] = 'בקשת הקורס שלך נשמרה בהצלחה. צפה לקבלת דוא"ל תוך מספר ימים לקבלת התוצאה';
$string['courserequestsupport'] = 'מידע נוסף בכדי לעזור למנהל(ת) המערכת לסייע לבקשה זו';
$string['courserestore'] = 'שחזר קורס';
$string['courses'] = 'קורסים';
$string['coursesectionsummaries'] = 'פסקאות מבוא בקורס';
$string['coursesectiontitle'] = 'קורס: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'ברירות־מחדל בקורס';
$string['coursesmovedout'] = 'הקורסים הועברו מ{$a}';
$string['coursespending'] = 'קורסים המחכים לאישור';
$string['coursestart'] = 'התחלת הקורס';
$string['coursesummary'] = 'תקציר הקורס';
$string['coursesummary_help'] = 'תקציר הקורס מוצג ברשימת הקורסים. חיפוש קורס מחפש טקסט בנוסף לשמות הקורסים.';
$string['coursetitle'] = 'קורס: {$a->course}';
$string['courseupdates'] = 'עדכוני קורסים';
$string['create'] = 'יצירה';
$string['createaccount'] = 'יצירת חשבון חדש';
$string['createcategory'] = 'יצירת קטגוריה';
$string['createfolder'] = 'יצירת תיקייה ב {$a}';
$string['createnew'] = 'יצירת חדש';
$string['createnewcategory'] = 'יצירת קטגוריה חדשה';
$string['createnewcourse'] = 'יצירת קורס חדש';
$string['createnewsubcategory'] = 'יצירת תת־קטגוריה חדשה';
$string['createsubcategoryof'] = 'יצירת תת־קטגוריה חדשה של {$a}';
$string['createuser'] = 'יצירת משתמש';
$string['createuserandpass'] = 'הזנת שם־משתמש וסיסמה';
$string['createziparchive'] = 'יצירת קובץ ארכיון 7zip';
$string['creatingblocks'] = 'יצירת משבצות';
$string['creatingblocksroles'] = 'יצירת הקצאות תפקידים ברמת המשבצת ועקיפתן';
$string['creatingblogsinfo'] = 'יצירת יצירת המידע של הבלוגים';
$string['creatingcategoriesandquestions'] = 'יצירת קטגוריות ושאלות';
$string['creatingcoursemodules'] = 'יצירת המודולים של הקורס';
$string['creatingcourseroles'] = 'יצירת הקצאות תפקידים של רמת הקורס ועקיפתן';
$string['creatingevents'] = 'יצירת אירועים';
$string['creatinggradebook'] = 'יוצר ספר ציונים';
$string['creatinggroupings'] = 'יצירת אוספי קבוצות';
$string['creatinggroupingsgroups'] = 'הוספת קבוצות לאוספי קבוצות';
$string['creatinggroups'] = 'יצירת קבוצות';
$string['creatinglogentries'] = 'יצירת רשימות יומן מעקב';
$string['creatingmessagesinfo'] = 'יוצר מידע הודעות';
$string['creatingmodroles'] = 'יצירת הקצאות תפקידים של רמת הרכיב ועקיפתן';
$string['creatingnewcourse'] = 'יצירת קורס חדש';
$string['creatingrolesdefinitions'] = 'יצירת הגדרות תפקידים';
$string['creatingscales'] = 'יצירת מדרגות־הערכה';
$string['creatingsections'] = 'יצירת יחידות־הוראה';
$string['creatingtemporarystructures'] = 'יצירת מבנים זמניים';
$string['creatinguserroles'] = 'יצירת הקצאות תפקידים של רמת המשתמש ועקיפתן';
$string['creatingusers'] = 'יצירת משתמשים';
$string['creatingxmlfile'] = 'יצירת קובץ XML';
$string['currency'] = 'מטבע';
$string['currentcourse'] = 'הקורס הנוכחי';
$string['currentcourseadding'] = 'הקורס הנוכחי, הוספת מידע אליו';
$string['currentcoursedeleting'] = 'הקורס הנוכחי, עם מחיקה קודמת';
$string['currentlanguage'] = 'שפה נוכחית';
$string['currentlocaltime'] = 'הזמן המקומי הנוכחי שלך';
$string['currentlyselectedusers'] = 'המשתמשים הנוכחיים שנבחרו';
$string['currentpicture'] = 'תמונה נוכחית';
$string['currentrelease'] = 'מאפייניי גירסה נוכחית';
$string['currentversion'] = 'גירסה עכשווית';
$string['databasechecking'] = 'שדרוג בסיס נתונים Moodle מגירסה {$a->oldversion} ל {$a->newversion}...';
$string['databaseperformance'] = 'ביצועי בסיס נתונים';
$string['databasesetup'] = 'הקמת בסיס נתונים';
$string['databasesuccess'] = 'בסיס הנתונים שודרג בהצלחה';
$string['databaseupgradebackups'] = 'גרסת הגיבוי היא עכשיו {$a}';
$string['databaseupgradeblocks'] = 'הגרסה הנוכחית של המשבצות היא {$a}';
$string['databaseupgradegroups'] = 'גרסת קבוצות היא כעת {$a}';
$string['databaseupgradelocal'] = 'גירסת ההתאמות האישיות של מסד הנתונים המקומי היא {$a}';
$string['databaseupgrades'] = 'שדרוג בסיס נתונים';
$string['date'] = 'תאריך';
$string['datechanged'] = 'תאריך שונה';
$string['datemostrecentfirst'] = 'תאריך - הכי חדשים ראשונים';
$string['datemostrecentlast'] = 'תאריך - הכי חדשים אחרונים';
$string['day'] = 'יום';
$string['days'] = 'ימים';
$string['decodinginternallinks'] = 'מפענח קישורים פנימיים';
$string['default'] = 'בררת־מחדל';
$string['defaultcoursestudent'] = 'סטודנט';
$string['defaultcoursestudentdescription'] = 'באופן כללי לסטודנטים יש זכויות גישה פחותות לכל קורס';
$string['defaultcoursestudents'] = 'סטודנטים';
$string['defaultcoursesummary'] = 'כתוב כאן פסקה תמציתית ומעניינת המסבירה על קורס  זה';
$string['defaultcourseteacher'] = 'מורה';
$string['defaultcourseteacherdescription'] = 'מורים יכולים לעשות הכל בקורס, כולל שינוי פעילויות ומתן ציונים לסטודנטים';
$string['defaultcourseteachers'] = 'מורים';
$string['defaulteditor'] = 'עורך בררת־מחדל';
$string['delete'] = 'מחיקה';
$string['deleteablock'] = 'מחיקת משבצת';
$string['deleteall'] = 'מחק הכל';
$string['deleteallcannotundo'] = 'מחיקת קטגוריה וכל הקורסים - לא ניתן לשחזר לאחר ביצוע פעולה זו!';
$string['deleteallcomments'] = 'מחיקת כל ההערות';
$string['deleteallratings'] = 'מחיקת כל הדירוגים';
$string['deletecategory'] = 'מחק את קטגוריה: {$a}';
$string['deletecategorycheck'] = 'האם אתה בטוח בהחלט כי אתה רוצה למחוק לגמרי את הקטגוריה הזו <b> \'{$a}\'</b>?<br /> דבר זה יעביר את כל הקורסים לקטגוריית המקור אם קיימת אחת כזאת, או אל קטגוריה שונות.';
$string['deletecategorycheck2'] = 'אם תמחק קטגוריה זאת, תצטרך להחליט מה לעשות עם הקורסים ותתי הקטגוריות שהיא מכילה.';
$string['deletecategoryempty'] = 'קטגוריה זו ריקה.';
$string['deletecheck'] = 'מחק {$a} ?';
$string['deletecheckfiles'] = 'האם אתה בטוח לחלוטין שאתה רוצה למחוק את הקבצים הללו?';
$string['deletecheckfull'] = 'האם אתה לגמרי בטוח שאתה רוצה למחוק את {$a} לחלוטין?';
$string['deletechecktype'] = 'האם הינך בטוח כי ברצונך למחוק את  {$a->type}?';
$string['deletechecktypename'] = 'האם הינך בטוח כי ברצונך למחוק את  {$a->type} "{$a->name}"';
$string['deletecheckwarning'] = 'אתה עומד למחוק את הקבצים הללו';
$string['deletecomment'] = 'מחר הערה זו';
$string['deletecompletely'] = 'מחיקה מוחלטת';
$string['deletecourse'] = 'מחק קורס';
$string['deletecoursecheck'] = 'האם אתה לגמרי בטוח שאתה רוצה למחוק לחלוטין את הקורס ואת כל המידע שהוא מכיל?';
$string['deleted'] = 'נמחק';
$string['deletedactivity'] = 'נמחק {$a}';
$string['deletedcourse'] = '{$a} נמחק לחלוטין';
$string['deletednot'] = 'לא ניתן היה למחוק {$a} !';
$string['deleteselected'] = 'מחיקת הפריטים שנבחרו';
$string['deleteselectedkey'] = 'מחיקת המפתח שנבחר';
$string['deletingcourse'] = 'מוחק {$a}';
$string['deletingexistingcoursedata'] = 'מוחק נתוני קורס קיימים';
$string['deletingolddata'] = 'מוחק נתונים ישנים';
$string['department'] = 'מחלקה';
$string['desc'] = 'יורד';
$string['description'] = 'תיאור';
$string['deselectall'] = 'ביטול בחירה להכל';
$string['detailedless'] = 'פחות מפורט';
$string['detailedmore'] = 'יותר מפורט';
$string['directory'] = 'ספריה';
$string['disable'] = 'לא פעיל';
$string['disabledcomments'] = 'כתיבת הערות אינה-זמינה';
$string['displayingfirst'] = 'רק הראשונים {$a->count} {$a->things} מוצגים';
$string['displayingrecords'] = 'מציג {$a} רשומות';
$string['displayingusers'] = 'מציג משתמשים {$a->start} עד {$a->end}';
$string['displayonpage'] = 'הצג בעמוד';
$string['dndcourse'] = 'ניתן לגרור ולשחרר את הקורס הזה כדי לשנות את המיון שלו או להעביר אותו לקטגוריה אחרת';
$string['dndenabled_inbox'] = 'ניתן להעתיק קבצים מהמחשב האישי לרכיב זה, על ידי גרירה ושחרור.';
$string['dndnotsupported'] = 'לא קיימת תמיכה (בדפדפן) להעלאת קבצים בגרירה';
$string['dndnotsupported_help'] = 'הדפדפן שלכם אינו תומך בהעלאת קבצים עלי ידי גרירתם לדפדפן.<br />יכולת זו נתמכת בגרסאות אחרונות של דפדפני Chrome, Firefox, ו- Safari, וכן ב- Internet Explorer מגרסה 10 ומעלה';
$string['dndnotsupported_insentence'] = 'לא קיימת תמיכה (בדפדפן) להעלאת קבצים בגרירה';
$string['dnduploadwithoutcontent'] = 'העלאה זו מכילה תוכן ריק';
$string['dndworkingfile'] = 'ניתן להעלות תוכן על ידי גרירת הקבצים מהמחשב שלכם ליחידות־הוראה הרצויה בקורס';
$string['dndworkingfilelink'] = 'העלאת קבצים או קישורים בגרירה ליחידות־הוראה בקורס';
$string['dndworkingfiletext'] = 'העלאת קבצים או קטעי טקסט (מלל) בגרירה ליחידות־הוראה בקורס';
$string['dndworkingfiletextlink'] = 'מנגנון העלאת: קבצים, קישורים וקטעי טקסט בגרירה, פעיל בקורס זה';
$string['dndworkinglink'] = 'ניתן להוסיף קישורים ליחידות־הוראה של הקורס, על ידי גרירה';
$string['dndworkingtext'] = 'ניתן להוסיף עמוד טקסט (מלל) ליחידות־הוראה של הקורס, על ידי סימון הטקסט וגרירה ליחידה הרצויה';
$string['dndworkingtextlink'] = 'ניתן להוסיף עמוד טקסט (מלל) או קישורים ליחידות־הוראה של הקורס, על ידי סימון הטקסט בעמוד כלשהו או הקישור בשדה הכתובת של הדפדפן וגרירה ליחידה הרצויה';
$string['documentation'] = 'תיעוד Moodle';
$string['dontsortcategories'] = 'לא למיין קטגוריות';
$string['dontsortcourses'] = 'לא למיין קורסים';
$string['down'] = 'למטה';
$string['download'] = 'הורדה';
$string['downloadall'] = 'הורדת הכל';
$string['downloadexcel'] = 'שמירה כקובץ Excel';
$string['downloadfile'] = 'הורדת קובץ';
$string['downloadods'] = 'שמירה כקובץ ODS';
$string['downloadtext'] = 'שמירה כקובץ CSV';
$string['doyouagree'] = 'האם קראת והבנת תנאים אלו?';
$string['droptoupload'] = 'שחרר את הקבצים כאן בכדי להעלותם';
$string['duplicate'] = 'שכפול';
$string['edhelpaspellpath'] = 'בכדי להשתמש ב-spell-checking בתוך העורך, אתה מוכרח <strong> aspell 0.50 </strong> או גירסה מאוחרת יותר מותקנת בשרת שלך, ועליך לציין את הנתיב התקין לאפשר גישה עבור ה-aspell הבינארי. במערכות Unix/Linux הנתיב הוא בד"כ: <strong> /usr/bin/aspell </strong> , אך יכול להיות שזה נתיב אחר.';
$string['edhelpbgcolor'] = 'הגדרת ערכי אזורי צבע הרקע. <br /> ערכים תקינים הם למשל: #FFFFFF או white';
$string['edhelpcleanword'] = 'הגדרה זו מאפשרת או מונעת מסנני תצורה יחודים של Word.';
$string['edhelpenablespelling'] = 'מאפשרת או מונעת spell-checking. כאשר מאופשר, <strong> aspell </strong> מוכרח להיות מותקן בשרת. הערך השני הוא ה <strong> default dictionary </strong>. ערך זה יופעל אם ל-aspell אין מילון עבור משתמשים בשפה שלהם.';
$string['edhelpfontfamily'] = 'תכונת משפחת-גופן היא רשימה של משפחת גופן ו/או שמות משפחת גופנים כלליים. שמות משפחה מוכרחים להיות מופרדים בפסיק';
$string['edhelpfontlist'] = 'הגדרת הגופנים בהם יעשה שימוש בתפריט הנפתח של עורכי התוכן.';
$string['edhelpfontsize'] = 'בררת־מחדל של font-size מגדירה את גודל הגופן. <br />. ערכים אפשריים הם למשל: medium, large, smaller, larger, 10pt, 11px';
$string['edit'] = 'עריכה';
$string['edita'] = 'עריכת {$a}';
$string['editcategorysettings'] = 'עריכת הגדרות הקורס';
$string['editcategorythis'] = 'עריכת קטגוריה';
$string['editcoursesettings'] = 'עריכת הגדרות קורס';
$string['editfiles'] = 'עריכת קבצים';
$string['editgroupprofile'] = 'עריכת פרופיל קבוצה';
$string['editinga'] = 'עורך {$a}';
$string['editingteachershort'] = 'עורך';
$string['editlock'] = 'ערך זה אינו ניתן לעריכה!';
$string['editmyprofile'] = 'עריכת המאפיינים שלי';
$string['editorbgcolor'] = 'צבע רקע';
$string['editorcleanonpaste'] = 'ניקוי קוד HTML מיותר שנוסף ע"י Word בזמן ההדבקה';
$string['editorcommonsettings'] = 'הגדרות משותפות';
$string['editordefaultfont'] = 'גופן בררת־מחדל';
$string['editorenablespelling'] = 'אפשר בדיקת איות';
$string['editorfontlist'] = 'רשימת גופנים';
$string['editorfontsize'] = 'בררת־מחדל של גודל גופן';
$string['editorresettodefaults'] = 'אתחול להגדרות בררת־מחדל';
$string['editorsettings'] = 'הגדרות עורך';
$string['editorshortcutkeys'] = 'מקשי קיצור־דרך לעורך';
$string['editsettings'] = 'הגדרות';
$string['editsummary'] = 'עריכת תקציר';
$string['editthisactivity'] = 'עריכת פעילות זו';
$string['editthiscategory'] = 'עריכת קטגוריה זו';
$string['edittitle'] = 'עריכת כותרת';
$string['edittitleinstructions'] = 'לחץ על esc בכדי לבטל, ו Enter בכדי לסיים';
$string['edituser'] = 'עריכת חשבונות משתמשים';
$string['edulevel'] = 'הקשר פדגוגי';
$string['edulevelother'] = 'אחר';
$string['edulevelparticipating'] = 'למידה';
$string['edulevelteacher'] = 'הוראה';
$string['email'] = 'כתובת דואר אלקטרוני';
$string['emailactive'] = 'דואר אלקטרוני פעיל';
$string['emailagain'] = 'דואר אלקטרוני (שוב)';
$string['emailalreadysent'] = 'דוא"ל לאיפוס סיסמא שכבר נשלח. יש לבדוק את הדוא"ל שלך';
$string['emailcharset'] = 'קבוצת התווים של הדוא"ל';
$string['emailconfirm'] = 'אשר את חשבונך';
$string['emailconfirmation'] = 'שלום {$a->firstname},

זה עתה, נוצר חשבון משתמש חדש, במערכת הלמידה \'{$a->sitename}\', המשתמש בכתובת דואר זו.
לשם אימות זהות הפרטים אשר הוזנו במהלך תהליך ההרשמה, הכוללים את כתובת דואר זו
וכדי לוודא שאף גורם זר לא משתמש בכתובת דואר זו ללא אישור ממך,
את/ה נדרש/ת לאשר את כתובת הדואר הזו של חשבונכם החדש, על ידי גלישה לכתובת האינטרנט הזו:

{$a->link}

אם את/ה זקוק/ה לעזרה, אנא צור/י קשר עם מנהל המערכת -
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: אישור חשבון';
$string['emailconfirmsent'] = '<p>לכתובתך ב <span style="direction:ltr;font-weight:bold;">{$a}</span> תשלח בקרוב הודעת דואר אלקטרוני. <p>הודעה זו מכילה הוראות פשוטות להשלמת הרשמתך.</p> <p>אם תיתקל בקשיים, אנא צור קשר עם מנהל האתר.</p>';
$string['emaildigest'] = 'אופן משלוח הדואר האלקטרוני';
$string['emaildigestcomplete'] = 'מקבץ (הודעת דואר יומית עם כל התכתובות)';
$string['emaildigestoff'] = 'רגיל (הודעת דואר על כל הודעה בפורום)';
$string['emaildigestsubjects'] = 'נושאים (הודעת דואר יומית עם כותרות בלבד)';
$string['emaildisable'] = 'כתובת הדוא"ל הזו אינה-זמינה';
$string['emaildisableclick'] = 'לחץ כאן בכדי להפסיק משלוח של דואר אלקטרוני לכתובת זו';
$string['emaildisplay'] = 'תצוגת דואר אלקטרוני';
$string['emaildisplaycourse'] = 'אפשר רק למשתתפים אחרים בקורס לראות את כתובת הדואר האלקטרוני שלי';
$string['emaildisplayhidden'] = 'דוא"ל מוסתר';
$string['emaildisplayno'] = 'הסתרת כתובת הדואל האמיתית שלי מכולם';
$string['emaildisplayyes'] = 'אפשר לכולם לראות את כתובת הדואר אלקטרוני שלי';
$string['emailenable'] = 'כתובת הדואר אלקטרוני הזו מופעלת';
$string['emailenableclick'] = 'לחץ כאן בכדי לאפשר מחדש משלוח של דואר אלקטרוני לכתובת זו';
$string['emailexists'] = 'כתובת הדואר אלקטרוני הזו כבר בשימוש.';
$string['emailformat'] = ' דואר אלקטרוני';
$string['emailmustbereal'] = 'הערה: כתובת הדואר אלקטרוני שלך חייבת להיות אמיתית';
$string['emailnotallowed'] = 'כתובות דוא"ל במתחמים אלו ({$a}) אינן מורשות.';
$string['emailnotfound'] = 'כתובת הדוא"ל לא נמצאה במסד הנתונים';
$string['emailonlyallowed'] = 'כתובת דוא"ל זו אינה אחת הכתובות המורשות ({$a})';
$string['emailpasswordchangeinfo'] = 'מישהו (כנראה אתה) ביקש סיסמה חדשה עבורך. חשבון ב-\'{$a->sitename}\'. בכדי לשנות את סיסמתך, אנא כנס לכתובת האינטרנט הבאה: {$a->link} ברוב תוכנות הדוא"ל, תראה קישור כחול אשר עליו תלחץ. אם זה לא עוזר, העתק והדבק את הכתובת לשורת הכתובות בחלון הדפדפן שלך. אם תצטרך עזרה, אנא פנה למנהל המערכת, {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'מישהו (כנראה אתה) ביקש סיסמה חדשה עבור חשבונך ב\'{$a->sitename}\'.

לצערינו חשבונך באתר זה אינו פעיל ולא ניתן לאפס אותו, אנא פנה למנהל(ת) המערכת {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'שלום {$a->firstname}, מישהו (כנראה אתה) ביקש סיסמה חדשה עבורך. חשבון ב-\'{$a->sitename}\'. לצערנו לא ניתן לאתחל סיסמאות באתר זה, אנא פנה למנהל(ת) המערכת, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = 'שנה את מידע הסיסמה';
$string['emailpasswordconfirmation'] = 'שלום {$a->firstname}, קיבלנו בקשה לסיסמה חדשה
עבור חשבונך באתר  \'{$a->sitename}\'. כדי לאשר שזו אכן בקשתך,
וכדי שסיסמה חדשה תישלח לדוא"ל שלך,
עליך ללחוץ על הקישור הבא: {$a->link}
אם הקישור אינו עובד, יש "לגזור" את הכתובת
ו"להדביק" אותה בשורת הכתובות של דפדפן האינטרנט
שלך. לעזרה, ניתן ליצור קשר עם מנהל
האתר: {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: אשר שינוי סיסמה';
$string['emailpasswordconfirmmaybesent'] = 'אם סיפקת שם משתמש וסיסמה נכונים ישלח אליך דוא"ל <p>הודעה זו מכילה הוראות פשוטות לאישור והשלמת שינוי סיסמה זה. אם אתה ממשיך להיתקל בקשיים, צור קשר עם מנהל האתר.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> חשבון המשתמש שציינת לא קיים כתובת דואר אלקטרוני.</p>
   <p>אנא צור קשר עם מנהל באתר.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>פרטי המשתמש שסופקו אינו מזהים את חשבון משתמש.</p>
   <p>אנא בדוק את המידע שהזנת, לאחר מכן נסה.
אם אתה ממשיך להיתקל בקשיים, אנא צור קשר עם מנהל האתר.</p>';
$string['emailpasswordconfirmsent'] = 'לכתובתך ב <span style="direction:ltr;font-weight:bold;">{$a}</span> תשלח בקרוב הודעת דוא"ל. <p>הודעה זו מכילה הוראות פשוטות לאישור והשלמת שינוי סיסמה זה. אם אתה ממשיך להיתקל בקשיים, צור קשר עם מנהל האתר.</p>';
$string['emailpasswordsent'] = 'תודה על אישור שינוי סיסמה זה.
<p>דואר אלקטרוני המכיל את סיסמתך החדשה נשלח לכתובתך ב<b>{$a->email}</b>.</p>
<p>הסיסמה החדשה הופעלה אוטומטית - יכול להיות שתרצה
<a href="{$a->link}">לשנות את הסיסמה שלך</a> למשהו שקל יותר לזכור.</p>';
$string['emailresetconfirmation'] = 'שלום {$a->firstname},

התקבלה בקשת איפוס סיסמא עבור חשבונך שם משתמש \'{$a->username}\' באתר {$a->sitename}.

על מנת לאשר את הבקשה, ולהגדיר סיסמא חדשה לחשבונך, אנא גשו לכתובת הבאה:

{$a->link}
(קישור זה תקף למשך {$a->resetminutes} דקות מרגע בקשת האיפוס)

אם לא ביקשתם איפוס סיסמא, אין צורך לנקוט באף פעולה.

אם אתם זקוקים לעזרה, אנא צור קשר אם מנהלי האתר,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: בקשת איפוס סיסמא';
$string['emailresetconfirmsent'] = 'נשלח דואר אקלטרוני לכתובת שלך <b>{$a}</b>.
<br />הדוא"ל מכיל הנחיות על מנת לאשר להשלים את בקשת החלפת הסיסמא.
אם אתם עדיין מתקשים, צרו קשר עם מנהל האתר.';
$string['emailtoprivatefiles'] = 'ניתן גם לשלוח בדואר אלקטרוני קבצים כקבצים מצורפים ישר למרחב הקבצים  הפרטי שלך. פשוט לצרף את הקבצים שלך לדואר אלקטרוני ולשלוח אותו ל-{$a}';
$string['emailtoprivatefilesdenied'] = 'מנהל המערכת שלך השבית את האפשרות להעלות קבצים הפרטיים.';
$string['emptydragdropregion'] = 'אזור ריק';
$string['enable'] = 'פעיל';
$string['encryptedcode'] = 'קוד מוצפן';
$string['english'] = 'אנגלית';
$string['enrolmentmethods'] = 'שיטות רישום';
$string['entercourse'] = 'לחץ בכדי להיכנס לקורס';
$string['enteremail'] = 'הכנס את כתובת הדוא"ל שלך';
$string['enteremailaddress'] = 'הכנס את כתובת הדואר אלקטרוני שלך בכדי לאתחל מחדש את הסיסמה ושהסיסמה החדשה תשלח לך דרך דואר אלקטרוני.';
$string['enterusername'] = 'הכנס את שם המשתמש שלך';
$string['entries'] = 'כניסות';
$string['error'] = 'טעות';
$string['errorcreatingactivity'] = 'לא ניתן ליצור מופע של פעילות \'{$a}\'';
$string['errorfiletoobig'] = 'גודל הקובץ גדול מהגבול שהוגדר {$a} בתים.';
$string['errornouploadrepo'] = 'לא קיים מאגר העלאה פעיל עבור אתר זה.';
$string['errorwhenconfirming'] = 'אתה לא מאושר עדיין מפני שקרתה טעות. אם לחצת על קישור בדואר אלקטרוני כדי להגיע לפה, וודא שהקו בדואר האלקטרוני שלך לא נקטע או נעטף. יכול להיות ותצטרך לגזור ולהדביק בכדי לשחזר את הקישור כצריך.';
$string['eventcommentcreated'] = 'תגובה נוצרה';
$string['eventcommentdeleted'] = 'תגובה נמחקה';
$string['eventcommentsviewed'] = 'הערות שנצפו';
$string['eventcontentviewed'] = 'התוכן נצפה';
$string['eventcoursecategorycreated'] = 'קטגוריה שנוצרה';
$string['eventcoursecategorydeleted'] = 'הקטגוריה נמחקה';
$string['eventcoursecategoryupdated'] = 'קטגוריה התעדכנה';
$string['eventcoursecontentdeleted'] = 'תוכן הקורס נמחק';
$string['eventcoursecreated'] = 'הקורס נוצר';
$string['eventcoursedeleted'] = 'הקורס נמחק';
$string['eventcoursemodulecreated'] = 'נוצרה פעילות בקורס';
$string['eventcoursemoduledeleted'] = 'נמחקה פעילות בקורס';
$string['eventcoursemoduleinstancelistviewed'] = 'צפיה ברשימת רכיבי הפעילות בקורס';
$string['eventcoursemoduleupdated'] = 'עודכנה פעילות בקורס';
$string['eventcoursemoduleviewed'] = 'רכיב קורס נצפה';
$string['eventcourseresetended'] = 'איפוס קורס הסתיים';
$string['eventcourseresetstarted'] = 'איפוס קורס התחיל';
$string['eventcourserestored'] = 'הקורס שוחזר';
$string['eventcoursesectionupdated'] = 'יחידת-הוראה בקורס עודכנה';
$string['eventcourseupdated'] = 'הקורס עודכן';
$string['eventcourseuserreportviewed'] = 'דוח משתמש בקורס נצפה';
$string['eventcourseviewed'] = 'קורס נצפה';
$string['eventemailfailed'] = 'כשלון בשליחת הדוא"ל';
$string['eventname'] = 'שם האירוע';
$string['eventrecentactivityviewed'] = 'פעילות אחרונה נצפתה';
$string['eventunknownlogged'] = 'אירוע לא ידוע';
$string['eventusercreated'] = 'משתמש נוצר';
$string['eventuserdeleted'] = 'משתמש נמחק';
$string['eventuserlistviewed'] = 'רשימת משתמשים נצפתה';
$string['eventuserloggedout'] = 'משתמש התנתק';
$string['eventuserpasswordupdated'] = 'סיסמת משתמש עודכנה';
$string['eventuserprofileviewed'] = 'פרופיל משתמש נצפה';
$string['eventuserupdated'] = 'משתמש עודכן';
$string['everybody'] = 'כולם';
$string['executeat'] = 'בצע ב';
$string['existing'] = 'קיימים';
$string['existingadmins'] = 'מנהלים קיימים';
$string['existingcourse'] = 'קורס קיים';
$string['existingcourseadding'] = 'קורס קיים, הוספת מידע אליו';
$string['existingcoursedeleting'] = 'קורס קיים, עם מחיקה קודמת';
$string['existingcreators'] = 'יוצרי קורס קיימים';
$string['existingstudents'] = 'סטודנטים רשומים';
$string['existingteachers'] = 'מורים קיימים';
$string['expand'] = 'הרחב';
$string['expandall'] = 'תצוגה מורחבת';
$string['expandcategory'] = 'הרחבת {$a}';
$string['explanation'] = 'הסבר';
$string['extendenrol'] = 'הארכת רישום (פרטית)';
$string['extendperiod'] = 'תקופת הארכה';
$string['failedloginattempts'] = '{$a->attempts} נסיונות כניסה כושלים מאז החיבור האחרון שלך';
$string['feedback'] = 'תגובות';
$string['file'] = 'קובץ';
$string['fileexists'] = 'קיים כבר קובץ בשם {$a}';
$string['filemissing'] = '{$a} חסר';
$string['files'] = 'קבצים';
$string['filesanduploads'] = 'קבצים והעלאות';
$string['filesfolders'] = 'קבצים/תיקיות';
$string['filetoolarge'] = 'הקובץ גדול מידי עבור העלאה';
$string['fileuploadwithcontent'] = 'קבצי ההעלאה  אינם יכולים לכלול את פרמטר התוכן';
$string['filloutallfields'] = 'אנא מלא את כל השדות בטופס זה';
$string['filter'] = 'מסנן';
$string['findmorecourses'] = 'מצא קורסים נוספים...';
$string['first'] = 'ראשון';
$string['firstaccess'] = 'כניסה ראשונה';
$string['firstname'] = 'שם פרטי';
$string['firstnamephonetic'] = 'שם פרטי - פונטי';
$string['firstsiteaccess'] = 'גישה ראשונה לאתר';
$string['firsttime'] = 'האם זהו הביקור הראשון שלך באתר זה?';
$string['folder'] = 'תיקייה';
$string['folderclosed'] = 'תיקייה סגורה';
$string['folderopened'] = 'תיקייה פתוחה';
$string['followingoptional'] = 'הפריטים הבאים ניתנים לבחירה';
$string['followingrequired'] = 'הפריטים הבאים הינם הכרחיים';
$string['for'] = 'עבור';
$string['force'] = 'הכרח';
$string['forcelanguage'] = 'שפת ממשק';
$string['forceno'] = 'בררת־מחדל (מערכתית)';
$string['forcepasswordchange'] = 'הכרחת שינוי סיסמה';
$string['forcepasswordchangecheckfull'] = 'האם אתה בטוח כי ברצונך לכפות שינוי סיסמה על משתמש {$a} ?';
$string['forcepasswordchange_help'] = 'כאשר התיבה מסומנת, המשתמש יתבקש לשנות את הסיסמה שלו בכניסה הבאה למערכת.';
$string['forcepasswordchangenot'] = 'לא היה ניתן לכפות שינוי סיסמה על {$a}';
$string['forcepasswordchangenotice'] = 'יש לשנות סיסמה כדי להמשיך';
$string['forcetheme'] = 'בחירת ערכת־עיצוב';
$string['forgotaccount'] = 'שכחת סיסמה?';
$string['forgotten'] = 'שכחת את שם המשתמש או את הסיסמה שלך?';
$string['forgottenduplicate'] = 'כתובת הדוא"ל משותפת ע"י מספר חשבונות, אנא הכנס שם משתמש במקום.';
$string['forgotteninvalidurl'] = 'כתובת אינטרנט שגויה לאיפוס סיסמה';
$string['format'] = 'תצורת תוכן הקורס';
$string['format_help'] = '<p align="center"><b>תצורת התצוגה של קורסים ב-Moodle</b></p>

<p><b>פעילות מרכזית</b></p>
<ul>
בכניסה לעמוד הראשי של הקורס תוצג הפעילות או המשאב בודד אשר יבחר על ידי המורה. ולא ניתן יהיה לגשת או לצפות בפעילויות או משאבים נוספים המצויים בקורס (חבויים מהתלמידים)

באופן זה, ניתן להפוך את הקורס לפורום מרכזי, או בלוג מרכזי או מבחן מרכזי...
</ul>

<p><b> שבועי</b></p>
<ul>
הקורס מאורגן לפי שבועות, עם תאריך התחלה וסיום ברורים. כל שבוע מורכב מפעילויות. לחלק מהן, כמו למטלות, יש "חלונות פתוחים" של, לדוגמא, שבועיים, שלאחריהם הן לא יהיו זמינות יותר.
</ul>

<p><b> יחידות־הוראה</b></p>
<ul>
מאוד דומה לתצורה השבועית, רק שכל "שבוע" נקרא "נושא". וה"נושא" לא מוגבל בזמן. אתם לא צריכים להגדיר אף תאריך.
</ul>

<p><b> חברתי (פורום)</b></p>
<ul>
התצורה הזו מכוננת סביב פורום אחד מרכזי, הפורום החברתי, שמופיע בעמוד הראשי. התצורה הזו שימושית למצבים בעלי צורה חופשית יותר, יכול להיות שהם אפילו לא יהיו קורסים. לדוגמא, הוא יכול לשמש כלוח הודעות מחלקתי.
</ul>';
$string['formathtml'] = 'מעוצב (HTML)';
$string['formatmarkdown'] = 'Markdown';
$string['formatplain'] = 'טקסט פשוט';
$string['formattext'] = 'תסדיר Moodle';
$string['formattexttype'] = 'עיצוב';
$string['framesetinfo'] = 'מסמך frameset זה מכיל:';
$string['from'] = 'מתאריך';
$string['frontpagecategorycombo'] = 'רשימת קטגוריות וקורסים';
$string['frontpagecategorynames'] = 'רשימת קטגוריות';
$string['frontpagecourselist'] = 'הצגת רשימה של קורסים';
$string['frontpagecoursesearch'] = 'משבצת חיפוש קורסים';
$string['frontpagedescription'] = 'תיאור של עמוד ראשי';
$string['frontpagedescriptionhelp'] = 'תיאור זה של האתר יוצג בעמוד הראשי בשימוש משבצת סיכום/הקדמה של האתר/קורס או על־ידי שילוב נושא יחידת הוראה בעמוד הראשי.';
$string['frontpageenrolledcourselist'] = 'הקורסים בהם אני רשום';
$string['frontpageformat'] = ' תסדיר העמוד הראשי';
$string['frontpageformatloggedin'] = 'תסדיר העמוד הראשי בעת כניסה למערכת';
$string['frontpagenews'] = 'הצגת פריטי חדשות';
$string['frontpagesettings'] = 'הגדרות עמוד ראשי';
$string['fulllistofcourses'] = 'כל הקורסים';
$string['fullname'] = 'שם מלא';
$string['fullnamecourse'] = 'שם מלא';
$string['fullnamecourse_help'] = 'השם המלא של הקורס מוצג בקצה העליון של כל עמוד בקורס וברשימת הקורסים.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'שם מלא';
$string['fullprofile'] = 'פרופיל מלא';
$string['fullsitename'] = 'שם אתר מלא';
$string['functiondisabled'] = 'מנגנון זה אינו-זמין כעת';
$string['general'] = 'כללי';
$string['geolocation'] = 'קו אורך - קו רוחב';
$string['gettheselogs'] = 'הצגת יומני מעקב אלו';
$string['go'] = 'ביצוע';
$string['gpl'] = 'Copyright (C) 1999 onwards   Martin Dougiamas  (http://dougiamas.com)

יישום זה הוא תוכנה חופשית; ניתן להפיצה מחדש ו/או לשנות אותה על-פי תנאי הרשיון הציבורי הכללי של GNU כפי שפורסם על ידי קרן התוכנה החופשית; בין אם גרסה 2 של הרשיון, ובין אם (לפי בחירתך) כל גרסה מאוחרת שלו.

יישום זה מופץ בתקווה שיהיה מועיל, אך ללא אחריות כלשהי; ואפילו ללא האחריות המשתמעת בדבר מסחריותו או התאמתו למטרה מסויימת. לפרטים נוספים, ראו את הרשיון הציבורי הכללי של GNU:

http://www.gnu.org/copyleft/gpl.html
http://www.law.co.il/computer-law/gpl-hebrew.html';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (http://moodle.com)
כל הזכויות (C) שמורות החל משנת 1999 למרטין דואגימאס (http://moodle.com)
<br />
יישום זה הוא תוכנה חופשית: ניתן להפיץ אותו וכמו כן גם לשנותו בכפוף לתנאים של הרשיון הציבורי הכללי GNU ( GNU General Public License) כפי שפורסמו על ידי קרן התוכנה החופשית (Free Software Foundation) במהדורה 3 של הרשיון או (להחלטתכם) כל מהדורה מאוחרת יותר.
<br />
היישום מופצת בתקווה שהוא תהיה שימושית אולם ללא כל אחריות; אפילו ללא האחריות המרומזת של סחירות או התאמה למטרה מסוימת.
<br />
ניתן לבחון את המידע המלא של רשיון מוודל (Moodle) ב:
http://docs.moodle.org/en/License';
$string['gpllicense'] = 'רשיון GPL';
$string['grade'] = 'ציונים';
$string['grades'] = 'ציונים';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> מאופשר באתר זה. אם אינך מעלה תמונה לפרופיל שלך בתאר, Moodle ינסה לטעון תמונה לפרופיל שלך מ-Gravatar';
$string['group'] = 'קבוצה';
$string['groupadd'] = 'הוספת קבוצה חדשה';
$string['groupaddusers'] = 'הוספה לקבוצה הנבחרים';
$string['groupextendenrol'] = 'רישום מורחב לכולם';
$string['groupfor'] = 'לקבוצה';
$string['groupinfo'] = 'מידע על הקבוצה הנבחרת';
$string['groupinfoedit'] = 'עריכת הגדרות קבוצה';
$string['groupinfomembers'] = 'מידע על החברים הנבחרים';
$string['groupinfopeople'] = 'מידע על המשתמשים הנבחרים';
$string['groupmembers'] = 'חברי הקבוצה';
$string['groupmemberssee'] = 'עיין ברשימת חברי הקבוצה';
$string['groupmembersselected'] = 'חברי הקבוצה הנבחרת';
$string['groupmode'] = 'מצב קבוצות';
$string['groupmodeforce'] = 'הכרח מצב חלוקה לקבוצות';
$string['groupmy'] = 'הקבוצה שלי';
$string['groupnonmembers'] = 'משתמשים לא בקבוצה';
$string['groupnotamember'] = 'סליחה, אינך חבר בקבוצה ההיא';
$string['grouprandomassign'] = 'שבץ את כולם לקבוצות באופן אקראי';
$string['groupremove'] = 'הסרת הקבוצה הנבחרת';
$string['groupremovemembers'] = 'הסרת הפריטים הנבחרים';
$string['groups'] = 'קבוצות';
$string['groupsnone'] = 'אין קבוצות';
$string['groupsseparate'] = 'קבוצות נפרדות';
$string['groupsvisible'] = 'קבוצות נראות';
$string['guest'] = 'אורח';
$string['guestdescription'] = 'לאורחים יש זכויות פחותות ובדרך כלל אינם יכולים להכניס טקסט בכל מקום.';
$string['guestskey'] = 'הרשה אורחים בעלי מפתח';
$string['guestsno'] = 'אל תרשה לאורחים להיכנס פנימה';
$string['guestsnotallowed'] = 'סליחה, \'{$a}\' אינו מרשה לאורחים להיכנס.';
$string['guestsyes'] = 'הרשה אורחים ללא המפתח';
$string['guestuser'] = 'משתמש אורח';
$string['guestuserinfo'] = 'משתמש זה הינו משתמש מיוחד המאפשר גישת קריאה בלבד לחלק מהקורסים.';
$string['help'] = 'עזרה';
$string['helpprefix2'] = 'עזרה עם {$a}';
$string['helpwiththis'] = 'עזור עם זה';
$string['hiddenassign'] = 'תפקיד מוסתר';
$string['hiddenfromstudents'] = 'מוסתר בפני סטודנטים';
$string['hiddensections'] = 'יחידות־הוראה חבויות';
$string['hiddensectionscollapsed'] = 'יחידות־הוראה חבויות: מוצגות בצורה לא זמינה';
$string['hiddensections_help'] = '<p align="center"><b>יחידות־הוראה חבויות</b></p>

<p>האפשרות הזו מאפשרת לכם להחליט כיצד יוצגו יחידות־הוראה הנסתרים בקורס שלכם בפני הסטודנטים.
</p>

<p>לפי בררת־מחדל, יש אזור קטן שמופיע (באופן מכווץ ולרוב באפור), כדי לציין מקום בו יש חלק נסתר, למרות שעדיין אי אפשר לראות את הפעילויות והטקסטים הנסתרים. הדבר מועיל במיוחד בתצורה השבועית, כדי לסמן באופן מאוד ברור שבועות שלא מתקיימים בהם שיעורים.
</p>

<p>אם תרצו, אתם יכולים לבחור יחידות־הוראה הנסתרות בקורס יהיו מוסתרים לחלוטין מעיני הסטודנטים, כך שהם אפילו לא יהיו מודעים לכך שבקורס יש יחידות־הוראה נסתרות.
</p>';
$string['hiddensectionsinvisible'] = 'יחידות־הוראה חבויות: לא מוצגות';
$string['hide'] = 'הסתרה';
$string['hideadvancedsettings'] = 'הסתר הגדרות מתקדמות';
$string['hidepicture'] = 'הסתר תמונה';
$string['hidesection'] = 'הסתרת יחידת־הוראה {$a}';
$string['hidesettings'] = 'הסתר הגדרות';
$string['hideshowblocks'] = 'הסתרת/הצגת משבצות';
$string['hits'] = 'פעולות';
$string['hitsoncourse'] = 'כל פעולות המשתמש {$a->username} בקורס {$a->coursename}';
$string['hitsoncoursetoday'] = 'פעולות מהיום של משתמש {$a->username} בקורס {$a->coursename}';
$string['home'] = 'ראשי';
$string['hour'] = 'שעה';
$string['hours'] = 'שעות';
$string['howtomakethemes'] = 'כיצד ליצור ערכות נושא חדשות';
$string['htmleditor'] = 'השתמש בעורך דף התוכן המעוצב';
$string['htmleditoravailable'] = 'עורך דף התוכן המעוצב זמין';
$string['htmleditordisabled'] = 'בפרופיל המשתמש שלך נטרלת את עורך דף התוכן המעוצב';
$string['htmleditordisabledadmin'] = 'באתר זה המנהל נטרל את עורך דף התוכן המעוצב';
$string['htmleditordisabledbrowser'] = 'עורך דף התוכן המעוצב אינו זמין מפני שדפדפן הרשת שלך אינו מתאים';
$string['htmlfilesonly'] = 'קבצי HTML בלבד';
$string['htmlformat'] = ' תסדיר HTML נאה';
$string['icon'] = 'צלמית';
$string['icqnumber'] = 'מספר ICQ';
$string['idnumber'] = 'מספר זיהוי';
$string['idnumbercourse'] = 'מספר זיהוי הקורס';
$string['idnumbercoursecategory'] = 'מספר זיהוי של קטגוריה';
$string['idnumbercoursecategory_help'] = 'מספר הזיהוי (IDׂ) של קטגורית הקורס בא לידי שימוש רק כאשר מתאימים את הקטגוריה הזו עם מידע של מערכות חיצוניות המשתמשות בו ואינו יוצג במקום אחר באתר. אם לקטגוריה יש קוד זיהוי רשמי כדאי שיוכנס כאן, אחרת ניתן להשאיר את השדה ריק.';
$string['idnumbercourse_help'] = '<p align="center"><b>מספר הזיהוי של הקורס</b></p>

<p> במספר הזיהוי של הקורס משתמשים רק כאשר בודקים זהות בין פריטי נתונים של הקורס ובין מערכות חיצוניות - לעולם הוא לא מוצג בתוך Moodle. אם יש לכם שם קוד רשמי בשביל הקורס, אז השתמשו בו כאן.... אחרת, אתם יכולים להשאיר את השדה ריק.
</p>';
$string['idnumbergroup'] = 'מספר זיהוי הקבוצה';
$string['idnumbergroup_help'] = 'מספר הזיהוי (ID) של הקבוצה בא לידי שימוש רק כאשר מתאימים את הקבוצה עם מידע של מערכות חיצוניות המשתמשות בו ואינו יוצג. אם לקבוצה שינו קוד זיהוי רשמי כדאי שיוכנס כאן, אחרת ניתן להשאיר את השדה ריק.';
$string['idnumbergrouping'] = 'מספר זיהוי לאוסף הקבוצות';
$string['idnumbergrouping_help'] = 'מספר הזיהוי (ID) של אוסף הקבוצה בא לידי שימוש רק כאשר מתאימים את אוסף הקבוצה עם מידע של מערכות חיצוניות המשתמשות בו ואינו יוצג. אם לאוסף הקבוצה שינו קוד זיהוי רשמי כדאי שיוכנס כאן, אחרת ניתן להשאיר את השדה ריק.';
$string['idnumbermod'] = 'קוד זיהוי יחודי
<br/>
(לצורך חישוב ציון)';
$string['idnumbermod_help'] = '<p>הגדרת מספר זיהוי מקנה דרך לזיהוי הפעילות לתהליך חישוב הציון. אם הפעילות לא כלולה איזשהו חישוב ציון, שדה מספר הזיהוי יכול להישאר ריק. </p>
<p>מספר הזיהוי יכול להיות מוגדר גם בעמוד העריכה של חישוב הציון, ניתן לערוך אותו רק בעמוד עדכון הפעילות.</p>';
$string['idnumbertaken'] = 'מספר זיהוי זה כבר נמצא בשימוש';
$string['imagealt'] = 'תיאור תמונה';
$string['import'] = 'יבוא';
$string['importdata'] = 'יבוא תכני הקורס';
$string['importdataexported'] = 'יצוא הנתונים מקורס ה-\'מ:\' עבר בהצלחה.
<br /> המשך לייבא לתוך קורס ה-\'ל:\'.';
$string['importdatafinished'] = 'היבוא הושלם! אנא המשך לקורס שלך';
$string['importdatafrom'] = 'בחירת קורס ממנו ניבא מידע:';
$string['inactive'] = 'לא־פעיל';
$string['include'] = 'כלול';
$string['includeallusers'] = 'כלול את כל המשתמשים';
$string['includecoursefiles'] = 'כלול קבצי קורסים';
$string['includecourseusers'] = 'כלול משתמשי הקורס';
$string['included'] = 'כלול';
$string['includelogentries'] = 'כלול רישומי יומן מעקב';
$string['includemodules'] = 'כלול מודולים';
$string['includemoduleuserdata'] = 'כלול נתוני מודול המשתמש';
$string['includeneededusers'] = 'כלול משתמשים נחוצים';
$string['includenoneusers'] = 'כלול לא-משתמשים';
$string['includeroleassignments'] = 'כלול הקצאות תפקידים';
$string['includesitefiles'] = 'כלול קבצי אתר שמשתמשים בהם בקורס זה';
$string['includeuserfiles'] = 'כלול קבצי משתמשים';
$string['increasesections'] = 'הוספת יחידת־הוראה';
$string['info'] = 'מידע';
$string['institution'] = 'מוסד';
$string['instudentview'] = 'בתצוגת סטודנט';
$string['interests'] = 'תחומי עניין';
$string['interestslist'] = 'רשימת תחומי עניין (מופרדים בפסיקים)';
$string['interestslist_help'] = 'מלא את תחומי העיניין שלך מופרדים בפסיקים';
$string['invalidemail'] = 'כתובת דואר אלקטרוני לא תקפה';
$string['invalidlogin'] = 'שם משתמש או סיסמה שהזנתם אינם תקינים';
$string['invalidusername'] = 'שם המשתמש יכול להכיל תווים בעלי אותיות קטנות באנגלית (ועברית או כל שפה), מקף תחתון(_), מקף(-), נקודה(.) או כרוכית( @). בלבד!';
$string['invalidusernameupload'] = 'שם משתמש לא תקף';
$string['ip_address'] = 'כתובת IP';
$string['jump'] = 'קפוץ';
$string['jumpto'] = 'קפוץ ל...';
$string['keep'] = 'שמירה';
$string['keepsearching'] = 'המשך בחיפוש';
$string['langltr'] = 'כיוון השפה משמאל לימין';
$string['langrtl'] = 'כיוון השפה מימין לשמאל';
$string['language'] = 'שפת ממשק';
$string['languagegood'] = 'חבילת שפה זו מעודכנת! :-)';
$string['last'] = 'אחרון';
$string['lastaccess'] = 'כניסה אחרונה';
$string['lastcourseaccess'] = 'גישה אחרונה לקורס';
$string['lastedited'] = 'עריכה אחרונה';
$string['lastip'] = 'כתובת ה-IP האחרון';
$string['lastlogin'] = 'כניסה אחרונה';
$string['lastmodified'] = 'שינוי אחרון';
$string['lastname'] = 'שם משפחה';
$string['lastnamephonetic'] = 'שם משפחה - פונטי';
$string['lastsiteaccess'] = 'גישה אחרונה לאתר';
$string['lastyear'] = 'שנה שעברה';
$string['latestlanguagepack'] = 'חפש את חבילת השפה האחרונה ב moodle.org';
$string['layouttable'] = 'טבלת תצורת התצוגה';
$string['leavetokeep'] = 'ניתן להשאיר ריק כדי לשמור על סיסמה נוכחית';
$string['legacythemeinuse'] = 'אתר זה מוצג בפניח במצב תאימות מפני שהדפדפן שלך בעל גרסה ישנה מידי.';
$string['license'] = 'רשיון';
$string['licenses'] = 'רישיונות תוכן';
$string['liketologin'] = 'האם ברצונך להתחבר כעת עם חשבון משתמש רגיל?';
$string['list'] = 'רשימה';
$string['listfiles'] = 'רשימת קבצים ב {$a}';
$string['listofallpeople'] = 'רשימה של כל השתמשים';
$string['listofcourses'] = 'רשימת קורסים';
$string['loadinghelp'] = 'טוען...';
$string['local'] = 'מקומי';
$string['localplugins'] = 'תוספות מקומיות';
$string['localpluginsmanage'] = 'ניהול תוספות מקומיות';
$string['location'] = 'מיקום';
$string['locktimeout'] = 'זמן הפעולה פג בזמן המתנה לנעילה';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'אתה מחובר כ: {$a}';
$string['loggedinasguest'] = 'אתם משתמשים כרגע בגישת אורחים';
$string['loggedinnot'] = 'את/ה לא מחובר/ת';
$string['login'] = 'התחברות';
$string['loginalready'] = 'את/ה כבר מחובר/ת למערכת';
$string['loginas'] = 'התחברות כמשתמש זה';
$string['loginaspasswordexplain'] = '<p> אתה חייב להכניס "loginas password" מיוחד בכדי להשתמש במאפיין זה.<br/> אם אינך יודע זאת, שאל את מנהל הרשת.';
$string['login_failure_logs'] = 'רישום נסיונות התחברות כושלים';
$string['loginguest'] = 'התחברות כאורח';
$string['loginsite'] = 'התחברות למערכת';
$string['loginsteps'] = 'שלום לך! לקבלת גישה מלאה לקורסים עליך להקדיש דקה לפתיחת חשבון חדש באתר זה.
לכל אחד מהקורסים הבודדים יכול להיות גם "מפתח רישום" שתצטרך רק מאוחר יותר. להלן שלבי פתיחת החשבון:
<ol>
<li>מלא את הטופס <a href="{$a}">חשבון חדש</a> בפרטים שלך</li>
<li>דואר אלקטרוני יישלח מיידית לכתובת הדואר האלקטרוני שסיפקת (אם לא נמצא, נא לחפש גם בדואר הזבל או הספאם). </li>
<li>קרא את הדואר אלקטרוני שלך ולחץ על קישור האינטרנט שהוא מכיל.</li>
<li>החשבון שלך יאושר ואתה תהיה מחובר.</li>
<li>עכשיו בחר את הקורס בו תרצה להשתתף.</li>
<li>אם מבקשים ממך "מפתח רישום" השתמש בזה שנתן לך המורה שלך. זה "ירשום" אותך לקורס.</li>
<li>עכשיו יש בידך גישה לכל הקורס. מעתה והלאה כל שתצטרך בכדי להתחבר ולהיכנס לכל קורס שנרשמת אליו הוא שם המשתמש שלך והסיסמה (בטופס המופיע בדף זה).</li>
</ol>';
$string['loginstepsnone'] = '<p>שלום לך!</p> <p>לקבלת גישה מלאה לקורסים עליך לפתוח חשבון באתר.</p> <p>כל שעליך לעשות הוא להמציא לעצמך שם משתמש וסיסמה ולהזין אותם בטופס בעמוד זה!</p> <p>אם מישהו אחר כבר בחר את שם המשתמש שלך אז תצטרך לנסות שוב עם שם משתמש אחר.</p>';
$string['loginto'] = 'התחברות ל{$a}';
$string['logout'] = 'התנתק';
$string['logoutconfirm'] = 'האם אתה באמת רוצה להתנתק?';
$string['logs'] = 'יומני מעקב';
$string['logtoomanycourses'] = '[ <a href="{$a->url}"> עוד </a>]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">עוד</a> ]';
$string['lookback'] = 'צפייה אחורנית';
$string['mailadmins'] = 'הודע למנהלים';
$string['mailstudents'] = 'הודע לתלמידים';
$string['mailteachers'] = 'הודע למורים';
$string['maincoursepage'] = 'הדף הראשי של הקורס';
$string['makeafolder'] = 'יצירת תיקייה';
$string['makeeditable'] = 'אם תהפוך את \'{$a}\' לקובץ שניתן לערוך אותו על ידי תוכנת שרת הרשת (לדוגמא Apache), אז תוכל לערוך קובץ זה ישירות מדף זה';
$string['makethismyhome'] = 'קביעת עמוד זה כבררת־מחדל לעמוד הבית';
$string['manageblocks'] = 'משבצות (בלוקים)';
$string['managecategorythis'] = 'ניהול קטגוריה';
$string['managecourses'] = 'ניהול קורסים';
$string['managedatabase'] = 'בסיס נתונים';
$string['manageeditorfiles'] = 'ניהול קבצים אשר בשימוש העורך';
$string['managefilters'] = 'מסננים';
$string['managemodules'] = 'רכיבים';
$string['manageroles'] = 'תפקידים והרשאות';
$string['markedthistopic'] = 'נושא זה מודגש כנושא הנוכחי';
$string['markthistopic'] = 'הדגש נושא זה כנושא הנוכחי';
$string['matchingsearchandrole'] = 'תוצאה \'{$a->search}\' ו- {$a->role}';
$string['maxareabytesreached'] = 'הקובץ (או כמות הנפח המירבית של מס\' קבצים) גדול מהמקום שנותר בתיבה זו';
$string['maxbytesforfile'] = 'נפח הקובץ {$a} גדול מהנפח המירבי המאופשר כאן';
$string['maxfilesize'] = 'הגודל המירבי לקבצים חדשים: {$a}';
$string['maxfilesreached'] = 'אתה רשאי להעלות מספר מירבי של {$a} קבצים עבור פריט זה';
$string['maximumchars'] = 'מקסימום של {$a} תווים';
$string['maximumgrade'] = 'ציון מירבי';
$string['maximumgradex'] = 'הציון המירבי הוא {$a} ';
$string['maximumshort'] = 'מקסימום';
$string['maximumupload'] = 'גודל מירבי של העלאת קובץ בודד';
$string['maximumupload_help'] = '<p align="center"><b>הגודל המירבי של העלאת קובץ בודד במקומות שונים בקורס</b></p>

<p> בדרך כלל, ניתן להעלות מספר לא מוגבל של קבצים. כך שהמגבלה מתייחסת לגודל קובץ בודד.
</p>

<p> ההגדרה הזו קובעת את גודל הקובץ המירבי אותו יכולים משתמשים בקורס להעלות, כמובן שהדבר מוגבל על ידי הגדרת הניהול הכלליות של המערכת, אותה קבע המנהל(ת).
</p>

<p> אפשרי להגביל את הגודל הזה עוד יותר, דרך ההגדרות שנמצאות בכל רכיב, פעילות או משאב.
</p>';
$string['maxnumberweeks'] = 'מספר מירבי של שבועות/נושאים';
$string['maxnumberweeks_desc'] = 'הגדרה זו שולטת על המספר המירבי של אפשרויות שיופיעו בהגדרת "מספר השבועות/נושאים" עבור קורסים.';
$string['maxnumcoursesincombo'] = 'עיין ל- <a href="{$a->link}">{$a->numberofcourses} courses</a>.';
$string['maxsize'] = 'גודל מירבי: {$a}';
$string['maxsizeandareasize'] = 'גודל מירבי עבור קבצים חדשים: {$a->size}, מגבלה כוללת: {$a->areasize}';
$string['maxsizeandattachments'] = 'נפח קבצים מירבי: {$a->size}, מספר קבצים מצורפים מירבי: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'גודל מירבי עבור עבור קבצים חדשים: {$a->size}, מקסימום קבצים מצורפים: {$a->attachments}, מגבלה כוללת: {$a->areasize}';
$string['memberincourse'] = 'משתתפים בקורס';
$string['messagebody'] = 'גוף ההודעה';
$string['messagedselectedusers'] = 'ההודעה נשלחה למשתתפים הנבחרים ורשימת  המקבלים אופסה';
$string['messagedselectedusersfailed'] = 'משהו השתבש בזמן שליחת הודעות למשתמשים הנבחרים. כמה מהם כנראה קיבלו את הדוא"ל.';
$string['messageprovider:availableupdate'] = 'הודעות עדכון זמינות';
$string['messageprovider:backup'] = 'הודעות הגיבוי';
$string['messageprovider:badgecreatornotice'] = 'הודעות יצירת הישג';
$string['messageprovider:badgerecipientnotice'] = 'הודעות קבלת הישג';
$string['messageprovider:courserequestapproved'] = 'הודעה על אישור הבקשה ליצירת קורס';
$string['messageprovider:courserequested'] = 'הודעת בקשת יצירת קורס';
$string['messageprovider:courserequestrejected'] = 'הודעה על דחיית הבקשה ליצירת קורס';
$string['messageprovider:errors'] = 'הודעות שגיאת מערכת חמורות';
$string['messageprovider:errors_help'] = 'אלו הן שגיאות חשובות אשר כדאי מאוד ליידע את מנהל המערכת.';
$string['messageprovider:instantmessage'] = 'מסרים אישיים בין משתמשים';
$string['messageprovider:instantmessage_help'] = 'קטע זה מגדיר מה קורה למסרים אשר נשלחים אליך ישירות ממשתמש אחר באתר.';
$string['messageprovider:notices'] = 'הודעות מערכת על בעיות פשוטות';
$string['messageprovider:notices_help'] = 'ישנן הודעות אשר מנהל המערכת ירצה להתבוננן בהן.';
$string['messageselect'] = 'בחירת משתמש זה כנמען דוא"ל';
$string['messageselectadd'] = 'שליחת מסר';
$string['middlename'] = 'שם אמצעי';
$string['migratinggrades'] = 'העברת ציונים';
$string['min'] = 'דקה';
$string['mins'] = 'דקות';
$string['minute'] = 'דקה';
$string['minutes'] = 'דקות';
$string['miscellaneous'] = 'שונות';
$string['missingcategory'] = 'אתה צריך לבחור קטגוריה';
$string['missingdescription'] = 'חסר תיאור';
$string['missingemail'] = 'חסרה כתובת דואר אלקטרוני';
$string['missingfirstname'] = 'חסר שם פרטי';
$string['missingfromdisk'] = 'חסר מהדיסק';
$string['missingfullname'] = 'חסר שם מלא';
$string['missinglastname'] = 'חסר שם משפחה';
$string['missingname'] = 'חסר שם';
$string['missingnewpassword'] = 'חסרה סיסמה חדשה';
$string['missingpassword'] = 'חסרה סיסמה';
$string['missingrecaptchachallengefield'] = 'שדה מנגנון reCAPTCHA חסר';
$string['missingreqreason'] = 'חסרה סיבה';
$string['missingshortname'] = 'חסר שם מקוצר';
$string['missingshortsitename'] = 'חסר שם אתר מקוצר';
$string['missingsitedescription'] = 'חסר תיאור אתר';
$string['missingsitename'] = 'חסר שם אתר';
$string['missingstrings'] = 'חיפוש מחרוזות חסרות';
$string['missingstudent'] = 'חייב לבחור משהו';
$string['missingsummary'] = 'חסר סיכום';
$string['missingteacher'] = 'חייב לבחור משהו';
$string['missingurl'] = 'חסר URL';
$string['missingusername'] = 'חסר שם משתמש';
$string['modchooserdisable'] = 'כיבוי בורר־פעילויות';
$string['modchooserenable'] = 'הפעלת בורר־פעילויות';
$string['moddoesnotsupporttype'] = 'הרכיב {$a->modname לא תומך בהעלאות מסוג זה {$a->type}';
$string['modified'] = 'שונה';
$string['moduleintro'] = 'הנחיה לפעילות';
$string['modulesetup'] = 'יוצר טבלאות מודולים';
$string['modulesuccess'] = 'טבלאות {$a} נוצרו בהצלחה';
$string['modulesused'] = 'פעילויות בהן נעשה שימוש';
$string['month'] = 'חודש';
$string['months'] = 'חודשים';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'מדריכי עזרה עבור עמוד זה';
$string['moodlerelease'] = 'שחרור Moodle';
$string['moodleversion'] = 'גרסת Moodle';
$string['more'] = 'עוד';
$string['morehelp'] = 'עזרה נוספת';
$string['moreinfo'] = 'מידע נוסף';
$string['moreinformation'] = 'מידע נוסף על שגיאה זו';
$string['moreprofileinfoneeded'] = 'אנא ספר לנו עוד על עצמך.';
$string['mostrecently'] = 'לאחרונה';
$string['move'] = 'העברה';
$string['movecategoriessuccess'] = '{$a->count} קטגוריות הועברו בהצלחה אל הקטגוריה \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = '{$a->count} קטגוריות הועברו בהצלחה אל הרמה הראשית';
$string['movecategorycontentto'] = 'העברה ל';
$string['movecategorysuccess'] = 'הקטגוריה \'{$a->moved}\' הועברה בהצלחה לקטגוריה \'{$a->to}\'';
$string['movecategoryto'] = 'העברת קטגוריה ל:';
$string['movecategorytotopsuccess'] = 'הקטגוריה \'{$a->moved}\' הועברה בהצלחה לרמה העליונה';
$string['movecontent'] = 'העברת {$a}';
$string['movecontentstoanothercategory'] = 'העברת תכנים לקטגוריה אחרת';
$string['movecoursemodule'] = 'העברת משאב';
$string['movecoursesection'] = 'העברת יחידת הוראה';
$string['movecourseto'] = 'העברת קורס ל:';
$string['movedown'] = 'הזזה למטה';
$string['movefilestohere'] = 'העברת הקבצים לכאן';
$string['movefull'] = 'העברת {$a} למיקום זה';
$string['movehere'] = 'העברה לכאן';
$string['moveleft'] = 'הזחה ימינה';
$string['moveright'] = 'הזחה שמאלה';
$string['movesection'] = 'העברת יחידת־הוראה {$a}';
$string['moveselectedcategoriesto'] = 'העברת קטגוריות שנבחרו אל';
$string['moveselectedcoursesto'] = 'העברת הקורסים הנבחרים ל...';
$string['movetoanotherfolder'] = 'העברה לתיקייה אחרת';
$string['moveup'] = 'הזזה למעלה';
$string['msnid'] = 'חשבון MSN';
$string['mustchangepassword'] = 'הסיסמה החדשה חייבת להיות שונה מהסיסמה הנוכחית';
$string['mustconfirm'] = 'עליך לאשר את ההתחברות שלך';
$string['mycourses'] = 'הקורסים שלי';
$string['myfiles'] = 'הקבצים שלי';
$string['myfilesmanage'] = 'ניהול הקבצים שלי';
$string['myhome'] = 'עדכונים בקורסים שלי';
$string['mymoodledashboard'] = 'לוח המחוונים של מוודל שלי';
$string['myprofile'] = 'כלי משתמש';
$string['name'] = 'שם';
$string['nameforlink'] = 'איזה שם תרצה לתת לקישור זה';
$string['nameforpage'] = 'שם';
$string['navigation'] = 'ניווט';
$string['needed'] = 'נדרש';
$string['networkdropped'] = 'זיהינו כי חיבור האינטרנט שלך לא אמין או משובש. <br /> יש להיות מודע לכך כי שינויים לא יישמרו כראוי עד שהחיבור שלך משתפר.';
$string['never'] = 'אף פעם לא';
$string['neverdeletelogs'] = 'אף פעם אל תמחק דוחות';
$string['new'] = 'חדש';
$string['newaccount'] = 'חשבון חדש';
$string['newcourse'] = 'קורס חדש';
$string['newpassword'] = 'סיסמה חדשה';
$string['newpasswordfromlost'] = '<strong> הודעה: הסיסמה הנוחכית </strong> שלך תשלח לך בדוא"ל <strong> השני</strong> מתוך השנים שישלחו לך כחלק מתהליך השבת הסיסמה האבודה שלך. וודא כי קיבלת את הסיסמה החלופה לפני שתמשיך עם עמוד זה.';
$string['newpassword_help'] = 'ניתן להזין סיסמה חדשה או להשאיר ריק כדי לשמור את סיסמתך הנוכחית';
$string['newpasswordtext'] = 'שלום לך {$a->firstname}, סיסמת חשבונך באתר \'{$a->sitename}\' אופסה, והונפקה לך סיסמה זמנית חדשה. פרטי ההתחברות החדשים שלך הינם: שם משתמש: {$a->username} סיסמה: {$a->newpassword} אנא גש לעמוד זה כדי לשנות את סיסמתך: {$a->link} ברוב תוכנות הדואר, כתובת האינטרנט אמורה להופיע כקישור כחול אשר אתה יכול פשוט ללחוץ עליו. אם זה לא עובד, גזור את הכתובת והדבק אותה בתוך פס הכתובות של דפדפן האינטרנט שלך. איחולי הצלחה מהמנהל של \'{$a->sitename}\'. {$a->signoff}';
$string['newpicture'] = 'תמונה חדשה';
$string['newpicture_help'] = '<p align="center"><b>העלאת תמונה</b></p>

<p>אתם יכולים להעלות תמונה מהמחשב שלכם לשרת זה, תמונה זו תופיע בכל מני מקומות ותסמל אתכם.
</p>
<p>מסיבה זו, התמונות שהכי כדאי להשתמש בהן הן תמונות \'קלוז-אפ\' של הפנים שלכם, אבל אתם יכולים להשתמש בכל תמונה שרק תרצו.
</p>
<p>על התמונה להיות בתסדיר JPG או PNG (כלומר, לרוב סיומת שמות הקבצים תהיה .jpg או .png).</p>
<p>אתם יכולים להשיג קובץ תמונה באמצעות אחת מתוך ארבע השיטות הבאות:
</p>

<ol>
<li>אם תשתמשו במצלמה דיגיטלית, רוב הסיכויים שהתמונות שלכם כבר יהיו על המחשב שלכם בתסדיר המתאים. </li>
<li>אתם יכולים להשתמש בסורק כדי לסרוק תמונה מודפסת. וודאו שאתם שומרים אותה כתסדיר  JPG או PNG.</li>
<li>אם יש לכם כישורים אומנותיים, אולי תירצו לצייר תמונה באמצעות תוכנת ציור.
</li>
<li>לבסוף, תוכלו \'לגנוב\' תמונות מהרשת. <a target="google" href="http://images.google.com/">http://images.google.com</a> הוא מקום נפלא לחפש אחר תמונות. מרגע שתמצאו תמונה, אתם יכולים ללחוץ עליה באמצעות הכפתור הימני של העכבר ולבחור ב-"שמור את התמונה..." מהתפריט שיופיע (במחשבים שונים יכולים להיות שינויים מעטים).</li>
</ol>

<p>כדי להעלות את התמונה, לחצו על כפתור ה"עיין" בעמוד העריכה וביחרו בתמונה מהדיסק הקשיח שלכם.
</p>
<p>שימו לב: וודאו שהקובץ לא עולה בגודלו על הגודל המירבי הרשום אחרת הוא לא יעלה.
</p>
<p>לאחר מכן לחצו על "עדכן את הפרופיל שלי" בתחתית - קובץ התמונה יקוצץ לריבוע וגודלו ישונה ל 100 X 100 פיקסלים.
</p>
<p>כשאתם חוזרים לעמוד הפרופיל שלכם יכול להיות שהתמונה לא תיראה שונה. אם זהו המקרה, פשוט השתמשו בכפתור ה"טען מחדש" בשרת שלכם.';
$string['newsitem'] = 'פריט חדשות';
$string['newsitems'] = 'פריטי חדשות';
$string['newsitemsnumber'] = 'מספר פריטי חדשות להצגה';
$string['newsitemsnumber_help'] = '<p align="center"><b>פריטי חדשות הקורס</b></p>

<p>פורום מיוחד בשם "חדשות" מופיע בקורסים בעלי תצורת ה"נושאי" וה"שבועי". זהו מקום טוב לפרסם הודעות שמיועדות לכלל הסטודנטים. (כל הסטודנטים רשומים לפורום זה כבררת־מחדל, ולכן גם יקבלו את ההודעות שלכם בדואר אלקטרוני).
</p>

<p>ההגדרה הזו קובעת את מספר הפריטים העדכניים אשר יופיעו בצידו הימני של עמוד הבית של הקורס שלכם, בתוך משבצת חדשות.
</p>

<p>כאשר מוגדרים "0 פריטי חדשות", לא תוצג בעמוד הראשי של הקורס משבצת חדשות.</p>';
$string['newuser'] = 'משתמש חדש';
$string['newusernewpasswordsubj'] = 'חשבון משתמש חדש';
$string['newusernewpasswordtext'] = 'שלום לך {$a->firstname}, חשבון חדש נוצך עבורך באתר \'{$a->sitename}\' והונפקה לך סיסמה זמנית. פרטי ההתחברות החדשים שלך הינם: שם משתמש: {$a->username} סיסמה: {$a->newpassword} (תצטרך לשנות את הסיסמה שלך כאשר תתחבר למערכת בפעם הראשונה) כדי להתחיל להשתמש ב-\'{$a->sitename}\', התחבר ל-{$a->link} ברוב תוכנות הדואר, כתובת האינטרנט אמורה להופיע כקישור כחול אשר אתה יכול פשוט ללחוץ עליו. אם זה לא עובד, גזור את הכתובת והדבק אותה בתוך פס הכתובות של דפדפן האינטרנט שלך. איחולי הצלחה מהמנהל של \'{$a->sitename}\'. {$a->signoff}';
$string['newusers'] = 'משתמשים חדשים';
$string['newwindow'] = 'חלון חדש';
$string['next'] = 'הבא';
$string['nextsection'] = 'יחידת־הוראה הבאה';
$string['no'] = 'לא';
$string['noblockstoaddhere'] = 'אין משבצות שניתן להוסיף לדף זה.';
$string['nobody'] = 'אף אחד';
$string['nochange'] = 'ללא שינוי';
$string['nocomments'] = 'ללא הערות';
$string['nocourses'] = 'אף קורס';
$string['nocoursesfound'] = 'לא נמצאו קורסים עם המילים  \'{$a}\'';
$string['nocoursesyet'] = 'אין קורסים בקטגוריה זו';
$string['nodstpresets'] = 'מנהל/ת המערכת לא אפשר תמיכה בעדכון שעון קיץ.';
$string['nofilesselected'] = 'לא נבחרו קבצים לשחזור';
$string['nofilesyet'] = 'עדיין לא הועלו קבצים לקורס שלך';
$string['nograde'] = 'אין ציון';
$string['nohelpforactivityorresource'] = 'כרגע לא קיימת עזרה בנוגע לפעילות או משאב זה';
$string['noimagesyet'] = 'עדיין לא הועלו תמונות לקורס שלך';
$string['nologsfound'] = 'לא נמצאו רשימות יומני מעקב';
$string['nomatchingusers'] = 'לא נמצאו משתמשים \'{$a}\'';
$string['nomorecourses'] = 'לא נמצאו קורסים נוספים המתאימים לשאילתא';
$string['nomoreidnumber'] = 'אין שימוש במספר ID כדי למנוע התנגשויות';
$string['none'] = 'אין';
$string['noneditingteacher'] = 'מורה לא עורך';
$string['noneditingteacherdescription'] = 'מורים שלא מורשים לערוך יכולים ללמד בקורסים, לבדוק ולתת ציון לעבודות תלמידים, אבל אינם יכולים לשנות פעילויות.';
$string['nonstandard'] = 'לא סטנדרטי';
$string['nopendingcourses'] = 'אין קורסים המחכים לאישור';
$string['nopotentialadmins'] = 'אין מנהלים זמינים';
$string['nopotentialcreators'] = 'אין יוצרי קורס פוטנציאלים';
$string['nopotentialstudents'] = 'אין סטודנטים פוטנציאלים';
$string['nopotentialteachers'] = 'אין מורים פוטנציאלים';
$string['norecentactivity'] = 'אין פעילות שאירעה לאחרונה';
$string['noreplybouncemessage'] = 'השבת אל כתובת דוא"ל שלא ניתן להשיב אליה. אם ניסית להשיב על פרסום בפורום, אנא במקום זאת השב ע"י הפורומים ה{$a}';
$string['noreplybouncesubject'] = '{$a} - דוא"לים חוזרים';
$string['noreplyname'] = 'אל תשיב לדוא"ל זה';
$string['noresetrecord'] = 'אין תיעוד של בקשה לאיפוס. יש ליזום בקשה לאיפוס סיסמא חדשה.';
$string['noresults'] = 'אין תוצאות';
$string['normal'] = 'רגיל';
$string['normalfilter'] = 'חיפוש רגיל';
$string['nosite'] = 'לא ניתן למצוא קורס site-level';
$string['nostudentsfound'] = 'לא נמצא {$a}';
$string['nostudentsingroup'] = 'אין עדיין סטודנטים בקבוצה זו';
$string['nostudentsyet'] = 'עדיין לא נרשמו סטודנטים לקורס זה';
$string['nosuchemail'] = 'כתובת דואר אלקטרוני שכזו לא קיימת';
$string['notavailable'] = 'לא זמין';
$string['notavailablecourse'] = '{$a} אינו זמין';
$string['noteachersyet'] = 'עדיין אין מורים בקורס זה';
$string['notenrolled'] = '{$a} אינו רשום בקורס זה.';
$string['notenrolledprofile'] = 'פרופיל זה לא זמין מפני שמשתמש זה לא רשום לקורס זה.';
$string['noteusercannotrolldatesoncontext'] = '<strong> הערה: </strong> היכולת לגלול תאריכים כאשר משחזרים גיבוי זה נוטרלה מכיוון שחסרת בהרשאות שנדרשו.';
$string['noteuserschangednonetocourse'] = 'הערה: כאשר משחזרים מידע,משתמשי הקורס גם כן צריכים להיות משוחזרים. הגדרה זו שונתה למענך.';
$string['nothingnew'] = 'אין חדש מאז התחברותך האחרונה';
$string['nothingtodisplay'] = 'אין כלום להציג';
$string['notice'] = 'לתשומת לב';
$string['noticenewerbackup'] = 'קובץ גיבוי זה נוצר על ידי מערכת מוודל בגרסה: Moodle {$a->backuprelease} ({$a->backupversion}) <br/> גירסה זו חדשה יותר מאשר הגירסה הנוכחית המותקנת אצלך: Moodle {$a->serverrelease} {$a->serverversion}).<br/> דבר זה יכול לגרום לחוסר עקביות מפני שתאימות אחורנית של קבצי גיבוי לא מובטחת.';
$string['notifications'] = 'עדכונים והודעות';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, משתמש: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'ניתן לעיין ביומני מעקב אלו ב: {$a}/course/report/log/index.php?id=1&chooselog=1&modid=site_errors';
$string['notifyloginfailuresmessagestart'] = 'להלן רשימה של נסיונות כניסה כושלים למערכת ב-{$a} מאז שעודכנת לאחרונה';
$string['notifyloginfailuressubject'] = '{$a} :: הודעות הזדהות למערכת אשר נכשלו';
$string['notincluded'] = 'לא נכלל';
$string['notingroup'] = 'מצטערים, אבל אתה צריך להיות חלק מקבוצה בשביל לראות פעילות זו.';
$string['notpublic'] = 'לא ציבורי!';
$string['nousersfound'] = 'לתשומת-לב';
$string['nousersmatching'] = 'לא נמצאו משתמשים התואמים את \'{$a}\'';
$string['nousersyet'] = 'עדיין אין משתמשים';
$string['novalidcourses'] = 'אין קורסים תקינים להראות';
$string['now'] = 'עכשיו';
$string['numattempts'] = '{$a} נסיונות התחברות כושלים';
$string['numberofcourses'] = 'מספר הקורסים';
$string['numberweeks'] = 'מספר שבועות/נושאים';
$string['numdays'] = '{$a} ימים';
$string['numhours'] = '{$a} שעות';
$string['numletters'] = '{$a} אותיות';
$string['numminutes'] = '{$a} דקות';
$string['nummonths'] = '{$a} חודשים';
$string['numseconds'] = '{$a} שניות';
$string['numviews'] = '{$a} צפיות';
$string['numweeks'] = '{$a} שבועות';
$string['numwords'] = '{$a} מילים';
$string['numyears'] = '{$a} שנים';
$string['ok'] = 'אישור';
$string['oldpassword'] = 'סיסמה נוכחית';
$string['olduserdirectory'] = 'זוהי ספריית המשתמשים הישנה, אשר אינה נחוצה יותר. אתה יכול למחוקה אותה. הקבצים אותם היא הכילה הועתקו לספריית המשתמש החדשה.';
$string['optional'] = 'ניתן לבחירה';
$string['options'] = 'אפשרויות';
$string['order'] = 'סדר';
$string['originalpath'] = 'הנתיב המקורי';
$string['orphanedactivitiesinsectionno'] = 'פעילויות חבויות מתלמידים אך זמינות (יחידה {$a})';
$string['other'] = 'אחר';
$string['outline'] = 'סקירה';
$string['outlinereport'] = 'צפיות במשאבים ופעילויות';
$string['page'] = 'עמוד';
$string['pagea'] = 'עמוד {$a}';
$string['pageheaderconfigablock'] = 'הגדרת משבצת ב- {$a->fullname}';
$string['pagepath'] = 'נתיב העמוד';
$string['pageshouldredirect'] = 'עמוד זה אמור להיות מופנה אוטומטית.אנא השתמש בקישור "המשך", אם דבר אינו קורה .';
$string['parentcategory'] = 'מיקום קטגוריה זו';
$string['parentcoursenotfound'] = 'קורס אב לא נמצא';
$string['parentfolder'] = 'תיקיית אב';
$string['participants'] = 'משתתפים';
$string['participantslist'] = 'רשימת משתתפים';
$string['participationratio'] = 'יחס השתתפות';
$string['participationreport'] = 'דוח משתתפים';
$string['password'] = 'סיסמה';
$string['passwordchanged'] = 'הסיסמה שונתה';
$string['passwordconfirmchange'] = 'אשר שינוי סיסמה';
$string['passwordextlink'] = 'הקישור הבא יסופק לך על מנת להשיג מחדש את ססמתך האבודה. פעולה זאת תוציא אותך מהמערכת.';
$string['passwordforgotten'] = 'שכחת סיסמה';
$string['passwordforgotteninstructions'] = 'פרטיך צריכים להימצא תחילה במסד הנתונים של המשתמש. אנא הכנס את שם המשתמש שלך או כתובת הדוא"ל הרשומה שלך בתיבה הבאה, אין צורך להכניס את שניהם,אלא רק אחד מהם.';
$string['passwordforgotteninstructions2'] = 'לאיפוס ססמתך, רשום את שם המשתמש או את כתובת הדוא"ל שלך למטה. אם נמצא אותך במסד הנתונים של האתר, ישלח אליך דוא"ל לכתובת הדוא"ל שלך, עם הוראות כיצד ניתן להיכנס לאתר.';
$string['passwordnohelp'] = 'לא ניתן לעזור לך למצוא את סיסמתך. אנא פנה למנהל המערכת למתן סיוע.';
$string['passwordrecovery'] = 'כן, עזור לי להתחבר';
$string['passwordsdiffer'] = 'סיסמאות אלו אינן תואמות';
$string['passwordsent'] = 'הסיסמה נשלחה';
$string['passwordsenttext'] = '<p>לכתובתך ב <span style="direction:ltr;font-weight:bold;">{$a->email}</span> תשלח בקרוב הודעת דואר אלקטרוני.</p>
<p><b>עליך לבדוק את תיבת הדואר שלך לקבלת סיסמתך החדשה</b></p>
<p>סיסמה זו נוצרה באופן אוטומטי, כך שיתכן ותרצה <a href="{$a->link}">לשנות את הסיסמה לאחת שתוכל לזכור בקלות</a>';
$string['passwordset'] = 'הסיסמא שלכם הוגדרה';
$string['path'] = 'נתיב';
$string['pathnotexists'] = 'נתיב לא קיים בשרת שלך!';
$string['pathslasherror'] = 'הנתיב אינו יכול להסתיים בלוכסן!!';
$string['paymentinstant'] = 'השתמש בכפתור למטה לשלם ולהירשם תוך דקות!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pending</small>)';
$string['paymentrequired'] = 'קורס זה מצריך תשלום לכניסה';
$string['payments'] = 'תשלומים';
$string['paymentsorry'] = 'תודה על תשלום שלך! למרבה הצער תהליך התשלום שלך לא הסתיים במלואו ולכן אינך רשאי עוד להירשם ולהכנס לקורס "{$a->fullname}" אנא נסה להיכנס בעוד מספר שניות. אם הינך עדיין מתקשה להיכנס אנא פנה למורה שלך {$a->teacher} או למנהל המערכת.';
$string['paymentthanks'] = 'תודה על התשלום שלך! כעת אתה רשום לקורס שלך: <br /> "{$a}"';
$string['pendingrequests'] = 'בקשות קורס, ממתינות';
$string['periodending'] = 'תקופת סיום ({$a})';
$string['perpage'] = 'לעמוד';
$string['perpagea'] = 'לעמוד: {$a}';
$string['personal'] = 'אישי';
$string['personalprofile'] = 'פרופיל אישי';
$string['phone'] = 'טלפון';
$string['phone2'] = 'טלפון נייד';
$string['phpinfo'] = 'מידע אודות php';
$string['pictureof'] = 'תמונה של {$a}';
$string['pictureofuser'] = 'תמונת משתמש';
$string['pleaseclose'] = 'אנא סגור חלון זה עכשיו';
$string['pleasesearchmore'] = 'אנא חפש עוד קצת';
$string['pleaseusesearch'] = 'אנא השתמש בחיפוש';
$string['plugin'] = 'תוסף';
$string['plugincheck'] = 'בדיקת תוספים';
$string['plugindeletefiles'] = 'כל המידע אשר משוייך לתוסף {\'$a->name\'} נמחק ממסד הנתונים. בכדי למנוע מהתוסף להתקין עצמו מחדש, תצטרך למחוק את הסיפרייה הזו ישירות מהשרת: {$a->directory}';
$string['pluginsetup'] = 'הגדר התקני טבלאות';
$string['policyaccept'] = 'אני מבין ומסכים';
$string['policyagree'] = 'הינך חייב לאשר את מדיניות זו על מנת להמשיך להשתמש באתר זה. האם אתה מסכים?';
$string['policyagreement'] = 'הסכם מדיניות המערכת';
$string['policyagreementclick'] = 'לחץ כאן על מנת לקרוא את הסכם מדיניות המערכת';
$string['popup'] = 'קופץ';
$string['popupwindow'] = 'פתח קובץ בחלון חדש';
$string['popupwindowname'] = 'חלון קופץ';
$string['post'] = 'פרסם';
$string['posts'] = 'פרסומים';
$string['potentialadmins'] = 'מנהלים זמינים';
$string['potentialcreators'] = 'יוצרי קורס פוטנציאלים';
$string['potentialstudents'] = 'סטודנטים פוטנציאלים';
$string['potentialteachers'] = 'מורים פוטנציאלים';
$string['preferences'] = 'העדפות';
$string['preferredlanguage'] = 'שפה מועדפת';
$string['preferredtheme'] = 'ערכת נושא מועדפת';
$string['preprocessingbackupfile'] = 'עיבוד מוקדם של קובץ הגיבוי';
$string['prev'] = 'קודם';
$string['preview'] = 'תצוגה מקדימה';
$string['previewhtml'] = 'תצוגת מקדימה של תסדיר דף מעוצב (html)';
$string['previeworchoose'] = 'הצגת או בחירת ערכת עיצוב';
$string['previous'] = 'קודם';
$string['previouslyselectedusers'] = 'המשתמשים שנבחרו קודם לכן אינם מתאימים {\'$a\'}';
$string['previoussection'] = 'יחידת־הוראה קודמת';
$string['primaryadminsetup'] = 'הגדרות חשבון מנהל/ת המערכת';
$string['private_files_handler'] = 'אחסן קבצים מצורפים לדואר אלקטרוני בשטח אחסון הקבצים הפרטי של המשתמש.';
$string['private_files_handler_name'] = 'שליחת קבצי דוא"ל מצורפים למאגר הקבצים שלי';
$string['profile'] = 'פרופיל';
$string['profilenotshown'] = 'תיאור פרופיל זה לא יוצג עד אשר משתמש זה ירשם לפחות לקורס אחד.';
$string['publicprofile'] = 'פרופיל ציבורי';
$string['publicsitefileswarning'] = 'הערה: קבצים הממוקמים כאן הינם נגישים לכולם';
$string['publicsitefileswarning2'] = 'הערה: ניתן לגשת לקבצים המוצגים כאן ע"י כל אדם היודע (או יכול לנחש) את כתובת האתר. מטעמי אבטחה, מומלץ כי כל קבצי הגיבוי ימחקו מייד לאחר ששחזרו אותם.';
$string['publicsitefileswarning3'] = 'הערה: הקבצים אשר ממוקמים כאן נגישים ע"י כל מי שמכיר (או יכול לנחש) את ה URL.
<br />
מסיבות אבטחה, רצוי לגבות קבצי גיבוי בתקיית Backupdata מאובטחת בלבד.';
$string['publish'] = 'שיתוף ציבורי';
$string['question'] = 'שאלה';
$string['questionsinthequestionbank'] = 'שאלות בבנק השאלות';
$string['readinginfofrombackup'] = 'קורא מידע מהגיבוי';
$string['readme'] = 'README';
$string['recentactivity'] = 'פעילות אחרונה';
$string['recentactivityreport'] = 'דוח מלא על פעילות אחרונה';
$string['recipientslist'] = 'רשימת הנמענים';
$string['recreatedcategory'] = 'יצירת קטגורית {$a}, מחדש';
$string['redirect'] = 'הכוון מחדש';
$string['reducesections'] = 'הסתרת יחידת־הוראה אחרונה';
$string['refresh'] = 'רענון';
$string['refreshingevents'] = 'רענון אירועים';
$string['registration'] = 'הרשמת Moodle';
$string['registrationcontact'] = 'קשר מהציבור';
$string['registrationcontactno'] = 'לא, אינני רוצה טופס ליצירת קשר ברשימת האתר';
$string['registrationcontactyes'] = 'כן, ספק טופס עבור משתמשי Moodle עתידיים לשם יצירת קשר איתי';
$string['registrationemail'] = 'הודעות דואר אלקטרוני';
$string['registrationinfo'] = 'עמוד זה מאפשר לך לרשום את אתר ה Moodle שלך באמצעות moodle.org. ההרשמה היא חינם.
ההטבה העיקרית של ההרשמה היא שאתה תתווסף לרשימת הפצה בעלת נפח נמוך של הודעות, להודעות חשובות כגון התראות אבטחה ושחרורים חדשים של .Moodle
<p>לפי ברירת מחדל, הנתונים שלך יישמרו סודיים, ולעולם לא יימכרו או יעבורו למשהו אחר. הסיבה היחידה לאסיפת מידע זה היא למטרת תמיכה, וכדי לעזור לבנות תמונה סטטיסטית של קהילת Moodle כשלם. </p>
<p>אם תבחר, אתה יכול להרשות ששם האתר שלך, ארץ וURL יוספו לרשימה הפומבית של אתרי .Moodle</p>
<p>כל ההרשמות החדשות מאושרות ידנית לפני שהם מתווספות לרשימה, אבל מרגע שאתה מתווסף לרשימה אתה יכול לעדכן את את ההרשמה (ואת הכניסה שלך ברשימה הפומבית) בכל זמן על ידי הגשה חוזרת של טופס זה.</p>';
$string['registrationinfotitle'] = 'מידע הרישום';
$string['registrationno'] = 'לא, אני לא רוצה לקבל דואר אלקטרוני';
$string['registrationsend'] = 'שליחת נתוני הרשמה ל moodle.org';
$string['registrationyes'] = 'כן, אנא הודע על נושאים חשובים';
$string['reject'] = 'דחייה';
$string['rejectdots'] = 'דחייה...';
$string['reload'] = 'טען מחדש';
$string['remoteappuser'] = 'משתמש {$a} מרוחק';
$string['remove'] = 'הסרה';
$string['removeadmin'] = 'הסרת מנהל/ת';
$string['removecreator'] = 'הסרת יוצר קורס';
$string['removestudent'] = 'הסרת סטודנט';
$string['removeteacher'] = 'הסרת מורה';
$string['rename'] = 'שנה שם';
$string['renamefileto'] = 'שנה שם ל<b>{$a}</b>';
$string['report'] = 'דוח';
$string['reports'] = 'דוחות';
$string['repositories'] = 'מאגרים';
$string['requestcourse'] = 'בקשת קורס';
$string['requestedby'] = 'נתבקש על ידי';
$string['requestedcourses'] = 'קורסים מבוקשים';
$string['requestreason'] = 'סיבה לבקשת קורס';
$string['required'] = 'דרוש';
$string['requirespayment'] = 'גישה לקורס זה מחייבת תשלום';
$string['reset'] = 'איפוס';
$string['resetcomponent'] = 'רכיב';
$string['resetcourse'] = 'איפוס קורס';
$string['resetinfo'] = 'עמוד זה מאפשר לך לרוקן קורס של נתוני משתמש, כאשר פעילויות והגדרות אחרות נשמרות. אנא שים לב בבחירת פריטים אלו והשלמת עמוד זה נתוני המשתמש שבחרת בקורס זה ימחקו לתמיד.';
$string['resetnotimplemented'] = 'איפוס לא הושם';
$string['resetrecordexpired'] = 'הקישור לאיפוס הסיסמה שבה השתמשת יותר מ {$a} דקות  ולכן פג תוקפו. יש ליצור איפוס סיסמא חדש.';
$string['resetstartdate'] = 'איפוס תאריך התחלה';
$string['resetstatus'] = 'מצב';
$string['resettask'] = 'משימה';
$string['resettodefaults'] = 'אתחול לבררת־מחדל';
$string['resortcourses'] = 'מיון קורסים';
$string['resortsubcategoriesby'] = 'מיון תת-קטגוריות על-ידי {$a} לפי סדר עולה';
$string['resortsubcategoriesbyreverse'] = 'מיון תת-קטגוריות על-ידי {$a} לפי סדר יורד';
$string['resource'] = 'משאב';
$string['resourcedisplayauto'] = 'אוטומטי';
$string['resourcedisplaydownload'] = 'הכרחת הורדה';
$string['resourcedisplayembed'] = 'שיבוץ';
$string['resourcedisplayframe'] = 'במסגרת';
$string['resourcedisplaynew'] = 'חלון חדש';
$string['resourcedisplayopen'] = 'באותו דף';
$string['resourcedisplaypopup'] = 'פתיחה בחלון נפרד';
$string['resources'] = 'משאבים';
$string['resources_help'] = 'סוגי משאבים מאפשרים כל סוג של תוכן רשת להכניס לקורס.';
$string['restore'] = 'שחזור';
$string['restorecancelled'] = 'שחזור בוטל';
$string['restorecannotassignroles'] = 'השחזור זקוק למנות תפקידים ואין לך הרשאה לכך.';
$string['restorecannotcreateorassignroles'] = 'מנגנון השחזור נדרש ליצור או למנות תפקידים, אך למשתמש שלך אין את הרשאה המתאימות.';
$string['restorecannotcreateuser'] = 'מנגנון השחזור זקוק ליצור משתמש  \'{$a}\' מקובץ גיבוי,  אך למשתמש שלך אין את הרשאה המתאימות.';
$string['restorecannotoverrideperms'] = 'השחזור זקוק לעקוף הרשאות ואין לך הרשאה לכך.';
$string['restorecoursenow'] = 'שחזר קורס זה כעת!';
$string['restoredaccount'] = 'חשבון שוחזר';
$string['restoredaccountinfo'] = 'חשבון זה יובא משרת אחר והסיסמה אבדה, בכדי ליצור סיסמה חדשה בעזרת שליחת דוא"ל יש להקליק "המשך".';
$string['restorefinished'] = 'השחזור הושלם בהצלחה';
$string['restoreto'] = 'שחזר ל';
$string['restoretositeadding'] = 'אזהרה: אתה עומד לשחזר לעמוד הראשי של האתר, הוספת מידע עליו!';
$string['restoretositedeleting'] = 'אזהרה: אתה עומד לשחזר לעמוד הראשי של האתר, מחיקת מידע ממנו קודם לכן!';
$string['restoreuserconflict'] = 'לא ניתן לסיים את תהליך השחזור<br/> כיוון שנמצא משתמש מיוחד: \'{$a}\' המצוי במערכת וגם בקובץ הגיבוי.<br/>
(מומלץ לבצע שחזור ללא משתמשים או גיבוי ללא המשתמש המסויים)';
$string['restoreuserinfofailed'] = 'תהליך השחזור הופסק מכיוון שאין לך הרשאות מתאימות לשחזר מידע משתמש.';
$string['restoreusersprecheck'] = 'בדיקת נתוני משתמש';
$string['restoreusersprecheckerror'] = 'בעיות אחדות זוהו בבדיקת נתוני המשתמש';
$string['restricted'] = 'מוגבל';
$string['returningtosite'] = 'האם זהו ביקור חוזר שלך באתר זה?';
$string['returntooriginaluser'] = 'חזרה ל:{$a}';
$string['revert'] = 'לחזור';
$string['role'] = 'תפקיד';
$string['roleassignments'] = 'שיוכי תפקידים';
$string['rolemappings'] = 'מיפוי תפקידים';
$string['rolerenaming'] = 'שינוי שמות תפקידים';
$string['rolerenaming_help'] = '<p>
אפשרות זו מאפשרת לך לשנות את שמות התפקידים המוצגים עבור שימוש בקורס שלך. לדוגמה, ייתכן שתרצה לשנות את "המורה" ל "המארגן" או ל "מנחה". רק את השם המוצג ישונה - תפקידי ההרשאות הבסיסיים אינם מושפעים.
</p>
<p>
שמות התפקיד החדש האלו יופיעו בדף המשתתפים של הקורס ובמקומות אחרים בתוך הקורס. אם שם התפקיד הוא כזה שמנהל האתר בחר כמו תפקיד של מנהל קורס,שם התפקיד החדש יופיע גם במסגרת של רשימות הקורס.
</p>
<p>
שמות תפקיד חדשים כלולים רק בגיבוי הקורס אם גם משתמשים כלולים.
</p>';
$string['roles'] = 'תפקידים';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'מספר הכתבות האחרונות של RSS';
$string['rsserror'] = 'שגיאה בקריאת נתוני RSS';
$string['rsserrorauth'] = 'קישור ה-RSS שלך לא מכיל אסימון אימות תקף.';
$string['rsserrorguest'] = 'הזנה זו משתמשת בגישת אורח עבור גישה למידע, אך לאורח אין הרשאה לקריאת המידע. אנא בקר במיקום המקורי שהזנה זו מגיעה ממנו (URL) כמשתמש תקף וקבל משם קישור RSS חדש.';
$string['rsstype'] = 'RSS feed לפעילות זו';
$string['saveandnext'] = 'שמירה ותצוגת הבא';
$string['savechanges'] = 'שמירת שינויים';
$string['savechangesanddisplay'] = 'שמירת השינויים והצגתם';
$string['savechangesandreturntocourse'] = 'שמירת שינויים וחזרה לקורס';
$string['savecomment'] = 'שמירת הערה';
$string['savedat'] = 'נשמר ב:';
$string['savepreferences'] = 'שמירת העדפות';
$string['saveto'] = 'שמירה ב';
$string['scale'] = 'מדרגת־הערכה';
$string['scale_help'] = '<p align="center"><b>מדרגות־הערכה (הערכה מילולית)</b></p>

<p>בידי המורים ניתנת האפשרות ליצור מדרגות־הערכה חדשות, מותאמות אישית, בהם ניתן להשתמש בקורס בכל פעילויות בהן נדרש מתן ציון מילולי ולא בהכרח מספרי.
</p>

<p>על שם מדרגת־הערכה להיות משפט או ביטוי שמזהה אותה במדויק: השם יופיע ברשימות בחירה של מדרגות־הערכה ובנוסף לכך על כפתורי עזרה.
</p>

<p>מדרגת־הערכה עצמה מוגדרת על ידי רשימת ערכים המופיעים לפי סדר, הנעים בטווח בין אפס  לחיובי ומופרדים על ידי פסיקים. לדוגמא:</p>

<blockquote><i>
   מאכזב, לא טוב מספיק, ממוצע, טוב, טוב מאוד, מצוין!
</i></blockquote>

<p>בנוסף, על מדרגות־הערכה להכיל תיאור המסביר את משמעותם ואת אופן השימוש בהם. תיאור זה יופיע בעמודי עזרה לתלמידים ולמורים כאחד.
</p>

<p>לבסוף, במערכת שלכם יכולים להופיע מספר מדרגות־הערכה "מערכתיים" שהוגדרו על ידי מנהל המערכת שלכם. אלו יהיו זמינים בכל הקורסים.
</p>';
$string['scales'] = 'מדרגות־הערכה';
$string['scalescustom'] = 'מדרגות־הערכה מותאמות אישית';
$string['scalescustomcreate'] = 'הוספת מדרגת־הערכה חדשה';
$string['scalescustomno'] = 'לא נוצרו עדיין מדרגות־הערכה מותאמות אישית';
$string['scalesstandard'] = 'מדרגות־הערכה מערכתיות';
$string['scalestandard'] = 'מדרגת־הערכה מערכתית';
$string['scalestandard_help'] = '<p>"מדרגת־הערכה מערכתית" הינה מדרגת הערכה אשר זמין בכל ההמערכת עבור כל הקורסים.</p>';
$string['scalestip'] = 'כדי ליצור מדרגות־הערכה מותאמות אישית, השתמש בקישור ה \'מדרגות...\' בתפריט הנהלת הקורס שלך.';
$string['scalestip2'] = 'בכדי ליצור מדרגות־הערכה בהתאמה אישית, בחר  בקישור הציונים בתפריט ניהול הקורס, בחר בעריכת מדרגות־הערכה.';
$string['schedule'] = 'לוח זמנים';
$string['screenshot'] = 'תמונת מסך';
$string['search'] = 'חיפוש';
$string['searchagain'] = 'חיפוש נוסף';
$string['searchbyemail'] = 'חיפוש לפי כתובת דוא"ל';
$string['searchbyusername'] = 'חיפוש לפי שם משתמש';
$string['searchcourses'] = 'חיפוש קורסים';
$string['searchhelp'] = 'אתה יכול לחפש מספר מילים בבת אחת.<br />word : תמצא כל התאמה למילה זו בתוך הטקסט.<br />+word : רק התאמות מדוייקות יימצאו.<br />-word : אל תכלול תוצאות הכוללות מילה זו.';
$string['search_help'] = 'משבצת החיפוש מאפשרת ביצוע חיפוש פשוט של מילה או יותר בכותרת ותוכן הודעות הפורום. לביצוע החיפוש,  יש להזין מילה או מספר מילים מופרדות בתו "רווח". מנגנון החיפוש מאחזר מילים המורכבות משלושה תווים ויותר, בלבד.

לביצוע חיפוש מתקדם, יש להקליק על כפתור ה"חיפוש" כאשר משבצת החיפוש ריקה.';
$string['searchoptions'] = 'אפשרויות חיפוש';
$string['searchresults'] = 'תוצאות חיפוש';
$string['sec'] = 'שניה';
$string['seconds'] = 'שניות';
$string['secondsleft'] = 'שניות {$a}';
$string['secondstotime172800'] = 'יומיים';
$string['secondstotime259200'] = 'שלושה ימים';
$string['secondstotime345600'] = 'ארבעה ימים';
$string['secondstotime432000'] = 'חמישה ימים';
$string['secondstotime518400'] = 'שישה ימים';
$string['secondstotime604800'] = 'שבוע אחד';
$string['secondstotime86400'] = 'יום אחד';
$string['secretalreadyused'] = 'קישור אישור שינוי סיסמה כבר משומש, הסיסמה לא השתנתה.';
$string['secs'] = 'שניות';
$string['section'] = 'יחידת־הוראה';
$string['sectionname'] = 'שם יחידת־הוראה';
$string['sections'] = 'יחידות־הוראה';
$string['sectionusedefaultname'] = 'שם יחידת־הוראה מקוצר';
$string['seealsostats'] = 'ראה גם: סטטיסטיקות';
$string['selctauser'] = 'בחירת משתמש';
$string['select'] = 'בחירה';
$string['selectacategory'] = 'יש לבחור קטגוריה';
$string['selectacountry'] = 'בחירת ארץ';
$string['selectacourse'] = 'בחירת קורס';
$string['selectacoursesite'] = 'בחירת מערכת או קורס';
$string['selectagroup'] = 'בחירת קבוצה';
$string['selectall'] = 'בחירת הכל';
$string['selectamodule'] = 'יש לבחור ברכיב פעילות כלשהי';
$string['selectanaction'] = 'בחירת פעולה';
$string['selectanoptions'] = 'בחירת אפשרות';
$string['selectaregion'] = 'בחירת אזור';
$string['selectcategorysort'] = 'אילו קטגוריות ברצונכם למיין?';
$string['selectcategorysortby'] = 'בחרו כיצד תרצו למיין קטיגוריות';
$string['selectcoursesortby'] = 'בחרו כיצד תרצו למיין קורסים';
$string['selectdefault'] = 'בחירת בררת־מחדל';
$string['selectedcategories'] = 'קטגוריות שנבחרו';
$string['selectedfile'] = 'הקובץ שנבחר';
$string['selectednowmove'] = '{$a} קבצים נבחרו להעברה. עכשיו המשיכו לתיקיית היעד ובחרו ב:\'הסטת קבצים לפה\'';
$string['selectfiles'] = 'קבצים שנבחרו';
$string['selectmoduletoviewhelp'] = 'יש לבחור פעילות או משאב לשם צפיה ב"עזרה" המשוייכת אליה.';
$string['selectnos'] = 'בחירת הכל \'לא\'';
$string['selectperiod'] = 'בחירת תקופה';
$string['senddetails'] = 'שליחת פרטי האישיים בדואל';
$string['separate'] = 'פרוד';
$string['separateandconnected'] = 'למידה והבנה בשיטות ניתוח מושכל או רגשי';
$string['separateandconnectedinfo'] = 'מדד זה מבוסס על התאוריה של "למידה והבנה בשיטות ניתוח מושכל או רגשי". תאוריה זו מתארת שתי דרכים שונות שאנו יכולים להעריך וללמוד  דברים שאנו רואים ושומעים. אילו <strong>היודעים באופן מושכל</strong> להישאר אובייקטיבי ככל האפשר, מבלי לכלול תחושות ורגשות. בשיחה עם אנשים אחרים, הם רוצים להגן על רעיונות משלהם, תוך שימוש בהיגיון כדי למצוא חורים ברעיונות של השני. ואילו <strong>היודעים באופן רגשי</strong> הם רגישים יותר לאנשים אחרים. הם מיומנים באמפטיה ונוטים להקשיב ולשאול שאלות עד שהם מרגישים שהם יכולים להתחבר ו"להבין את הדברים מנקודת מבט שלהם". הם לומדים על ידי מנסים לחלוק את החוויות שהובילו לידיעה שהם מוצאים באנשים אחרים.';
$string['servererror'] = 'שגיאה התרחשה בזמן התחברות עם השרת.';
$string['serverlocaltime'] = 'הזמן המקומי של השרת';
$string['setcategorytheme'] = 'הגדר נושא קטגוריה';
$string['setpassword'] = 'הגדר סיסמא';
$string['setpasswordinstructions'] = 'יש להכניס ולחזור על הסיסמה החדשה בתחתית, ולאחר מכן יש ללחות על כפתור "הגדר סיסמה".
 <br />הסיסמה החדשה שלך תשמרותשאר מחובר לאתר.';
$string['settings'] = 'הגדרות';
$string['shortname'] = 'שם מקוצר';
$string['shortnamecollisionwarning'] = 'שם מקוצר זה כבר בשימוש ע"י קורס ו = [*] יצטרך להשתנות באישור';
$string['shortnamecourse'] = 'השם הקצר של הקורס';
$string['shortnamecourse_help'] = '<p align="center"><b>השם הקצר של הקורס</b></p>

<p> להרבה מוסדות יש שמות מקוצרים בהם הם משתמשים על מנת להתייחס לקורסים, לדוגמא משהו כמו BP102 או COMMS. אם אין לכם עדיין שם מקוצר לקורס שלכם, תמציאו אחד כזה כאן. השם המקוצר יופיע בכל מני מקומות בהם לא מתאים להשתמש בשם המלא (לדוגמא, בשורת הנושא בזמן שליחת דואר אלקרוני).
</p>';
$string['shortnametaken'] = 'השם המקוצר כבר בשימוש בקורס אחר ({$a})';
$string['shortnameuser'] = 'השם הקצר של המשתמש';
$string['shortsitename'] = 'שם מקוצר לעמוד הראשי (יופיע בסרגל הניווט)';
$string['show'] = 'הצגה';
$string['showactions'] = 'הצגת פעילויות';
$string['showadvancedsettings'] = 'הצגת הגדרות מתקדמות';
$string['showall'] = 'תצוגת כל ה-{$a}';
$string['showallcourses'] = 'הצגת כל הקורסים';
$string['showallusers'] = 'הצגת כל המשתמשים';
$string['showblockcourse'] = 'הצגת רשימת קורסים המכילים משבצת';
$string['showcategory'] = 'הצגת {$a}';
$string['showcomments'] = 'הראב/הסתר הערות';
$string['showcommentsnonjs'] = 'הצגת הערות';
$string['showdescription'] = 'הצגת ההנחיה בעמוד הראשי של הקורס';
$string['showdescription_help'] = 'אם מאופשר, התיאור/הקדמה מעל תוצג בעמוד הקורס מייד מתחת לקישור של המשאב/פעילות.';
$string['showgrades'] = 'תצוגת גליון־הציונים לתלמידים';
$string['showgrades_help'] = '<p align="center"><b>ציונים</b></p>

<p>פעילויות רבות מאפשרות קביעה של ציונים.</p>

<p>כבררת־המחדל, כל הציונים הניתנים בפעילויות השונות במהלך הקורס ניתן לראות בעמוד הציונים, אליו אפשר להגיע מהעמוד הראשי של הקורס.
</p>

<p>אם מורים לא מעוניינים להשתמש בציונים בקורס, או שהם פשוט רוצים להסתיר את הציונים מעיני הסטודנטים, הם יכולים לבטל את אופציית הצגת הציונים בהגדרות הקורס. הדבר לא מונע מכל פעילויות לקבוע או לעשות שימוש בציונים, אלא רק מבטל את הצגתם בפני הסטודנטים.
</p>';
$string['showingacourses'] = 'מציג את כל {$a} הקורסים';
$string['showingxofycourses'] = 'מציג קורסים {$a->start} עד {$a->end} מתוך {$a->total} קורסים';
$string['showlistofcourses'] = 'הצגת רשימה של קורסים';
$string['showmodulecourse'] = 'הצגת רשימת קורסים המכילים פעילות';
$string['showonly'] = 'הצגה בלבד';
$string['showperpage'] = 'הצגת {$a} לכל עמוד';
$string['showrecent'] = 'הצגת פעילות אחרונה';
$string['showreports'] = 'תצוגת דיווחי פעילות';
$string['showreports_help'] = '<p align="center"><b>דוחות פעילות</b></p>

<p>ישנם דוחות פעילות זמינים על כל משתמש, שמראים את הפעילות המלאה שלו בקורס הנוכחי. בנוסף לרשימות התרומות שלהם, דוחות אלה כוללים רישומי כניסה מפורטים.
</p>

<p>למורים תמיד יש גישה לדוחות הללו, זאת על ידי כפתור שנמצא בעמוד הפרופיל של כל משתמש.
</p>

<p>גישה של סטודנטים לדוחות שלהם נשלטת על ידי המורה באמצעות הגדרות הקורס. בקורסים מסויימים דוחות אלה יכולים לשמש ככלי מועיל לסטודנטים על מנת להרהר על ההשתתפות והנוכחות שלהם בתוך הסביבה המקוונת (און-ליין), אבל יכול להיות שלקורסים אחרים הדבר לא הכרחי.
</p>

<p>סיבה נוספת לכיבוי אפשרות הצגת הדוחות לסטודנטים היא כי בזמן שהם נוצרים, הדוחות יכולים ליצור מעט עומס על השרת. לכיתות גדולות או שיעורים ארוכים, יכול להיות יותר מועיל להשאיר אותה מכובה.
<p>';
$string['showsettings'] = 'הצגת הגדרות';
$string['showtheselogs'] = 'הצגת דוחות אלה';
$string['showthishelpinlanguage'] = 'הצגת עמוד עזרה זה בשפה: {$a}';
$string['since'] = 'מאז';
$string['sincelast'] = 'מאז ההתחברות האחרונה';
$string['site'] = 'מערכת';
$string['sitedefault'] = 'בררת־המחדל של המערכת';
$string['siteerrors'] = 'שגיאות האתר';
$string['sitefiles'] = 'קבצי האתר';
$string['sitefilesused'] = 'קבצי האתר הנמצאים בשימוש בקורס זה';
$string['sitehome'] = 'דף הבית';
$string['sitelegacyfiles'] = 'קבצי המערכת כפי שנוהלו בגרסאות קודמות';
$string['sitelogs'] = 'יומני מעקב האתר';
$string['sitemessage'] = 'מסרים של משתמשים';
$string['sitenews'] = 'חדשות האתר';
$string['sitepages'] = 'כלי המערכת';
$string['sitepartlist'] = 'לא קיימת לך ההרשאה המתאימה לראות את ברשימת המשתתפים.';
$string['sitepartlist0'] = 'אתה חייב להיות מורה האתר בכדי לראות את רשימת המשתתפים באתר';
$string['sitepartlist1'] = 'אתה חייב להיות מורה בכדי לראות את רשימת המשתתפים באתר';
$string['sites'] = 'אתרים';
$string['sitesection'] = 'תצוגת פעילויות ומשאבים';
$string['sitesettings'] = 'הגדרות האתר';
$string['siteteachers'] = 'מורי האתר';
$string['size'] = 'גודל';
$string['sizeb'] = 'בתים';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'דולג';
$string['skiptocategorylisting'] = 'דילוג לרשימות הקטגוריות';
$string['skiptocoursedetails'] = 'דילוג למידע מפורט אודות הקורס';
$string['skiptocourselisting'] = 'דילוג לרשימות הקורסים';
$string['skypeid'] = 'זיהוי משתמש Skype';
$string['socialheadline'] = 'פורום חברתי - נושאים אחרונים';
$string['someallowguest'] = 'יתכן וחלק מהקורסים מאפשרים כניסת אורחים';
$string['someerrorswerefound'] = 'חלק מהמידע היה חסר או לא נכון. לפרטים ראה למטה.';
$string['sort'] = 'מיון';
$string['sortby'] = 'מיון לפי';
$string['sortbyx'] = 'מיון לפי {$a} עולה';
$string['sortbyxreverse'] = 'מיון לפי {$a} יורד';
$string['sorting'] = 'מיון';
$string['sourcerole'] = 'תפקיד מקור';
$string['specifyname'] = 'אתה חייב להגדיר שם.';
$string['standard'] = 'רגיל';
$string['starpending'] = '( קורס המחכה לאישור = [*] )';
$string['startdate'] = 'תאריך תחילת הקורס';
$string['startdate_help'] = 'הגדרה זאת קובעת את ההתחלה של השבוע הראשון של קורס במבנה שבועי. היא גם קובעת את התאריך המוקדם ביותר שבו יופעלו יומני המעקב של הקורס.';
$string['startingfrom'] = 'מתחיל מ';
$string['startsignup'] = 'יצירת חשבון חדש!';
$string['state'] = 'מדינה/מחוז';
$string['statistics'] = 'סטטיסטיקות';
$string['statisticsgraph'] = 'גרף סטטיסטיקות';
$string['stats'] = 'סטטיסטיקות';
$string['statslogins'] = 'כניסות התחברות';
$string['statsmodedetailed'] = 'מראה (מתשתמש) מפורט';
$string['statsmodegeneral'] = 'מראה כללי';
$string['statsnodata'] = 'אין נתונים זמינים להרכב זה של קורס ותקופת זמן';
$string['statsnodatauser'] = 'לא קיימים נתונים לצירוף של משתמש הקורס עם תקופת הזמן.';
$string['statsoff'] = 'הסטטיסטיקות לא מאופשרות כרגע';
$string['statsreads'] = 'צפיות';
$string['statsreport1'] = 'כניסות התחברות';
$string['statsreport10'] = 'פעילות משתמש';
$string['statsreport11'] = 'הקורסים הפעילים ביותר';
$string['statsreport12'] = 'הקורסים הפעילים ביותר (משוקלל)';
$string['statsreport13'] = 'קורסים בעלי השתתפות גדולה ביותר (שרשומים)';
$string['statsreport14'] = 'קורסים בעלי השתתפות גדולה ביותר (צפיות/פרסומים)';
$string['statsreport2'] = 'צפיות (כל התפקידים)';
$string['statsreport3'] = 'פרסומים (כל התפקידים)';
$string['statsreport4'] = 'כל הפעילות (כל התפקידים)';
$string['statsreport5'] = 'כל הפעילות (צפיות ופרסומים)';
$string['statsreport7'] = 'פעילות משתמש (צפיות ופרסומים)';
$string['statsreport8'] = 'פעילות המשתמש';
$string['statsreport9'] = 'כניסות התחברות';
$string['statsreportactivity'] = 'כל פעילות (כל התפקידים)';
$string['statsreportactivitybyrole'] = 'כל פעילות (צפיות ופרסומים)';
$string['statsreportforuser'] = 'עבור';
$string['statsreportlogins'] = 'כניסות התחברות';
$string['statsreportreads'] = 'צפיות (כל התפקידים)';
$string['statsreporttype'] = 'סוג הדוח';
$string['statsreportwrites'] = 'פרסומים (כל התפקידים)';
$string['statsstudentactivity'] = 'פעילות סטודנט';
$string['statsstudentreads'] = 'צפיות הסטודנט';
$string['statsstudentwrites'] = 'פרסומי הסטודנט';
$string['statsteacheractivity'] = 'פעילות מורה';
$string['statsteacherreads'] = 'צפיות המורה';
$string['statsteacherwrites'] = 'פרסומי מורה';
$string['statstimeperiod'] = 'תקופת זמן - אחרון:';
$string['statsuniquelogins'] = 'כניסות התחבות ייחודיות';
$string['statsuseractivity'] = 'כל פעילות';
$string['statsuserlogins'] = 'כניסות התחברות';
$string['statsuserreads'] = 'צפיות';
$string['statsuserwrites'] = 'פרסומים';
$string['statswrites'] = 'פרסומים';
$string['status'] = 'מצב';
$string['stringsnotset'] = 'המחרוזות הבאות אינן מוגדרות ב {$a}';
$string['studentnotallowed'] = 'מצטערים, אבל אתה לא יכול להיכנס לקורס זה כ \'{$a}\'';
$string['students'] = 'סטודנטים';
$string['studentsandteachers'] = 'סטודנטים ומורים';
$string['subcategories'] = 'תת-קטגוריות';
$string['subcategory'] = 'תת קטגוריה';
$string['subcategoryof'] = 'תת קטגוריה של {$a}';
$string['submit'] = 'שמירה';
$string['success'] = 'הצלחה';
$string['summary'] = 'תקציר';
$string['summary_help'] = '<p align="center"><b>פסקאת מבוא לתצורת שבועות או יחידות־הוראה</b></p>

<p>פסקאת מבוא הוא טקסט מאוד קצר שמיועד להכין את הסטודנטים לפעילויות שיופיעו בתוך יחידת־ההוראה (או שבוע) זה.
</p>

<p>על כל פסקאת מבוא להיות קצר ותמציתי, זאת כדי שעמוד הקורס לא ייהפך לארוך מדי.
</p>

<p>אם אתם מוצאים את עצמכם רוצים לכתוב יותר ממשפט או שניים אז כדאי לכם לשקול להוסיף משאב לנושא זה במקום (לדוגמא, הפעילות הראשונה יכולה להיות עמוד בעל הכותרת <b>על יחידת־הוראה זה</b>).</p>';
$string['summaryof'] = 'תקציר של {$a}';
$string['supplyinfo'] = 'אנא ספק מספר נתונים על עצמך';
$string['suspended'] = 'לא־פעיל';
$string['suspendedusers'] = 'משתמשים מושהים';
$string['switchdevicedefault'] = 'מעבר לערכת תצוגה רגילה';
$string['switchdevicerecommended'] = 'החלף לערכת הנושא המומלצת עבור ההתקן שלך';
$string['switchrolereturn'] = 'חזרה לתפקיד הרגיל שלי';
$string['switchroleto'] = 'החלפת תפקיד ל...';
$string['tag'] = 'תג';
$string['tagalready'] = 'תג זה כבר קיים';
$string['tagmanagement'] = 'הוספת/הסרת תגים';
$string['tags'] = 'תגים';
$string['targetrole'] = 'תפקיד מטרה';
$string['teacheronly'] = 'בשביל ה{$a} בלבד';
$string['teacherroles'] = '{$a} תפקידים';
$string['teachers'] = 'מורים';
$string['textediting'] = 'עורך טקסט';
$string['texteditor'] = 'השתמש בעורך דף תוכן פשוט';
$string['textformat'] = 'תסדיר טקסט פשוט';
$string['thanks'] = 'תודה';
$string['theme'] = 'ערכת נושא';
$string['themes'] = 'ערכות נושא';
$string['themesaved'] = 'ערכת הנושא החדשה נשמרה';
$string['therearecourses'] = 'ישנם {$a} קורסים';
$string['thereareno'] = 'אין {$a} בקורס';
$string['thiscategory'] = 'קטגוריה זו';
$string['thiscategorycontains'] = 'קטגוריה זו מכילה';
$string['time'] = 'זמן';
$string['timecreatedcourse'] = 'זמן יצירת הקורס';
$string['timezone'] = 'אזור זמן';
$string['to'] = 'עד תאריך';
$string['tocontent'] = 'תחת משבצת "{$a}"';
$string['tocreatenewaccount'] = 'דילוג ליצירת חשבון חדש';
$string['today'] = 'היום';
$string['todaylogs'] = 'פעילות בקורס מהיום';
$string['toeveryone'] = 'לכולם';
$string['toomanybounces'] = 'לכתובת הדוא"ל הזו היו הרבה ניתורים. תהיה <b> חייב </b> להחליף אותה בכדי להמשיך.';
$string['toomanytoshow'] = 'ישנם יותר מדי משתמשים מכדי להראותם';
$string['toomanyusersmatchsearch'] = 'יותר מדי משתמשים ({$a->count}) מתאימים ל \'{$a->searchי}\'';
$string['toomanyuserstoshow'] = 'יותר מדי משתמשים -({$a})- בכדי להראותם';
$string['toonly'] = 'רק ל{$a}';
$string['top'] = 'ראשי';
$string['topic'] = 'יחידת־הוראה';
$string['topichide'] = 'הסתר נושא זה מפני {$a}';
$string['topicoutline'] = 'יחידות הוראה';
$string['topicshow'] = 'הצגת יחידת-הוראה זו ל {$a}';
$string['toplevelcategory'] = 'קטגוריית רמה עליונה';
$string['total'] = 'סך הכל';
$string['totopofsection'] = 'החלק העליון של היחידה "{$a}"';
$string['trackforums'] = 'מעקב פורום';
$string['trackforumsno'] = 'לא: אל תחזיק במעקב של פרסומים (posts) שראיתי';
$string['trackforumsyes'] = 'כן: הדגש פרסומי הודעות חדשות עבורי';
$string['trysearching'] = 'נסה לחפש במקום';
$string['turneditingoff'] = 'כיבוי עריכה';
$string['turneditingon'] = 'הפעלת עריכה';
$string['unauthorisedlogin'] = 'חשבון המשתמש  "{$a}" אינו זמין באתר זה';
$string['undecided'] = 'בהתלבטות';
$string['unfinished'] = 'לא גמור';
$string['unknowncategory'] = 'קטגוריה לא ידועה';
$string['unknownerror'] = 'שגיאה לא ידועה';
$string['unlimited'] = 'אין הגבלה';
$string['unpacking'] = 'פתיחת ארכיון {$a}';
$string['unsafepassword'] = 'סיסמה לא בטוחה - נסה משהו אחר';
$string['untilcomplete'] = 'עד ההשלמה';
$string['unusedaccounts'] = 'הרישום של חשבונות שלא נעשה בהם שימוש יותר מ{$a} ימים מבוטל באופן אוטומטי';
$string['unzip'] = 'פתח קובץ מכווץ';
$string['unzippingbackup'] = 'פותח גיבוי מקובץ';
$string['up'] = 'מעלה';
$string['update'] = 'עדכן';
$string['updated'] = 'עודכן {$a}';
$string['updatemymoodleoff'] = 'סיום עריכה';
$string['updatemymoodleon'] = 'עריכת (תצוגת) עמוד';
$string['updatemyprofile'] = 'עדכן המאפיינים שלי';
$string['updatesevery'] = 'עדכונים כל {$a} שניות';
$string['updatethis'] = 'עדכן {$a} זה';
$string['updatethiscourse'] = 'עדכן קורס זה';
$string['updatinga'] = 'מעדכן: {$a}';
$string['updatingain'] = 'מעדכן {$a->what} ב{$a->in}';
$string['upload'] = 'העלה';
$string['uploadafile'] = 'העלאת קובץ';
$string['uploadcantwrite'] = 'שגיאה בכתיבת הקובץ לדיסק';
$string['uploadedfile'] = 'הקובץ הועלה בהצלחה';
$string['uploadedfileto'] = 'הקובץ {$a->file} הועלה לספרייה {$a->directory}';
$string['uploadedfiletoobig'] = 'מצטערים, אך קובץ זה גדול מידי (הגודל המירבי הוא {$a} בתים)';
$string['uploadextension'] = 'העלאת הקובץ נעצרה ע"י הרחבת PHP';
$string['uploadfailednotrecovering'] = 'העלאת הקובץ שלך נכשלה בגלל בעיה עם אחד הקבצים, {$a->name}. <br /> אינה יומן מעקב אשר מתאר את הבעיות: <br /> {$a->problem} <br /> אינו מתאושש.';
$string['uploadfilelog'] = 'טען את הרישום עבור הקובץ {$a}';
$string['uploadformlimit'] = 'הקובץ המועלה  {$a} עבר את תחום הגודל המירבי אשר הוגדר בטופס זה.';
$string['uploadlabel'] = 'כותרת:';
$string['uploadlimitwithsize'] = '{$a->contextname} הגבלת העלאה ({$a->displaysize})';
$string['uploadnewfile'] = 'טען קובץ חדש';
$string['uploadnofilefound'] = 'לא נמצא כל קובץ - האם אתה בטוח שבחרת אחד להעלאה?';
$string['uploadnotallowed'] = 'העלאות אינן מורשות';
$string['uploadnotempdir'] = 'תיקיית ה-temporary חסרה';
$string['uploadoldfilesdeleted'] = 'הקובץ הקודם באיזור העלאת הקבצים שלך נמחק';
$string['uploadpartialfile'] = 'קובץ הועלה בצורה חלקית';
$string['uploadproblem'] = 'בעיה לא מזוהה קרתה בזמן העלאת קובץ \'{$a}\' (אולי הוא היה גדול מדי?)';
$string['uploadrenamedchars'] = 'שם הקובץ שונה מ-{$a->oldname} ל-{$a->newname} מפני שקבוצת התווים שגויה.';
$string['uploadrenamedcollision'] = 'שם הקובץ שונה מ-{$a->oldname} ל-{$a->newname} מפני שנוצרה התנגשות (קונפליקט) בקובץ.';
$string['uploadserverlimit'] = 'הקובץ המועלה עבר את תחום הגודל המירבי אשר הוגדר בשרת.';
$string['uploadthisfile'] = 'העלה קובץ זה';
$string['url'] = 'URL';
$string['used'] = 'בשימוש';
$string['usedinnplaces'] = 'בשימוש ב {$a} מקומות';
$string['usemessageform'] = 'או השתמש בטופס להלן בכדי לשלוח הודעה לסטודנטים הנבחרים';
$string['user'] = 'משתמש';
$string['useractivity'] = 'פעילות';
$string['userconfirmed'] = '{$a} מאושר';
$string['usercurrentsettings'] = 'הגדרות כלי משתמש';
$string['userdata'] = 'נתוני משתמש';
$string['userdeleted'] = 'חשבון משתמש זה נמחק';
$string['userdescription'] = 'תיאור';
$string['userdescription_help'] = 'תיבה זאת מאפשרת לכך להכניס טקסט אודותיך שיוצג לאחר מכן בדף הפרופיל שלך בעבור צופים אחרים.';
$string['userdetails'] = 'מאפייניי המשתמש';
$string['userfiles'] = 'קבצי משתמש';
$string['userlist'] = 'רשימת משתמשים';
$string['usermenu'] = 'תפריט משתמש';
$string['username'] = 'שם משתמש';
$string['usernameemail'] = 'שם משתמש/ דוא"ל';
$string['usernameemailmatch'] = 'שם המשתמש וכתובת הדוא"ל אינם שייכים לאותו משתמש';
$string['usernameexists'] = 'שם משתמש זה כבר קיים, בחר אחר';
$string['usernamelowercase'] = 'רק אותיות lowercase מאופשרות';
$string['usernamenotfound'] = 'שם המשתמש לא נמצא במסד הנתונים';
$string['usernameoremail'] = 'הכנס אחד משניים שם משתמש או כתובת דוא"ל';
$string['usernotconfirmed'] = 'לא ניתן לאשר את {$a}';
$string['userpic'] = 'תמונת המשתמש';
$string['users'] = 'משתמשים';
$string['userselectorautoselectunique'] = 'אם משתמש אחד תואם לחיפוש, יש לבחור אותו אוטומטית';
$string['userselectorpreserveselected'] = 'שמירת משתמשים שנבחרו, אפילו אם הם לא תואמים יותר את החיפוש';
$string['userselectorsearchanywhere'] = 'חיפוש התווים לעיל, במקום כלשהו בשמו של המשתמש';
$string['usersnew'] = 'משתמשים חדשים';
$string['usersnoaccesssince'] = 'לא פעיל ליותר מ';
$string['userswithfiles'] = 'מתשמשים עם קבצים';
$string['useruploadtype'] = 'סוג ההעלאה למשתמש {$a}';
$string['userviewingsettings'] = 'הגדרות הפרופיל עבור {$a}';
$string['userzones'] = 'אזורי משתמש';
$string['usetheme'] = 'השתמשו בערכת נושא זו';
$string['usingexistingcourse'] = 'משתמש בקורס קיים';
$string['valuealreadyused'] = 'ערך זה מצוי בפרופיל של משתמש קיים, אנא הזינו ערך שונה.';
$string['version'] = 'גירסה';
$string['view'] = 'תצוגה';
$string['viewallcourses'] = 'צפייה בכל הקורסים';
$string['viewallcoursescategories'] = 'צפייה בכל הקורסים והקטגוריות';
$string['viewallsubcategories'] = 'תצוגת כל תת־הקטגוריות';
$string['viewfileinpopup'] = 'צפייה בקובץ ובחלון הקופץ';
$string['viewing'] = 'מציג';
$string['viewmore'] = 'תוכן נוסף';
$string['viewprofile'] = 'תצוגת מאפיינים';
$string['views'] = 'צפיות';
$string['viewsolution'] = 'הצגת פתרון';
$string['virusfound'] = 'הודעה חשובה למנהלי האתר! תוכנת Clam AV מצאה וירוס בקובץ המועלה ע"י {$a->user} בקורס {$a->course}. להלן פלט תוכנית האנטי-וירוס:';
$string['virusfoundlater'] = 'הקובץ אשר עלה בתאריך {$a->date} עם שם הקובץ {$a->filename} בקורס {$a->course} נמצא מאז נגוע בוירוס. הינה סיכום מאורעות קובץ זה: {$a->action} אם זאת הייתה עבודת הגשה, תוכל להגיש אותה שנית כך שהמורה שלך יראה אותה. If this was submitted work, you may want to resubmit it so that your tutor can see it';
$string['virusfoundlateradmin'] = 'הודעה חשובה למנהלי האתר! קובץ אשר הועלה ב {$a->date} עם שם הקובץ {$a->filename} בקורס {$a->course} ע"י המשתמש {$a->user} נמצא מאז נגוע בוירוס. הינה סיכום מאורעות קובץ זה: {$a->action} אל משתמש זה נשלחה הודעה בנידון';
$string['virusfoundlateradminnolog'] = 'הודעה חשובה למנהלי האתר! קובץ אשר הועלה עם שם הקובץ {$a->filename} נמצא מאז נגוע בוירוס? מערכת Moodle לא הצליחה להפריד את קובץ זה חזרה אל המשתמש אשר העלה את קובץ זה מלכתחילה.';
$string['virusfoundsubject'] = '{$a}: נמצא וירוס!';
$string['virusfounduser'] = 'הקובץ אשר עלה, {$a->filename} ,נסרק ע"י תוכנת וירוס ונתגלה כנגוע בוירוס! העלאת הקובץ נכשלה!';
$string['virusplaceholder'] = 'קובץ זה אשר הועלה נמצאה כנגוע בוירוס והוסר או נמחק. בנוסף המשתמש קיבל הודעה על כך.';
$string['visible'] = 'זמינות';
$string['visible_help'] = 'הגדרות אלו קובעות אם הקורס יופיע או לא יופיע ברשימת הקורסים. פרט למרצים / מורים ומנהלים לא מורשים משתמשים אחרים להכנס לקורס.';
$string['visibletostudents'] = 'גלוי ל{$a}';
$string['warning'] = 'אזהרה';
$string['warningdeleteresource'] = 'אזהרה: {$a} מיוחס למשאב. האם תרצה לעדכן את המשאב?';
$string['webpage'] = 'דף בית באינטרנט';
$string['week'] = 'שבוע';
$string['weekhide'] = 'הסתר שבוע זה מפני {$a}';
$string['weeklyoutline'] = 'סקירה שבועית';
$string['weeks'] = 'שבועות';
$string['weekshow'] = 'הצגת שבוע זה ל {$a}';
$string['welcometocourse'] = 'ברוך בואך לקורס {$a}';
$string['welcometocoursetext'] = 'ברוכים הבאים לקורס {$a->coursename}!

אם לא עשיתם זאת כבר, עליכם לערוך את עמוד הפרופיל שלכם בקורס כך שנוכל להכירכם טוב יותר:

{$a->profileurl}';
$string['whatforlink'] = 'מה אתם מעוניינים לעשות עם הקישור?';
$string['whatforpage'] = 'מה אתם מעוניינים לעשות עם המלל?';
$string['whattocallzip'] = 'כיצד אתה רוצה לקרוא לקובץ זיפ זה?';
$string['whattodo'] = 'מה לעשות';
$string['windowclosing'] = 'חלון זה יסגר באופן אוטומטי. אם החלון לא נסגר, סגור אותו.';
$string['withchosenfiles'] = 'פעולות עבור הקבצים הנבחרים';
$string['withdisablednote'] = '{$a} (אינו-זמין)';
$string['withoutuserdata'] = 'ללא נתוני משתמש';
$string['withselectedusers'] = 'פעולות עבור המשתמשים הנבחרים...';
$string['withselectedusers_help'] = '* שליחת הודעה - עבור שליחת הודעה לאחר או יותר נמענים.
* הוספת הערה - עבור הוספת הערה למשתתפים שנבחרו.
* הוספת הערה נפוצה - עבור הוספת הערה נפוצה עבור אחד או יותר משתתפים.';
$string['withuserdata'] = 'עם נתוני משתמש';
$string['wordforstudent'] = 'מילתך לסטודנט';
$string['wordforstudenteg'] = 'לדוגמא: סטודנט, משתמש וכדומה';
$string['wordforstudents'] = 'מלתך לסטודנטים';
$string['wordforstudentseg'] = 'לדוגמא: סטודנטים, משתמשים וכדומה';
$string['wordforteacher'] = 'מילתך למורה';
$string['wordforteachereg'] = 'לדוגמא: מורה,  מדריך, חונך וכדומה';
$string['wordforteachers'] = 'מילתך למורים';
$string['wordforteacherseg'] = 'לדוגמא: מורים, מדריכים חונכים וכדומה';
$string['writingblogsinfo'] = 'כתיבת מידע הבלוגים';
$string['writingcategoriesandquestions'] = 'כתיבת קטגוריות ושאלות';
$string['writingcoursedata'] = 'כתיבת נתוני קורס';
$string['writingeventsinfo'] = 'כתיבת מידע אירועים';
$string['writinggeneralinfo'] = 'כתיבת מידע כללי';
$string['writinggradebookinfo'] = 'כתיבת מידע על ספר ציונים';
$string['writinggroupingsgroupsinfo'] = 'כתיבת מידע על קבוצות - אוסף קבוצות';
$string['writinggroupingsinfo'] = 'כתיבת מידע עבור אוסף הקבוצות';
$string['writinggroupsinfo'] = 'כתיבת מידע קבוצות';
$string['writingheader'] = 'כתיבת כותרת';
$string['writingloginfo'] = 'כתיבת דוחות מידע';
$string['writingmessagesinfo'] = 'כתיבת מידע על הודעות';
$string['writingmoduleinfo'] = 'כתיבת מידע מודולים';
$string['writingscalesinfo'] = 'כתיבת מרכיבי מדרגות־הערכה';
$string['writinguserinfo'] = 'כתיבת מידע משתמשים';
$string['wrongpassword'] = 'סיסמה שגויה לשם משתמש זה';
$string['yahooid'] = 'משתמש Yahoo';
$string['year'] = 'שנה';
$string['years'] = 'שנים';
$string['yes'] = 'כן';
$string['youareabouttocreatezip'] = 'אתה עומד ליצור קובץ ארכיב 7zip המכיל';
$string['youaregoingtorestorefrom'] = 'אתה עומד להתחיל את תהליך השיחזור ל';
$string['youneedtoenrol'] = 'לביצוע פעולה זו תצטרך להירשם לקורס זה.';
$string['yourlastlogin'] = 'התחברותך האחרונה היתה';
$string['yourself'] = 'עצמך';
$string['yourteacher'] = '{$a} שלך';
$string['yourwordforx'] = 'התפקיד \'{$a}\' יוצג כ:';
$string['zippingbackup'] = 'מכווץ את הגיבוי לארכיב';
