<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'he', branch 'MOODLE_28_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'בקרת גישה';
$string['actionaftercorrectanswer'] = 'הפעולה לאחר תשובה נכונה';
$string['actionaftercorrectanswer_help'] = '<p>הפעולה המקובלת היא לעקוב אחר הקפיצה המתוארת בתשובה. ברוב המקרים הדבר יראה על העמוד הבא של השיעור. הסטדנט עובר על השיעור בדרך לוגית, מתחיל בתחילת השיעור ומסתיים בסופו.</p>

<p>בכל אופן, ניתן להשתמש ברכיב השיעור כסוג של מטלת <i>עמוד "פלאש" </i>.לסטודנט מוצגים מידע (חלופי) ושאלה בסדר אקראי בד"כ. אין קביעה של התחלה או קביעה של סוף. רק מוצגות קביעות של <i>עמודים</i> אחד אחרי השני בסדר שאיננו מיוחד.
</p>
<p>אפשרות זו מותירה לשתי גרסאות דומות מאוד של התנהגות עמוד "פלאש". האפשרות "הצג עמוד שלא נראה" לעולה לא מציגה את אותו עמוד פעמיים (גם אם הסטודנט <b>לא</b> ענה על השאלה הקשורה לעמוד הנוכחי). האפשרות השניה (שאיננה בררת־מחדל) "הצג עמוד שלא נענה" מאפשר לסטודנט לצפות עמודים אשר כנראה הופיעו בעבר אך רק אם הם ענו על השאלה המקושרת בצורה שגויה.</p>

<p>בעמוד ה-"פלאש" וגם בסוג השיעור המורה יכול להחליט אם להשתמש בכל העמודים שבשיעור או רק בתת-קביעה (אקראית). הדבר נעשה ע"י משתנה "מספר העמודים להצגה"</p>';
$string['actions'] = 'פעולות';
$string['activitylink'] = 'קשר לפעילות הבאה';
$string['activitylink_help'] = '<p align="center"><b>קישור לפעילות</b></p>

<p>התפריט הנפתח מכיל את כל הפעילויות שיש בקורס הזה. ביחרו כל פעילות שהיא מתוך הרשימה ובסוף השיעור יופיע קישור שיוביל אליה.
</p>';
$string['activitylinkname'] = 'צפיה ב: {$a}';
$string['activityoverview'] = 'ישנם שיעורים שמועדם הגיע';
$string['addabranchtable'] = 'הוספת עמוד תוכן מסתעף';
$string['addanendofbranch'] = 'הוספת סוף הסתעפות';
$string['addanewpage'] = 'הוספת עמוד חדש';
$string['addaquestionpage'] = 'הוספת עמוד';
$string['addaquestionpagehere'] = 'הוספת עמוד כאן';
$string['addbranchtable'] = 'הוספת טבלת הסתעפות';
$string['addcluster'] = 'הוספת אשכול';
$string['addedabranchtable'] = 'התווסף עמוד תוכן מסתעף';
$string['addedanendofbranch'] = 'התווסף סוף ההסתעפות';
$string['addedaquestionpage'] = 'התווסף עמוד';
$string['addedcluster'] = 'התווסף אשכול';
$string['addedendofcluster'] = 'התווסף סוף האשכול';
$string['addendofcluster'] = 'הוספת סוף אשכול';
$string['addpage'] = 'הוספת עמוד מסוג';
$string['anchortitle'] = 'תחילת תוכן עיקרי';
$string['and'] = 'ו';
$string['answer'] = 'תשובה';
$string['answeredcorrectly'] = 'נענה נכונה';
$string['answersfornumerical'] = 'לתשובות לשאלות מספריות צריך להתאים זוגות של ערכי מקסימום ומינמום.';
$string['arrangebuttonshorizontally'] = 'במצב \'מצגת\' לסדר את כפתורי ההסתעפות במאוזן?';
$string['attempt'] = 'ניסיון: {$a}';
$string['attempts'] = 'ניסיונות';
$string['attemptsdeleted'] = 'ניסיונות מחוקים';
$string['attemptsremaining'] = 'נשארו לך עוד {$a} ניסיונות';
$string['available'] = 'זמין החל מ-';
$string['averagescore'] = 'תוצאה ממוצעת';
$string['averagetime'] = 'זמן ממוצע';
$string['branch'] = 'הסתעף';
$string['branchtable'] = 'עמוד תוכן מסתעף';
$string['cancel'] = 'ביטול';
$string['cannotfindanswer'] = 'שגיאה: התשובה לא נמצאה';
$string['cannotfindattempt'] = 'שגיאה: הניביון לא נמצא';
$string['cannotfindessay'] = 'שגיאה: המאמר לא נמצא';
$string['cannotfindfirstgrade'] = 'שגיאה: לא נמצאו הציונים';
$string['cannotfindfirstpage'] = 'לא נמצא העמוד הראשון';
$string['cannotfindgrade'] = 'שגיאה: לא נמצאו הציונים';
$string['cannotfindnewestgrade'] = 'שגיאה:  הציון החדש לא נמצא';
$string['cannotfindnextpage'] = 'גיבוי השיעור : העמוד הבא לא נמצא';
$string['cannotfindpagerecord'] = 'הוספת סיום הסתעפות: רשומת העמוד לא נמצאה';
$string['cannotfindpages'] = 'דפי השיעור לא נמצאו';
$string['cannotfindpagetitle'] = 'אישור מחיקה: כותרת העמוד לא נמצאה';
$string['cannotfindpreattempt'] = 'רשומת הניסיון הקודם לא נמצאה!';
$string['cannotfindrecords'] = 'שגיאה: לא נמצאו רשומות השיעור';
$string['cannotfindtimer'] = 'לא ניתן היה למצוא את רשומות
lesson_timer';
$string['cannotfinduser'] = 'שגיאה: לא ניתן היה למצוא משתמשים';
$string['canretake'] = 'ה-{$a} יכול לנסות מחדש';
$string['casesensitive'] = 'השתמש בביטויים רגולריים';
$string['casesensitive_help'] = '<p align="center"><b>אפשרויות של שאלות</b></p>

<p>לכמה מסוגי השאלות יש אפשרות שמופעלת על ידי לחיצה על תיבת הסימון. סוגי השאלות והמשמעויות שלהם, מפורטות למטה.
</p>

<ol>
<li><p><b>שאלות אמריקאיות (שאלות רב־בחירה)</b>ישנה גרסה לשאלות האמריקאיות (רבות בחירה) הנקראת שאלות <b>"אמריקאיות (רבות בחירה), מרובות תשובות"</b>. אם אתם בוחרים באפשרות זו, אז הסטודנט מחויב לבחור בכל התשובות הנכונות מתוך מקבץ התשובות. בשאלה עצמה לאוו דווקא יאמר לסטודנט <i>כמה</i> תשובות נכונות ישנן. לדוגמה, השאלה: "מי מהאנשים הבאים כיהן כנשיא ארה"ב??" לא מודיעה לסטודנט כמה תשובות נכונות ישנן, לעומת השאלה: "בחרו מהרשימה הבאה את שני האנשים שכיהנו כנשיאי ארה"ב", שכן עושה זאת. מספר התשובות הנכונות יכול להיות כל ערך הכל מ<b>אחת</b> ועד למספר של כל האפשרויות שמתוכן ניתן לבחור.
{שאלה אמריקאית \'מרובת תשובות\' בעלת רק תשובה נכונה אחת <b>הינה</b> עדיין שונה משאלה אמריקאית (רב-ברירה) בגלל שהיא עדיין מאפשרת לסטודנט לבחור ביותר מתשובה אחת, בעוד שהשאלה האמריקאית (רב-ברירה) לא מאפשרת זאת כלל.}
</p></li>

<li>
  <p><b>תשובה קצרה</b> ישנן שתי מערכות השוואה שונות שניתן להשתמש בהן לשאלות מסוג \'תשובה קצרה\': המערכת הפשוטה ביותר משמשת כברירת המחדל. ניתן להשתמש במערכת ה"ביטוי הרגולרי", כל שצריך לעשות זה לסמן את תיבת הסימון של האפשרות "ביטוי רגולרי". למידע נוסף, אנא קראו את קובץ העזרה: סוגי שאלות בשיעור.
</p>
</li>
</ol>
<p>שאר סוגי השאלות, לא עושות שימוש ב\'אפשרות השאלה\'.
</p>';
$string['checkbranchtable'] = 'בדוק את טבלת ההסתעפויות';
$string['checkedthisone'] = 'בדוק את זו';
$string['checknavigation'] = 'בדוק את הניווט';
$string['checkquestion'] = 'בדוק את השאלה';
$string['classstats'] = 'הנתונים הסטטיסטיים של הכיתה';
$string['clicktodownload'] = 'לחץ על הקישור הבא כדי להוריד את הקובץ';
$string['clicktopost'] = 'לחץ כאן כדי לפרסם את הציון שלך ברשימת התוצאות הגבוהות.';
$string['cluster'] = 'אשכול';
$string['clusterjump'] = 'שאלת אנסין בתוך אשכול';
$string['clustertitle'] = 'אשכול';
$string['collapsed'] = 'מצומצם';
$string['comments'] = 'ההערות שלך';
$string['completed'] = 'הושלם';
$string['completederror'] = 'השלם את השיעור';
$string['completethefollowingconditions'] = 'עלייך לעמוד בתנאי(ם) הבאים<b>{$a}</b> בשיעור לפני שתוכל להתקדם הלאה.';
$string['conditionsfordependency'] = 'התנאי(ם) לתלות';
$string['configactionaftercorrectanswer'] = 'פעולת בררת־מחדל שתופעל לאחר תשובה הכונה';
$string['configmaxanswers'] = 'ברירית המחדל של המספר המירבי של תשובות/הסתעפיות בעמוד';
$string['configmaxhighscores'] = 'מספר ציונים גבוהים שיוצג ';
$string['configmediaclose'] = 'הצגת כפתור סגירה כחלק חלון קופץ המיוצר עבור קובץ מדיה מקושר';
$string['configmediaheight'] = 'מגדיר את הגובה של החלון הקופץ המוצג עבור קובץ מדיה מקושר';
$string['configmediawidth'] = 'מגדיר את הרוחב של החלון הקופץ המוצג עבור קובץ מדיה מקושר';
$string['configslideshowbgcolor'] = 'צבע הרקע למצגת אם היא מאופשרת';
$string['configslideshowheight'] = 'מגדיר את הגובה של המצגת אם מאופשרת';
$string['configslideshowwidth'] = 'הגדרת רוחב מצגת השיקופיות (באם היא מופעלת)';
$string['confirmdelete'] = 'מחק עמוד';
$string['confirmdeletionofthispage'] = 'אשר את המחיקה של עמוד זה';
$string['congratulations'] = 'איחולים לבבים - הגעת לסוף השיעור';
$string['continue'] = 'המשך';
$string['continuetoanswer'] = 'המשך לשנות את התשובות';
$string['continuetonextpage'] = 'המשך לעמוד הבא.';
$string['correctanswerjump'] = 'העמוד שיוצג במצב של "תשובה נכונה"';
$string['correctanswerscore'] = 'ניקוד של תשובה נכונה';
$string['correctresponse'] = 'תגובה נכונה';
$string['createaquestionpage'] = 'צרו עמוד שאלה';
$string['credit'] = 'ניקוד';
$string['customscoring'] = 'ניקוד מותאם אישית';
$string['customscoring_help'] = '<p align="center"><b>ניקוד מותאם אישית</b></p>

<p>אפשרות זו תאפשר לכם לתת ערך מספרי לנקודות של כל תשובה (לקבוע את מספר הנקודות שהתשובה מזכה).
לתשובות יכול להיות ערך חיובי וכמו כן גם ערך שלילי. לתשובות מיובאות יוקצה באופן אוטומטי ערך של נקודה אחת לתשובות נכונות וערך של 0 לתשובות לא נכונות, את זה אתם יכולים לשנות לאחר הייבוא.

</p>';
$string['deadline'] = 'מועד סופי להגשה';
$string['defaultessayresponse'] = 'המאמר שלך ייבדק על ידי המדריך של הקורס.';
$string['deleteallattempts'] = 'מוחק את כל נסיונות המענה';
$string['deletedefaults'] = 'מוחקים {$a} שיעורים כבררת־מחדל';
$string['deletedpage'] = 'עמוד מחוק';
$string['deletepagenamed'] = 'מחיקת עמוד: {$a}';
$string['deleting'] = 'מוחק';
$string['deletingpage'] = 'מוחק את עמוד: {$a}';
$string['dependencyon'] = 'תלוי ב-';
$string['dependencyon_help'] = '<p align="center"><b>תלות</b></p>

<p>הגדרה זו מאפשרת להפוך את השתתפות הסטודנט בשיעור הנוכחי לתלויה ברמת ביצועיו בשיעור אחר (באותו הקורס). אם הסטודנט לא עומד בדרישות, אז הוא לא יוכל להיכנס לשיעור הזה. </p>

<p>הדרישות כוללות:
    <ul>
        <li><b>זמן:</b> על הסטודנט לבלות (לפחות) כמות זמן מוגדרת בשיעור הנדרש.
</li>
        <li><b>שלם:</b>על הסטודנט לסיים את השיעור הנדרש בשלמותו.</li>
        <li><b>ציון יותר גבוה מאשר:</b>על הסטודנט לקבל בשיעור הנדרש ציון יותר גבוה מהציון שמפורט פה. </li>
    </ul>
כשהדבר נדרש, אתם יכולים להשתמש בכל שילוב של הדרישות לעיל.
</p>';
$string['description'] = 'תיאור';
$string['detailedstats'] = 'סטטיסטיקה';
$string['didnotanswerquestion'] = 'לא ענה על השאלה.';
$string['didnotreceivecredit'] = 'לא קיבל את הניקוד.';
$string['displaydefaultfeedback'] = 'הצגת המשוב שמשמש כבררת־מחדל';
$string['displaydefaultfeedback_help'] = '<p align="center"><strong>הצגת המשוב שמשמש כבררת־מחדל</strong></p>

<p>אם אפשרות זו נקבעת ל<strong>כן</strong>, אז, גם כאשר לא נמצאה תגובה לשאלה מסוימת, ישתמשו בתגובות שמשמשות כברירות המחדל: "זוהי התשובה הנכונה" ו"זוהי לא התשובה הנכונה". </p>
<p>אם אפשרות זו נקבעת ל<strong>לא</strong>,אז כאשר לא נמצאה תשובה לשאלה מסוימת, לא יוצג עליה משוב. הסטודנט שלומד את השיעור יופנה אוטומטית לעמוד הבא בשיעור.
</p>';
$string['displayhighscores'] = 'הצגת התוצאות הגבוהות';
$string['displayinleftmenu'] = 'להציג בתפריט השמאלי?';
$string['displayleftif'] = 'הצגת תפריט שמאלי רק כאשר הציון גדול מ:';
$string['displayleftif_help'] = 'הגדרה זו קובעת האם סטודנט חייב להגיע לציון מסויים לפני שהוא צופה בתפריט השמאלי. הדבר מכריח את הסטודנט לעבור על כל השיעור  בנסיון הראשון שלו, ולאחר הגעה לציון  הנדרש הוא יכול להשתמש ולצפות בתפריט השמאלי';
$string['displayleftmenu'] = 'הצגת תפריט שמאלי';
$string['displayleftmenu_help'] = '<p>אפשרות זו תציג רשימה של העמודים (עמוד תוכן מסתעף) בשיעור זה.</p>
<p>בנוסף לכך, על ידי פירוט ציון הגבוה מאפס, משתמש הלוקח את שיעור זה לא יוכל לראו את התפריט השמאלי אם הוא אינו בעל ציון השווה או גבוה מהציון המפורט. מה מאפשר למעצבי שיעורים לכפות על המשתמשים לעבור דרך כל חלקי השיעור במהלך ניסיון המענה הראשון של הסטודנט. לאחר מכן, אם הסטודנט לוקח מחדש את השיעור לאחר שהוא מקבל את הציון הנדרש, הוא יכול לראות את התפריט השמאלי על מנת שיעזור לו במהלך העיון בתשובות.
</p>';
$string['displayofgrade'] = 'תצוגת הציון (לתלמידים בלבד)';
$string['displayreview'] = 'הצגת כפתור הסקירה';
$string['displayreview_help'] = '<p align="center"><b>הצג כפתור סקירה</b></p>

<p>אם תבחרו את אפשרות זו, לאחר שסטודנט ענה לא נכונה על שאלה, יוצג כפתור שיאפשר לו לענות עליה שנית. אפשרות זו לא מתאימה לשאלות הדורשות חיבור מאמרים, אז אל תפעילו אותה אם אתם משתמשים בשאלות מסוג זה.</p>';
$string['displayscorewithessays'] = 'עבור השאלות שנבדקות באופן אוטומטי קיבלת {$a->score} נקודות מתוך {$a->tempmaxgrade} .<br>
שאלת(ות) החיבור {$a->essayquestions}  שלך תבדק, והציון שתקבל עבורה יתווסף <br />במועד מאוחר יותר לחישוב של הציון הסופי שלך. <br /><br />
הציון הנוכחי שלך, מבלי שאלת(ות) החיבור הוא תוצאה של {$a->score} מתוך {$a->grade}.';
$string['displayscorewithoutessays'] = 'התוצאה שלך היא {$a->score} (מתוך {$a->grade}).';
$string['edit'] = 'עריכה';
$string['editingquestionpage'] = 'עריכת עמוד שאלה {$a}';
$string['editlessonsettings'] = 'עריכת הגדרות השיעור';
$string['editpage'] = 'עריכת תוכן העמוד';
$string['editpagecontent'] = 'עריכת תכולת העמוד';
$string['email'] = 'דוא"ל';
$string['emailallgradedessays'] = 'שליחת דואל לכל אילו שמאמריהם שנבדקו';
$string['emailgradedessays'] = 'שליחה בדוא"ל מאמרים בדוקים';
$string['emailsuccess'] = 'הודעות דוא"ל נשלחו בהצלחה';
$string['emptypassword'] = 'הסיסמה איננה יכולה להיות ריקה';
$string['endofbranch'] = 'סוף ההסתעפות';
$string['endofcluster'] = 'סוף האשכול';
$string['endofclustertitle'] = 'סוף אשכול';
$string['endoflesson'] = 'סוף השיעור';
$string['enteredthis'] = 'הכניס את זה.';
$string['entername'] = 'הכנס כינוי חיבה לרשימת התוצאות הגבוהות.';
$string['enterpassword'] = 'בבקשה הכנס את הסיסמה:';
$string['eolstudentoutoftime'] = 'שים לב: נגמר לך הזמן המוקצב לשיעור זה. יכול להיות שהתשובה האחרונה שלך לא נספרה, אם ענית לאחר שהזמן נגמר.';
$string['eolstudentoutoftimenoanswers'] = 'לא ענית על אף שאלה. קיבלת ציון 0 עבור שיעור זה.';
$string['essay'] = 'מאמר';
$string['essayemailmessage'] = '<p>הוראות למאמר:<blockquote>{$a->question}</blockquote></p><p>תגובתך:<blockquote><em>{$a->response}</em></blockquote></p><p>{$a->teacher}\'s הערות:<blockquote><em>{$a->comment}</em></blockquote></p><p>קיבלת {$a->earned} מתוך {$a->outof} עבור שאלת מאמר זו.</p><p>
הציון שלך עבור שיעור זה שונה ל-{$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p>נסיון מהיר:<blockquote>{$a->question}</blockquote></p><p>התגובות שלך:<blockquote><em>{$a->response}</em></blockquote></p><p>הערות נותן הציון:<blockquote><em>{$a->comment}</em></blockquote></p><p>קיבלת {$a->earned} מתוך {$a->outof} עבור שאלה מהירה זו.</p><p>ציון השיעור שלך השתנה ל-{$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'הציון שלך עבור שאלה {$a}';
$string['essays'] = 'מאמרים';
$string['essayscore'] = 'ציון המאמר';
$string['eventessayassessed'] = 'המאמר הוערך';
$string['eventessayattemptviewed'] = 'נסיונות מאמר נצפו';
$string['eventhighscoreadded'] = 'תוצאה גבוהה התווספה';
$string['eventhighscoresviewed'] = 'תוצאות גבוהות נצפו';
$string['eventlessonended'] = 'שיעור השתיים';
$string['eventlessonstarted'] = 'שיעור התחיל';
$string['false'] = 'לא נכון';
$string['fileformat'] = 'תסדיר הקובץ';
$string['finish'] = 'סיום';
$string['firstanswershould'] = 'בחירת התשובה הראשונה תציג את העמוד המוגד כ"נכון"';
$string['firstwrong'] = 'למרבה הצער, אינך יכול לזכות בנקודה זו מפני שהתשובה שלך היתה שגויה. האם תרצה להמשיך לנחש בשביל האושר שכרוך בלמידה (אבל ללא נקודות נוספות)?';
$string['flowcontrol'] = 'בקרת זרימה';
$string['fractionsaddwrong'] = 'המשקלים החיוביים בהם בחרת לא מסתכמים ל-100%<br />במקום זאת, הם מסתכמים ל-{$a}%<br />האם ברצונך לחזור ולתקן שאלה זו?';
$string['fractionsnomax'] = 'אחת מהתשובות צריכה להעניק 100% כדי שאפשר יהיה <br />לקבל את הציון המירבי עבור שאלה זו.<br />האם ברצונך לחזור ולתקן שאלה זו?';
$string['full'] = 'מורחב';
$string['general'] = 'כללי';
$string['gotoendoflesson'] = 'המשך לסוף השיעור';
$string['grade'] = 'ציון';
$string['gradebetterthan'] = 'ציון טוב יותר מאשר (%)';
$string['gradebetterthanerror'] = 'הרווח ציון טוב יותר מ- {$a} אחוז';
$string['gradeessay'] = 'מתן ציון לשאלות המאמרים ({$a->notgradedcount} עדיין לא נבדקו ו-{$a->notsentcount} לא נשלחו.)';
$string['gradeis'] = 'הציון הוא {$a}';
$string['gradeoptions'] = 'אפשרויות ציון';
$string['handlingofretakes'] = 'ניהול מקרים בהם הסטודנטים חוזרים על השיעור יותר מפעם אחת';
$string['handlingofretakes_help'] = '<p align="center"><b>ניהול מקרים בהם הסטודנטים חוזרים על אותו השיעור</b></p>

<p>כאשר מאפשרים לסטודנטים לחזור על השיעור, אפשרות זו מאפשרת למורה להציג את הציון של השיעור ב(לדוגמא) עמוד הציון, או כ<b>ממוצע</b> (ממוצע בין הציון שהסטודנט קיבל במהלך הניסיון הראשון שלו ובין הציונים שהוא קיבל בנסיונות העוקבים), או כציון (שהוא קיבל בנסיון) <b>הטוב ביותר</b> של הסטודנט.
</p>

<p>את אפשרות זו ניתן לשנות בכל עת.</p>';
$string['havenotgradedyet'] = 'עדיין לא נבדק';
$string['here'] = 'הנה';
$string['highscore'] = 'תוצאה גבוהה';
$string['highscores'] = 'תוצאות גבוהות';
$string['hightime'] = 'זמן גבוה';
$string['importcount'] = 'ייבוא {$a} שאלות';
$string['importquestions'] = 'ייבא שאלות';
$string['importquestions_help'] = '<p align="center"><b>ייבוא שאלות חדשות</b></p>

<p>פונקציה זו מאפשרת לכם לייבא שאלות מקבצי טקסט חיצוניים, אותם מעלים דרך טופס. </p>

<p>הליך זה תומך במספר תסדירים של קבצים:
</p>

<p><b> תסדיר GIFT</b></p>
<ul>
<p>GIFT הינו תסדיר קובץ הייבוא הכי מקיף שבאמצעותו ניתן לייבא שאלות לבחנים של מוודל מתוך קבצי טקסט. הוא תוכנן להיות שיטה פשוטה למורים שכותבים את שאלותיהם בתוך קבצי טקסט. GIFT תומך בשאלות נכון/לא-נכון, שאלות אמריקאיות, שאלות בעלות תשובות קצרות, שאלות התאמה ושאלות בעלות תשובות מספריות, בנוסף לשאלות בתסדיר "המילה החסרה", בהם מחדירים ______ .  בקובץ טקסט יחיד ניתן לערבב מספר סוגים שונים של שאלות, ובנוסף לכך, התסדיר תומך בהערות, נתינת שמות לשאלות, משוב וציונים המבוססים על אחוזים והמשקל שניתן להם. הנה כמה דוגמאות:</p>
<pre>
מי קבור בקבר של גראנט?{~גראנט ~ג\'פרסון =אף אחד}

גראנט{~קבור =לקבור ~חי} בקבר של גראנט.

גראנט קבור בקבר של גראנט.{לא נכון}

מי קבור בקבר של גראנט?{=אף אחד =אף אחד לא}

מתי נולד יוליסס ס. גרנט (Ulysses S. Grant) ?{#1822}
</pre>

<p align="right"><a href="help.php?file=formatgift.html&module=quiz">מידע נוסף על תסדיר ה"GIFT" </a></p>
</ul>

<p><b>תסדיר Aiken</b></p>
<ul>
<p>Aiken הוא למעשה שיטה מאוד פשוטה ליצירת שאלות אמריקאיות על ידי שימוש בתסדיר מאוד ברור וקריא. הנה דוגמא לתסדיר הAiken:
</p>
<pre>
מהי המטרה של עזרה ראשונה?
א. להציל חיים, למנוע פגיעה נוספת, לשמר בריאות טובה.
ב. לספק טיפול רפואי לכל אדם פצוע או פגוע.
ג. למנוע פגיעה נוספת
ד. לעזור לקורבנות שמחפשים עזרה.
תשובה: א
</pre>

<p align="right"><a href="help.php?file=formataiken.html&module=quiz">מידע נוסף על תסדיר ה"Aiken" format</a></p>
</ul>

<p><b>מילה חסרה</b></p>
<ul>
<p>תסדיר זה תומך רק בשאלות אמריקאיות. כל תשובה מופרדת על ידי טילדה (~), ולתשובה הנכונה מוספת תחילית של סימן שווה (=). הנה דוגמא:</p>

<blockquote>מהרגע שאנו מתחילים לחקור את חלקי גופנו כתינוקות, אנו הופכים לתלמידים של {=אנטומיה ופיזיולוגיה ~מדע ~רפלקסולוגיה ~ניסוי}, ובמובן מסויים אנו נישארים תלמידים לאורך כל החיים.
</blockquote>

<p align="right"><a href="help.php?file=formatmissingword.html&module=quiz">מידע נוסף על התסדיר "מילה חסרה"</a></p>
</ul>

<p><b>AON</b></p>
<ul>
<p>תסדיר זה זהה לתסדיר "מילה חסרה", מלבד מה שקורה לאחר ייבוא השאלות. אז, כל שאלות התשובות הקצרות הופכות, ארבע בכל פעם, לשאלות התאמה.
</p>
<p>בנוסף, בזמן הייבוא, התשובות לשאלות האמריקאיות מעורבבות בינן לבין עצמן (באופן רנדומלי).
</p>
<p>תסדיר זה נקרא אחר ארגון שמימן פיתוח של תכונות בחנים רבות.
</p>
</ul>

<p><b>Blackboard</b></p>
<ul>
<p>מודול זה יכול לייבא שאלות שנשמרו בתסדיר הייצוא של Blackboard. הוא מסתמך על כך שפונקציות XML יעברו קומפילציה לתוך הPHP שלכם.
</p>

<p align="right"><a href="help.php?file=formatblackboard.html&module=quiz">מידע נוסף על תסדיר "Blackboard" </a></p>
</ul>

<p><b>Course Test Manager (מנהל מבחני הקורס)</b></p>
<ul>
<p> מודול זה יכול ליבא שאלות שנשמרו במאגר (בנק) המבחנים של Course Test Manager (מנהל מבחני הקורס). לפי שרת האינטרנט עליו רץ מוודל (Windows או Linux) הוא מסתמך על דרכי גישה שונות למאגר המבחנים, שנמצא בתוך בסיס נתונים של Microsoft Access.</p>
<p>על Windows הוא מאפשר לכם להעלות את בסיס הנתונים אליו נכנסתם בדיוק כמו כל נתוניו של קובץ מיובא אחר.
</p>
<p>על Linux, עליכם להגדיר מכונת windows על אותה הרשת בעלת אותו בסיס הנתונים של Course Test Manager(מנהל מבחני הקורס), ותוכנה שנקראת ODBC Socket Server (קישור פתוח למאגרי נתונים, תקן של מיקרוסופט המאפשר גישה למאגרי נתונים מכל יישום ודרך כל מערכת ניהול נתונים של המאגר) שעושה שימוש בXML על מנת להעביר נתונים למוודל על השרת של Linux.
</p>

<p>אנא קיראו את קובץ העזרה המלא שמופיע למטה, לפני שאתם משתמשים במחלקת ייבוא זו.</p>

<p align="right"><a href="help.php?file=formatctm.html&module=quiz">מידע נוסף על תסדיר ה"CTM" </a></p>
</ul>

<p><b>מותאם אישית</b></p>
<ul>
<p>אם יש לכם תסדיר משלכם שאתם צריכים לייבא, אתם יכולים ליישם אותו בעצמכם על ידי עריכתquiz/format/custom.php.
</p>

<p>כמות הקוד החדש הנדרשת היא די קטנה - מספיקה בדיוק כדי לנתח שאלה יחידה מתוך טקסט נתון.
</p>

<p align="right"><a href="help.php?file=formatcustom.html&module=quiz">מידע נוסף על תסדיר "בהתאמה אישית"</a></p>
</ul>

<p>תסדירים נוספים עתידים לבוא, והם כוללים WebCT, IMS QTI, וכל דבר אחר שמשתמשי מוודל יכולים לתרום!
 </p>';
$string['insertedpage'] = 'עמוד מושתל';
$string['invalidfile'] = 'קובץ לא חוקי';
$string['invalidid'] = 'לא הועברו  מספרי זיהוי הרכיב של הקורס או מספרי זיהוי של השיעור';
$string['invalidlessonid'] = 'קוד השיעור איננו נכון';
$string['invalidpageid'] = 'קוד עמוד איננו תקין';
$string['jump'] = 'מעבר';
$string['jumps'] = 'מעברים';
$string['jumps_help'] = '<p align="center"><b>קישור ה"מעבר ל"</b></p>

<p>לכל תשובה (לשאלה) או תיאור (לעמודי הסתעפויות) מחובר קישור \'מעבר ל\'. כאשר התשובה נבחרה, תגובת התשובה מוצגת לסטודנט. לאחר מכן, הסטודנט נשלח לעמוד שנקבע בקישור ה\'מעבר ל\'. הקישור יכול להיות יחסי או מוחלט. קישורים יחסיים הם  <b>העמוד הזה</b> ו<b>העמוד הבא</b> .<b>העמוד הזה</b> משמעותו שהסטודנט רואה שוב את העמוד הנוכחי. <b>העמוד הבא</b> מראה את העמוד הבא העוקב אחר העמוד הזה בסדר הלוגי של העמודים. קישור מוחלט (לעמוד) נקבע על ידי בחירה ב<b>כותרת</b> של העמוד.</p>

<p>שימו לב שקישור \'מעבר ל\' <b>עמוד הבא</b> (קישור יחסי), יכול להפנות לעמוד שונה לאחר שהעמודים שינו מקום. זאת לעומת קישור \'מעבר ל\' שמשתמש ב<b>כותרות</b> של עמודים, ולכן תמיד יראו את אותו העמוד גם לאחר שהעמודים עברו מקום.
</p>
<p>מעברי עמוד מיוחדים</p>
<p>שאלת "unseen" (קטע טקסט שלא נלמד) בתוך הסתעפות</p>
<p>אפשרות זו תקשר לשאלת "unseen" שנבחרה באופן שרירותי (על ידי הסטודנט בניסיון זה) בין טבלת הסתעפות זו וסוף השיעור או \'סוף ההסתעפות\' הבא.
</p>

<p>שאלה שרירותית בתוך הסתעפות</p>
<p>אפשרות זו תקשר לשאלה שנבחרה באופן שרירותי בין טבלת ההסתעפות הנוכחית וסוף השיעור, או \'סוף ההסתעפות\' הבא.
אם הסטודנט כבר ראה את השאלה ו(מספר) הניסיונות גדול מ-1, תהיה לו אפשרות נוספת להרוויח את הנקודות של השאלה ההיא. אם (מספר) הניסיונות נקבע ל-1, אז שאלה זו תושמט, ובמקומה תוצג שאלה שרירותית אחרת.
</p>

<p>טבלת הסתעפות שרירותית</p>
<p>אפשרות זו תציג באופן שרירותי טבלת הסתעפות שנמצאת בין טבלת ההסתעפות הנוכחית וסוף השיעור, או \'סוף ההסתעפות\' הבא.
</p>';
$string['jumpsto'] = 'מעברים ל-<em>{$a}</em>';
$string['leftduringtimed'] = 'עזבת באמצע שיעור מתוזמן.<br />אנא לחץ על \'המשך\' בשביל להתחיל מחדש את השיעור.';
$string['leftduringtimednoretake'] = 'עזבת באמצע שיעור מתוזמן <br />ואינך מורשה לחזור עליו או להמשיך אותו.';
$string['leftduringtimedsession'] = 'עזבת במסגרת שיעור מתוזמן.';
$string['lesson:addinstance'] = 'הוספת פעילות שיעור חדשה';
$string['lessonattempted'] = 'נסיון לשיעור';
$string['lessonclosed'] = 'שיעור זה נסגר ב- {$a}.';
$string['lessoncloses'] = 'השיעור נסגר';
$string['lessoncloseson'] = 'שיעור נסגר ב {$a}';
$string['lesson:edit'] = 'עריכת פעילות שיעור';
$string['lessonformating'] = 'עיצוב השיעור';
$string['lesson:manage'] = 'ניהול פעילות שיעור';
$string['lessonmenu'] = 'תפריט השיעור';
$string['lessonnotready'] = 'השיעור לא מוכן שיתחילו בו. אנא צור קשר עם ה-{$a} שלך.';
$string['lessonnotready2'] = 'שיעור זה עדיין לא מוכן';
$string['lessonopen'] = 'השיעור שלך ייפתח ב-{$a}.';
$string['lessonopens'] = 'השיעור נפתח.';
$string['lessonpagelinkingbroken'] = 'העמוד הראשון לא נמצא. הקישורים שבין עמודי השיעור כנראה נשברו. אנא צור קשר עם מנהל.';
$string['lessonstats'] = 'הנתונים הסטטיסטיים של השיעורים.';
$string['linkedmedia'] = 'מדיה מקושרת';
$string['loginfail'] = 'ההתחברות נכשלה, אנא נסה שנית.....';
$string['lowscore'] = 'תוצאה נמוכה.';
$string['lowtime'] = 'זמן נמוך';
$string['manualgrading'] = 'בדיקה ומתן ציון למאמרים';
$string['matchesanswer'] = 'התאמה עם התשובה';
$string['matching'] = 'התאמה';
$string['matchingpair'] = 'נמצא הזוג {$a}';
$string['maxgrade'] = 'ציון מירבי';
$string['maxgrade_help'] = '<p align="center"><b>הציון של השיעור</b></p>

<p>ערך זה קובע מהו הציון המירבי שניתן להעניק בשיעור זה, כאשר הטווח נע בין 0 ל100%. את ערך זה ניתן לשנות בכל עת במהלך השיעור. לכל שינוי יש השפעה מיידית על עמוד הציונים ועל הציונים שמוצגים בפני הסטודנטים ברשימות השונות. אם הערך נקבע כ-0, אז השיעור לא יופיע באף אחד מעמודי הציונים.
</p>';
$string['maxhighscores'] = 'מספר התוצאות הגבוהות המוצגות';
$string['maximumnumberofanswersbranches'] = 'מספר מירבי של תשובות או הסתעפויות';
$string['maximumnumberofanswersbranches_help'] = '<p align="center"><b>המספר המירבי של תשובות בשיעור</b></p>

<p>ערך זה קובע את מספר התשובות המירבי בהן יכול המורה להשתמש. ערך ברירת המחדל הוא 4. אם השיעור עושה שימוש בלעדי ב, נגיד, שאלות נכון/לא נכון לכל אורכו, אז הגיוני לקבוע את הערך הזה ל-2.
</p>

<p>משתנה זה קובע גם כן את המספר המירבי של הסתעפויות בהן ניתן להשתמש בעמוד תוכן מסתעף.
</p>

<p>את המבנה הזה ניתן לשנות בביטחה בכל שיעור בעל תוכן קיים. למעשה, במקרה ותרצו להוסיף שאלה מרובת אפשרויות או דף תוכן מסתעף ארוך, אתם תהיו חייבים לשנות את הפרמטר הזה. לאחר שהוספתם את השאלה (החריגה) או את טבלת ההסתעפויות (BranchTable), אתם יכולים להנמיך את הערך הזה למשהו מעט יותר "תקני".

</p>';
$string['maximumnumberofattempts'] = 'מספר מירבי של נסיונות';
$string['maximumnumberofattempts_help'] = 'הגשה זו מציינת את המספר המירבי של נסיונות המאופשרות עבור כל שאלה.
במידה והתשובה שגויה שוב ושוב, כשהערך המירבי מגיע, העבוד הבא של השיעור יופיע.';
$string['maximumnumberofattemptsreached'] = 'הושג המספר המירבי של נסיונות - עובר לעמוד הבא';
$string['maxtime'] = 'הגבלת זמן (דקות)';
$string['maxtimewarning'] = 'יש לך {$a} דקה(ות) כדי לסיים את השיעור';
$string['mediaclose'] = 'הצגת כפתור \'סגור\'';
$string['mediafile'] = '\'חלון קופץ\' לקובץ או עמוד ברשת';
$string['mediafile_help'] = '<p align="center"><b>קובץ או עמוד רשת \'קופץ\'</b></p>

<p>אפשרות זו תיצור חלון \'קופץ\' בתחילתו של השיעור שיוביל לקובץ (לדוגמא: קובץ mp3) או לעמוד ברשת.
בנוסף לכך, על כל עמוד של השיעור יופיע קישור שפותח מחדש את החלון ה\'קופץ\', במידה ויש בכך צורך.
</p>

<p>לבחירתכם, ניתן להוסיף כפתור "סגור חלון" בתחתית החלון ה\'קופץ\'. בנוסף, ניתן לקבוע את רוחב ואורך החלון.</p>

<p>אפשרות זו תומכת בסוגי הקבצים המשובצים הבאים:
    <ul>
        <li>MP3</li>
        <li>Media Player</li>
        <li>Quicktime</li>
        <li>Realmedia</li>
        <li>HTML</li>
        <li>Plain Text (טקסט רגיל)</li>
        <li>GIF</li>
        <li>JPEG</li>
        <li>PNG</li>
    </ul>
כברירת מחדל, כל סוגי הקבצים האחרים יופיעו כקישור להורדת הקובץ.
</p>';
$string['mediafilepopup'] = 'לחץ כאן על מנת לראות את קובץ המדיה של השיעור.';
$string['mediaheight'] = 'גובה החלון הקופץ';
$string['mediawidth'] = 'רוחב החלון הקופץ';
$string['messageprovider:graded_essay'] = 'הודעת מתן הציון למאמר';
$string['minimumnumberofquestions'] = 'מספר מיזערי של שאלות';
$string['minimumnumberofquestions_help'] = '<p align="center"><b>מספר השאלות המינמלי בשיעור</b></p>

<p> לרוב רצוי שהמורה יקבע את הפרמטר הזה כשהשיעור מכיל דף תוכן מסתעף אחת או יותר. ערך זה קובע את (גבול) מינמום השאלות שנראות בזמן חישוב הציון. הוא <b>לא</b> כופה על הסטודנטים לענות על מספר זה של שאלות במהלך השיעור.</p>

<p>לדוגמא, אם תקבעו את הפרמטר הזה כ 20, אתם תבטיחו שהציונים ייתנו כאילו הסטודנטים ראו <b>לפחות</b> מספר זהה של שאלות (20). בואו ניקח לדוגמא את המיקרה הבא, בוא סטודנט מסתכל רק על הסתעפות אחת בשיעור. בהסתעפות זו יש, למשל, חמישה עמודים, והסטודנט עונה על כל השאלות המשוייכות אליהן בצורה נכונה. לאחר מכן, הסטודנט בוחר לסיים את השיעור (בהנחה שהאפשרות הזו קיימת בדף תוכן מסתעף "ברמה הגבוהה ביותר", הנחה הגיונית למדי). אם הפרמטר הזה נישאר ללא הגדרה, אז הציון שהסטודנט הנל יקבל יהיה 5 מתוך 5, כלומר 100%.
לעומת זאת, אם הפרמטר הזה נקבע ל 20, הציון של הסטודנט הנל ירד ל5 מתוך 20, כלומר 25%. ובמקרה נוסף, של סטודנט אחר, שעבר על כל ההסתעפויות, וראה, למשל, 25 עמודים בהם הוא ענה על כל השאלות, מלבד שתיים, בצורה נכונה, הציון שלו יהיה 23 מתוך 25, כלומר 92%. </p>

<p>אם אתם משתמשים בפרמטר הזה, בעמוד הראשון של השיעור עליכם לכתוב משהו כמו:
</p>

<p><blockquote>בשיעור זה מצפים מכם לנסות ולענות על לפחות X שאלות. אתם יכולים לנסות ולענות על יותר שאלות אם אתם רוצים בכך. לעומת זאת, אם תנסו לפתור פחות מX שאלות, הציון שלכם עדיין יחושב כאילו ניסיתם לפתור X שאלות.
</blockquote></p>

<p>כמובן, שבקטע לעיל ה"X" מוחלף על ידי הערך הממשי שניתן לפרמטר זה.
</p>

<p>כשהפרמטר הזה הוגדר, מודיעים לסטודנטים על כמה שאלות הם כבר ניסו לענות ועל כמה שאלות מצפים מהם לנסות ולענות.</p>';
$string['missingname'] = 'אנא הכנס כינוי';
$string['modattempts'] = 'אפשר סקירה נוספת של הסטודנט';
$string['modattempts_help'] = '<p align="center"><b>אפשר לסטודנטים לשקול שוב</b></p>

<p>אפשרות זו תאפשר לסטודנטים לנווט בחזרה דרך השיעור כדי לשנות את התשובות שלהם.</p>';
$string['modattemptsnoteacher'] = 'סקירת סטודנטים עובדת רק בשביל סטודנטים.';
$string['modulename'] = 'שיעור';
$string['modulename_help'] = 'רכיב הפעילות "שיעור" (Lesson) מאפשר למורה להציג תוכן בצורה מעניינת וגמישה. הוא מורכב ממספר עמודים. כשבדרך כלל, כל עמוד מסתיים בשאלה בעלת מספר תשובות אפשריות. לפי התשובה שהסטודנט עונה הוא: ממשיך לעמוד הבא או נלקח חזרה לעמוד הקודם.

ניווט לאורך פעילות השיעור יכול להיות ישר ופשוט (עמוד אחר עמוד) או מורכב, הדבר תלוי ברובו על מבנה החומר המוצג.

ניתן לתת ציון על השיעור, וכך הציון גם יופיע בגליון הציונים.

ניתן להשתמש בפעילות שיעור עבור:

* לימוד עצמי של נושא מסויים.

* לימוד נושא חדש עבור תרחישים וסימולציות / או קבלת החלטות תרגילים

* לקבלת גרסה שונה, עם קבוצות שונות של שאלות לבחינות תלוי תשובות שנתנו לשאלות הראשוניות.';
$string['modulenameplural'] = 'שיעורים';
$string['move'] = 'הזזת עמוד';
$string['movedpage'] = 'העמוד הועבר';
$string['movepagehere'] = 'העבר את העמוד לכאן';
$string['movepagenamed'] = 'העברת עמוד: {$a}';
$string['moving'] = 'מעביר את העמוד: {$a}';
$string['multianswer'] = 'תשובות מרובות';
$string['multianswer_help'] = 'סמן את תיבת הסימון אם יש יותר מתשובה אחת נכונה.';
$string['multichoice'] = 'בחירה מרובה';
$string['multipleanswer'] = 'תשובות מרובות';
$string['nameapproved'] = 'שם מאושר';
$string['namereject'] = 'סליחה, השם שלך נדחה על ידי המסנן.<br />אנא נסה שם אחר.';
$string['new'] = 'חדש';
$string['nextpage'] = 'העמוד הבא';
$string['noanswer'] = 'לא ניתנה תשובה';
$string['noattemptrecordsfound'] = 'לא נימצאו רשומות של ניסיונות: לא ניתן ציון.';
$string['nobranchtablefound'] = 'לא נמצא עמוד תוכן מסתעף';
$string['nocommentyet'] = 'עדיין אין הערות.';
$string['nocoursemods'] = 'לא נמצאו פעילויות';
$string['nocredit'] = 'אין נקודות.';
$string['nodeadline'] = 'אין מועד סופי';
$string['noessayquestionsfound'] = 'לא נמצאו שאלות מאמר בשיעור זה.';
$string['nohighscores'] = 'אין תוצאות גבוהות.';
$string['nolessonattempts'] = 'לא נעשו נסיונות מענה לשיעור זה.';
$string['nooneansweredcorrectly'] = 'אף אחד לא ענה נכונה.';
$string['nooneansweredthisquestion'] = 'שאלה זו לא נענתה על ידי אף אחד.';
$string['noonecheckedthis'] = 'אף אחד לא סימן את זה.';
$string['nooneenteredthis'] = 'אף אחד לא הכניס את זה.';
$string['noonehasanswered'] = 'אף אחד לא ענה עדיין על שאלת מאמר.';
$string['noretake'] = 'אתה לא מורשה לחזור על שיעור זה.';
$string['normal'] = 'עקוב אחר נתיב השיעור';
$string['notcompleted'] = 'לא גמור';
$string['notdefined'] = 'לא מוגדר';
$string['notenoughsubquestions'] = 'לא הוגדרו מספיק תת-שאלות!<br />האם לחזור ולתקן את השאלה הזו?';
$string['nothighscore'] = 'עדיין לא הצלחת להיכנס לרשימת {$a} התוצאות הכי גבוהות.';
$string['notitle'] = 'אין כותרת';
$string['numberofcorrectanswers'] = 'מספר התשובות הנכונות: {$a}';
$string['numberofcorrectmatches'] = 'מספר ההתאמות הנכונות: {$a}';
$string['numberofpagestoshow'] = 'מספר העמודים (שקופיות) שיש להראות';
$string['numberofpagestoshow_help'] = '<p>שימוש במשתנה זה אך ורק בשיעורים עם סוג שקופית פלאש. ערך ברירת המחדל הוא 0 כך שכל העמודיםשקופיות גלויים בשיעור. קביעת משתנה זה לערך הגדול מאפס יציג את מספר העמודים כמספר הנבחר. לאחר שמספר עמודיםשקופיות  יוצגו סוף השיעור יושג כאשר כל העמודים יופיעו.</p>

<p>אם משתנה זה נקבע לערך הגדול ממספר העמודים בשיעור, סוף השיעור יושג כאשר כל העמודים יופיעו.</p>';
$string['numberofpagesviewed'] = 'מספר השאלות שנענו: {$a}';
$string['numberofpagesviewednotice'] = 'מספר התשובות שנענו: {$a->nquestions}; (עליך לענות על {$a->minquestions} שאלות לפחות.)';
$string['numerical'] = 'מספרי';
$string['ongoing'] = 'הצגת התוצאה המצטברת';
$string['ongoingcustom'] = 'הרווחת {$a->score} נקודה(ות) מתוך {$a->currenthigh} נקודה(ות) עד כה.';
$string['ongoing_help'] = '<p align="center"><b>תוצאה מצטברת</b></p>

<p>כאשר אפשרות זו מופעלת, כל עמוד יציג את הנקודות שהסטודנט צבר עד כה, מתוך הסכום הכולל האפשרי (עד כה). לדוגמא: הסטודנט ענה נכונה על ארבע שאלות, שכל אחת מהן מזכה אותו ב5 נקודות, וטעה בשאלה אחת. התוצאה המצטברת תקליד שהסטודנט הרוויח עד כה 15/20 נקודות.
</p>';
$string['ongoingnormal'] = 'ענית על {$a->correct} נכונה מתוך {$a->viewed} ניסיונות.';
$string['onpostperpage'] = 'פרסום אחד בלבד לכל ציון';
$string['options'] = 'אפשרויות';
$string['or'] = 'או';
$string['ordered'] = 'הוזמן';
$string['other'] = 'אחר';
$string['outof'] = 'מתוך {$a}';
$string['overview'] = 'סקירה כללית';
$string['overview_help'] = '<p align="center"><b>סקירה כללית</b></p>

<ol>
    <li>שיעור מורכב ממספר <b>עמודים</b>, ובנוסף מ<b>דפי תוכן מסתעפים
    </b>,לפי בחירתכם.</li>
    <li>עמוד מכיל בתוכו <b>תוכן</b> כלשהו, ומסתיים, על פי רוב, ב<b>שאלה</b>.
        מכאן המונח, <b>עמוד שאלה</b>.</li>
    <li>לשאלות מאמר, אין תשובה, ישנם רק תוצאה, משוב ו\'מעבר עמוד\' עמוד.</li>
    <li>לכל תשובה יכול להיות קטע טקסט קצר שמוצג אם וכאשר התשובה נבחרת. קטע הטקסט נקרא <b>תגובה</b>.</li>
    <li> - בנוסף לכך, לכל תשובה מותאמת <b>\'מעבר עמוד\'</b>. ה\'מעבר עמוד\' יכולה להיות יחסית - לעמוד הזה, לעמוד הבא - או מוחלטת - מציינת כל אחד מהעמודים בשיעור או את סוף השיעור. </li>
    <li>לפי ברירת המחדל, התשובה הראשונה \'קופצת\' ל<b>עמוד הבא</b> בשיעור. התשובות שעוקבות אחריה, \'קופצות\' לאותו עמוד שבו הן נמצאות. כלומר, אם הסטודנט לא בוחר בתשובה הראשונה, הוא כל הזמן חוזר לאותו העמוד בשיעור. אם כבר יצרתם אשכול (יחידה לאחסון נתונים) בעל \'סוף אשכול\', והשאלה נמצאת בתוכו, אתם יכולים לבחור בנוסף למעבר עמוד לשאלת "אנסין" בתוך האשכול. אפשרות זו לא תוצג אם אתם לא נמצאים בתוך אשכול. אתם יכולים להקיף מערכת של שאלות באשכול וב\'סוף אשכול\' בכל עת.</li>
    <li>העמוד הבא נקבע על ידי <b>הסדר הלוגי</b> של השיעור. זהו סדר העמודים כפי שהמורה רואה אותם. את הסדר הזה ניתן לשנות על ידי הזזה של עמודים בתוך השיעור.</li>
    <li>לשיעור ישנו גם <b>סדר ניווט</b>. זהו סדר העמודים, כפי שהסטודנטים רואים אותם.
        סדר זה נקבע על ידי ה\'מעברי עמוד\' שמוגדרות לשאלות פרטניות, והוא יכול להיות שונה ביותר מהסדר הלוגי, אלא אם כן, <i>לא</i> משנים את ערכי ה\'מעברי עמוד\' ומשאירים אותם לפי ערכי ברירת המחדל (השניים קשורים באדיקות אחד לשני). בידי המורה האפשרות לבדוק את סדר הניווט.
    </li>
    <li>לרוב, כאשר התשובות מוצגות בפני הסטודנטים, הן מעורבבות. כלומר, התשובה הראשונה בתצוגה של המורה, לאוו דווקא תהיה התשובה שתופיע ראשונה ברשימה שמוצגת לסטודנטים. (יתרה מזאת, רוב הסיכויים שאותו סט של שאלות יופיע בסדר אחר בכל פעם שהוא מוצג). יוצאות מן הכלל הן מערכות של תשובות לשאלות התאמה, כאן, התשובות מופיעות באותו הסדר שהמורה הכניס אותן.
    </li>
    <li>מספר התשובות יכול להישתנות מעמוד לעמוד. לדוגמא, מותר שעמודים מסויימים יסתיימו בשאלת נכוןלא נכון, בזמן שאחרים יסתיימו בשאלות בעלות תשובה אחת נכונה, ובו נאמר, שלוש הסחות דעת (שאלות אמריקאיות).</li>
    <li>ניתן להגדיר עמוד ללא תשובות כלל. בפני הסטודנטים מוצג קישור <b>המשך</b> במקום סט של תשובות.
    </li>
    <li>אם לא הפעלתם שיטה להשגת נקודות מותאמת אישית: למטרת נתינת ציון לשיעורים, תשובות <b>נכונות</b> הן התשובות ש\'קופצות\' לעמוד שנמצא <i>למטה</i> מהעמוד הנוכחי בסדר הלוגי.
        תשובות <b>לא נכונות</b>, הן אלו ש\'קופצות\' או, לאותו העמוד או, לעמוד שנמצא <i>למעלה</i> מהעמוד הנוכחי בסדר הלוגי. כך שאם אתם <i>לא</i> משנים את ה\'מעברי עמוד\', התשובה הראשונה היא התשובה הנכונה, ושאר התשובות הן תשובות לא נכונות.
        <br /><br />
        אם הפעלתם שיטה להשגת נקודות בהתאמה אישית: מתן ציון לתשובה נקבע לפי ערך הנקודות של התשובה, כאשר כלל הנקודות שהורווחו משמש כמקטע מכלל ערך הנקודות של השיעור, עד ל100%.
    </li>
    <li>יכול להיות שלשאלות יהיו מספר תשובות נכונות (ולא רק תשובה נכונה אחת). לדוגמא, אם ישנן שתי תשובות ש\'קופצות\' לעמוד הבא, אז כל אחת מהן נחשבת כתשובה נכונה. (למרות שעמוד היעד של שתי התשובות הוא זהה, התגובות שמוצגות עבור שתי התשובות בפני הסטודנטים בדרך לעמוד היעד יכולות להיות שונות.)
    <li> בתצוגת השיעור של המורה, התשובות הנכונות מופיעות עם תווית \'תשובה\', מודגשת בקו תחתון.
    </li>
    <li><b>טבלאות הסתעפות</b> הינן פשוט עמודים בעלי מערכת של קישורים לעמודים אחרים בשיעור. למשל הגיוני ששיעור יתחיל בטבלת הסתעפויות שמתנהגת כמו <b>תוכן עניינים</b>.
    </li>
    <li>לכל קישור בטבלת ההסתעפויות יש שני מרכיבים, תיאור וכותרת של העמוד אליו הוא \'קופץ\'.
    </li>
    <li>טבלת הסתעפויות מחלקת ביעילות את השיעור למספר <b>הסתעפויות</b> (או חלקים).
        על כל הסתעפות להכיל מספר עמודים (שכולם, כנראה, קשורים לאותו הנושא). סוף ההסתעפות לרוב מסומנת על ידי עמוד <b>סוף הסתעפות</b>. זהו עמוד מיוחד, שלפי ברירת מחדל, מחזיר את הסטודנטים חזרה לטבלת ההסתעפויות שקודמת לו.
        (אם יש בכך צורך, ניתן לשנות את \'מעבר עמוד\' ה"חזור" בסוף ההסתעפות, וזאת על ידי עריכת העמוד.)
    </li>
    <li>בשיעור יכולה להיות יותר מטבלת הסתעפויות אחת. לדוגמא, ניתן לבנות שיעור כך שנקודות מומחיות ימוקמו כתת-הסתעפויות בתוך ענפי הנושא העיקריים.

    </li>
    <li>זה חשוב לספק לסטודנטים את האמצעים לסיים את השיעור. את זה ניתן לעשות על ידי הוספת קישור "סיים את השיעור" בטבלת ההסתעפויות העיקרית. קישור זה \'קופץ\' לעמוד (הדמיוני) <b>סוף השיעור</b>.
        אפשרות אחרת היא שההסתעפות האחרונה בשיעור (כאן המילה "אחרון" משמשת במובן של הסדר הלוגי),
        פשוט תמשיך לסוף השיעור, כלומר, השיעור <i>לא</i> יסתיים על ידי עמוד \'סוף הסתעפות\'. </li>

    <li>כאשר לא מופעלת שיטה להשגת נקודות בהתאמה אישית, וכאשר בשיעור יש טבלת הסתעפויות אחת או יותר, מומלץ לקבוע את פרמטר "מספר השאלות המינמלי" לערך הגיוני כלשהוא. פרמטר זה קובע גבול נמוך יותר למספר העמודים שמוצגים בזמן חישוב הציון. ללא הפרמטר הזה, סטודנט יכול לבקר בהסתעפות אחת בלבד בשיעור, לענות על כל השאלות נכונה, לעזוב את השיעור ועדיין לקבל עליו את הציון המירבי.
        <br /><br />
        כאשר השיטה להשגת נקודות בהתאמה אישית מופעלת, לסטודנט ניתן ציון על בסיס היות מספר הנקודות שהוא צבר אחוז מתוך כלל הנקודות של השיעור. </li>
    <li>בנוסף לכך, כאשר לא מופעלת שיטה להשגת נקודות בהתאמה אישית, ויש טבלת הסתעפויות, בידי הסטודנט האפשרות לחזור ולבקר באותה הסתעפות יותר מפעם אחת. אך הציון מחושב על ידי מספר השאלות <i>הייחודיות</i> שנענו.
        כך נתינה חוזרת ונשנית של תשובות לאותן השאלות, <i>לא</i> מעלה את הציון. (למעשה, ההפך הוא הנכון, היא מורידה את הציון מכיוון שמספר העמודים שנראו על ידי הסטודנט משמש כמכנה כשמחשבים את הציונים, והספירה כוללת בחובה עמודים שחוזרים על עצמם). כדי לתת לסטודנטים מושג כללי על ההתקדמות שלהם בשיעור, מציגים בפניהם את הפרטים הבאים, בכל עמוד טבלת הסתעפויות: על כמה שאלות הם ענו נכונה, מספר העמודים שהם ראו, והציון הנוכחי שלהם.
        <br /> <br />
        כאשר השיטה להשגת נקודות בהתאמה אישית מופעלת, הסטודנט יכול לחזור לשאלה לאחר שהוא כבר ראה אותה אם נתיב הניווט מאפשר זאת, וכך לזכות בנקודות של השאלה הזאת, אם (מספר ה) \'נסיונות\' גדול מ 1. כדי למנוע את זה, קבעו את (מספר) ה\'נסיונות\' ל 1. </li>
    <li>ל<b>סוף השיעור</b> ניתן להגיע על ידי \'מעבר עמוד\' ישירה למיקום שלו, או על ידי \'מעבר עמוד\' מהעמוד האחרון (הלוגי) של השיעור, לעמוד הבא אחריו. כאשר לא מופעלת השיטה להשגת נקודות בהתאמה אישית, כאשר מגיעים לסוף השיעור, הסטודנט מקבל הודעת איחולים ונגלה בפניו הציון שלו. הציון מורכב מ: (מספר השאלות עליהן הוא ענה נכונה  מספר העמודים שהוא ראה) * הציון של השיעור.
        כאשר השיטה להשגת נקודות בהתאמה אישית מופעלת, הציון מורכב מהנקודות שהסטודנט הרוויח, כ% (אחוז) מתוך כלל הנקודות. (לדוגמא, הסטודנט הרוויח 3 נקודות בשיעור של 3 נקודות = 100% של 3 נקודות).</li>
    <li>אם הסטודנט מחליט לעזוב את השיעור באמצע, ולכן הוא <i>לא</i> מגיע לסוף השיעור, כאשר הוא מחליט להיכנס בחזרה לשיעור ניתנת לו אפשרות הבחירה הבאה: הוא יכול להתחיל את השיעור מההתחלה, או שהוא יכול להתחיל את השיעור מהשאלה האחרונה עליה הוא ענה נכונה.</li>
    <li>בשיעור שמאפשר נסיונות חוזרים, המורה יכול לבחור בין אם להשתמש בציון הטוב ביותר או בממוצא של הציונים כציון ה"סופי" של השיעור. </li>
    <li>עמודי אשכול: אשכול מייצג סט של שאלות, שמתוכן ניתן לבחור שאלה אחת או יותר באופן שרירותי. על מנת לקבל את התוצאות הטובות ביותר, את האשכולים יש לסיים עם עמוד \'סוף אשכול\' (אחרת הם מתייחסים לעמוד סוף השיעור כסוף האשכול). שאלות מתוך האשכול ניתן לבחור באופן שרירותי על ידי שימוש ב"שאלה שרירותית מתוך אשכול" כ\'מעבר עמוד\'. שאלות מתוך האשכול ניתן לקשר לסוף האשכול על מנת לצאת מהאשכול, או ניתן לקשר אותם ל\'מעבר עמוד\' לשאלת "אנסין" בתוך הקלסר, או לכל עמוד אחר בשיעור. דבר שמאפשר יצירה של תרחישים עם מרכיב שרירותי באמצעות פרק השיעור.
    </li>
</ol>';
$string['page'] = 'עמוד: {$a}';
$string['pageanswers'] = 'תשובות בעמוד';
$string['pagecontents'] = 'תכולת העמוד';
$string['page-mod-lesson-edit'] = 'עריכת עמוד השיעור';
$string['page-mod-lesson-view'] = 'צפיה ותצוגה של עמוד השיעור';
$string['page-mod-lesson-x'] = 'עמוד שיעור כלשהו';
$string['pageresponses'] = 'מענים בעמוד';
$string['pages'] = 'עמודים';
$string['pagetitle'] = 'כותרת העמוד';
$string['password'] = 'סיסמה';
$string['passwordprotectedlesson'] = '{$a} הינו שיעור שמוגן על ידי סיסמה.';
$string['pleasecheckoneanswer'] = 'אנא סמן תשובה אחת';
$string['pleasecheckoneormoreanswers'] = 'אנא סמן תשובה אחת, או יותר.';
$string['pleaseenteryouranswerinthebox'] = 'אנא הקלד את התשובה שלך בקופסא.';
$string['pleasematchtheabovepairs'] = 'אנא התאם בין הזוגות שמופיעים לעיל.';
$string['pluginadministration'] = 'ניהול פעילות השיעור';
$string['pluginname'] = 'שיעור';
$string['pointsearned'] = 'נקודות שהורווחו';
$string['postprocesserror'] = 'שגיאה התרחשה בזמן post-processing!';
$string['postsuccess'] = 'פרסם את המצליחים';
$string['practice'] = 'תרגול';
$string['practice_help'] = '<p align="center"><b>שיעור לתרגול</b></p>

<p>שיעור לתרגול לא יופיע בגיליון הציונים.
</p>';
$string['preprocesserror'] = 'שגיאה התרחשה בזמן pre-processing!';
$string['prerequisitelesson'] = 'שיעור המהווה דרישת קדם';
$string['preview'] = 'תצוגה מקדימה';
$string['previewlesson'] = 'הצגה מוקדמת של {$a}';
$string['previewpagenamed'] = 'תצוגה מקדימה של עמוד: {$a}';
$string['previouspage'] = 'עמוד קודם';
$string['processerror'] = 'שגיאה התרחשה במהלך העיבוד';
$string['progressbar'] = 'סרגל התקדמות';
$string['progressbar_help'] = '<p align="center"><b>סרגל התקדמות</b></p>

<p>הצגת סרגל התקדמות בתחתית השיעור. כרגע, סרגל התקדמות זה מציג באופן הכי מדוייק את ההתקדמות הנעשית בשיעור הליניארי. </p>
<p>כדי לחשב איזה אחוז מהשיעור התלמיד כבר עשה, הסרגל מתייחס לטבלאות ההסתעפות ועמודי השאלות שנענו נכונה, כסימני התקדמות בשיעור.
במהלך חישוב המספר הכולל של עמודים בשיעור, אשכולים (יחידות לאחסון נתונים), ועמודים בעלי אשכולים נחשבים כעמוד אחד בלבד, בזמן שעמודי \'סוף אשכול\' ו\'סוף טבלת הסתעפות\' לא נספרים כלל. כל שאר העמודים נחשבים במספר הכולל של העמודים בשיעור.</p>
<p>שימו לב: הסגנונות שמוצעים בברירת המחדל לסרגל ההתקדמות הם לא מרשימים (; את כל הסגנונות (כלומר: צבעים, תמונות רקע, וכו\') בסרגל ההתקדמות, ניתן לשנות ב mod/lesson/styles.php.';
$string['progressbarteacherwarning'] = 'לא ניתן להציג סרגל התקדמות עבור {$a}';
$string['progressbarteacherwarning2'] = 'לא  תוכל לראות את סרגל ההתקדמות מפני שאתה יכול לערוך את שיעור זה';
$string['progresscompleted'] = '{$a}% מהשיעור הושלמו';
$string['qtype'] = 'סוג עמוד';
$string['question'] = 'שאלה';
$string['questionoption'] = 'שאלה';
$string['questiontype'] = 'סוג שאלה';
$string['randombranch'] = 'עמוד תוכן מסתעף שרירותי';
$string['randompageinbranch'] = 'שאלה שרירותית בתוך הסתעפות';
$string['rank'] = 'דרגה';
$string['rawgrade'] = 'ציון גולמי';
$string['receivedcredit'] = 'נקודות שהתקבלו';
$string['redisplaypage'] = 'רענון תצוגת תוכן העמוד';
$string['report'] = 'דוח';
$string['reports'] = 'דוחות';
$string['response'] = 'תגובה';
$string['retakesallowed'] = 'נסיונות חוזרים מאופשרים';
$string['retakesallowed_help'] = '<p align="center"><b>אפשר לסטודנטים לחזור על השיעור</b></p>

<p>הגדרה זו קובעת האם הסטודנטים יוכלו לחזור על השיעור יותר מפעם אחת, או פעם אחת בלבד.
המורה יכול להחליט שהשיעור מכיל תוכן שהסטודנטים צריכים להכיר לעומק. במקרה כזה, צריך לאפשר צפיה חוזרת בשיעור. אך במידה והחומר משמש יותר כמעין מבחן, לא צריך לאפשר חזרה על השיעור.
</p>

<p>כשלסטודנטים ניתנת האפשרות לחזור שנית על השיעור, ה<b>ציונים</b> שמוצגים בעמוד הציונים יכולים להיות או, הציון ה<b>ממוצע</b> של כל הניסיונות החוזרים שלהם, או הציון ה<b>טוב ביותר</b> שהם קיבלו עבור השיעור. הפרמטר הבא קובע באיזו משתי הדרכים החלופיות הללו יחושב הציון.
</p>

<p>שימו לב שב<b>ניתוח השאלות</b>תמיד נבחנות התשובות מהניסיונות הראשונים של הסטודנטים, התשובות מניסיונות חוזרים שבאים לאחר מכן, לא נחשבות.</p>

<p>לפי ברירת המחדל, אפשרות זו היא <b>לא</b>, כלומר הסטודנטים לא יכולים לחזור על השיעור.
    זה מצופה שאפשרות זו תכוון <b>כן</b> רק בנסיבות יוצאות דופן.</p>';
$string['returnto'] = 'חזרה ל:{$a}';
$string['returntocourse'] = 'חזרה לקורס';
$string['review'] = 'סקירה';
$string['reviewlesson'] = 'סקירת השיעור';
$string['reviewquestionback'] = 'כן, הייתי רוצה לנסות בשנית';
$string['reviewquestioncontinue'] = 'לא, אני רוצה להמשיך לשאלה הבאה';
$string['sanitycheckfailed'] = 'לא עבר את בדיקת שפיות הדעת: ניסיון זה נמחק.';
$string['savechanges'] = 'שמירת שינויים';
$string['savechangesandeol'] = 'שמירת כל השינויים והמשך לסוף השיעור.';
$string['savepage'] = 'שמירת העמוד';
$string['score'] = 'תוצאה';
$string['scores'] = 'תוצאות';
$string['secondpluswrong'] = 'לא בדיוק. תרצה לנסות שוב?';
$string['selectaqtype'] = 'יש לבחור את סוג השאלה אשר תוצג בסוף הדף (לשם התקדמות לדפים נוספים)';
$string['shortanswer'] = 'תשובה קצרה';
$string['showanunansweredpage'] = 'הצגת עמוד שלא נענה';
$string['showanunseenpage'] = 'הצגת עמוד אשר טרם נצפה';
$string['singleanswer'] = 'תשובה יחידה';
$string['skip'] = 'פסח על הניווט.';
$string['slideshow'] = 'מצגת שקופיות';
$string['slideshowbgcolor'] = 'צבע הרקע של מצגת השקופיות';
$string['slideshowheight'] = 'גובה מצגת השקופיות';
$string['slideshow_help'] = '<p align="center"><b>מצגת שקפים</b></p>

<p>אפשרות זו מאפשרת להציג את השיעור כמצגת בה הגובה והרוחב קבועים מראש, וצבע הרקע מותאם אישית.
אם תוכן העמוד עובר את גבול המצגת, יופיע סרגל גלילה לגובה או לרוחב (המסך) שמבוסס על CSS. שאלות \'ישברו\' את מצב המצגת, לפי ברירת מחדל רק העמודים (טבלאות הסתעפות) יוצגו כמצגת. כפתורים שמתוייגים לפי שפת ברירת המחדל כ"הלאה" ו"חזרה" יופיעו בקצה הימני ובקצה השמאלי של השקופית, במידה  ואפשרות זו נבחרת בעמוד. כפתורים אחרים ימוקמו יחדיו מתחת לאמצע השקופית.
</p>';
$string['slideshowwidth'] = 'רוחב מצגת השקופיות';
$string['startlesson'] = 'התחל את השיעור';
$string['studentattemptlesson'] = 'ניסיון מספר {$a->attempt}, של {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} שם';
$string['studentoneminwarning'] = 'אזהרה: יש לך דקה אחת או פחות כדי לסיים את השיעור.';
$string['studentresponse'] = 'התגובות של {$a}';
$string['submit'] = 'הגש';
$string['submitname'] = 'הגשת שם';
$string['teacherjumpwarning'] = 'שיעור זה משתמש באשכול־מעברים {$a->cluster} או במעברים {$a->unseen}. כחלופה, יעשה שימוש במעבר ל\'עמוד הבא\'. יש להתחבר כסטודנט על מנת לבחון את התנהגות מעבר העמודים לעיל.';
$string['teacherongoingwarning'] = 'תוצאה מצטברת מוצגת רק בפני הסטודנט. התחבר כסטודנט כדי לבחון את התוצאה המתמשכת.';
$string['teachertimerwarning'] = 'שעון העצר עובד רק לסטודנטים. התחבר כסטודנט כדי לבחון את שעון העצר.';
$string['thatsthecorrectanswer'] = 'זוהי התשובה הנכונה.';
$string['thatsthewronganswer'] = 'זוהי לא התשובה הנכונה.';
$string['thefollowingpagesjumptothispage'] = 'העמודים הבאים מנותבים לעמוד זה';
$string['thispage'] = 'עמוד זה';
$string['timeisup'] = 'הזמן חלף';
$string['timeremaining'] = 'הזמן שנשאר';
$string['timespenterror'] = 'עליך להעביר לפחות {$a} דקות בשיעור זה.';
$string['timespentminutes'] = 'הזמן שעבר (בדקות)';
$string['timetaken'] = 'זמן שנלקח';
$string['topscorestitle'] = '{$a} התוצאות הגבוהות ביותר.';
$string['true'] = 'נכון';
$string['truefalse'] = 'נכון/שגוי';
$string['unabledtosavefile'] = 'הקובץ שהעלאת לא ניתן לשמירה';
$string['unknownqtypesnotimported'] = 'לא היה ניתן לייבא{$a} שאלות עם סוגי שאלה שלא נתמכים 
';
$string['unseenpageinbranch'] = 'שאלת אנסין בתוך ההסתעפות';
$string['unsupportedqtype'] = 'סוג שאלה לא נתמך ({$a})!';
$string['updatedpage'] = 'עמוד מעודכן';
$string['updatefailed'] = 'עדכון נכשל';
$string['updatepagenamed'] = 'עדכון עמוד: {$a}';
$string['usemaximum'] = 'השתמש במקסימום';
$string['usemean'] = 'השתמש בממוצע';
$string['usepassword'] = 'שיעור המוגן על-ידי סיסמה';
$string['usepassword_help'] = '<p align="center"><b>שיעור המוגן על ידי סיסמא</b></p>

<p>אפשרות זו תיתן לסטודנט גישה לשיעור רק במידה והוא הקליד את הסיסמא.
</p>';
$string['viewgrades'] = 'ראה ציונים';
$string['viewhighscores'] = 'ראה את רשימת התוצאות הגבוהות';
$string['viewreports'] = 'ראה {$a->attempts} שהושלמו {$a->student} נסיונות.';
$string['viewreports2'] = 'צפה ב- {$a} נסיונות שהושלמו';
$string['welldone'] = 'כל הכבוד!';
$string['whatdofirst'] = 'לצורך אתחול השיעור, יש לבחור אחת מהאפשרויות הבאות:';
$string['wronganswerjump'] = 'העמוד שיוצג במצב של "תשובה לא נכונה"';
$string['wronganswerscore'] = 'תוצאה של תשובה לא נכונה.';
$string['wrongresponse'] = 'תגובה של תשובה לא נכונה.';
$string['xattempts'] = 'נסיונות';
$string['youhaveseen'] = 'כבר ראית יותר מעמוד אחד בשיעור זה.<br />האם תרצה להתחיל בעמוד האחרון שראית?';
$string['youmadehighscore'] = 'נכנסת לרשימת {$a} התוצאות הגבוהות ביותר.';
$string['youranswer'] = 'התשובה שלך';
$string['yourcurrentgradeis'] = 'הציון הנוכחי שלך הוא {$a}';
$string['yourcurrentgradeisoutof'] = 'הציון הנוכחי שלך הוא {$a->grade} מתוך {$a->total}.';
$string['youshouldview'] = 'על התשובה שלך להיות לפחות: {$a}';
