<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'he', branch 'MOODLE_28_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'הוספת הערה';
$string['addentry'] = 'הוספת מונח חדש';
$string['addingcomment'] = 'הוספת הערה';
$string['alias'] = 'מקלדת';
$string['aliases'] = 'מילות מפתח';
$string['aliases_help'] = '<p align="center"><b>מילות מפתח</b></p>

<p>ניתן לשייך לכל רשומה באגרון המונחים רשימה של מילות מפתח (או כינויים). </p>

<p><b>הכניסו כל כינוי על שורה חדשה</b> (שאינה מופרדת על ידי פסיקים).</p>

<p>המילים והביטויים שמשמשים ככינויים, יכולים לשמש כדרכים חלופיות להפנות לרשומה. לדוגמא, אם באגרון המונחים אתם משתמשים במסנן שיוצר קישורים באופן אוטומטי, אז (בנוסף לשם העיקרי של הרשומה) יעשה שימוש גם בכינויים, כשיוחלט איזה מילים לקשר לרשומה.

</p>';
$string['allcategories'] = 'כל הסיווגים';
$string['allentries'] = 'הכל';
$string['allowcomments'] = 'הוספת הערות למונח';
$string['allowcomments_help'] = '<p align="center"><b>אפשר לסטודנטים להעיר הערות על רשומות</b></p>

<p>ניתן לאפשר לסטודנטים להוסיף הערות לרשומות באגרון המונחים.</p>

<p>אתם יכולים להחליט בין אם להפעיל או למנוע את התכונה הזו.</p>

<p>המורים תמיד יכולים להוסיף הערות לרשומות שבאגרון המונחים.
</p>';
$string['allowduplicatedentries'] = 'מונחים כפולים';
$string['allowduplicatedentries_help'] = '<p align="center"><b>אפשר רשומות כפולות</b></p>

<p>אם תחליטו להפעיל את האפשרות הזו, אז ניתן יהיה להוסיף מספר רשומות שונות תחת אותו השם (מושג).
</p>';
$string['allowprintview'] = 'תצוגת הדפסה';
$string['allowprintview_help'] = 'כאשר זמין, מאפשר לסטודנטים לראות את גרסת ההדפסה של אגרון המונחים.
אתם יכולים לבחור אם להפעיל יכולת זו או למנוע אותה.
המורים תמיד יכולים להשתמש בגרסה להדפסה.';
$string['andmorenewentries'] = 'ו-{$a} ומעלה מונחים חדשים';
$string['answer'] = 'השב';
$string['approvaldisplayformat'] = 'תסדיר תצוגה מאושר';
$string['approvaldisplayformat_help'] = 'כאשר מאשרים פריטי אגרון מונחים תוכל להשתמש בתסדיר תצוגה שונה';
$string['approve'] = 'אשר';
$string['areaattachment'] = 'קבצים מצורפים';
$string['areaentry'] = 'הגדרות';
$string['areyousuredelete'] = 'האם אתה בטוח שאתה רוצה למחוק מונח זה?';
$string['areyousuredeletecomment'] = 'האם אתה בטוח שאתה רוצה למחוק הערה זו?';
$string['areyousureexport'] = 'האם אתה בטוח שאתה רוצה לייצא מונח זה ל-';
$string['ascending'] = '(עולה)';
$string['attachment'] = 'קובץ מצורף';
$string['attachment_help'] = '<p align="center"><b>צירוף קבצים לרשומות</b></p>

<p>באפשרותכם לצרף קובץ אחד מהמחשב האישי שלכם לכל רשומה באגרון המונחים. הקובץ מועלה לשרת ומאוכסן ביחד עם הרשומה שלכם.</p>

<p>האפשרות הזו מועילה כשאתם רוצים לחלוק לדוגמא תמונה או מסמך Word.</p>

<p>הקובץ יכול להיות מכל סוג שהוא, אך עדיין מומלץ מאוד שהשם שלו ישתמש בסיומות האינטרנט הסטנדרטיות של שלוש האותיות, כמו .doc  למסמך .jpg. ,Word או .png לתמונה, וכו\'. זה יקל על אחרים להוריד ולראות את הקבצים בשרתים שלהם.</p>

</p><p>אם אתם עורכים מחדש רשומה ומצרפים אליה קובץ חדש, הקובץ החדש יחליף כל קובץ אחר שצירפתם לרשומה לפני כן.</p>

<p>אם אתם עורכים מחדש רשומה שמצורף אליה קובץ ואתם משאירים את החלל הזה ריק, הקובץ המקורי שצירפתם יישמר. </p>';
$string['author'] = 'מחבר';
$string['authorview'] = 'עיון לפי מחבר';
$string['back'] = 'חזרה';
$string['cachedef_concepts'] = 'קישורים למושגים';
$string['cantinsertcat'] = 'אין אפשרות להוסיף סיווג זה';
$string['cantinsertrec'] = 'אין אפשרות לתחוב רשומה זו';
$string['cantinsertrel'] = 'אין אפזרות לתחוב את ההקשר סיווג-מונח';
$string['casesensitive'] = 'מונח זה תלוי אותיות רישיות';
$string['casesensitive_help'] = '<p align="center"><b>התאמה בעלת רגישות לגודל האותיות</b></p>

<p>הגדרה זו קובעת האם נדרשת התאמה מלאה בין אותיות קטנות וגדולות על מנת ליצור קישורים אוטומטיים לרשומות הללו.</p>

<p>לדוגמא, אם האפשרות הזו מופעלת, אז מילה כמו "html" שתופיע בפירסום בפורום, לא תקושר לרשומה שנקראת "HTML" באגרון המונחים.
</p>';
$string['cat'] = 'סיווג';
$string['categories'] = 'הסיווגים';
$string['category'] = 'סיווג';
$string['categorydeleted'] = 'הסיווג נמחק';
$string['categoryview'] = 'עיון לפי הסיווגים';
$string['changeto'] = 'שנה ל{$a}';
$string['cnfallowcomments'] = 'האם כבררת־מחדל אגרון המונחים יאפשר הערות משתמשים על מונחים.';
$string['cnfallowdupentries'] = 'האם כבררת־מחדל אגרון המונחים יאפשר מונחים כפולים.';
$string['cnfapprovalstatus'] = 'הגדרת אופן האישור (שישמש כבררת־מחדל) למונחים שיוגדרו על ידי המשתמשים.';
$string['cnfcasesensitive'] = 'האם כבררת־מחדל מונח, מרגע שקושר, יהיה רגיש לאותיות רישיות.';
$string['cnfdefaulthook'] = 'הגדרת המבחר שיוצג כבררת־מחדל כאשר צופים לראשונה באגרון המונחים.';
$string['cnfdefaultmode'] = 'הגדרת המבנה שיוצג כבררת־מחדל כאשר צופים לראשונה באגרון המונחים.';
$string['cnffullmatch'] = 'האם כבררת־מחדל, מונח, מרגע שקושר, צריך להתאים לאותיות הרישיות של התוכן.';
$string['cnflinkentry'] = 'האם כבררת־מחדל יש ליצור קישורים אוטומטיים למונחים.';
$string['cnflinkglossaries'] = 'האם כבררת־מחדל יש ליצור קישורים אוטומטיים לאגרון המונחים.';
$string['cnfrelatedview'] = 'הגדרת מבנה התצוגה שישמש ליצירת קישורים אוטומטיים וצפייה בערכים.';
$string['cnfshowgroup'] = 'הגדר האם תוצג ההפרדה בין הקבוצות, או לא.';
$string['cnfsortkey'] = 'יש לבחור את מפתח המיון שישמש כבררת־מחדל.';
$string['cnfsortorder'] = 'הגדרת סדר המיון שישמש כבררת־מחדל.';
$string['cnfstudentcanpost'] = 'האם כבררת־מחדל, סטודנטים יכולים לפרסם ערכים.';
$string['comment'] = 'הערה';
$string['commentdeleted'] = 'ההערה נמחקה.';
$string['comments'] = 'הערות';
$string['commentson'] = 'הערות על';
$string['commentupdated'] = 'ההערה עודכנה.';
$string['completionentries'] = 'סטודנטים חייבים ליצור מונחים';
$string['completionentriesgroup'] = 'מונחים שנדרשים';
$string['concept'] = 'מונח';
$string['concepts'] = 'מונחים';
$string['configenablerssfeeds'] = 'הגדרה זו תאפשר דיווחי עדכונים בתסדיר RSS לכל אגרוני המונחים. עדיין, יהיה צורך להפעיל את הדיווחים באופן ידני בהגדרות של כל אחד מאגרוני המונחים.';
$string['current'] = '{$a} מאוחסן כרגע';
$string['currentglossary'] = 'אגרון מונחים נוכחי';
$string['date'] = 'תאריך';
$string['dateview'] = 'עיון לפי תאריך';
$string['defaultapproval'] = 'בררת־מחדל: "מאושר"?';
$string['defaultapproval_help'] = '<p align="center"><b>ברירת המחדל: מצב "מאושר"</b></p>

<p>ההגדרה הזו מאפשרת למורה להגדיר מה קורה לרשומות חדשות שהוספו על ידי סטודנטים. אפשר לאשר את כולן אוטומטית, כך שהן הופכות זמינות לכולם, אחרת, המורה יצטרך לאשר כל אחת בנפרד.</p>';
$string['defaulthook'] = 'בררת־מחדל של הקשר';
$string['defaultmode'] = 'מצב בררת־מחדל';
$string['defaultsortkey'] = 'בררת־מחדל של מפתח המיון';
$string['defaultsortorder'] = 'בררת־מחדל של מפתח הסידור';
$string['definition'] = 'הגדרה';
$string['definitions'] = 'הגדרות';
$string['deleteentry'] = 'מחק מונח';
$string['deletenotenrolled'] = 'מחק כניסות ע"י משתמש אשר לא רשום';
$string['deletingcomment'] = 'מוחק את ההערה';
$string['deletingnoneemptycategory'] = 'מחיקת סיווג זה לא תמחוק את המונחים שהיא מכילה - הם יסומנו כ"ללא-סיווג".';
$string['descending'] = '(יורד)';
$string['destination'] = 'יעד';
$string['destination_help'] = '<p align="center"><b>הגדרת יעד לייבוא רשומות</b></p>

<p>אתם יכולים להגדיר לאן אתם רוצים ליבא רשומות:</p>
<ul>
<li><strong>אגרון מונחים נוכחי:</strong>אפשרות זו תצרף את הרשומות המיובאות לתוך אגרון המונחים שפתוח כרגע.</li>
<li><strong>אגרון מונחים חדש:</strong>אפשרות זו תיצור אגרון מונחים חדש המבוסס על המידע שנמצא בתוך הקובץ המיובא שבחרתם ותכניס לתוכו רשומות חדשות.
</li>
</ul>';
$string['disapprove'] = 'בטל אישור';
$string['displayformat'] = 'מבנה התצוגה';
$string['displayformatcontinuous'] = 'רציף בלי מחבר';
$string['displayformatdefault'] = 'בררת־מחדל לדומה לתצורת תצוגה';
$string['displayformatdictionary'] = 'פשוט, סגנון מילוני';
$string['displayformatencyclopedia'] = 'אנציקלופדיה';
$string['displayformatentrylist'] = 'רשימת מונחים';
$string['displayformatfaq'] = 'שאלות ותשובות';
$string['displayformatfullwithauthor'] = 'מלא עם מחבר';
$string['displayformatfullwithoutauthor'] = 'מלא בלי מחבר';
$string['displayformat_help'] = '<p align="center"><b>עיצוב התצוגה</b></p>

<p>הגדרה זו מציינת באיזו דרך תוצג כל רשומה בתוך אגרון המונחים. עיצובי ברירת המחדל הינם:</p>
<blockquote>
<dl>
<dt><b>מילון פשוט</b>:</dt>
<dd>תצוגה שנראית כמו מילון קונבנציונלי עם רשומות נפרדות. המחברים לא מוצגים, וקבצים מצורפים מוצגים כקישורים.
</dd>
<dt><b>רצוף (זה אחר זה)</b>:</dt>
<dd>הרשומות מוצגות ברצף, אחת אחרי השניה, ללא שום הפרדה מלבד סמלי (אייקון) העריכה.</dd>
<dt><b>מלא עם מחבר</b>:</dt>
<dd>עיצוב תצוגה הדומה לפורום המציג את נתוני המחבר. קבצים מצורפים מוצגים כקישורים. </dd>
<dt><b>מלא ללא מחבר</b>:</dt>
<dd>עיצוב תצוגה הדומה לפורום, שאינו מציג את נתוני המחבר. קבצים מצורפים מוצגים כקישורים.</dd>
<dt><b>אנציקלופדיה</b>:</dt>
<dd>דומה ל"מלא עם מחבר", מלבד העובדה שתמונות מצורפות מוצגות כחלק מהטקסט.</dd>
<dt><b>שאלות ותשובות</b>:</dt>
<dd>אפשרות זו יעילה לתצוגת רשימות של שאלות תכופות (FAQ). האפשרות מוסיפה באופן אוטומטי את המילים \'שאלה\' ו\'תשובה\' בהתאמה, למושג ולהגדרה.</dd>
</dl>
</blockquote>

<hr />
<p>מנהלי מוודל יכולים ליצור עיצובים חדשים, לפי ההוראות ב:<b>mod/glossary/formats/README.txt</b>.</p>';
$string['displayformats'] = 'מבני התצוגה';
$string['displayformatssetup'] = 'הגדרת מבני התצוגה';
$string['duplicatecategory'] = 'סיווג כפול';
$string['duplicateentry'] = 'מונח כפול';
$string['editalways'] = 'ללא הגבלת עריכה';
$string['editalways_help'] = '<p align="center"><b>ערוך תמיד</b></p>

<p>אפשרות זו מאפשרת לכם להחליט אם הסטודנטים יכולים לערוך את הרשומות שלהם בכל עת.
</p>

<p>אתם יכולים לבחור:</p>

<ul>
<li><b>כן:</b> תמיד ניתן לערוך רשומות.</li>

<li><b>לא:</b>רשומות ניתן לערוך רק בזמן עריכה מוגדר.
</li>
</ul>';
$string['editcategories'] = 'עריכת סיווגים';
$string['editentry'] = 'עריכת מונח';
$string['editingcomment'] = 'עורך את ההערה';
$string['entbypage'] = 'מונחים המוצגים בכל עמוד';
$string['entries'] = 'מונחים';
$string['entrieswithoutcategory'] = 'מונחים ללא סיווג';
$string['entry'] = 'מונח';
$string['entryalreadyexist'] = 'המונח כבר קיים';
$string['entryapproved'] = 'מונח זה אושר';
$string['entrydeleted'] = 'המונח נמחק';
$string['entryexported'] = 'המונח יוצא בהצלחה';
$string['entryishidden'] = '(מונח זה מוסתר כרגע)';
$string['entryleveldefaultsettings'] = 'הגדרות בררת־מחדל ברמת המונח';
$string['entrysaved'] = 'המונח נשמר';
$string['entryupdated'] = 'המונח עודכן';
$string['entryusedynalink'] = 'יש ליצור קישורים באופן אוטומטי למונח זה';
$string['entryusedynalink_help'] = '<p align="center"><b>אפשר יצירה אוטומטית של קישורים ברשומה</b></p>

<p> הפעלה של תכונה זו תאפשר יצירה אוטומטית של קישורים לרשומה זו. הקישורים יופיעו בכל מקום ברחבי (אותו) הקורס, בו יופיעו המילים או הביטויים שמשמשים להגדרת המושג.

הדבר כולל פירסומים בפורומים, משאבים פנימיים, סיכומים שבועיים וכיוצא בזה.</p>

<p>אם אתם לא רוצים שטקסט מסויים יקושר (נאמר, בפירסום בפורום), אז אתם צריכים להוסיף את התגיות lt;nolink&gt; ו &lt;/nolink&gt; מסביב לטקסט.</p>

<p>על מנת שתוכלו להפעיל את התכונה הזו, אפשרות יצירת הקישורים האוטומטית חייבת להיות מופעלת ברמת אגרון המונחים.</p>';
$string['errcannoteditothers'] = 'אינך יכול לערוך מונחים של משתמשים אחרים.';
$string['errconceptalreadyexists'] = 'מושג זה כבר קיים. באגרון מונחים זה לא ניתן להכניס ערכים כפולים.';
$string['errdeltimeexpired'] = 'לא ניתן למחוק זאת';
$string['erredittimeexpired'] = 'פרק הזמן בו היה ניתן לערוך את מונח זה, חלף.';
$string['errorparsingxml'] = 'חלה שגיאה במהלך הפירוק של קובץ זה למרכיביו.  וודא שהוא בתחביר XML תקף.';
$string['eventcategorycreated'] = 'הסיווג נוצר';
$string['eventcategorydeleted'] = 'הסיווג נמחק';
$string['eventcategoryupdated'] = 'הסיווג עודכן';
$string['evententryapproved'] = 'מונח אושר';
$string['evententrycreated'] = 'המונח נוצר';
$string['evententrydeleted'] = 'המונח  נמחק';
$string['evententrydisapproved'] = 'המונח לא אושר';
$string['evententryupdated'] = 'המונח עודכן';
$string['evententryviewed'] = 'המונח נצפה';
$string['explainaddentry'] = 'הוספת מונח חדש לאגרון המונחים הנוכחי.<br />שדות המושג וההגדרה הם הכרחיים.';
$string['explainall'] = 'מציג את כל המונחים על עמוד אחד.';
$string['explainalphabet'] = 'עיין באגרון המונחים באמצעות מפתח זה.';
$string['explainexport'] = 'כדי לייצא את המונחים של אגרון המונחים, לחץ על הכפתור שנמצא למטה.<br /> אתה יכול ליצא אותם לקורס זה, או לקורס אחר, בכל זמן שתבחר.<p> אנא שים לב שקבצים מצורפים (לדוגמא תמונות) ושמות המחברים לא מיוצאים. </p>';
$string['explainimport'] = 'עליך לציין את הקובץ שיש לייבא ולקבוע את קנה המידה של תהליך.<br />שלח את בקשתך וסקור את התוצאות.</p>';
$string['explainspecial'] = 'מציג מונחים שלא מתחילים באות.';
$string['exportedentry'] = 'מונח מיוצא';
$string['exportentries'] = 'יצוא מונחים';
$string['exportentriestoxml'] = 'יצוא מונחים לקובץ XML';
$string['exportfile'] = 'יצוא מונחים לקובץ';
$string['exportglossary'] = 'יצוא אגרון מונחים';
$string['exporttomainglossary'] = 'יצוא לאגרון המונחים הראשי';
$string['filetoimport'] = 'קובץ ליבוא';
$string['filetoimport_help'] = '<p align="center"><b>קובץ לייבוא</b></p>

<p>ביחרו על המחשב שלכם בקובץ ה-XML שמכיל את הרשומות שאתם רוצים לייבא. </p>';
$string['fillfields'] = 'חובה למלא את שדות המושג וההגדרה.';
$string['filtername'] = 'יצירת קישורים באופן אוטומטי לאגרון המונחים';
$string['fullmatch'] = 'התאם מילים שלמות בלבד';
$string['fullmatch_help'] = '<p align="center"><b>התאמת מילים שלמות</b></p>

<p>אם האפשרות ליצירת קישורים באופן אוטומטי מופעלת, אז הפעלה של ההגדרה הזו תכפה קישורים רק על מילים מלאות.</p>

<p>לדוגמא, רשומה באגרון המונחים ששמה "construct" לא תיצור קישור בתוך המילה "constructivism"</p>';
$string['glossary:addinstance'] = 'הוספת אגרון מונחים חדש';
$string['glossary:approve'] = 'אשר את המונחים';
$string['glossary:comment'] = 'יצירת הערות';
$string['glossary:export'] = 'יצוא רשומות';
$string['glossary:exportentry'] = 'יצוא רשומה בודדת';
$string['glossary:exportownentry'] = 'יצוא רשומות בודדות השייכות לך';
$string['glossary:import'] = 'יבוא רשומות';
$string['glossaryleveldefaultsettings'] = 'הגדרות בררת־מחדל ברמת אגרון המונחים';
$string['glossary:managecategories'] = 'נהל הסיווגים';
$string['glossary:managecomments'] = 'ניהול הערות';
$string['glossary:manageentries'] = 'ניהול מונחים';
$string['glossary:rate'] = 'דרג מונחים';
$string['glossarytype'] = 'סוג אגרון המונחים';
$string['glossarytype_help'] = '<p align="center"><b>הגדרת אגרון המונחים העיקרי של הקורס</b></p>

<p>מערכת אגרוני המונחים מאפשרת לכם לייצא רשומות מכל אגרון מונחים משני, לתוך אגרון המונחים העיקרי של הקורס.</p>

<p>על מנת שתוכלו לעשות את זה, עליכם לציין איזה מאגרוני המונחים הוא העיקרי.</p>

ביצוע עקיפת הרשאות mod/glossary:write לתפקיד סטודנט בפעילות, תמנע אפשרות להוספה של מונחים חדשים.';
$string['glossary:view'] = 'ראה את אגרון המונחים';
$string['glossary:viewallratings'] = 'צפיה בכל שורת הדירוגים הניתנים על-ידי אנשים';
$string['glossary:viewanyrating'] = 'צפיה בדירוגים הכוללניים שכל אחד קיבל';
$string['glossary:viewrating'] = 'הצגת הדירוגים';
$string['glossary:write'] = 'יצירת מונחים חדשים';
$string['guestnoedit'] = 'אורחים אינם יכולים לערוך מונחים';
$string['importcategories'] = 'יבוא סיווגים';
$string['importedcategories'] = 'הסיווגים מיובאים';
$string['importedentries'] = 'מונחים מיובאים';
$string['importentries'] = 'יבוא מונחים';
$string['importentriesfromxml'] = 'יבא רשומות מקובץ XML';
$string['includegroupbreaks'] = 'כלול הפסקות קבוצה';
$string['isglobal'] = 'האם זהו אגרון מונחים מערכתי?';
$string['isglobal_help'] = '<p align="center"><b>הגדרת אגרון מונחים מערכתי</b></p>

<p>מנהלים יכולים להגדיר אגרון מונחים מערכתי.</p>

<p>אגרונות מונחים אלה יכולים לשמש כמשאב לכל קורס שהוא (וגם להופיע בעמוד השער).</p>

<p>השוני בין אגרון מונחים זה לבין אגרון מונחים מקומי, רגיל, הוא שהרשומות משמשות ליצירה אוטומטית של קישורים לכל אורך האתר (ולא רק באותו הקורס אליו משתייך אגרון המונחים).
</p>';
$string['letter'] = 'אות';
$string['linkcategory'] = 'יצירת קישורים באופן אוטומטי לסיווג זה';
$string['linkcategory_help'] = '<p align="center"><b>יצירה אוטומטית של קישורים לסיווגים</b></p>

<p>אתם יכולים לציין אם אתם מעוניינים ליצור קישורים לסיווגים באופן אוטומטי, או לא.</p>

<p>שימו לב: לסיווגים נוצרים קישורים שרגישים לגודל האותיות (לדוגמא: B ו b), ולפי התאמה של המילה המלאה. </p>';
$string['linking'] = 'יצירת קישורים באופן אוטומטי';
$string['mainglossary'] = 'אגרון מונחים ראשי';
$string['maxtimehaspassed'] = 'סליחה, אך הזמן המירבי שבו מותר היה לערוך הערה זו({$a}) חלף!';
$string['modulename'] = 'אגרון מונחים';
$string['modulename_help'] = 'פעילות "אגרון־מונחים" (Glossary), מאפשרת למשתתפים ליצור רשימה של הגדרות, בדומה למילון, כדי לאסוף ולארגן משאבים או מידע.

מורה יכול לאפשר צרוף קבצים ותמונות למונחים באגרון. ניתן לערוך חיפוש מונחים באופן של דיפדוף אלפביתי, לפי קטגוריה, תאריך או מחבר. מונחים יכולים להיות מאושרים כברירת מחדל או על ידי אישור ממורה לפני שהם ניתנים לצפייה על ידי כולם.

כאשר מסנן (filter) "קישור־אוטומטי" מופעל, אזי כל המונחים באגרון יקושרו באופן אוטומטי בשעה שיופיעו או יוזנו כביטויים בכל פסקאת תוכן בכל מקום בתוך הקורס.

המורה יכול לאפשר לתלמידים להגיב על מונחים. מונחים יכולים להיות מדורגים על ידי מורים או תלמידים (הערכת עמיתים). ניתן לצבור דירוגים, וליצור ציון סופי שיירשם בגליון־הציונים.

ניתן להציג משבצת־צד (block) בעמוד הראשי של הקורס, אשר מציגה מונח אקראי מתוך האגרון.

לאגרון מונחים שימושים רבים, כגון:

* מאגר שיתופי של מונחי מפתח.

* מרחב "להכיר אותך" ,שבו תלמידים חדשים יכולים להוסיף את שמם ופרטיהם האישיים .

* משאב \'טיפים שימושיים\' לתרגול הטוב ביותר בנושא מסוים.

* אזור שיתוף של סרטונים שימושיים, תמונות או קבצי קול.

 * משאב לעדכון של עובדות שיש לזכור.';
$string['modulenameplural'] = 'אגרוני מונחים';
$string['newentries'] = 'מונחים חדשים באגרון המונחים';
$string['newglossary'] = 'אגרון מונחים חדש';
$string['newglossarycreated'] = 'נוצר אגרון מונחים חדש.';
$string['newglossaryentries'] = 'מונחים חדשים באגרון המונחים:';
$string['nocomment'] = 'לא נמצאו הערות';
$string['nocomments'] = '(לא נמצאו הערות עבור מונח זה)';
$string['noconceptfound'] = 'לא נמצאו לא מונח ולא הגדרה.';
$string['noentries'] = 'לא נמצאו מונחים בקטע זה.';
$string['noentry'] = 'לא נמצא אף מונח.';
$string['nopermissiontodelcomment'] = 'לא ניתן למחוק הערות של משתמשים אחרים!';
$string['nopermissiontodelinglossary'] = 'לא ניתן לרשום הערה באגרון מונחים זה!';
$string['nopermissiontoviewresult'] = 'תוכל לצפון בתוצאות  המונחים שלך בלבד';
$string['notapproved'] = 'מונח האגרון עדיין לא קיבל אישור';
$string['notcategorised'] = 'ללא סיווג';
$string['numberofentries'] = 'מספר המונחים';
$string['onebyline'] = '(אחד בשורה)';
$string['page-mod-glossary-edit'] = 'עמוד הוספת/עריכת מונח של אגרון המונחים';
$string['page-mod-glossary-view'] = 'צפיה בעמוד העריכה של אגרון המונחים';
$string['page-mod-glossary-x'] = 'עמוד רכיב אגרון מונחים כלשהו';
$string['pluginadministration'] = 'ניהול אגרון המונחים';
$string['pluginname'] = 'אגרון מונחים';
$string['popupformat'] = 'תבנית חלון קופץ';
$string['print'] = 'הדפסה';
$string['printerfriendly'] = 'הדפסה';
$string['printviewnotallowed'] = 'אין אפשרות לתצוגה מקדימה של ההדפסה';
$string['question'] = 'שאלה';
$string['rejectedentries'] = 'מונחים שנדחו';
$string['rejectionrpt'] = 'דוח דחויים';
$string['resetglossaries'] = 'מחק כניסות מכל אגרוני המונחים';
$string['resetglossariesall'] = 'מחק כניסות מכל';
$string['rssarticles'] = 'מספר כתבות ה-RSS האחרונות';
$string['rssarticles_help'] = '<p align="center"><b>מספר מאמרי ה-RSS שאירעו לאחרונה</b></p>

<p>אפשרות זו מאפשרת לכם לבחור את מספר המאמרים (טקסטים הנשלחים לקבוצת דיון) שיכללו בהזנת ה-RSS. </p>

<p>מספר בין 5 ל-20 מספיק לרוב אגרונות המונחים הרגילים. הגדילו את המספר אם אגרון המונחים שלכם מתעדכן בתדירות גבוהה.
</p>';
$string['rsssubscriberss'] = 'הצגת הזנת ה-RSS עבור  \'{$a}\' מושגים';
$string['rsstype'] = 'הזנות ה-RSS עבור פעילות זו';
$string['rsstype_help'] = '<p align="center"><b>הזנת RSS לאגרון מונחים זה</b></p>

<p>אפשרות זו מאפשרות לכם להפעיל הזנות RSS מאגרון מונחים זה.</p>

<p>אתם יכולים לבחור בין שתי סוגי הזנות:</p>

<ul>
<li><b>עם מחבר:</b>ההזנות שנוצרו, יכללו את שם המחבר בכל מאמר.</li>

<li><b>ללא מחבר:</b>ההזנות שנוצרו, לא יכללו את שם המחבר בכל מאמר.</li>
</ul>';
$string['searchindefinition'] = 'חיפוש בתוכן המונח';
$string['secondaryglossary'] = 'אגרון מונחים משני';
$string['showall'] = 'הצגת קישור "הכל"';
$string['showall_help'] = 'כאשר פעיל, משתמשים יכולים לצפות בכל המונחים יחדיו.';
$string['showalphabet'] = 'הצגת סרגל ניווט מבוסס אלפבית';
$string['showalphabet_help'] = 'כאשר פעיל, משתמשים יכולים לצפות באגרון המונחים לפי אלפבית.';
$string['showspecial'] = 'הצגת קישור "מיוחד"';
$string['showspecial_help'] = 'כאשר פעיל, משתמשים יכולים לצפות במונחי האגרון לפי תווים מיוחדים כמו @, #, וכו\'.';
$string['sortby'] = 'מיין לפי';
$string['sortbycreation'] = 'לפי תאריך יצירה';
$string['sortbylastupdate'] = 'לפי עדכון אחרון';
$string['sortchronogically'] = 'מיין באופן כרונולוגי';
$string['special'] = 'מיוחד';
$string['standardview'] = 'עיון לפי אלפבית';
$string['studentcanpost'] = 'סטודנטים יכולים להוסיף מונחים';
$string['totalentries'] = 'כלל המונחים';
$string['usedynalink'] = 'יצירת קישורים באופן אוטומטי לאגרון המונחים';
$string['usedynalink_help'] = '<p align="center"><b>אפשר יצירה אוטומטית של קישורים באגרון המונחים</b></p>

<p> הפעלה של תכונה זו תאפשר יצירה אוטומטית של קישורים לרשומות פרטניות בתוך אגרון מונחים זה. הקישורים יופיעו בכל מקום ברחבי (אותו) הקורס, בו יופיעו המילים או הביטויים שמשמשים את הגדרת המושג.

הדבר כולל פירסומים בפורומים, משאבים פנימיים, סיכומים שבועיים וכיוצא בזה.</p>

<p>שימו לב, שהתרה של אפשרות זו לא מפעילה אוטומטית קישורים לכל רשומה, את יצירת הקישורים צריך להגדיר לכל רשומה בנפרד.</p>

<p>אם אתם לא רוצים שטקסט מסויים יקושר (נאמר, בפירסום בפורום), אז אתם צריכים להוסיף תגיות lt;nolink&gt; ו &lt;/nolink&gt; מסביב לטקסט. </p>

<p>שימו לב ששמות של סיווגים, גם כן מקושרות.</p>';
$string['waitingapproval'] = 'ממתין לאישור';
$string['warningstudentcapost'] = '(תקף רק אם זהו אינו אגרון המונחים הראשי)';
$string['withauthor'] = 'מונחים עם מחבר';
$string['withoutauthor'] = 'מונחים בלי מחבר';
$string['writtenby'] = 'על ידי';
$string['youarenottheauthor'] = 'אתה לא המחבר של הערה זו, ולכן לא תוכל לערוך אותה.';
