<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_magazine', language 'de', branch 'MOODLE_27_STABLE'
 *
 * @package   theme_magazine
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['background'] = 'Hintergrund';
$string['backgrounddesc'] = 'Um das Hintergrundbild zu ändern, geben Sie die URL zu einem neuen Hintergrundbild an (z.B. http://www.meinedomain.de/hintergrund.jpg).';
$string['blockcolor'] = 'Blockfarbe';
$string['blockcolordesc'] = 'Diese Farbe wird für die Blocküberschriften benutzt.';
$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Magazine</h2>
<img src="magazine/pix/screenshot.png" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentationen:</h3>
<p><a href="http://docs.moodle.org/de/Designs">http://docs.moodle.org/de/Designs</a></p>
<h3>Fehler melden:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Magazine</h2>
<p>Magazine ist ein Drei-Spalten-Design mit variabler Breite für Moodle 2.0.</p>
<h2>Hinweise</h2>
<p>Dieses Design basiert auf den beiden in Moodle enthaltenen Grunddesigns Base und Canvas. Wenn Sie Änderungen vornehmen wollen, empfehlen wir unbedingt, vorher immer eine Kopie zu erstellen und diese umzubenennen. So wird verhindert, dass Ihre Änderungen bei einem Update von Moodle verloren gehen; Sollte Ihnen ein Fehler in den Änderungen unterlaufen, haben Sie so ebenfalls noch eine funktionierende Sicherheitskopie. Weitere Informationen zum Bearbeiten von Designs finden Sie in der <a href="http://docs.moodle.org/de/Designs">Designdokumentation</a>.</p>
<h2>Autor</h2>
<p>Dieses Design wurde erstellt und wird weiter unterstützt von John Stabinger (NewSchool Learning). Kontaktaufnahme ist per E-Mail: contact@newschoollearning.com</p>
<h2>Lizenz</h2>
<p>Dieses und alle weiteren in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>. Einige der im Design benutzten Icons stammen aus dem Splashy Icon Set, die über <a href="http://splashyfish.com/icons/">http://splashyfish.com/icons/</a> frei verfügbar sind. </p>
</div>
</div>';
$string['configtitle'] = 'Magazine-Einstellungen';
$string['forumback'] = 'Forumshintergrund';
$string['forumbackdesc'] = 'Diese Farbe wird für die Titelhintergründe von Forumsbeiträgen benutzt.';
$string['headingcolor'] = 'Kopfbereichsfarbe';
$string['headingcolordesc'] = 'Diese Farbe wird für große Kopfbereiche (Website-Nachrichten, meine Kurse) und andere Kopfbereiche benutzt.';
$string['linkcolor'] = 'Link';
$string['linkcolordesc'] = 'Diese Farbe wird für alle Links benutzt. Verwenden Sie HTML hex-Code.';
$string['linkhover'] = 'Link (on hover)';
$string['linkhoverdesc'] = 'Diese Farbe wird für Links (on hover) benutzt. Verwenden Sie HTML hex-Code.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Um das Logo zu ändern, geben Sie die URL zu einem neuen Logo an (z.B. http://www.meinedomain.de/logo.png). Das Standardlogo ist 300px breit und 80px hoch. Ein transparentes Logo im Format PNG funktioniert am besten.';
$string['maincolor'] = 'Kopfbereichsfarbe';
$string['maincoloraccent'] = 'Akzentfarbe zum Kopfbereich';
$string['maincoloraccentdesc'] = 'Dunkle Akzentfarbe für das Dock und Ränder des Kopfbereichs. Diese Farbe sollte geringfügig dunkler als die Kopfbereichsfarbe sein.';
$string['maincolordesc'] = 'Diese Farbe wird für den Kopfbereich, das Dock und andere Bereiche benutzt. Am besten wirken dunkle oder deckende Farben.';
$string['pluginname'] = 'Magazine';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
