<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'zh_cn', branch 'MOODLE_28_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = '访问被拒绝';
$string['accounts'] = '帐户';
$string['addcategory'] = '添加一个类别';
$string['additionalhtml'] = '附加HTML';
$string['additionalhtml_desc'] = '用此设置您可以指定一段HTML代码，它会被插入到每个页面中。您可以把HTML代码插入到页面的HEAD标签内，BODY标签刚开始的地方，或BODY标签结束之前。<br />通过这种方式，您可以在每个页面内都添加自定义的页头或页脚，也可以方便地支持Google Analytics之类的服务，并且和您选择的主题风格完全无关。';
$string['additionalhtmlfooter'] = '在</body>之前添加';
$string['additionalhtmlfooter_desc'] = '这些内容将被插入每个页面的</body>标签之前，也就是网页的最底部。';
$string['additionalhtmlhead'] = '在HEAD内';
$string['additionalhtmlhead_desc'] = '这些内容将做为HEAD标签的最后一条而被插入到每个页面。';
$string['additionalhtml_heading'] = '向所有页面插入的HTML代码。';
$string['additionalhtmltopofbody'] = '在<body>标签后面添加';
$string['additionalhtmltopofbody_desc'] = '这些内容将被插入每个页面的<body>标签的后面，也就是网页内容的顶部';
$string['admincategory'] = '类别：{$a}';
$string['adminseesall'] = '管理员可见所有事件';
$string['adminseesallevents'] = '管理员看到所有事件';
$string['adminseesownevents'] = '管理员和其它用户一样';
$string['advancedfeatures'] = '高级特性';
$string['allcountrycodes'] = '全部国家代码';
$string['allowbeforeblock'] = '优先处理允许访问列表';
$string['allowbeforeblockdesc'] = '缺省情况，禁止访问IP列表会先被匹配。如果启用此选项，则允许访问IP列表的处理会先于禁止访问列表。';
$string['allowblockstodock'] = '允许版块停靠于此';
$string['allowcategorythemes'] = '允许课程分类主题';
$string['allowcoursethemes'] = '允许课程主题';
$string['allowediplist'] = '允许访问的IP列表';
$string['allowemailaddresses'] = '允许的邮件域名';
$string['allowframembedding'] = '允许嵌入框架';
$string['allowframembedding_help'] = '允许将本站嵌入到外部网站的框架（frame）中。出于安全考量，不建议启用此特性。';
$string['allowguestmymoodle'] = '允许访客访问我的主页';
$string['allowobjectembed'] = '允许EMBED和OBJECT标记';
$string['allowthemechangeonurl'] = '准许在URL中改变主题';
$string['allowuserblockhiding'] = '允许用户隐藏版块';
$string['allowuserswitchrolestheycantassign'] = '允许没有分配角色权限的用户切换角色';
$string['allowuserthemes'] = '允许用户主题';
$string['alternativefullnameformat'] = '备选全名格式';
$string['alternativefullnameformat_desc'] = '此项用于定义拥有全名显示权限的用户如何显示名字（管理员、教师和无编辑权的教师默认具有此权限）。“全名格式”设置可以使用占位符。';
$string['antivirus'] = '防病毒';
$string['appearance'] = '外观';
$string['aspellpath'] = 'aspell的路径';
$string['authentication'] = '身份认证';
$string['authpreventaccountcreation'] = '防止在身份认证时创建账号';
$string['authpreventaccountcreation_help'] = '当认证用户且它在本站还没有账号时，会自动在本站创建账号。如果使用外部数据库（例如LDAP）做认证，但是您希望只允许在本站有账号的用户访问，那么就启用此选项。新账号可以通过手工建立或者上传用户创建。注意，此设置不会影响MNet认证。';
$string['authsettings'] = '管理身份认证';
$string['autolang'] = '语言自动检测';
$string['autologinguests'] = '自动登录为访客';
$string['availablelicenses'] = '可选的许可证';
$string['availableto'] = '可用到';
$string['backgroundcolour'] = '透明色';
$string['backups'] = '备份';
$string['backup_shortname'] = '在备份文件名中使用课程名';
$string['backup_shortnamehelp'] = '备份文件名中包含课程名。';
$string['badwordsconfig'] = '输入以逗号(英文半角)分割的禁用词语列表。';
$string['badwordsdefault'] = '如果自定义列表为空，则使用语言包提供的缺省列表。';
$string['badwordslist'] = '自定义禁用词语列表';
$string['blockediplist'] = '禁止访问的IP列表';
$string['blockeditingmenu'] = '版块编辑菜单';
$string['blockeditingmenu_desc'] = '若启用，在编辑状态下，版块的编辑图标将会显示到下拉菜单中。这样可以减少屏幕上显示的内容，让图标在用到时才显示。';
$string['blockinstances'] = '实例';
$string['blockmultiple'] = '多个';
$string['blockprotect'] = '保护实例';
$string['blockprotect_help'] = '如果您锁定了特定类型的版块，那么别人就不能再添加或删除实例。（当然，你是可以的，只要在编辑前先解锁）

此功能用来保护导航和设置这样的版块，它们如果被偶然删除，会很难再加回来。';
$string['blocksettings'] = '管理版块';
$string['blockunprotect'] = '取消保护';
$string['bloglevel'] = '博客可见性';
$string['bookmarkadded'] = '书签已添加。';
$string['bookmarkalreadyexists'] = '您已经为此页设置了书签。';
$string['bookmarkdeleted'] = '删除书签';
$string['bookmarkthispage'] = '将本页加入书签';
$string['cacheapplication'] = '应用程序缓存';
$string['cacheapplicationhelp'] = '缓存的项目能被所有用户共享，期限由指定的TTL决定。';
$string['cachejs'] = '缓存Javascript';
$string['cachejs_help'] = 'JavaScript的缓存和压缩能大大提高页面的加载速度。我们强烈建议正式运营的网站使用它。开发者可能需要禁用此功能。
';
$string['cacherequest'] = '请求缓存';
$string['cacherequesthelp'] = '用户特定缓存。当请求结束时自动过期，主要是用来替代那些我们使用静态存储保存缓存';
$string['cachesession'] = '会话缓存';
$string['cachesessionhelp'] = '用户特定缓存。当用户会话结束时自动过期，主要是用来缓解会话过多或滥用';
$string['cachesettings'] = '缓存设置';
$string['caching'] = '缓存';
$string['calendarexportsalt'] = '日历导出盐';
$string['calendarsettings'] = '日历';
$string['calendartype'] = '日历样式';
$string['calendartype_desc'] = '为全站选择一个预设的日历样式。此设定可以被课程设定覆盖，也可以被用户在个人资料中的设定覆盖。';
$string['calendar_weekend'] = '周末';
$string['cannotdeletemodfilter'] = '您不能卸载“{$a->filter}”，因为它是“$a->module}”模块的一部分。';
$string['cannotuninstall'] = '不能卸载{$a}。';
$string['cfgwwwrootslashwarning'] = 'config.php文件中定义的$CFG->wwwroot不正确。可能是因为在结尾处包含了"/"字符，请将其删除或者像调试bug一样<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'config.php文件中定义的$CFG->wwwroot不正确。可能是因为因为URL地址和使用访问站点的地址不匹配，请将其纠正或者像调试bug一样<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = '修改';
$string['checkboxno'] = '否';
$string['checkboxyes'] = '是';
$string['choosefiletoedit'] = '选择要编辑的文件';
$string['clamfailureonupload'] = 'Clam AV失败时';
$string['cleanup'] = '清理';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliincorrectvalueerror'] = '错误，将“{$a->option}”的值设为“{$a->value}”是不正确的';
$string['cliincorrectvalueretry'] = '不正确的值，请重试';
$string['clistatusdisabled'] = '状态：禁止';
$string['clistatusenabled'] = '状态：启用';
$string['clistatusenabledlater'] = '状态：CLI 维护模式将会在 {$a} 启用';
$string['clitypevalue'] = '输入值';
$string['clitypevaluedefault'] = '输入值，按回车使用缺省值（{$a}）';
$string['cliunknowoption'] = '未识别的选项：
{$a}
请使用 --help 选项。';
$string['cliupgradefinished'] = '命令行升级成功地完成了。';
$string['cliupgradenoneed'] = '暂无针对{$a}版本的可用更新。不管怎样，欢迎你没事儿来转转！';
$string['cliyesnoprompt'] = '输入y（表示是）或n（表示否）';
$string['commentsperpage'] = '每页显示的评论';
$string['commonfiltersettings'] = '通用过滤设置';
$string['commonsettings'] = '通用设置';
$string['componentinstalled'] = '组件已安装';
$string['computedfromlogs'] = '从{$a}开始的日志中计算得出';
$string['condifmodeditdefaults'] = '创建新的活动或资源时使用的缺省设置值。';
$string['confeditorhidebuttons'] = '请选择HTML编辑器中要隐藏的按钮。';
$string['configallcountrycodes'] = '在很多地方都要使用这个国家/地区列表，例如用户个人资料。如果留空（缺省情况），那么会使用标准英文语言包中的countries.php（它来自ISO 3166-1）。否则，您可以输入用半角逗号分隔的代码列表，例如“GB,FT,ES”。如果要添加新的非标准代码，您必须先在en和您的语言包中添加它们。';
$string['configallowassign'] = '您可以允许属于左边角色的用户将竖行中的部分角色分配给其它人';
$string['configallowblockstodock'] = '如果启用，且当前主题风格支持，那么用户可以将版块移动到一个特别的停靠栏中';
$string['configallowcategorythemes'] = '如果启用该功能，将可以在类别中使用主题。同时这将影响到所有的子类别和课程，除非子类别和课程中都设置了自己的主题。警告：启用类别主题可能影响系统性能！';
$string['configallowcoursethemes'] = '如果启用，则允许每个课程设定自己的主题风格。课程的主题风格将覆盖其它位置(网站、用户或会话)的设定。';
$string['configallowemailaddresses'] = '如果您希望将新的email地址限制在一定的域名范围内，把他们列在这里，域名之间以空格隔开。所有其它域名都会被拒绝。域名加上前缀“.”表示子域名亦可接受。例如<strong>ourcollege.edu.au .gov.au</strong>';
$string['configallowguestmymoodle'] = '如果打开，游客可以访问我的首页，否则游客将被重定向到网站首页';
$string['configallowobjectembed'] = '作为缺省的安全考量，普通用户是不能在网页文本中通过显示的EMBED或OBJECT标记嵌入多媒体(如Falsh)的(通过mediaplugins过滤器是比较安全的)。如果您希望允许用户使用上述标记，请启用此选项。';
$string['configallowoverride'] = '允许属于左边角色的用户覆盖竖行中的某些角色';
$string['configallowoverride2'] = '选择哪些角色可以被左侧栏中角色修改。<br />注意，这些设置仅适用于具有权moodle/role:override或moodle/role:safeoverride的用户。';
$string['configallowswitch'] = '基于用户已经拥有的角色，选择他可以切换到哪些角色。除了在此表中设定外，还要赋予用户moodle/role:switchroles权限。<br />注意，只能切换到有moodle/course:view权限，而没有moodle/site:doanything权限的用户。所以表中有些列是禁用的。';
$string['configallowthemechangeonurl'] = '如果启用，那么可以用下面办法改变主题：<br />
向任意 Moodle URL添加 ?theme=themename（例如：mymoodlesite.com/?theme=afterburner）或<br />
向任意 Moodle 内部 URL添加 &theme=themename（例如：mymoodlesite.com/course/view.php?id=2&theme=afterburner）。';
$string['configallowuserblockhiding'] = '是否允许用户隐藏/显示此站中各页面两侧的版块？这个功能使用JavaScript和Cookie来记住每一个可折叠版块的状态，它只影响用户自己看到的界面。';
$string['configallowuserswitchrolestheycantassign'] = '默认情况下，用户必须有moodle/role:assign权限才能切换角色。启用这个选项会去掉这一限制，并仅用“允许角色分配”表格来确定“切换角色到”下拉菜单中的内容。我们建议您，在“允许角色分配”表格中，不要允许用户切换到权限更高的角色。';
$string['configallowuserthemes'] = '如果启用，用户就可以设定自己的主题风格。用户的主题风格设定会覆盖网站的设定(但不会覆盖课程设定)。';
$string['configallusersaresitestudents'] = '是否假定<strong>所有</strong>访问站点首页的用户为学生。如果设定为是，则所有经过确认的用户帐号都可以参加首页上学生的活动。如果设定为否，则只有那些至少参加了一门课程学习的用户才可以参加首页上学生的活动。只有管理员和特别指定的教师才可以作为这些首页活动的教师。';
$string['configauthenticationplugins'] = '请选择您想使用的认证插件，并且按照failthrough的顺序排列。';
$string['configautolang'] = '通过浏览器设置检测缺省语言。如未设置，则使用网站的缺省语言。';
$string['configautologinguests'] = '当访问者进入允许访客访问的课程时，是否自动以访客身份登录？';
$string['configbloglevel'] = '这项设定允许您限制哪个级别的用户可以在本网站浏览博客。注意，这里列出的是能浏览的用户的最大级别，而与发表者和博客类型无关。如果不需要博客功能，您也可以完全禁止它。';
$string['configcalendarcustomexport'] = '允许日历自定义日期范围';
$string['configcalendarexportsalt'] = '此随机文本用来提高日历导出验证令牌的安全性。请注意，如果您修改了这个哈希盐，那么当前所令牌都会失效。';
$string['configclamactlikevirus'] = '认为文件带病毒';
$string['configclamdonothing'] = '认为文件没问题';
$string['configclamfailureonupload'] = '如果您让clam杀毒软件扫描上传的文件，但并未正确配置clam杀毒软件或它因某些未知原因而运行失败了，那应该怎么做？如果您选择了“认为文件带病毒”，那么它们将会被转移到隔离区或是被删除。如果您选择了“认为文件没问题”，那么文件将会如往常一样被转移到目标目录中。无论选择哪个，系统都会提醒管理员clam运行失败了。如果您选择“认为文件带病毒”且由于某些原因clam运行失败了(通常是因为您未能指定合法的pathtoclam值)，所有上传的文件将会被转移到隔离区或者被删除。使用这个设置要小心。';
$string['configcookiehttponly'] = '启用 PHP 5.2.0 新特性—让浏览器只在真正的 http 请求中发送 cookie，不允许脚本语言访问 cookies。目前不是所有浏览器都支持该功能，并且可能与当前的代码不完全兼容。但是它有助于阻止某些 XSS 类型的攻击。';
$string['configcookiesecure'] = '如果当前服务器仅接收 https 连接方式，建议启用发送安全 cookies 功能。如果已启用，请确保 web 服务器不接受 http:// 地址或者设置了到 https:// 地址的永久重定向。当 <em>wwwroot</em> 地址不是以 https:// 开始时，此设置会自动关闭。';
$string['configcountry'] = '如果在此处设定一个国家或地区，则他将被用于用户注册时的缺省选择。要强制用户自己选择一个国家或地区，保持此处为空白。';
$string['configcourseoverviewfilesext'] = '课程摘要文件可以使用扩展名';
$string['configcourseoverviewfileslimit'] = '课程摘要最多可以使用多少个附件';
$string['configcourserequestnotify'] = '输入有新建课程申请时应当被通知的用户。';
$string['configcourserequestnotify2'] = '有新建课程申请时会被通知的用户。只有拥有确认课程申请权限的用户才会被列出。';
$string['configcoursesperpage'] = '输入课程列表中每页显示的课程数。';
$string['configcourseswithsummarieslimit'] = '当课程数量少于这个值时，显示带有摘要的课程列表。而当课程数量超过这个数值时，使用简单的课程列表';
$string['configcronclionly'] = '如果启用，cron将只能在命令行中运行，不能通过web访问。此设置将覆盖下面的cron密码设置。';
$string['configcronremotepassword'] = '这意味着cron.php脚本可以通过浏览器运行，而不需要通过URL地址：<pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre>提供密码，如果这里为空，就不需要密码。';
$string['configcurlcache'] = 'cURL缓存有效时间，单位是秒。';
$string['configcustommenuitems'] = '您可以在此自定义一个由主题显示的菜单。每一行包含菜单项文本、一个URL链接（可选），一个工具提示（可选）和一个语言代码或逗号分隔的代码列表（可选，只对指定语言的用户显示这一行），用管道操作符（|）隔开。您还可以使用连字符构建结构，还可以在需要的地方添加一行一个或者多个#号作为分隔符。例如：
<pre>
Moodle社区|https://moodle.org
-Moodle免费支持|https://moodle.org/support
-###
-Moodle开发|https://moodle.org/development
--Moodle文档|http://docs.moodle.org|Moodle Docs
--德语Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
#####
Moodle.com|http://moodle.com/
</pre>';
$string['configcustomusermenuitems'] = '你可以配置用户菜单（除了登出链接，它是自动添加的）。 每一行由|字符分开， 包括1）一个“语言字符串名称,内容名称"格式的字符串或纯文本， 2）一个超链接， 和3）一个图标或者超链接。可以在需要的地方添加一行一个或者多个#号作为分隔符。';
$string['configdbsessions'] = '如果启用，该设置将使用数据库来存储有关当前会话的信息。请注意，现在改变这个设置，将使得所有当前用户（包括你）退出登录。如果你正在使用MySQL，请确保在my.cnf（或my.ini文件）中的\'max_allowed_packet\'至少是4M。其他会话驱动可以直接在config.php配置，参阅config-dist.php以获取更多信息。如果你在config.php文件指定了会话驱动，此选项将消失。';
$string['configdebug'] = '如果您打开这个选项，那么PHP的错误报表会增加，页面上会出现更多的警告信息。这只对开发人员有用。';
$string['configdebugdisplay'] = '如果设为on，错误报表将在html页面中显示。这个很实用，但是常会破坏XHTML,JS,COOKIES和HTTP头。如果设为off，系统将自动发送到服务器日志中，允许更好的调试。PHP设置error_log控制那些日志写入到系统日志中。';
$string['configdebugpageinfo'] = '如果您希望在页脚打印页面信息，就启用此设置。';
$string['configdebugsmtp'] = '向SMTP服务器发送email时提供详细的调试信息。';
$string['configdebugvalidators'] = '如果您希望页面底端有到外部检查器的链接，就启用此项。您可能需要建立一个名为<em>w3cvalidator</em>的用户，并赋予它访客权限。这个改动可能会使某些人未经授权就能访问本站，所以不要在正式使用的网站上使用它。';
$string['configdefaulthomepage'] = '这里决定已登录用户的首页';
$string['configdefaultrequestcategory'] = '用户申请的课程将自动放入此类别中。';
$string['configdefaultrequestedcategory'] = '当申请被批准时，课程放到哪个类别中。';
$string['configdefaultuserroleid'] = '对所有已登录用户来说，在网站层，除了其它可能已经指派的角色以外，所有已登录用户都会获得您这里指定的角色的权限。默认为已认证用户角色。注意，除了被特别禁用的权限，此角色和他们所拥有的其它角色不会冲突，这么做只是为了确保所有用户都可以获得在网站层不能分派的一些权限（比如，发表博客、管理自己的日历等等）。';
$string['configdeleteincompleteusers'] = '之后，以前不完整的账号将被删除';
$string['configdeleteunconfirmed'] = '使用email认证注册时，超过该时限未确认的用户将被删除。';
$string['configdenyemailaddresses'] = '要拒绝某些域名的email地址，请把他们列在这里。系统会接受所有其它域名的邮件。域名加上“.”前缀会连同子域一起拒收。例如<strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = '禁止更改图像。';
$string['configdisplayloginfailures'] = '向用户显示上一次登录失败的信息。';
$string['configdndallowtextandlinks'] = '打开或关闭拖放文本、链接或文件到课程页面功能。注意，拖放文本到 Firefox或在不同浏览器间拖放是不可靠的，可能导致上传成空内容或混乱的文本。';
$string['configdoclang'] = '语言将被用在文档页面的链接地址';
$string['configdocroot'] = '定义一个Moodle文档的路径，这个路径通过在每一页页脚的“此页的Moodle文档”链接，提供相关的文档。如果该字段留空，将不会显示链接。';
$string['configdoctonewwindow'] = '启用这个选项，那么到Moodle文档的链接都将在新窗口中打开。';
$string['configeditordictionary'] = '如果aspell没有为用户自己语言指定字典，该值将会被使用。';
$string['configeditorfontlist'] = '选择应该出现在编辑器下拉列表中的字体。';
$string['configemailchangeconfirmation'] = '更改Email后需要Email确认。';
$string['configenableblogs'] = '此开关为全站用户提供一个个人博客';
$string['configenablecalendarexport'] = '启用导出或订阅日历。';
$string['configenablecomments'] = '启用评论';
$string['configenablecourserequests'] = '启用这个选项，允许任何人申请创建新课程。';
$string['configenabledevicedetection'] = '为主题风格的选择和其它特性启用移动电话、智能电话、平板电脑和缺省设备（桌面PC、笔记本等）检测功能。';
$string['configenablemobilewebservice'] = '为官方 Moodle 应用或其它应用启用移动服务功能。更多信息请访问{$a}。';
$string['configenablerssfeeds'] = '此开关将启用全站的RSS种子，诸如博客、论坛、数据库活动、词汇表等。但您还要为每个模块单独启用RSS种子。';
$string['configenablerssfeedsdisabled'] = '由于RSS种子已经在整个站点关闭了，因此无法使用。要开启它，访问管理中的变量设置。';
$string['configenablerssfeedsdisabled2'] = '默认RSS种子功能在服务器层面是禁用的，要启用该功能首先要激活服务器/RSS功能。';
$string['configenablesafebrowserintegration'] = '启用后，在测验设置表单的“浏览器安全”域中可以选择“必须使用Safe Exam Browser”。查看http://www.safeexambrowser.org/了解详情。';
$string['configenablestats'] = '如果选择“是”，则Moodle的cronjob会处理日志并做一些统计。根据您网站流量的不同，所消耗的时间也不同。如果启用这个选项，您就可以看到关于每个课程或整个网站的一些有趣的图表及统计。';
$string['configenabletrusttext'] = '默认情况下，Moodle总会全面清理来自用户的文本，移除任何可能带来安全问题的不良脚本、媒体等。如果您信任某些特定的用户使用这些高级特性的能力，可以通过可信内容系统取消对他们的干涉。为了使此系统有效，您需要首先使此设置有效，然后给指定的Moodle角色授予可信内容权限。由此类用户建立或上传的文本将被标记为可信任的，在显示前不会被清理。';
$string['configenablewebservices'] = '其它系统可以通过网络服务登录到此 Moodle 并做各种操作。出于安全考量，您应该禁用这个特性，除非您真的要使用它。';
$string['configenablewsdocumentation'] = '启用网络服务文档自动生成。用户可以在他的安全密钥页{$a}访问自己的文档。只会显示已启用协议的文档。';
$string['configerrorlevel'] = '选择显示的PHP警告数目。“正常”通常是最佳选择。';
$string['configexportlookahead'] = '在导出时要前瞻的日期';
$string['configexportlookback'] = '在导出时要前瞻的日期';
$string['configextendedusernamechars'] = '启用此选项后，学生在用户名中便可以使用任何字符(这并不会影响它们的实际名字)。缺省的情况是“否”，它限制用户名只能使用小写字母、数字、下划线（_）、横线（-）、小数点（.）或（@）。';
$string['configextramemorylimit'] = '某些脚本（如搜索、备份、还原或定期执行）需要更多的内存。对于大站点，请设置一个较高的值。';
$string['configfilterall'] = '过滤全部字符串，包括头部、标题、导航栏等等。当使用多语言过滤时，这是非常有用的，否则它只会给您的系统带来额外的负担。';
$string['configfiltermatchoneperpage'] = '自动链接过滤器在过滤内容时，仅在一页中首次匹配到的地方生成链接，而忽略掉后面的。';
$string['configfiltermatchonepertext'] = '自动链接过滤器在过滤内容时，仅在一篇文字(如资源、版块)中首次匹配到地方生成链接，而忽略掉后面的。如果每页只过滤一次的选项为<i>是</i>，则此选项会被忽略。';
$string['configfilteruploadedfiles'] = '使用该设置会让Moodle在显示上传的HTML和文本前用过滤器处理他们。';
$string['configforcelogin'] = '通常，不需要登录即可看到首页和课程列表(但不是课程)。如果您想要禁止在登录前做任何事，请使用此项设置。';
$string['configforceloginforprofiles'] = '启用这个选项会强制访问者在查看用户信息页面时必须以真实(非访客)身份登录。如果您禁用了该选项，那么可能会有用户在个人信息中发布广告（垃圾信息）或其他不和谐的内容，这些全世界都可见。';
$string['configfrontpage'] = '上面那些被选择的项将显示在网站的首页上。';
$string['configfrontpagecourselimit'] = '最大课程数目';
$string['configfrontpagecourselimithelp'] = '网站首页显示的课程列表中课程的最大数量。';
$string['configfrontpageloggedin'] = '当用户登陆后，上面那些被选择的项将显示在网站的首页上。';
$string['configfullnamedisplay'] = '本项定义如何完整显示姓名。默认值是“language（语言）”，由当前语言包中的“全名显示”字符串来决定。不同语言常常有不同的姓名显示习惯。

对大多数单一语言网站而言，最简单的设置是“firstname lastname（名 姓）”（中文网站，则大多数选择"语言"），但也完全可以选择隐藏“姓”。
可用设置项有：firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, and alternatename（名，姓，名拼音，姓拼音，中间名，和别名）。';
$string['configgeoipfile'] = 'GeoIP City二进制文件位置。该文件不是Moodle发行版的一部分，需要单独从<a href="http://www.maxmind.com/">MaxMind</a>获取。您可以购买商业版本或者使用免费版。从<a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a>下载并解压到服务器的"{$a}"目录中。';
$string['configgetremoteaddrconf'] = '如果您的服务器在一个反向代理后，您可以设定此项以确定哪条 HTTP 头信息包含了访问者的 IP 地址。头信息按顺序读入，第一条出现的将被使用。';
$string['configgradebookroles'] = '此设置允许您控制谁可以出现在成绩单上。用户至少需要在课程中具有这里的一种角色，才会在该课程的成绩单中显示他的成绩。';
$string['configgradeexport'] = '选择用哪种成绩薄导出格式做为主要格式。被选择的插件将设置和使用每个成绩的“最近导出”字段。例如，已导出的记录可以被标记为“新的”或者“已更新的”。如果您不能确定该如何设置，就什么都别选。';
$string['confighiddenuserfields'] = '选择对教师/管理员以外的用户隐藏的信息。这可以加强对学生隐私的保护。要选择多个字段时请按住CTRL键。';
$string['configidnumber'] = '指定用户是否(a)不需要ID号，(b)要ID号但可留空，(c)必须要ID号。如果给出，它将显示在用户资料中。';
$string['configintro'] = '在此页中您能够设定许多变量，它们让Moodle更好地运行在您的服务器上。不必过多忧虑——默认的设置已能很好地运行，而且您以后也可以回到这里改变设置。';
$string['configintroadmin'] = '在这个页面中，您可以设置您的主管理员帐号，它可以完全控制站点。请确认您为它设定了一个安全的用户名和密码以及一个合法的email地址。您以后可以创建更多的管理员帐号。';
$string['configintrosite'] = '在此页配置首页和这个站点的名称。您随时可以通过首页上的“站点设置”链接返回到此页，修改这些设置。';
$string['configiplookup'] = '当您点击诸如日志中的IP地址(例如34.12.222.93),您将会看到一副显示IP地址确切位置的地图。有多种插件可供选择，它们各有优缺点。';
$string['configkeeptagnamecase'] = '如果您希望用户输入的标签保持原有的大小写，请勾选此选项';
$string['configlang'] = '选择全站的缺省语言。用户可以通过语言菜单或个人资料设定自己的语言，从而覆盖这个设置。';
$string['configlanglist'] = '此处留空将允许用户从您所有已安装的语言种类中任选一种。当然如果您要缩短语言选择菜单，那么可以在此填入语言代码，以逗号(半角)隔开。例如：en,es_es,fr,it。';
$string['configlangmenu'] = '选择要不要在主页、登录页显示通用的语言菜单。这并不影响用户在他们的个人资料中选择偏爱的语言。';
$string['configlangstringcache'] = '将所有语言编译后的字符串缓存在数据目录中。如果您正在翻译Moodle，或在Moodle源码中编辑了字符串，那么您应该关闭此选项。否则，请打开它，来提升性能。';
$string['configlatinexcelexport'] = '选择Excel导出编码方式。';
$string['configlocale'] = '选择全站的区域设置——它会影响所有语言包对显示日期的格式和语言。您的操作系统上必须安装了这种区域设置(比如Linux里的zh_cn.UTF-8或en_US.UTF-8)。大多数情况下，您可以把它留空。';
$string['configloginhttps'] = '启用这个选项会让Moodle在登录时使用安全的https连接，登录之后再返回到普通的http方式以保证速度。注意: 这个设定<strong>需要</strong>Web服务器上的https已经被激活。如果没有激活，<strong>您可能会将自己锁在站点之外</strong>。';
$string['configloglifetime'] = '在此指定保存用户活动日志的时间长短。超出此时间段的日志将被自动删除。最好是将日志保留尽量长的时间，万一需要他们呢？但如果您的服务器非常繁忙且有性能方面的问题，您也许会希望减少保留日志的时间。不建议将天数设为小于30的值，因为这样可能会让统计功能出错。';
$string['configlookahead'] = '向前查看天数';
$string['configmaxbytes'] = '限制整个站点内上传文件的最大尺寸。这个设置会受到PHP设定中post_max_size和upload_max_filesize，以及Apache设定中LimitRequestBody的影响。这个设置也会影响课程和模块中选择文件尺寸的范围。如果选择“服务器限制”，将使用服务器允许的最大值。';
$string['configmaxconsecutiveidentchars'] = '密码中连续相同字符的个数不能超过此值。使用0会禁用这项检查。';
$string['configmaxeditingtime'] = '此参数指定用户在多长时间内可以重新编辑讨论区的贴子。通常30分钟比较合适。';
$string['configmaxevents'] = '向前查找的事件数';
$string['configmaxusersperpage'] = '课程、小组、群组、网站服务等设置中，选择用户时显示的最多显示多少个用户。';
$string['configmessaging'] = '是否应当启用在站点用户之间发送消息的功能?';
$string['configmessagingallowemailoverride'] = '允许用户将电子邮件通知发送到个人资料中的电子邮件地址之外的地址。';
$string['configmessagingdeletereadnotificationsdelay'] = '可以删除已读的通知，以节约空间。通知被阅读多久后可以被删除？';
$string['configmessaginghidereadnotifications'] = '在查看消息历史时，隐藏讨论区发帖之类的阅读通知';
$string['configminpassworddigits'] = '密码中至少要包含多少个数字。';
$string['configminpasswordlength'] = '密码中至少要包含多少个字符。';
$string['configminpasswordlower'] = '密码中至少要包含多少小写字母。';
$string['configminpasswordnonalphanum'] = '密码中至少包含多少个非字母和数字的字符。';
$string['configminpasswordupper'] = '密码至少要包含多少个大写字母。';
$string['configmobilecssurl'] = '用来修改手机界面的CSS文件';
$string['configmodchooserdefault'] = '是否在默认情况下将该活动选择器显示给用户？';
$string['configmycoursesperpage'] = '在用户课程列表中最多显示多少门课程';
$string['configmymoodleredirect'] = '如果开启，则当非管理员用户登录时，直接跳转到/my，并用/my替换掉站点首页。';
$string['configmypagelocked'] = '此设置阻止任何非管理员用户对缺省页面的编辑企图';
$string['confignavcourselimit'] = '限制显示给未登录或从未选课用户的课程数。';
$string['confignavshowallcourses'] = '这个设置决定了参加课程的用户是否可以在导航中看到课程（列出所有课程），除了在我的课程（列出所有参加的课程）中查看之外。';
$string['confignavshowcategories'] = '在导航条和导航版块中显示课程分类。学生已经选课的课程不受此设置影响，它们仍会被直接列在“我的课程”之下，与分类无关。';
$string['confignotifyloginfailures'] = '将登录失败的信息发送给这些选中的用户。这需要启用一个内部的日志存储（如标准日志存储）';
$string['confignotifyloginthreshold'] = '如果发送登录失败的通知，对于一个用户或者IP地址而言，多少次登录失败之后发送通知呢？';
$string['confignotloggedinroleid'] = '未登陆的用户将被当作此角色。访客几乎始终是这里的最佳选择，但是您可能希望建立有更多或更少限制的角色。类似于发帖子这样的事情总是要求用户正确登录。';
$string['configopentogoogle'] = '如果使用该设置，Google将能够以访客的身份进入网站。通过Google搜索而来的访问者也可以以访客的身份登陆网站。这个选项仅对允许访客访问的课程有效。';
$string['configoverride'] = '已在config.php中定义';
$string['configpasswordpolicy'] = '启用该功能，Moodle将检查用户密码是否符合密码使用规则。选中将启用密码规则（选否将忽略密码规则）。';
$string['configpasswordresettime'] = '在多长时间之内，用户必须验证重置密码请求，否则过期失效。通常设为30分钟。';
$string['configpathtoclam'] = 'Clam AV的路径。通常是/usr/bin/clamscan或/usr/bin/clamdscan。设定了这个选项，Clam AV才能运行。';
$string['configpathtodu'] = 'du的路径，如/usr/bin/du。如果您设定了这个选项，则那些显示目录内容的脚本在目录中有很多文件时，可以运行得稍快些。';
$string['configperfdebug'] = '如果启用，在标准主题的页脚会显示性能信息。';
$string['configprofileroles'] = '在用户个人资料和课程成员页面可以看到的角色列表。';
$string['configprofilesforenrolledusersonly'] = '为了防止个人信息被盗用，未加入任何课程的用户的信息将是隐藏的。新用户只有加入至少一门课程后，才可以添加个人信息描述。';
$string['configprotectusernames'] = '缺省情况下，forget_password.php不会显示任何对猜测用户名和email地址有帮助的信息。';
$string['configproxybypass'] = '半角逗号分隔的主机或IP列表。访问它们时不使用代理（例如，192.168.,.mydomain.com）';
$string['configproxyhost'] = '如果此<b>服务器</b>是通过代理服务器(例如防火墙)上网，那么请填入代理的主机名，否则留空。';
$string['configproxypassword'] = '通过代理访问internet密码是必须的，如果没有通过代理可以为空（需要PHP cURL扩展支持）。';
$string['configproxyport'] = '如果此服务器需要使用代理计算机，那么在这里提供代理端口。';
$string['configproxytype'] = 'web代理类型（需要PHP5和支持SOCKS5的cURL扩展的支持）';
$string['configproxyuser'] = '通过代理访问internet用户名是必须的，如果没有通过代理可以为空（需要PHP cURL扩展支持）。';
$string['configquarantinedir'] = '如果您希望Clam AV把受感染的文件转移到一个隔离目录中，那么请在此处指定它。这个目录对于Web服务器必须是可写的。如果您在此处留空或者填写了一个不存在或无法访问的目录，受感染的文件将会被删除。注意末尾不需要斜线。';
$string['configrecaptchaprivatekey'] = '用来在您的Moodle服务器和recaptcha服务器之间通信的字符串。访问 http://www.google.com/recaptcha 为本站申请一个';
$string['configrecaptchapublickey'] = '用来在注册表单中显示reCAPTCHA的字符串。由 http://www.google.com/recaptcha 生成';
$string['configrequestcategoryselection'] = '当请求课程时允许选择课程分类';
$string['configrequestedstudentname'] = '在申请的课程中，用于表示学生(student)的词。';
$string['configrequestedstudentsname'] = '在申请的课程中，用于表示学生的复数形式(students)的词。';
$string['configrequestedteachername'] = '在申请的课程中，用于表示教师(teacher)的词。';
$string['configrequestedteachersname'] = '在申请的课程中，用于表示教师的复数形式(teachers)的词。';
$string['configrequiremodintro'] = '如果您不想强制要求用户输入每个活动的描述，就禁止此选项。';
$string['configrunclamavonupload'] = '当有效时，clam AV将用来扫描全部上传的文件。';
$string['configrunclamonupload'] = '在上传文件时运行Clam AV? 您需要在pathtoclam中填写了正确的路径，此选项才能生效。(Clam AV是一个病毒扫描程序，它是自由软件，可从 http://www.clamav.net/ 获得。';
$string['configsectioninterface'] = '界面';
$string['configsectionmail'] = '邮件';
$string['configsectionmaintenance'] = '管理';
$string['configsectionmisc'] = '杂项';
$string['configsectionoperatingsystem'] = '操作系统';
$string['configsectionpermissions'] = '权限';
$string['configsectionrequestedcourse'] = '课程申请';
$string['configsectionsecurity'] = '安全';
$string['configsectionstats'] = '统计';
$string['configsectionuser'] = '用户';
$string['configsecureforms'] = '当读取表单的数据时，Moodle可以提供更多的安全级别。如果此选项被激活，系统将检查浏览器的HTTP_REFERER变量是否与当前的表单相符。在一些极个别的情况下，这会带来一些麻烦，譬如用户使用防火墙(如Zonealarm)并配置了从Web信息中删除HTTP_REFERER的时候。其症状是遇到表单就再也无法前进了。如果用户在登录页面上发生错误，或许您应当选在关闭这个选项，尽管这样做会使您的站点进一步暴露在暴力密码攻击之下。如果不知道选什么，那就让它保留“是”吧。';
$string['configsessioncookie'] = '此选项用来设定 Moodle 会话所使用的 cookie 的名称。这个选项是可选的，仅仅在一种情况下比较有用：一个站点上运行了多个 Moodle 的拷贝，要避免 cookie 发生混乱。';
$string['configsessioncookiedomain'] = '通过此选项可以设置 Moodle cookie 有效的域名。此选项对于定制 Moodle（如认证或选课插件）非常有用，可以让 Moodle 和另一子域名上的应用共享会话信息。<strong>警告：强烈建议您不要修改此选项——错误的设置将会导致包括管理员在内的所有人都无法登录。</strong>';
$string['configsessioncookiepath'] = '如果您希望修改浏览器发送 Moodle cookie 时使用的地址信息，您可以修改这个选项将其指定为您网站的某个目录。否则缺省情况下会使用“/”。';
$string['configsessiontimeout'] = '如果用户登入本站后空闲了很长时间(没有加载新页面)，那么他们将自动登离(会话结束)。该变量指定这个时间有多长。';
$string['configshowcommentscount'] = '显示评论数量。它会在现实评论链接时增加一次数据库查询';
$string['configshowicalsource'] = '显示iCal事件的来源信息';
$string['configshowsiteparticipantslist'] = '站点中所有的学生和教师将会被列在站点师生名录中。谁可以查看这个列表呢?';
$string['configsitedefaultlicense'] = '网站缺省许可证';
$string['configsitedefaultlicensehelp'] = '在本站发布的资源的缺省许可证';
$string['configsitemaxcategorydepth'] = '课程分类最大层数';
$string['configsitemaxcategorydepthhelp'] = '这个功能指定了当显示类别或组合列表的时候，子类别扩展的最大深度。更深层级别的类别会显示为链接，用户可以通过AJAX请求来展开它们。';
$string['configslasharguments'] = '“斜杠参数” (使用<em>PATH_INFO</em>)对SCORM包和多文件资源的正确显示来说，是必须的。如果你的服务器不支持“斜杠参数”你将无法配置它，这个设置将被禁用。相关的功能将无法使用。<br />注意：未来的Moodle版本中“斜杠参数”将会是必须的。';
$string['configsmartpix'] = '将此项打开，服务器将通过php脚本查找当前主题风格中的icons（图标）和所有的父类别中主题，接下来查找Moodle主题风格中的pix文件夹。这将减少themes中的图像文件，但是对于此设置，需要系统花费部分性能的代价。';
$string['configstartwday'] = '星期的开始';
$string['configstatsfirstrun'] = '在这里指定<b>第一次</b>cronjob要进行统计时，应当处理多长时间内的日志。如果您的流量很大，并且是在共享的主机上，最好不要处理太旧的日志，这将会耗费大量的时间并占用相当多的资源。(注意对于此设置，一个月=28天。在生成的统计图和报表中，一个月=日历上的一个月。)';
$string['configstatsmaxruntime'] = '统计工作是很耗时的，因此通过这个选项和下面的选项来设定应当在何时开始执行它以及执行的时间。';
$string['configstatsmaxruntime2'] = '统计工作是很耗时的，因此要指定处理一天的统计的最长时间，在cron的一次运行中处理的最长天数是31天。';
$string['configstatsmaxruntime3'] = '计算一天的统计信息所能使用的最长时间。注意统计信息的计算将会给服务器带来很高的负载，在一次计划任务运行中可计算最多多少天的统计信息可在下面设置。';
$string['configstatsruntimedays'] = '每次执行统计最多计算多少天的数据。如果统计信息是最新的，只会处理最后一天的。请根据服务器的负载来设定这一项的值，如果需要较短的计划任务执行时间，可以设定一个较小的值。';
$string['configstatsruntimestart'] = '执行统计工作的计划任务应当何时开始？如果一台服务器上运行着多个Moodle，推荐您分别选择不同的时间。';
$string['configstatsuserthreshold'] = '此设置指定至少要有多少人选课的课程才会被包含在统计计算中。';
$string['configstrictformsrequired'] = '如果启用，可以阻止用户在表单的必填字段中只输入一个空格或换行。';
$string['configstripalltitletags'] = '取消本设置，容许在活动和资源名中使用HTML标签。';
$string['configsupportemail'] = '当用户需要获得一般的帮助时，这个email地址会被发布给他们（例如，当新用户创建自己的帐号时）。如果此地址留空，就不会提供链接地址。';
$string['configsupportname'] = '通过支持email或者web地址提供一般帮助的个人或团体的名字。';
$string['configsupportpage'] = '当用户需要获得一般的帮助时，这个web地址会被发布给他们（例如，当新用户创建自己的帐号时）。如果此地址留空，就不会提供链接地址。';
$string['configthemedesignermode'] = '通常为了提升性能，外观主题的所有图片和CSS都会在浏览器和服务器上缓存很长时间。如果您正在设计主题或编写代码，那么您可以需要关闭这个模式，这样您就能访问到最新的版本。警告：这会使所有用户的访问变慢！另外，您可以可以在主题选择页面手动重置主题缓存。';
$string['configthemelist'] = '此项为空则用户可以使用所有的合法主题风格。如果您希望让可选的主题风格列表短一些，您可以在此指定一些（不要使用空格！）。譬如: standard,orangewhite。';
$string['configtimezone'] = '与时间显示相关的默认时区设置——每个用户也可以在个人设置中优先设定他自己的时区。此处设为“Server timezone”（服务器时区）则Moodle默认使用PHP的服务器时区设置，不过用户个人设置中的“Server timezone”（服务器时区）却表示默认使用此处魔灯服务器的时区设置。建议你更新时区并根据你的地点指定一个时区。';
$string['configuseblogassociations'] = '用户可以将博客与课程或课程活动关联吗？';
$string['configuseexternalyui'] = '使用Yahoo服务器上的在线文件，而不是本地文件。警告：必须要能访问互联网，否则您网站上的AJAX会失效。此设置不兼容使用https的网站。';
$string['configuserquota'] = '用户私人文件区的最大配额（单位：字节）。 {$a->bytes} 字节 == {$a->displaysize}';
$string['configusesitenameforsitepages'] = '如果启用，会用网站简称代替导航中的“网站页面”字符串';
$string['configusetags'] = '在站点中启用标签功能吗？';
$string['configvariables'] = '变量';
$string['configverifychangedemail'] = '在修改email地址时也对域名进行限制。如果关闭此选项，则只在创建用户时限制email地址的域名。';
$string['configvisiblecourses'] = '是否显示在隐藏的课程类别中的课程';
$string['configwarning'] = '小心修改这些选项——不合法的值可能导致错误。';
$string['configyuicomboloading'] = '此选项可以用合并文件的方式优化YUI库的加载。为提升性能，正式服务的网站应该开启这个选项。';
$string['confirmation'] = '确认';
$string['confirmdeletecomments'] = '您将删除评论，确定吗？';
$string['confirmed'] = '已确认';
$string['cookiehttponly'] = '只使用 http cookies';
$string['cookiesecure'] = '只使用安全的 cookies';
$string['country'] = '默认的国家/地区';
$string['coursecontact'] = '课程联系人';
$string['coursecontact_desc'] = '此设置允许您控制谁会出现在课程描述中。用户必须至少是这些角色中的一个，才能被显示在该课程的课程描述中。';
$string['courselistshortnames'] = '显示扩展课程名称';
$string['courselistshortnames_desc'] = '若启用，显示课程列表或者在管理界面标识课程时，同时显示课程简称和全称。实际上，当您启用此项功能时， 会使用“courseextendednamedisplay”语言字符串，所以您可以通过语言自定义更改显示的内容。';
$string['coursemgmt'] = '管理课程和分类';
$string['courseoverview'] = '课程概述';
$string['courserequestnotify'] = '创建课程申请通知';
$string['courserequestnotifyemail'] = '用户{$a->user}申请创建一个新课程，地址为{$a->link}';
$string['courserequests'] = '课程申请';
$string['courserequestspending'] = '待处理的课程申请';
$string['courses'] = '课程';
$string['coursesperpage'] = '每页课程数';
$string['courseswithsummarieslimit'] = '带有大纲限制的课程';
$string['creatornewroleid'] = '在新课程中课程创建者的角色';
$string['creatornewroleid_help'] = '如果用户还没有获得管理这个新课程的权限，那么该用户就自动使用此角色选课。';
$string['cron'] = '定时任务';
$string['cronclionly'] = 'Cron仅通过命令行执行';
$string['cronerrorclionly'] = 'Sorry，访问这页的权限已经被管理员禁用！';
$string['cronerrorpassword'] = 'Sorry，要访问该页，您必须输入一个密码！';
$string['cron_help'] = 'cron.php维护脚本帮助某些Moodle模块执行定时或周期任务，例如用email发出讨论区新帖子。此脚本必须被定时调用，例如每5分钟执行一次。';
$string['cronremotepassword'] = '访问远程Cron的密码';
$string['cronwarning'] = '已经有至少24个小时没运行<a href="{$a}">cron.php维护脚本</a>了。';
$string['cronwarningcli'] = 'cli/cron.php 维护脚本超过 24 个小时没有运行';
$string['ctyperequired'] = 'Moodle需要ctype PHP扩展，以便改善性能和提高多种语言的兼容性。';
$string['curlcache'] = 'cURL缓存TTL';
$string['curlrequired'] = 'Moodle现在需要PHP的cURL扩展来和Moodle容器通信。';
$string['curltimeoutkbitrate'] = '计算cURL超时时使用的比特率（Kbps）';
$string['curltimeoutkbitrate_help'] = '此设置用来计算处理大cURL请求时的超时时间。此计算的一部分会使用HTTP的HEAD请求获得文件大小。设为0则不会发出这个请求。';
$string['currenttheme'] = '当前主题';
$string['customcheck'] = '其他检查';
$string['custommenu'] = '自定义菜单';
$string['custommenuitems'] = '自定义菜单项';
$string['customusermenuitems'] = '用户菜单条目';
$string['datarootsecurityerror'] = '<p><strong>安全警告！</strong></p><p>您的dataroot目录设在错误的位置，导致它向整个Web公开。这意味着世界上的任何人都可以访问到您的私密文件。其中有些文件还可以被黑客利用，以管理员的身份访问您的网站！</p>
<p>您<em>必须</em>将dataroot目录({$a})移动到一个不在web公开目录下的新位置，并相应地更新config.php中的<code>$CFG->dataroot</code>设置。</p>';
$string['datarootsecuritywarning'] = '您的网站设置可能不安全。请确保您的数据根目录（{$a}）不能直接通过网页访问。';
$string['dbsessions'] = '用数据库处理会话信息';
$string['debug'] = '调试信息';
$string['debugall'] = '所有：显示全部可能的PHP调试信息';
$string['debugdeveloper'] = '开发者：针对开发者的额外moodle调试信息';
$string['debugdisplay'] = '显示调试信息';
$string['debugging'] = '调试';
$string['debugminimal'] = '最少：只显示致命的错误';
$string['debugnone'] = '无：不显示任何错误或警告';
$string['debugnormal'] = '标准：显示错误、警告和注意';
$string['debugpageinfo'] = '显示页面信息';
$string['debugsmtp'] = '调试email发送过程';
$string['debugstringids'] = '显示语言字符串来源';
$string['debugstringids_desc'] = '此选项对翻译人员很有帮助。启用后，如果在URL中加上参数strings=1，那么每个输出的字符串旁都会显示语言文件和字符串id。';
$string['debugvalidators'] = '显示校验链接';
$string['defaultcity'] = '默认城市';
$string['defaultcity_help'] = '在此输入的城市将成为新建用户的缺省城市。';
$string['defaultformatnotset'] = '检测默认课程格式发现错误。请检查网站设置。';
$string['defaulthomepage'] = '给用户的缺省主页';
$string['defaultrequestcategory'] = '申请课程的默认类别';
$string['defaultsettinginfo'] = '默认：{$a}';
$string['defaultuserroleid'] = '所有用户的默认角色';
$string['deleteincompleteusers'] = '几天后删除资料不完整的用户';
$string['deleteunconfirmed'] = '之后删除未完全配置好的用户';
$string['deleteuser'] = '删除用户';
$string['density'] = '密度';
$string['denyemailaddresses'] = '禁止的邮件域名';
$string['development'] = '开发';
$string['devicedetectregex'] = '设备检测正则表达式';
$string['devicedetectregex_desc'] = '<p>缺省情况，Moodle可以检测的设备类型包括：缺省（桌面PC、笔记本等），移动（电话和小型手持设备），平板（iPad、Android平板电脑）和传统（Internet Explorer 6用户）。主题选择器可以给它们分配不同的主题。通过此设置，可以用正则表达式检测其它类型的设备（这些设备的优先级高于缺省类型）。</p>
<p>例如，您可以输入正则表达式“/(MIDP-1.0|Maemo|Windows CE)/”和返回值“featurephone”来检测 一些常见的特殊电话。主题选择器里就会增加一个“featurephone”类型，您就可以设定给这些设备使用的主题。其它电话仍会使用为移动类型的设备选择的主题。</p>';
$string['devicedetectregexexpression'] = '正则表达式';
$string['devicedetectregexvalue'] = '返回值';
$string['devicetype'] = '设备类型';
$string['disableuserimages'] = '禁用自定义头像功能';
$string['displayerrorswarning'] = '建议不要在站点中设置PHP的<em>display_errors</em>，因为这可能会暴露敏感资料。';
$string['displayloginfailures'] = '显示登录失败信息';
$string['dndallowtextandlinks'] = '拖放上传文本/链接';
$string['doclang'] = '说明文档语言';
$string['docroot'] = 'Moodle Docs文档根目录';
$string['doctonewwindow'] = '在新窗口中打开';
$string['download'] = '下载';
$string['edithelpdocs'] = '编辑帮助文档';
$string['editlang'] = '<br>修改</b>';
$string['editorbackgroundcolor'] = '背景色';
$string['editordictionary'] = '编辑字典';
$string['editorfontfamily'] = '字体家族';
$string['editorfontlist'] = '字体列表';
$string['editorfontsize'] = '字体大小';
$string['editorhidebuttons'] = '隐藏按钮';
$string['editorkillword'] = 'Word格式过滤器';
$string['editorspelling'] = '编辑拼法';
$string['editorspellinghelp'] = '启动或关闭拼写检查，当启动后，<strong>aspell</strong> 必须在服务器上安装。';
$string['editstrings'] = '编辑字符串';
$string['emailchangeconfirmation'] = 'Email变更确认';
$string['emoticonalt'] = '替代文字';
$string['emoticoncomponent'] = '图片组件';
$string['emoticonimagename'] = '图片名';
$string['emoticons'] = '表情';
$string['emoticons_desc'] = '此表单定义您的网址使用的表情（或笑脸）。如果将某行所有字段都清空，然后保存此表单，可以删除该行。在最后的空行里填写字段，可以注册一个新表情。重置所有字段到缺省值，请点击上面的链接。

* 文字（必须） - 文字会被表情图片替换。它至少要两个字符长。
* 图片名（必须） - 相对于组件pix文件夹的表情图片文件名，不带扩展名。
* 图片组件（必须） - 提供图标的组件。
* 替代文字（可选） - 表情替代文字的字符串ID和组件。';
$string['emoticonsreset'] = '重置表情设置到缺省值';
$string['emoticontext'] = '文字';
$string['emptysettingvalue'] = '为空';
$string['enableblogs'] = '启用博客';
$string['enablecalendarexport'] = '启用日历导出';
$string['enablecomments'] = '启用评论';
$string['enablecourserequests'] = '可以课程申请';
$string['enablecssoptimiser'] = '启用 CSS 优化器';
$string['enablecssoptimiser_desc'] = '启用后 CSS 将在被缓存前进行优化。优化器会从 CSS 中移除重复规则和样式，以及可以删除的空格，并重新格式化。请注意同时启用此项和主题设计师模式对性能十分不好，但会帮助主题设计师创建优化的 CSS。';
$string['enabled'] = '启用';
$string['enabledevicedetection'] = '启用设备检测';
$string['enablegravatar'] = '启用Gravatar';
$string['enablegravatar_help'] = '启用后，如果用户未上传头像，Moodle会尝试从Gravatar获取用户头像。';
$string['enablemobilewebservice'] = '为移动设备启动网络服务';
$string['enablerecordcache'] = '允许记录缓存';
$string['enablerssfeeds'] = '启用RSS种子';
$string['enablesafebrowserintegration'] = '打开安全考试浏览器的集成';
$string['enablestats'] = '启用统计';
$string['enabletgzbackups'] = '启用新备份格式';
$string['enabletgzbackups_desc'] = '如果启用，将来的备份将以新的.mbz压缩格式（内部以.tar.gz文件格式存储）进行创建。这将移除4GB的备份大小限制，并可能提高性能。还原时支持多种格式，它们之间的区别应该对于用户透明。';
$string['enabletrusttext'] = '启用可信内容';
$string['enablewebservices'] = '启用网络服务';
$string['enablewsdocumentation'] = '网络服务文档';
$string['enrolinstancedefaults'] = '选课实例缺省值';
$string['enrolinstancedefaults_desc'] = '新建课程的缺省选课设置。';
$string['enrolmultipleusers'] = '将这些用户加入课程';
$string['environment'] = '环境';
$string['environmenterrortodo'] = '在继续安装此版本的 Moodle 前，您必需解决上面所列出的所有环境问题（错误）！';
$string['environmenterrorupgrade'] = '警告：在升级此版本的Moodle之前，您应当解决上面列出的所有环境问题（错误）！不解决这些就直接升级的话可能造成严重问题，比如数据丢失。您确定要继续升级吗？';
$string['environmentmustfixsetting'] = '必须修改PHP配置。';
$string['environmentok'] = '您的服务器环境满足所有最低需求。';
$string['environmentrecommendcustomcheck'] = '如果该测试失败，表明存在问题';
$string['environmentrecommendinstall'] = '为了最好的效果，应该安装并启用';
$string['environmentrecommendversion'] = '推荐 {$a->needed} 版本，而您的是 {$a->current}';
$string['environmentrequirecustomcheck'] = '该项测试必须通过';
$string['environmentrequireinstall'] = '必须安装并启用';
$string['environmentrequireversion'] = '需要 {$a->needed} 版本，而您的是 {$a->current}';
$string['environmentsettingok'] = '检测到建议设置';
$string['environmentshouldfixsetting'] = 'PHP配置应更改。';
$string['environmentxmlerror'] = '读取环境数据时错误({$a->error_code})';
$string['errordeletingconfig'] = '删除插件“{$a}”的配置记录时出错。';
$string['errorsetting'] = '无法保存设置：';
$string['errorwithsettings'] = '无法更新一些设置，因为发生了一个错误。';
$string['everyonewhocan'] = '所有可以“{$a}”的用户';
$string['exceptions'] = '异常';
$string['execpathnotallowed'] = 'config.php 里禁止设置可执行及本地路径';
$string['experimental'] = '试验性功能';
$string['experimentalsettings'] = '试验性设置';
$string['extendedusernamechars'] = '允许在用户名中使用扩展字符';
$string['extramemorylimit'] = '额外的 PHP 内存限制';
$string['fatalsessionautostart'] = '<p>检测到严重的配置错误，请通知服务器管理员。</p> <p>管理员要更改PHP的设置，Moodle才能正常运行。</p> <p><code> session.auto_start </code>必须被设置为<code>off</code>。</p> <p>此设置通过编辑服务器上<code>php.ini </code>、Apache/IIS的配置或<code>.htaccess </code>“文件来控制。</ p>';
$string['filecreated'] = '新文件已创建';
$string['filestoredin'] = '保存文件至文件夹';
$string['filestoredinhelp'] = '文件将保存于此';
$string['filterall'] = '过滤全部字符串';
$string['filtermatchoneperpage'] = '每页只过滤一次';
$string['filtermatchonepertext'] = '每篇只过滤一次';
$string['filters'] = '过滤器';
$string['filtersettings'] = '管理过滤器';
$string['filtersettingsgeneral'] = '常规过滤设置';
$string['filteruploadedfiles'] = '过滤上传的文件';
$string['forcelogin'] = '用户必须登录';
$string['forceloginforprofileimage'] = '强制用户登录才能查看用户头像';
$string['forceloginforprofileimage_help'] = '如果启用，只有已登录用户才能查看用户的个人头像，并且所有通知邮件都将使用默认头像。';
$string['forceloginforprofiles'] = '用户必须登录后才能查看个人资料';
$string['forcetimezone'] = '强制时区';
$string['formatuninstallwithcourses'] = '共有 {$a->count} 个课程使用 {$a->format}。它们的格式会改成 {$a->defaultformat} (本站的默认格式). 一些格式相关的数据将会丢失。您确定要继续吗？';
$string['frontpage'] = '首页';
$string['frontpagebackup'] = '首页备份';
$string['frontpagedefaultrole'] = '默认首页角色';
$string['frontpagefilters'] = '首页过滤器';
$string['frontpageloggedin'] = '登录后显示的首页项';
$string['frontpageoverrides'] = '首页权限覆盖';
$string['frontpagequestions'] = '首页试题';
$string['frontpagerestore'] = '首页恢复';
$string['frontpageroles'] = '首页角色';
$string['frontpagesettings'] = '首页设置';
$string['fullnamedisplay'] = '全名格式';
$string['fullnamedisplayprivate'] = '全名格式 - 私人的';
$string['gdrequired'] = 'Moodle 现在需要 GD 扩展来做图片转换。';
$string['generalsettings'] = '一般设置';
$string['geoipfile'] = 'GeoIP城市数据文件';
$string['getremoteaddrconf'] = '被记录的IP地址来源于';
$string['googlemapkey3'] = 'Google 地图的 API V3 密钥';
$string['googlemapkey3_help'] = '您需要输入一个特殊的 key 以使用 Google 地图来显示 IP 地址查询可视化。您可以从 <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a> 获取免费的 key';
$string['gotofirst'] = '转到第一个缺失字符处';
$string['gradebook'] = '成绩单';
$string['gradebookroles'] = '有成绩的角色';
$string['gradeexport'] = '成绩导出的主要方法';
$string['gravatardefaulturl'] = 'Gravatar 默认图像 URL';
$string['gravatardefaulturl_help'] = '如果不能够对于指定的用户找到一个图片，Gravatar 将需要一个默认的图像去展示。请对该图片提供一个完整的 URL 地址。如果您置该选项为空，那么 Moodle 将会对于您当前浏览的页面尝试使用最合适的默认图片。请注意 Gravatar 也有一段代码 <a href="https://en.gravatar.com/site/implement/images/#default-image"> 可以用于产生默认图片。';
$string['groupenrolmentkeypolicy'] = '分组选课密码策略';
$string['groupenrolmentkeypolicy_desc'] = '打开此选项后，Moodle会按照既定的密码策略检查分组选课密码。';
$string['guestroleid'] = '访客的角色';
$string['guestroleid_help'] = '此角色被自动分配给访客用户。它也被临时分配给通过访客选课插件进入课程的未选课用户。';
$string['helpadminseesall'] = '管理员可以看到日历中的所有事件还是只能看到与他们自己有关的事件？';
$string['helpcalendarcustomexport'] = '在日历导出中启用自定义的日期范围导出选项。要使设置生效必须启用日历导出功能。';
$string['helpexportlookahead'] = '对于自定义导出选项，日历需要在导出时查找未来多少天内的活动？';
$string['helpexportlookback'] = '对于自定义导出选项，日历需要在导出时查找过去多少天内的活动？';
$string['helpforcetimezone'] = '您可以允许用户选择他自己的时区或者让所有用户只能使用同一时区。';
$string['helpshowicalsource'] = '若启用，通过 iCal 导入的活动将显示订阅名和链接。';
$string['helpsitemaintenance'] = '用于升级和其它需要的工作';
$string['helpstartofweek'] = '在日历中一周的开始是哪一天?';
$string['helpupcominglookahead'] = '缺省情况下，日历系统查找未来几天内的事件？';
$string['helpupcomingmaxevents'] = '缺省情况下，为用户显示最多几个即将发生事件？';
$string['helpweekenddays'] = '一周中的哪些天是“周末”并用不同的颜色显示?';
$string['hiddenuserfields'] = '隐藏用户字段';
$string['hidefromall'] = '隐瞒所有用户';
$string['hidefromnone'] = '因此没有任何人';
$string['hidefromstudents'] = '隐瞒学生';
$string['htmleditor'] = 'HTML编辑器';
$string['htmleditorsettings'] = 'HTML编辑器设置';
$string['htmlsettings'] = 'HTML设置';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP安全';
$string['hubs'] = '交换中心';
$string['iconvrequired'] = '必须安装ICONV扩展';
$string['ignore'] = '忽略';
$string['includemoduleuserdata'] = '包括模块用户数据';
$string['incompatibleblocks'] = '不兼容的版块';
$string['installhijacked'] = '很抱歉，只有来自最初IP地址的访问才能结束安装。';
$string['installsessionerror'] = '无法初始化 PHP 会话，请确认您的浏览器接受 cookies。';
$string['intlrecommended'] = 'intl扩展可以增强国际化支持，例如符合区域习惯的排序。';
$string['invalidsection'] = '无效小节。';
$string['invaliduserchangeme'] = '用户名“changeme”是保留的用户名，您不能用它创建账号。';
$string['ipblocked'] = '本站现在不可访问。';
$string['ipblocker'] = 'IP封禁器';
$string['ipblockersyntax'] = '每行只放一项。有效的项可以是完整的IP地址（例如<b>192.168.10.1</b>），它只与一个主机匹配；也可以是部分地址（例如<b>192.168.</b>），它与任何用这些数字开头的地址匹配；也可以是CIDR符号（例如<b>231.54.211.0/20</b>）；还可以是一个IP地址范围（例如<b>231.3.56.10-20</b>），指明地址最后一个数字的范围。不支持域名（比如“example.com”）。空行会被忽略。';
$string['iplookup'] = 'IP地址查找';
$string['iplookupgeoplugin'] = '当前正在使用 <a href="http://www.geoplugin.com">geoPlugin</a> 服务来查找地理信息。为得到更准确的结果，我们建议在本地安装 MaxMind GeoLite 数据库。';
$string['iplookupinfo'] = '默认情况下，Moodle使用免费的在线NetGeo (The Internet Geographic Database) 服务器查询IP地址的位置，不幸的是，现在这个数据不能再使用。会返回<em>wildly incorrect</em> 数据。
因此强烈推荐安装免费GeoLite City数据库MaxMind。<br />
IP地址位置会显示在简单的地图或者Google Maps上。请注意，您需要一个Google帐号，并申请免费的 Google Maps API key。';
$string['iplookupmaxmindnote'] = '该产品包括由MaxMind创建的GeoLite数据，可通过 <a href="http://www.maxmind.com/">http://www.maxmind.com/访问</a>。';
$string['keeptagnamecase'] = '保持标签名大小写';
$string['lang'] = '缺省语言';
$string['langcache'] = '缓存语言菜单';
$string['langcache_desc'] = '缓存语言菜单。如果启用缓存语言菜单，那么可用的翻译列表将会被缓存。当您通过内置的语言包管理工具安装或删除语言包时，缓存会自动更新。如果您手动安装一个新的语言包时，您需要使用“清除缓存”来更新已缓存的语言包列表。';
$string['langlist'] = '语言菜单中的语言';
$string['langmenu'] = '显示语言菜单';
$string['langpackwillbeupdated'] = '注意：在升级期间，Moodle将尝试更新语言包。';
$string['langstringcache'] = '缓存所有语言字符串';
$string['languagesettings'] = '语言设置';
$string['latinexcelexport'] = 'Excel编码方式';
$string['legacyfilesaddallowed'] = '允许在旧版本课程文件中添加';
$string['legacyfilesaddallowed_help'] = '如果课程有旧版本课程文件，则允许在其中添加新文件和文件夹。';
$string['legacyfilesinnewcourses'] = '新课程使用旧版课程文件';
$string['legacyfilesinnewcourses_help'] = '缺省情况下，旧版本课程文件区域只在升级过来的课程中存在。请注意，某些特性，比如单个活动的备份/恢复，和此设置不兼容。';
$string['licensesettings'] = '许可证设置';
$string['linkadmincategories'] = '链接管理类别';
$string['linkadmincategories_help'] = '如果启用，管理员设置分类链接会显示在导航中，导向管理分类页面。';
$string['loading'] = '正在加载';
$string['localetext'] = '全站的地区设置';
$string['localstringcustomization'] = '本地定制';
$string['location'] = '位置';
$string['locationsettings'] = '位置设置';
$string['locked'] = '已锁定';
$string['lockoutduration'] = '帐号锁定期限';
$string['lockoutduration_desc'] = '到设置的期限锁定的帐号自动解除锁定。';
$string['lockoutemailbody'] = '因多次无效的登录尝试，你的用户名为 {$a->username}的帐号在 \'{$a->sitename}\'网站上已被锁定。

如需立即解锁帐号请访问以下地址：

{$a->link}

对于大多数邮件客户端，这儿会出现蓝色链接，你只需点击即可。如果点击无效，则需复制、粘帖地址到你的网页浏览器窗口顶部的地址栏里面。

如需帮助，请联系网站管理员，
{$a->admin}';
$string['lockoutemailsubject'] = '你在 {$a} 的账户被锁定';
$string['lockouterrorunlock'] = '提供的帐号解锁信息无效。';
$string['lockoutthreshold'] = '帐号锁定阀值';
$string['lockoutthreshold_desc'] = '设定一个数值，达到多少次登录尝试失败则帐号锁定。这一选项可以防范网络攻击。';
$string['lockoutwindow'] = '帐号锁定监视窗';
$string['lockoutwindow_desc'] = '为帐号锁定阀值设置的监视时间，如果到设置的时间没有失败的尝试，则阀值计数器归零。';
$string['log'] = '日志';
$string['logguests'] = '日志包含访客的访问';
$string['logguests_help'] = '此设置启用后，访客账号的行为会被记入日志。高知名度的网站出于性能考虑，可能要禁用此功能。建议正式使用的网站打开此功能。';
$string['loginhttps'] = '使用HTTPS登录';
$string['loginpageautofocus'] = '登录页面焦点自动移到表单';
$string['loginpageautofocus_help'] = '启用此选项可以让登录页面更方便，但自动移动焦点可能会给无障碍访问带来问题。';
$string['loginpasswordautocomplete'] = '阻止登陆框自动保存密码功能';
$string['loginpasswordautocomplete_help'] = '开启此选项将不再允许用户在浏览器中保存他们的密码。';
$string['loglifetime'] = '保留多久的日志';
$string['logstorenotrequired'] = '不要求日志存储';
$string['logstoressupported'] = '日志存储支持这份报告';
$string['longtimewarning'] = '<b>注意：这个过程可能需要花费较长时间。</b>';
$string['maintenancemode'] = '系统维护中';
$string['maintenancemodeisscheduled'] = '网站将在 {$a->min} 分 {$a->sec} 秒内切换到维护模式';
$string['maintfileopenerror'] = '打开维护文件时发生错误！';
$string['maintinprogress'] = '维护工作进行中...';
$string['manageformats'] = '管理课程格式';
$string['manageformatsgotosettings'] = '能够改变在{$a}中的默认格式';
$string['managelang'] = '管理';
$string['managelicenses'] = '管理许可证';
$string['manageqbehaviours'] = '管理题目行为';
$string['manageqtypes'] = '管理题目类型';
$string['maturity100'] = '测试';
$string['maturity150'] = '待发行';
$string['maturity200'] = '稳定版';
$string['maturity50'] = '内部测试';
$string['maturityallowunstable'] = '提示：您可能需要使用 --allow-unstable 选项来运行这个脚本';
$string['maturitycoreinfo'] = '您的网站正运行不稳定的“{$a}”开发版代码。';
$string['maturitycorewarning'] = '您正要安装或升级的Moodle版本包含不稳定的“{$a}”开发代码，它还不适合在正式网站使用。如果您不想这样，请确认您正在从稳定分支的Moodle代码升级。看Moodle文档了解更多细节。';
$string['maxbytes'] = '上传文件大小的最大值';
$string['maxconsecutiveidentchars'] = '连续相同字符数';
$string['maxeditingtime'] = '编辑帖子的最大时间';
$string['maxtimelimit'] = '最长时间限制';
$string['maxtimelimit_desc'] = '限制Moodle没有输出时最长执行时间，以秒为单位。0表示使用Moodle默认限制。如果你前端服务器有设置时间限制，那要将这个值设的比前端的值低一点这样才会将PHP错误记录到日志中。此设置对CLI脚本无效。';
$string['maxusersperpage'] = '每页的最大用户数';
$string['mbstringrecommended'] = '我们强烈建议您安装时 MBSTRING 库，特别是您的站点使用非拉丁语系的语言时，它可以大大提升系统性能。';
$string['mediapluginavi'] = '过滤.avi文件';
$string['mediapluginflv'] = '过滤.flv文件';
$string['mediapluginimg'] = '启用自动嵌入链接的图片';
$string['mediapluginmov'] = '过滤.mov文件';
$string['mediapluginmp3'] = '过滤.mp3文件';
$string['mediapluginmpg'] = '过滤.mpg文件';
$string['mediapluginogg'] = '打开.ogg过滤器';
$string['mediapluginogv'] = '启用.ogv过滤器';
$string['mediapluginram'] = '过滤.ram文件';
$string['mediapluginrm'] = '过滤.rm文件';
$string['mediapluginrpm'] = '过滤.rpm文件';
$string['mediapluginswf'] = '过滤.swf文件';
$string['mediapluginswfnote'] = '按照缺省的安全标准，普通用户不允许嵌入扩展名为swf的flash文件';
$string['mediapluginwmv'] = '过滤.wmv文件';
$string['mediapluginyoutube'] = '打开YouTube链接过滤器';
$string['messaging'] = '启用消息系统';
$string['messagingallowemailoverride'] = '修改通知邮件';
$string['messagingdeletereadnotificationsdelay'] = '删除已读通知';
$string['messaginghidereadnotifications'] = '隐藏已读通知';
$string['minpassworddigits'] = '数字';
$string['minpasswordlength'] = '密码长度';
$string['minpasswordlower'] = '小写字母';
$string['minpasswordnonalphanum'] = '非文字数字式字符';
$string['minpasswordupper'] = '大写字母';
$string['misc'] = '杂项';
$string['mnetrestore_extusers'] = '<strong>注意：</strong> 这个备份文件包含远程Moodle网络的使用者帐号，该帐号将做在处理过程中存储。';
$string['mnetrestore_extusers_admin'] = '<strong>注意：</strong>您选择的备份文件貌似是来自另一个Moodle，且文件中包含远程Moodle网络用户账户。恢复过程将尝试把所有已有用户和Moodle网络主机匹配。所有不匹配的帐号将自动转换为互联网认证帐号（而不是mnet账号）。恢复日志将记录详情。';
$string['mnetrestore_extusers_mismatch'] = '<strong>注意：</strong> 这个备份文件来自一个不同的MOODLE站点，而且包括远程Moodle网络中的用户帐号，这个操作可能不支持。如果您确定在Moodle安装的时候已经创建好，或者您确定所有需要Moodle网路中主机已经配置完成，您才可以尝试恢复。';
$string['mnetrestore_extusers_noadmin'] = '<strong>注意：</strong>您选择的备份文件貌似是来自另一个Moodle，且文件中包含远程Moodle网络用户账户。您不可以进行这种恢复。请联系网站管理员，或者不带用户信息（模块、文件等）恢复课程。';
$string['mnetrestore_extusers_switchuserauth'] = '远程Moodle网络用户{$a->username}(来自{$a->mnethosturl}) 切换到本地{$a->auth}认证用户';
$string['mobile'] = '手机';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = '缺省的活动选择器';
$string['modeditdefaults'] = '活动设置缺省值';
$string['modeditingmenu'] = '活动编辑菜单';
$string['modeditingmenu_desc'] = '如果启用，当在编辑状态浏览课程时，很多活动的编辑图标会显示在一个下拉菜单里。这样直到有需要时为止可以在编辑课程时将图标隐藏起来，从而减小屏幕上的内容。';
$string['modsettings'] = '管理活动';
$string['modulesecurity'] = '模块安全';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = '强制旧版的多语言语法：没有 class="multilang" 的&lt;span&gt; 和 &lt;lang&gt;';
$string['mustenablestats'] = '本网站的统计功能还未开启。';
$string['mycoursesperpage'] = '课程数';
$string['mydashboard'] = '系统缺省仪表板';
$string['mymoodle'] = '我的主页';
$string['mymoodleredirect'] = '强制用户使用“我的Moodle”';
$string['mypage'] = '缺省我的主页';
$string['mypagelocked'] = '锁定缺省页面';
$string['myprofile'] = '缺省个人资料页';
$string['navadduserpostslinks'] = '添加查看用户帖子的链接';
$string['navadduserpostslinks_help'] = '如果启用，每个用户的导航中都会有两个链接，指向用户在全站或指定课程发起的讨论和发表的帖子。';
$string['navcourselimit'] = '课程限制';
$string['navexpandmycourses'] = '在我的主页中展开我的课程';
$string['navexpandmycourses_desc'] = '如果启用，导航板块中的"我的课程"会在"我的主页"中默认展开。';
$string['navigationupgrade'] = '此次升级引入了两个新的导航版块来替换管理、课程、活动和师生名录版块。如果你已经为这些版块设置了某些特殊的权限，那么你应该检查一下是否一切都在按照你想要的方式工作。';
$string['navshowallcourses'] = '显示所有课程';
$string['navshowcategories'] = '显示课程分类';
$string['navshowfrontpagemods'] = '在导航中显示首页活动';
$string['navshowfrontpagemods_help'] = '如果启用，导航版块的“网站页面”下会显示首页活动。';
$string['navshowfullcoursenames'] = '显示课程全名';
$string['navshowfullcoursenames_help'] = '如果启用，导航将使用课程的全称而不是简称';
$string['navshowmycoursecategories'] = '显示我的课程类别';
$string['navshowmycoursecategories_help'] = '如果启用，用户“我的课程”中的课程会显示在分类中。';
$string['navsortmycoursessort'] = '排序我的课程';
$string['navsortmycoursessort_help'] = '这决定在 “我的课程” 下是按设定的排序顺序罗列所有的课程（如，在网站管理 > 课程 > 管理课程和分类设定的排序顺序）还是按课程设置的字母顺序排序';
$string['neverdeleteruns'] = '从不删除运行';
$string['nobookmarksforuser'] = '您没有任何书签。';
$string['nodatabase'] = '无数据库';
$string['nohttpsformobilewarning'] = '建议启用HTTPS并使用有效的证书。Moodle应用总会先尝试安全连接。';
$string['nomissingstrings'] = '没有缺失的字符';
$string['nonewsettings'] = '此次升级没有增加新的设置。';
$string['nonexistentbookmark'] = '您请求的书签不存在。';
$string['noresults'] = '查无结果';
$string['noroles'] = '无角色';
$string['nosupportedlogstore'] = '找不到支持的日志存储';
$string['notifications'] = '通告';
$string['notifyloginfailures'] = '发送登陆失败的Email到';
$string['notifyloginthreshold'] = '邮件通告的下限';
$string['notloggedinroleid'] = '访问者的角色';
$string['numberofmissingstrings'] = '缺失字符数：{$a}';
$string['numberofstrings'] = '字符串总数：{$a->strings}<br />缺失：{$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['opcacherecommended'] = 'PHP字节码缓存提高性能且降低对内存的要求。Moodle完全支持并建议使用OPC缓存扩展';
$string['opensslrecommended'] = '要使用Moodle网络功能，强烈推荐安装OpenSSL库。';
$string['opentogoogle'] = '向Google开放';
$string['optionalmaintenancemessage'] = '可选的维护信息';
$string['order1'] = '第一';
$string['order2'] = '第二';
$string['order3'] = '第三';
$string['order4'] = '第四';
$string['passwordpolicy'] = '密码规则';
$string['passwordresettime'] = '在多长时间内必须验证重置密码请求';
$string['pathtoclam'] = 'clam AV路径';
$string['pathtodot'] = 'dot的路径';
$string['pathtodot_help'] = 'dot的路径。形式如/usr/bin/dot。您必须安装dot并在这里指向它，才能从DOT文件生成图片。注意，到目前为止，只有Moodle内置的剖析功能（开发->剖析）需要使用它。';
$string['pathtodu'] = 'du的路径';
$string['pathtogs'] = '还原脚本路径';
$string['pathtogs_help'] = '在多数Linux中是 "/usr/bin/gs"。在Windows中它有类似 "c:gsbingswin32c.exe" 的形式 (确保路径中没有空格。如果需要的话，可以把 "gswin32c.exe" 和 "gsdll32.dll" 复制到一个没有空格的新路径中)';
$string['pathtopgdump'] = 'pg_dump 的路径';
$string['pathtopgdumpdesc'] = '只有您的系统上有多个 pg_dump 时您才需要指定这个选项(譬如您您安装了多个版本的 postgresql)。';
$string['pathtopgdumpinvalid'] = 'pg_dump 路径无效──错误的路径或无法执行';
$string['pathtopsql'] = 'psql 的路径';
$string['pathtopsqldesc'] = '只有您的系统上有多个 psql 时您才需要指定这个选项(譬如您您安装了多个版本的 postgresql)。';
$string['pathtopsqlinvalid'] = '无效的 psql 路径──错误的路径或无法执行';
$string['pcreunicodewarning'] = '强烈建议使用兼容 Unicode 字符的 PCRE PHP扩展。';
$string['perfdebug'] = '性能信息';
$string['performance'] = '性能';
$string['pgcluster'] = 'PostgreSQL 集群';
$string['pgclusterdescription'] = '命令行操作时使用的 PostgreSQL version/cluster 选项。如果您的系统上只有一个 postgresql 服务器或您不对此不确定，请将此选项留空。';
$string['phpfloatproblem'] = '在处理PHP浮点数时遇到不期望的问题 - {$a}';
$string['pleaserefreshregistration'] = '您的站点已经注册。你可以随时手动更新注册信息。“站点注册”计划任务默认会自动定期更新你的注册信息。';
$string['pleaseregister'] = '要删除此按钮，请注册您的站点。';
$string['plugin'] = '插件';
$string['plugins'] = '插件';
$string['pluginscheck'] = '插件依赖检查';
$string['pluginscheckfailed'] = '{$a->pluginslist}依赖检查失败';
$string['pluginschecktodo'] = '您必须先解决所有插件的需求，然后再继续安装此版本的Moodle！';
$string['pluginsoverview'] = '插件概况';
$string['pluginsoverviewsee'] = '点击 <a href="{$a->url}">插件预览</a>了解更多详细信息';
$string['profilecategory'] = '类别';
$string['profilecategoryname'] = '类别名（必填）';
$string['profilecategorynamenotunique'] = '该类别名已经使用';
$string['profilecommonsettings'] = '公共设置';
$string['profileconfirmcategorydeletion'] = '类别中{$a}字段将被移入类别上面或下面。<br />您是否希望删除该类别吗？';
$string['profileconfirmfielddeletion'] = '{$a}用户记录字段将会删除<br />您是否希望删除该字段。';
$string['profilecreatecategory'] = '创建一个新的个人资料类别';
$string['profilecreatefield'] = '创建一个新的个人资料字段';
$string['profilecreatenewcategory'] = '创建一个新的类别';
$string['profilecreatenewfield'] = '创建一个新的“{$a}”个人资料字段';
$string['profiledefaultcategory'] = '其它项';
$string['profiledefaultchecked'] = '使用默认值检查';
$string['profiledefaultdata'] = '默认值';
$string['profiledeletecategory'] = '删除一个类别';
$string['profiledeletefield'] = '删除字段“{$a}”';
$string['profiledescription'] = '字段描述';
$string['profiledscript'] = '这个脚本已经被剖析过';
$string['profiledscriptview'] = '查看此脚本的剖析信息';
$string['profileeditcategory'] = '编辑类别{$a}';
$string['profileeditfield'] = '编辑个人资料字段{$a}';
$string['profilefield'] = '个人资料字段';
$string['profilefieldcolumns'] = '列';
$string['profilefieldispassword'] = '这是密码字段吗？';
$string['profilefieldlink'] = '链接';
$string['profilefieldlink_help'] = '要将文字转换成链接，请输入一个包含$$的网址，其中$$将被替换成文字。例如，要将一个Twitter的ID转换成链接，请输入：http://twitter.com/$$。';
$string['profilefieldlinktarget'] = '链接目标';
$string['profilefieldmaxlength'] = '字段长';
$string['profilefieldrows'] = '行';
$string['profilefields'] = '追加管理字段';
$string['profilefieldsize'] = '显示大小';
$string['profileforceunique'] = '数据是唯一吗？';
$string['profileinvaliddata'] = '无效值';
$string['profilelocked'] = '该字段锁定了吗？';
$string['profilemenudefaultnotinoptions'] = '默认值不再选项中';
$string['profilemenunooptions'] = '无菜单选择';
$string['profilemenuoptions'] = '菜单选项（每行一个）';
$string['profilemenutoofewoptions'] = '您必须提供至少两个选项';
$string['profilename'] = '名称';
$string['profilenofieldsdefined'] = '无定义字段';
$string['profilerequired'] = '该字段是否必填';
$string['profileroles'] = '个人资料可见角色';
$string['profilesforenrolledusersonly'] = '只对已选课用户建立个人资料';
$string['profileshortname'] = '简称（必须唯一）';
$string['profileshortnamenotunique'] = '简称已经使用';
$string['profilesignup'] = '在注册页显示？';
$string['profilespecificsettings'] = '细节设置';
$string['profilevisible'] = '该字段对谁可见';
$string['profilevisibleall'] = '对任何人可见';
$string['profilevisible_help'] = '* 不可见 - 只有管理员能查看的私人数据
* 用户可见 - 只有管理员和用户能查看的私人数据
* 所有人可见';
$string['profilevisiblenone'] = '不可见';
$string['profilevisibleprivate'] = '对注册用户可见';
$string['profiling'] = '剖析';
$string['profilingallowall'] = '继续剖析';
$string['profilingallowall_help'] = '如果启用此设置，那么，在任何时刻，你可以在任何地方（PGC）使用PROFILEALL参数来激活对Moodle会话生命周期中执行的所有脚本的剖析。类似的，你可以使用PROFILEALLSTOP参数来停止剖析。';
$string['profilingallowme'] = '选择性剖析';
$string['profilingallowme_help'] = '如果启用此设置，那么，你可以选择性地在任何地方（PGC）使用PROFILEME参数，来剖析该脚本。类似的，你可以使用DONTPROFILEME参数阻止剖析。';
$string['profilingautofrec'] = '自动剖析';
$string['profilingautofrec_help'] = '通过配置此参数，一些请求（基于指定的频率（1/N）随机选择）会被选出、自动分析、保存结果以待进一步分析。注意这种分析方式会使用包含/排除设置。设为0会禁用自动分析。';
$string['profilingenabled'] = '启用剖析';
$string['profilingenabled_help'] = '如果您启用了这个设置，那么剖析就是可用的，然后您就可以通过配置下一个选项来定义它的行为。';
$string['profilingexcluded'] = '排除剖析';
$string['profilingexcluded_help'] = '符合“剖析这些”设置的定义，但不要被剖析的URL列表（逗号分隔，绝对路径但不含wwwroot，可调用）。';
$string['profilingimportprefix'] = '个人简历导入前缀';
$string['profilingimportprefix_desc'] = '为更容易检测，所有输入运行的配置信息需要用特殊的值做为前缀';
$string['profilingincluded'] = '剖析这些';
$string['profilingincluded_help'] = '会被自动剖析的URL列表（逗号分隔，绝对路径但不含wwwroot，可调用）。例如： /index.php，/course/view.php。在任何位置都可以使用* 通配符。例如：/mod/forum/*，/mod/*/view.php。';
$string['profilinglifetime'] = '保留剖析运行数据';
$string['profilinglifetime_help'] = '指定您想保留多久旧的剖析运行信息。旧数据会被周期清理。注意，这不包含任意标记为“参考运行”的剖析运行数据。';
$string['protectusernames'] = '保护用户名';
$string['proxybypass'] = '不使用代理的主机';
$string['proxyhost'] = '代理主机域名';
$string['proxypassword'] = '代理主机密码';
$string['proxyport'] = '代理端口';
$string['proxytype'] = '代理类型';
$string['proxyuser'] = '代理用户名';
$string['purgecaches'] = '清空所有缓存';
$string['purgecachesconfirm'] = 'Moodle可以缓存主题、javascript、语言字符串、已过滤的文本、rss种子和许多其它已处理过的数据。清空这些缓存会从服务器删除这些数据，并强制浏览器重新下载数据，从而使您能看到由当前代码生成的最新数据。清空缓存并没有危险，但在服务器和客户端还没有处理完新信息和缓存好它们之前，您的网站可能会显得有点儿慢。';
$string['purgecachesfinished'] = '所有缓存都被清空了。';
$string['quarantinedir'] = '隔离目录';
$string['question'] = '试题';
$string['questionbehaviours'] = '题目行为';
$string['questioncwqpfscheck'] = '测验中的一个或多个‘随机’试题来至于共享和非共享问题类型中。更多细节报表<a href="{$a->reporturl}">点击这里</a>，或者<a href="{$a->docsurl}">查看Moodle文档</a>。';
$string['questioncwqpfsok'] = '测验中没有‘随机’试题来至于共享和非共享问题类型中。';
$string['questiontype'] = '题目类型';
$string['questiontypes'] = '题目类型';
$string['quizattemptsupgradedmessage'] = '在Moodle 2.1版本有一个重大升级，数据库的升级可能会延后。升级到Moodle 2.7之前，必须完成这个升级。';
$string['recaptchaprivatekey'] = 'ReCAPTCHA私有密钥';
$string['recaptchapublickey'] = 'ReCAPTCHA公有密钥';
$string['register'] = '注册您的网站';
$string['registermoodleorg'] = '当你注册你的网站';
$string['registermoodleorgli1'] = '为了您能得到重要的通知如安全警告和新版本的Moodle，您被添加到一个低频度的邮件列表里。';
$string['registermoodleorgli2'] = '关于您网站的统计数据将被加入到全球的 Moodle 社区{$a}里。';
$string['registermoodleorgli3'] = '您的网站也注册了 Moodle.org  ({$a})，允许有发布课程权限的用户（默认情况下为管理员）可选择是否在Moodle.net 发布课程。';
$string['registerwithmoodleorg'] = '注册你的网站';
$string['registration'] = '注册';
$string['registration_help'] = '推荐您注册您的站点，以便接受安全警告以及访问Moodle.net，我们的课程分享平台。';
$string['registrationwarning'] = '您的网站还没有注册。';
$string['releasenoteslink'] = '想更多了解此版本的 Moodle，请参考<a target="_new" href="{$a}">发行备忘录</a>。';
$string['rememberusername'] = '记住用户名';
$string['rememberusername_desc'] = '如果想在用户登录时用永久 cookie 保存用户名，启用此选项。未经用户同意而使用永久 cookie 可能会引发隐私问题。';
$string['reportsmanage'] = '管理报告';
$string['requestcategoryselection'] = '启用类别选择';
$string['requiredentrieschanged'] = '<strong>重要—请一定阅读<br/>（这条警告只会在升级过程中显示）</strong><br/>为了修复一个bug，使用了“必须完成的条目数”和“查看前必须完成的条目数”的数据库活动的设置将被更改。请查看<a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">数据库模块讨论区</a>了解更多细节。还可以在<a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle文档</a>中了解这些设置的特性。<br/><br/>这个修改影响您系统中的下列数据库：（请马上保存此列表，并在升级结束后，检查这些活动是否仍按照教师期望的方式工作。）<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = '必须输入活动描述';
$string['requires'] = '需要';
$string['restorecourse'] = '恢复课程';
$string['restorernewroleid'] = '操作恢复的用户在课程中的角色';
$string['restorernewroleid_help'] = '如果用户还没有管理恢复的课程的权限，那么用户会被自动选课并分配此角色。如果您不期望做恢复的用户能管理所有他恢复的课程，就选择“无”。';
$string['reverseproxy'] = '反向代理';
$string['riskconfig'] = '用户可以改变网站的设置和行为';
$string['riskconfigshort'] = '配置风险';
$string['riskdataloss'] = '能破坏大量内容或信息的用户';
$string['riskdatalossshort'] = '数据丢失的风险';
$string['riskmanagetrust'] = '用户可以改变其它用户的信任设置';
$string['riskmanagetrustshort'] = '管理信任';
$string['riskpersonal'] = '用户可以获得访问其它用户隐私信息的权力';
$string['riskpersonalshort'] = '隐私风险';
$string['riskspam'] = '用户可以发送垃圾信息给站内用户或其它人';
$string['riskspamshort'] = '垃圾信息风险';
$string['riskxss'] = '用户可以添加允许跨网站描述的（XSS）文件和文本';
$string['riskxssshort'] = 'XSS风险';
$string['roleswithexceptions'] = '{$a->roles}，有以下例外， {$a->exceptions}';
$string['rssglobaldisabled'] = '在服务器层面禁用';
$string['runclamavonupload'] = '对上传的文件使用clam AV';
$string['save'] = '保存';
$string['savechanges'] = '保存更改';
$string['search'] = '搜索';
$string['searchinsettings'] = '在设置中查找';
$string['searchresults'] = '搜索结果';
$string['sectionerror'] = '小节错误！';
$string['secureforms'] = '使用额外的表单安全性';
$string['security'] = '安全';
$string['selectdevice'] = '选择设备';
$string['selecttheme'] = '为{$a}设备选择主题';
$string['server'] = '服务器';
$string['serverchecks'] = '检查服务器';
$string['serverlimit'] = '服务器限制';
$string['sessionautostartwarning'] = '<p>检测到严重的配置错误。请通知服务器管理员。</p><p>为了Moodle的正确运作，需要管理员修改PHP设置。</p><p><code>session.auto_start</code>必须被设为<code>off</code>。</p><p>修改服务器上的<code>php.ini</code>、 Apache/IIS<br />配置或<code>.htaccess</code>文件可以设定它。</p>';
$string['sessioncookie'] = 'Cookie 前缀';
$string['sessioncookiedomain'] = 'Cookie 域名';
$string['sessioncookiepath'] = 'Cookie 路径';
$string['sessionhandling'] = '会话处理';
$string['sessiontimeout'] = '超时';
$string['settingfileuploads'] = '很多功能都需要使用文件上传功能，请在PHP配置中启用这个功能。';
$string['settingmemorylimit'] = '内存不够用，请在PHP设置中设定更高的内存限制。';
$string['settingsafemode'] = 'Moodle和安全模式不完全兼容。请让服务器管理员关闭安全模式。在安全模式下运行Moodle不会获得支持。如果您坚持这么做，那么敬请期待各种问题。';
$string['showcommentscount'] = '显示评论数';
$string['showdetails'] = '显示细节';
$string['showuseridentity'] = '显示用户私人标识';
$string['showuseridentity_desc'] = '在选择或搜索用户，以及显示用户列表的时候，这些字段可以和全名一起显示。它们只会显示给有moodle/site:viewuseridentity权限的用户。缺省情况下是教师和管理员。（选择您的机构强制分配的字段，比如学号，会非常有用。）';
$string['simplexmlrequired'] = 'PHP的SimpleXML扩展现在是运行Moodle必须的组件。';
$string['sitemaintenance'] = '本站正在维护中，目前不能访问。';
$string['sitemaintenancemode'] = '维护模式';
$string['sitemaintenanceoff'] = '维护模式已关闭，网站已经重新正常运行';
$string['sitemaintenanceon'] = '您的网站正处于维护模式(只有管理员可以登录或使用)。';
$string['sitemaintenanceoncli'] = '你的站点当前处理CLI维护模式，不允许WEB访问';
$string['sitemaintenancewarning'] = '您的网站目前处于维护模式(只有管理员可以登录)。要让网站回复到正常模式，请<a href="maintenance.php">关闭维护模式</a>。';
$string['sitemaintenancewarning2'] = '您的网站目前处于维护模式（仅管理员可以登录）。要回复到正常模式，请<a href="{$a}">关闭维护模式</a>。';
$string['sitepolicies'] = '网站策略';
$string['sitepolicy'] = '网站协议URL';
$string['sitepolicyguest'] = '给访客的网站策略链接';
$string['sitepolicyguest_help'] = '如果您有一份网站使用协议，并且需要所有访客在使用此网站前阅读并同意，那么请在此指定它的URL，否则请留空。URL可以指向任何公开的地址。注意：如果设置了强制登录，那么未登录用户的访问会被拒绝。';
$string['sitepolicy_help'] = '如果您有一份网站使用协议，并且要求所有用户在使用此网站前阅读并同意，那么请在此指定它的URL，否则请留空。URL可以指向任何公开的地址。';
$string['sitesectionhelp'] = '如果选择了，那么网站首页会显示一个主题小节。';
$string['slasharguments'] = '使用斜线参数';
$string['slashargumentswarning'] = '建议允许使用带斜线参数。将来会需要。详情请查看文档<a href="https://docs.moodle.org/en/admin/environment/slasharguments">使用带斜线参数</a>。';
$string['smartpix'] = '在小图标（pix）中查找';
$string['soaprecommended'] = '网络服务和某些插件需要安装可选的 SOAP 扩展。';
$string['sort_fullname'] = '课程全称';
$string['sort_idnumber'] = '课程ID';
$string['sort_shortname'] = '课程简称';
$string['sort_sortorder'] = '排序';
$string['spellengine'] = '拼写检查引擎';
$string['spelllanguagelist'] = '拼写检查语言列表';
$string['splrequired'] = 'PHP的SPL扩展现在是运行Moodle的必备条件。';
$string['stats'] = '统计';
$string['statsfirstrun'] = '最长的处理间隔';
$string['statsmaxruntime'] = '最长运行时间';
$string['statsmoodleorg'] = '统计数据';
$string['statsruntimedays'] = '最多处理多少天';
$string['statsruntimestart'] = '运行在';
$string['statsuserthreshold'] = '用户限制';
$string['stickyblocks'] = '粘性版块';
$string['stickyblockscourseview'] = '课程页';
$string['stickyblocksduplicatenotice'] = '如果您增加到这的版块已经存在于单独的页面中时，它将会被复制。<br /> 复制的版块能够被编辑除了一些小的版块。';
$string['stickyblocksmymoodle'] = '我的Moodle';
$string['stickyblockspagetype'] = '要配置的页类型';
$string['strictformsrequired'] = '严格校验必填字段';
$string['stripalltitletags'] = '删除所有活动名中的HTML标签';
$string['supportcontact'] = '技术支持';
$string['supportemail'] = '支持email';
$string['supportname'] = '技术支持';
$string['supportpage'] = '支持页';
$string['suspenduser'] = '停用用户账号';
$string['switchlang'] = '切换语言目录';
$string['systempaths'] = '系统路径';
$string['tablenosave'] = '在上面表格中所做的修改会被自动保存。';
$string['tablesnosave'] = '在上面表格中所做的修改会被自动保存。';
$string['tabselectedtofront'] = '在有tab的表格中，是否将已选择的标签置于顶层。';
$string['tabselectedtofronttext'] = '把被选择的tab置于顶层';
$string['taskautomatedbackup'] = '自动备份';
$string['taskbackupcleanup'] = '清空backup表和日志';
$string['taskbadgescron'] = '奖励勋章';
$string['taskblogcron'] = '同步外部博客';
$string['taskcachecleanup'] = '删除过期缓存';
$string['taskcachecron'] = '后台处理缓存';
$string['taskcalendarcron'] = '发送日历通知';
$string['taskcheckforupdates'] = '检查更新';
$string['taskcompletioncron'] = '奖励勋章';
$string['taskcontextcleanup'] = '清理上下文';
$string['taskcreatecontexts'] = '创建丢失的文本';
$string['taskdeletecachetext'] = '删除旧文本cache记录';
$string['taskdeleteincompleteusers'] = '删除不完整用户';
$string['taskdeleteunconfirmedusers'] = '删除末确认用户';
$string['taskeventscron'] = '对事件的背景处理';
$string['taskfiletrashcleanup'] = '清除垃圾箱中的文件';
$string['taskgradecron'] = '对成绩单的背景处理';
$string['tasklegacycron'] = '对插件进行传统的计划任务处理';
$string['taskmessagingcleanup'] = '消息的背景处理';
$string['taskpasswordresetcleanup'] = '清零密码重置尝试记录';
$string['taskplagiarismcron'] = '抄袭插件的背景处理';
$string['taskportfoliocron'] = '后台处理组合插件';
$string['taskquestioncron'] = '后台处理问题模块';
$string['taskregistrationcron'] = '网站注册';
$string['tasksendfailedloginnotifications'] = '发送登陆失败通知';
$string['tasksendnewuserpasswords'] = '发送新的用户密码';
$string['tasksessioncleanup'] = '清除旧的会话';
$string['taskstatscron'] = '后台统计进程';
$string['tasktagcron'] = '后台分类进程';
$string['tasktempfilecleanup'] = '删除临时文件';
$string['testsiteupgradewarning'] = '你当前正在使用 {$a} 测试站点，你可以使用命令行工具进行升级。';
$string['themedesignermode'] = '主题设计师模式';
$string['themelist'] = '主题列表';
$string['themenoselected'] = '未选择主题';
$string['themeresetcaches'] = '清除主题缓存';
$string['themeselect'] = '更改主题';
$string['themeselector'] = '主题选择器';
$string['themesettings'] = '主题设置';
$string['therewereerrors'] = '在您的数据中有错误';
$string['thirdpartylibrary'] = '开发库名称';
$string['thirdpartylibrarylocation'] = '位置';
$string['thirdpartylibs'] = '第三方库';
$string['timezone'] = '默认时区';
$string['timezoneforced'] = '站点管理员规定必须这样做';
$string['timezoneisforcedto'] = '强制所有用户使用';
$string['timezonenotforced'] = '用户可以选择自己的时区';
$string['tokenizerrecommended'] = '为了改进Moodle网络功能，建议安装PHP Tokenizer扩展库。';
$string['tools'] = '管理工具';
$string['toolsmanage'] = '管理管理工具';
$string['unattendedoperation'] = '无人值守操作';
$string['unbookmarkthispage'] = '删除此页面的书签';
$string['unicoderequired'] = '您必须使用Unicode（UTF-8）存储全部数据。全新安装必须安装在缺省字符集为Unicode的数据库中。如果正在升级，您应该执行UTF-8移植处理（请参考管理员页面）。';
$string['uninstallplugin'] = '卸载';
$string['unlockaccount'] = '帐号解锁';
$string['unsettheme'] = '取消主题';
$string['unsupported'] = '不支持';
$string['unsupporteddbstorageengine'] = '正在使用的数据库存储引擎已不再被支持';
$string['unsupporteddbtablerowformat'] = '你的数据库含有使用Antelope文件格式的表。建议将这些表转换成Barracuda格式。查看文档 <a href="https://docs.moodle.org/en/cli">命令行管理</a> 获得转换InnoDB表到Barracuda的工具详情。';
$string['unsupportedphpversion7'] = '不支持 PHP 7';
$string['unsuspenduser'] = '激活用户账号';
$string['updateaccounts'] = '更新已有帐户';
$string['updateautocheck'] = '自动检查可用更新';
$string['updateautocheck_desc'] = '如果启用，你的网站会自动检查 Moodle 代码和所有附加插件的可用更新。如果有新的更新可用，会发送给网站管理员一个通知。';
$string['updateautodeploy'] = '启用自动部署更新';
$string['updateautodeploy_desc'] = '如果启用，您可以直接从 Moodle 管理员界面中下载和安装可用的更新。注意，您的 Web 服务器进程必须有 Moodle 安装文件夹的写入权限。这会导致潜在的安全风险。';
$string['updateavailable'] = '有一个新版本的 Moodle 可用！';
$string['updateavailabledetailslink'] = '去 {$a->url} 查看更多细节';
$string['updateavailableforplugin'] = '您的一些插件有新版本可用！';
$string['updateavailableinstall'] = '安装这一更新';
$string['updateavailable_moreinfo'] = '更多信息...';
$string['updateavailablenot'] = '您的 Moodle 代码是最新的！';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = '版本 {$a}';
$string['updatecomponent'] = '更新组件';
$string['updateminmaturity'] = '代码成熟度需求';
$string['updateminmaturity_desc'] = '只有当可用代码至少达到选定的成熟度时，才通知有可用更新。不论此设置如何，没有声明代码成熟度的插件总会被报告更新。';
$string['updatenotificationfooter'] = '您的 Moodle 的网站 {$a->siteurl} 配置为自动检查可用的更新。作为网站管理员，您会收到此消息。您可以在网站设置版块的管理部分里禁用自动检查可用更新。您可以在个人设置部分里的私人消息设置里自定义此消息的接受方式。';
$string['updatenotifications'] = '更新通知';
$string['updatenotificationsubject'] = '有 Moodle 的新更新 ({$a->siteurl})';
$string['updatenotifybuilds'] = '有新更新时通知';
$string['updatenotifybuilds_desc'] = '如果启用，当当前版本有新更新时，会报告 Moodle 代码有更新。更新是某个 Moodle 版本的持续改进。它们通常是每周发布一次。如果禁用，只有当更高版本的 Moodle 发布时才会报告有可用的更新。插件更新的检查不受此设置影响。';
$string['upgradeerror'] = '升级{$a->plugin}到版本{$a->version}时发生未知错误，不能继续。';
$string['upgradeforumread'] = '在Moodle 1.5中增加了一项新的功能，它可以跟踪讨论区帖子是否已经阅读。<br />为了使用这个功能，您需要<a href="{$a}">升级您的数据库表</a>。';
$string['upgradeforumreadinfo'] = '在Moodle 1.5中增加了一项新的功能，它可以跟踪论坛帖子是否已经阅读。为了使用这个功能，您需要升级您的表格为已经存在的帖子添加这一信息。如果您的站点很大，这会花费很长的时间(数小时)，并且给数据库服务器带来很大负担，因此最好在夜深人静时再做这个工作。当然，在您的站点升级时，它还是可以继续工作的，用户不会受到任何影响。一旦您开始了这个工作，就必须让它结束(一直开启浏览器)。当然，如果您中途关闭了浏览器：不用担心，重新开始就可以了。<br /><br />您现在要开始升级么？';
$string['upgradelogs'] = '要获得完整功能，您的旧日志必须升级。<a href="{$a}">更多信息</a>';
$string['upgradelogsinfo'] = '保存日志的方式最近有些变动。为了能查看每个活动的旧日志，它们必须被升级。这个过程所花费的时间取决于您的网站（可能长达几小时），并且会给大规模网站的数据库带来很大的负荷。一旦您开始了这个工作，就必须让它结束(一直开启浏览器)。不用担心——日志升级过程中，其他人仍然可以正常地使用网站。<br /><br />打算现在升级日志吗?';
$string['upgradepluginsfirst'] = '建议首先安装好所有可用的更新。';
$string['upgradepluginsinfo'] = '更新插件';
$string['upgradepluginsinfo_help'] = '您的某些插件有可用的更新。你应该在升级数据库前先全部更新好插件。如果您的网站不支持自动更新，则您必须手动下载并在服务器上安装它。';
$string['upgradesettings'] = '新设置';
$string['upgradesettingsintro'] = '您刚升级的Moodle增加了下面所显示的新设置。对缺省设置做必要的修改后，点击页面底部的“保存更改”按钮。';
$string['upgradestalefiles'] = '检测到混合的 Moodle 版本，升级不能继续';
$string['upgradestalefilesinfo'] = 'Moodle 更新过程已暂停，因为在 Moodle 目录内检测到来自至少两个 Moodle 主版本的 PHP 脚本。

这将可能引发重大问题。如果要继续，您必须保证 Moodle 目录只包含一个版本的 Moodle 文件。

建议您采用如下方法清理您的 Moodle 目录：

* 重命名当前的 Moodle 目录为“moodle_old”
* 创建一个只包含来自标准 Moodle 下载软件包、Moodle CVS 或 GIT 仓库的文件的文件夹
* 从“moodle_old”目录移动 config.php 文件和所有非标准插件到新 Moodle 目录

当您有了纯净的 Moodle 目录，刷新页面继续 Moodle 更新进程。

这个警告一般是由解压标准 Moodle 软件包覆盖到旧版本的 Moodle 引发的。虽然这样做小的升级是可以的，但是一定不要这样升级主版本。

这个警告也可能由使用 GIT 仓库时的一次不完整的校验或更新操作引发的。如果是这样，您可能只需要等待操作完成，或者运行适当的清理命令并且重新执行原操作。

您可以在 <a href="{$a}">{$a}</a> 的升级文档中找到更多信息';
$string['upgradestart'] = '现在升级Moodle数据库';
$string['upgradesure'] = '<p>您的Moodle文件已经被修改了，您正在准备自动升级您的服务器到如下版本:</p>
<p><strong>{$a}</strong></p>
<p>您一旦执行了这个操作就不能再返回到先前的版本了。请注意，此过程会消耗一定的时间。</p>
<p>您确定要将此服务器升级到这个版本么？</p>';
$string['upgradetimedout'] = '升级过程超时，请重新升级。';
$string['upgradingdata'] = '升级数据';
$string['upgradinglogs'] = '升级日志';
$string['upgradingversion'] = '正在升级到新版本';
$string['upwards'] = '以上';
$string['useblogassociations'] = '启用关联';
$string['useexternalyui'] = '使用在线的YUI库';
$string['user'] = '用户';
$string['userbulk'] = '批量处理';
$string['userdefaultpreferences'] = '用户默认偏好';
$string['userlist'] = '浏览用户';
$string['userpolicies'] = '用户策略';
$string['userpreference'] = '用户偏好设置';
$string['userquota'] = '用户配额';
$string['users'] = '用户';
$string['usesitenameforsitepages'] = '用网站名表示网站页面';
$string['usetags'] = '启用标签功能';
$string['validateerror'] = '此值无效';
$string['verifychangedemail'] = '修改email时也限制域名';
$string['warningcurrentsetting'] = '当前值：{$a} 无效';
$string['warningiconvbuggy'] = '您的 iconv 库不支持 //IGNORE 标识。您需要安装 mbstring 扩展，用来清理包含无效 UTF-8 字符的字符串。';
$string['webproxy'] = 'Web 代理';
$string['webproxyinfo'] = '如果您的 Moodle 服务器不能直接访问 Internet，请填写下面的选项。对于数据文件、语言包、RSS 种子、时区等的下载，Internet 访问是必须的。<br /><em>强烈推荐您安装 PHP cURL 扩展。</em>';
$string['xmlrpcrecommended'] = '中心服务器通讯功能需要 xmlrpc 扩展。网络服务和 Moodle 网络功能也会用到';
$string['yuicomboloading'] = 'YUI合并加载';
$string['ziprequired'] = 'Moodle 需要 PHP Zip 扩展，info-ZIP 命令行程序和 PclZip 库已经不再使用了。';
