<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'fr', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = 'Remarque : cette app mobile officielle Moodle ne fonctionne qu\'avec les plateformes Moodle qui ont été configurées adéquatement dans ce but. Veuillez contacter l\'administrateur de votre plateforme Moodle si vous avez des difficultés à vous connecter.

Si votre plateforme Moodle a été configurée adéquatement, vous pouvez utiliser cette app pour :

– consulter le contenu de vos cours, même hors ligne ;
– recevoir des notifications instantanées des messages et autres événements ;
– trouver rapidement et contacter d\'autres personnes de vos cours ;
– déposer des images, sons, vidéos et autres fichiers à partir de votre appareil mobile ;
– consulter vos notes ;
– et bien plus encore !

Veuillez consulter http://docs.moodle.org/en/Mobile_app (en anglais) pour les informations les plus récentes.

Nous apprécions vraiment les bonnes critiques sur les fonctionnalités existantes ainsi que toute suggestion sur ce que vous aimeriez pouvoir faire avec cette app.';
$string['mma.calendar.calendarevents'] = 'Événements du calendrier';
$string['mma.calendar.errorloadevent'] = 'Erreur de chargement de l\'événement';
$string['mma.calendar.errorloadevents'] = 'Erreur de chargement des événements';
$string['mma.calendar.noevents'] = 'Il n\'y a pas d\'événement';
$string['mma.calendar.notifications'] = 'Notifications';
$string['mma.coursecompletion.complete'] = 'Terminer';
$string['mma.coursecompletion.completecourse'] = 'Terminer le cours';
$string['mma.coursecompletion.completed'] = 'Terminé';
$string['mma.coursecompletion.completiondate'] = 'Date d\'achèvement';
$string['mma.coursecompletion.couldnotloadreport'] = 'Impossible de charger le rapport d\'achèvement de cours. Veuillez essayer plus tard.';
$string['mma.coursecompletion.coursecompletion'] = 'Achèvement du cours';
$string['mma.coursecompletion.criteria'] = 'Critères';
$string['mma.coursecompletion.criteriagroup'] = 'Groupe de critères';
$string['mma.coursecompletion.criteriarequiredall'] = 'Tous les critères ci-dessous sont requis';
$string['mma.coursecompletion.criteriarequiredany'] = 'Un des critères ci-dessous est requis';
$string['mma.coursecompletion.inprogress'] = 'En cours';
$string['mma.coursecompletion.manualselfcompletion'] = 'Auto-achèvement manuel';
$string['mma.coursecompletion.notyetstarted'] = 'Pas encore commencé';
$string['mma.coursecompletion.pending'] = 'En attente';
$string['mma.coursecompletion.required'] = 'Requis';
$string['mma.coursecompletion.requiredcriteria'] = 'Critères requis';
$string['mma.coursecompletion.requirement'] = 'Condition';
$string['mma.coursecompletion.status'] = 'Statut';
$string['mma.coursecompletion.viewcoursereport'] = 'Afficher le rapport du cours';
$string['mma.files.admindisableddownload'] = 'L\'administrateur de votre Moodle a désactivé le téléchargement des fichiers. Vous pouvez les consulter, mais pas les télécharger.';
$string['mma.files.audio'] = 'Audio';
$string['mma.files.camera'] = 'Caméra';
$string['mma.files.chooseaccountuploadfile'] = 'Sélectionnez un compte vers lequel déposer le fichier';
$string['mma.files.clicktoupload'] = 'Cliquer sur le bouton ci-dessous pour déposer les fichiers dans vos fichiers personnels.';
$string['mma.files.confirmuploadfile'] = 'Vous allez déposer {$a}. Voulez-vous vraiment continuer ?';
$string['mma.files.couldnotloadfiles'] = 'La liste des fichiers n\'a pas pu être chargée.';
$string['mma.files.downloading'] = 'Téléchargement en cours';
$string['mma.files.emptyfilelist'] = 'Aucun fichier à afficher.';
$string['mma.files.errorcapturingaudio'] = 'Erreur d\'enregistrement audio';
$string['mma.files.errorcapturingimage'] = 'Erreur lors de la capture de l\'image';
$string['mma.files.errorcapturingvideo'] = 'Erreur lors de la capture vidéo';
$string['mma.files.errorgettingimagealbum'] = 'Erreur lors de la récupération de l\'image de l\'album';
$string['mma.files.errormustbeonlinetoupload'] = 'Vous devez être en ligne pour déposer des fichiers.';
$string['mma.files.errornoapp'] = 'Vous n\'avez pas d\'app installée pour effectuer cette action.';
$string['mma.files.errorreadingfile'] = 'Erreur de lecture du fichier « {$a} »';
$string['mma.files.errorreceivefilenosites'] = 'Aucun site enregistré. Veuillez ajouter un site avant de déposer un fichier.';
$string['mma.files.errorwhiledownloading'] = 'Une erreur est survenue lors du téléchargement du fichier.';
$string['mma.files.errorwhilerecordingaudio'] = 'Une erreur est survenue lors de l\'enregistrement audio.';
$string['mma.files.errorwhileuploading'] = 'Une erreur est survenue lors du dépôt du fichier.';
$string['mma.files.file'] = 'Fichier';
$string['mma.files.fileuploaded'] = 'Fichier envoyé';
$string['mma.files.myfiles'] = 'Mes fichiers';
$string['mma.files.myprivatefiles'] = 'Mes fichiers personnels';
$string['mma.files.myprivatefilesdesc'] = 'Les fichiers disponibles dans votre zone privée sur cette plateforme Moodle.';
$string['mma.files.photoalbums'] = 'Albums de photos';
$string['mma.files.readingfile'] = 'Lecture du fichier';
$string['mma.files.sitefiles'] = 'Fichiers du site';
$string['mma.files.sitefilesdesc'] = 'Les autres fichiers disponibles sur cette plateforme Moodle.';
$string['mma.files.success'] = 'Succès !';
$string['mma.files.uploadafile'] = 'Déposer un fichier';
$string['mma.files.uploadfiles'] = 'Déposer des fichiers';
$string['mma.files.uploading'] = 'Envoi';
$string['mma.files.video'] = 'Vidéo';
$string['mma.frontpage.frontpage'] = 'Page d\'accueil';
$string['mma.frontpage.sitehome'] = 'Plateforme';
$string['mma.grades.average'] = 'Moyenne';
$string['mma.grades.contributiontocoursetotal'] = 'Contribution au total du cours';
$string['mma.grades.feedback'] = 'Feedback';
$string['mma.grades.grade'] = 'Note';
$string['mma.grades.grades'] = 'Notes';
$string['mma.grades.itemname'] = 'Élément d\'évaluation';
$string['mma.grades.lettergrade'] = 'Note lettre';
$string['mma.grades.percentage'] = 'Pourcentage';
$string['mma.grades.range'] = 'Intervalle';
$string['mma.grades.rank'] = 'Rang';
$string['mma.grades.viewgrades'] = 'Afficher les notes';
$string['mma.grades.weight'] = 'Poids';
$string['mma.messages.contactlistempty'] = 'La liste des contacts est vide';
$string['mma.messages.contactname'] = 'Nom du contact';
$string['mma.messages.errordeletemessage'] = 'Erreur lors de la suppression du message';
$string['mma.messages.errorwhileretrievingcontacts'] = 'Erreur lors de la récupération des contacts depuis le serveur.';
$string['mma.messages.errorwhileretrievingdiscussions'] = 'Erreur lors de la récupération des discussions depuis le serveur.';
$string['mma.messages.errorwhileretrievingmessages'] = 'Erreur lors de la récupération des messages depuis le serveur.';
$string['mma.messages.messagenotsent'] = 'Ce message n\'a pas été envoyé. Veuillez essayer plus tard.';
$string['mma.messages.mustbeonlinetosendmessages'] = 'Vous devez être en ligne pour envoyer des messages';
$string['mma.messages.newmessage'] = 'Nouveau message...';
$string['mma.messages.nomessages'] = 'Aucun message.';
$string['mma.messages.nousersfound'] = 'Aucun utilisateur trouvé';
$string['mma.messages.send'] = 'Envoyer';
$string['mma.messages.type_blocked'] = 'Bloqué';
$string['mma.messages.type_offline'] = 'Hors ligne';
$string['mma.messages.type_online'] = 'En ligne';
$string['mma.messages.type_search'] = 'Résultats de recherche';
$string['mma.messages.type_strangers'] = 'Autres';
$string['mma.mod_assign.userwithid'] = 'Utilisateur d\'Id {{id}}';
$string['mma.mod_chat.errorwhileconnecting'] = 'Erreur lors de la connexion au chat.';
$string['mma.mod_chat.errorwhilegettingchatdata'] = 'Erreur lors de l\'obtention des données de chat.';
$string['mma.mod_chat.errorwhilegettingchatusers'] = 'Erreur lors de l\'obtention des usagers du chat.';
$string['mma.mod_chat.errorwhileretrievingmessages'] = 'Erreur lors de la récupération des messages sur le serveur.';
$string['mma.mod_chat.errorwhilesendingmessage'] = 'Erreur lors de l\'envoi du message.';
$string['mma.mod_chat.messagebeepsyou'] = '{{$a}} vous a bippé !';
$string['mma.mod_chat.messageenter'] = '{{$a}} est entré dans ce chat';
$string['mma.mod_chat.messageexit'] = '{{$a}} a quitté ce chat';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = 'Vous devez être en ligne pour envoyer des messages';
$string['mma.mod_chat.sessionstart'] = 'La prochaine session de chat commencera dans {{$a}}';
$string['mma.mod_choice.errorgetchoice'] = 'Erreur lors de l\'obtention des données du choix.';
$string['mma.mod_choice.expired'] = 'Cette activité est fermée depuis le {{$a}} et n\'est plus disponible';
$string['mma.mod_choice.notopenyet'] = 'Cette activité n\'est pas disponible avant le {{$a}}';
$string['mma.mod_choice.numberofuser'] = 'Nombre de participants';
$string['mma.mod_choice.numberofuserinpercentage'] = 'Pourcentage de participants';
$string['mma.mod_choice.previewonly'] = 'Ceci est une prévisualisation des options disponibles pour cette activité.  Vous ne pourrez pas envoyer votre choix avant le {{$a}}.';
$string['mma.mod_choice.responsesresultgraphdescription'] = '{{number}} % des participants ont choisi l\'option : {{text}}.';
$string['mma.mod_folder.emptyfilelist'] = 'Aucun fichier à afficher.';
$string['mma.mod_folder.errorwhilegettingfolder'] = 'Erreur lors de l\'obtention des données du dossier.';
$string['mma.mod_forum.erroremptysubject'] = 'L\'objet du message ne peut pas être vide';
$string['mma.mod_forum.errorgetforum'] = 'Erreur de récupération des données de forum.';
$string['mma.mod_forum.errorgetgroups'] = 'Erreur lors de l\'obtention des réglages de groupe.';
$string['mma.mod_forum.forumnodiscussionsyet'] = 'Il n\'y a pas encore de message dans ce forum';
$string['mma.mod_forum.group'] = 'Groupe';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}} discussions';
$string['mma.mod_forum.numreplies'] = '{{numreplies}} réponses';
$string['mma.mod_glossary.browsemode'] = 'Parcourir les articles';
$string['mma.mod_glossary.byalphabet'] = 'Alphabétiquement';
$string['mma.mod_glossary.byauthor'] = 'Grouper par auteur';
$string['mma.mod_glossary.bynewestfirst'] = 'Les plus récents en premier';
$string['mma.mod_glossary.byrecentlyupdated'] = 'Modifiés récemment';
$string['mma.mod_glossary.bysearch'] = 'Rechercher';
$string['mma.mod_glossary.entrypendingapproval'] = 'Cet article est en attente d\'approbation';
$string['mma.mod_glossary.errorloadingentries'] = 'Une erreur est survenue lors du chargement des articles.';
$string['mma.mod_glossary.errorloadingentry'] = 'Une erreur est survenue lors du chargement de l\'article.';
$string['mma.mod_glossary.errorloadingglossary'] = 'Une erreur est survenue lors du chargement du glossaire.';
$string['mma.mod_glossary.noentriesfound'] = 'Aucun article trouvé.';
$string['mma.mod_glossary.searchquery'] = 'Texte recherché';
$string['mma.mod_imscp.showmoduledescription'] = 'Afficher la description';
$string['mma.mod_label.label'] = 'Étiquette';
$string['mma.mod_label.taptoview'] = 'Tapoter pour voir l\'étiquette';
$string['mma.mod_lti.errorgetlti'] = 'Erreur lors de l\'obtention des données du module.';
$string['mma.mod_lti.errorinvalidlaunchurl'] = 'L\'URL de lancement n\'est pas valide.';
$string['mma.mod_lti.launchactivity'] = 'Lancer l\'activité';
$string['mma.mod_page.errorwhileloadingthepage'] = 'Erreur lors du chargement du contenu de la page';
$string['mma.mod_resource.errorwhileloadingthecontent'] = 'Erreur lors du chargement du contenu';
$string['mma.mod_resource.openthefile'] = 'Ouvrir le fichier';
$string['mma.mod_scorm.cannotcalculategrade'] = 'La note n\'a pas pu être calculée.';
$string['mma.mod_scorm.dataattemptshown'] = 'Ces données appartiennent à la tentative numéro {{number}}';
$string['mma.mod_scorm.errorcreateofflineattempt'] = 'Une erreur est survenue lors de la création d\'une tentative hors ligne. Veuillez réessayer.';
$string['mma.mod_scorm.errordownloadscorm'] = 'Erreur de téléchargement SCORM : « {{name}} »';
$string['mma.mod_scorm.errorgetscorm'] = 'Erreur de récupération des données SCORM.';
$string['mma.mod_scorm.errorinvalidversion'] = 'L\'application ne supporte que SCORM 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = 'Le téléchargement des paquetages SCORM n\'est pas activé sur cette plateforme Moodle. Veuillez contacter l\'administrateur de la plateforme.';
$string['mma.mod_scorm.errornovalidsco'] = 'Ce SCORM n\'a pas de SCO visible à charger.';
$string['mma.mod_scorm.errorpackagefile'] = 'L\'application ne supporte que les paquetages ZIP.';
$string['mma.mod_scorm.errorsyncscorm'] = 'Une erreur est survenue lors de la synchronisation. Veuillez réessayer.';
$string['mma.mod_scorm.lastsync'] = 'Dernière synchronisation';
$string['mma.mod_scorm.offlineattemptnote'] = 'Cette tentative comporte des données non synchronisées.';
$string['mma.mod_scorm.offlineattemptovermax'] = 'Cette tentative ne peut pas être envoyée, car vous avez dépassé le nombre maximum de tentatives.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = 'Ce SCORM n\'est pas téléchargé. Il sera téléchargé automatiquement dès que vous l\'ouvrirez.';
$string['mma.mod_scorm.scormstatusoutdated'] = 'Ce SCORM a été modifié depuis son dernier téléchargement. Il sera téléchargé automatiquement dès que vous l\'ouvrirez.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = 'Des données hors ligne de la tentative {{number}} ont été supprimées, car elles n\'ont pas pu être intégrées dans une nouvelle tentative.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = 'Certaines tentatives n\'ont pas pu être synchronisées avec la plateforme, car la dernière tentative en ligne n\'est pas terminée. Veuillez d\'abord finir votre tentative en ligne.';
$string['mma.mod_survey.cannotsubmitsurvey'] = 'Un problème est survenu lors de l\'envoi de votre consultation. Veuillez essayer à nouveau.';
$string['mma.mod_survey.errorgetsurvey'] = 'Erreur lors de l\'obtention des données de la consultation.';
$string['mma.mod_survey.results'] = 'Résultats';
$string['mma.mod_url.accessurl'] = 'Accéder à l\'URL';
$string['mma.mod_url.pointingtourl'] = 'URL vers laquelle cette ressource dirige';
$string['mma.mod_wiki.errorloadingpage'] = 'Une erreur est survenue lors du chargement de la page.';
$string['mma.mod_wiki.errornowikiavailable'] = 'Aucun wiki à consulter';
$string['mma.mod_wiki.gowikihome'] = 'Vers l\'accueil du wiki';
$string['mma.mod_wiki.subwiki'] = 'Sous-wiki';
$string['mma.mod_wiki.viewpage'] = 'Consulter la page';
$string['mma.notes.addnewnote'] = 'Ajouter une annotation';
$string['mma.notes.coursenotes'] = 'Annotations de cours';
$string['mma.notes.eventnotecreated'] = 'Annotation créée';
$string['mma.notes.nonotes'] = 'Il n\'y a pas encore d\'annotation de ce type';
$string['mma.notes.note'] = 'Annotation';
$string['mma.notes.notes'] = 'Annotations';
$string['mma.notes.personalnotes'] = 'Annotations personnelles';
$string['mma.notes.publishstate'] = 'Contexte';
$string['mma.notes.sitenotes'] = 'Annotations du site';
$string['mma.notes.userwithid'] = 'Utilisateur d\'identifiant {{id}}';
$string['mma.notifications.errorgetnotifications'] = 'Erreur lors de la récupération des notifications';
$string['mma.notifications.notifications'] = 'Notifications';
$string['mma.notifications.therearentnotificationsyet'] = 'Aucune notification';
$string['mma.participants.noparticipants'] = 'Aucun participant trouvé dans ce cours';
$string['mma.participants.participants'] = 'Participants';
$string['mm.contentlinks.chooseaccount'] = 'Sélectionner un compte';
$string['mm.contentlinks.chooseaccounttoopenlink'] = 'Sélectionner un compte avec lequel ouvrir le lien.';
$string['mm.contentlinks.confirmurlothersite'] = 'Ce lien provient d\'un autre site. Voulez-vous l\'ouvrir ?';
$string['mm.contentlinks.errornoactions'] = 'Impossible de trouver une action à effectuer avec ce lien.';
$string['mm.contentlinks.errornosites'] = 'Impossible de trouver un site pour traiter ce lien.';
$string['mm.core.android'] = 'Android';
$string['mm.core.cannotconnect'] = 'Connexion impossible : vérifiez que l\'URL a été saisie correctement et que votre site utilise Moodle 2.4 ou ultérieur.';
$string['mm.core.cannotdownloadfiles'] = 'Le téléchargement de fichiers est désactivé dans le service mobile de votre plateforme. Veuillez contacter l\'administrateur de la plateforme.';
$string['mm.core.clearsearch'] = 'Effacer la recherche';
$string['mm.core.clicktoseefull'] = 'Cliquer pour voir tout le contenu.';
$string['mm.core.close'] = 'Fermer';
$string['mm.core.completion-alt-auto-fail'] = 'Terminé : {{$a}} (n\'a pas atteint la note pour passer)';
$string['mm.core.completion-alt-auto-n'] = 'Non terminé : {{$a}}';
$string['mm.core.completion-alt-auto-pass'] = 'Terminé : {{$a}} (a atteint la note pour passer)';
$string['mm.core.completion-alt-auto-y'] = 'Terminé : {{$a}}';
$string['mm.core.completion-alt-manual-n'] = 'Non terminé : {{$a}}. Sélectionner pour marquer comme terminé.';
$string['mm.core.completion-alt-manual-y'] = 'Terminé : {{$a}}. Sélectionner pour marquer comme non terminé.';
$string['mm.core.confirmopeninbrowser'] = 'Voulez-vous l\'ouvrir dans le navigateur ?';
$string['mm.core.deleting'] = 'Suppression';
$string['mm.core.dfdayweekmonth'] = 'ddd, D MMM';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'hh[:]mm';
$string['mm.core.downloading'] = 'Téléchargement en cours';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.errorchangecompletion'] = 'Une erreur est survenue lors du changement de l\'état d\'achèvement. Veuillez essayer à nouveau.';
$string['mm.core.errordownloading'] = 'Erreur lors du téléchargement du fichier';
$string['mm.core.errordownloadingsomefiles'] = 'Erreur lors du téléchargement des fichiers du module. Certains fichiers peuvent être manquants.';
$string['mm.core.errorinvalidresponse'] = 'Réponse reçue non valide. Veuillez contacter l\'administrateur de votre plateforme Moodle si l\'erreur persiste.';
$string['mm.core.erroropenfilenoapp'] = 'Erreur lors de l\'ouverture du fichier : aucune app trouvée pour ouvrir ce type de fichier.';
$string['mm.core.erroropenfilenoextension'] = 'Erreur lors de l\'ouverture du fichier : le nom du fichier n\'a pas d\'extension.';
$string['mm.core.erroropenpopup'] = 'Cette activité essaie de s\'ouvrir dans une fenêtre surgissante. Ceci n\'est pas supporté dans cette app.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = 'Image';
$string['mm.core.imageviewer'] = 'Lecteur d\'images';
$string['mm.core.info'] = 'Info';
$string['mm.core.ios'] = 'iOS';
$string['mm.core.loading'] = 'Chargement';
$string['mm.core.lostconnection'] = 'Connexion perdue. Vous devez vous reconnecter. Votre jeton n\'est plus valide';
$string['mm.core.mod_assign'] = 'Devoir';
$string['mm.core.mod_assignment'] = 'Devoir';
$string['mm.core.mod_book'] = 'Livre';
$string['mm.core.mod_chat'] = 'Chat';
$string['mm.core.mod_choice'] = 'Sondage';
$string['mm.core.mod_data'] = 'Base de données';
$string['mm.core.mod_database'] = 'Base de données';
$string['mm.core.mod_external-tool'] = 'Outil externe';
$string['mm.core.mod_feedback'] = 'Feedback';
$string['mm.core.mod_file'] = 'Fichier';
$string['mm.core.mod_folder'] = 'Dossier';
$string['mm.core.mod_forum'] = 'Forum';
$string['mm.core.mod_glossary'] = 'Glossaire';
$string['mm.core.mod_ims'] = 'Paquetage IMS content';
$string['mm.core.mod_imscp'] = 'Paquetage IMS content';
$string['mm.core.mod_label'] = 'Étiquette';
$string['mm.core.mod_lesson'] = 'Leçon';
$string['mm.core.mod_lti'] = 'Outil externe';
$string['mm.core.mod_page'] = 'Page';
$string['mm.core.mod_quiz'] = 'Test';
$string['mm.core.mod_resource'] = 'Ressource';
$string['mm.core.mod_scorm'] = 'Paquetage SCORM';
$string['mm.core.mod_survey'] = 'Consultation';
$string['mm.core.mod_url'] = 'URL';
$string['mm.core.mod_wiki'] = 'Wiki';
$string['mm.core.mod_workshop'] = 'Atelier';
$string['mm.core.mygroups'] = 'Mes groupes';
$string['mm.core.networkerrormsg'] = 'Réseau désactivé ou en panne.';
$string['mm.core.notapplicable'] = 'n/a';
$string['mm.core.numdays'] = '{{$a}} jours';
$string['mm.core.numhours'] = '{{$a}} heures';
$string['mm.core.numminutes'] = '{{$a}} minutes';
$string['mm.core.nummonths'] = '{{$a}} mois';
$string['mm.core.numseconds'] = '{{$a}} secondes';
$string['mm.core.numyears'] = '{{$a}} ans';
$string['mm.core.offline'] = 'Hors ligne';
$string['mm.core.online'] = 'En ligne';
$string['mm.core.openfullimage'] = 'Cliquer ici pour afficher l\'image en pleine grandeur';
$string['mm.core.openinbrowser'] = 'Ouvrir dans le navigateur';
$string['mm.core.othergroups'] = 'Autres groupes';
$string['mm.core.percentagenumber'] = '{{$a}} %';
$string['mm.core.pictureof'] = 'Avatar de {{$a}}';
$string['mm.core.pulltorefresh'] = 'Tirer pour actualiser';
$string['mm.core.requireduserdatamissing'] = 'Il manque certaines données au profil de cet utilisateur. Veuillez compléter ces données dans votre plateforme Moodle et essayer à nouveau.<br />{{$a}}';
$string['mm.core.searching'] = 'Recherche';
$string['mm.core.sending'] = 'Envoi';
$string['mm.core.serverconnection'] = 'Erreur de connexion au serveur';
$string['mm.core.sizetb'] = 'To';
$string['mm.core.success'] = 'Succès !';
$string['mm.core.tablet'] = 'Tablette';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.unexpectederror'] = 'Erreur inattendue. Veuillez fermer et rouvrir l\'app pour continuer';
$string['mm.core.unknown'] = 'Inconnu';
$string['mm.core.unzipping'] = 'Décompression';
$string['mm.core.windowsphone'] = 'Windows phone';
$string['mm.core.wsfunctionnotavailable'] = 'La fonction webservice n\'est pas disponible';
$string['mm.course.activitynotyetviewable'] = 'Cette activité ou ressource n\'est pas encore accessible via l\'app.';
$string['mm.course.activitynotyetviewablegothere'] = 'Cette activité ou ressource n\'est pas encore accessible via l\'app ; cliquer sur le bouton ci-dessous pour y accéder sur la plateforme.';
$string['mm.course.allsections'] = 'Toutes les sections';
$string['mm.course.confirmdownload'] = 'Vous allez télécharger {{size}}. Voulez-vous vraiment continuer ?';
$string['mm.course.confirmdownloadsection'] = 'Vous allez télécharger {{size}}. Voulez-vous vraiment continuer ?';
$string['mm.course.confirmdownloadunknownsize'] = 'Il n\'a pas été possible de calculer la taille du téléchargement. Voulez-vous vraiment effectuer le téléchargement ?';
$string['mm.course.contents'] = 'Contenus';
$string['mm.course.couldnotloadsectioncontent'] = 'Impossible de charger le contenu de la section. Veuillez essayer plus tard.';
$string['mm.course.couldnotloadsections'] = 'Impossible de charger les sections. Veuillez essayer plus tard.';
$string['mm.course.errordownloadingsection'] = 'Erreur lors du téléchargement de la section.';
$string['mm.course.errorgetmodule'] = 'Erreur lors de l\'obtention des données du module.';
$string['mm.course.gotothesite'] = 'Aller sur la plateforme';
$string['mm.course.nocontentavailable'] = 'Aucun contenu disponible actuellement.';
$string['mm.courses.confirmselfenrol'] = 'Voulez-vous vraiment vous inscrire vous-même dans ce cours ?';
$string['mm.courses.enrolme'] = 'M\'inscrire';
$string['mm.courses.errorloadcourses'] = 'Une erreur est survenue lors du chargement des cours.';
$string['mm.courses.errorsearching'] = 'Une erreur est survenue durant la recherche.';
$string['mm.courses.errorselfenrol'] = 'Une erreur est survenue durant l\'auto-inscription';
$string['mm.courses.filter'] = 'Filtre';
$string['mm.courses.filtermycourses'] = 'Filtrer mes cours';
$string['mm.courses.frontpage'] = 'Page d\'accueil';
$string['mm.course.showall'] = 'Tout afficher';
$string['mm.courses.mycourses'] = 'Mes cours';
$string['mm.courses.nocourses'] = 'Aucune information de cours à afficher';
$string['mm.courses.nosearchresults'] = 'Votre recherche n\'a donné aucun résultat';
$string['mm.courses.notenroled'] = 'Vous n\'êtes pas inscrit à ce cours';
$string['mm.courses.notenrollable'] = 'Vous ne pouvez pas vous inscrire vous-même à ce cours.';
$string['mm.courses.password'] = 'Clef d\'inscription';
$string['mm.courses.search'] = 'Rechercher';
$string['mm.courses.searchcourses'] = 'Rechercher des cours';
$string['mm.courses.searchcoursesadvice'] = 'Veuillez utiliser le bouton de recherche de cours pour accéder anonymement à des cours ou vous inscrire vous-même à des cours qui le permettent.';
$string['mm.courses.selfenrolment'] = 'Auto-inscription';
$string['mm.courses.totalcoursesearchresults'] = 'Nombre de cours : {{$a}}';
$string['mm.course.whoops'] = 'Oups !';
$string['mm.login.authenticating'] = 'Authentification';
$string['mm.login.cancel'] = 'Annuler';
$string['mm.login.cannotdownloadfiles'] = 'Le téléchargement des fichiers est désactivé sur votre Moodle et l\'app ne peut pas fonctionner si ce réglage est désactivé. Veuillez contacter l\'administrateur de la plateforme.';
$string['mm.login.confirmdeletesite'] = 'Voulez-vous vraiment supprimer la plateforme {{sitename}} ?';
$string['mm.login.connect'] = 'Connecter !';
$string['mm.login.connecttomoodle'] = 'Connexion à Moodle';
$string['mm.login.credentials'] = 'Données de connexion';
$string['mm.login.credentialsdescription'] = 'Veuillez fournir votre nom d\'utilisateur et votre mot de passe';
$string['mm.login.erroraccesscontrolalloworigin'] = 'La tentative d\'appel « Cross-Origin » que vous avez effectuée a été rejetée. Veuillez consulter https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = 'Une erreur est survenue lors de la suppression de la plateforme. Veuillez essayer plus tard.';
$string['mm.login.errorupdatesite'] = 'Une erreur est survenue lors de la mise à jour du jeton du site.';
$string['mm.login.help'] = 'Aide';
$string['mm.login.helpmelogin'] = '<p>Il existe plusieurs milliers de sites Moodle dans le monde. Cette app vous permet de vous connecter aux sites Moodle qui ont explicitement activé l\'accès via l\'app mobile.</p><p>Si vous ne pouvez pas vous connecter à votre site Moodle, veuillez contacter son administrateur local et lui demander de lire <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Pour tester l\'app dans un Moodle de démonstration, tapez <i>teacher</i> ou <i>student</i> dans le champ <i>Nom d\'utilisateur</i> et tapoter le bouton <b>Ajouter</b>.</p>';
$string['mm.login.invalidaccount'] = 'Veuillez vérifier vos données de connexion ou demander à l\'administrateur de votre site de vérifier sa configuration.';
$string['mm.login.invalidmoodleversion'] = 'Version de Moodle non valide. La version minimale requise est :';
$string['mm.login.invalidsite'] = 'Cette URL n\'est pas valide.';
$string['mm.login.localmobileunexpectedresponse'] = 'La vérification des fonctionnalités additionnelles de Moodle Mobile a envoyé une réponse inattendue. Vous allez être connecté au moyen du service mobile standard.';
$string['mm.login.login'] = 'Connexion';
$string['mm.login.loginbutton'] = 'Se connecter !';
$string['mm.login.logininsiterequired'] = 'Vous devez vous connecter au moyen d\'un navigateur.';
$string['mm.login.mobileservicesnotenabled'] = 'Les Services Moodle ne sont pas activés sur votre site. Veuillez contacter l\'administrateur de votre site si vous pensez qu\'ils devraient être activés.';
$string['mm.login.newsitedescription'] = 'Veuillez saisir l\'URL de votre plateforme Moodle.';
$string['mm.login.notloggedin'] = 'Vous devez être connecté.';
$string['mm.login.password'] = 'Mot de passe';
$string['mm.login.passwordrequired'] = 'Mot de passe requis';
$string['mm.login.reconnect'] = 'Reconnecter';
$string['mm.login.reconnectdescription'] = 'Votre jeton d\'authentification est non valide ou échu. Veuillez vous reconnecter à la plateforme.';
$string['mm.login.reconnectssodescription'] = 'Votre jeton d\'authentification est non valide ou échu. Veuillez vous reconnecter à la plateforme, en vous connectant dans un navigateur.';
$string['mm.login.siteaddress'] = 'Adresse de la plateforme';
$string['mm.login.siteinmaintenance'] = 'Votre site est en mode de maintenance';
$string['mm.login.siteurl'] = 'URL du site';
$string['mm.login.siteurlrequired'] = 'URL du site requis, p. ex. <i>http://www.votre_moodle.fr</i> ou <i>https://www.votre_moodle.fr</i>';
$string['mm.login.username'] = 'Nom d\'utilisateur';
$string['mm.login.usernamerequired'] = 'Nom d\'utilisateur requis';
$string['mm.login.webservicesnotenabled'] = 'Les Services web ne sont pas activés sur votre site. Veuillez contacter l\'administrateur de votre site si vous pensez qu\'ils devraient être activés.';
$string['mm.settings.about'] = 'À propos';
$string['mm.settings.appname'] = 'Moodle Mobile {{version}}';
$string['mm.settings.appready'] = 'Prêt pour l\'app';
$string['mm.settings.cacheexpirationtime'] = 'Durée d\'échéance du cache (ms)';
$string['mm.settings.cordovadevicemodel'] = 'Modèle Cordova Device';
$string['mm.settings.cordovadeviceosversion'] = 'Version OS Cordova Device';
$string['mm.settings.cordovadeviceplatform'] = 'Plateforme Cordova Device';
$string['mm.settings.cordovadeviceuuid'] = 'UUID Cordova Device';
$string['mm.settings.cordovaversion'] = 'Version Cordova';
$string['mm.settings.credits'] = 'Remerciements';
$string['mm.settings.currentlanguage'] = 'Langue actuelle';
$string['mm.settings.deletesitefiles'] = 'Voulez-vous vraiment supprimer les fichiers téléchargés depuis ce site ?';
$string['mm.settings.deletesitefilestitle'] = 'Supprimer les fichiers de site';
$string['mm.settings.development'] = 'Développement';
$string['mm.settings.deviceinfo'] = 'Info sur l\'appareil';
$string['mm.settings.deviceos'] = 'Système d\'exploitation de l\'appareil';
$string['mm.settings.devicewebworkers'] = 'Web workers supportés';
$string['mm.settings.displayformat'] = 'Format d\'affichage';
$string['mm.settings.enabledebugging'] = 'Activer débogage';
$string['mm.settings.enabledownloadsection'] = 'Activer le téléchargement des sections';
$string['mm.settings.enabledownloadsectiondescription'] = 'La désactivation de cette option accélère le chargement des sections de cours.';
$string['mm.settings.enablesyncwifi'] = 'Ne permettre la synchronisation que sur Wi-Fi';
$string['mm.settings.errordeletesitefiles'] = 'Erreur lors de la suppression des fichiers de site.';
$string['mm.settings.errorsyncsite'] = 'Erreur de synchronisation des données. Veuillez vérifier votre connexion internet et essayer plus tard.';
$string['mm.settings.estimatedfreespace'] = 'Espace libre estimé';
$string['mm.settings.filesystemroot'] = 'Racine du système de fichiers';
$string['mm.settings.general'] = 'Général';
$string['mm.settings.language'] = 'Langue';
$string['mm.settings.license'] = 'Licence';
$string['mm.settings.localnotifavailable'] = 'Notifications locales disponibles';
$string['mm.settings.locationhref'] = 'URL webview';
$string['mm.settings.navigatorlanguage'] = 'Langue du navigateur';
$string['mm.settings.navigatoruseragent'] = 'UserAgent du navigateur';
$string['mm.settings.networkstatus'] = 'Statut de la connexion internet';
$string['mm.settings.reportinbackground'] = 'Annoncer les erreurs automatiquement';
$string['mm.settings.settings'] = 'Réglages';
$string['mm.settings.sites'] = 'Plateformes';
$string['mm.settings.spaceusage'] = 'Espace utilisé';
$string['mm.settings.storagetype'] = 'Type de stockage';
$string['mm.settings.success'] = 'Succès !';
$string['mm.settings.synchronization'] = 'Synchronisation';
$string['mm.settings.synchronizenow'] = 'Synchroniser maintenant';
$string['mm.settings.synchronizing'] = 'Synchronisation en cours';
$string['mm.settings.syncsettings'] = 'Réglages de synchronisation';
$string['mm.settings.syncsitesuccess'] = 'Données de site synchronisées et tous les caches vidés.';
$string['mm.settings.total'] = 'Total';
$string['mm.settings.versioncode'] = 'Code de version';
$string['mm.settings.versionname'] = 'Nom de version';
$string['mm.settings.wificonnection'] = 'Connexion WiFi';
$string['mm.sidemenu.appsettings'] = 'Réglages de l\'app';
$string['mm.sidemenu.changesite'] = 'Changer de plateforme';
$string['mm.sidemenu.help'] = 'Aide';
$string['mm.sidemenu.logout'] = 'Déconnexion';
$string['mm.sidemenu.mycourses'] = 'Mes cours';
$string['mm.sidemenu.togglemenu'] = 'Menu';
$string['mm.sidemenu.website'] = 'Site web';
$string['mm.user.address'] = 'Adresse';
$string['mm.user.city'] = 'Ville';
$string['mm.user.contact'] = 'Contact';
$string['mm.user.country'] = 'Pays';
$string['mm.user.description'] = 'Description';
$string['mm.user.details'] = 'Détails';
$string['mm.user.detailsnotavailable'] = 'Vous n\'avez pas accès aux informations de cet utilisateur.';
$string['mm.user.editingteacher'] = 'Enseignant';
$string['mm.user.email'] = 'Courriel';
$string['mm.user.interests'] = 'Intérêts';
$string['mm.user.invaliduser'] = 'Utilisateur non valide.';
$string['mm.user.manager'] = 'Gestionnaire';
$string['mm.user.phone1'] = 'Tél.';
$string['mm.user.phone2'] = 'Mobile';
$string['mm.user.roles'] = 'Rôles';
$string['mm.user.student'] = 'Étudiant';
$string['mm.user.teacher'] = 'Enseignant non-éditeur';
$string['mm.user.viewprofile'] = 'Consulter le profil';
$string['mm.user.webpage'] = 'Page web';
$string['pluginname'] = 'Chaînes de caractères de Moodle Mobile';
