<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'fr', branch 'MOODLE_28_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Ajouter des copies d\'écran';
$string['advertise'] = 'Publier ce cours pour l\'inscription de personnes';
$string['advertised'] = 'Publier';
$string['advertiseon'] = 'Publier ce cours sur {$a}';
$string['advertiseonhub'] = 'Publier ce cours sur un serveur d\'échanges';
$string['advertiseonmoodleorg'] = 'Publier ce cours sur Moodle.org';
$string['advertisepublication_help'] = 'La publication de votre cours sur un serveur d\'échanges permet à d\'autres personnes de le retrouver et de venir s\'y inscrire.';
$string['all'] = 'Tout';
$string['allowglobalsearch'] = 'Publier ce serveur d\'échanges et permettre une recherche globale de tous ses cours';
$string['allowpublicsearch'] = 'Publier ce serveur d\'échanges afin que des utilisateurs puissent s\'y inscrire';
$string['audience'] = 'Public cible';
$string['audienceadmins'] = 'Administrateurs Moodle';
$string['audienceeducators'] = 'Formateurs';
$string['audience_help'] = 'Veuillez sélectionner le public cible de ce cours.';
$string['audiencestudents'] = 'Étudiants';
$string['badgesnumber'] = 'Nombre de badges ({$a})';
$string['badurlformat'] = 'Format d\'URL non valide';
$string['cannotsearchcommunity'] = 'Désolé, vous n\'avez pas les droits d\'accès requis pour voir cette page';
$string['community'] = 'Communauté';
$string['communityremoved'] = 'Ce lien de cours a été retiré de votre liste';
$string['confirmregistration'] = 'Confirmer l\'enregistrement';
$string['contactable'] = 'Contact de la part du public';
$string['contactable_help'] = 'Si oui, le serveur d\'échanges affichera votre adresse de courriel.';
$string['contactemail'] = 'Courriel de contact';
$string['contactname'] = 'Nom de contact';
$string['contactphone'] = 'Téléphone';
$string['contactphone_help'] = 'Les numéros de téléphone ne sont visibles que pour l\'administrateur du serveur d\'échanges et ne sont pas affichés publiquement.';
$string['continue'] = 'Continuer';
$string['contributornames'] = 'Autres contributeurs';
$string['contributornames_help'] = 'Vous pouvez utiliser ce champ pour écrire une liste de toutes les personnes qui ont contribué à ce cours.';
$string['coursemap'] = 'Plan du cours';
$string['coursename'] = 'Nom';
$string['courseprivate'] = 'Privé';
$string['coursepublic'] = 'Public';
$string['coursepublished'] = 'Ce cours a été publié sur « {$a} ».';
$string['courseshortname'] = 'Nom abrégé';
$string['courseshortname_help'] = 'Saisissez un nom abrégé pour votre cours. Ce nom n\'a pas besoin d\'être unique.';
$string['coursesnumber'] = 'Nombre de cours ({$a})';
$string['courseunpublished'] = 'Le cours {$a->courseshortname} n\'est plus publié sur {$a->hubname}.';
$string['courseurl'] = 'URL du cours';
$string['courseurl_help'] = 'L\'URL de votre cours. Cette URL est affichée sous forme de lien dans les résultats de recherche.';
$string['creatorname'] = 'Créateur';
$string['creatorname_help'] = 'La personne qui a créé le cours';
$string['creatornotes'] = 'Notes du créateur';
$string['creatornotes_help'] = 'Les notes du créateur fournissent une aide pour les enseignants sur la façon d\'utiliser le cours.';
$string['deletescreenshots'] = 'Supprimer ces copies d\'écran';
$string['deletescreenshots_help'] = 'Supprimer toutes les copies d\'écrans déposées.';
$string['demourl'] = 'URL démo';
$string['demourl_help'] = 'Tapez une URL de démo de votre cours. C\'est par défaut l\'URL de votre cours. Cette URL de démo est affichée comme un lien dans les résultats de recherche.';
$string['description'] = 'Description';
$string['description_help'] = 'Ce texte descriptif sera affiché dans la liste des cours sur le serveur d\'échanges.';
$string['detectednotexistingpublication'] = '{$a->hubname} mentionne un cours qui n\'existe plus. Veuillez informer l\'administrateur de ce serveur d\'échanges que la publication numéro {$a->id} doit être retirée.';
$string['downloadable'] = 'Téléchargeable';
$string['educationallevel'] = 'Degré scolaire';
$string['educationallevel_help'] = 'Veuillez sélectionner le degré d\'enseignement correspondant le mieux à ce cours.';
$string['edulevelassociation'] = 'Association';
$string['edulevelcorporate'] = 'Entreprise';
$string['edulevelgovernment'] = 'Gouvernement';
$string['edulevelother'] = 'Autre';
$string['edulevelprimary'] = 'Primaire';
$string['edulevelsecondary'] = 'Secondaire';
$string['eduleveltertiary'] = 'Tertiaire (supérieur)';
$string['emailalert'] = 'Notifications par courriel';
$string['emailalert_help'] = 'Si ce réglage est activé, l\'administrateur du serveur d\'échanges vous enverra des courriels sur des problèmes de sécurité ou d\'autres nouvelles importantes.';
$string['enrollable'] = 'Disponible pour inscription';
$string['errorbadimageheightwidth'] = 'La taille de l\'image doit être au maximum de {$a->width} x {$a->height}';
$string['errorcourseinfo'] = 'Une erreur est survenue lors de la récupération des métadonnées du cours depuis le serveur d\'échanges ({$a}). Veuillez réessayer en rechargeant cette page. Sinon, vous pouvez continuer le processus d\'enregistrement avec les métadonnées par défaut suivantes.';
$string['errorcoursepublish'] = 'Une erreur est survenue durant la publication du cours ({$a}). Veuillez réessayer plus tard.';
$string['errorcoursewronglypublished'] = 'Une erreur de publication a été renvoyée par le serveur d\'échanges. Veuillez réessayer plus tard.';
$string['errorcron'] = 'Une erreur est survenue durant la mise à jour de l\'enregistrement sur « {$a->hubname} » ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = 'L\'extension XML-RPC doit être activée pour permettre la mise à jour de l\'enregistrement.';
$string['errorhublisting'] = 'Une erreur est survenue lors de la récupération de la liste des serveurs d\'échanges de Moodle. Veuillez essayer plus tard ({$a}).';
$string['errorlangnotrecognized'] = 'Le code de langue fourni est inconnu. Veuillez contacter {$a}';
$string['errorregistration'] = 'Une erreur est survenue durant l\'enregistrement. Veuillez réessayer plus tard ({$a}).';
$string['errorunpublishcourses'] = 'En raison d\'une erreur, les cours n\'ont pas pu être supprimés du serveur d\'échanges. Réessayez plus tard ou contactez l\'administrateur du serveur d\'échanges.';
$string['existingscreenshotnumber'] = '{$a} copies d\'écran présentes. Vous pourrez voir ces illustrations sur cette page dès que l\'administrateur du serveur d\'échanges aura activé votre cours.';
$string['existingscreenshots'] = 'Copies d\'écran existantes';
$string['forceunregister'] = 'Oui, nettoyer les données d\'enregistrement';
$string['forceunregisterconfirmation'] = 'Votre site ne peut pas atteindre {$a}. Ce serveur d\'échanges est peut-être temporairement arrêté. À moins de vouloir vraiment retirer l\'enregistrement localement, veuillez annuler l\'opération et réessayer plus tard.';
$string['geolocation'] = 'Géolocalisation';
$string['geolocation_help'] = 'Une fonctionnalité future proposera la recherche suivant la localisation. Si vous désirez indiquer le lieu de votre cours, spécifiez ici un couple de valeurs latitude/longitude, par exemple 46.7892,7.1302. Vous pouvez trouver ces valeurs en utilisant par exemple Google Maps.';
$string['hub'] = 'Serveur d\'échanges';
$string['imageurl'] = 'URL de l\'image';
$string['imageurl_help'] = 'Cette image sera affichée sur le serveur d\'échanges. Elle doit être accessible par le serveur à tout moment et sa taille maximale doit être de {$a->width} x {$a->height}';
$string['information'] = 'Information';
$string['issuedbadgesnumber'] = 'Nombre de badges remis ({$a})';
$string['language'] = 'Langue';
$string['language_help'] = 'Langue principale de ce cours';
$string['lasttimechecked'] = 'Dernière vérification';
$string['licence'] = 'Licence';
$string['licence_help'] = 'Sélectionner la licence sous laquelle vous voulez distribuer votre cours.';
$string['logourl'] = 'URL du logo';
$string['modulenumberaverage'] = 'Nombre moyen de modules de cours ({$a})';
$string['moodleorg'] = 'Moodle';
$string['mustselectsubject'] = 'Veuillez choisir un sujet';
$string['name'] = 'Nom';
$string['name_help'] = 'Ce nom sera affiché sur la liste des cours';
$string['neverchecked'] = 'Jamais vérifié';
$string['next'] = 'Suite';
$string['no'] = 'Non';
$string['nocheckstatusfromunreghub'] = 'Le site n\'est pas enregistré sur le serveur d\'échanges. L\'état ne peut pas être vérifié.';
$string['nohubselected'] = 'Aucun serveur d\'échanges sélectionné';
$string['none'] = 'Aucun';
$string['nosearch'] = 'Ne publier ni serveur d\'échanges, ni cours';
$string['notregisteredonhub'] = 'L\'administrateur doit enregistrer ce site sur au moins un serveur d\'échanges avant que vous ne puissiez publier un cours. Contactez l\'administrateur de votre site.';
$string['notregisteredonmoodleorg'] = 'L\'administrateur doit enregistrer ce site sur moodle.org.';
$string['operation'] = 'Actions';
$string['orenterprivatehub'] = 'Saisir l\'URL du serveur d\'échanges privé :';
$string['participantnumberaverage'] = 'Nombre moyen de participants ({$a})';
$string['postaladdress'] = 'Adresse postale';
$string['postaladdress_help'] = 'Adresse postale du site ou de l\'institution représentée par ce site.';
$string['postsnumber'] = 'Nombre de messages ({$a})';
$string['previousregistrationdeleted'] = 'L\'enregistrement précédent a été supprimé de {$a}. Vous pouvez recommencer le processus d\'enregistrement. Merci.';
$string['prioritise'] = 'Rendre prioritaire';
$string['privacy'] = 'Sphère privée';
$string['privacy_help'] = 'Le serveur d\'échanges peut afficher une liste des sites enregistrés. Dans ce cas, vous pourrez choisir si vous voulez que votre site apparaisse sur cette liste.';
$string['private'] = 'Privé';
$string['privatehuburl'] = 'URL du serveur d\'échanges';
$string['publicationinfo'] = 'Information de publication du cours';
$string['publichub'] = 'Serveurs d\'échanges public';
$string['publishcourse'] = 'Publier {$a}';
$string['publishcourseon'] = 'Publier sur {$a}';
$string['publishedon'] = 'Publié sur';
$string['publisheremail'] = 'Courriel du diffuseur ';
$string['publisheremail_help'] = 'L\'adresse de courriel du diffuseur permet à l\'admnistrateur du serveur d\'échanges d\'informer sur les modifications de statuts du cours publié.';
$string['publishername'] = 'Diffuseur';
$string['publishername_help'] = 'Le diffuseur est la personne ou l\'organisation qui publie officiellement le cours. À moins que vous ne le publiez pour le compte de quelqu\'un d\'autre, ce sera vous-même.';
$string['publishon'] = 'Publier sur';
$string['publishonspecifichub'] = 'Publier sur un autre serveur d\'échanges';
$string['questionsnumber'] = 'Nombre de questions ({$a})';
$string['readvertiseon'] = 'Modifier l\'information de publication sur {$a}';
$string['registeredcourses'] = 'Cours enregistrés';
$string['registeredmoodleorg'] = 'Moodle ({$a})';
$string['registeredon'] = 'Le serveur sur lequel votre site est enregistré';
$string['registeredsites'] = 'Sites enregistrés';
$string['registermoochtips'] = 'Ennregistrez votre site afin afin de recevoir les alertes de sécurité et pour accéder à Moodle.net, notre plateforme d\'échange de cours.';
$string['registersite'] = 'Enregistrer sur {$a}';
$string['registerwith'] = 'S\'enregistrer sur un serveur d\'échanges';
$string['registrationconfirmed'] = 'Enregistrement du site confirmé';
$string['registrationconfirmedon'] = 'Merci pour l\'enregistrement de votre plateforme. Les informations d\'enregistrement sont maintenues à jour par la tâche planifiée « Enregistrement du site ».';
$string['registrationinfo'] = 'Information d\'enregistrement';
$string['registrationupdated'] = 'L\'enregistrement a été mis à jour.';
$string['registrationupdatedfailed'] = 'Échec de la mise à jour de l\'enregistrement';
$string['removefromhub'] = 'Supprimer du serveur d\'échanges';
$string['renewregistration'] = 'Renouveler l\'enregistrement';
$string['resourcesnumber'] = 'Nombre de ressources ({$a})';
$string['restartregistration'] = 'Recommencer l\'enregistrement';
$string['roleassignmentsnumber'] = 'Nombre d\'attributions de rôles ({$a})';
$string['screenshots'] = 'Copies d\'écran';
$string['screenshots_help'] = 'Les copies d\'écran du cours seront affichées dans les résultats de recherche.';
$string['search'] = 'Recherche';
$string['selecthub'] = 'Sélectionner un serveur d\'échanges';
$string['selecthubforadvertise'] = 'Sélectionner un serveur d\'échanges pour publication';
$string['selecthubforsharing'] = 'Sélectionner un serveur d\'échanges pour dépôt';
$string['selecthubinfo'] = 'Un serveur d\'échanges communautaire est un serveur publiant une liste de cours partagés. Vous ne pouvez publier des cours que vers des serveurs sur lesquels ce site Moodle est enregistré. Si le serveur d\'échanges que vous voulez n\'est pas indiqué ci-dessous, veuillez contacter l\'administrateur de votre site.';
$string['sendfollowinginfo'] = 'Plus d\'informations';
$string['sendfollowinginfo_help'] = 'Les informations suivantes seront envoyées uniquement pour contribuer aux statistiques globales. Aucune de ces informations ne sera rendue publique.';
$string['sendingcourse'] = 'Envoi du cours';
$string['sendingsize'] = 'Veuillez patienter durant l\'envoi du fichier de cours ({$a->total} Mo)...';
$string['sent'] = '...terminé';
$string['settings'] = 'Réglages';
$string['settingsupdated'] = 'Les réglages ont été mis à jour.';
$string['share'] = 'Partager ce cours pour téléchargement';
$string['shared'] = 'Partagé';
$string['shareon'] = 'Déposer ce cours sur {$a}';
$string['shareonhub'] = 'Déposer ce cours sur un serveur d\'échanges';
$string['sharepublication_help'] = 'Le dépôt d\'un cours sur un serveur d\'échanges permettra à d\'autres personnes de le télécharger et de l\'installer sur leur propre site Moodle.';
$string['siteadmin'] = 'Administrateur';
$string['siteadmin_help'] = 'Le nom complet de l\'administrateur du site.';
$string['sitecountry'] = 'Pays';
$string['sitecountry_help'] = 'Le pays de votre institution.';
$string['sitecreated'] = 'Site créé';
$string['sitedesc'] = 'Description';
$string['sitedesc_help'] = 'Cette description de votre site peut être affichée sur la liste des sites. Veuillez n\'utiliser que du texte pur.';
$string['siteemail'] = 'Adresse de courriel';
$string['siteemail_help'] = 'Une adresse de courriel valide doit être indiquée, de sorte que l\'administrateur du serveur d\'échanges puisse vous contacter si nécessaire. Cette adresse ne sera pas utilisée pour d\'autres raisons. Il est recommandé d\'utiliser ici une adresse en lien avec une fonction, par exemple webmestre@exemple.fr, plutôt qu\'une adresse personnelle.';
$string['sitegeolocation'] = 'Géolocalisation';
$string['sitegeolocation_help'] = 'Une fonctionnalité future proposera dans les serveurs d\'échanges la recherche suivant la localisation. Si vous désirez indiquer le lieu de votre site, spécifiez ici un couple de valeurs latitude/longitude, par exemple 46.7892,7.1302. Vous pouvez trouver ces valeurs en utilisant par exemple Google Maps.';
$string['sitelang'] = 'Langue';
$string['sitelang_help'] = 'La langue de votre site sera affichée dans la liste des sites.';
$string['sitename'] = 'Nom';
$string['sitename_help'] = 'Le nom du site tel qu\'il sera affiché dans la liste du serveur d\'échanges, si celui-ci permet une telle liste.';
$string['sitephone'] = 'Téléphone';
$string['sitephone_help'] = 'Votre numéro de téléphone ne sera visible que de l\'administrateur du serveur d\'échanges.';
$string['siteprivacy'] = 'Confidentialité';
$string['siteprivacylinked'] = 'Publier le site avec un lien';
$string['siteprivacynotpublished'] = 'Ne pas publier le site';
$string['siteprivacypublished'] = 'Publier le nom du site seulement';
$string['siteregconfcomment'] = 'Afin d\'éviter du SPAM sur {$a}, votre site requiert une dernière validation.';
$string['siteregistrationcontact'] = 'Formulaire de contact';
$string['siteregistrationcontact_help'] = 'Si vous l\'autorisez, d\'autres personnes pourront vous contacter au moyen d\'un formulaire sur le serveur d\'échanges. Votre adresse de courriel ne sera jamais visible.';
$string['siteregistrationemail'] = 'Notifications par courriel';
$string['siteregistrationemail_help'] = 'Si vous activez ce réglage, l\'administrateur du serveur d\'échanges pourra vous contacter pour vous informer sur des nouveautés importantes, par exemple des problèmes de sécurité.';
$string['siteregistrationupdated'] = 'Enregistrement du site mis à jour';
$string['siterelease'] = 'Version de Moodle';
$string['siterelease_help'] = 'Le numéro de la version de Moodle de ce site.';
$string['siteupdatedcron'] = 'Enregistrement du site mis à jour sur « {$a} »';
$string['siteupdatesend'] = 'Mise à jour de l\'enregistrement sur les serveurs d\'échanges terminée.';
$string['siteupdatesstart'] = 'Début de la mise à jour de l\'enregistrement sur les serveurs d\'échanges...';
$string['siteurl'] = 'URL du site';
$string['siteurl_help'] = 'L\'URL est l\'adresse de ce site. Si les réglages de confidentialité permettent aux personnes de voir les adresses des sites, cette URL sera alors utilisée.';
$string['siteversion'] = 'Version de Moodle';
$string['siteversion_help'] = 'Le numéro de la version de Moodle de ce site.';
$string['specifichubregistrationdetail'] = 'Vous pouvez aussi enregistrer votre site avec d\'autres serveurs d\'échanges de la communauté.';
$string['statistics'] = 'Confidentialité des statistiques';
$string['status'] = 'Liste du serveur d\'échanges';
$string['statuspublished'] = 'Listé';
$string['statusunpublished'] = 'Non listé';
$string['subject'] = 'Sujet';
$string['subject_help'] = 'Sélectionner le domaine disciplinaire principal du cours.';
$string['tags'] = 'Tags';
$string['tags_help'] = 'Les tags vous aident à classer votre cours et permettent de le trouver plus facilement. Veuillez utiliser des simples mots significatifs et les séparer par des virgules. Exemple : géographie, hydrographie, Suisse';
$string['trustme'] = 'Se fier à moi';
$string['type'] = 'Publié / partagé';
$string['unknownstatus'] = 'Inconnu';
$string['unlistedurl'] = 'URL de serveur d\'échanges non listés';
$string['unprioritise'] = 'Enlever la priorité';
$string['unpublish'] = 'Dépublier';
$string['unpublishalladvertisedcourses'] = 'Retirer tous les cours publiés sur un serveur d\'échanges';
$string['unpublishalluploadedcourses'] = 'Retirer tous les cours déposés sur un serveur d\'échanges';
$string['unpublishconfirmation'] = 'Voulez-vous vraiment retirer le cours « {$a->courseshortname} » du serveur d\'échanges « {$a->hubname} »?';
$string['unpublishcourse'] = 'Dépublier {$a}';
$string['unregister'] = 'Retirer l\'enregistrement';
$string['unregisterconfirmation'] = 'Vous allez retirer votre enregistrement du serveur d\'échanges {$a}. Une fois ceci fait, vous ne pourrez plus gérer les cours que vous y avez laissés. Voulez-vous vraiment retirer votre enregistrement ?';
$string['unregisterfrom'] = 'Retirer l\'enregistrement de {$a}';
$string['unregistrationerror'] = 'Une erreur est survenue au cours de la tentative de retrait de l\'enregistrement du serveur d\'échanges {$a}';
$string['untrustme'] = 'Non fiable';
$string['update'] = 'Mettre à jour';
$string['updatesite'] = 'Mettre à jour l\'enregistrement sur {$a}';
$string['updatestatus'] = 'Vérifier maintenant.';
$string['uploaded'] = 'Déposé';
$string['url'] = 'URL du serveur d\'échanges';
$string['urlalreadyregistered'] = 'Votre site semble déjà enregistré sur ce serveur d\'échanges, ce qui signifie qu\'un problème est survenu. Veuillez contacter l\'administrateur du serveur d\'échanges pour réinitialiser votre enregistrement, afin de pouvoir réessayer.';
$string['usersnumber'] = 'Nombre d\'utilisateurs';
$string['warning'] = 'AVERTISSEMENT';
$string['wrongtoken'] = 'L\'enregistrement a échoué pour une raison inconnue (réseau ?). Veuillez réessayer.';
$string['wrongurlformat'] = 'Format d\'URL incorrect';
$string['xmlrpcdisabledcommunity'] = 'L\'extension XML-RPC n\'est pas activée sur le serveur. Vous ne pouvez pas rechercher ni télécharger des cours.';
$string['xmlrpcdisabledpublish'] = 'L\'extension XML-RPC n\'est pas activée sur le serveur. Vous ne pouvez pas publier ni gérer des cours publiés.';
$string['xmlrpcdisabledregistration'] = 'L\'extension XML-RPC n\'est pas activée sur le serveur. Vous ne pourrez pas retirer votre enregistrement ni modifier votre enregistrement tant que vous ne l\'activerez pas. ';
