<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'pt_br', branch 'MOODLE_28_STABLE'
 *
 * @package   scheduler
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['actions'] = 'Ações';
$string['addappointment'] = 'Adicionar outro estudante';
$string['addcommands'] = 'Adicionar slots';
$string['addondays'] = 'Adicionar compromissos em';
$string['addscheduled'] = 'Adicionar estudante agendado';
$string['addscheduled_help'] = '<h3> Adicionando uma consulta sobre a configuração do slot </h3>
<p> Usando este link, você irá adicionar um usuário à lista de compromissos definidos por esta informação do slot. Pode ser uma maneira simples e rápida para configurar um compromisso coletivo. </p>';
$string['addsession'] = 'Adicionar slots repetidos';
$string['addsingleslot'] = 'Adicionar um único slot';
$string['addslot'] = 'Você pode adicionar slots de compromisso adicionais a qualquer hora.';
$string['addstudenttogroup'] = 'Adicionar esse estudante ao grupo de compromisso';
$string['allappointments'] = 'Todos os compromissos';
$string['allowgroup'] = 'Slot exclusivo - clique para modificar';
$string['allslotsincloseddays'] = 'Todos os slots foram em dias fechados';
$string['allteachersgrading'] = 'Professores podem dar nota a todos os compromissos';
$string['allteachersgrading_desc'] = 'Quando habilitados, professores podem dar nota para compromissos nos quais não estão inscritos.';
$string['alreadyappointed'] = 'Não pode criar compromisso. O slot já está completamente reservado.';
$string['appointagroup'] = 'Compromisso do grupo';
$string['appointagroup_help'] = 'Escolha se você quiser fazer o compromisso apenas para si mesmo, ou para um grupo inteiro.';
$string['appointfor'] = 'Designar para';
$string['appointformygroup'] = 'Designar para meu grupo inteiro';
$string['appointingstudent'] = 'Compromisso para slot';
$string['appointingstudentinnew'] = 'Compromisso para novo slot';
$string['appointmentmode'] = 'Configurando o modo de compromisso';
$string['appointmentmode_help'] = '<p> Você pode escolher aqui algumas variantes na forma como os compromissos podem ser tomados. </p>
<p><ul>
<li><strong> "<emph>n</emph> compromissos neste organizador": </strong> O estudante só pode reservar um número fixo de compromissos nesta atividade. Mesmo se o professor os marca como "visto", eles não serão autorizados a reservar mais reuniões. A única maneira de restaurar a capacidade de um aluno para reservar é excluir os antigos registros "visto". </ Li>
<li><strong>"<emph>n</emph> compromissos em um momento": </strong> O aluno pode reservar um número fixo de compromissos. Quando a reunião acabou e que o professor tem marcado o aluno como "visto", o estudante pode fazer novas nomeações. No entanto, o estudante é limitado a <emph>n</ emph> slots "abertos" (não vistos), em determinado momento.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Compromisso {$a}';
$string['appointmentnotes'] = 'Notas para compromisso';
$string['appointments'] = 'Compromissos';
$string['appointmentsummary'] = 'Compromisso habilitado {$a->startdate} de {$a->starttime} para {$a->endtime} com {$a->teacher}';
$string['appointsolo'] = 'somente eu';
$string['appointsomeone'] = 'Adicionar novo compromisso';
$string['attendable'] = 'Apto';
$string['attendablelbl'] = 'Total de candidatos para agendamento';
$string['attended'] = 'Atendido';
$string['attendedlbl'] = 'Quantidade de alunos atendidos';
$string['attendedslots'] = 'Slots atendidos';
$string['availableslots'] = 'Slots disponíveis';
$string['availableslotsall'] = 'Todos os slots';
$string['availableslotsnotowned'] = 'Não possuído';
$string['availableslotsowned'] = 'Possuído';
$string['bookwithteacher'] = 'Professor';
$string['bookwithteacher_help'] = 'Escolha um professor para o compromisso.';
$string['break'] = 'Intervalo entre slots';
$string['breaknotnegative'] = 'Tamanho do intervalo não deve ser negativo';
$string['canbook1appointment'] = 'Você pode reservar mais um compromisso nesse organizador.';
$string['canbooknappointments'] = 'Você pode reservar {$a} mais compromissos nesse organizador.';
$string['canbooknofurtherappointments'] = 'Você não pode reservar novos compromissos nesse organizador.';
$string['canbooksingleappointment'] = 'Você pode reservar um compromisso nesse organizador.';
$string['canbookunlimitedappointments'] = 'Você pode reservar qualquer número de compromissos nesse organizador.';
$string['cancelledbystudent'] = '{$a} : Compromisso cancelado ou movido por um aluno';
$string['cancelledbyteacher'] = '{$a} : Compromisso cancelado pelo professor';
$string['choice'] = 'Escolha';
$string['chooseexisting'] = 'Escolher existente';
$string['choosingslotstart'] = 'Escolhendo o horário de início';
$string['choosingslotstart_help'] = 'Mude (ou escolha) o horário de início do compromisso. Se esse compromisso colide com alguns outros slots, você será perguntado
se esse slot substitui todos os compromissos conflitantes. Note-se que os novos parâmetros do slot substituirão todas as configurações anteriores.';
$string['comments'] = 'Comentários';
$string['complete'] = 'Reservado';
$string['composeemail'] = 'Escrever e-mail:';
$string['confirmdelete'] = 'A exclusão é definitiva. Continuar mesmo assim?';
$string['conflictingslots'] = 'Conflitante';
$string['course'] = 'Curso';
$string['csvencoding'] = 'Codificação do texto do arquivo';
$string['csvfieldseparator'] = 'Separador de campo para csv';
$string['csvparms'] = 'Parâmetros de formato de csv';
$string['csvrecordseparator'] = 'Separador de registros para csv';
$string['cumulatedduration'] = 'Duração somada dos compromissos';
$string['date'] = 'Data';
$string['datelist'] = 'Resumo';
$string['defaultslotduration'] = 'Duração padrão de slot';
$string['defaultslotduration_help'] = 'Tamanho padrão (em minutos) para os slots de compromissos que você configurou';
$string['deleteallslots'] = 'Excluir todos os slots';
$string['deleteallunusedslots'] = 'Excluir slots não utilizados';
$string['deletecommands'] = 'Excluir slots';
$string['deletemyslots'] = 'Excluir todos os meus slots';
$string['deleteselection'] = 'Excluir slots selecionados';
$string['deletetheseslots'] = 'Excluir esses slots';
$string['deleteunusedslots'] = 'Excluir meus slots não utilizados';
$string['department'] = 'De onde?';
$string['disengage'] = 'Excluir todos os meus compromissos';
$string['displayfrom'] = 'Mostrar compromissos para alunos de';
$string['distributetoslot'] = 'Distribuir para o grupo inteiro';
$string['divide'] = 'Dividir entre slots?';
$string['dontforgetsaveadvice'] = 'Você mudou a lista de pessoas nomeadas. Não se esqueça de salvar essa forma para confirmar as mudanças definitivamente.';
$string['downloadexcel'] = 'Exporta para Excel';
$string['downloads'] = 'Exporta';
$string['duration'] = 'Duração';
$string['durationrange'] = 'Duração de slot deve estar entre {$a->min} e {$a->max} minutos.';
$string['email_applied_html'] = '<p>Um compromisso foi aplicado em {$a->date} às {$a->time},<br/>
pelo aluno <a href="{$a->attendee_url}">{$a->attendee}</a> para o curso:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>usando o organizador intitulado "<em>{$a->module}</em>" no website: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'Um compromisso foi aplicado em {$a->date} às {$a->time},
pelo aluno {$a->attendee} para o curso:

{$a->course_short}: {$a->course}

usando o organizador intitulado "{$a->module}" no website: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Novo compromisso';
$string['email_cancelled_html'] = '<p>Seu compromisso em <strong>{$a->date}</strong> às <strong>{$a->time}</strong>,<br/>
com o aluno <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> para o curso:</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>no organizador intitulado "<em>{$a->module}</em>" no website : <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">foi cancelado ou removido</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Seu compromisso em  {$a->date} às {$a->time},
com o aluno {$a->attendee} para o curso:

{$a->course_short} : {$a->course}

no organizador intitulado "{$a->module}" no website : {$a->site}

foi cancelado ou removido.';
$string['email_cancelled_subject'] = '{$a->course_short}: Compromisso cancelado ou removido por um aluno';
$string['emailreminder'] = 'Envie um lembrete';
$string['email_reminder_html'] = '<p>Você tem um próximo compromisso em <strong>{$a->date}</strong>
de <strong>{$a->time}</strong> até<strong>{$a->endtime}</strong><br/>
com<strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Local: <strong>{$a->location}</strong></p>';
$string['emailreminderondate'] = 'Envie um lembrete em';
$string['email_reminder_plain'] = 'Você tem um próximo compromisso
em {$a->date} de {$a->time} até {$a->endtime}
com {$a->attendant}.

Local: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Lembrete de compromisso';
$string['email_teachercancelled_html'] = '<p>Seu compromisso em <strong>{$a->date}</strong> às <strong>{$a->time} </strong>,<br/>
com o {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> para o curso:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>no organizador "<em>{$a->module}</em>" no website: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">foi cancelado</span></strong>. Por favor, solicite por um novo slot.</p>';
$string['email_teachercancelled_plain'] = 'Seu compromisso em {$a->date} às {$a->time},
com o {$a->staffrole} {$a->attendant} para o curso:

{$a->course_short}: {$a->course}

no organizador intitulado "{$a->module}" no website: {$a->site}

foi cancelado. Por favor, solicite por um novo slot.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Compromisso cancelado pelo professor';
$string['end'] = 'Fim';
$string['enddate'] = 'Repetir slots de tempo até';
$string['endtime'] = 'Tempo final';
$string['event_appointmentlistviewed'] = 'Organizador de lista de compromissos visualizado';
$string['event_bookingadded'] = 'Organizador de agendamentos adicionado';
$string['event_bookingformviewed'] = 'Organizador de formulário de agendamentos visualizado';
$string['event_bookingremoved'] = 'Organizador de agendamentos removido';
$string['exclusive'] = 'Exclusivo';
$string['exclusivity'] = 'Exclusividade';
$string['exclusivityoverload'] = 'O slot possui {$a} alunos agendados, mais do que o permitido por essa configuração.';
$string['explaingeneralconfig'] = 'Essas opções podem ser apenas configuradas no nível do site e aplicarão para todos os organizadores nessa instalação do Moodle.';
$string['finalgrade'] = 'Nota final';
$string['firstslotavailable'] = 'O primeiro slot não será aberto: {$}';
$string['forbidgroup'] = 'Slot de grupo - clique para alterar';
$string['forcewhenoverlap'] = 'Forçar quando coincidir';
$string['forcewhenoverlap_help'] = '<h3>Forçar criação de slot quando slots coincidirem</h3>
<p>Essa configuração determina quantos slots novos serão tratados se eles se coincidirem com outros slots já existentes.</p>
<p>Se habilitado, a sobreposição de slot existente será removida e o novo slot criado.</p>
<p>Se desabilitado, a sobreposição de slot existente será mantida e um novo slot <em>não</em> será criado.</p>';
$string['forcourses'] = 'Escolher alunos em cursos';
$string['friday'] = 'Sexta-feira';
$string['generalconfig'] = 'Configuração geral';
$string['grade'] = 'Nota';
$string['gradingstrategy'] = 'Estratégia de avaliação';
$string['gradingstrategy_help'] = 'Em um organizador, quando alunos podem ter vários compromissos, selecione quantas notas são agregadas.
  O livro de notas pode mostrar entre <ul><li>a nota principal ou</li><li>a nota máxima</li></ul>que o aluno alcançou.';
$string['group'] = 'grupo';
$string['groupbreakdown'] = 'Por tamanho do grupo';
$string['groupscheduling'] = 'Habilitar organização de grupo';
$string['groupsession'] = 'Sessão de grupo';
$string['groupsize'] = 'Tamanho do grupo';
$string['guardtime'] = 'Tempo de proteção';
$string['guardtime_help'] = 'Um tempo de proteção impede que os alunos alterem sua reserva um pouco antes do compromisso.
 <p> Se o tempo de guarda estiver habilitado e configurado para, por exemplo, 2 horas, em seguida, os alunos serão capazes de reservar um slot que começa em menos de 2 horas de tempo a partir de agora, e eles serão incapazes de deixar cair um compromisso se iniciar em menos de 2 horas. </ p>';
$string['guestscantdoanything'] = 'Visitantes não podem fazer nada aqui.';
$string['howtoaddstudents'] = 'Para adicionar alunos a um agendador de escopo global, use a configuração da função para o módulo. <br/> Você também pode usar definições de função do módulo para definir quem atenderá seus alunos.';
$string['ignoreconflicts'] = 'Ignorar conflitos de planejamento';
$string['ignoreconflicts_help'] = 'Se esta opção estiver assinalada, então o slot será movido para a data e hora solicitada, mesmo se existirem outros slots ao mesmo tempo. Isso pode levar à sobreposição de compromissos para alguns professores ou estudantes, e deve, portanto, ser usada com cuidado.';
$string['incourse'] = 'em curso';
$string['introduction'] = 'Introdução';
$string['invitation'] = 'Convite';
$string['invitationtext'] = 'Por favor, escolha um slot de tempo para um compromisso às';
$string['isnonexclusive'] = 'Não-exclusivo';
$string['lengthbreakdown'] = 'Por duração de slot';
$string['limited'] = 'Limitado ({$a} left)';
$string['location'] = 'Localização';
$string['location_help'] = 'Especificar o local da reunião agendada.';
$string['markasseennow'] = 'Marcar como visto agora';
$string['markseen'] = 'Depois de ter tido uma consulta com um aluno, por favor, marcá-los como "Visto" ao clicar na caixa próxima à imagem de usuário acima.';
$string['maxgrade'] = 'Pegar a nota mais alta';
$string['maxstudentlistsize'] = 'Tamanho máximo da lista de alunos';
$string['maxstudentlistsize_desc'] = 'O comprimento máximo da lista dos alunos que precisam criar um compromisso, como mostrado na visão do professor do organizador. Se houver mais alunos do que isso, nenhuma lista será exibida.';
$string['maxstudentsperslot'] = 'Número máximo de alunos por slot';
$string['maxstudentsperslot_desc'] = 'Slots de grupo / slots não-exclusivos podem ter no máximo esse número de alunos. Note que em adição, a configuração "ilimitada" pode sempre ser escolhida para um slot.';
$string['meangrade'] = 'Pegar a nota média';
$string['meetingwith'] = 'Encontro com seu';
$string['meetingwithplural'] = 'Encontro com seu';
$string['minutes'] = 'minutos';
$string['minutesperslot'] = 'minutos por slot';
$string['missingstudents'] = '{$a} alunos ainda precisarão criar um compromisso';
$string['missingstudentsmany'] = '{$a} alunos ainda precisarão criar um compromisso. Nenhuma lista está sendo exibida devido ao tamanho.';
$string['mode'] = 'Modo';
$string['modeappointments'] = 'compromisso(s)';
$string['modeintro'] = 'Alunos podem registrar';
$string['modeoneatatime'] = 'em uma vez';
$string['modeoneonly'] = 'nesse organizador';
$string['modulename'] = 'Organizador';
$string['modulename_help'] = 'A atividade do organizador ajuda você a programar compromissos com seus alunos.

Professores especificar intervalos de tempo para as reuniões, os alunos, em seguida, escolhem um deles no Moodle.
Os professores, por sua vez, podem gravar o resultado da reunião - e, opcionalmente, um grau - dentro do organizador.

Organizador de grupo é suportada; isto é, cada intervalo de tempo pode acomodar vários alunos, e, opcionalmente, é possível programar compromissos para grupos inteiros, ao mesmo tempo.';
$string['modulenameplural'] = 'Agendador';
$string['monday'] = 'Segunda-feira';
$string['move'] = 'Alterar';
$string['moveslot'] = 'Mover slot';
$string['myappointments'] = 'Meus compromissos';
$string['name'] = 'Nome do agendador';
$string['needteachers'] = 'Slots não podem ser adicionados a curso sem professores';
$string['negativerange'] = 'Faixa é negativa. Isso não pode.';
$string['never'] = 'Nunca';
$string['newappointment'] = '{$a}: Novo compromisso';
$string['noappointments'] = 'Nenhum compromisso';
$string['nogroups'] = 'Não há grupos disponíveis para organização.';
$string['noresults'] = 'Sem resultados.';
$string['noschedulers'] = 'Não há agendadores';
$string['noslots'] = 'Não há slots de compromisso disponíveis.';
$string['nostudenttobook'] = 'Nenhum aluno para agendar';
$string['note'] = 'Nota';
$string['noteacherforslot'] = 'Nenhum professor para os slots';
$string['noteachershere'] = 'Nenhum professor disponível';
$string['notenoughplaces'] = 'Sinto muito, não há compromissos livres suficientes nesse slot.';
$string['notifications'] = 'Notificações';
$string['notifications_help'] = 'Quando essa opção estiver habilitada, professores e alunos receberão notificações quando compromissos são solicitados ou cancelados.';
$string['notseen'] = 'Não visto';
$string['notselected'] = 'Você ainda não fez uma escolha';
$string['now'] = 'Agora';
$string['occurrences'] = 'Ocorrências';
$string['on'] = 'em';
$string['onedaybefore'] = 'Slot de 1 dia antes';
$string['oneslotadded'] = '1 slot adicionado';
$string['oneweekbefore'] = 'Slot de 1 semana antes';
$string['onthemorningofappointment'] = 'Na manhã do compromisso';
$string['otherstudents'] = 'Outros participantes';
$string['overall'] = 'No geral';
$string['overlappings'] = 'Alguns outros slots estão sobrepostos';
$string['pluginadministration'] = 'Administração do agendador';
$string['pluginname'] = 'Agendador';
$string['registeredlbl'] = 'Aluno agendado';
$string['reminder'] = 'Lembrete';
$string['remindertext'] = 'Isso é apenas um lembrete de que você ainda não configurou seu compromisso. Por favor, escolha um slot de tempo o mais breve possível';
$string['remindtitle'] = '{$a}: Lembrete de compromisso';
$string['remindwhere'] = 'Local do compromisso:';
$string['remindwithwhom'] = 'Compromisso agendado com';
$string['resetappointments'] = 'Compromissos e notas excluídos';
$string['resetslots'] = 'Excluir slots de organizador';
$string['return'] = 'Retornar ao curso';
$string['revoke'] = 'Revogar o compromisso';
$string['saturday'] = 'Sábado';
$string['save'] = 'Salvar';
$string['savechoice'] = 'Salvar minha escolha';
$string['savecomment'] = 'Salvar o comentário';
$string['saveseen'] = 'Salvar visto';
$string['schedule'] = 'Organizar';
$string['scheduleappointment'] = 'Organizar compromisso para {$a}';
$string['schedulecancelled'] = '{$a}: Seu compromisso cancelado ou movido';
$string['schedulegroups'] = 'Organizar por grupo';
$string['scheduleinnew'] = 'Agendar em um novo slot';
$string['scheduleinslot'] = 'Agendar em slot';
$string['scheduler'] = 'Agendador';
$string['scheduler:addinstance'] = 'Adicionar um novo agendador';
$string['scheduler:appoint'] = 'Agendar';
$string['scheduler:attend'] = 'Assistir alunos';
$string['scheduler:canscheduletootherteachers'] = 'Agendar compromissos para outros membros da equipe';
$string['scheduler:canseeotherteachersbooking'] = 'Ver e buscar outros agendamentos de professores';
$string['scheduler:manage'] = 'Gerenciar seus slot e compromissos';
$string['scheduler:manageallappointments'] = 'Gerenciar todos os dados do agendador';
$string['scheduler:seeotherstudentsbooking'] = 'Ver outros agendamentos de alunos no slot';
$string['scheduler:seeotherstudentsresults'] = 'Ver outros slots de resultados de alunos';
$string['schedulestudents'] = 'Agendar por aluno';
$string['seen'] = 'Visto';
$string['selectedtoomany'] = 'Você selecionou muitos slots. Você não pode selecionar mais do que {$a}.';
$string['showemailplain'] = 'Mostrar endereços de e-mail em texto simples';
$string['showemailplain_desc'] = 'Na visão do professor do agendador, mostrar os endereços de e-mail dos alunos que precisam de um novo compromisso em texto simples, em adição aos links mailto:';
$string['showparticipants'] = 'Mostrar participantes';
$string['slotdescription'] = '{$a->status} em {$a->startdate} de {$a->starttime} para {$a->endtime} em {$a->location} com {$a->facilitator}.';
$string['slot_is_just_in_use'] = 'Desculpa, o compromisso já foi escolhido por outro aluno! Por favor, tente novamente.';
$string['slots'] = 'Slots';
$string['slotsadded'] = '{$a} slots foram adicionados';
$string['slottype'] = 'Tipo de slot';
$string['slotupdated'] = '1 slot atualizado';
$string['slotwarning'] = '<strong>Aviso: </strong> Movendo esse slot para o tempo selecionado entra em conflito com o slot(s) listado(s) abaixo. Assinale "Ignorar conflitos de agendamento" se você quiser mover o slot mesmo assim.';
$string['staffbreakdown'] = 'Por {$a}';
$string['staffmember'] = 'Membro da equipe';
$string['staffrolename'] = 'Nome do papel do professor';
$string['staffrolename_help'] = 'O rótulo para o papel que atende alunos. Este não é necessariamente um "professor".';
$string['start'] = 'Iniciar';
$string['startpast'] = 'Você não pode iniciar um slot de agendamento vazio no passado';
$string['starttime'] = 'Tempo inicial';
$string['statistics'] = 'Estatística';
$string['student'] = 'Aluno';
$string['studentbreakdown'] = 'Por aluno';
$string['studentcomments'] = 'Notas do aluno';
$string['studentdetails'] = 'Detalhes do aluno';
$string['studentmultiselect'] = 'Cada aluno pode ser selecionado apenas uma vez nesse slot';
$string['studentnotes'] = 'Suas notas sobre agendamento';
$string['students'] = 'Alunos';
$string['sunday'] = 'Domingo';
$string['tab-otherappointments'] = 'Todos os compromissos desse aluno';
$string['tab-otherstudents'] = 'Alunos nesse slot';
$string['tab-thisappointment'] = 'Esse compromisso';
$string['teacher'] = 'Professor';
