<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'pt_br', branch 'MOODLE_28_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Você pode visualizar este teste, mas se isto fosse uma tentativa real, você seria bloqueado porque:
';
$string['action'] = 'Ação';
$string['activityoverview'] = 'Você tem questionários pendentes';
$string['adaptive'] = 'Modo adaptativo';
$string['adaptive_help'] = 'Se ativado, várias respostas a uma pergunta são permitidas em uma mesma tentativa do questionário. Por exemplo, se uma resposta está marcada como incorreta, será permitido ao estudante tentar novamente. No entanto, dependendo da definicção de "Aplicar sanções", geralmente serão subtraídos pontos para cada tentativa errada.
';
$string['add'] = 'Adicionar';
$string['addaquestion'] = 'uma nova questão';
$string['addarandomquestion'] = 'uma pergunta aleatória';
$string['addarandomquestion_help'] = 'Quando uma pergunta aleatória é adicionada, isso resulta em uma questão escolhida aleatoriamente a partir da categoria que está sendo inserida no questionário. Isto significa que diferentes alunos poderão receber uma seleção diferente de perguntas, e quando um questionário permite várias tentativas, para cada uma delas é possível conter uma nova seleção de perguntas.
';
$string['addarandomselectedquestion'] = 'Adicionar uma questão aleatória';
$string['adddescriptionlabel'] = 'Adicionar um item de descrição';
$string['addingquestion'] = 'Adicionando uma questão';
$string['addingquestions'] = 'Neste lado da página você administra a sua base de dados de questões. As questões são organizadas em categorias e podem ser usadas por qualquer questionário deste curso ou de outros cursos.
<br /><br />Depois de selecionar ou criar uma categoria você poderá criar ou editar questões. Você pode selecionar qualquer destas questões para adicionar ao seu questionário que se encontra no outro lado desta página.';
$string['addmoreoverallfeedbacks'] = 'Adicionar {no} outro(s) campo(s) de feedback';
$string['addnewgroupoverride'] = 'Nova sobreposição de grupo';
$string['addnewpagesafterselected'] = 'Adicionar novas páginas após questões selecionadas';
$string['addnewquestionsqbank'] = 'Adicionar perguntas à categoria {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Adicionar sobreposição de usuário';
$string['addpagebreak'] = 'Adicionar quebra de página';
$string['addpagehere'] = 'Adicionar página aqui';
$string['addquestion'] = 'Adicionar pergunta';
$string['addquestionfrombankatend'] = 'Adicionar a partir do banco de questões no final';
$string['addquestionfrombanktopage'] = 'Adicionar a partir do banco de questões para página {$a}';
$string['addquestions'] = 'Acrescentar perguntas';
$string['addquestionstoquiz'] = 'Acrescentar perguntas a este questionário';
$string['addrandom'] = 'Acrescentar {$a} questões aleatórias';
$string['addrandom1'] = '<< Acrescentar';
$string['addrandom2'] = 'questões aleatórias';
$string['addrandomfromcategory'] = 'Adicionar perguntas aleatórias da categoria';
$string['addrandomquestion'] = 'Adiconar perguntas aleatórias';
$string['addrandomquestionatend'] = 'Adicionar uma pergunta aleatória no final';
$string['addrandomquestiontopage'] = 'Adicionar uma pergunta aleatória para página {$a}';
$string['addrandomquestiontoquiz'] = 'Adicionar uma pergunta aleatória ao questionário {$a}';
$string['addselectedquestionstoquiz'] = 'Adicionar perguntas selecionadas para o quiz';
$string['addselectedtoquiz'] = 'Acrescentar as seleções ao questionário';
$string['addtoquiz'] = 'Acrescentar ao questionário';
$string['affectedstudents'] = 'Atingidos {$a}';
$string['aftereachquestion'] = 'Após adicionada cada pergunta';
$string['afternquestions'] = 'Após adicionar {$a} perguntas';
$string['age'] = 'idade';
$string['allattempts'] = 'Todas as tentativas';
$string['allinone'] = 'Ilimitado';
$string['allowreview'] = 'Permitir revisão';
$string['alreadysubmitted'] = 'É provável que você já tenha enviado esta tentativa';
$string['alternativeunits'] = 'Unidades alternativas';
$string['alwaysavailable'] = 'Sempre disponível';
$string['analysisoptions'] = 'Opções de análise';
$string['analysistitle'] = 'Tabela de Análise dos Itens';
$string['answer'] = 'Resposta';
$string['answered'] = 'Respondido';
$string['answerhowmany'] = 'Uma ou múltiplas respostas?';
$string['answers'] = 'Respostas';
$string['answersingleno'] = 'Respostas múltiplas permitidas';
$string['answersingleyes'] = 'Apenas uma resposta';
$string['answertoolong'] = 'Resposta longa demais a partir da linha {$a} (máximo de 255 caracteres)';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = 'Você quer mesmo remover todas as questões selecionadas?';
$string['asshownoneditscreen'] = 'Como mostrado na tela de edição';
$string['attempt'] = 'Tentativa';
$string['attemptalreadyclosed'] = 'Essa tentativa já terminou.';
$string['attemptclosed'] = 'A tentativa não foi ainda fechada';
$string['attemptduration'] = 'Tempo utilizado';
$string['attemptedon'] = 'Tentativas em';
$string['attempterror'] = 'Você não tem permissão de tentar este questionário neste momento porque: {$a}';
$string['attemptfirst'] = 'Primeira tentativa';
$string['attemptincomplete'] = 'Esta tentativa (por {$a}) ainda não foi concluída';
$string['attemptlast'] = 'Última tentativa';
$string['attemptnumber'] = 'Tentativa';
$string['attemptquiznow'] = 'Tentar responder o questionário agora';
$string['attempts'] = 'Tentativas';
$string['attemptsallowed'] = 'Tentativas permitidas';
$string['attemptsdeleted'] = 'Excluir tentativas do questionário';
$string['attemptselection'] = 'Selecionar as tentativas a serem analisadas em relação aos usuários:';
$string['attemptsexist'] = 'Este questionário já foi respondido';
$string['attemptsnum'] = 'Tentativas: {$a}';
$string['attemptsnumthisgroup'] = 'Tentativas: {$a->total} ({$a->group} deste grupo)';
$string['attemptsnumyourgroups'] = 'Tentativas: {$a->total} ({$a->group} do seu grupo)';
$string['attemptsonly'] = 'Mostrar apenas alunos com tentativas realizadas';
$string['attemptstate'] = 'Estado';
$string['attemptstillinprogress'] = 'Tentativa ainda em andamento';
$string['attemptsunlimited'] = 'Tentativas ilimitadas';
$string['autosaveperiod'] = 'Período de salvamento automático';
$string['autosaveperiod_desc'] = 'As respostas dos alunos podem ser salvas automaticamente a cada minuto, durante as tentativas do quiz. Trata-se de um trade-off: salvar as respostas aumenta a carga do servidor, mas reduz a chance dos alunos perdem o seu trabalho.';
$string['back'] = 'Voltar à visualização prévia da questão';
$string['backtocourse'] = 'Voltar ao curso';
$string['backtoquestionlist'] = 'Voltar à Lista de Questões';
$string['backtoquiz'] = 'Voltar para edição do questionário';
$string['basicideasofquiz'] = 'As ideias básicas da construção do questionário';
$string['bestgrade'] = 'Melhor nota';
$string['bothattempts'] = 'Mostrar alunos com e sem tentativas';
$string['browsersecurity'] = 'Segurança do navegador';
$string['browsersecurity_help'] = 'Se a opção "Tela cheia pop-up com segurança JavaScript" estiver selecionada,

 * O teste só vai começar se o aluno tem um JavaScript habilitado no navegador.
* O questionário aparece em uma janela <em>pop-up</em> em tela cheia, que abrange todas as outras janelas e não tem controles de navegação
 * Estudantes são impedidos, na medida do possível, de usar os recursos como copiar e colar.';
$string['calculated'] = 'Calculado';
$string['calculatedquestion'] = 'A Questão-Calculada da linha {$a} não é suportada. A questão será ignorada';
$string['cannotcreatepath'] = 'Percurso não pode ser criado ({$a})';
$string['cannoteditafterattempts'] = 'Você não pode adicionar ou remover perguntas, porque já foram registradas tentativas. ({$a})';
$string['cannotfindprevattempt'] = 'Não foi possível encontrar tentativa anterior de construção.
';
$string['cannotfindquestionregard'] = 'Falha ao obter questões para reavaliação!';
$string['cannotinsert'] = 'Impossível inserir questão';
$string['cannotinsertrandomquestion'] = 'Não foi possível inserir uma nova pergunta aleatória!
';
$string['cannotloadquestion'] = 'Não foi possível carregar as opções da pergunta';
$string['cannotloadtypeinfo'] = 'Não foi possível carregar questiontype informações questão específica';
$string['cannotopen'] = 'Impossível abrir arquivo de exportação ({$a})';
$string['cannotrestore'] = 'Não foi possível restaurar as sessões de perguntas';
$string['cannotreviewopen'] = 'Você não pode rever essa tentativa, ela ainda está aberta.
';
$string['cannotsavelayout'] = 'Não foi possível salvar layout';
$string['cannotsavenumberofquestion'] = 'Não foi possível salvar número de questões por página';
$string['cannotsavequestion'] = 'Não foi possível salvar lista de questões';
$string['cannotsetgrade'] = 'Não foi possível definir nova nota máxima para questionário';
$string['cannotsetsumgrades'] = 'Falhou ao definir sumgrades';
$string['cannotstartgradesmismatch'] = 'Você não pode iniciar uma tentativa neste questionário. O Questionário está configurado para ser avaliado com nota {$a->grade}, mas nenhuma das questões valem nota. Isso pode ser arrumado na página \'Editar questionário".';
$string['cannotstartmissingquestion'] = 'Não foi possivel iniciar tentativa para esse questionário.  As definições do questionário incluem uma questão que não existe.';
$string['cannotstartnoquestions'] = 'Não é possível iniciar uma tentativa neste questionário. O questionário não foi configurado ainda. Nenhuma questão foi adicionada.';
$string['cannotwrite'] = 'Impossível escrever arquivo de exportação ({$a})';
$string['caseno'] = 'Não importa a diferença entre maiúsculas e minúsculas';
$string['casesensitive'] = 'Considerar diferenças entre maiúsculas e minúsculas';
$string['caseyes'] = 'Sim, a correspondência com maiúsculas ou minúsculas deve ser exata';
$string['categories'] = 'Categorias';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'A categoria \'{$a}\' foi acrescentada';
$string['categorydeleted'] = 'A categoria \'{$a}\' foi cancelada';
$string['categorynoedit'] = 'O seu perfil de usuário não permite a edição na categoria \'{$a}\'.';
$string['categoryupdated'] = 'A categoria foi atualizada com sucesso';
$string['close'] = 'Fechar janela';
$string['closebeforeopen'] = 'Não foi possível atualizar o questionário. A data final é muito próxima à data de abertura.';
$string['closed'] = 'Fechada';
$string['closepreview'] = 'Fechar janela';
$string['closereview'] = 'Fechar janela';
$string['comment'] = 'Comentário';
$string['commentorgrade'] = 'Faça um comentário ou modifique a avaliação';
$string['comments'] = 'Comentários';
$string['completedon'] = 'Concluída em';
$string['completionattemptsexhausted'] = 'Todas as tentativas disponíveis concluídas';
$string['completionattemptsexhausted_help'] = 'Marcar questionário como completo quando o aluno tiver esgotado o número máximo de tentativas.';
$string['completionpass'] = 'Exigir nota de aprovação';
$string['completionpass_help'] = 'Se habilitado, esta atividade é considerada completa quando o aluno receber uma nota superior à de aprovação definida no livro de notas.';
$string['configadaptive'] = 'Se você escolher \'Sim\' para esta opção, então   será permitido ao estudante a utilização de múltiplas respostas a uma pergunta até mesmo em uma mesma tentativa do questionário.
';
$string['configattemptsallowed'] = 'Restrições no número de tentativas que estudantes tem permissão no questionário.';
$string['configdecimaldigits'] = 'Número de dígitos que devem ser mostrados após o ponto decimal ao exibir notas.';
$string['configdecimalplaces'] = 'Quantidade de dígitos que devem ser mostrados após o ponto decimal ao exibir a pontuação para o questionário. ';
$string['configdecimalplacesquestion'] = 'Quantidade de dígitos que devem ser mostrados após o ponto decimal ao exibir a série para as perguntas individuais.
';
$string['configdelay1'] = 'Se você definir um intervalo de tempo, então um estudante tem que esperar que o tempo antes que eles podem tentar um teste após a primeira tentativa.';
$string['configdelay1st2nd'] = 'Se você definir aqui um tempo, o aluno não pode iniciar a sua segunda tentativa, até que esse tempo tenha se passado desde o final da primeira tentativa.
';
$string['configdelay2'] = 'Se você definir um período de tempo aqui, então um estudante tem que esperar que o tempo antes que eles possam tentar as suas tentativas de terceiros ou posterior.';
$string['configdelaylater'] = 'Se você definir aqui um tempo, o aluno não pode iniciar a sua terceira, quarta ... tentativa até que este tempo tenha passado desde o fim da tentativa anterior.';
$string['configeachattemptbuildsonthelast'] = 'Se forem permitidas tentativas múltiplas, então cada nova tentativa contém o resultado da anterior.';
$string['configgrademethod'] = 'Quando são permitidas múltiplas tentativas, qual método deve ser utilizado para calcular a nota final do aluno para o questionário.';
$string['configintro'] = 'Os valores que você definir aqui determina os valores padrões que são utilizados nas configurações de formulário quando você cria um novo questionário. Você também pode definir as configurações avançadas.';
$string['configmaximumgrade'] = 'A nota máxima deste questionário.';
$string['confignavmethod'] = 'Usando navegação Livre, as questões pode ser respondidas em qualquer ordem usando a navegação.';
$string['confignewpageevery'] = 'Quando se adicionarem perguntas no questionário quebras de página serão inserida automaticamente conforme a configuração aqui escolhida.';
$string['configoutcomesadvanced'] = 'Se esta opção estiver ativada, então os resultados no formulário de edição de teste são configurações avançadas.';
$string['configpenaltyscheme'] = 'Punição atribuída a cada resposta errada no modo adaptativo.';
$string['configpopup'] = 'Força a tentativa de abrir em uma janela <em>pop-up</em>, e usar truques do JavaScript  para tentar restringir a copiar e colar, etc. durante as tentativas do questionário.';
$string['configrequirepassword'] = 'Os estudantes devem digitar essa senha antes que eles possam tentar responder o questionário.';
$string['configrequiresubnet'] = 'Os estudantes podem tentar responder o questionário apenas a partir desses computadores.';
$string['configreviewoptions'] = 'Estas opções controlam que informações os usuários podem ver ao rever uma tentativa de questionário ou ver nos relatórios.';
$string['configshowblocks'] = 'Mostra blocos durante as tentativas de resposta.';
$string['configshowuserpicture'] = 'Mostra a foto do usuário na tela durante as tentativas.';
$string['configshufflequestions'] = 'Se você habilitar esta opção, então a ordem das perguntas no questionário serão expostas aleatoriamente toda vez que um aluno responder ao questionário.';
$string['configshufflewithin'] = 'Se você habilitar esta opção, então as partes que compõem cada uma das perguntas será mudada aleatoriamente toda vez que um estudante iniciar uma tentativa no questionário, desde que a opção também esteja ativada nas configurações do questionário.';
$string['configtimelimit'] = 'Limite de tempo padrão para testes em poucos minutos. 0 significa sem limite de tempo.';
$string['configtimelimitsec'] = 'Limite padrão de tempo para questionário em segundos. \'Zero\' significa que não há limite de tempo. ';
$string['configurerandomquestion'] = 'Configurar questão';
$string['confirmclose'] = 'Uma vez enviada, você não poderá alterar as respostas para esta tentativa.';
$string['confirmremovequestion'] = 'Tem certeza de que deseja remover esta pergunta {$a}?';
$string['confirmserverdelete'] = 'Você quer mesmo remover o servidor <b>{$a}</b> da lista?';
$string['confirmstartattemptlimit'] = 'Número de tentativas permitidas: {$a}. Você está prestes a iniciar uma nova tentativa. Você quer continuar?';
$string['confirmstartattempttimelimit'] = 'Este questionário tem limites de tempo e permite apenas {$a} tentativas. Você está prestes a iniciar uma nova tentativa. Você quer continuar?';
$string['confirmstarttimelimit'] = 'Este questionário tem um limite de tempo. Tem certeza que quer iniciar?';
$string['connectionerror'] = 'Conexão de rede perdida. (Salvamento automático falhou). Anote quaisquer respostas registradas nesta página nos últimos minutos e tente conectar-se novamente. Quando a conexão for restabelecida, suas respostas devem ser salvas e esta mensagem irá desaparecer.';
$string['connectionok'] = 'Conexão de rede restaurada. Você pode continuar com segurança.';
$string['containercategorycreated'] = 'Esta categoria foi criada para arquivar todas as categorias que foram movidas para o nível do site principal pelas seguintes razões:';
$string['continueattemptquiz'] = 'Continuar a última tentativa';
$string['continuepreview'] = 'Continuar a última prévia';
$string['copyingfrom'] = 'Criando uma cópia da questão \'{$a}\'';
$string['copyingquestion'] = 'Copiando uma questão';
$string['correct'] = 'Correto';
$string['correctanswer'] = 'Resposta correta';
$string['correctanswerformula'] = 'Fórmula de respostas corretas';
$string['correctansweris'] = 'Resposta correta: {$a}';
$string['correctanswerlength'] = 'Cifras significativas';
$string['correctanswers'] = 'Respostas corretas';
$string['correctanswershows'] = 'Exibições de respostas corretas';
$string['corrresp'] = 'Resposta correta';
$string['countdown'] = 'Contagem regressiva';
$string['countdownfinished'] = 'O prazo para o envio dos resultados do questionário terminou, envie as suas respostas agora.';
$string['countdowntenminutes'] = 'O prazo para o envio dos resultados do questionário vai acabar daqui a 10 minutos.';
$string['coursetestmanager'] = 'Formato Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Criar categoria e adicionar questão aleatória';
$string['createfirst'] = 'Você deve criar primeiro algumas questões de resposta breve.';
$string['createmultiple'] = 'Criar perguntas múltiplas';
$string['createnewquestion'] = 'Criar nova pergunta';
$string['createquestionandadd'] = 'Criar uma nova questão e adicioná-la ao quiz.';
$string['custom'] = 'Formato personalizado';
$string['dataitemneed'] = 'Você tem que acrescentar pelo menos una série de dados para obter uma questão válida';
$string['datasetdefinitions'] = 'Definições de conjunto de dados reutilizáveis em categoria {$a}';
$string['datasetnumber'] = 'Número';
$string['daysavailable'] = 'Dias disponíveis';
$string['decimaldigits'] = 'Números decimais nas notas';
$string['decimalplaces'] = 'Casas decimais nas avaliações';
$string['decimalplaces_help'] = 'Este campo permite selecionar o número de algarismos decimais que serão
apresentados na classificação de cada tentativa. Por exemplo, \'0\' significa que os números mostrados serão inteiros. Esta configuração se aplica apenas à modalidade de visualização e não altera o cálculo das notas.';
$string['decimalplacesquestion'] = 'Casas decimais nas avaliações da pergunta';
$string['decimalplacesquestion_help'] = 'Esta configuração especifica a quantidade de dígitos mostrados após o ponto decimal ao exibir as avaliações para as perguntas individuais.';
$string['decimalpoints'] = 'Pontos decimais';
$string['default'] = 'Predefinido';
$string['defaultgrade'] = 'Avaliação predefinida';
$string['defaultinfo'] = 'Categoria predefinida para perguntas';
$string['delay1'] = 'Intervalo entre a primeira e a segunda tentativa';
$string['delay1st2nd'] = 'Força demora entre a primeira e a segunda tentativas.';
$string['delay1st2nd_help'] = '<p>Se você configurar um Lapso temporal, um estudante tem que esperar este período após a primeira tentativa, antes que possa fazer a segunda tentativa.</p>';
$string['delay2'] = 'Intervalo entre a segunda e outras tentativas';
$string['delaylater'] = 'Força demora entre tentativas posteriores.';
$string['delaylater_help'] = '<p>Se você configurar um Lapso temporal aqui, então um estudante tem que esperar este período antes que possa fazer outras tentativas.</p>';
$string['deleteattemptcheck'] = 'Você tem certeza que quer excluir estas tentativas completamente?';
$string['deleteselected'] = 'Excluir selecionadas';
$string['deletingquestionattempts'] = 'Excluir tentativas';
$string['description'] = 'Descrição';
$string['disabled'] = 'Desativado';
$string['displayoptions'] = 'Opções de Visualização';
$string['donotuseautosave'] = 'Não use auto-save';
$string['download'] = 'Clique para baixar o arquivo de categoria exportado';
$string['downloadextra'] = '(o arquivo pode ser encontrado também na pasta /quiz da seção arquivos do curso)';
$string['dragtoafter'] = 'Após {$a}';
$string['dragtostart'] = 'Para o início';
$string['duplicateresponse'] = 'Esta tentativa foi ignorada porque você já deu uma resposta idêntica em data anterior.';
$string['eachattemptbuildsonthelast'] = 'Cada tentativa se baseia na última';
$string['eachattemptbuildsonthelast_help'] = '<P>Caso forem permitidas tentativas múltiplas e esta opção for colocada em <B>Sim</B>, então
cada nova tentativa contém o resultado da tentativa anterior. Isto permite que o questionário seja
concluído após várias tentativas.</P>
<P>Para mostrar um questionário vazio em cada tentativa, seleciona-se <B>Não</B> para esta
opção.</P>';
$string['editcategories'] = 'Editar categorias';
$string['editcategory'] = 'Editar categoria';
$string['editcatquestions'] = 'Editar questões da categoria';
$string['editingquestion'] = 'Editando uma pergunta';
$string['editingquiz'] = 'Editando questionário';
$string['editingquiz_help'] = 'Ao se criar um questionário, os conceitos principais são:

* O questionário contém perguntas que estejam em uma ou mais páginas
* O banco de questões, que armazena cópias de todas as perguntas organizadas em categorias
* Perguntas aleatórias - Um aluno recebe perguntas diferentes a cada tentativa de resposta ao questionário e estudantes diferentes podem obter diferentes perguntas.';
$string['editingquizx'] = 'Editando questionário: {$a}';
$string['editmaxmark'] = 'Editar nota máxima';
$string['editoverride'] = 'Editar sobreposição';
$string['editqcats'] = 'Editar categorias de questões';
$string['editquestion'] = 'Editar questão';
$string['editquestions'] = 'Editar questões';
$string['editquiz'] = 'Editar questionário';
$string['editquizquestions'] = 'Editar questões do Quiz';
$string['emailconfirmbody'] = 'Prezado(a) {$a->username},

obrigada pelo envio das suas respostas ao questionário \'{$a->quizname}\'
no curso \'{$a->coursename}\'
em {$a->submissiontime}.

Esta mensagem confirma o recebimento das suas respostas.

Você pode acessar o questionário em {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Obrigado por submeter as respostas para \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Confirmação de envio: {$a->quizname}';
$string['emailnotifybody'] = 'Prezado(a) {$a->username},

{$a->studentname} completou o questionário
\'{$a->quizname}\' ({$a->quizurl})
do curso \'{$a->coursename}\'

Para rever a tentativa acesse {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} completou {$a->quizname}. Veja {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} concluiu o questionário {$a->quizname}';
$string['emailoverduebody'] = 'Prezado {$a->studentname},

Você iniciou uma tentativa no queziontário \'{$a->quizname}\' no curso \'{$a->coursename}\' mas não finalizou a tentativa.

Se você pretende ainda finalizar essa tentativa, por favor retorne para {$a->attemptsummaryurl} e clique no botão de envio. Você precisa fazer isso antes de {$a->attemptgraceend}, caso contrário sua tentativa não será levada em conta.';
$string['emailoverduesmall'] = 'Você não finalizou sua tentativa em {$a->quizname}. Por favor vá para {$a->attemptsummaryurl} antes de {$a->attemptgraceend} se você pretende finalizá-la.';
$string['emailoverduesubject'] = 'Tentativa agora vencida: {$a->quizname}';
$string['empty'] = 'Vazio';
$string['enabled'] = 'Ativado';
$string['endtest'] = 'Finalizar tentativa ...';
$string['erroraccessingreport'] = 'Você não pode acessar este relatório';
$string['errorinquestion'] = 'Erro na questão';
$string['errormissingquestion'] = 'Erro: o sistema não encontra a questão com ID {$a}';
$string['errornotnumbers'] = 'Erro - as respostas devem ser numéricas';
$string['errorunexpectedevent'] = 'Um código de evento inesperado {$a->event} foi encontado para a pergunta {$a->questionid} na tentativa {$a->attemptid}.';
$string['essay'] = 'Dissertação';
$string['essayquestions'] = 'Questões de dissertação';
$string['eventattemptdeleted'] = 'Tentativa do questionário excluída';
$string['eventattemptpreviewstarted'] = 'Pré-visualização do questionário iniciada';
$string['eventattemptreviewed'] = 'Tentativa do questionário revisada';
$string['eventattemptsummaryviewed'] = 'Resumo da tentativa do questionário visualizada';
$string['eventattemptviewed'] = 'Tentativa do questionário visualizada';
$string['eventeditpageviewed'] = 'Edição da página do Quiz visualizada';
$string['eventoverridecreated'] = 'Sobreposição de questionário criada';
$string['eventoverridedeleted'] = 'Sobreposição de questionário apagada';
$string['eventoverrideupdated'] = 'Sobreposição de questionário atualizada';
$string['eventquestionmanuallygraded'] = 'Questões avaliadas manualmente';
$string['eventquizattemptabandoned'] = 'Tentativa do questionário abandonada';
$string['eventquizattemptstarted'] = 'Tentativa do questionário iniciada';
$string['eventquizattemptsubmitted'] = 'Tentativa do questionário entregue';
$string['eventquizattempttimelimitexceeded'] = 'Limite de tempo do questionário excedido';
$string['eventreportviewed'] = 'Relatório do questionário visualizado';
$string['everynquestions'] = 'Cada {$a} perguntas.';
$string['everyquestion'] = 'Cada pergunta';
$string['everythingon'] = 'Tudo sobre';
$string['export'] = 'Exportar';
$string['exportcategory'] = 'exportar categoria';
$string['exporterror'] = 'Erro durante a exportação';
$string['exportingquestions'] = 'As questões estão sendo exportadas em um arquivo';
$string['exportname'] = 'nome do arquivo';
$string['exportquestions'] = 'Exportar questões em um arquivo';
$string['extraattemptrestrictions'] = 'Restrições extras nas tentativas';
$string['false'] = 'Falso';
$string['feedback'] = 'Comentários';
$string['feedbackerrorboundaryformat'] = 'Os limites de nota do retorno devem ser em porcentagem ou um número. O valor digitado no limite {$a} não foi reconhecido.';
$string['feedbackerrorboundaryoutofrange'] = 'Os limites da nota de retorno devem estar entre 0% e 100%. O valor digitado no limite {$a} está fora do intervalo.';
$string['feedbackerrorjunkinboundary'] = 'Você tem que preencher os limites da nota de retorno sem deixar espaços/caracteres desnecessários.';
$string['feedbackerrorjunkinfeedback'] = 'Você precisa preencher as caixas de retorno sem deixar espaços/caracteres desnecessários.';
$string['feedbackerrororder'] = 'Os limites de nota de retorno devem estar em ordem decrescente. O valor digitado no limite {$a} está fora de sequência.';
$string['file'] = 'Arquivo';
$string['fileformat'] = 'Formato do arquivo';
$string['fillcorrect'] = 'Preencher com a opção correta';
$string['filloutnumericalanswer'] = 'Você precisa digitar uma resposta possível e permitida dentro da tolerância. A primeira resposta encontrada será usada para determinar a nota e a avaliação. Se você colocar um retorno sem resposta no final, ele será usado para os alunos cujas respostas não estejam na lista.';
$string['filloutoneanswer'] = 'Pelo menos uma resposta tem que ser preenchida. Respostas em branco não serão consideradas. \'*\' pode ser usado com curinga para corresponder a qualquer caractere. A primeira resposta encontrada será usad para determinar a nota e feedback.';
$string['filloutthreequestions'] = 'Pelo menos 3 respostas têm que ser preenchidas. Respostas em branco não serão consideradas.';
$string['fillouttwochoices'] = 'Tem que preencher pelo menos duas opções. Respostas em branco não serão consideradas.';
$string['finishattemptdots'] = 'Tentativas encerradas';
$string['finishreview'] = 'Terminar revisão';
$string['forceregeneration'] = 'forçar regeneração';
$string['formatnotfound'] = 'Formato {$a} não foi encontrado';
$string['formatnotimplemented'] = 'Este formato não foi implementado corretamente, por favor indique o bug na comunidade';
$string['formulaerror'] = 'Erros na fórmula';
$string['fractionsaddwrong'] = 'As soma das notas positivas escolhidas não totaliza 100%
<br />A soma é {$a}%
<br />Quer retornar e corrigir esta pergunta?';
$string['fractionsnomax'] = 'Uma das respostas deve ser 100% para que seja
<br />possível obter a nota total nesta pergunta.
<br />Quer retornar e corrigir esta pergunta?';
$string['fromfile'] = 'do arquivo:';
$string['functiondisabledbysecuremode'] = 'Esta funcionalidade está desativada neste momento';
$string['generalfeedback'] = 'Comentários gerais';
$string['generalfeedback_help'] = '<p>Feedback geral da Questão é um texto mostrado para os estudantes depois que eles responderam a questão. Diferente do feedback simples, que depende do tipo de questão e da resposta que o estudante deu, no feedback geral da Questão o mesmo texto é mostrado para todos os estudantes.</p>

<p>Você pode controlar quando o feedback geral é mostrado para os estudantes usando a caixa de maracação de escolha "Estudantes podem rever:" no formulário de edição do questionário.</p>

<p>Você pode usar o feedback geral para dar aos estudantes mais informações sobre qual conhecimento a questão estava testando. Ou dar a eles referências de outras informações para estudo caso eles não tenham entendido as questões.</p>';
$string['graceperiod'] = 'Período de carência de envio';
$string['graceperiod_desc'] = 'Se a opção "O que fazer quando o tempo expira" está configurada com a opção "Permitir um período de carência de envio, mas não muda nenhuma resposta" este é o tempo extra permitido em segundos.';
$string['graceperiod_help'] = 'Se a opção "O que fazer quando o tempo expira" está configurada com a opção "Permitir um período de carência de envio, mas não muda nenhuma resposta" este é o tempo extra permitido.';
$string['graceperiodmin'] = 'Período de carência do último envio';
$string['graceperiodmin_desc'] = 'Há um problema potencial bem no final do questionário. Por um lado precisamos garantir que os alunos continuem sua tentativa até o último segundo - com a ajuda do cronômetro que envia automaticamente a tentativa quando o tempo termina. Por outro lado, o servidor pode ficar sobrecarregado e levar algum tempo para processar todas as respostas. Tendo esse problema em vista, esta configuração cria um período de carência após a expiração do tempo assim os alunos não são penalizados se o servidor ficar lento. Entretanto, seus alunos podem \'colar\' e gastar estes segundos respondendo o questionário. Você terá que tomar uma decisão baseada em quanto confia nos seus servidores durante a aplicação de questionários.';
$string['graceperiodtoosmall'] = 'O período de carência deve ser mais do que {$a}.';
$string['grade'] = 'Avaliar';
$string['gradeall'] = 'Avaliar todos';
$string['gradeaverage'] = 'Nota média';
$string['gradeboundary'] = 'Limite das notas';
$string['gradeessays'] = 'Avaliar dissertações';
$string['gradehighest'] = 'Nota mais alta';
$string['grademethod'] = 'Método de avaliação';
$string['grademethod_help'] = '<P>Quando são permitidas diversas tentativas de resposta ao questionário, podem ser configurados 4 modos diversos de cálculo da nota final.

<h2>Nota mais alta</h2>
<UL>
<P>A nota final é a nota mais alta obtida nas diversas tentativas.
</UL>

<h2>M&eacute;dia dos resultados</h2>
<UL>
<P>A nota final é a média entre as notas de todas as tentativas.
</UL>

<h2>Primeira nota</h2>
<UL>
<P>Apenas os resultados da primeira tentativa são considerados.
</UL>

<h2>Última nota</h2>
<UL>
<P>Apenas o resultado da última tentativa é considerado..
</UL>';
$string['gradesdeleted'] = 'Excluir notas de questionário';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Notas relativas a este envio: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Considerando as penalidades: <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Penalidade de {$a} neste envio';
$string['gradingdetailszeropenalty'] = 'Você não foi penalizado em relação a este envio';
$string['gradingmethod'] = 'Método de avaliação: {$a}';
$string['groupoverrides'] = 'Sobreposições de grupo';
$string['groupsnone'] = 'Não há grupos neste curso';
$string['guestsno'] = 'Sinto muito, os visitantes não podem ver ou responder questionários';
$string['hidebreaks'] = 'Ocultar quebras de página';
$string['hidereordertool'] = 'Ocultar ferramenta de reordenação';
$string['history'] = 'Histórico das respostas:';
$string['howquestionsbehave_desc'] = 'Configuração padrão para comportamento das questões no questionário.';
$string['imagedisplay'] = 'Imagem a ser mostrada';
$string['import'] = 'Importação';
$string['importcategory'] = 'importar categoria';
$string['importerror'] = 'Erro durante a importação';
$string['importfilearea'] = 'Importação do arquivo já presente no curso...';
$string['importfileupload'] = 'Importação de arquivo carregado...';
$string['importfromthisfile'] = 'Importar deste arquivo';
$string['import_help'] = 'Esta função permite que você importe perguntas de arquivos externos de texto.

Se o arquivo contém caracteres em formato não-ASCII, você deverá usar a codificação UTF-8. Tenha especial cautela ao tratar com arquivos gerados por aplicativos do Microsoft Office, uma vez que estes geralmente usam codificação especial que não serão tratados adequadamente.

Formatos de importação e exportação são um recurso conectável. Outros formatos opcionais podem estar disponíveis na Modules and Plugins database.';
$string['importingquestions'] = 'Importando {$a} questões de arquivo';
$string['importmax10error'] = 'Erro nesta questão: você não pode incluir mais de dez respostas.';
$string['importmaxerror'] = 'Erro na questão: número de respostas superior ao limite máximo.';
$string['importquestions'] = 'Importar perguntas de arquivos externos';
$string['inactiveoverridehelp'] = '* O estudante não tem o grupo correto ou atribuição para tentar o questionário';
$string['incorrect'] = 'Errado';
$string['indivresp'] = 'Respostas dos indivíduos a cada item';
$string['info'] = 'Informações';
$string['infoshort'] = 'i';
$string['inprogress'] = 'Em andamento';
$string['introduction'] = 'Introdução';
$string['invalidattemptid'] = 'Não existe a identificação desta tentativa.';
$string['invalidcategory'] = 'O ID da categoria é inválido';
$string['invalidnumericanswer'] = 'Uma das respostas não era um número válido';
$string['invalidnumerictolerance'] = 'Uma das tolerâncias não era um número válido.';
$string['invalidoverrideid'] = 'Identificação inválida de sobreposição';
$string['invalidquestionid'] = 'Identificação inválida da pergunta';
$string['invalidquizid'] = 'Identificação inválida do questionário';
$string['invalidsource'] = 'O recurso não foi reconhecido como válido';
$string['invalidsourcetype'] = 'Tipo de recurso inválido';
$string['invalidstateid'] = 'Estado inválido de identificação';
$string['lastanswer'] = 'A sua última resposta foi';
$string['layout'] = 'Layout';
$string['layoutasshown'] = 'Layout da página como mostrado.';
$string['layoutasshownwithpages'] = 'Layout da página como mostrado. <small>(Nova página automaticamente a cada {$a} questões.)</small>';
$string['layoutshuffledandpaged'] = 'Questões embaralhadas aleatoriamente com {$a} questões por página.';
$string['layoutshuffledsinglepage'] = 'Questões aleatoriamente ordenadas, todas na mesma página.';
$string['link'] = 'Link';
$string['listitems'] = 'Lista dos itens do quiz';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Falha no carregamento da pergunta: {$a}';
$string['makecopy'] = 'Salvar nova questão';
$string['managetypes'] = 'Gerenciar tipos de questão e servidores';
$string['manualgrading'] = 'Avaliação';
$string['mark'] = 'Enviar';
$string['markall'] = 'Enviar página';
$string['marks'] = 'Notas';
$string['marks_help'] = 'A nota atribuída para cada questão e a nota total da tentativa.';
$string['match'] = 'Associação';
$string['matchanswer'] = 'Resposta associada';
$string['matchanswerno'] = 'Resposta associada {$a}';
$string['max'] = 'Max';
$string['maxmark'] = 'Nota máxima';
$string['messageprovider:attempt_overdue'] = 'Avisar quando suas tentativas se tornarem vencidas';
$string['messageprovider:confirmation'] = 'Confirmação de suas próprias submissões de questionário';
$string['messageprovider:submission'] = 'Notificação de submissões do questionário';
$string['min'] = 'Min';
$string['minutes'] = 'Minutos';
$string['missingcorrectanswer'] = 'A resposta correta deve ser especificada';
$string['missingitemtypename'] = 'Falta o nome';
$string['missingquestion'] = 'Esta questão parece não existir mais';
$string['modulename'] = 'Questionário';
$string['modulename_help'] = 'O módulo de questionário permite ao professor criar e configurar testes de múltipla escolha, verdadeiro ou falso, correspondência e outros tipos de perguntas. Cada tentativa é corrigida automaticamente e o professor pode optar por fornecer <em>feedback</em> e / ou mostrar as respostas corretas.';
$string['modulenameplural'] = 'Questionários';
$string['moveselectedonpage'] = 'Move as questões selecionadas para página: {$a}';
$string['multichoice'] = 'Múltipla Escolha';
$string['multipleanswers'] = 'Escolha pelo menos uma resposta.';
$string['multiplier'] = 'Multiplicador';
$string['mustbesubmittedby'] = 'Esta tentativa precisa ser enviada até {$a}.';
$string['name'] = 'Nome';
$string['navmethod'] = 'Método de navegação';
$string['navmethod_free'] = 'Livre';
$string['navmethod_help'] = 'Quando a navegação sequencial está habilitada, os alunos são obrigados a responder o questionário na ordem e não podem retornar às páginas anteriores nem passar adiante.';
$string['navmethod_seq'] = 'Sequencial';
$string['navnojswarning'] = 'Atenção: esses links não vão salvar as suas respostas. Use o botão \'Próximo\' na parte inferior da página.';
$string['neverallononepage'] = 'Nunca, todas as questões em uma página';
$string['newattemptfail'] = 'Erro: Não foi possível iniciar uma tentativa deste questionário';
$string['newpage'] = 'Nova página';
$string['newpageevery'] = 'Começar nova página automaticamente';
$string['newpage_help'] = '<P>Para questionários longos faz sentido dividi-los em várias páginas limitando-se
o números de perguntas por página. Quando se adicionarem perguntas no questionário serão
inseridas quebras de página automaticamente de acordo com o valor escolhido.
Contudo posteriormente pode-se também manualmente mover as quebras de página
na edição da página. </P>';
$string['noanswers'] = 'Nenhuma resposta foi selecionada!';
$string['noattempts'] = 'Nenhuma tentativa foi feita neste questionário';
$string['noattemptsfound'] = 'Nenhuma tentativa encontrada.';
$string['noattemptstoshow'] = 'Nenhuma tentativa a ser mostrada';
$string['nocategory'] = 'Categoria incorreta ou não especificada';
$string['noclose'] = 'Sem data de fechamento';
$string['nocommentsyet'] = 'Nenhum comentário por enquanto.';
$string['noconnection'] = 'Atualmente não há nenhuma conexão com um serviço web que possa processar esta questão. Por favor contate o administrador';
$string['nodataset'] = 'Nada - isto não é um caractere genérico';
$string['nodatasubmitted'] = 'Senhum dado foi submetido.';
$string['noessayquestionsfound'] = 'Nenhuma questão de dissertação encontrada';
$string['nogradewarning'] = 'Este quiz não foi avaliado e assim não é possível criar feedbacks gerais diferentes para cada nota.';
$string['nomoreattempts'] = 'Não são permitidas outras tentativas';
$string['none'] = 'Nenhum';
$string['noopen'] = 'Sem data de abertura';
$string['nooverridedata'] = 'Você precisa sobrepor ao menos uma configuração de questionário.';
$string['nopossibledatasets'] = 'Nenhum conjunto de dados possível';
$string['noquestionintext'] = 'O texto da questão não contém perguntas embutidas';
$string['noquestions'] = 'Ainda não foi inserida nenhuma pergunta';
$string['noquestionsfound'] = 'Nenhuma questão encontrada';
$string['noquestionsinquiz'] = 'Não há perguntas neste questionário.';
$string['noquestionsnotinuse'] = 'Esta pergunta aleatória não está em uso, uma vez que a sua categoria está vazia.';
$string['noquestionsonpage'] = 'Página vazia';
$string['noresponse'] = 'Nenhuma resposta';
$string['noreview'] = 'Não é permitido rever este questionário';
$string['noreviewattempt'] = 'Você não tem permissão para revisar esta tentativa.';
$string['noreviewshort'] = 'Não permitido';
$string['noreviewuntil'] = 'Não é permitido rever este questionário até {$a}';
$string['noreviewuntilshort'] = 'Disponível {$a}';
$string['noscript'] = 'Para continuar é necessário que o uso de javascript seja permitido no seu navegador!';
$string['notavailabletostudents'] = 'Nota: Este questionário não está disponível para os estudantes neste momento';
$string['notenoughrandomquestions'] = 'Não há questões suficientes na categoria {$a->category} para criar a questão {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Não foi definido um número suficiente de perguntas subordinadas<br />Você quer voltar e corrigir esta pergunta?';
$string['notimedependentitems'] = 'Os itens que dependem de tempo não são suportados pelo módulo questionário. Você pode estabelecer um tempo de execução para o questionário inteiro, se quiser. Você quer escolher um outro item ou usar este mesmo?';
$string['notyetgraded'] = 'Ainda não avaliado';
$string['notyetviewed'] = 'Ainda não visto';
$string['notyourattempt'] = 'Esta não é a sua tentativa!';
$string['noview'] = 'O usuário que está acessando não tem permissão para ver este questionário';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} fizeram {$a->attemptnum} tentativas';
$string['numattemptsmade'] = '{$a} tentativa(s) feita(s) neste questionário.';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numérica';
$string['numquestionsx'] = 'Perguntas: {$a}';
$string['oneminute'] = '1 minuto';
$string['onlyteachersexport'] = 'Apenas os professores podem exportar questões';
$string['onlyteachersimport'] = 'Apenas os professores com direitos de edição podem importar questões';
$string['onthispage'] = 'Esta página';
$string['open'] = 'Não respondido';
$string['openclosedatesupdated'] = 'Datas de abertura e encerramento do questionário atualizadas';
$string['optional'] = 'opcional';
$string['orderandpaging'] = 'Ordem e paginação';
$string['orderandpaging_help'] = 'Os números 10, 20, 30, ... em frente de cada pergunta indicam a a sua ordem. Os números aumentam em intervalos de 10 para possibilitar espaço para questões adicionais a serem inseridas. Para reordená-las, modificar os números e clicar no botão "Reordenar questões".

Para adicionar quebras de página após a perguntas particulares, marque as caixas ao seu lado e, em seguida, clique em "Adicionar nova página, após as perguntas selecionadas ".

Para ordenar as perguntas em um número de páginas, clique no botão "Repaginar" e selecione o número desejado de perguntas por página.';
$string['orderingquiz'] = 'Ordenar e paginar';
$string['orderingquizx'] = 'Ordem e paginação: {$a}';
$string['outcomesadvanced'] = 'Resultados são as configurações avançadas';
$string['outof'] = '{$a->grade} de um máximo de {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} de um máximo de {$a->maxgrade}({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback geral';
$string['overallfeedback_help'] = '<p>Feedback global é um texto mostrado para o estudante depois que ele terminou, uma tentativa, de responder o questionário. O texto que é mostrado pode depender da nota que o estudante obteve.</p>

<p>Por exemplo, se voce entrou com:</p>

<p>Limite de notas: 100%<br />
Feedback: Muito Bom<br />
Limite de notas: 40%<br />
Feedback: Por favor estude outra vez o trabalho desta semana<br />
...<br />
Limite de notas: 0%</p>

<p>Assim, estudantes com avaliação entre 100% e 40% irão ver a mensagem "Muito Bom", e estudantes com avaliação entre 39.99% e 0% irão ver a outra mensagem. Isto é, os limites de notas definem intervalos de notas, e cada mensagem de feedback global é mostrada de acordo com o intervalo.</p>

<p>Os intervalos de notas podem ser especificados tanto em percentagem, por exemplo "31.41%", ou em um número, por exemplo "7". Se o seu questionário vale 10, um limite de notas de 7 significa 7 em 10 ou melhor.</p>';
$string['overdue'] = 'Expirado';
$string['overduehandling'] = 'Quando o tempo expirar';
$string['overduehandlingautoabandon'] = 'Tentativas devem ser submetidas antes que o tempo expire ou elas não serão contabilizadas';
$string['overduehandlingautosubmit'] = 'a tentativa é enviada automaticamente';
$string['overduehandling_desc'] = 'O que deveria acontecer por padrão se um aluno não enviar o questionário antes de o tempo expirar.';
$string['overduehandlinggraceperiod'] = 'há um período de carência no qual a tentativa pode ser enviada, mas não é possível modificar questões';
$string['overduehandling_help'] = 'Esta configuração controla o que acontece se o aluno não envia sua tentativa questionário antes do tempo expirar. Se o aluno está trabalhando ativamente no questionário, no momento, então a contagem regressiva irá sempre enviar automaticamente a tentativa para eles, mas se eles deslogare, então essa configuração controla o que acontece.';
$string['overduemustbesubmittedby'] = 'Esta tentativa está vencida. Ela já deveria ter sido enviada. Se você quiser que este questionário seja avaliado, você deve enviá-lo até {$a}. Se você não enviar até até lá, nenhuma nota dessa tentativa será levada em conta.';
$string['override'] = 'Sobrepor';
$string['overridedeletegroupsure'] = 'Você tem certeza que deseja apagar a sobreposição do grupo {$a}?';
$string['overridedeleteusersure'] = 'Você tem certeza que deseja apagar a sobreposição do usuário {$a}?';
$string['overridegroup'] = 'Sobrepor grupo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Sobreposições';
$string['overrideuser'] = 'Sobrepor usuário';
$string['overrideusereventname'] = '{$a->quiz} - Sobrepor';
$string['page-mod-quiz-attempt'] = 'Página da tentativa do questionário';
$string['page-mod-quiz-edit'] = 'Editar página do questionário';
$string['page-mod-quiz-report'] = 'Qualquer página de relatório do questionário';
$string['page-mod-quiz-review'] = 'Revisão da página da tentativa do questionário';
$string['page-mod-quiz-summary'] = 'Página de resumo da tentativa do questionário';
$string['page-mod-quiz-view'] = 'Página de informações do questionário';
$string['page-mod-quiz-x'] = 'Qualquer página do módulo questionário';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Tamanho da página';
$string['parent'] = 'Pai';
$string['parentcategory'] = 'Categoria principal';
$string['parsingquestions'] = 'Analisando questões do arquivo importado.';
$string['partiallycorrect'] = 'Parcialmente correta';
$string['penalty'] = 'Penalidade';
$string['penaltyscheme'] = 'Aplicar penalidades';
$string['penaltyscheme_help'] = '<P>Se um questionário estiver rodando no modo adaptativo então é permitida uma nova tentativa
após uma resposta errada. Neste caso pode-se desejar impor uma penalidade para cada
resposta errada sendo subtraída da marca final para a pergunta. O valor da
penalidade é escolhida individualmente para cada pergunta durante a configuração ou a edição da
pergunta.</P>
<P>Esta configuração não tem efeito a menos que o questionário rode no modo
adaptativo.</P>';
$string['percentcorrect'] = 'Percentual correto';
$string['pleaseclose'] = 'O seu pedido foi processado. Você já pode fechar esta janela';
$string['pluginadministration'] = 'Administração do questionário';
$string['pluginname'] = 'Questionário';
$string['popup'] = 'Mostrar o questionário em uma janela "segura"';
$string['popupblockerwarning'] = 'A seção desse teste está em modo de segurança, o que significa que você precisa fazer o questionário numa janela segura. Por favor desligue o bloqueador de popups. Obrigado.';
$string['popupnotice'] = 'Os estudantes vão ver este questionário em uma janela segura';
$string['preprocesserror'] = 'Ocorreu um erro durante o pré-processamento!';
$string['preview'] = 'Visualização prévia';
$string['previewquestion'] = 'Visualização prévia da questão';
$string['previewquiz'] = 'Visualização prévia de {$a}';
$string['previewquiznow'] = 'Pré-visualizar questionário agora';
$string['previous'] = 'Estado anterior';
$string['publish'] = 'Publicar';
$string['publishedit'] = 'Você deve ter direitos de publicação de cursos para adicionar ou editar questões nesta categoria';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'nome';
$string['qti'] = 'Formato IMS QTI';
$string['qtypename'] = 'tipo, nome';
$string['question'] = 'Pergunta';
$string['questionbank'] = 'do banco de questões';
$string['questionbankmanagement'] = 'Gerenciamento de banco de questões';
$string['questionbehaviour'] = 'Comportamento da questão';
$string['questioncats'] = 'Categorias de questões';
$string['questiondeleted'] = 'Esta questão foi cancelada';
$string['questioninuse'] = 'A pergunta \'{$a->questionname}\' é atualmente usada em:<br />{$a->quiznames}<br />A questão não será excluída destes questionários mas apenas das categorias.';
$string['questionmissing'] = 'Faltando pergunta para esta sessão';
$string['questionname'] = 'Nome da pergunta';
$string['questionnonav'] = '<span class="accesshide">Questão </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informação </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'A pergunta {$a} não foi carregada da base de dados.';
$string['questionorder'] = 'Ordem da pergunta';
$string['questionposition'] = 'Nova posição para a pergunta {$a}';
$string['questions'] = 'Perguntas';
$string['questionsinclhidden'] = 'Perguntas (inclusive escondidas)';
$string['questionsinthisquiz'] = 'Perguntas neste questionário';
$string['questionsperpage'] = 'Questões por página';
$string['questionsperpageselected'] = 'Perguntas por página foi estabelecido de modo a paginação está actualmente fixado. Como resultado, os controles de paginação foram desativados. Você pode mudar isso em {$a}.';
$string['questionsperpagex'] = 'Perguntas por página: {$a}';
$string['questiontext'] = 'Texto da pergunta';
$string['questiontextisempty'] = '[Texto vazio de pergunta]';
$string['questiontype'] = 'Tipo de questão {$a}';
$string['questiontypesetupoptions'] = 'Opções de configuração de tipos de questão';
$string['quiz:addinstance'] = 'Incluir um novo questionário';
$string['quiz:attempt'] = 'Responder questionários';
$string['quizavailable'] = 'O questionário estará disponível até: {$a}';
$string['quizclose'] = 'Encerrar o questionário';
$string['quizclosed'] = 'Este questionário foi encerrado em {$a}';
$string['quizcloses'] = 'O questionário se encerra';
$string['quizcloseson'] = 'O questionário será fechado {$a}';
$string['quiz:deleteattempts'] = 'Cancelar tentativas';
$string['quiz:emailconfirmsubmission'] = 'Receber confirmação por email ao enviar';
$string['quiz:emailnotifysubmission'] = 'Receber notificação dos envios por email';
$string['quiz:emailwarnoverdue'] = 'Receber uma mensagem de notificação quando uma tentativa se tornar vencida e precisar ser enviada.';
$string['quiz:grade'] = 'Avaliar manualmente';
$string['quiz:ignoretimelimits'] = 'Ignorar limite de tempo';
$string['quizisclosed'] = 'Este questionário está fechado';
$string['quizisclosedwillopen'] = 'Questionário fechado (abre {$a})';
$string['quizisopen'] = 'Este questionário está aberto';
$string['quizisopenwillclose'] = 'Questionário aberto (fecha {$a})';
$string['quiz:manage'] = 'Gerenciar questionários';
$string['quiz:manageoverrides'] = 'Administrar sobreposições do questionário';
$string['quiznavigation'] = 'Navegação do questionário';
$string['quizopen'] = 'Abrir o questionário';
$string['quizopenclose'] = 'Datas de abertura e fechamento';
$string['quizopenclose_help'] = 'Alunos podem iniciar tentativas apenas depois do horário de abertura e devem completar suas tentativas antes do horário de término.';
$string['quizopened'] = 'Este questionário está aberto.';
$string['quizopenedon'] = 'Este questionário será aberto em {$a}';
$string['quizopens'] = 'O questionário inicia';
$string['quizopenwillclose'] = 'Este questionário está aberto e será fechado em {$a} as';
$string['quizordernotrandom'] = 'Ordem do questionário não embaralhada';
$string['quizorderrandom'] = '* Ordem do questionário está embaralhada';
$string['quiz:preview'] = 'Visualização prévia';
$string['quiz:regrade'] = 'Reclassificar as tentativas do questionário';
$string['quiz:reviewmyattempts'] = 'Rever as suas tentativas';
$string['quizsettings'] = 'Configurações do questionário';
$string['quiztimer'] = 'Cronômetro do questionário';
$string['quiz:view'] = 'Ver informação sobre o questionário';
$string['quiz:viewreports'] = 'Ver relatórios';
$string['quizwillopen'] = 'Este questionário de aberto {$a}';
$string['random'] = 'Pergunta aleatória';
$string['randomcreate'] = 'Criar questões aleatórias';
$string['randomfromcategory'] = 'Pergunta aleatória da categoria';
$string['randomfromexistingcategory'] = 'Pergunta aleatória de uma categoria existente';
$string['randomnosubcat'] = 'Questões somente dessa categoria, não de suas subcategorias';
$string['randomnumber'] = 'Número de questões aleatórias';
$string['randomquestionusinganewcategory'] = 'Pergunta aleatória utilizando uma nova categoria';
$string['randomwithsubcat'] = 'Perguntas desta categoria e de suas subcategorias';
$string['readytosend'] = 'Você está enviando o seu questionário para ser avaliado. Tem certeza que quer continuar?';
$string['reattemptquiz'] = 'Fazer uma outra tentativa';
$string['recentlyaddedquestion'] = 'Pergunta acrescentada recentemente!';
$string['recurse'] = 'Incluir também as questões das sub-categorias';
$string['regrade'] = 'Avaliar novamente todas as tentativas';
$string['regradecomplete'] = 'Todas as tentativas foram avaliadas novamente';
$string['regradecount'] = '{$a->changed} de {$a->attempt} notas foram modificadas';
$string['regradedisplayexplanation'] = 'Tentativas que são modificadas durante a reavaliação são mostradas como links à página de revisão da questão';
$string['regradenotallowed'] = 'Você não tem permissão para alterar notas neste questionário';
$string['regradingquestion'] = 'Reavaliando "{$a}".';
$string['regradingquiz'] = 'Reavaliando o questionário "{$a}".';
$string['remove'] = 'Remover';
$string['removeallquizattempts'] = 'Excluir todas as tentativas do questionário';
$string['removeemptypage'] = 'Remover página vazia';
$string['removepagebreak'] = 'Remover quebra de página';
$string['removeselected'] = 'Remover seleção';
$string['rename'] = 'Renomear';
$string['renderingserverconnectfailed'] = 'O servidor {$a} não processou um pedido RQP. Verifique se a URL está certa.';
$string['reorderquestions'] = 'Reordenar perguntas';
$string['reordertool'] = 'Mostrar o instrumento de ordenação';
$string['repaginate'] = 'Ordenar novamente com {$a} questões por página';
$string['repaginatecommand'] = 'Repaginar';
$string['repaginatenow'] = 'Repaginar agora';
$string['replace'] = 'Substituir';
$string['replacementoptions'] = 'Opções de substituição';
$string['report'] = 'Relatórios';
$string['reportanalysis'] = 'Análise de item';
$string['reportattemptsfrom'] = 'Tentativa de';
$string['reportattemptsthatare'] = 'Tentativas que estão';
$string['reportdisplayoptions'] = 'Opções de visualização';
$string['reportfullstat'] = 'Estatísticas detalhadas';
$string['reportmulti_percent'] = 'Multi-Percentuais';
$string['reportmulti_q_x_student'] = 'Multi-Escolhas de estudantes';
$string['reportmulti_resp'] = 'Respostas Individuais';
$string['reportmustselectstate'] = 'Você precisa selecionar pelo menos um estado.';
$string['reportnotfound'] = 'Relatório não conhecido ({$a})';
$string['reportoverview'] = 'Visão Geral';
$string['reportregrade'] = 'Modificar notas';
$string['reportresponses'] = 'Respostas detalhadas';
$string['reports'] = 'Relatórios';
$string['reportshowonly'] = 'Mostrar apenas tentativas';
$string['reportshowonlyfinished'] = 'Mostrar no máximo uma tentativa finalizada por usuário {$a})';
$string['reportsimplestat'] = 'Estatísticas simples';
$string['reportusersall'] = 'todos os usuário que tem';
$string['reportuserswith'] = 'usuários inscritos haviam tentado o questionário';
$string['reportuserswithorwithout'] = 'usuários inscritos que haviam ou não tentado o questionário';
$string['reportuserswithout'] = 'usuários inscritos que não haviam tentado o questionário';
$string['reportwhattoinclude'] = 'O que incluir no relatório';
$string['requirepassword'] = 'Senha necessária';
$string['requirepassword_help'] = '<P>Este campo é opcional</P>
<P>Caso se especifique uma senha neste campo então os participantes devem digitar a mesma
senha para receberem a permissão para fazer uma tentativa no
questionário.</P>';
$string['requiresubnet'] = 'Requer endereço de rede';
$string['requiresubnet_help'] = '<P>Este campo é opcional.</P>
<P>Pode-se restringir o acesso a um questionário a sub-redes particulares numa LAN ou
Internet especificando-se uma lista separada por vírgulas dos endereços IP completos ou parciais.</P>
<P>Isto é especialmente útil para um questionário pré-determinado ("proctored quiz"), onde se desejar certeza
que somente as pessoas de uma certa sala estiverem aptas a acessar o questionário.</P>
<P>Por exemplo: <B>192.168. , 231.54.211.0/20, 231.3.56.211</B></P>
<P>Existem três tipos de números que podem ser usados (não se podem utilizar nomes de domínios em texto como exemplo.com):
<OL>
  <LI>Endereços IP completos, tais como <B>192.168.10.1</B> designarão um simples
  computador (ou proxy).
  <LI>Endereços parciais, tais como <B>192.168</B> designarão qualquer um
  iniciando com estes números.
  <LI>Notação CIDR, tais como <B>231.54.211.0/20</B> permitirá que se especifiquem
  sub-redes mais detalhadas. </LI></OL>

<P>Os espaços são ignorados.</P>';
$string['response'] = 'Resposta';
$string['responses'] = 'Respostas';
$string['results'] = 'Resultados';
$string['returnattempt'] = 'Retornar à tentativa';
$string['reuseifpossible'] = 'reutilizar removida anteriormente';
$string['reverttodefaults'] = 'Reverter para o questionário padrão';
$string['review'] = 'Revisão';
$string['reviewafter'] = 'Permitir revisão depois da data de fechamento';
$string['reviewalways'] = 'Permitir revisão sempre';
$string['reviewattempt'] = 'Revisão de tentativa';
$string['reviewbefore'] = 'Permitir revisão enquanto estiver aberto';
$string['reviewclosed'] = 'Depois do fechamento do questionário';
$string['reviewduring'] = 'Durante a tentativa';
$string['reviewimmediately'] = 'Após a tentativa';
$string['reviewnever'] = 'Nunca permitir revisões';
$string['reviewofattempt'] = 'Revisão da tentativa {$a}';
$string['reviewofpreview'] = 'Revisão da prévia';
$string['reviewopen'] = 'Mais tarde, enquanto ainda estiver aberto';
$string['reviewoptions'] = 'Estudantes podem fazer revisão';
$string['reviewoptionsheading'] = 'Opções de revisão';
$string['reviewoptionsheading_help'] = 'Estas opções controlam quais informações estudantes podem ver quando eles revisam uma tentativa visualizam os relatórios do quiz.</p>

**Durante a tentativa** é relevante para alguns comportamentos como "interativo com múltiplas tentativas" que pode mostrar o feedback durante a tentativa.

**Imediatamente após a tentativa** se aplica aos primeiros dois minutos após clicar em "Enviar tudo e terminar".


**Mais tarde, enquanto o quiz ainda está aberto** se aplica após isto e antes da data de encerramento do quiz.

**Após o quiz estar fechado** se aplica após a data de encerramento. Se o quiz não tem uma data de encerramento, este estado nunca é alcançado.';
$string['reviewoverallfeedback'] = 'Feedback final';
$string['reviewoverallfeedback_help'] = 'Feedback exibido ao final da tentativa, dependendo da nota total do aluno.';
$string['reviewresponse'] = 'Resposta da revisão';
$string['reviewresponsetoq'] = 'Resposta da revisão (question {$a})';
$string['reviewthisattempt'] = 'Analise as suas respostas a esta tentativa';
$string['rqp'] = 'Questão remota';
$string['rqps'] = 'Questões remotas';
$string['sameasoverall'] = 'O mesmo que para as avaliações em geral';
$string['save'] = 'Gravar';
$string['saveandedit'] = 'Salvar mudanças e editar questões';
$string['saveattemptfailed'] = 'Falha ao salvar a tentativa atual do questionário.';
$string['savedfromdeletedcourse'] = 'Salvo do seguinte curso cancelado: "{$a}"';
$string['savegrades'] = 'Gravar notas';
$string['savemyanswers'] = 'Gravar as minhas respostas';
$string['savenosubmit'] = 'Salvar sem enviar';
$string['saveoverrideandstay'] = 'Salvar e entrar com outra sobreposição';
$string['savequiz'] = 'Gravar este questionário inteiro';
$string['saving'] = 'Salvando';
$string['savingnewgradeforquestion'] = 'Salvando nova nota para a questão de id {$a}.';
$string['savingnewmaximumgrade'] = 'Salvando nova nota máxima.';
$string['score'] = 'Classificação';
$string['scores'] = 'Notas';
$string['seequestions'] = '(ver questões)';
$string['select'] = 'Selecione';
$string['selectall'] = 'Selecionar tudo';
$string['selectcategory'] = 'Selecionar categoria';
$string['selectedattempts'] = 'tentativas selecionadas...';
$string['selectnone'] = 'Deselecionar Tudo';
$string['selectquestiontype'] = '-- Selecionar tipo de questão --';
$string['serveradded'] = 'Servidor acrescentado';
$string['serveridentifier'] = 'Identificador';
$string['serverinfo'] = 'Informação do servidor';
$string['servers'] = 'Servidores';
$string['serverurl'] = 'URL do servidor';
$string['settingsoverrides'] = 'Sobreposição de configurações';
$string['shortanswer'] = 'Resposta breve';
$string['show'] = 'Visualizar';
$string['showall'] = 'Mostrar todas as questões em uma página';
$string['showblocks'] = 'Mostrar blocos durante as tentativas do questionário';
$string['showblocks_help'] = 'Se definido como sim, então os blocos serão exibidos durante tentativas do quiz';
$string['showbreaks'] = 'Mostrar interrupções de página';
$string['showcategorycontents'] = 'Mostra o conteúdo da categoria {$a->arrow}';
$string['showcorrectanswer'] = 'Visualizar respostas corretas no feedback?';
$string['showdetailedmarks'] = 'Mostrar detalhes da nota';
$string['showeachpage'] = 'Mostrar uma página por vez';
$string['showfeedback'] = 'Mostrar feedback depois de responder?';
$string['showinsecurepopup'] = 'Use uma janela <em>pop-up</em> \'segura\' para as tentativas.';
$string['showlargeimage'] = 'Imagem grande';
$string['shownoattempts'] = 'Mostrar estudantes que ainda não responderam';
$string['shownoattemptsonly'] = 'Mostrar apenas estudantes que ainda não responderam';
$string['shownoimage'] = 'Nenhuma imagem';
$string['showreport'] = 'Mostrar relatório';
$string['showsmallimage'] = 'Imagem pequena';
$string['showteacherattempts'] = 'Mostrar tentativas de professores';
$string['showuserpicture'] = 'Mostrar a fotografia do usuário.';
$string['showuserpicture_help'] = 'Se ativado, o nome do aluno e a sua fotografia será mostrada na tela durante a tentativa, e na revisão, tornando mais fácil a verificação que o estudante está acessando como ele mesmo em um teste supervisionado.';
$string['shuffle'] = 'Misturar';
$string['shuffleanswers'] = 'Misturar as respostas';
$string['shuffledrandomly'] = 'Embaralhar aleatoriamente';
$string['shufflequestions'] = 'Misturar as perguntas';
$string['shufflequestionsselected'] = 'Foram definidas perguntas embaralhadas, portanto, algumas ações relacionadas a páginas não estão disponíveis. Para alterar a opção de embaralhamento, {$a}.';
$string['shufflewithin'] = 'Misturar entre as questões';
$string['shufflewithin_help'] = '<p>Se esta opção estiver ativada, então as partes que compõem as perguntas
   individualmente serão misturadas aleatoriamente toda vez que um estudante
   inicia uma tentativa do questionário, contanto que esta opção esteja também
   ativada na configuração das perguntas.</p>

<p>A intenção é simplesmente tornar um pouco mais difícil que os estudantes
   copiem as respostas entre eles.</p>

<p>Isto somente se aplica às perguntas que têm partes múltiplas, tais como
   perguntas de múltipla escolha ou perguntas de associação. Para perguntas de múltipla escolha
   a ordem das respostas é misturada somente quando esta opção estiver em
   "Sim". Para perguntas de associação as respostas são sempre misturadas,
   e esta opção controla se adicionalmente a ordem dos pares pergunta-resposta
   serão misturados.</p>

<p>Esta opção não está relacionada ao uso das perguntas aleatórias.</p>';
$string['singleanswer'] = 'Escolha uma resposta.';
$string['sortage'] = 'Ordenar por idade';
$string['sortalpha'] = 'Ordenar alfabeticamente';
$string['sortquestionsbyx'] = 'Ordenar questões por: {$a}';
$string['sortsubmit'] = 'Ordenar questões';
$string['sorttypealpha'] = 'Ordenar por tipo, nome';
$string['specificapathnotonquestion'] = 'O caminho de arquivo especificado não se encontra na questão especificada';
$string['specificquestionnotonquiz'] = 'A questão especificada não se encontra no questionário especificado';
$string['startagain'] = 'Iniciar novamente';
$string['startattempt'] = 'Iniciar tentativa';
$string['startedon'] = 'Iniciado em';
$string['startnewpreview'] = 'Iniciar nova visualização';
$string['stateabandoned'] = 'Nunca enviadas';
$string['statefinished'] = 'Finalizada';
$string['statefinisheddetails'] = 'Enviada(s) {$a}';
$string['stateinprogress'] = 'Em progresso';
$string['statenotloaded'] = 'O estado da pergunta {$a} não foi carregado do banco de dados';
$string['stateoverdue'] = 'Vencidas';
$string['stateoverduedetails'] = 'Precisam ser enviadas até {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Interromper em caso de erro';
$string['submitallandfinish'] = 'Enviar tudo e terminar';
$string['subneterror'] = 'O acesso a este questionário é limitado aos endereços de rede autorizados. Atualmente o computador que você está utilizando não está autorizado a utilizar este questionário.';
$string['subnetnotice'] = 'Este questionário pode ser acessado apenas em áreas definidas da rede. O seu computador não tem a permissão de acesso. Como professor você pode fazer uma prova de visualização.';
$string['subplugintype_quiz'] = 'Relatório';
$string['subplugintype_quizaccess'] = 'Regra de acesso';
$string['subplugintype_quizaccess_plural'] = 'Regras de acesso';
$string['subplugintype_quiz_plural'] = 'Relatórios';
$string['substitutedby'] = 'será substituído por';
$string['summaryofattempt'] = 'Resumo de tentativas';
$string['summaryofattempts'] = 'Resumo das suas tentativas anteriores';
$string['temporaryblocked'] = 'Você deve refletir um pouco antes de fazer uma nova tentativa.<br /> Você terá permissão para tentar novamente em:';
$string['theattempt'] = 'A tentativa';
$string['theattempt_help'] = 'Define se o aluno pode ver o relatório da tentativa ou não.';
$string['time'] = 'Tempo';
$string['timecompleted'] = 'Completo';
$string['timedelay'] = 'Você ainda não pode resolver este questionário porque existe um tempo de espera definido entre a realização de duas tentativas.';
$string['timeleft'] = 'Tempo restante';
$string['timelimit'] = 'Limite de tempo';
$string['timelimitexeeded'] = 'O limite de tempo do questionário foi superado!';
$string['timelimit_help'] = '<P align=center><STRONG>Tempo Limite</STRONG></P>
<P>Na configuração padrão os questionários não têm tempo limite, permitindo-se aos estudantes o tempo
que for necessário para completar o questionário.</P>
<P>Caso se especifique um tempo limite,  diversas coisas  são feitas para tentar e assegurar
que os questionários sejam concluídos dentro deste tempo:</P>
<UL>
  <LI>O suporte  ao Javascript no navegador torna-se prioritário - isto permite que o
  contador do tempo trabalhe corretamente.
  <LI>Uma janela com o contador é mostrada com a contagem regressiva
  <LI>Quando a contagem terminar, o questionário é submetido automaticamente com
  as respostas que foram preenchidas até então
  <LI>Se um estudante tentar enganar o sistema e gastar mais que 60 segundos acima do tempo permitido
  então o questionário é automaticamente avaliado com zero.
</LI>
</UL>';
$string['timelimitmin'] = 'Limite de tempo (minutos)';
$string['timelimitsec'] = 'Limite de tempo (segundos)';
$string['timestr'] = '%H:%M:%S em %d/%m/%y';
$string['timesup'] = 'Acabou o tempo de duração!';
$string['timetaken'] = 'Tempo empregado';
$string['timing'] = 'Duração';
$string['tofile'] = 'para o arquivo';
$string['tolerance'] = 'Tolerância';
$string['toomanyrandom'] = 'O número de perguntas aleatórias requerido é superior ao conteúdo desta categoria! ({$a})';
$string['top'] = 'Topo';
$string['totalmarksx'] = 'Total de avaliações: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} perguntas na categoria.';
$string['true'] = 'Verdadeiro';
$string['truefalse'] = 'Verdadeiro/Falso';
$string['type'] = 'Tipo';
$string['unfinished'] = 'aberto';
$string['ungraded'] = 'Não avaliados';
$string['unit'] = 'Unidade';
$string['unknowntype'] = 'Tipo de questão não suportado na linha {$a}. A questão será ignorada';
$string['unusedcategorydeleted'] = 'Esta categoria foi cancelada porque depois do cancelamento do curso as questões não foram mais usadas.';
$string['updatesettings'] = 'Atualizar configuração do questionário';
$string['updatingatttemptgrades'] = 'Atualizando notas da tentativa.';
$string['updatingfinalgrades'] = 'Atualizando notas finais.';
$string['updatingthegradebook'] = 'Atualizando livro de notas.';
$string['upgradesure'] = '<div>O módulo questionário provoca uma mudança profunda nas tabelas e esta atualização ainda não foi testada em modo satisfatório. Faça um backup das tabelas da sua base de dados antes de proceder.</div>';
$string['upgradingquizattempts'] = 'Atualizando tentativas do questionário {$a->done}/{$a->outof} (Id do questionário {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Atualizando tentativas muito antigas do questionário {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Esta categoria foi transferida ao nível do site porque é uma categoria compartilhada ainda em uso em outros questionários.';
$string['useroverrides'] = 'Sobreposições por usuário';
$string['usersnone'] = 'Nenhum aluno tem acesso a este questionário';
$string['validate'] = 'Validar';
$string['viewallanswers'] = 'Ver {$a} questionários concluídos';
$string['viewallreports'] = 'Mostrar relatórios de {$a} tentativas';
$string['viewed'] = 'Visualizado';
$string['warningmissingtype'] = '<b>Este tipo de questão ainda não foi instalado em Moodle.<br />Por favor avise o administrador do sistema.</b>';
$string['wheregrade'] = 'Onde está a minha avaliação?';
$string['wildcard'] = 'Caractere genérico (wild card)';
$string['windowclosing'] = 'Esta janela será fechada em breve.';
$string['withsummary'] = 'com resumo de estatísticas';
$string['wronguse'] = 'Você não pode usar esta página assim';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Você deve se cadastrar neste curso antes de tentar responder este questionário';
$string['yourfinalgradeis'] = 'A sua nota final neste questionário é {$a}.';
