<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'es', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodlemobileapp
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['appstoredescription'] = 'NOTA: Esta aplicación oficial de Moodle Mobile sólo funciona con sitios Moodle que se han configurado para permitirlo. Por favor, contacte con su administrador de Moodle si usted tiene algún problema de conexión.

Si su sitio Moodle se ha configurado correctamente, puede utilizar esta aplicación para:

- Navegar por el contenido de sus cursos, incluso sin conexión
- Recibir notificaciones instantáneas de mensajes y otros eventos
- Encontrar y contactar de forma rápida a otras personas en sus cursos
- Subir imágenes, audio, vídeos y otros archivos desde su dispositivo móvil
- Ver las calificaciones de los cursos
- ¡y más!

Por favor, vea http://docs.moodle.org/en/Mobile_app para toda la información más reciente.

Nos encantaría recibir cualquier crítica acerca de la aplicación y sus sugerencias sobre qué más quieres que pueda hacer.

La aplicación requiere los siguientes permisos:
Grabación de audio - Para la grabación de audio para subir a Moodle
Leer y modificar los contenidos de la tarjeta SD - El contenido se descarga en la tarjeta SD para que puedas verlos offline
Acceso a la red - Para ser capaz de conectar con su sitio Moodle y comprobar si está conectado o no para cambiar al modo fuera de línea
Ejecutar en el arranque - Así recibirá notificaciones locales incluso cuando la aplicación se ejecuta en segundo plano
Desactivar el modo stand - Podrá recibir las notificaciones push en cualquier momento';
$string['mma.calendar.calendarevents'] = 'Eventos de calendario';
$string['mma.calendar.errorloadevent'] = 'Error cargando el evento.';
$string['mma.calendar.errorloadevents'] = 'Error cargando los eventos.';
$string['mma.calendar.noevents'] = 'No hay eventos';
$string['mma.calendar.notifications'] = 'Notificaciones';
$string['mma.coursecompletion.complete'] = 'Completado';
$string['mma.coursecompletion.completecourse'] = 'Curso completado';
$string['mma.coursecompletion.completed'] = 'Finalizado';
$string['mma.coursecompletion.completiondate'] = 'Fecha de finalización';
$string['mma.coursecompletion.couldnotloadreport'] = 'No se puede cargar el informe de finalización del curso, por favor inténtalo de nuevo más tarde.';
$string['mma.coursecompletion.coursecompletion'] = 'Finalización del curso';
$string['mma.coursecompletion.criteria'] = 'Criterios';
$string['mma.coursecompletion.criteriagroup'] = 'Grupo de criterios';
$string['mma.coursecompletion.criteriarequiredall'] = 'Son necesarios todos los criterios que aparecen más abajo';
$string['mma.coursecompletion.criteriarequiredany'] = 'Es necesario cualquiera de los criterios que aparecen más abajo';
$string['mma.coursecompletion.inprogress'] = 'En curso';
$string['mma.coursecompletion.manualselfcompletion'] = 'Autocompletar manualmente';
$string['mma.coursecompletion.notyetstarted'] = 'Aún no comenzado';
$string['mma.coursecompletion.pending'] = 'Pendiente';
$string['mma.coursecompletion.required'] = 'Obligatorio';
$string['mma.coursecompletion.requiredcriteria'] = 'Criterios necesarios';
$string['mma.coursecompletion.requirement'] = 'Requisito';
$string['mma.coursecompletion.status'] = 'Estado';
$string['mma.coursecompletion.viewcoursereport'] = 'Ver informe del curso';
$string['mma.files.admindisableddownload'] = 'Por favor tome nota de que su administrador de Moodle deshabilitó las descargas de archivos; Usted puede ojear los archivos pero no puede descargarlos.';
$string['mma.files.audio'] = 'Audio';
$string['mma.files.camera'] = 'Cámara';
$string['mma.files.chooseaccountuploadfile'] = 'Seleccione una cuenta para subir el archivo.';
$string['mma.files.clicktoupload'] = 'Clic en el botón inferior para subir archivos a su zona de archivos privados.';
$string['mma.files.confirmuploadfile'] = 'Usted va a subir {{size}}. ¿Desea continuar?';
$string['mma.files.couldnotloadfiles'] = 'La lista de archivos no ha podido cargarse.';
$string['mma.files.downloading'] = 'Descargando...';
$string['mma.files.emptyfilelist'] = 'No hay archivos que mostrar';
$string['mma.files.errorcapturingaudio'] = 'Error capturando audio';
$string['mma.files.errorcapturingimage'] = 'Error capturando imagen.';
$string['mma.files.errorcapturingvideo'] = 'Error grabando el vídeo';
$string['mma.files.errorgettingimagealbum'] = 'Error tomando la imagen desde al álbum.';
$string['mma.files.errormustbeonlinetoupload'] = 'Debe estar conectado para subir archivos.';
$string['mma.files.errornoapp'] = 'Usted no tiene una app instalada para realizar esta acción.';
$string['mma.files.errorreadingfile'] = 'Error al leer el archivo  "{$a}"';
$string['mma.files.errorreceivefilenosites'] = 'No hay archivos almacenados. Por favor, añada un sitio antes de intentar subir un archivo.';
$string['mma.files.errorwhiledownloading'] = 'Ocurrió un error al tratar de descargar el archivo.';
$string['mma.files.errorwhilerecordingaudio'] = 'Ocurrió un error al tratar de grabar audio.';
$string['mma.files.errorwhileuploading'] = 'Ocurrió un error al subir un archivo.';
$string['mma.files.file'] = 'Archivo';
$string['mma.files.fileuploaded'] = 'Archivo subido';
$string['mma.files.myfiles'] = 'Mis archivos';
$string['mma.files.myprivatefiles'] = 'Mis archivos privados';
$string['mma.files.myprivatefilesdesc'] = 'Los archivos que están disponibles en su área privada en este sitio Moodle.';
$string['mma.files.photoalbums'] = 'Álbumes de fotos';
$string['mma.files.readingfile'] = 'Leyendo archivo';
$string['mma.files.sitefiles'] = 'Archivos del sitio';
$string['mma.files.sitefilesdesc'] = 'Los otros archivos que están disponibles  para Usted en este sitio Moodle.';
$string['mma.files.success'] = 'Éxito';
$string['mma.files.uploadafile'] = 'Subir un archivo';
$string['mma.files.uploadfiles'] = 'Puede subir ficheros';
$string['mma.files.uploading'] = 'Subiendo';
$string['mma.files.video'] = 'Vídeo';
$string['mma.frontpage.frontpage'] = 'Página Principal';
$string['mma.frontpage.sitehome'] = 'Inicio';
$string['mma.grades.average'] = 'Media';
$string['mma.grades.contributiontocoursetotal'] = 'Contribución al total del curso';
$string['mma.grades.feedback'] = 'Retroalimentación';
$string['mma.grades.grade'] = 'Calificación';
$string['mma.grades.grades'] = 'Calificaciones';
$string['mma.grades.itemname'] = 'Elemento de calificación';
$string['mma.grades.lettergrade'] = 'Calificación por letra';
$string['mma.grades.percentage'] = 'Porcentaje';
$string['mma.grades.range'] = 'Rango';
$string['mma.grades.rank'] = 'Rango';
$string['mma.grades.viewgrades'] = 'Ver calificaciones';
$string['mma.grades.weight'] = 'Peso';
$string['mma.messages.contactlistempty'] = 'Lista de contactos vacía';
$string['mma.messages.contactname'] = 'Nombre del contacto';
$string['mma.messages.errordeletemessage'] = 'Error borrando el mensaje.';
$string['mma.messages.errorwhileretrievingcontacts'] = 'Error al recuperar los contactos del servidor.';
$string['mma.messages.errorwhileretrievingdiscussions'] = 'Error al recuperar las discusiones del servidor.';
$string['mma.messages.errorwhileretrievingmessages'] = 'Error al recuperar los mensajes del servidor.';
$string['mma.messages.messagenotsent'] = 'El mensaje no fue enviado; por favor inténtelo nuevamente después.';
$string['mma.messages.mustbeonlinetosendmessages'] = 'Debe conectarse para enviar mensajes';
$string['mma.messages.newmessage'] = 'Nuevo mensaje...';
$string['mma.messages.nomessages'] = 'No hay mensajes en espera';
$string['mma.messages.nousersfound'] = 'No se encuentran usuarios';
$string['mma.messages.send'] = 'Enviar';
$string['mma.messages.type_blocked'] = 'Bloqueado';
$string['mma.messages.type_offline'] = 'Desconectado';
$string['mma.messages.type_online'] = 'En línea';
$string['mma.messages.type_search'] = 'Resultados de la búsqueda';
$string['mma.messages.type_strangers'] = 'Otros';
$string['mma.mod_assign.userwithid'] = 'Usuario con ID {{id}}';
$string['mma.mod_chat.errorwhileconnecting'] = 'Se ha producido un error conectando al chat.';
$string['mma.mod_chat.errorwhilegettingchatdata'] = 'Se ha producido un error recuperando los datos del chat.';
$string['mma.mod_chat.errorwhilegettingchatusers'] = 'Se ha producido un error recuperando los usuarios del chat.';
$string['mma.mod_chat.errorwhileretrievingmessages'] = 'Error al recuperar los mensajes del servidor.';
$string['mma.mod_chat.errorwhilesendingmessage'] = 'Se ha producido un error al enviar el mensaje.';
$string['mma.mod_chat.messagebeepsyou'] = '{$a} le acaba de enviar un beep';
$string['mma.mod_chat.messageenter'] = '{$a} entró a la sala';
$string['mma.mod_chat.messageexit'] = '{$a} salió de la sala';
$string['mma.mod_chat.mustbeonlinetosendmessages'] = 'Usted debe de estar conectado a Internet para enviar mensajes';
$string['mma.mod_chat.sessionstart'] = 'La próxima sesión de chat comenzará en  {$a}';
$string['mma.mod_choice.errorgetchoice'] = 'Se ha producido un error recuperando los datos de la consulta.';
$string['mma.mod_choice.expired'] = 'Lo sentimos, esta actividad se cerró el {$a} y ya no está disponible';
$string['mma.mod_choice.notopenyet'] = 'Lo sentimos, esta actividad no estará disponible hasta {$a}';
$string['mma.mod_choice.numberofuser'] = 'Número de participantes';
$string['mma.mod_choice.numberofuserinpercentage'] = 'Porcentaje de participantes';
$string['mma.mod_choice.previewonly'] = 'Esto es una previsualización de las opciones disponibles para esta actividad. No puedes enviar tu opción hasta {{$a}}.';
$string['mma.mod_choice.responsesresultgraphdescription'] = '{{number}}% de los usuarios han escogido la opción: {{text}}.';
$string['mma.mod_folder.emptyfilelist'] = 'No hay archivos que mostrar';
$string['mma.mod_folder.errorwhilegettingfolder'] = 'Error recuperando los datos de la carpeta.';
$string['mma.mod_forum.erroremptysubject'] = 'El asunto del mensaje no puede estar vacío.';
$string['mma.mod_forum.errorgetforum'] = 'Error al obtener datos del foro.';
$string['mma.mod_forum.errorgetgroups'] = 'Error al obtener los datos del grupo.';
$string['mma.mod_forum.forumnodiscussionsyet'] = 'No existen temas de discusión en este foro';
$string['mma.mod_forum.group'] = 'Grupo';
$string['mma.mod_forum.numdiscussions'] = '{{numdiscussions}} discusiones';
$string['mma.mod_forum.numreplies'] = '{{numreplies}} respuestas';
$string['mma.mod_glossary.browsemode'] = 'Navegar por las entradas';
$string['mma.mod_glossary.byalphabet'] = 'Alfabéticamente';
$string['mma.mod_glossary.byauthor'] = 'Agrupado por autor';
$string['mma.mod_glossary.bynewestfirst'] = 'El más reciente primero';
$string['mma.mod_glossary.byrecentlyupdated'] = 'Actualizado recientemente';
$string['mma.mod_glossary.bysearch'] = 'Busca';
$string['mma.mod_glossary.entrypendingapproval'] = 'Esta entrada está pendiente de aprobación.';
$string['mma.mod_glossary.errorloadingentries'] = 'Ha ocurrido un error cargando las entradas.';
$string['mma.mod_glossary.errorloadingentry'] = 'Ha ocurrido un error cargando la entrada.';
$string['mma.mod_glossary.errorloadingglossary'] = 'Ha ocurrido un error cargando el glosario.';
$string['mma.mod_glossary.noentriesfound'] = 'No se han encontrado entradas.';
$string['mma.mod_glossary.searchquery'] = 'Tú búsqueda';
$string['mma.mod_imscp.showmoduledescription'] = 'Mostrar descripción';
$string['mma.mod_label.label'] = 'Etiqueta';
$string['mma.mod_label.taptoview'] = 'Toca para ver la etiqueta.';
$string['mma.mod_lti.errorgetlti'] = 'Se ha producido un error recuperando los datos del módulo.';
$string['mma.mod_lti.errorinvalidlaunchurl'] = 'La dirección URL no es válida.';
$string['mma.mod_lti.launchactivity'] = 'Ejecutar la actividad';
$string['mma.mod_page.errorwhileloadingthepage'] = 'Error al cargar el contenido de la página.';
$string['mma.mod_resource.errorwhileloadingthecontent'] = 'Se ha producido un error cargando el contenido.';
$string['mma.mod_resource.openthefile'] = 'Abrir el archivo';
$string['mma.mod_scorm.cannotcalculategrade'] = 'La calificación no se puede calcular.';
$string['mma.mod_scorm.dataattemptshown'] = 'Este dato pertenece al intento número {{number}}.';
$string['mma.mod_scorm.errorcreateofflineattempt'] = 'Se ha producido un error creando un nuevo intento fuera de línea. Por favor inténtelo otra vez.';
$string['mma.mod_scorm.errordownloadscorm'] = 'Se ha producido un error descargando el paquete SCORM: "{{name}}".';
$string['mma.mod_scorm.errorgetscorm'] = 'Se ha producido un error recuperando los datos del paquete SCORM.';
$string['mma.mod_scorm.errorinvalidversion'] = 'Lo sentimos, la aplicación solo soporta SCORM 1.2.';
$string['mma.mod_scorm.errornotdownloadable'] = 'La descarga de paquetes SCORM está deshabilitada en esta instalación de Moodle. Contacte con el administrador.';
$string['mma.mod_scorm.errornovalidsco'] = 'Este paquete SCORM no tiene una SCO visible para cargar.';
$string['mma.mod_scorm.errorpackagefile'] = 'Lo sentimos, la aplicación solo soporta paquetes ZIP.';
$string['mma.mod_scorm.errorsyncscorm'] = 'Se ha producido un error durante la sincronización. Por favor inténtelo de nuevo.';
$string['mma.mod_scorm.lastsync'] = 'Última sincronización';
$string['mma.mod_scorm.offlineattemptnote'] = 'Este intento contiene datos que todavía no se han sincronizado .';
$string['mma.mod_scorm.offlineattemptovermax'] = 'Este intento no se puede enviar porque has sobrepasado el máximo número de intentos.';
$string['mma.mod_scorm.scormstatusnotdownloaded'] = 'Este SCORM no se ha descargado. Lo hará automáticamente cuando lo abras.';
$string['mma.mod_scorm.scormstatusoutdated'] = 'Este SCORM se ha modificado desde la última descarga. Se descargará automáticamente cuando lo abras.';
$string['mma.mod_scorm.warningofflinedatadeleted'] = 'Algunos datos fuera de línea del intento {{number}} se han eliminado porque no pueden crearse en el nuevo intento.';
$string['mma.mod_scorm.warningsynconlineincomplete'] = 'Algunos intentos no pueden sincronizarse con el sitio porque el último intento en línea no ha finalizado. Por favor acabe primero el intento.';
$string['mma.mod_survey.cannotsubmitsurvey'] = 'Lo sentimos, hay un problema enviando la encuesta. Por favor inténtelo otra vez.';
$string['mma.mod_survey.errorgetsurvey'] = 'Se ha producido un error recuperando los datos de la encuesta.';
$string['mma.mod_survey.results'] = 'Resultados';
$string['mma.mod_url.accessurl'] = 'Ir a la URL';
$string['mma.mod_url.pointingtourl'] = 'La URL donde apunta este recurso';
$string['mma.notes.addnewnote'] = 'Agregar una nueva nota';
$string['mma.notes.coursenotes'] = 'Notas del curso';
$string['mma.notes.eventnotecreated'] = 'Nota creada';
$string['mma.notes.nonotes'] = 'Todavía no hay notas de este tipo';
$string['mma.notes.note'] = 'Nota';
$string['mma.notes.notes'] = 'Su análisis privado y sus notas';
$string['mma.notes.personalnotes'] = 'Notas personales';
$string['mma.notes.publishstate'] = 'Contexto';
$string['mma.notes.sitenotes'] = 'Notas del sitio';
$string['mma.notes.userwithid'] = 'Usuario con id {{id}}';
$string['mma.notifications.errorgetnotifications'] = 'Error al obtener notificaciones';
$string['mma.notifications.notifications'] = 'Notificaciones';
$string['mma.notifications.therearentnotificationsyet'] = 'No hay notificaciones';
$string['mma.participants.noparticipants'] = 'No se han encontrado participantes en este curso';
$string['mma.participants.participants'] = 'Participantes';
$string['mm.contentlinks.chooseaccount'] = 'Escoger una cuenta';
$string['mm.contentlinks.chooseaccounttoopenlink'] = 'Escoger una cuenta con la que abrir el enlace.';
$string['mm.contentlinks.confirmurlothersite'] = 'Este enlace pertenece a otro sitio. ¿Quieres abrirlo?';
$string['mm.contentlinks.errornoactions'] = 'No se ha encontrado ninguna acción para realizar con este enlace.';
$string['mm.contentlinks.errornosites'] = 'No se ha encontrado ningún sitio para gestionar este enlace.';
$string['mm.core.android'] = 'Android';
$string['mm.core.cannotconnect'] = 'No se puede conectar: Verifique que la URL es correcta y que el sitio Moodle usa la versión 2.4 o posterior.';
$string['mm.core.cannotdownloadfiles'] = 'La descarga de archivos está deshabilitada en su servicio Mobile. Por favor contacte al administrador de su sitio.';
$string['mm.core.clearsearch'] = 'Limpiar búsqueda';
$string['mm.core.clicktoseefull'] = 'Clic para ver el contenido al completo';
$string['mm.core.close'] = 'Cerrar';
$string['mm.core.completion-alt-auto-fail'] = 'Finalizado {$a} (no ha alcanzado la calificación de aprobado)';
$string['mm.core.completion-alt-auto-n'] = 'Sin finalizar: {$a}';
$string['mm.core.completion-alt-auto-pass'] = 'Finalizado: {$a} (ha alcanzado la calificación de aprobado)';
$string['mm.core.completion-alt-auto-y'] = 'Finalizado: {$a}';
$string['mm.core.completion-alt-manual-n'] = 'No finalizado; {$a}. Seleccione para marcar como finalizado';
$string['mm.core.completion-alt-manual-y'] = 'Finalizado; {$a} seleccione para marcar como no finalizado';
$string['mm.core.confirmopeninbrowser'] = '¿Quiere abrirlo en el navegador?';
$string['mm.core.deleting'] = 'Borrando';
$string['mm.core.dfdayweekmonth'] = 'ddd, D MMM';
$string['mm.core.dflastweekdate'] = 'ddd';
$string['mm.core.dfmediumdate'] = 'LLL';
$string['mm.core.dftimedate'] = 'h[:]mm A';
$string['mm.core.downloading'] = 'Descargando...';
$string['mm.core.elementseparator'] = ',';
$string['mm.core.errorchangecompletion'] = 'Ha ocurrido un error cargando el grado de realización. Por favor inténtalo de nuevo.';
$string['mm.core.errordownloading'] = 'Ocurrió un error descargando el archivo';
$string['mm.core.errordownloadingsomefiles'] = 'Se ha producido un error descargando los ficheros del módulo. Algunos archivos se pueden haber perdido.';
$string['mm.core.errorinvalidresponse'] = 'Se ha recibido una respuesta no válida. Por favor contactar con el administrador de Moodle si el error persiste.';
$string['mm.core.erroropenfilenoapp'] = 'Error durante la apertura del archivo: no se encontró ninguna aplicación capaz de abrir este tipo de archivo.';
$string['mm.core.erroropenfilenoextension'] = 'Se ha producido un error abriendo el archivo: el archivo no tiene extensión.';
$string['mm.core.erroropenpopup'] = 'Esta actividad está intentando abrir una ventana emergente. Esta aplicación no lo soporta.';
$string['mm.core.humanreadablesize'] = '{{size}} {{unit}}';
$string['mm.core.image'] = 'Imagen';
$string['mm.core.imageviewer'] = 'Visor de imágenes';
$string['mm.core.info'] = 'Información';
$string['mm.core.ios'] = 'iOs';
$string['mm.core.loading'] = 'Cargando';
$string['mm.core.lostconnection'] = 'Hemos perdido la conexión, necesita reconectar. Su token ya no es válido';
$string['mm.core.mod_assign'] = 'Tarea';
$string['mm.core.mod_assignment'] = 'Tarea';
$string['mm.core.mod_book'] = 'Libro';
$string['mm.core.mod_chat'] = 'Chat';
$string['mm.core.mod_choice'] = 'Elección';
$string['mm.core.mod_data'] = 'Base de datos';
$string['mm.core.mod_database'] = 'Base de datos';
$string['mm.core.mod_external-tool'] = 'Herramienta externa';
$string['mm.core.mod_feedback'] = 'Retroalimentación';
$string['mm.core.mod_file'] = 'Recurso';
$string['mm.core.mod_folder'] = 'Directorio';
$string['mm.core.mod_forum'] = 'Foro';
$string['mm.core.mod_glossary'] = 'Glosario';
$string['mm.core.mod_ims'] = 'Paquete de contenidos IMS';
$string['mm.core.mod_imscp'] = 'Paquete de contenidos IMS';
$string['mm.core.mod_label'] = 'Etiqueta';
$string['mm.core.mod_lesson'] = 'Lección';
$string['mm.core.mod_lti'] = 'Herramienta externa';
$string['mm.core.mod_page'] = 'Página';
$string['mm.core.mod_quiz'] = 'Cuestionario';
$string['mm.core.mod_resource'] = 'Recurso';
$string['mm.core.mod_scorm'] = 'Paquete SCORM';
$string['mm.core.mod_survey'] = 'Encuesta';
$string['mm.core.mod_url'] = 'URL';
$string['mm.core.mod_wiki'] = 'Wiki';
$string['mm.core.mod_workshop'] = 'Taller';
$string['mm.core.networkerrormsg'] = 'Conexión no disponible o sin funcionar.';
$string['mm.core.notapplicable'] = 'n/a';
$string['mm.core.numdays'] = '{$a} días';
$string['mm.core.numhours'] = '{$a} horas';
$string['mm.core.numminutes'] = '{$a} minutos';
$string['mm.core.nummonths'] = '{$a} meses';
$string['mm.core.numseconds'] = '{$a} segundos';
$string['mm.core.numyears'] = '{$a} años';
$string['mm.core.offline'] = 'No se requieren entregas online';
$string['mm.core.online'] = 'Conectado';
$string['mm.core.openfullimage'] = 'Haga clic aquí para ver la imagen a tamaño completo';
$string['mm.core.openinbrowser'] = 'Abrir en el navegador';
$string['mm.core.percentagenumber'] = '{{$a}}%';
$string['mm.core.pulltorefresh'] = 'Tirar para recargar';
$string['mm.core.requireduserdatamissing'] = 'En este perfil de usuario faltan datos requeridos. Por favor, rellene estos datos e inténtelo otra vez.<br>{{$a}}';
$string['mm.core.searching'] = 'Buscando';
$string['mm.core.sending'] = 'Enviando';
$string['mm.core.serverconnection'] = 'Error conectando con el servidor';
$string['mm.core.sizetb'] = 'TB';
$string['mm.core.success'] = 'Éxito';
$string['mm.core.tablet'] = 'Tablet';
$string['mm.core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['mm.core.unexpectederror'] = 'Error inesperado. Por favor cierre y vuelva a abrir la aplicación para intentarlo de nuevo';
$string['mm.core.unknown'] = 'Desconocido';
$string['mm.core.unzipping'] = 'Descomprimiendo';
$string['mm.core.windowsphone'] = 'Windows Phone';
$string['mm.core.wsfunctionnotavailable'] = 'La función de webservice no está disponible.';
$string['mm.course.activitynotyetviewable'] = 'Este tipo de actividad o recurso todavía no esta disponible para su visualización en la app.';
$string['mm.course.activitynotyetviewablegothere'] = 'Este tipo de actividad o recurso todavía no esta disponible para su visualización en la app, haga clic en el botón de abajo para acceder desde la web.';
$string['mm.course.allsections'] = 'Todas las secciones';
$string['mm.course.confirmdownload'] = 'Está a punto de descargar {{size}}. ¿Está seguro de que desea continuar?';
$string['mm.course.confirmdownloadsection'] = 'Está a punto de descargar {{size}}. ¿Está seguro de que desea continuar?';
$string['mm.course.confirmdownloadunknownsize'] = 'No se puede calcular el tamaño de la descarga. ¿Está seguro que quiere descargarlo?';
$string['mm.course.contents'] = 'Contenidos';
$string['mm.course.couldnotloadsectioncontent'] = 'No se ha podido cargar el contenido de la sección, por favor inténtelo más tarde.';
$string['mm.course.couldnotloadsections'] = 'No se ha podido cargar las secciones, por favor inténtelo más tarde.';
$string['mm.course.errordownloadingsection'] = 'Error durante la descarga de la sección.';
$string['mm.course.errorgetmodule'] = 'Se ha producido un error recuperando los datos del módulo.';
$string['mm.course.gotothesite'] = 'Ir al sitio';
$string['mm.course.nocontentavailable'] = 'No hay contenido disponible en este momento.';
$string['mm.courses.confirmselfenrol'] = '¿Está seguro que desea auto-matricularse en este curso?';
$string['mm.courses.enrolme'] = 'Matricularme';
$string['mm.courses.errorloadcourses'] = 'Se ha producido un error cargando los cursos.';
$string['mm.courses.errorsearching'] = 'Se ha producido un error durante la búsqueda.';
$string['mm.courses.errorselfenrol'] = 'Se ha producido un error durante la auto-matriculación.';
$string['mm.courses.filter'] = 'Filtro';
$string['mm.courses.filtermycourses'] = 'Filtrar mis cursos';
$string['mm.courses.frontpage'] = 'Página Principal';
$string['mm.course.showall'] = 'Mostrar todo';
$string['mm.courses.mycourses'] = 'Mis cursos';
$string['mm.courses.nocourses'] = 'No hay información del curso para mostrar.';
$string['mm.courses.nosearchresults'] = 'No hay resultados para su búsqueda';
$string['mm.courses.notenroled'] = 'No está inscrito en este curso';
$string['mm.courses.notenrollable'] = 'No puede auto-matricularse en este curso.';
$string['mm.courses.password'] = 'Clave';
$string['mm.courses.search'] = 'Buscar';
$string['mm.courses.searchcourses'] = 'Buscar cursos';
$string['mm.courses.searchcoursesadvice'] = 'Puede utilizar el botón de buscar cursos para acceder como invitado o auto-matricularse en los cursos que lo permitan.';
$string['mm.courses.selfenrolment'] = 'Auto-matriculación';
$string['mm.courses.totalcoursesearchresults'] = 'Total de cursos: {{$a}}';
$string['mm.course.whoops'] = '¡Vaya!';
$string['mm.login.authenticating'] = 'Autenticando';
$string['mm.login.cancel'] = 'Cancelar';
$string['mm.login.cannotdownloadfiles'] = 'La descarga de archivos está desactivada en el servicio móvil de Moodle, la aplicación no puede funcionar con este parámetro desactivado. Por favor, contacte con el administrador del sitio.';
$string['mm.login.confirmdeletesite'] = '¿Está seguro de que quiere eliminar el sitio {{sitename}}?';
$string['mm.login.connect'] = 'Conectar';
$string['mm.login.connecttomoodle'] = 'Conectar a Moodle';
$string['mm.login.credentials'] = 'Credenciales';
$string['mm.login.credentialsdescription'] = 'Introduzca su nombre se usuario y contraseña para entrar';
$string['mm.login.erroraccesscontrolalloworigin'] = 'La llamada Cross-Origin que está intentando ha sido rechazada. Por favor visite https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['mm.login.errordeletesite'] = 'Ha ocurrido un error eliminando este sitio. Por favor, inténtelo de nuevo.';
$string['mm.login.errorupdatesite'] = 'Se ha producido un error actualizando el token del sitio.';
$string['mm.login.help'] = 'Ayuda';
$string['mm.login.helpmelogin'] = '<p>Hay miles de sitios que usan Moodle en el mundo. Esta aplicación sólo puede acceder a aquellos que han habilitado acceso móvil.</p><p>Si no puede conectar, contacte con su administrador de Moodle para que lea la siguiente información <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app</a></p><p>Para probar la aplicación en un sitio de demostración teclee <i>teacher</i> o <i>student</i> en el campo <i>URL del sitio</i> y haga clic en el botón <b>Añadir</b>.</p>';
$string['mm.login.invalidaccount'] = 'Por favor, verifique sus datos de acceso, o consulte con el administrador para revisar la configuración del sitio.';
$string['mm.login.invalidmoodleversion'] = 'Versión de Moodle inválida. La versión mínima requerida es:';
$string['mm.login.invalidsite'] = 'La URL del sitio es inválida.';
$string['mm.login.localmobileunexpectedresponse'] = 'Las características adicionales de Moodle Mobile han devuelto una respuesta inesperada, debe autenticarse utilizando el servicio estándar de Mobile.';
$string['mm.login.login'] = 'Entrar';
$string['mm.login.loginbutton'] = 'Entra!';
$string['mm.login.logininsiterequired'] = 'Para autentificarse en el sitio se ha de abrir una ventana de navegador.';
$string['mm.login.mobileservicesnotenabled'] = 'El acceso móvil no está habilitado para este sitio, por favor, contacte con su administrador si piensa que debería estar habilitado.';
$string['mm.login.newsitedescription'] = 'Introduzca la URL de su sitio Moodle. Tenga en cuenta que podría no estar configurado para trabajar con esta aplicación.';
$string['mm.login.notloggedin'] = 'Ha de entrar al sitio.';
$string['mm.login.password'] = 'Contraseña';
$string['mm.login.passwordrequired'] = 'Contraseña obligatoria';
$string['mm.login.reconnect'] = 'Reconectar';
$string['mm.login.reconnectdescription'] = 'El token de autenticación no es válido o ha caducado, ha de volver a conectarse al sitio.';
$string['mm.login.reconnectssodescription'] = 'El token de autenticación no es válido o ha caducado, ha de volver a conectarse al sitio. Necesita hacerlo desde un navegador web.';
$string['mm.login.siteaddress'] = 'Dirección del sitio';
$string['mm.login.siteinmaintenance'] = 'Su sitio está en modo mantenimiento';
$string['mm.login.siteurl'] = 'URL del sitio';
$string['mm.login.siteurlrequired'] = 'La URL del sitio es obligatoria, por ejemplo <i>http://www.yourmoodlesite.es o  https://www.yourmoodlesite.org</i>';
$string['mm.login.username'] = 'Nombre de usuario';
$string['mm.login.usernamerequired'] = 'Nombre de usuario obligatorio';
$string['mm.login.webservicesnotenabled'] = 'Los Servicios Web no están habilitados en su sitio, por favor, contacte con su administrador de Moodle si piensa que deberían estarlo.';
$string['mm.settings.about'] = 'Acerca de';
$string['mm.settings.appname'] = 'Moodle Mobile {{version}}';
$string['mm.settings.appready'] = 'App preparada';
$string['mm.settings.cacheexpirationtime'] = 'Tiempo de expiración de caché (mili segundos)';
$string['mm.settings.cordovadevicemodel'] = 'Modelo de dispositivo Cordova';
$string['mm.settings.cordovadeviceosversion'] = 'Versión de OS de dispositivo Cordova';
$string['mm.settings.cordovadeviceplatform'] = 'Plataforma de dispositivo Cordova';
$string['mm.settings.cordovadeviceuuid'] = 'uuid del dispositivo Cordova';
$string['mm.settings.cordovaversion'] = 'Versión Cordova';
$string['mm.settings.credits'] = 'Créditos';
$string['mm.settings.currentlanguage'] = 'Idioma actual';
$string['mm.settings.deletesitefiles'] = '¿Está seguro de que desea borrar todos los archivos descargados de este sitio?';
$string['mm.settings.deletesitefilestitle'] = 'Elimina los ficheros del sitio';
$string['mm.settings.development'] = 'Desarrollo';
$string['mm.settings.deviceinfo'] = 'Información del dispositivo';
$string['mm.settings.deviceos'] = 'OS del dispositivo';
$string['mm.settings.devicewebworkers'] = 'Soporta Device Web Workers';
$string['mm.settings.displayformat'] = 'Formato de visualización';
$string['mm.settings.enabledebugging'] = 'Activar modo debug';
$string['mm.settings.enabledownloadsection'] = 'Habilitar la descarga de secciones';
$string['mm.settings.enabledownloadsectiondescription'] = 'Deshabilitar esta opción para acelerar la carga de las secciones del curso.';
$string['mm.settings.enablesyncwifi'] = 'Permitir la sincronización solo con la WiFi activada';
$string['mm.settings.errordeletesitefiles'] = 'Se ha producido un error eliminando los ficheros del sitio.';
$string['mm.settings.errorsyncsite'] = 'Se ha producido un error sincronizando los datos del sitio, por favor compruebe su conexión a internet y pruebe de nuevo.';
$string['mm.settings.estimatedfreespace'] = 'Espacio libre (estimado)';
$string['mm.settings.general'] = 'General';
$string['mm.settings.language'] = 'Idioma';
$string['mm.settings.license'] = 'Licencia';
$string['mm.settings.localnotifavailable'] = 'Notificaciones locales disponibles';
$string['mm.settings.locationhref'] = 'Webview URL';
$string['mm.settings.navigatorlanguage'] = 'Lenguaje del navegador';
$string['mm.settings.navigatoruseragent'] = 'Agente de usuario del navegador';
$string['mm.settings.networkstatus'] = 'Estado de la conexión a internet';
$string['mm.settings.reportinbackground'] = 'Informar de los errores automáticamente';
$string['mm.settings.settings'] = 'Ajustes';
$string['mm.settings.sites'] = 'Sitios';
$string['mm.settings.spaceusage'] = 'Espacio';
$string['mm.settings.storagetype'] = 'Tipo de almacenamiento';
$string['mm.settings.success'] = 'Éxito';
$string['mm.settings.synchronization'] = 'Sincronización';
$string['mm.settings.synchronizenow'] = 'Sincronizar ahora';
$string['mm.settings.synchronizing'] = 'Sincronizando';
$string['mm.settings.syncsettings'] = 'Configuración de la sincronización';
$string['mm.settings.syncsitesuccess'] = 'Se han invalidado todos los datos sincronizados y las memorias cache.';
$string['mm.settings.total'] = 'Total';
$string['mm.settings.versioncode'] = 'Código de la versión';
$string['mm.settings.versionname'] = 'Nombre de la versión';
$string['mm.settings.wificonnection'] = 'Conexión WiFi';
$string['mm.sidemenu.appsettings'] = 'Configuración de la aplicación';
$string['mm.sidemenu.changesite'] = 'Cambiar de sitio';
$string['mm.sidemenu.help'] = 'Ayuda';
$string['mm.sidemenu.logout'] = 'Salir';
$string['mm.sidemenu.mycourses'] = 'Mis cursos';
$string['mm.sidemenu.togglemenu'] = 'Cambiar menú';
$string['mm.sidemenu.website'] = 'Página web';
$string['mm.user.address'] = 'Dirección';
$string['mm.user.city'] = 'Ciudad';
$string['mm.user.contact'] = 'Contacto';
$string['mm.user.country'] = 'País';
$string['mm.user.description'] = 'Descripción';
$string['mm.user.details'] = 'Detalles';
$string['mm.user.detailsnotavailable'] = 'No tiene acceso a los detalles de este usuario.';
$string['mm.user.editingteacher'] = 'Profesor';
$string['mm.user.email'] = 'Email';
$string['mm.user.interests'] = 'Intereses';
$string['mm.user.invaliduser'] = 'Usuario no válido';
$string['mm.user.manager'] = 'Gestor';
$string['mm.user.phone1'] = 'Teléfono';
$string['mm.user.phone2'] = 'Móvil';
$string['mm.user.roles'] = 'Roles';
$string['mm.user.student'] = 'Estudiante';
$string['mm.user.teacher'] = 'Profesor sin permiso de edición';
$string['mm.user.webpage'] = 'Página web';
$string['pluginname'] = 'Cadenas de idioma de Moodle Mobile';
