<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'es', branch 'MOODLE_28_STABLE'
 *
 * @package   bigbluebuttonbn
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bbbduetimeoverstartingtime'] = 'La hora de vencimiento para esta actividad debe ser mayor que la hora de inicio';
$string['bbbdurationwarning'] = 'La duración máxima para esta sesión es de %duration% minutos.';
$string['bbbrecordwarning'] = 'Esta sesión está siendo grabada.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Añadir una nueva sesión';
$string['bigbluebuttonbn:join'] = 'Unirse a una sesión';
$string['bigbluebuttonbn:managerecordings'] = 'Administrar grabaciones';
$string['bigbluebuttonbn:moderate'] = 'Moderar una sesión';
$string['config_extended_capabilities'] = 'Configuración para compatibilidad extendida';
$string['config_extended_capabilities_description'] = 'Configuración para compatibilidad extendida cuando el servidor BigBlueButton lo ofrezca';
$string['config_extended_feature_recordingready_enabled'] = 'Notificaciones cuando la grabación disponible esté habilitada';
$string['config_extended_feature_recordingready_enabled_description'] = 'Notificaciones cuando la grabación disponible esté habilitada.';
$string['config_extended_feature_uidelegation_enabled'] = 'Delegación de Interfaz del usuario está habilitada';
$string['config_extended_feature_uidelegation_enabled_description'] = 'Estas configuraciones habilitan o deshabilitan la delegación de Interfaz del Usuario al servidor BigBlueButton.';
$string['config_feature_preuploadpresentation'] = 'Configuración para la función de "Pre-cargar presentación"';
$string['config_feature_preuploadpresentation_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario y también definen valores por defecto para estas opciones. La función es valida solamente si el servidor Moodle es accesibe para BigBlueButton.';
$string['config_feature_preuploadpresentation_enabled'] = 'Función de Pre-cargar presentación habilitada';
$string['config_feature_preuploadpresentation_enabled_description'] = 'La función de pre-cargar presentación está habilitada en la Interfaz del Usuario cuando se añade o actualiza una sala o conferencia.';
$string['config_feature_recording'] = 'Configuración para función de "Grabando"';
$string['config_feature_recording_default'] = 'Función de Grabando habilitada por defecto';
$string['config_feature_recording_default_description'] = 'Si se habilita, las sesiones creadas en BigBlueButton tendrán capacidades para grabar.';
$string['config_feature_recording_description'] = 'Estas configuraciones son específicas para cada función';
$string['config_feature_recording_editable'] = 'La función de Grabando puede ser editada';
$string['config_feature_recording_editable_description'] = 'Si se activa, la interfaz incluye una opción para habilitar y deshabilitar la función de grabación.';
$string['config_feature_recording_icons_enabled'] = 'Iconos para gestión de grabaciones';
$string['config_feature_recording_icons_enabled_description'] = 'Cuando se habilita, el panel de gestión de grabación muestra iconos para las acciones de publicar/ocultar y eliminar.';
$string['config_feature_recordingtagging'] = 'Configuración para función de "Marcar (tag) Grabación"';
$string['config_feature_recordingtagging_default'] = 'Marcado (tagging) de grabación habilitado por defecto';
$string['config_feature_recordingtagging_default_description'] = 'La función de marcar (tag) grabación está habilitada por defecto cuando se añade una nueva sala o conferencia<br>Cuando se habilita esta función, una página intermedia que permite introducir una descripción y etiquetas (tags) para la sesión BigBlueButton se le muestra al primer moderador que se une. La descripción y las marcas (tags) después son usadas para identificar la grabación en la lista.';
$string['config_feature_recordingtagging_description'] = 'Estas configuraciones son específicas de la función';
$string['config_feature_recordingtagging_editable'] = 'La función de Marcar (tag) Grabación puede ser editada';
$string['config_feature_recordingtagging_editable_description'] = 'El valor de marca (tagging) de la grabación puede editarse cuando se añade o actualiza la sala o conferencia.';
$string['config_feature_sendnotifications'] = 'Configuración para la función de "Enviar notificaciones"';
$string['config_feature_sendnotifications_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario y también definen valores para estas opciones.';
$string['config_feature_sendnotifications_enabled'] = 'Función para enviar notificaciones habilitada';
$string['config_feature_sendnotifications_enabled_description'] = 'La función de enviar notificaciones está habilitada en la Interfaz del Usuario cuando se añade o actualiza la sala o conferencia.';
$string['config_feature_userlimit'] = 'Configuración para función de "Límite de usuario"';
$string['config_feature_userlimit_default'] = 'Límite de usuario habilitado por defecto';
$string['config_feature_userlimit_default_description'] = 'El número de usuarios permitidos por sesión por defecto cuando se añade una nueva sala o conferencia. Si el número se configura a 0, no se establece límite alguno.';
$string['config_feature_userlimit_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario y también definen valores por defecto para estas opciones.';
$string['config_feature_userlimit_editable'] = 'La función de límite de usuario puede ser editada';
$string['config_feature_userlimit_editable_description'] = 'El valor límite del usuario por defecto puede editarse cuando se añade o actualiza una sala o conferencia.';
$string['config_feature_voicebridge'] = 'Configuración para función de "Puente de voz"';
$string['config_feature_voicebridge_description'] = 'Estas configuraciones habilitan o deshabilitan opciones en la Interfaz del Usuario y también definen valores por defecto para estas opciones.';
$string['config_feature_voicebridge_editable'] = 'El puente de voz de la conferencia puede ser editado';
$string['config_feature_voicebridge_editable_description'] = 'El número del puente de conferencia de voz puede asignarse permanentemente a una conferencia en sala. Cuando se asigna, el número no puede usarse por ninguna otra sala o conferencia.';
$string['config_feature_waitformoderator'] = 'Configuración para la función de "Esperar al moderador"';
$string['config_feature_waitformoderator_cache_ttl'] = 'TTL (time to live) de caché para esperar al moderador (segundos)';
$string['config_feature_waitformoderator_cache_ttl_description'] = 'Para soportar una carga fuerte de clientes, este plugin hace uso de un caché. Este parámetro define el tiempo que se conservará el caché antes de que la siguiente solicitud sea enviada al servidor BigBlueButton.';
$string['config_feature_waitformoderator_default'] = 'Esperar al moderador activado por defecto';
$string['config_feature_waitformoderator_default_description'] = 'La función de esperar al moderador está habilitada por defecto cuando se añade una sala o conferencia nueva.';
$string['config_feature_waitformoderator_description'] = 'Estas configuraciones son específicas de la función';
$string['config_feature_waitformoderator_editable'] = 'La función de esperar al moderador puede ser editada';
$string['config_feature_waitformoderator_editable_description'] = 'El esperar por defecto al moderador puede editarse cuando se añade o actualiza una sala o conferencia.';
$string['config_feature_waitformoderator_ping_interval'] = 'Esperar el \'ping\' del moderador (segundos)';
$string['config_feature_waitformoderator_ping_interval_description'] = 'Cuando se habilita la función de esperar al moderador, el cliente hace \'ping\' para conocer el estatus de la sesión cada [número de] segundos. Este parámetro define el intervalo para solicitudes hechas al servidor Moodle.';
$string['config_general'] = 'Configuración general';
$string['config_general_description'] = 'Estas configuraciones son usadas <b>siempre</b>';
$string['config_permission'] = 'Configuración de permiso';
$string['config_permission_description'] = 'Estas configuraciones definen los permisos por defecto para las salas o conferencias creadas.';
$string['config_permission_moderator_default'] = 'Moderador por defecto';
$string['config_permission_moderator_default_description'] = 'Esta regla es usada por defecto cuando se añade una sala o conferencia nueva.';
$string['config_scheduled'] = 'Configuración para "Sesiones programadas"';
$string['config_scheduled_description'] = 'Estas configuraciones definen algunos de los comportamientos por defecto para las sesiones programadas.';
$string['config_scheduled_duration_compensation'] = 'Tiempo compensatorio (minutos)';
$string['config_scheduled_duration_compensation_description'] = 'Minutos añadidos al cierre agendado al calcular la duración.';
$string['config_scheduled_duration_enabled'] = 'Calcular duración habilitada';
$string['config_scheduled_duration_enabled_description'] = 'La duración de una sesión programada es calculada basándose en las horas de apertura y cierre.';
$string['config_scheduled_pre_opening'] = 'Accesible antes de la hora de apertura (minutos)';
$string['config_scheduled_pre_opening_description'] = 'El tiempo en minutos para que la sesión sea accesible antes de que sea la hora de apertura programada.';
$string['config_server_url'] = 'URL del servidor BigBlueButton';
$string['config_server_url_description'] = 'La URL de su servidor BigBlueButton debe terminar en  /bigbluebutton/. (Esta URL por defecto es para un servidor BigBlueButton proporcionado por Blindside Networks que Usted puede usar para pruebas.)';
$string['config_shared_secret'] = 'Clave secreta de BigBlueButton';
$string['config_shared_secret_description'] = 'La sal de seguridad de su servidor BigBlueButton. (esta sal por defecto es para un servidor BigBlueButton proporcionado por Blindside Networks que Usted puede usar para pruebas.)';
$string['config_warning_curl_not_installed'] = 'Esta función requiere que la extensión CURL para php  se encuentre instalada y habilitada. La configuración de estos parameteros será posible solo si esta condición se cumple.';
$string['email_body_notification_meeting_by'] = 'por';
$string['email_body_notification_meeting_description'] = 'Descripción';
$string['email_body_notification_meeting_details'] = 'Detalles';
$string['email_body_notification_meeting_end_date'] = 'Fecha de finalización';
$string['email_body_notification_meeting_has_been'] = 'ha sido';
$string['email_body_notification_meeting_start_date'] = 'Fecha de inicio';
$string['email_body_notification_meeting_title'] = 'Título';
$string['email_body_recording_ready_for'] = 'Grabado por';
$string['email_body_recording_ready_is_ready'] = 'está listo';
$string['email_footer_sent_by'] = 'Esta notificación automática fue enviada por';
$string['email_footer_sent_from'] = 'del curso';
$string['email_title_notification_has_been'] = 'ha sido';
$string['event_activity_created'] = 'Actividad BigBlueButtonBN creada';
$string['event_activity_deleted'] = 'Actividad BigBlueButtonBN borrada';
$string['event_activity_modified'] = 'Actividad BigBlueButtonBN actualizada';
$string['event_activity_viewed'] = 'Actividad BigBlueButtonBN visualizada';
$string['event_activity_viewed_all'] = 'Configuración de la actividad BigBlueButtonBN visualizada';
$string['event_meeting_created'] = 'Reunión BigBlueButtonBN creada';
$string['event_meeting_ended'] = 'Se ha finalizado una reunión BigBlueButtonBN de forma inesperada';
$string['event_meeting_joined'] = 'Se ha unido a una reunión BigBlueButtonBN';
$string['event_meeting_left'] = 'Se ha abandonado una reunión BigBlueButtonBN';
$string['event_recording_deleted'] = 'Grabación borrada';
$string['event_recording_published'] = 'Grabación publicada';
$string['event_recording_unpublished'] = 'Grabación no publicada';
$string['general_error_unable_connect'] = 'Incapaz de conectar. Por favor, compruebe la URL del servidor de BigBlueButton y compruebe si el servidor de BigBlueButton está funcionando.';
$string['index_confirm_end'] = '¿Desea terminar la clase virtual?';
$string['index_disabled'] = 'deshabilitada';
$string['index_enabled'] = 'habilitada';
$string['index_ending'] = 'Finalizando la sala virtual....por favor espere';
$string['index_error_checksum'] = 'Ha ocurrido en error en la suma de comprobación. Asegúrese de que ha introducido la sal correcta.';
$string['index_error_forciblyended'] = 'Incapaz de unirse a esta sesión porque ha sido terminada manualmente.';
$string['index_error_unable_display'] = 'Incapaz de mostrar las sesiones. Por favor, compruebe la URL del servidor de BigBlueButton y compruebe si el servidor de BigBlueButton está funcionando.';
$string['index_heading'] = 'Salas BigBlueButton';
$string['index_heading_actions'] = 'Acciones';
$string['index_heading_group'] = 'Grupo';
$string['index_heading_moderator'] = 'Moderadores';
$string['index_heading_name'] = 'Sala';
$string['index_heading_recording'] = 'Grabación';
$string['index_heading_users'] = 'Usuarios';
$string['index_heading_viewer'] = 'Asistentes';
$string['mod_form_block_general'] = 'Ajustes generales';
$string['mod_form_block_participants'] = 'Participantes';
$string['mod_form_block_presentation'] = 'Presentación de contenido';
$string['mod_form_block_record'] = 'Ajustes de grabación.';
$string['mod_form_block_schedule'] = 'Programación de sesiones';
$string['mod_form_field_closingtime'] = 'Accesso cerrado';
$string['mod_form_field_conference_name'] = 'Nombre de conferencia';
$string['mod_form_field_duration'] = 'Duración';
$string['mod_form_field_duration_help'] = 'Fijar la duración para una sesión establecerá el tiempo máximo para mantener activa una sesión antes de que termine la grabación';
$string['mod_form_field_intro'] = 'Descripción';
$string['mod_form_field_intro_help'] = 'Descripción corta para la sala o conferencia.';
$string['mod_form_field_name'] = 'Nombre de la sala virtual';
$string['mod_form_field_newwindow'] = 'Abrir BigBlueButton en una nueva ventana';
$string['mod_form_field_notification'] = 'Enviar notificación';
$string['mod_form_field_notification_created_help'] = 'Enviarles una notificación a los usuarios inscritos para hacerles saber que esta actividad ha sido creada';
$string['mod_form_field_notification_help'] = 'Enviarles una notificación a los usuarios inscritos para hacerles saber que esta actividad ha sido creada o modificada';
$string['mod_form_field_notification_modified_help'] = 'Enviarles una notificación a los usuarios inscritos para hacerles saber que esta actividad ha sido modificada';
$string['mod_form_field_notification_msg_at'] = 'en';
$string['mod_form_field_notification_msg_created'] = 'Creada';
$string['mod_form_field_notification_msg_modified'] = 'Modificada';
$string['mod_form_field_openingtime'] = 'Acceso abierto';
$string['mod_form_field_participant_add'] = 'Agregar participante';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderador';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Observador';
$string['mod_form_field_participant_list'] = 'Lista de participantes';
$string['mod_form_field_participant_list_action_add'] = 'Agregar';
$string['mod_form_field_participant_list_action_remove'] = 'Eliminar';
$string['mod_form_field_participant_list_text_as'] = 'como';
$string['mod_form_field_participant_list_type_all'] = 'Todos los usuarios inscritos';
$string['mod_form_field_participant_list_type_owner'] = 'Responsable';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Usuario';
$string['mod_form_field_predefinedprofile'] = 'Perfil predefinido';
$string['mod_form_field_predefinedprofile_help'] = 'Perfil por defecto';
$string['mod_form_field_record'] = 'La sesión puede ser grabada';
$string['mod_form_field_recordingtagging'] = 'Activar interfaz para marcar (tag)';
$string['mod_form_field_room_name'] = 'Nombre de la sala';
$string['mod_form_field_userlimit'] = 'Límite de usuarios';
$string['mod_form_field_userlimit_help'] = 'Límite máximo de usuarios permitidos en una reunión. Si el límite está a 0 el número de usuarios será ilimitado.';
$string['mod_form_field_voicebridge'] = 'Puente de voz';
$string['mod_form_field_voicebridge_format_error'] = 'Error de formato. Debe introducir un número entre 1 y 9999.';
$string['mod_form_field_voicebridge_help'] = 'Número de la conferencia de voz a la que los participantes pueden entrar para unirse a la conferencia de voz.';
$string['mod_form_field_voicebridge_notunique_error'] = 'No es un valor único. Este numero ha sido usado por otra sala o conferencia.';
$string['mod_form_field_wait'] = 'Los estudiantes deben esperar hasta que se una un moderador';
$string['mod_form_field_wait_help'] = 'Los observadores deben esperar hasta que un moderador entre a la sesión para poder acceder';
$string['mod_form_field_welcome'] = 'Mensaje de bienvenida';
$string['mod_form_field_welcome_default'] = '¡<br>Bienvenido a <b>%%CONFNAME%%</b>!<br><br>Para entender cómo funciona BigBlueButton vea nuestros <a href="event:http://www.bigbluebutton.org/content/videos"><u>vídeotutoriales</u></a>.<br><br>Para unirse al puente de audio pulse en el icono de los auriculares (en la esquina superior izquierda). <b>Por favor, use auriculares para evitar causarle ruido a los demás.</b>';
$string['mod_form_field_welcome_help'] = 'Reemplaza el mensaje por defecto fijado por el servidor de BigBlueButton. El mensaje puede incluir las palabras clave (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) las cuales serán sutituidas automáticamente, y también etiquetas html como &lt;b&gt;...&lt;/b&gt; or &lt;i&gt;&lt;/i&gt;';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = 'BigBlueButtonBN le permite crear dentro de Moodle enlaces hacia aulas en línea en tiempo real con salas que emplean BigBlueButton, un sistema de código abierto para conferencias web para la educación a distancia.

Usando BigBlueButtonBN puede especificar el título, descripción, fecha del calendario (que le proporciona un rango de fechas para unirse a la sesión), grupos, y detalles acerca de la grabación de la sesión en línea.

Para ver grabaciones posteriormente, añada un recurso RecordingsBN a este curso.';
$string['modulenameplural'] = 'BigBlueButtonBN';
$string['pluginadministration'] = 'Administración de BigBlueButton';
$string['pluginname'] = 'BigBlueButtonBN';
$string['predefined_profile_classroom'] = 'Sala de clases';
$string['predefined_profile_collaborationroom'] = 'Sala de colaboración';
$string['predefined_profile_conferenceroom'] = 'Sala de conferencia';
$string['predefined_profile_default'] = 'Por defecto';
$string['predefined_profile_scheduledsession'] = 'Sesión programada';
$string['serverhost'] = 'Nombre del servidor';
$string['view_conference_action_end'] = 'Fin de sesión';
$string['view_conference_action_join'] = 'Unirse a la sesión';
$string['view_conference_action_lineup'] = 'Cola de espera para unirse a la sesión';
$string['view_error_create'] = 'El servidor BigBlueButton ha respondido con un mensaje de error, la sesión no pudo ser creada.';
$string['view_error_max_concurrent'] = 'El máximo número de sesiones concurrentes permitido ha sido alcanzado.';
$string['view_error_no_group'] = 'Aún no hay grupos configurados. Por favor, establezca los grupos antes de intentar unirse a una sesión.';
$string['view_error_no_group_student'] = 'No has sido enrolado a ningún grupo. Por favor, contacte con su profesor con el administrador.';
$string['view_error_no_group_teacher'] = 'Aún no hay grupos configurados. Por favor, establezca los grupos o contacte con el administrador.';
$string['view_error_unable_join'] = 'Incapaz de unirse a la sesión. Por favor compruebe la URL del servidor de BigBlueButton y compruebe que el servidor de BigBlueButton está en funcionamiento.';
$string['view_error_unable_join_student'] = 'Incapáz de conectarse al servidor de BigBlueButton. Por favor, póngase en contacto con su profesor o con el administrador.';
$string['view_error_unable_join_teacher'] = 'Incapáz de conectarse al servidor de BigBlueButton. Por favor, póngase en contacto con el administrador.';
$string['view_error_userlimit_reached'] = 'El número de usuarios permitido en una reunión ha sido alcanzado.';
$string['view_groups_selection'] = 'Seleccione el grupo al que desea unirse y confirme la acción';
$string['view_groups_selection_join'] = 'Unirse';
$string['view_groups_selection_warning'] = 'Hay una sala de conferencia para cada grupo, Si Usted tiene acceso a más de una, asegúrese de seleccionar la sala correcta.';
$string['view_login_moderator'] = 'Accediendo como moderador...';
$string['view_login_viewer'] = 'Accediendo como asistente...';
$string['view_message_conference_has_ended'] = 'Esta conferencia ha terminado';
$string['view_message_conference_in_progress'] = 'Esta conferencia está en proceso.';
$string['view_message_conference_not_started'] = 'Esta conferencia no ha comenzado todavía.';
$string['view_message_conference_room_ready'] = 'Esta sala de conferencia está lista. Puede unirse a la sesión ahora.';
$string['view_message_conference_wait_for_moderator'] = 'Esperando por un moderador para unirse.';
$string['view_message_finished'] = 'Esta actividad finalizó.';
$string['view_message_has_joined'] = 'se ha unido';
$string['view_message_have_joined'] = 'se han unido';
$string['view_message_hour'] = 'hora';
$string['view_message_hours'] = 'horas';
$string['view_message_minute'] = 'minuto';
$string['view_message_minutes'] = 'minutos';
$string['view_message_moderator'] = 'moderador';
$string['view_message_moderators'] = 'moderadores';
$string['view_message_norecordings'] = 'No hay grabación para esta reunión.';
$string['view_message_notavailableyet'] = 'Esta sesión aun no está disponible.';
$string['view_message_room_closed'] = 'Esta sala está cerrada.';
$string['view_message_room_open'] = 'Esta sala está abierta.';
$string['view_message_room_ready'] = 'Esta sala está lista.';
$string['view_message_session_has_user'] = 'Hay';
$string['view_message_session_has_users'] = 'Hay';
$string['view_message_session_no_users'] = 'No hay usuarios en esta sesión';
$string['view_message_session_running_for'] = 'Esta sesión ha estado activa por';
$string['view_message_session_started_at'] = 'Esta sesión inició a las';
$string['view_message_tab_close'] = 'Esta pestaña/ventana debe ser cerrada manualmente';
$string['view_message_user'] = 'usuario';
$string['view_message_users'] = 'usuarios';
$string['view_message_viewer'] = 'observador';
$string['view_message_viewers'] = 'observadores';
$string['view_noguests'] = 'El módulo BigBlueButtonBN no está abierto para invitados';
$string['view_nojoin'] = 'No estás en un rol con permiso para unirse a esta sesión.';
$string['view_recording_actionbar'] = 'Barra de herramienta';
$string['view_recording_activity'] = 'Actividad';
$string['view_recording_course'] = 'Curso';
$string['view_recording_date'] = 'Fecha';
$string['view_recording_delete_confirmation'] = '¿Está usted seguro de eliminar esta grabación?';
$string['view_recording_description'] = 'Descripción';
$string['view_recording_duration'] = 'Duración';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_presentation'] = 'presentación';
$string['view_recording_format_video'] = 'video';
$string['view_recording_length'] = 'Duración';
$string['view_recording_list_actionbar'] = 'Barra de herramientas';
$string['view_recording_list_actionbar_delete'] = 'Borrar';
$string['view_recording_list_actionbar_deleting'] = 'Borrado';
$string['view_recording_list_actionbar_hide'] = 'Ocultar';
$string['view_recording_list_actionbar_processing'] = 'Procesando';
$string['view_recording_list_actionbar_publish'] = 'Publicar';
$string['view_recording_list_actionbar_publishing'] = 'Publicando';
$string['view_recording_list_actionbar_show'] = 'Mostrar';
$string['view_recording_list_actionbar_unpublish'] = 'Despublicar';
$string['view_recording_list_actionbar_unpublishing'] = 'Despublicando';
$string['view_recording_list_activity'] = 'Actividad';
$string['view_recording_list_course'] = 'Curso';
$string['view_recording_list_date'] = 'Fecha';
$string['view_recording_list_description'] = 'Descripción';
$string['view_recording_list_duration'] = 'Duración';
$string['view_recording_list_recording'] = 'Grabación';
$string['view_recording_modal_button'] = 'Aplicar';
$string['view_recording_modal_title'] = 'Coloque valores para grabación';
$string['view_recording_name'] = 'Nombre';
$string['view_recording_recording'] = 'Grabando';
$string['view_recording_tags'] = 'Etiquetas';
$string['view_section_title_presentation'] = 'Archivo de presentación';
$string['view_section_title_recordings'] = 'Grabaciones';
